from django import template
from django.contrib.staticfiles.storage import staticfiles_storage
from django.contrib.sites.models import Site
from django.template import Library
import logging
import urlparse

register = template.Library()

@register.simple_tag
def absstatic(context, path):
    try:
        request=context['request']
        if request.is_secure():
            domain = "https://%s" % Site.objects.get_current().domain
        else:
            domain = "http://%s" % Site.objects.get_current().domain
    except:
        domain = "http://%s" % Site.objects.get_current().domain

    new_path = staticfiles_storage.url(path)
    return urlparse.urljoin(domain, new_path)

absstatic=register.simple_tag(takes_context=True)(absstatic)