function IncResize()
{
	this.content;
	this.top;
	this.middle;
	this.middleContainer;
	this.bottom;
	this.footer;
	this.minTopBottomHeight;
	this.ratio;
	this.preMiddleSizeFunc;
	this.postMiddleSizeFunc;

	this.init = function(contantId, topId, middleId, bottomId, footerId, minTopBottomHeight, ratio, preMiddleSizeFunc, postMiddleSizeFunc)
	{
		this.content = $('#' + contantId);
		if (topId != null) {
			this.top = $('#' + topId); 			
		}
		this.middle = $('#' + middleId); 
		this.middleContainer = $(this.middle).parent();
		if (bottomId != null) {
			this.bottom = $('#' + bottomId);
		}
		this.footer =  $('#' + footerId);
		this.minTopBottomHeight = minTopBottomHeight;
		this.ratio = ratio;
		this.preMiddleSizeFunc = preMiddleSizeFunc;
		this.postMiddleSizeFunc = postMiddleSizeFunc;

		$(window).resize(this.resizeElements);
		window.onorientationchange = function() {
			incResize.resizeElements();
		}
	};

	this.resizeElements = function()
	{
		var self = incResize;

		// Compute maximun middle element height
		var heightForTopMiddleBotom = $(self.content).height() - $(self.footer).height() - 70;
		var maxMiddleHeight = heightForTopMiddleBotom - self.minTopBottomHeight * 2;

		// Get the middle element parent width nad test if it is not to big (to let place for top and bottom without adding scroll bars)
		var middleRatio = 1 / self.ratio;
		var newMiddleWidth = $(self.middleContainer).width();
		var newMiddleHeight = newMiddleWidth * middleRatio;

		/*
		if (newMiddleHeight > maxMiddleHeight) {
			newMiddleHeight = maxMiddleHeight;
			newMiddleWidth = newMiddleHeight * 1 / middleRatio;
		}
		*/

		// Pre register the middle element size change
		if (self.preMiddleSizeFunc !== undefined && self.preMiddleSizeFunc !== null) {
			self.preMiddleSizeFunc(newMiddleWidth, newMiddleHeight);
		}

		// Change middle element size and the height of its parent
		$(self.middle).attr('width', newMiddleWidth);
		$(self.middle).attr('height', newMiddleHeight);
		$(self.middleContainer).attr('width', newMiddleWidth);
		$(self.middleContainer).attr('height', newMiddleHeight);

		// Change children size of the middle element
		var children = $(self.middle).children();
		if (children.length > 0) {
			children.attr('width', newMiddleWidth);
			children.attr('height', newMiddleHeight);
		}

		// Post register the middle element size change
		if (self.postMiddleSizeFunc !== undefined && self.postMiddleSizeFunc !== null) {
			self.postMiddleSizeFunc(newMiddleWidth, newMiddleHeight);
		}

		// Change top and bottom heights
		if (this.top != undefined && this.bottom != undefined) {
			// Get the full height and compute heigth for top and bottom
			var remainingHeight = $(self.content).height() - $(self.footer).height() - newMiddleHeight - 70;
			var newOtherHeight = remainingHeight / 2.0;
			if (newOtherHeight < self.minTopBottomHeight) {
				newOtherHeight = self.minTopBottomHeight;
			}
			$(self.top).css({"height" : +newOtherHeight+'px', "lineHeight" : +newOtherHeight+'px'});
			$(self.bottom).css({"height" : +newOtherHeight+'px', "lineHeight" : +newOtherHeight+'px'});					
		}
	}
}

var incResize = new IncResize();


