function IncResize()
{
	this.content;
	this.top;
	this.middle;
	this.middleContainer;
	this.bottom;
	this.footer;
	this.minTopBottomHeight;
	this.ratio;
	this.considerFooterToCenter;
	this.callbacks;

	this.init = function(contentId, topId, middleId, bottomId, footerId, minTopBottomHeight, ratio, considerFooterToCenter, callbacks)
	{
		// Content
		this.content = $('#' + contentId);

		// Top
		if (topId != null) {
			this.top = $('#' + topId); 			
		}

		// Middle
		this.middle = $('#' + middleId); 
		this.middleContainer = $(this.middle).parent();

		// Bottom
		if (bottomId !== null) {
			this.bottom = $('#' + bottomId);
		}

		// Footer
		if (footerId !== null) {
			this.footer =  $('#' + footerId);
		}

		this.minTopBottomHeight = minTopBottomHeight;
		this.ratio = ratio;
		this.considerFooterToCenter = (considerFooterToCenter === undefined || footerId === null) ? false : considerFooterToCenter;
		this.callbacks = callbacks;

		$(window).resize(this.resizeElements);
		window.onorientationchange = function() {
			incResize.resizeElements();
		}
	};

	this.resizeElements = function()
	{
		var self = incResize;

		// Compute maximun middle element height
		var heightForTopMiddleBottom = $(self.content).height();
		if (self.footer !== undefined) {
			heightForTopMiddleBottom -= $(self.footer).height()			
		}
		var maxMiddleHeight = heightForTopMiddleBottom - self.minTopBottomHeight * 2;

		// Get the middle element parent width and test if it is not to big (to let place for top and bottom without adding scroll bars)
		var middleRatio = 1 / self.ratio;
		var newMiddleWidth = $(self.middleContainer).width();
		var newMiddleHeight = newMiddleWidth * middleRatio;

		if (self.top !== undefined && self.bottom !== undefined && newMiddleHeight > maxMiddleHeight) {
			newMiddleHeight = maxMiddleHeight;
			newMiddleWidth = newMiddleHeight * 1 / middleRatio;
		}

		newMiddleWidth = Math.max(newMiddleWidth, 1);
		newMiddleHeight = Math.max(newMiddleHeight, 1);

		// Change middle element size and the height of its parent
		$(self.middle).attr('width', newMiddleWidth);
		$(self.middle).attr('height', newMiddleHeight);
		$(self.middleContainer).attr('width', newMiddleWidth);
		$(self.middleContainer).attr('height', newMiddleHeight);

		// Change children size of the middle element
		var children = $(self.middle).children();
		if (children.length > 0) {
			children.attr('width', newMiddleWidth);
			children.attr('height', newMiddleHeight);
		}

		// Post register the middle element size change
		if (self.callbacks !== undefined) {
			for (var i = 0; i < self.callbacks.length; ++i) {
				self.callbacks[i](newMiddleWidth, newMiddleHeight);				
			}
		}

		// Change top and bottom heights
		if (self.top !== undefined && self.bottom !== undefined) {

			// Get the full height and compute heigth for top and bottom
			var remainingHeight = heightForTopMiddleBottom - newMiddleHeight;
			var newTopHeight = remainingHeight / 2.0;
			if (newTopHeight < self.minTopBottomHeight) {
				newTopHeight = self.minTopBottomHeight;
			}

			var newBottomHeight = newTopHeight;
			
			if (self.considerFooterToCenter) {
				var halfFooterHeight = $(self.footer).height() / 2;
				newTopHeight += halfFooterHeight;
				newBottomHeight -= halfFooterHeight;
			}

			$(self.top).css({"height" : + newTopHeight +'px', "lineHeight" : + newTopHeight + 'px'});
			$(self.bottom).css({"height" : + newBottomHeight + 'px', "lineHeight" : + newBottomHeight + 'px'});					
		}
	};
}

var incResize = new IncResize();


