from django.shortcuts import render_to_response
from django.template import RequestContext
from ldt.ldt_utils.models import Content

def level2_tag(request, tag):
    return render_to_response("theend/tag.html",
                              {'tag': tag },
                              context_instance=RequestContext(request))

def level2_content(request, content_id):
    content = Content.objects.get(iri_id=content_id)
    proj = content.get_or_create_front_project()
    return render_to_response("theend/content.html",
                              {'content': content, 'front_project': proj },
                              context_instance=RequestContext(request))