var effectSpeed = 8;

function IncChoice()
{
	this.currentWorldIndex = 0;
	this.canSelectWord = true;
	this.image1;
	this.image2;
	this.image3;
	this.prefixCookieChosenWords = "niv1_ChosenWords";
	this.prefixCookieChosenVideos = "niv1_ChosenVideos";
	this.prefixCookiePlayedVideos = "niv1_PlayedVideos";
	this.prefixCookieSingleVideo = "niv1_SingleVideo";
	this.prefixCookieHD = "niv1_HD";
	this.prefixCookieSeekTime = "niv1_SeekTime";

	//----------------------------------------------------------------------------------------------------------------------------
	// Words display
	//----------------------------------------------------------------------------------------------------------------------------	

	this.setMosaicImages = function(images1, images2, images3, postFirstImageCallback)
	{
		// Choose 2 image for the effect
		this.image1 = images1[incMosaic.randomInt(0, images1.length)];
		this.image2 = images2[incMosaic.randomInt(0, images2.length)];
		this.image3 = images3[incMosaic.randomInt(0, images3.length)];

	    incMosaic.addImageUrl("static/res/img/" + this.image1);
	    incMosaic.addImageUrl("static/res/img/" + this.image2);
	    incMosaic.addImageUrl("static/res/img/" + this.image3);

	    incMosaic.start("mosaic", effectSpeed, 9, 5, true, true, function() {incChoice.effectIsDone();}, postFirstImageCallback);		
	};

	this.setWordsAndEffect = function(choiceIndex)
	{
		if (choiceIndex === 0) {
			$("#mot1").html("famille");
			$("#mot2").html("amour");
			$("#mot3").html("travail");
			$("#mot4").html("international");
			$("#mot5").html("dieu");
			$("#mot6").html("président");

			// class
			// by default there is the class blue

		} else if (choiceIndex === 1) {
			$("#mot1").html("actif");
			$("#mot2").html("passif");
			$("#mot3").html("corps");
			$("#mot4").html("charité");
			$("#mot5").html("patrie");
			$("#mot6").html("politique");

			// class
			$("#choice").removeClass("blue").addClass("whiteN");

		} else {
			$("#mot1").html("spleen");
			$("#mot2").html("idéal");
			$("#mot3").html("origines");
			$("#mot4").html("peur");
			$("#mot5").html("désir");
			$("#mot6").html("bonheur");

			// class
			$("#choice").removeClass("whiteN").addClass("red");
		}
	};

	this.effectIsDone = function()
	{
		this.canSelectWord = true;

        // Set the list of words and the mosaic effect
		this.setWordsAndEffect(this.currentWorldIndex);

		// Stop the mosaic effect
		incMosaic.UnpauseEffect(false);

		// Fade the text
		$('.big_txt').animate({opacity: 1}, 10000 * 1 / effectSpeed);
	};

	//----------------------------------------------------------------------------------------------------------------------------
	// Selected Words
	//----------------------------------------------------------------------------------------------------------------------------	

	this.selectWord = function(wordIndex)
	{
		if (!this.canSelectWord) {
			// Don't set the word 2 times
			return;
		}

		this.canSelectWord = false;

		// Save the word
		var allWorldIndex = this.currentWorldIndex * 6 + wordIndex;
		this.setCookie(this.prefixCookieChosenWords + this.currentWorldIndex, allWorldIndex);

		++this.currentWorldIndex;

		// FTV Tag
		xt_click(this,"F" ,"5", "Creation_Film::Choix_mot_" + this.currentWorldIndex);

		if (this.currentWorldIndex == 3) {
			// The 3 words get choosen
			location.href = "film-aleatoire-the-end-etc.html";
		} else {
			
			// Start the mosaic effect
			incMosaic.UnpauseEffect(true);

			// Fade the text
			$('.big_txt').animate({opacity: 0}, 20000 * 1 / effectSpeed);
		}
	};

	this.getChoosenWords = function()
	{
		var words = [];
		for (var i = 0; i < 3; ++i) {
			words.push(this.getCookie(this.prefixCookieChosenWords + i));
		}
		return words;
	};

	//----------------------------------------------------------------------------------------------------------------------------
	// Random Chosen Videos
	//----------------------------------------------------------------------------------------------------------------------------	

	this.saveChosenVideos = function(indexs)
	{
		for (var i = 0; i < indexs.length; ++i) {
			this.setCookie(this.prefixCookieChosenVideos + i, indexs[i]);
		}
	};

	this.getChosenVideos = function()
	{
		var indexs = [];
		for (var i = 0; i < 3; ++i) {
			var n = this.getCookie(this.prefixCookieChosenVideos + i);
			if (n !== null) {
				n = parseInt(n);
				if (n != -1) {
					indexs.push(n);
				}				
			}
		}
		return indexs;
	};		

	//----------------------------------------------------------------------------------------------------------------------------
	// All time played videos
	//----------------------------------------------------------------------------------------------------------------------------	

	this.getChoosenVideosFlags = function()
	{
		var var32bits = [];

		// Get previous used videos
		for (var i = 0; i < 3; ++i) {
			var v32 = this.getCookie(this.prefixCookiePlayedVideos + i);
			v32 = v32 === null ? 0 : parseInt(v32);
			var32bits.push(v32);
		}

		return var32bits;
	};

	this.savePlayedVideos = function(indexs, markPlayed)
	{
		// This function used 3 values of 32 bits to records used videos
		// This means we can record the state of 32 * 3 = 96 videos

		// Get previous used videos
		var var32bits = this.getChoosenVideosFlags();

		// Update 32 bits flags var
		var i;
		for (i = 0; i < indexs.length; ++i) {
			var index = indexs[i];
			for (var j = 0; j < var32bits.length; ++j) {
				var indexMax = (j+1)*32;
				if (index < indexMax) {
					var flag = 1 << (index - indexMax + 32);
					if (markPlayed) {
						var32bits[j] = var32bits[j] | flag;
					} else {
						var32bits[j] = var32bits[j] & ~flag;						
					}
					break;
				}
			}			
		}

		// Save updated flags
		for (i = 0; i < 3; ++i) {
			this.setCookie(this.prefixCookiePlayedVideos + i, var32bits[i]);
		}
	};

	this.IsThisVideoWasPlayed = function(var32bits, index)
	{
		for (var j = 0; j < var32bits.length; ++j) {
			var indexMax = (j+1)*32;
			if (index < indexMax) {
				return var32bits[j] & (1 << (index - indexMax + 32));
			}
		}
		return false;
	};

	this.clearAllVideosChoices = function()
	{
		for (i = 0; i < 3; ++i) {
			this.removeCookie(this.prefixCookiePlayedVideos + i);
		}
	};

	//----------------------------------------------------------------------------------------------------------------------------
	// Single video
	//----------------------------------------------------------------------------------------------------------------------------

	this.saveSingleVideo = function(name)
	{
		this.setCookie(this.prefixCookieSingleVideo, name);
	};

	this.getSingleVideo = function()
	{
		return this.getCookie(this.prefixCookieSingleVideo);
	};

	//----------------------------------------------------------------------------------------------------------------------------
	// Hd
	//----------------------------------------------------------------------------------------------------------------------------	

	this.setHD = function(state)
	{
		this.setCookie(this.prefixCookieHD, state); 
	};

	this.getHD = function()
	{
		var hd = this.getCookie(this.prefixCookieHD);
		if (hd == "0") {
			return false;
		}
		return true;
	};

	this.setSeekTime = function(time)
	{
		this.setCookie(this.prefixCookieSeekTime, time); 
	};

	this.getSeekTime = function()
	{
		var time = this.getCookie(this.prefixCookieSeekTime);
		if (time === null) {
			return 0;
		}
		return time;
	};

	//----------------------------------------------------------------------------------------------------------------------------
	// Url share
	//----------------------------------------------------------------------------------------------------------------------------			

	this.createShareUrl = function(index1, index2, index3)
	{
		var index = this.getChosenVideos();
		var code = 	index[0] + index[2];	
		var param = (index[0] << 24) | (index[1] << 16) | (index[2] << 8) | code;
		var urlBase = document.URL;
		urlBase = urlBase.replace("partage-du-film-aleatoire-the-end-etc", "film-aleatoire-the-end-etc");
		var url = urlBase + "?" + param;
		
		return url;
	};

	this.readUrlVideosIndex = function()
	{
		var query = window.location.search.substring(1);
		if (query.length === 0) {
			return [];
		}
		return this.decodeUrlIndex(query);
	};

	this.decodeUrlIndex = function(query)
	{
		var number = parseInt(query);

		var code = number & 255; 
		number >>= 8;
		var index3 = number & 255; 
		number >>= 8;
		var index2 = number & 255; 
		number >>= 8;
		var index1 = number & 255;

		if (code != index1 + index3) {
			return [];
		}

		if (typeof( incPlayer ) != "undefined") {
			var maxVideoIndex = incPlayer.allSequencesData.videos.length - 1;
			if (index1 > maxVideoIndex || index2 > maxVideoIndex || index3 > maxVideoIndex) {
				return [];
			}
		}

		return [index1, index2, index3]; 
	};				

	//----------------------------------------------------------------------------------------------------------------------------
	// Cookies tools
	//----------------------------------------------------------------------------------------------------------------------------		

	this.setCookie = function(name, value)
	{
		this.removeCookie(name);
		$.cookie(name, value, { expires: 7, path: '/' }); 
    };

	this.getCookie = function(name)
	{
		return $.cookie(name);
	};

	this.removeCookie = function(name)
	{
		$.removeCookie(name, { path: '/' });
	};	
}

var incChoice = new IncChoice();