var effectSpeed = 8;

function IncChoice()
{
	this.currentWorldIndex = 0;
	this.canSelectWord = true;

	this.setMosaicEffect = function(images1, images2)
	{
		// Choose 2 image for the effect
		var image1 = images1[incMosaic.randomInt(0, images1.length)];
		var image2 = images2[incMosaic.randomInt(0, images2.length)];
        incMosaic.addImageUrl("static/res/img/" + image1);
        incMosaic.addImageUrl("static/res/img/" + image2);

        // Start mosaic effect
    	incMosaic.start("mosaic", effectSpeed, 9, 5, false, true, function() {incChoice.effectIsDone();});        
	};

	this.setWords = function(choiceIndex)
	{
		if (choiceIndex == 0) {
			$("#mot1").html("famille");
			$("#mot2").html("amour");
			$("#mot3").html("travail");
			$("#mot4").html("international");
			$("#mot5").html("dieu");
			$("#mot6").html("president");

		} else if (choiceIndex == 1) {
			$("#mot1").html("actif");
			$("#mot2").html("passif");
			$("#mot3").html("corps");
			$("#mot4").html("charité");
			$("#mot5").html("patrie");
			$("#mot6").html("politique");

		} else {
			$("#mot1").html("spleen");
			$("#mot2").html("ideal");
			$("#mot3").html("origines");
			$("#mot4").html("peur");
			$("#mot5").html("desir");
			$("#mot6").html("bonheur");
		}
	};

	this.selectWord = function(wordIndex)
	{
		if (!this.canSelectWord) {
			// Don't set the word 2 times
			return;
		}

		this.canSelectWord = false;

		// Start the mosaic effect
		incMosaic.goEffect();

		// Fade the text
		$('.big_txt').animate({opacity: 0}, 20000 * 1 / effectSpeed);

		// Save the word
		this.setCookie("niv1_world" + this.currentWorldIndex, $("#mot" + wordIndex).html());
	};

	this.effectIsDone = function()
	{
		this.canSelectWord = true;
		++this.currentWorldIndex;

		// Change list of words
		this.setWords(this.currentWorldIndex);

		// Fade the text
		$('.big_txt').animate({opacity: 1}, 20000 * 1 / effectSpeed);

		if (this.currentWorldIndex == 3) {
			// The 3 words get choosen
			location.href = "niv1_videoplayer.html";
		}
	}

	this.setCookie = function(name, value)
	{
		$.removeCookie(name);
		$.cookie(name, value, { expires: 7, path: '/' });    	
    };

	this.getCookie = function(name) {
		return $.cookie(name);
	};
}

var incChoice = new IncChoice();