<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/doctrine/BaseFormFilterDoctrine.class.php');

/**
 * ThdVideo filter form base class.
 *
 * @package    filters
 * @subpackage ThdVideo *
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 11675 2008-09-19 15:21:38Z fabien $
 */
class BaseThdVideoFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'ref'      => new sfWidgetFormDoctrineChoice(array('model' => 'ThdSegment', 'add_empty' => true)),
      'film_ref' => new sfWidgetFormDoctrineChoice(array('model' => 'ThdFilm', 'add_empty' => true)),
      'file'     => new sfWidgetFormFilterInput(),
      'title'    => new sfWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'ref'      => new sfValidatorDoctrineChoice(array('required' => false, 'model' => 'ThdSegment', 'column' => 'id')),
      'film_ref' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => 'ThdFilm', 'column' => 'id')),
      'file'     => new sfValidatorPass(array('required' => false)),
      'title'    => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('thd_video_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'ThdVideo';
  }

  public function getFields()
  {
    return array(
      'id'       => 'Number',
      'ref'      => 'ForeignKey',
      'film_ref' => 'ForeignKey',
      'file'     => 'Text',
      'title'    => 'Text',
    );
  }
}