uc = uc || {};
uc.player = uc.player || {};
uc.player.classIdExpr = /media-(\S+)-(\S+)/;
uc.player.jsLoaded = false;
uc.player.skins = {
    universcine:  {
        // display properties such as size, location and opacity
        bottom: 0,
        height: 24,

        // progress bar
        progressColor: '#990000',
        bufferColor: '#333333',
        SliderColor: '#333333',

        // buttons
       	buttonColor: '#990000',
        buttonColorOver: '#999999',

        // styling properties (will be applied to all plugins)
		backgroundColor: '#000000',
		backgroundGradient: 'none',
		opacity: 0.8,

        // controlbar specific settings
        autoHide: true,
        all: false,
        play: true,
        scrubber: true,
        mute: true,
        volume: true,
        fullscreen: true,

        // a little more styling
        width: '99%',
        bottom: 2,
        left: '50%',
        borderRadius: 5
    }
}

uc.player.conf = {
    video: {
    	clip: {
        	autoPlay: true,
        	autoBuffering: true,
                scaling: 'fit'
        },
        plugins: {
        	controls: uc.player.skins.universcine
        }
    },

    slideshow: {
    	clip: {
	    	autoPlay: true,
	        autoBuffering: false,
	        scaling: 'fit'
    	},
    	plugins: {
            controls: null
        },
        play: {
          opacity:0
        }
    }
}

uc.player.currentPlayer = null;

uc.player.loadJS = function(callback) {
	// Preload flowplayer
	jQuery.getScript('/js/flowplayer/flowplayer-3.1.0.min.js', function () {
		jQuery.getScript('/js/flowplayer/flowplayer.playlist-3.0.5.min.js', function () {
			uc.player.jsLoaded = true;
			callback();
		});
	});
}

uc.player.mediaPlayer = function(node) {
	this.jq_playlist = jQuery(node);

	// Extract playlist id
	var matches = this.jq_playlist.attr('id').match(uc.player.classIdExpr);
	this.playlist_id = matches[2];

	// Get default playlist
	this.default_playlist = 'image';

	if (jQuery('.video-playlist.default-playlist', this.jq_playlist).length == 1) this.default_playlist = 'video';

	// Extract video playlist
	this.video_playlist = [];
	var self = this;
	jQuery('.video-playlist .media-item', this.jq_playlist).each(function(index) {
		var jq_this = jQuery(this);

		// Extract media info
		var media_item = {uri: null, thumb_uri: null};
		var jq_uri = jQuery('.media-uri', jq_this);
		media_item.uri = jq_uri.attr('href');
		var jq_thumb_uri = jQuery('.media-thumb-uri', jq_this);
		if (jq_thumb_uri.length == 1) media_item.thumb_uri = jq_thumb_uri.attr('href');
		self.video_playlist[index] = media_item;

		// Wrap media click
		jq_uri.attr('href', 'javascript:void(0)');
		jq_uri.click(function () {
			self.playVideo(index);
		});
	});

	// Extract image playlist
	this.image_playlist = [];
	var self = this;
	jQuery('.image-playlist .media-item', this.jq_playlist).each(function(index) {
		var jq_this = jQuery(this);

		// Extract media info
		var media_item = {uri: null};
		var jq_uri = jQuery('.media-uri', jq_this);
		media_item.uri = jq_uri.attr('href');
		self.image_playlist[index] = media_item;

		// Wrap media click
		jq_uri.attr('href', 'javascript:void(0)');
		jq_uri.click(function () {
			self.playSlideShow(index);
		});
	});

	// Search the place to include the media player
	this.jq_player_wrapper = jQuery('<div class="media-player-wrapper" id="media-player-wrapper-' + this.playlist_id + '">&nbsp;</div>');
	jq_place = jQuery('.media-player-after', this.jq_playlist);

	if (jq_place.length == 1) {
		jq_place.after(this.jq_player_wrapper);
	} else {
		jq_place = jQuery('.media-player-before', this.jq_playlist);
		jq_place.before(this.jq_player_wrapper);
	}

	this.showPlayer();
}

uc.player.mediaPlayer.prototype = {
	removePlayer: function() {
		jQuery('.media-player', this.jq_player_wrapper).unload();
		jQuery('*', this.jq_player_wrapper).remove();
	},
	stopPlayer: function() {
		this.removePlayer();
		this.showPlayer();
	},
	showPlayer: function() {
		var jq_play_button = jQuery('<a class="play-button">Play</a>');
		var self = this;
		this.jq_player_wrapper.append(jq_play_button);

		// Get default media
		var default_media = null;

		if (this.default_playlist == 'video') {
			default_media = this.video_playlist[0];
			jq_play_button.click(function() {self.playVideo(0)});
		} else {
			default_media = this.image_playlist[0];
			default_media.thumb_uri = default_media.uri;
			jq_play_button.click(function() {self.playSlideShow(0)});
		}

		if (default_media.thumb_uri) {
			// Add background to player
			this.jq_player_wrapper.css('background-image', 'url(' + default_media.thumb_uri + ')');
			this.jq_player_wrapper.css('background-repeat', 'no-repeat');
			this.jq_player_wrapper.css('background-position', '50% 0%');
		}
	},
	createPlayer: function(media, conf)  {
		// Stop current player
		var current_player = uc.player.currentPlayer;
		if (current_player && current_player.playlist_id != this.playlist_id) current_player.stopPlayer();


		// Create new player
		this.removePlayer();
		uc.player.currentPlayer = this;
		this.jq_player_wrapper.append('<a id="media-player-' + this.playlist_id + '" class="media-player" href="' + media.uri + '"/>');
		return flowplayer('media-player-' + this.playlist_id, {src: '/swf/flowplayer-3.1.0.swf', wmode: 'opaque'}, conf);
	},
	playVideo: function(index) {
		var media = this.video_playlist[index];
		var conf = uc.player.conf.video;
		conf.playlist = [];
		conf.playlist.push({url: media.uri});
		this.createPlayer(media, conf);
	},

	playSlideShow: function(index) {
		var conf = uc.player.conf.slideshow;
		var duration = 5;
		conf.playlist = [];

		for (var i=index; i<this.image_playlist.length; i++) {
			conf.playlist.push({url: this.image_playlist[i].uri, duration: duration, scaling: true});
		}

		for (var i=0; i<index; i++) {
			conf.playlist.push({url: this.image_playlist[i].uri, duration: duration, scaling: true});
		}

		// Add loop features if there are more than one items
		if (conf.playlist.length > 1) {
			conf.playlist[conf.playlist.length - 1].onBeforeFinish = function () {return false;}
		}

		var media = this.image_playlist[index];
		this.createPlayer(media, conf);
	}
}

uc.player.initPlayer = function(selector) {
	jQuery(selector).each(function($index) {
		var player = new uc.player.mediaPlayer(this);
	});
}

uc.player.build = function (selector) {
	if (!uc.player.jsLoaded && jQuery(selector).length > 0) {
		uc.player.loadJS(function() {uc.player.initPlayer(selector);});
	} else {
		uc.player.initPlayer(selector);
	}
}
