# encoding: utf-8
from south.db import db
from south.v2 import SchemaMigration

class Migration(SchemaMigration):

    def forwards(self, orm):
        
        # Adding model 'Annotation'
        db.create_table('text_annotation', (  # @UndefinedVariable
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('external_id', self.gf('django.db.models.fields.CharField')(default=u'5393f930-c975-11e0-bf36-58b035f6b93d', unique=True, max_length=255)),
            ('uri', self.gf('django.db.models.fields.CharField')(max_length=1024)),
            ('tags_field', self.gf('tagging.fields.TagField')(max_length=2048, null=True)),
            ('title', self.gf('django.db.models.fields.CharField')(max_length=1024, null=True, blank=True)),
            ('description', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('text', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('color', self.gf('django.db.models.fields.CharField')(max_length=1024)),
            ('creator', self.gf('django.db.models.fields.CharField')(max_length=1024, null=True, blank=True)),
            ('contributor', self.gf('django.db.models.fields.CharField')(max_length=1024, null=True, blank=True)),
            ('creation_date', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
            ('update_date', self.gf('django.db.models.fields.DateTimeField')(auto_now=True, blank=True)),
        ))
        db.send_create_signal('text', ['Annotation'])  # @UndefinedVariable


    def backwards(self, orm):
        
        # Deleting model 'Annotation'
        db.delete_table('text_annotation')  # @UndefinedVariable


    models = {
        'text.annotation': {
            'Meta': {'object_name': 'Annotation'},
            'color': ('django.db.models.fields.CharField', [], {'max_length': '1024'}),
            'contributor': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'creation_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'creator': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'description': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'external_id': ('django.db.models.fields.CharField', [], {'default': "u'53952d00-c975-11e0-b311-58b035f6b93d'", 'unique': 'True', 'max_length': '1024'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'tags_field': ('tagging.fields.TagField', [], {'max_length': '2048', 'null': 'True'}),
            'text': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'update_date': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'uri': ('django.db.models.fields.CharField', [], {'max_length': '1024'})
        }
    }

    complete_apps = ['text']
