class sysconfig::django_init (
    $superuser_name = hiera('sysconfig::params::superuser_name', $sysconfig::params::superuser_name ),
    $superuser_pw   = hiera('sysconfig::params::superuser_pw'  , $sysconfig::params::superuser_pw   ),
    $path_to_virtualenv = hiera('sysconfig::params::path_to_virtualenv', $sysconfig::params::path_to_virtualenv )
) inherits sysconfig::params {
    
    notify {'django_init': name => "django init \$superuser_name : ${superuser_name}, \$superuser_pw : ${superuser_pw}", withpath => true }->

    exec { 'syncdb_without_south':
        command => "/usr/bin/python /srv/spel/dev/files/settings_south_syncdb.py -i /srv/spel/src/spel/settings.py && . ${path_to_virtualenv}/bin/activate && ${path_to_virtualenv}/bin/python manage.py syncdb --noinput",
        cwd     => '/srv/spel/src',
        user    => 'vagrant',
        provider => 'shell';
    }
    exec { 'syncdb_with_south':
        command => "/usr/bin/python /srv/spel/dev/files/settings_south_syncdb.py -r -i /srv/spel/src/spel/settings.py && . ${path_to_virtualenv}/bin/activate && ${path_to_virtualenv}/bin/python manage.py syncdb --noinput",
        cwd     => '/srv/spel/src',
        user    => 'vagrant',
        provider => 'shell',
        require => Exec['syncdb_without_south'];
    }
    exec { 'tricking_manage_py':
        command => ". ${path_to_virtualenv}/bin/activate && ${path_to_virtualenv}/bin/python manage.py migrate --fake",
        cwd     => '/srv/spel/src',
        user    => 'vagrant',
        provider => 'shell',
        require => Exec['syncdb_with_south'];
    }

    exec { 'loaddata':
        command => ". ${path_to_virtualenv}/bin/activate && ${path_to_virtualenv}/bin/python manage.py loaddata roles_generic",
        cwd     => '/srv/spel/src',
        user    => 'vagrant',
        provider => 'shell',
        require => Exec['tricking_manage_py']
    }

    exec { 'createsuperuser':
        command => "/bin/echo \"from django.contrib.auth.models import User; User.objects.create_superuser('${superuser_name}', 'admin@example.com', '${superuser_pw}')\" | . ${path_to_virtualenv}/bin/activate && ${path_to_virtualenv}/bin/python manage.py shell",
        cwd     => '/srv/spel/src',
        user    => 'vagrant',
        provider => 'shell',
        onlyif  => "/bin/echo \"from django.contrib.auth.models import User; exit(User.objects.filter(username='${superuser_name}').count())\" | . ${path_to_virtualenv}/bin/activate && ${path_to_virtualenv}/bin/python manage.py shell",
       require => Exec['tricking_manage_py']
    }

}