'''
Created on 2014-02-21

@author: tcavalie
'''

from django.conf import settings
from django.views.generic import TemplateView
from tagging.models import Tag, TaggedItem
from ldt.ldt_utils.models import Segment


import logging
logger = logging.getLogger(__name__)



class Home(TemplateView):
    
    template_name = "spel_home.html"
    
    def get(self, request):
        
        context = {}
        
        return self.render_to_response(context)


class ChapterRequest(TemplateView):
    
    template_name = "partial/spel_chapters.html"
    
    def get(self, request):
        # Filter segment if necessary
        annot_types_param = request.GET.get("annotation_types", "")
        seg_queryset = Segment
        if annot_types_param!="":
            annot_types = annot_types_param.split(",")
            seg_queryset = Segment.objects.filter(cutting_id__in=annot_types)
        
        # First we look at modalites_sceniques and personnages tags.
        mod_scen_param = request.GET.get("modalites_sceniques", "")
        mod_scen = []
        if mod_scen_param!="":
            mod_scen = mod_scen_param.split(",")
        perso_param = request.GET.get("personnages", "")
        perso = []
        if perso_param!="":
            perso = perso_param.split(",")
        
        # Get tags from orm
        all_tags = mod_scen + perso
        tags = Tag.objects.filter(name__in=all_tags)
        # Get segments from tagged items
        s = TaggedItem.objects.get_by_model(seg_queryset, tags)
        
        
        logger.debug("COUCOU")
        #logger.debug(mod_scen_param)
        #logger.debug(perso_param)
        #logger.debug(mod_scen)
        #logger.debug(perso)
        #logger.debug(tags)
        #logger.debug(s)
        
        context = {"segments": s }
        
        return self.render_to_response(context)

    