from django.template import Library, TemplateSyntaxError

register = Library()

import logging
logger = logging.getLogger(__name__)

@register.filter
def get_tags(value, arg=None):
    """ Takes a segment's tag list and returns an array of values from argument. Example seg_obj|get_tags:"personnages" will return "Romeo, Juliette" """
    # Error management
    if value is None :
        return ""
    if not isinstance(value, (str,unicode)) :
        raise TemplateSyntaxError('get_tags value error : string is required')
    # If no arg, we join all values
    a = value.split(u",")
    val = []
    if arg is None :
        for t in a:
            val.append(t[t.index(":")+2:])
    elif arg=="ref_text_2":
        logger.debug("ICI 1")
        for t in a:
            logger.debug("ICI 2")
            if t[:t.index(":")]=="ref_text":
                logger.debug("ICI 3")
                tag_split = t.split(":")
                if len(tag_split)>2:
                    logger.debug("ICI 4")
                    val.append( ":".join(tag_split[2:]) )
                else:
                    logger.debug("ICI 5")
                    val.append(t[t.index(":")+2:])
    
    return ", ".join(val)
get_tags.is_safe = True

