$(document).ready(function () {
	
	// Chapter multiselect management
	$('.chapters .multiselect').multiselect({
	    buttonText: function(options, select) {
	      return $(select).attr("data-title") + ' (' + options.length + ') <b class="caret"></b>';
	    },
	    onChange: function(element, checked) {
	      var filter_enabled = false;
	      var chbs = $(".chapters input:checkbox");
	      for (var i = chbs.length - 1; i >= 0; i--) {
	        filter_enabled = filter_enabled || $(chbs[i]).is(":checked");
	      };
	      if(filter_enabled){
	        $("#btn-filter-chapters").removeAttr('disabled');
	      }
	      else{
	        $("#btn-filter-chapters").attr('disabled','disabled');
	      }
	    }
	});
	// Annotations multiselect management
	$('.annotations .multiselect').multiselect({
	    buttonText: function(options, select) {
	      return $(select).attr("data-title") + ' (' + options.length + ') <b class="caret"></b>';
	    },
	    buttonContainer: '<div class="btn-group width100percent" />',
	    buttonClass: 'btn btn-default width100percent disabled',
	    onChange: function(element, checked) {
	      var filter_enabled = false;
	      var chbs = $(".annotations input:checkbox");
	      for (var i = chbs.length - 1; i >= 0; i--) {
	        filter_enabled = filter_enabled || $(chbs[i]).is(":checked");
	      };
	      if(filter_enabled){
	        $("#btn-filter-annotations").removeAttr('disabled');
	      }
	      else{
	        $("#btn-filter-annotations").attr('disabled','disabled');
	      }
	    }
	});

	// Data 1
	var data1 = [
	    {label: "Performance", value: "performance"},
	    {label: "Discussion", value: "discussion"}
    ];
	$("#mulsel1").multiselect('dataprovider', data1);
  
	// Data 2 : modalités scéniques
	$.ajax({
		url: urlMS
	})
	.done(function( data ) {
		var o = data.objects;
		var n = data.objects.length;
		var data2 = [];
		for(var i=0;i<n;i++){
			data2.push({label: o[i].name.substr(21), value: o[i].name})
		}
		$("#mulsel2").multiselect('dataprovider', data2);
		$("#mulsel2").multiselect('enable');
	});
  
	// Data 3 : Personnages
	$.ajax({
		url: urlP
	})
	.done(function( data ) {
		var o = data.objects;
		var n = data.objects.length;
		var data3 = [];
		for(var i=0;i<n;i++){
			data3.push({label: o[i].name.substr(12), value: o[i].name})
		}
		$("#mulsel3").multiselect('dataprovider', data3);
		$("#mulsel3").multiselect('enable');
	});

	// Data 4 : type interventions
	$.ajax({
		url: urlTI
	})
	.done(function( data ) {
		var o = data.objects;
		var n = data.objects.length;
		var data4 = [];
		for(var i=0;i<n;i++){
			data4.push({label: o[i].name.substr(11), value: o[i].name})
		}
		$("#mulsel4").multiselect('dataprovider', data4);
		$("#mulsel4").multiselect('enable');
	});
	$(document).on('input', "#search-input", function(){
		if($(this).val()!=""){
			$("#btn-search-annotations").removeAttr('disabled');
		}
		else{
			$("#btn-search-annotations").attr('disabled','disabled');
		}
	});

	// Search chapters management
	$("#btn-filter-chapters").click(function(e){
		if($("#mulsel1").val()==null && $("#mulsel2").val()==null && $("#mulsel3").val()==null){
			$(".chapter-results").html("<p>Vous devez sélectionner au moins un filtre</p>");
			return false;
		}
		$(".chapter-results").html("<br/><br/>");
		$(".chapter-results").addClass("loader");
		$.ajax({
			url: urlChapters,
			data:{
				start_date: $('input[name=start_date]').val(),
				end_date: $('input[name=end_date]').val(),
				annotation_types: ( ($("#mulsel1").val()==null) ? [] : $("#mulsel1").val() ).join(","),
				modalites_sceniques: ( ($("#mulsel2").val()==null) ? [] : $("#mulsel2").val() ).join(","),
				personnages: ( ($("#mulsel3").val()==null) ? [] : $("#mulsel3").val() ).join(",")
			}
		})
		.done(function( html ) {
			$(".chapter-results").removeClass("loader");
			$(".chapter-results").html(html);
		})
		.fail(function() {
			$(".chapter-results").removeClass("loader");
			$(".chapter-results").html('<p class="bg-danger">Erreur de chargement</p>');
		});
	});
	
	
	// Search annotations management
	$("#btn-search-annotations").click(function(e){
		e.preventDefault();
	});
	
	


});
