from django.conf import settings
from django.conf.urls import patterns, include, url
from django.conf.urls.static import static
from django.contrib import admin
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
from django.views.generic import RedirectView, TemplateView
from ldt.auth.views import login as pf_login
from ldt.text import VERSION_STR
from .views import ChapterRequest, Spectacle

#from django.conf import settings

# Uncomment the next two lines to enable the admin:
admin.autodiscover()

js_info_dict = {
    'packages': ('django.contrib.admin',), 
}

urlpatterns = patterns('',
    # Example:

    # Uncomment the admin/doc line below and add 'django.contrib.admindocs' 
    # to INSTALLED_APPS to enable admin documentation:
    # (r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    (r'^admin/', include(admin.site.urls)),
    (r'^i18n/', include('django.conf.urls.i18n')),

    (r'^ldt/', include('ldt.ldt_utils.urls')),
    (r'^user/', include('ldt.user.urls')),
    (r'^api/', include('ldt.api.urls')),
    (r'^api/' + VERSION_STR + '/text/', include('ldt.text.urls')),

    (r'^auth_accounts/', include('registration.backends.simple.urls')),

    #(r'^accounts/', include('socialauth.urls')),
    (r'^accounts/', include('social_auth.urls')),
    url(r'^accounts/login/$',pf_login,{'template_name': 'registration/login.html'},name='auth_login'),
    (r'^oauth/', include('oauth_provider.urls')),
    
    #(r'^platform/?$', RedirectView.as_view(url='ldt')),
    
    (r'^jsi18n/$', 'django.views.i18n.javascript_catalog', js_info_dict),
    url(r'^$', TemplateView.as_view(template_name="spel_home.html"), name='spel_home'),
    url(r'^spectacle$', Spectacle.as_view(), name='spel_spectacle'),
    url(r'^chapters$', ChapterRequest.as_view(), name='spel_chapters'),
)

urlpatterns += staticfiles_urlpatterns()
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)