'''
Created on 2014-02-21

@author: tcavalie
'''
import json
import time
from django.db.models import Q
from django.conf import settings
from django.views.generic import TemplateView
from itertools import groupby
from operator import itemgetter
from tagging.models import Tag, TaggedItem
from ldt.ldt_utils.models import Segment, Content


import logging
from ldt.ldt_utils.views.workspace import get_search_results
from django.http.response import HttpResponse
from django.db.models.query import RawQuerySet
logger = logging.getLogger(__name__)



class Home(TemplateView):
    template_name = "spel_home.html"
    def get(self, request):
        context = {}
        return self.render_to_response(context)



class Spectacle(TemplateView):
    template_name = "spel_spectacle.html"
    def get(self, request):
        # Get start and end for date bounds (earliest is available only on django 1.6)
        start_date = Content.objects.all().order_by("content_creation_date")[0].content_creation_date
        end_date = Content.objects.latest("content_creation_date").content_creation_date
        context = {"start_date":start_date, "end_date":end_date, "chapter_ids": settings.CHAPTER_IDS }
        return self.render_to_response(context)



class ChapterRequest(TemplateView):
    
    template_name = "partial/spel_chapters.html"
    
    def get(self, request):
        # Filter content by date if necessary
        content_qs = Content.objects.all()
        start_date_param = request.GET.get("start_date", "")
        if start_date_param!="":
            content_qs = content_qs.filter(content_creation_date__gt=start_date_param)
        end_date_param = request.GET.get("end_date", "")
        if end_date_param!="":
            content_qs = content_qs.filter(content_creation_date__lt=end_date_param + " 23:59:59")
        iri_ids = content_qs.values_list("iri_id", flat=True)
        #logger.debug("iri_ids")
        #logger.debug(iri_ids)
        # Filter segment if necessary
        annot_types_param = request.GET.get("annotation_types", "")
        seg_queryset = Segment.objects.filter(iri_id__in=iri_ids).select_related('content__title')
        annot_types = []
        if annot_types_param!="":
            annot_types = annot_types_param.split(",")
            seg_queryset = seg_queryset.filter(cutting_id__in=annot_types)
        
        # First we look at modalites_sceniques and personnages tags.
        mod_scen_param = request.GET.get("modalites_sceniques", "")
        mod_scen = []
        if mod_scen_param!="":
            mod_scen = mod_scen_param.split(",")
        perso_param = request.GET.get("personnages", "")
        perso = []
        if perso_param!="":
            perso = perso_param.split(",")
        
        # All tags from mod_scen and perso
        all_tags = mod_scen + perso
        
        # Tags from start text and end text
        all_ref_text = settings.CHAPTER_IDS
        start_text = request.GET.get("start_text", "")
        end_text = request.GET.get("end_text", "")
        ref_text = None
        if (start_text!="" and start_text!="start") or (end_text!="" and end_text!="end"):
            # At least start or end have been defined, so we search for the concerned chapter ids.
            start_index = 0
            if start_text!="start":
                try:
                    start_index = all_ref_text.index(start_text)
                except:
                    pass
            end_index = len(all_ref_text)
            if end_text!="end":
                try:
                    end_index = all_ref_text.index(end_text) + 1
                except:
                    pass
            searched_ref_text = all_ref_text[start_index:end_index]
            ref_text = Tag.objects.filter(name__in=[ ("ref_text: " + rt) for rt in searched_ref_text ])
            #return HttpResponse(", ".join(all_tags))
        
        # Get tags from orm
        tags = Tag.objects.filter(name__in=all_tags)
        # Ref text filter if possible
        if ref_text and len(ref_text)>0:
            # a chapter can only have on ref_text, and the search on ref_text is a OR.
            # That's many request by (with the orm) it's the only thing
            s = []
            for rt in ref_text:
                current_tags = list(tags)
                current_tags.append(rt)
                s += list(TaggedItem.objects.get_by_model(seg_queryset, current_tags))
        else:
            # Get segments from tagged items
            s = TaggedItem.objects.get_by_model(seg_queryset, tags)
        
        #logger.debug("COUCOU")
        #logger.debug(mod_scen_param)
        #logger.debug(perso_param)
        #logger.debug(mod_scen)
        #logger.debug(perso)
        #logger.debug(tags)
        #logger.debug(s)
        
        context = {"annot_types": annot_types, "mod_scen":mod_scen, "perso":perso, "segments": s}
        
        return self.render_to_response(context)
    
    def post(self, request):
        annotations_param = request.POST.get("annotations", "[]")
        grouped_annotations = []
        for iri_id, items in groupby(json.loads(annotations_param), itemgetter('iri_id')):
            # Get segments timecodes
            s = [ int(i["data"]) for i in items ]
            grouped_annotations.append({ 'content': iri_id, 'list': s })
        if len(grouped_annotations)==0:
            return HttpResponse("")
        # Request segment : we make a complex query impossible (?) to do with orm, even with Q, Sum and other stuffs.
        # Here is a SQL example of what we want :
        # select ldt_utils_segment.id, ldt_utils_segment.cutting_id, ldt_utils_segment.tags, ldt_utils_segment.start_ts, ldt_utils_segment.duration, ldt_utils_content.title AS ct
        # from ldt_utils_segment 
        # INNER JOIN ldt_utils_content ON (ldt_utils_segment.content_id = ldt_utils_content.id)
        # where cutting_id IN ('performance','discussion') 
        # AND (
        #   ( ldt_utils_segment.iri_id='CONTENT_ID_1' AND (
        #     ( ldt_utils_segment.start_ts < TIMECODE_1 AND TIMECODE_1 < (ldt_utils_segment.start_ts + ldt_utils_segment.duration) )
        #      OR 
        #     ( ldt_utils_segment.start_ts < TIMECODE_2 AND TIMECODE_2 < (ldt_utils_segment.start_ts + ldt_utils_segment.duration) )
        #   )) 
        #   OR 
        #   ( ldt_utils_segment.iri_id='CONTENT_ID_2' AND (
        #     ( ldt_utils_segment.start_ts < TIMECODE_3 AND TIMECODE_3 < (ldt_utils_segment.start_ts + ldt_utils_segment.duration) )
        #   )) 
        # )
        
        raw_query = "select ldt_utils_segment.id, ldt_utils_segment.cutting_id, ldt_utils_segment.tags, ldt_utils_segment.start_ts, ldt_utils_segment.duration, ldt_utils_content.title AS ct \nfrom ldt_utils_segment \nINNER JOIN ldt_utils_content ON (ldt_utils_segment.content_id = ldt_utils_content.id) \nwhere cutting_id IN ('performance','discussion') \nAND ("
        for i, ga in enumerate(grouped_annotations):
            if i>0:
                raw_query += "\n  OR "
            raw_query += "\n  ( ldt_utils_segment.iri_id='" + ga["content"] + "' AND ("
            for j, tc in enumerate(ga["list"]):
                if j>0:
                    raw_query += "\n     OR "
                raw_query += "\n    ( ldt_utils_segment.start_ts < " + str(tc) + " AND " + str(tc) + " < (ldt_utils_segment.start_ts + ldt_utils_segment.duration) )"
            raw_query += "\n  )) "
        raw_query += "\n) "
        
        context = {"annot_chapters": True, "annot_types": [], "mod_scen":[], "perso":[], "segments": list(Segment.objects.raw(raw_query)) }
        return self.render_to_response(context)



class AnnotationRequest(TemplateView):
    
    template_name = "partial/spel_annotations.html"
    
    def get(self, request):
        q = request.GET.get("q", "")
        page = 1
        content_list = None
        if q!="":
            field = "abstract"
            results, nb_contents, nb_segments = get_search_results(request, q, field, page, content_list)
            results = results.object_list
            type_inter_param = ""
        else:
            type_inter_param = request.GET.get("type_inter", "")
            seg_queryset = []
            results = []
            tagged_segs = []
            if type_inter_param!="":
                type_inter = [("type_inter: " + t) for t in type_inter_param.split(",")]
                tags = Tag.objects.filter(name__in=type_inter)
                # Get segments from tagged items
                tagged_segs = TaggedItem.objects.get_by_model(Segment, tags).values()
                # Prefetch all contents
                all_contents = list(Content.objects.filter(iri_id__in=[s['iri_id'] for s in tagged_segs]))
                for iri_id, items in groupby(tagged_segs, itemgetter('iri_id')):
                    # Get good content
                    content = None
                    content_filter = filter(lambda e: e.iri_id == iri_id, all_contents)
                    if len(content_filter)>0:
                        content = content_filter[0]
                    if content is None:
                        continue
                    # Get segments
                    s = list(items)
                    results.append({ 'content': content, 'list': s })
            nb_contents = len(results)
            nb_segments = len(tagged_segs)
        
        context = {"q":q, "searched_tags": type_inter_param.split(","), "results": results, "nb_contents": nb_contents, "nb_annotations": nb_segments}
        
        return self.render_to_response(context)
    
    def post(self, request):
        chapters_param = request.POST.get("chapters", "[]")
        grouped_chapters = []
        for iri_id, items in groupby(json.loads(chapters_param), itemgetter('iri_id')):
            # Get segments timecodes
            s = [ {"start": int(i["start"]), "end": int(i["end"])} for i in items ]
            grouped_chapters.append({ 'content': iri_id, 'list': s })
        if len(grouped_chapters)==0:
            return HttpResponse("")
        
        
        # Request segment : we make a complex query impossible (?) to do with orm, even with Q, Sum and other stuffs.
        # Here is a SQL example of what we want :
        # select *
        # from ldt_utils_segment 
        # where cutting_id IN ('performance','discussion') 
        # AND (
        #   ( ldt_utils_segment.iri_id='CONTENT_ID_1' AND (
        #     ( TIMECODE_START_1 < ldt_utils_segment.start_ts AND ldt_utils_segment.start_ts < TIMECODE_END_1 )
        #      OR 
        #     ( TIMECODE_START_2 < ldt_utils_segment.start_ts AND ldt_utils_segment.start_ts < TIMECODE_END_2 )
        #   )) 
        #   OR 
        #   ( ldt_utils_segment.iri_id='CONTENT_ID_2' AND (
        #     ( TIMECODE_START_3 < ldt_utils_segment.start_ts AND ldt_utils_segment.start_ts < TIMECODE_END_3 )
        #   )) 
        # )
        
        raw_query = "select id, iri_id, cutting_id, tags, start_ts, duration, title, abstract \nfrom ldt_utils_segment \nwhere cutting_id NOT IN ('performance','discussion') \nAND ("
        for i, ga in enumerate(grouped_chapters):
            if i>0:
                raw_query += "\n  OR "
            raw_query += "\n  ( ldt_utils_segment.iri_id='" + ga["content"] + "' AND ("
            for j, tc in enumerate(ga["list"]):
                if j>0:
                    raw_query += "\n     OR "
                raw_query += "\n    ( " + str(tc["start"]) + " < ldt_utils_segment.start_ts AND ldt_utils_segment.start_ts < " + str(tc["end"]) + " )"
            raw_query += "\n  )) "
        raw_query += "\n)"
        
        # Dict because of itemgetter for groupby
        tagged_segs = [ dict(s.__dict__) for s in Segment.objects.raw(raw_query) ]
        for i in tagged_segs:
            i["tags"] = i["_tags_cache"] # WHY ????? Because i don't know but we need it
        # Prefetch all contents
        all_contents = list(Content.objects.filter(iri_id__in=[s['iri_id'] for s in tagged_segs]))
        results = []
        for iri_id, items in groupby(tagged_segs, itemgetter('iri_id')):
            # Get good content
            content = None
            content_filter = filter(lambda e: e.iri_id == iri_id, all_contents)
            if len(content_filter)>0:
                content = content_filter[0]
            if content is None:
                continue
            # Get segments
            s = list(items)
            results.append({ 'content': content, 'list': s })
        nb_contents = len(results)
        nb_segments = len(tagged_segs)
        
        context = {"chapter_annots":True, "q":"", "searched_tags": [], "results": results, "nb_contents": nb_contents, "nb_annotations": nb_segments}
        
        return self.render_to_response(context)









    