$(document).ready(function () {
	
	// Chapter multiselect management
	$('.chapters .multiselect').multiselect({
	    buttonText: function(options, select) {
	      return $(select).attr("data-title") + ' (' + options.length + ') <b class="caret"></b>';
	    },
	    onChange: function(element, checked) {
	      var filter_enabled = false;
	      var chbs = $(".chapters input:checkbox");
	      for (var i = chbs.length - 1; i >= 0; i--) {
	        filter_enabled = filter_enabled || $(chbs[i]).is(":checked");
	      };
	      if(filter_enabled){
	        $("#btn-filter-chapters").removeAttr('disabled');
	      }
	      else{
	        $("#btn-filter-chapters").attr('disabled','disabled');
	      }
	    }
	});
	// Annotations multiselect management
	$('.annotations .multiselect').multiselect({
	    buttonText: function(options, select) {
	      return $(select).attr("data-title") + ' (' + options.length + ') <b class="caret"></b>';
	    },
	    buttonContainer: '<div class="btn-group width100percent" />',
	    buttonClass: 'btn btn-default width100percent disabled',
	    /*onChange: function(element, checked) {
	      var filter_enabled = false;
	      var chbs = $(".annotations input:checkbox");
	      for (var i = chbs.length - 1; i >= 0; i--) {
	        filter_enabled = filter_enabled || $(chbs[i]).is(":checked");
	      };
	      if(filter_enabled){
	        $("#btn-filter-annotations").removeAttr('disabled');
	      }
	      else{
	        $("#btn-filter-annotations").attr('disabled','disabled');
	      }
	    }*/
	});

	// Data 1
	var data1 = [
	    {label: "Performance", value: "performance"},
	    {label: "Discussion", value: "discussion"}
    ];
	$("#mulsel1").multiselect('dataprovider', data1);
  
	// Data 2 : modalités scéniques
	$.ajax({
		url: urlMS
	})
	.done(function( data ) {
		var o = data.objects;
		var n = data.objects.length;
		var data2 = [];
		for(var i=0;i<n;i++){
			data2.push({label: o[i].name.substr(21), value: o[i].name})
		}
		$("#mulsel2").multiselect('dataprovider', data2);
		$("#mulsel2").multiselect('enable');
	});
  
	// Data 3 : Personnages
	$.ajax({
		url: urlP
	})
	.done(function( data ) {
		var o = data.objects;
		var n = data.objects.length;
		var data3 = [];
		for(var i=0;i<n;i++){
			data3.push({label: o[i].name.substr(12), value: o[i].name})
		}
		$("#mulsel3").multiselect('dataprovider', data3);
		$("#mulsel3").multiselect('enable');
	});

	// Data 4 : type interventions
	$.ajax({
		url: urlTI
	})
	.done(function( data ) {
		var o = data.objects;
		var n = data.objects.length;
		var data4 = [];
		for(var i=0;i<n;i++){
			data4.push({label: o[i].name.substr(12), value: o[i].name.substr(12)})
		}
		$("#mulsel4").multiselect('dataprovider', data4);
		$("#mulsel4").multiselect('enable');
	});
	$(document).on('input', "#search-input", function(){
		if($(this).val()!=""){
			$("#btn-search-annotations").removeAttr('disabled');
		}
		else{
			$("#btn-search-annotations").attr('disabled','disabled');
		}
	});

	// Search chapters management
	$("#btn-filter-chapters").click(function(e){
		if($("#mulsel1").val()==null && $("#mulsel2").val()==null && $("#mulsel3").val()==null){
			$(".chapter-results").html("<p>Vous devez sélectionner au moins un filtre</p>");
			return false;
		}
		$(".chapter-results").html("<br/><br/>");
		$(".chapter-results").addClass("loader");
		$.ajax({
			url: urlChapters,
			data:{
				start_date: $('input[name=start_date]').val(),
				end_date: $('input[name=end_date]').val(),
				annotation_types: ( ($("#mulsel1").val()==null) ? [] : $("#mulsel1").val() ).join(","),
				modalites_sceniques: ( ($("#mulsel2").val()==null) ? [] : $("#mulsel2").val() ).join(","),
				personnages: ( ($("#mulsel3").val()==null) ? [] : $("#mulsel3").val() ).join(",")
			}
		})
		.done(function( html ) {
			$(".chapter-results").removeClass("loader");
			$(".chapter-results").html(html);
			$('.popinfo').popover({ html: true });
			$(".tablesorter").tablesorter({
			    theme : "bootstrap",
			    widthFixed: true,
			    headerTemplate : '{content} {icon}',
			    widgets : [ "uitheme"],
			    widgetOptions : {
			        zebra : ["even", "odd"],
			        filter_reset : ".reset"
			    },
			    headers: { 3: { sorter: false } }
			});
		})
		.fail(function() {
			$(".chapter-results").removeClass("loader");
			$(".chapter-results").html('<p class="bg-danger">Erreur de chargement</p>');
		});
	});
	
	$.extend($.tablesorter.themes.bootstrap, {
		// these classes are added to the table. To see other table classes available,
		// look here: http://twitter.github.com/bootstrap/base-css.html#tables
		table      : 'table table-bordered',
		caption    : 'caption',
		header     : 'bootstrap-header', // give the header a gradient background
		footerRow  : '',
		footerCells: '',
		icons      : '', // add "icon-white" to make them white; this icon class is added to the <i> in the header
		sortNone   : 'bootstrap-icon-unsorted',
		sortAsc    : 'icon-chevron-up glyphicon glyphicon-chevron-up',     // includes classes for Bootstrap v2 & v3
		sortDesc   : 'icon-chevron-down glyphicon glyphicon-chevron-down', // includes classes for Bootstrap v2 & v3
		active     : '', // applied when column is sorted
		hover      : '', // use custom css here - bootstrap class may not override it
		filterRow  : '', // filter row class
		even       : '', // odd row zebra striping
		odd        : ''  // even row zebra striping
	});
	
	
	// Search annotations management
	$("#btn-search-annotations").click(function(e){
		e.preventDefault();
		if($("#search-input").val()==""){
			$(".annotation-results").html("<p>Vous devez indiquer un terme pour la recherche.</p>");
			return false;
		}
		$(".annotation-results").html("<br/><br/>");
		$(".annotation-results").addClass("loader");
		$.ajax({
			url: urlAnnotations,
			data:{
				q: $('#search-input').val(),
				type_inter: ( ($("#mulsel4").val()==null) ? [] : $("#mulsel4").val() ).join(",")
			}
		})
		.done(function(html){
			$(".annotation-results").removeClass("loader");
			$(".annotation-results").html(html);
		})
		.fail(function() {
			$(".annotation-results").removeClass("loader");
			$(".annotation-results").html('<p class="bg-danger">Erreur de chargement</p>');
		});
	});
	
	$("#btn-filter-annotations").click(function(e){
		if($("#mulsel4").val() && $("#mulsel4").val()!=""){
			var filters = $("#mulsel4").val();
			var nb_filters = filters.length;
			$( ".searched-annot" ).each(function(index){
				var type_inter = $(this).attr("data-type-inter").split(", ");
				var found = true;
				for(var i=0;i<nb_filters;i++){
					if(type_inter.indexOf(filters[i])==-1){
						found = found && false;
					}
				}
				found ? $(this).show() : $(this).hide();
			});
		}
		else{
			$( ".searched-annot" ).each(function(j){
				$(this).show();
			});
		}
		$(".nb-annotations-found").html($('.annotation-results > div:visible').length);
	});

});
