from django.template import Library
import re

register = Library()


@register.simple_tag
def active(request, css_class, pattern, exact=True):
    """
    a simple tag to test the current path and return a given css class.
    Useful for navigation tabs
    """
    if pattern:
        if exact:
            pattern = "^%s$" % pattern.lstrip("^").rstrip("$")
     
        if re.search(pattern, request.path):
            return css_class
    return ''


@register.inclusion_tag("ldt/ldt_utils/partial/content_project_pagination.html", takes_context=True)
def build_pagination(context, nb_pages, cur_page_nb, a_class, begin_pages=2, end_pages=2, before_current_pages=2, after_current_pages=2):
    # Digg-like pagination. Adapted from http://djangosnippets.org/snippets/2199/
    nb_pages = int(nb_pages)
    cur_page_nb = int(cur_page_nb)
    #assert False, str(nb_pages) + ', ' + str(cur_page_nb)
    before = max(cur_page_nb - before_current_pages - 1, 0)
    after = cur_page_nb + after_current_pages
    
    page_range = range(nb_pages)
    #assert False, str(nb_pages) + str(page_range) 
    begin = page_range[:begin_pages]
    #assert False, str(nb_pages) + ", " + str(page_range) + ", " + str(begin)
    middle = page_range[before+1:after+1]
    end = page_range[-end_pages:]
    last_page_number = end[-1]
    #assert False, "a - cur_page_nb = " + str(cur_page_nb) + ", before = " + str(before) + ", after = " + str(after) + ", begin = " + str(begin) + ", middle = " + str(middle) + ", end = " + str(end)
    
    def collides(firstlist, secondlist):
        """ Returns true if lists collides (have same entries)
        >>> collides([1,2,3,4],[3,4,5,6,7])
        True
        >>> collides([1,2,3,4],[5,6,7])
        False
        """
        return any(item in secondlist for item in firstlist)
    
    # If middle and end has same entries, then end is what we want
    if collides(middle, end):
        end = range(max(cur_page_nb-before_current_pages, 1), last_page_number+1)
        middle = []
        
    #assert False, "0, " + str(nb_pages) + ", " + str(page_range) + ", " + str(begin)
    # If begin and middle ranges has same entries, then begin is what we want
    if collides(begin, middle):
        begin = range(0, min(cur_page_nb + after_current_pages - 1, last_page_number)+1)
        middle = []
        #assert False, "1 - cur_page_nb = " + str(cur_page_nb) + ", before = " + str(before) + ", after = " + str(after) + ", begin = " + str(begin) + ", middle = " + str(middle) + ", end = " + str(end)
        
    # If begin and end has same entries then begin is what we want
    if collides(begin, end):
        begin = range(1, last_page_number+1)
        end = []
        #assert False, "2 - " + str(nb_pages) + ", " + str(page_range) + ", " + str(begin)
        
    #assert False, str(nb_pages) + ", " + str(page_range) + ", " + str(begin)
    
    context.update({'begin' : begin,
                    'middle' : middle,
                    'end' : end,
                    'nb_pages' : nb_pages,
                    'cur_page_nb' : cur_page_nb,
                    'a_class' : a_class})
    #assert False, begin + middle + end
    return context
