from django.core.management.base import BaseCommand
from django.conf import settings
from django.contrib.sites.models import Site

class Command(BaseCommand):
    help = 'set the site domain to the right value according to the django settings'
    
    def handle(self, *args, **options):
        site = Site.objects.get(id=settings.SITE_ID)
        web_url = settings.WEB_URL
        if (web_url.startswith("http://")):
            domain_area = web_url.split("//",1)
            domain = domain_area[1]
        else:
            domain=web_url
        if site.domain!=domain:
            site.domain = domain
            site.save()
        if site.name!=domain:
            site.name=domain
            site.save()