$(document).ready(function () {

  $('.chapters .multiselect').multiselect({
    buttonText: function(options, select) {
      return $(select).attr("data-title") + ' (' + options.length + ') <b class="caret"></b>';
    },
    onChange: function(element, checked) {
      var filter_enabled = false;
      var chbs = $(".chapters input:checkbox");
      for (var i = chbs.length - 1; i >= 0; i--) {
        filter_enabled = filter_enabled || $(chbs[i]).is(":checked");
      };
      if(filter_enabled){
        $("#btn-filter-chapters").removeAttr('disabled');
      }
      else{
        $("#btn-filter-chapters").attr('disabled','disabled');
      }
    }
  });
  $('.annotations .multiselect').multiselect({
    buttonText: function(options, select) {
      return $(select).attr("data-title") + ' (' + options.length + ') <b class="caret"></b>';
    },
    buttonContainer: '<div class="btn-group width100percent" />',
    buttonClass: 'btn btn-default width100percent disabled',
    onChange: function(element, checked) {
      var filter_enabled = false;
      var chbs = $(".annotations input:checkbox");
      for (var i = chbs.length - 1; i >= 0; i--) {
        filter_enabled = filter_enabled || $(chbs[i]).is(":checked");
      };
      if(filter_enabled){
        $("#btn-filter-annotations").removeAttr('disabled');
      }
      else{
        $("#btn-filter-annotations").attr('disabled','disabled');
      }
    }
  });

  // Data 1
  var data1 = [
    {label: "Performance", value: "performance"},
    {label: "Discussion", value: "discussion"}
  ];
  $("#mulsel1").multiselect('dataprovider', data1);
  
  // Data 2 : modalités scéniques
  $.ajax({
	  url: urlMS
  })
  .done(function( data ) {
	  var o = data.objects;
	  var n = data.objects.length;
	  var data2 = [];
	  for(var i=0;i<n;i++){
		  data2.push({label: o[i].name.substr(21), value: o[i].name})
	  }
	  $("#mulsel2").multiselect('dataprovider', data2);
	  $("#mulsel2").multiselect('enable');
  });
  
  // Data 3 : Personnages
  $.ajax({
	  url: urlP
  })
  .done(function( data ) {
	  var o = data.objects;
	  var n = data.objects.length;
	  var data3 = [];
	  for(var i=0;i<n;i++){
		  data3.push({label: o[i].name.substr(12), value: o[i].name})
	  }
	  $("#mulsel3").multiselect('dataprovider', data3);
	  $("#mulsel3").multiselect('enable');
  });

  // Annotations :
  $("#mulsel4").multiselect('disable');
  $(document).on('input', "#search-input", function(){
    if($(this).val()!=""){
      $("#btn-search-annotations").removeAttr('disabled');
    }
    else{
      $("#btn-search-annotations").attr('disabled','disabled');
    }
  });

  $("#btn-search-annotations").click(function(e){
    e.preventDefault();
    var data4 = [
      {label: "Intervention MES", value: "Intervention MES"},
      {label: "Filage de la scène", value: "Filage de la scène"},
      {label: "Parole à l'acteur/actrice", value: "Parole à l'acteur/actrice"},
      {label: "Interprétation du texte", value: "Interprétation du texte"},
      {label: "Décision", value: "Décision"}
    ];
    $("#mulsel4").multiselect('dataprovider', data4);
    $("#mulsel4").multiselect('enable');
  });


});
