'''
Created on 2014-02-21

@author: tcavalie
'''
import time
from django.conf import settings
from django.views.generic import TemplateView
from itertools import groupby
from operator import itemgetter
from tagging.models import Tag, TaggedItem
from ldt.ldt_utils.models import Segment, Content


import logging
from ldt.ldt_utils.views.workspace import get_search_results
logger = logging.getLogger(__name__)



class Home(TemplateView):
    template_name = "spel_home.html"
    def get(self, request):
        context = {}
        return self.render_to_response(context)



class Spectacle(TemplateView):
    template_name = "spel_spectacle.html"
    def get(self, request):
        # Get start and end for date bounds (earliest is available only on django 1.6)
        start_date = Content.objects.all().order_by("content_creation_date")[0].content_creation_date
        end_date = Content.objects.latest("content_creation_date").content_creation_date
        context = {"start_date":start_date, "end_date":end_date }
        return self.render_to_response(context)



class ChapterRequest(TemplateView):
    
    template_name = "partial/spel_chapters.html"
    
    def get(self, request):
        # Filter content by date if necessary
        content_qs = Content.objects.all()
        start_date_param = request.GET.get("start_date", "")
        if start_date_param!="":
            content_qs = content_qs.filter(content_creation_date__gt=start_date_param)
        end_date_param = request.GET.get("end_date", "")
        if end_date_param!="":
            content_qs = content_qs.filter(content_creation_date__lt=end_date_param + " 23:59:59")
        iri_ids = content_qs.values_list("iri_id", flat=True)
        #logger.debug("iri_ids")
        #logger.debug(iri_ids)
        # Filter segment if necessary
        annot_types_param = request.GET.get("annotation_types", "")
        seg_queryset = Segment.objects.filter(iri_id__in=iri_ids).select_related('content__title')
        if annot_types_param!="":
            annot_types = annot_types_param.split(",")
            seg_queryset = seg_queryset.filter(cutting_id__in=annot_types)
        
        # First we look at modalites_sceniques and personnages tags.
        mod_scen_param = request.GET.get("modalites_sceniques", "")
        mod_scen = []
        if mod_scen_param!="":
            mod_scen = mod_scen_param.split(",")
        perso_param = request.GET.get("personnages", "")
        perso = []
        if perso_param!="":
            perso = perso_param.split(",")
        
        # Get tags from orm
        all_tags = mod_scen + perso
        tags = Tag.objects.filter(name__in=all_tags)
        # Get segments from tagged items
        s = TaggedItem.objects.get_by_model(seg_queryset, tags)
        
        #logger.debug("COUCOU")
        #logger.debug(mod_scen_param)
        #logger.debug(perso_param)
        #logger.debug(mod_scen)
        #logger.debug(perso)
        #logger.debug(tags)
        #logger.debug(s)
        
        context = {"segments": s}
        
        return self.render_to_response(context)



class AnnotationRequest(TemplateView):
    
    template_name = "partial/spel_annotations.html"
    
    def get(self, request):
        q = request.GET.get("q", "")
        page = 1
        content_list = None
        if q!="":
            field = "abstract"
            results, nb_contents, nb_segments = get_search_results(request, q, field, page, content_list)
            results = results.object_list
            type_inter_param = ""
        else:
            type_inter_param = request.GET.get("type_inter", "")
            seg_queryset = []
            results = []
            tagged_segs = []
            if type_inter_param!="":
                type_inter = [("type_inter: " + t) for t in type_inter_param.split(",")]
                tags = Tag.objects.filter(name__in=type_inter)
                # Get segments from tagged items
                tagged_segs = TaggedItem.objects.get_by_model(Segment, tags).values()
                # Prefetch all contents
                all_contents = Content.objects.filter(iri_id__in=[s['iri_id'] for s in tagged_segs])
                for iri_id, items in groupby(tagged_segs, itemgetter('iri_id')):
                    # Get good content
                    content = None
                    content_filter = filter(lambda e: e.iri_id == iri_id, all_contents)
                    if len(content_filter)>0:
                        content = content_filter[0]
                    if content is None:
                        continue
                    # Get segments
                    s = list(items)
                    results.append({ 'content': content, 'list': s })
            nb_contents = len(results)
            nb_segments = len(tagged_segs)
        
        context = {"q":q, "searched_tags": type_inter_param.split(","), "results": results, "nb_contents": nb_contents, "nb_annotations": nb_segments}
        
        return self.render_to_response(context)









    