# -*- coding: utf-8 -*-
import django

# location of patterns, url, include changes in 1.4 onwards
try:
    from django.conf.urls import patterns, url, include
except ImportError:
    from django.conf.urls.defaults import patterns, url, include


# in Django>=1.5 CustomUser models can be specified
if django.VERSION >= (1, 5):
    from django.contrib.auth import get_user_model
    from django.conf import settings
    User = get_user_model()
    AUTH_USER_MODEL  = settings.AUTH_USER_MODEL
else:
    from django.contrib.auth.models import User
    AUTH_USER_MODEL  = "auth.User"

try:
    from django.utils.crypto import get_random_string
except:
    import random
    # fallback for older versions of django (<=1.3). You shouldn't use them
    get_random_string = lambda length: ''.join([random.choice('abcdefghijklmnopqrstuvwxyz'
                                    'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789') for i in range(length)])