$(document).ready(function () {

  $('.chapters .multiselect').multiselect({
    buttonText: function(options, select) {
      return $(select).attr("data-title") + ' (' + options.length + ') <b class="caret"></b>';
    },
    onChange: function(element, checked) {
      var filter_enabled = false;
      var chbs = $(".chapters input:checkbox");
      for (var i = chbs.length - 1; i >= 0; i--) {
        filter_enabled = filter_enabled || $(chbs[i]).is(":checked");
      };
      if(filter_enabled){
        $("#btn-filter-chapters").removeAttr('disabled');
      }
      else{
        $("#btn-filter-chapters").attr('disabled','disabled');
      }
    }
  });
  $('.annotations .multiselect').multiselect({
    buttonText: function(options, select) {
      return $(select).attr("data-title") + ' (' + options.length + ') <b class="caret"></b>';
    },
    buttonContainer: '<div class="btn-group width100percent" />',
    buttonClass: 'btn btn-default width100percent disabled',
    onChange: function(element, checked) {
      var filter_enabled = false;
      var chbs = $(".annotations input:checkbox");
      for (var i = chbs.length - 1; i >= 0; i--) {
        filter_enabled = filter_enabled || $(chbs[i]).is(":checked");
      };
      if(filter_enabled){
        $("#btn-filter-annotations").removeAttr('disabled');
      }
      else{
        $("#btn-filter-annotations").attr('disabled','disabled');
      }
    }
  });


  var data1 = [
    {label: "Performance", value: "Performance"},
    {label: "Discussion", value: "Discussion"}
  ];
  $("#mulsel1").multiselect('dataprovider', data1);
  var data2 = [
    {label: "Lumière", value: "Lumière"},
    {label: "Son", value: "Son"},
    {label: "Musique", value: "Musique"},
    {label: "Décor", value: "Décor"}
  ];
  $("#mulsel2").multiselect('dataprovider', data2);
  var data3 = [
    {label: "PA", value: "Lumière"},
    {label: "PB", value: "Son"},
    {label: "PC", value: "Musique"},
    {label: "PD", value: "Décor"},
    {label: "PE", value: "Décor"}
  ];
  $("#mulsel3").multiselect('dataprovider', data3);

  // Annotations :
  $("#mulsel4").multiselect('disable');
  $(document).on('input', "#search-input", function(){
    if($(this).val()!=""){
      $("#btn-search-annotations").removeAttr('disabled');
    }
    else{
      $("#btn-search-annotations").attr('disabled','disabled');
    }
  });

  $("#btn-search-annotations").click(function(e){
    e.preventDefault();
    var data4 = [
      {label: "Intervention MES", value: "Intervention MES"},
      {label: "Filage de la scène", value: "Filage de la scène"},
      {label: "Parole à l'acteur/actrice", value: "Parole à l'acteur/actrice"},
      {label: "Interprétation du texte", value: "Interprétation du texte"},
      {label: "Décision", value: "Décision"}
    ];
    $("#mulsel4").multiselect('dataprovider', data4);
    $("#mulsel4").multiselect('enable');
  });


});
