# -*- coding: utf-8 -*-
#@PydevCodeAnalysisIgnore
import os.path
import spel
# Django settings for project.

DEBUG = True
TEMPLATE_DEBUG = DEBUG

ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.', # Add 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'oracle'.
        'NAME': '',                      # Or path to database file if using sqlite3.
        'USER': '',                      # Not used with sqlite3.
        'PASSWORD': '',                  # Not used with sqlite3.
        'HOST': '',                      # Set to empty string for localhost. Not used with sqlite3.
        'PORT': '',                      # Set to empty string for default. Not used with sqlite3.
    }
}

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'UTC'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'fr-fr'

ugettext = lambda s: s

LANGUAGES = ( 
    ('fr', ugettext('French')),
    ('en', ugettext('English')),
    ('ja', ugettext('Japanese')),
)


SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
#MEDIA_ROOT = ''

# Root of static files used by each app, generated by code or uploaded by users
#STATIC_URL = '/static/'

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
#MEDIA_URL = ''

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".

#LDT_MEDIA_PREFIX = '/ldt/'

# Make this unique, and don't share it with anybody.
SECRET_KEY = 't^lii5_z@tho$%6t&b#dm#t9nz$$ylyclxvkdiyqbl+(dnt(ma'

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
#     'django.template.loaders.eggs.Loader',
)

MIDDLEWARE_CLASSES = (
    'django.middleware.cache.UpdateCacheMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.cache.FetchFromCacheMiddleware',
    'django.middleware.gzip.GZipMiddleware',
    'ldt.ldt_utils.middleware.swfupload.SWFUploadMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    #'django.middleware.locale.LocaleMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django_openid_consumer.middleware.OpenIDMiddleware',
    'ldt.ldt_utils.middleware.userprofile.LanguageMiddleware',
    'ldt.security.middleware.SecurityMiddleware',
)

TEMPLATE_CONTEXT_PROCESSORS = ( 
    "django.core.context_processors.request",
    "django.contrib.auth.context_processors.auth",
    "django.core.context_processors.debug",
    "django.core.context_processors.i18n",
    "django.core.context_processors.media",
    "django.core.context_processors.static",
    "ldt.utils.context_processors.ldt_context",
)


ROOT_URLCONF = 'spel.urls'

TEMPLATE_DIRS = (
    # Put strings here, like "/home/html/django_templates" or "C:/www/django/templates".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
    os.path.join(os.path.basename(__file__), 'templates'), 
    os.path.join(os.path.dirname(__file__), 'templates'),  
)
    
FIXTURES_DIRS = (
    os.path.join(os.path.basename(__file__), 'fixtures'),
)

INSTALLED_APPS = (
    'django_extensions',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.admin',
    'django.contrib.staticfiles',
    'haystack',
    'tastypie',
    'guardian',
    'tagging',
    'registration',
    'oauth_provider',
    'django_openid_consumer',
    'social_auth',
    'south',
    'sorl.thumbnail',
    'ldt',
    'ldt.core',
    'ldt.security',
    'ldt.user',
    'ldt.ldt_utils',
    'ldt.text',
    'ldt.management',
    'ldt.indexation',
    'chunked_uploads',
    'spel',
)

#AUTH_PROFILE_MODULE = 'user.UserProfile'
AUTH_USER_MODEL = 'user.LdtUser'
INITIAL_CUSTOM_USER_MIGRATION = "0009_rename_auth_user_to_user_ldt_user"

DECOUPAGE_BLACKLIST = (
     "de_PPP",
)
 
ZIP_BLACKLIST = (
     "__MACOSX",
)

AUTHENTICATION_BACKENDS = (
    'social_auth.backends.twitter.TwitterBackend',
    'social_auth.backends.facebook.FacebookBackend',
#    'social_auth.backends.google.GoogleOAuthBackend',
#    'social_auth.backends.google.GoogleOAuth2Backend',
    'social_auth.backends.google.GoogleBackend',
    'social_auth.backends.yahoo.YahooBackend',
#    'social_auth.backends.contrib.linkedin.LinkedinBackend',
#    'social_auth.backends.contrib.LiveJournalBackend',
#    'social_auth.backends.contrib.orkut.OrkutBackend',
    'social_auth.backends.OpenIDBackend',
    'django.contrib.auth.backends.ModelBackend',
    'guardian.backends.ObjectPermissionBackend',
)
#SOCIAL_AUTH_IMPORT_BACKENDS = (
#    'myproy.social_auth_extra_services',
#)

ACCOUNT_ACTIVATION_DAYS = 7 

LDT_MAX_SEARCH_NUMBER = 50
LDT_JSON_DEFAULT_INDENT = 0
LDT_MAX_FRAGMENT_PER_SEARCH = 3
LDT_RESULTS_PER_PAGE = 10
LDT_MAX_CONTENTS_PER_PAGE = 10
LDT_MAX_PROJECTS_PER_PAGE = 10
LDT_FRONT_MEDIA_PER_PAGE = 9
LDT_FRONT_PROJECTS_PER_PAGE = 12
LDT_MEDIA_IN_RESULTS_PAGE = 6

OAUTH_PROVIDER_KEY_SIZE = 32
OAUTH_PROVIDER_SECRET_SIZE = 32
OAUTH_PROVIDER_VERIFIER_SIZE = 10
OAUTH_PROVIDER_CONSUMER_KEY_SIZE = 256
OAUTH_AUTHORIZE_VIEW = 'oauth_provider.views.fake_authorize_view'
OAUTH_CALLBACK_VIEW = 'oauth_provider.views.fake_callback_view'
TEST_WEBSERVER_ADDRPORT = "127.0.0.1:8888"

TWITTER_CONSUMER_KEY     = 'UxAdbOLSo4Mx3CXIwDG9Eg'
TWITTER_CONSUMER_SECRET  = '2PcWgdjnJL6Vp8srB40jeAo0fjMEtDnUwmAia6EUww'
FACEBOOK_APP_ID = '163134140411313'
FACEBOOK_API_SECRET = 'f25e0754a44f0d90d3f4d9ea961ff012'

SOCIAL_AUTH_COMPLETE_URL_NAME  = 'complete'
SOCIAL_AUTH_ASSOCIATE_URL_NAME = 'associate_complete'


AUTO_INDEX_AFTER_SAVE = True

ANONYMOUS_USER_ID = -1

WEB_VERSION = spel.get_version()

DIVISIONS_FOR_STAT_ANNOTATION = 64

FRONT_TAG_LIST = []

DEFAULT_CONTENT_ICON = "thumbnails/contents/content_default_icon.png"
DEFAULT_PROJECT_ICON = "thumbnails/projects/project_default_icon.png"
DEFAULT_USER_ICON = "thumbnails/users/user_default_icon.png"
DEFAULT_GROUP_ICON = "thumbnails/groups/group_default_icon.png"
PROFILE_IMG_MAX_SIZE = 1000000

USE_GROUP_PERMISSIONS = ['Project', 'Content', 'Media']
FORBIDDEN_STREAM_URL = "rtmp://media.iri.centrepompidou.fr/ddc_player/mp4:video/forbidden_stream.mp4?old_path="
PUBLIC_GROUP_NAME = 'everyone'
MAX_USERS_SEARCH = 20

SYNTAX = {
          '++' : 'OK',
          '--' : 'KO',
          '==' : 'REF',
          '??' : 'Q'
          }

EXTERNAL_STREAM_SRC = ['youtube.com', 'dailymotion.com', 'vimeo.com']

HAYSTACK_CONNECTIONS = {
    'default': {
        'ENGINE': 'haystack.backends.simple_backend.SimpleEngine',
    },
}
HAYSTACK_SIGNAL_PROCESSOR = 'ldt.indexation.signals.LdtSignalProcessor'

from config import *

if not "SRC_BASE_URL" in locals():
    SRC_BASE_URL = BASE_URL + __name__.split('.')[0] + '/' 

if not "LOGIN_URL" in locals():
    LOGIN_URL = SRC_BASE_URL + 'accounts/login/'
if not "LOGOUT_URL" in locals():
    LOGOUT_URL = SRC_BASE_URL + 'accounts/disconnect/'
if not "LOGIN_REDIRECT_URL" in locals():
    LOGIN_REDIRECT_URL = SRC_BASE_URL + 'ldt/'
if not "LOGOUT_REDIRECT_URL" in locals():
    LOGOUT_REDIRECT_URL = SRC_BASE_URL + 'accounts/login'
if not "PROFILE_REDIRECT_URL" in locals():
    PROFILE_REDIRECT_URL = SRC_BASE_URL + 'auth_accounts/create/profile'

if not "LOGIN_ERROR_URL" in locals():
    LOGIN_ERROR_URL = SRC_BASE_URL + 'accounts/login'

# Used in a lot of templates
if not "LDT_MEDIA_PREFIX" in locals():
    LDT_MEDIA_PREFIX = STATIC_URL + 'ldt/'
# URL that handles the media served from MEDIA_ROOT.
if not "MEDIA_URL" in locals():
    MEDIA_URL = BASE_URL + 'static/media/'

#forced settings
MAX_TAG_LENGTH = 1024
#FORCE_LOWERCASE_TAGS = True
LDT_INDEXATION_INSERT_BATCH_SIZE = 1
LDT_RESULTS_PER_PAGE = 500
    
CHAPTER_IDS = ["7-1","7-2","7-3","7-4","7-5","7-6","7-7","7-8","7-9","8-1","8-2","8-3","8-4","8-5","8-6","9-1","9-2","9-3","9-4","9-5","9-6","9-7","10-1","10-2","10-3","10-4","11-1","11-2","11-3","11-4","11-5","11-6","11-7","11-8","12-1","12-2","12-3","12-4","12-5","12-6","12-7","12-8","12-9","12-10","12-11","12-12","12-13","12-14","12-15","12-16","13-1","13-2","13-3","13-4","13-5","13-6","14-1","14-2","14-3","14-4","14-5","14-6","14-7","14-8","14-9","14-10","14-11","14-12","15-1","15-2","15-3","15-4","15-5","15-6","15-7","15-8","15-9","15-10","15-11","15-12","15-13","15-14","15-15","15-16","15-17","15-18","15-19","15-20","15-21","16-1","16-2","16-3","16-4","16-5","16-6","16-7","16-8","16-9","16-10","16-11","16-12","16-13","16-14","16-15","16-16","16-17","16-18","17-1","17-2","17-3","17-4","17-5","17-6","17-7","17-8","17-9","17-10","17-11","17-12","17-13","17-14","17-15","18-1","18-2","18-3","18-4","18-5","18-6","18-7","18-8","18-9","18-10","18-11","18-12","18-13","18-14","18-15","18-16","18-17","18-18","18-19","18-20","19-1","19-2","19-3","19-4","19-5","19-6","19-7","19-8","19-9","19-10","19-11","19-12","20-1","20-2","20-3","20-4","20-5","20-6","20-7","20-8","20-9","21-1","21-2","21-3","21-4","21-5","21-6","21-7","21-8","21-9","21-10","21-11","21-12","22-1","22-2","22-3","22-4","22-5","22-6","22-7","22-8","22-9","23-1","23-2","23-3","23-4","23-5","23-6","23-7","23-8","23-9","23-10","23-11","24-1","24-2","24-3","24-4","24-5","25-1","25-2","25-3","25-4","25-5","25-6","25-7","25-8","25-9","25-10","25-11","25-12","25-13","25-14","26-1","26-2","26-3","26-4","26-5","26-6","26-7","26-8","27-1","27-2","27-3","28-1","28-2","28-3","28-4","28-5","28-6","28-7","29-1","29-2","29-3","29-4","29-5","29-6","29-7","29-8","29-9","29-10","29-11","29-12","30-1","30-2","30-3","30-4","30-5","30-6","30-7","31-1","31-2","31-3","31-4","31-5","31-6","32-1","32-2","32-3","32-4","32-5","32-6","32-7","32-8","32-9","32-10","32-11","33-1","33-2","33-3","33-4","33-5","33-6","33-7","33-8","33-9","33-10","33-11","33-12","33-13","33-14","33-15","34-1","34-2","34-3","34-4","34-5","34-6","34-7","34-8","34-9","34-10","34-11","34-12","34-13","34-14","34-15","34-16","34-17","34-18","35-1","35-2","35-3","35-4","35-5","35-6","35-7","35-8","35-9","35-10","35-11","35-12","35-13","35-14","35-15","36-1","36-2","36-3","36-4","36-5","36-6","36-7","36-8","36-9","37-1","37-2","37-3","37-4","37-5","37-6","37-7","37-8","37-9","37-10","37-11","37-12","37-13","37-14","37-15","37-16","38-1","38-2","38-3","38-4","38-5","38-6","38-7","38-8","38-9","38-10","38-11","38-12","38-13","38-14","38-15","38-16","38-17","38-18","38-19","39-1","39-2","39-3","39-4","39-5","39-6","39-7","39-8","39-9","39-10","39-11","39-12","39-13","39-14","39-15","39-16","40-1","40-2","40-3","40-4","40-5","40-6","41-1","41-2","41-3","41-4","41-5","41-6","41-7","41-8","41-9","41-10","41-11","41-12","42-1","42-2","42-3","42-4","42-5","42-6","42-7","42-8","42-9","42-10","42-11","42-12","42-13","42-14","42-15","42-16","42-17","42-18","42-19","43-1","43-2","43-3","43-4","43-5","43-6","43-7","43-8","43-9","43-10","43-11","43-12","43-13","43-14","43-15","44-1","44-2","44-3","44-4","44-5","44-6","44-7","44-8","44-9","44-10","45-1","45-2","45-3","45-4","45-5","45-6","45-7","45-8","45-9","45-10","45-11","45-12","45-13","45-14","45-15","45-16","45-17","46-1","46-2","46-3","46-4","46-5","46-6","46-7","46-8","46-9","46-10","46-11","46-12","46-13","46-14","46-15","46-16","46-17","46-18","47-1","47-2","47-3","47-4","47-5","47-6","47-7","47-8","47-9","47-10","47-11","47-12","47-13","47-14","47-15","47-16","47-17","47-18","47-19","47-20","48-1","48-2","48-3","48-4","48-5","48-6","48-7","48-8","48-9","48-10","48-11","49-1","49-2","49-3","49-4","49-5","49-6","49-7","49-8","49-9","49-10","49-11","49-12","49-13","49-14","49-15","49-16","50-1","50-2","50-3","50-4","50-5","50-6","50-7","50-8","50-9","51-1","51-2","51-3","51-4","51-5","51-6","51-7","51-8","51-9","51-10","51-11","51-12","51-13","52-1","52-2","52-3","52-4","52-5","52-6","52-7","52-8","52-9","52-10","52-11","52-12","52-13","52-14","52-15","52-16","52-167","53-1","53-2","53-3","53-4","53-5","53-6","53-7","53-8","53-9","53-10","53-11","53-12","53-13","53-14","54-1","54-2","54-3","54-4","54-5","54-6","54-7","54-8","55-1","55-2","55-3","55-4","55-5","55-6","55-7","55-8","55-9","55-10","55-11","55-12","56-11","56-12","56-13","56-14","56-15","56-16","56-17","56-18","56-19","56-20","56-21","56-22","56-23","56-24","56-25","56-26","56-27","57-1","57-2","57-3","57-4","58-1","58-2","58-3","58-4","58-5","58-6","58-7","58-8","58-9","58-10","58-16","58-17","58-18","58-19","58-20","58-21","59-1","59-32","59-3","59-4","59-5","59-6","59-7","59-8","59-9","59-10","59-11","59-12","59-13","59-14","59-15","59-16","59-17","59-18","59-19","59-20","60-1","60-2","60-3","60-4","60-5","60-6","60-7","60-8","60-9","60-10","60-11","60-12","60-13","60-14","60-15","60-16","61-1","61-2","61-3","61-4","61-5","61-6","61-7","61-8","61-9","61-10","61-11","61-12","61-13","61-14","61-15","61-16","61-17","61-18","61-19","62-20","62-1","62-2","62-3","62-4","62-5","62-6","62-7","62-8","62-9","62-10","62-11","62-12","62-13","62-14","62-15","63-1","63-2","63-3","63-4","63-5","63-6","63-7","63-8","63-9","63-10","63-11","63-12","63-13","63-14","63-15","63-16","63-17","63-18","63-19","63-20","64-1","64-2","64-3","64-4","64-5","64-6","64-7","64-8","64-9","64-10","64-11","64-12","64-13","64-14","64-15","64-16","64-17","64-18","64-19","64-20","65-1","65-2","65-3","65-4","65-5","65-6","65-7","65-8","65-9","65-10","65-11","65-12","65-13","65-14","65-15","65-16","65-17","66-1","66-2","66-3","66-4","66-5","66-6","66-7","66-8","66-9","66-10","66-11","66-12","66-13","66-14","66-15","66-16","66-17","66-18","66-19","67-1","67-2","67-3","67-4","67-5","67-6","67-7","67-8","67-9","67-010","67-11","67-12","67-13","67-14","67-15","67-16","67-17","68-1","68-2","68-3","68-4","68-5","68-6","68-7","68-8","68-9","68-10","68-11","68-12","68-13","68-14","68-15","69-1","69-2","69-3","69-4","69-5","69-6","69-7","69-8","69-9","69-10","69-11","69-12","69-13","69-14","69-15","69-16","70-1","70-2","70-3","70-4","70-5","70-6","70-7","71-1","71-2","71-3","71-4","71-5","71-6","71-7","71-8","71-9","71-10","71-11","71-12","71-13","71-14","71-15","71-16","71-717","71-18","71-19","72-1","72-2","72-3","72-4","72-5","72-6","72-7","72-8","72-9","72-10","72-11","72-12","72-13","72-14","72-15","72-16","72-17","72-18","72-19","73-1","73-2","73-3","73-4","73-5","73-6","73-7","73-8","73-9","73-10","73-11","73-12","73-13","73-14","73-15","73-16","74-1","74-2","74-3","74-4","74-5","74-6","74-7","74-8","74-9","74-10","74-11","74-12","74-13","74-14","74-15","74-16","74-17","74-18","75-1","75-2","75-3","75-4","75-5","75-6","75-7","75-8","75-9","75-10","75-11","75-1","76-2","76-3","76-4","76-5","76-6","76-7","76-8","76-9","76-10","76-11"]
