/***

    P R O C E S S I N G . J S - 1.3.6
    a port of the Processing visualization language

    Processing.js is licensed under the MIT License, see LICENSE.
    For a list of copyright holders, please refer to AUTHORS.

    http://processingjs.org

***/

(function(B,d,o,r){var E=function(){};var q=function(){if("console" in B){return function(L){B.console.log("Processing.js: "+L)}}return E()}();var u=function(L){var M=new XMLHttpRequest;M.open("GET",L,false);if(M.overrideMimeType){M.overrideMimeType("text/plain")}M.setRequestHeader("If-Modified-Since","Fri, 01 Jan 1960 00:00:00 GMT");M.send(null);if(M.status!==200&&M.status!==0){throw"XMLHttpRequest failed, status code "+M.status}return M.responseText};var l="document" in this&&!("fake" in this.document);d.head=d.head||d.getElementsByTagName("head")[0];function A(L,M){if(L in B){return B[L]}if(typeof B[M]==="function"){return B[M]}return function(O){if(O instanceof Array){return O}if(typeof O==="number"){var N=[];N.length=O;return N}}}var e=A("Float32Array","WebGLFloatArray"),I=A("Int32Array","WebGLIntArray"),w=A("Uint16Array","WebGLUnsignedShortArray"),b=A("Uint8Array","WebGLUnsignedByteArray");var z={X:0,Y:1,Z:2,R:3,G:4,B:5,A:6,U:7,V:8,NX:9,NY:10,NZ:11,EDGE:12,SR:13,SG:14,SB:15,SA:16,SW:17,TX:18,TY:19,TZ:20,VX:21,VY:22,VZ:23,VW:24,AR:25,AG:26,AB:27,DR:3,DG:4,DB:5,DA:6,SPR:28,SPG:29,SPB:30,SHINE:31,ER:32,EG:33,EB:34,BEEN_LIT:35,VERTEX_FIELD_COUNT:36,P2D:1,JAVA2D:1,WEBGL:2,P3D:2,OPENGL:2,PDF:0,DXF:0,OTHER:0,WINDOWS:1,MAXOSX:2,LINUX:3,EPSILON:0.0001,MAX_FLOAT:3.4028235e+38,MIN_FLOAT:-3.4028235e+38,MAX_INT:2147483647,MIN_INT:-2147483648,PI:o.PI,TWO_PI:2*o.PI,HALF_PI:o.PI/2,THIRD_PI:o.PI/3,QUARTER_PI:o.PI/4,DEG_TO_RAD:o.PI/180,RAD_TO_DEG:180/o.PI,WHITESPACE:" \t\n\r\u000c\u00a0",RGB:1,ARGB:2,HSB:3,ALPHA:4,CMYK:5,TIFF:0,TARGA:1,JPEG:2,GIF:3,BLUR:11,GRAY:12,INVERT:13,OPAQUE:14,POSTERIZE:15,THRESHOLD:16,ERODE:17,DILATE:18,REPLACE:0,BLEND:1<<0,ADD:1<<1,SUBTRACT:1<<2,LIGHTEST:1<<3,DARKEST:1<<4,DIFFERENCE:1<<5,EXCLUSION:1<<6,MULTIPLY:1<<7,SCREEN:1<<8,OVERLAY:1<<9,HARD_LIGHT:1<<10,SOFT_LIGHT:1<<11,DODGE:1<<12,BURN:1<<13,ALPHA_MASK:4278190080,RED_MASK:16711680,GREEN_MASK:65280,BLUE_MASK:255,CUSTOM:0,ORTHOGRAPHIC:2,PERSPECTIVE:3,POINT:2,POINTS:2,LINE:4,LINES:4,TRIANGLE:8,TRIANGLES:9,TRIANGLE_STRIP:10,TRIANGLE_FAN:11,QUAD:16,QUADS:16,QUAD_STRIP:17,POLYGON:20,PATH:21,RECT:30,ELLIPSE:31,ARC:32,SPHERE:40,BOX:41,GROUP:0,PRIMITIVE:1,GEOMETRY:3,VERTEX:0,BEZIER_VERTEX:1,CURVE_VERTEX:2,BREAK:3,CLOSESHAPE:4,OPEN:1,CLOSE:2,CORNER:0,CORNERS:1,RADIUS:2,CENTER_RADIUS:2,CENTER:3,DIAMETER:3,CENTER_DIAMETER:3,BASELINE:0,TOP:101,BOTTOM:102,NORMAL:1,NORMALIZED:1,IMAGE:2,MODEL:4,SHAPE:5,SQUARE:"butt",ROUND:"round",PROJECT:"square",MITER:"miter",BEVEL:"bevel",AMBIENT:0,DIRECTIONAL:1,SPOT:3,BACKSPACE:8,TAB:9,ENTER:10,RETURN:13,ESC:27,DELETE:127,CODED:65535,SHIFT:16,CONTROL:17,ALT:18,CAPSLK:20,PGUP:33,PGDN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,NUMLK:144,META:157,INSERT:155,ARROW:"default",CROSS:"crosshair",HAND:"pointer",MOVE:"move",TEXT:"text",WAIT:"wait",NOCURSOR:"url('data:image/gif;base64,R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=='), auto",DISABLE_OPENGL_2X_SMOOTH:1,ENABLE_OPENGL_2X_SMOOTH:-1,ENABLE_OPENGL_4X_SMOOTH:2,ENABLE_NATIVE_FONTS:3,DISABLE_DEPTH_TEST:4,ENABLE_DEPTH_TEST:-4,ENABLE_DEPTH_SORT:5,DISABLE_DEPTH_SORT:-5,DISABLE_OPENGL_ERROR_REPORT:6,ENABLE_OPENGL_ERROR_REPORT:-6,ENABLE_ACCURATE_TEXTURES:7,DISABLE_ACCURATE_TEXTURES:-7,HINT_COUNT:10,SINCOS_LENGTH:720,PRECISIONB:15,PRECISIONF:1<<15,PREC_MAXVAL:(1<<15)-1,PREC_ALPHA_SHIFT:24-15,PREC_RED_SHIFT:16-15,NORMAL_MODE_AUTO:0,NORMAL_MODE_SHAPE:1,NORMAL_MODE_VERTEX:2,MAX_LIGHTS:8};function h(N){if(typeof N==="string"){var M=0;for(var L=0;L<N.length;++L){M=M*31+N.charCodeAt(L)&4294967295}return M}if(typeof N!=="object"){return N&4294967295}if(N.hashCode instanceof Function){return N.hashCode()}if(N.$id===r){N.$id=o.floor(o.random()*65536)-32768<<16|o.floor(o.random()*65536)}return N.$id}function p(M,L){if(M===null||L===null){return M===null&&L===null}if(typeof M==="string"){return M===L}if(typeof M!=="object"){return M===L}if(M.equals instanceof Function){return M.equals(L)}return M===L}var m=function(M){if(M.iterator instanceof Function){return M.iterator()}if(M instanceof Array){var L=-1;this.hasNext=function(){return ++L<M.length};this.next=function(){return M[L]}}else{throw"Unable to iterate: "+M}};var f=function(){function M(O){var N=0;this.hasNext=function(){return N<O.length};this.next=function(){return O[N++]};this.remove=function(){O.splice(N,1)}}function L(){var N;if(arguments.length===0){N=[]}else{if(arguments.length>0&&typeof arguments[0]!=="number"){N=arguments[0].toArray()}else{N=[];N.length=0|arguments[0]}}this.get=function(O){return N[O]};this.contains=function(O){return this.indexOf(O)>-1};this.indexOf=function(Q){for(var P=0,O=N.length;P<O;++P){if(p(Q,N[P])){return P}}return -1};this.add=function(){if(arguments.length===1){N.push(arguments[0])}else{if(arguments.length===2){var O=arguments[0];if(typeof O==="number"){if(O>=0&&O<=N.length){N.splice(O,0,arguments[1])}else{throw O+" is not a valid index"}}else{throw typeof O+" is not a number"}}else{throw"Please use the proper number of parameters."}}};this.addAll=function(P,O){var Q;if(typeof P==="number"){if(P<0||P>N.length){throw"Index out of bounds for addAll: "+P+" greater or equal than "+N.length}Q=new m(O);while(Q.hasNext()){N.splice(P++,0,Q.next())}}else{Q=new m(P);while(Q.hasNext()){N.push(Q.next())}}};this.set=function(){if(arguments.length===2){var O=arguments[0];if(typeof O==="number"){if(O>=0&&O<N.length){N.splice(O,1,arguments[1])}else{throw O+" is not a valid index."}}else{throw typeof O+" is not a number"}}else{throw"Please use the proper number of parameters."}};this.size=function(){return N.length};this.clear=function(){N.length=0};this.remove=function(O){if(typeof O==="number"){return N.splice(O,1)[0]}O=this.indexOf(O);if(O>-1){N.splice(O,1);return true}return false};this.isEmpty=function(){return !N.length};this.clone=function(){return new L(this)};this.toArray=function(){return N.slice(0)};this.iterator=function(){return new M(N)}}return L}();var v=function(){function L(){if(arguments.length===1&&arguments[0] instanceof L){return arguments[0].clone()}var U=arguments.length>0?arguments[0]:16;var V=arguments.length>1?arguments[1]:0.75;var O=[];O.length=U;var Q=0;var M=this;function S(X){var W=h(X)%O.length;return W<0?O.length+W:W}function P(){if(Q<=V*O.length){return}var Z=[];for(var Y=0;Y<O.length;++Y){if(O[Y]!==r){Z=Z.concat(O[Y])}}var aa=O.length*2;O=[];O.length=aa;for(var X=0;X<Z.length;++X){var W=S(Z[X].key);var ab=O[W];if(ab===r){O[W]=ab=[]}ab.push(Z[X])}}function N(aa,ab){var W=0;var Z=-1;var Y=false;function X(){while(!Y){++Z;if(W>=O.length){Y=true}else{if(O[W]===r||Z>=O[W].length){Z=-1;++W}else{return}}}}this.hasNext=function(){return !Y};this.next=function(){var ac=aa(O[W][Z]);X();return ac};this.remove=function(){ab(this.next());--Z};X()}function T(W,X,Y){this.clear=function(){M.clear()};this.contains=function(Z){return X(Z)};this.containsAll=function(aa){var Z=aa.iterator();while(Z.hasNext()){if(!this.contains(Z.next())){return false}}return true};this.isEmpty=function(){return M.isEmpty()};this.iterator=function(){return new N(W,Y)};this.remove=function(Z){if(this.contains(Z)){Y(Z);return true}return false};this.removeAll=function(ac){var Z=ac.iterator();var ab=false;while(Z.hasNext()){var aa=Z.next();if(this.contains(aa)){Y(aa);ab=true}}return true};this.retainAll=function(ad){var ab=this.iterator();var aa=[];while(ab.hasNext()){var ac=ab.next();if(!ad.contains(ac)){aa.push(ac)}}for(var Z=0;Z<aa.length;++Z){Y(aa[Z])}return aa.length>0};this.size=function(){return M.size()};this.toArray=function(){var Z=[];var aa=this.iterator();while(aa.hasNext()){Z.push(aa.next())}return Z}}function R(W){this._isIn=function(X){return X===M&&W.removed===r};this.equals=function(X){return p(W.key,X.getKey())};this.getKey=function(){return W.key};this.getValue=function(){return W.value};this.hashCode=function(X){return h(W.key)};this.setValue=function(Y){var X=W.value;W.value=Y;return X}}this.clear=function(){Q=0;O=[];O.length=U};this.clone=function(){var W=new L;W.putAll(this);return W};this.containsKey=function(Y){var W=S(Y);var Z=O[W];if(Z===r){return false}for(var X=0;X<Z.length;++X){if(p(Z[X].key,Y)){return true}}return false};this.containsValue=function(Y){for(var X=0;X<O.length;++X){var Z=O[X];if(Z===r){continue}for(var W=0;W<Z.length;++W){if(p(Z[W].value,Y)){return true}}}return false};this.entrySet=function(){return new T(function(W){return new R(W)},function(W){return W instanceof R&&W._isIn(M)},function(W){return M.remove(W.getKey())})};this.get=function(Y){var W=S(Y);var Z=O[W];if(Z===r){return null}for(var X=0;X<Z.length;++X){if(p(Z[X].key,Y)){return Z[X].value}}return null};this.isEmpty=function(){return Q===0};this.keySet=function(){return new T(function(W){return W.key},function(W){return M.containsKey(W)},function(W){return M.remove(W)})};this.values=function(){return new T(function(W){return W.value},function(W){return M.containsValue(W)},function(W){return M.removeByValue(W)})};this.put=function(Y,aa){var W=S(Y);var ab=O[W];if(ab===r){++Q;O[W]=[{key:Y,value:aa}];P();return null}for(var X=0;X<ab.length;++X){if(p(ab[X].key,Y)){var Z=ab[X].value;ab[X].value=aa;return Z}}++Q;ab.push({key:Y,value:aa});P();return null};this.putAll=function(W){var X=W.entrySet().iterator();while(X.hasNext()){var Y=X.next();this.put(Y.getKey(),Y.getValue())}};this.remove=function(Y){var W=S(Y);var aa=O[W];if(aa===r){return null}for(var X=0;X<aa.length;++X){if(p(aa[X].key,Y)){--Q;var Z=aa[X].value;aa[X].removed=true;if(aa.length>1){aa.splice(X,1)}else{O[W]=r}return Z}}return null};this.removeByValue=function(Y){var aa,X,W,Z;for(aa in O){if(O.hasOwnProperty(aa)){for(X=0,W=O[aa].length;X<W;X++){Z=O[aa][X];if(Z.value===Y){O[aa].splice(X,1);return true}}}}return false};this.size=function(){return Q}}return L}();var y=function(){function L(O,Q,P){this.x=O||0;this.y=Q||0;this.z=P||0}L.dist=function(P,O){return P.dist(O)};L.dot=function(P,O){return P.dot(O)};L.cross=function(P,O){return P.cross(O)};L.angleBetween=function(P,O){return o.acos(P.dot(O)/(P.mag()*O.mag()))};L.prototype={set:function(O,Q,P){if(arguments.length===1){this.set(O.x||O[0]||0,O.y||O[1]||0,O.z||O[2]||0)}else{this.x=O;this.y=Q;this.z=P}},get:function(){return new L(this.x,this.y,this.z)},mag:function(){var O=this.x,Q=this.y,P=this.z;return o.sqrt(O*O+Q*Q+P*P)},add:function(O,Q,P){if(arguments.length===1){this.x+=O.x;this.y+=O.y;this.z+=O.z}else{this.x+=O;this.y+=Q;this.z+=P}},sub:function(O,Q,P){if(arguments.length===1){this.x-=O.x;this.y-=O.y;this.z-=O.z}else{this.x-=O;this.y-=Q;this.z-=P}},mult:function(O){if(typeof O==="number"){this.x*=O;this.y*=O;this.z*=O}else{this.x*=O.x;this.y*=O.y;this.z*=O.z}},div:function(O){if(typeof O==="number"){this.x/=O;this.y/=O;this.z/=O}else{this.x/=O.x;this.y/=O.y;this.z/=O.z}},dist:function(R){var Q=this.x-R.x,P=this.y-R.y,O=this.z-R.z;return o.sqrt(Q*Q+P*P+O*O)},dot:function(O,Q,P){if(arguments.length===1){return this.x*O.x+this.y*O.y+this.z*O.z}return this.x*O+this.y*Q+this.z*P},cross:function(P){var O=this.x,R=this.y,Q=this.z;return new L(R*P.z-P.y*Q,Q*P.x-P.z*O,O*P.y-P.x*R)},normalize:function(){var O=this.mag();if(O>0){this.div(O)}},limit:function(O){if(this.mag()>O){this.normalize();this.mult(O)}},heading2D:function(){return -o.atan2(-this.y,this.x)},toString:function(){return"["+this.x+", "+this.y+", "+this.z+"]"},array:function(){return[this.x,this.y,this.z]}};function M(O){return function(R,Q){var P=R.get();P[O](Q);return P}}for(var N in L.prototype){if(L.prototype.hasOwnProperty(N)&&!L.hasOwnProperty(N)){L[N]=M(N)}}return L}();function K(){}K.prototype=z;var g=new K;g.ArrayList=f;g.HashMap=v;g.PVector=y;g.ObjectIterator=m;g.PConstants=z;g.defineProperty=function(M,L,N){if("defineProperty" in Object){Object.defineProperty(M,L,N)}else{if(N.hasOwnProperty("get")){M.__defineGetter__(L,N.get)}if(N.hasOwnProperty("set")){M.__defineSetter__(L,N.set)}}};function i(O,N){function P(Q){g.defineProperty(O,Q,{get:function(){return N[Q]},set:function(R){N[Q]=R},enumerable:true})}var M=[];for(var L in N){if(typeof N[L]==="function"){if(!O.hasOwnProperty(L)){O[L]=N[L]}}else{if(L.charAt(0)!=="$"&&!(L in O)){M.push(L)}}}while(M.length>0){P(M.shift())}}g.extendClassChain=function(M){var N=[M];for(var L=M.$upcast;L;L=L.$upcast){i(L,M);N.push(L);M=L}while(N.length>0){N.pop().$self=M}};g.extendStaticMembers=function(L,M){i(L,M)};g.extendInterfaceMembers=function(L,M){i(L,M)};g.addMethod=function(O,N,Q,P){if(O[N]){var M=Q.length,L=O[N];O[N]=function(){if(arguments.length===M){return Q.apply(this,arguments)}return L.apply(this,arguments)}}else{O[N]=Q}};g.createJavaArray=function(P,Q){var M=null;if(typeof Q[0]==="number"){var L=0|Q[0];if(Q.length<=1){M=[];M.length=L;for(var O=0;O<L;++O){M[O]=0}}else{M=[];var R=Q.slice(1);for(var N=0;N<L;++N){M.push(g.createJavaArray(P,R))}}}return M};var C={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"};(function(M){var P=("open() createOutput() createInput() BufferedReader selectFolder() dataPath() createWriter() selectOutput() beginRecord() saveStream() endRecord() selectInput() saveBytes() createReader() beginRaw() endRaw() PrintWriter delay()").split(" "),O=P.length,L,Q;function N(R){return function(){throw"Processing.js does not support "+R+"."}}while(O--){L=P[O];Q=L.replace("()","");M[Q]=N(L)}})(g);g.defineProperty(g,"screenWidth",{get:function(){return B.innerWidth}});g.defineProperty(g,"screenHeight",{get:function(){return B.innerHeight}});var k=[];var H={};var J=function(L){k.splice(H[L],1);delete H[L]};var a=function(L){if(L.externals.canvas.id===r||!L.externals.canvas.id.length){L.externals.canvas.id="__processing"+k.length}H[L.externals.canvas.id]=k.length;k.push(L)};function n(V){var O=250,ac=V.size/O,L=d.createElement("canvas");L.width=2*O;L.height=2*O;L.style.opacity=0;var U=V.getCSSDefinition(O+"px","normal"),W=L.getContext("2d");W.font=U;V.context2d=W;var aa="dbflkhyjqpg";L.width=W.measureText(aa).width;W.font=U;var R=d.createElement("div");R.style.position="absolute";R.style.opacity=0;R.style.fontFamily='"'+V.name+'"';R.style.fontSize=O+"px";R.innerHTML=aa+"<br/>"+aa;d.body.appendChild(R);var S=L.width,Z=L.height,T=Z/2;W.fillStyle="white";W.fillRect(0,0,S,Z);W.fillStyle="black";W.fillText(aa,0,T);var N=W.getImageData(0,0,S,Z).data;var X=0,Q=S*4,Y=N.length;while(++X<Y&&N[X]===255){E()}var P=o.round(X/Q);X=Y-1;while(--X>0&&N[X]===255){E()}var ab=o.round(X/Q);V.ascent=ac*(T-P);V.descent=ac*(ab-T);if(d.defaultView.getComputedStyle){var M=d.defaultView.getComputedStyle(R,null).getPropertyValue("height");M=ac*M.replace("px","");if(M>=V.size*2){V.leading=o.round(M/2)}}d.body.removeChild(R)}function F(L,M){if(L===r){L=""}this.name=L;if(M===r){M=0}this.size=M;this.glyph=false;this.ascent=0;this.descent=0;this.leading=1.2*M;var P=L.indexOf(" Italic Bold");if(P!==-1){L=L.substring(0,P)}this.style="normal";var O=L.indexOf(" Italic");if(O!==-1){L=L.substring(0,O);this.style="italic"}this.weight="normal";var N=L.indexOf(" Bold");if(N!==-1){L=L.substring(0,N);this.weight="bold"}this.family="sans-serif";if(L!==r){switch(L){case"sans-serif":case"serif":case"monospace":case"fantasy":case"cursive":this.family=L;break;default:this.family='"'+L+'", sans-serif';break}}this.context2d=null;n(this);this.css=this.getCSSDefinition();this.context2d.font=this.css}F.prototype.getCSSDefinition=function(N,L){if(N===r){N=this.size+"px"}if(L===r){L=this.leading+"px"}var M=[this.style,"normal",this.weight,N+"/"+L,this.family];return M.join(" ")};F.prototype.measureTextWidth=function(L){return this.context2d.measureText(L).width};F.PFontCache={};F.get=function(N,O){var M=F.PFontCache;var L=N+"/"+O;if(!M[L]){M[L]=new F(N,O)}return M[L]};F.list=function(){return["sans-serif","serif","monospace","fantasy","cursive"]};F.preloading={template:{},initialized:false,initialize:function(){var N=function(){var P="#E3KAI2wAgT1MvMg7Eo3VmNtYX7ABi3CxnbHlm7Abw3kaGVhZ7ACs3OGhoZWE7A53CRobXR47AY3AGbG9jYQ7G03Bm1heH7ABC3CBuYW1l7Ae3AgcG9zd7AI3AE#B3AQ2kgTY18PPPUACwAg3ALSRoo3#yld0xg32QAB77#E777773B#E3C#I#Q77773E#Q7777777772CMAIw7AB77732B#M#Q3wAB#g3B#E#E2BB//82BB////w#B7#gAEg3E77x2B32B#E#Q#MTcBAQ32gAe#M#QQJ#E32M#QQJ#I#g32Q77#";var O=function(Q){return"AAAAAAAA".substr(~~Q?7-Q:6)};return P.replace(/[#237]/g,O)};var L=d.createElement("style");L.setAttribute("type","text/css");L.innerHTML='@font-face {\n  font-family: "PjsEmptyFont";\n  src: url(\'data:application/x-font-ttf;base64,'+N()+"')\n       format('truetype');\n}";d.head.appendChild(L);var M=d.createElement("span");M.style.cssText='position: absolute; top: 0; left: 0; opacity: 0; font-family: "PjsEmptyFont", fantasy;';M.innerHTML="AAAAAAAA";d.body.appendChild(M);this.template=M;this.initialized=true},getElementWidth:function(L){return d.defaultView.getComputedStyle(L,"").getPropertyValue("width")},timeAttempted:0,pending:function(P){if(!this.initialized){this.initialize()}var N,L,O=this.getElementWidth(this.template);for(var M=0;M<this.fontList.length;M++){N=this.fontList[M];L=this.getElementWidth(N);if(this.timeAttempted<4000&&L===O){this.timeAttempted+=P;return true}else{d.body.removeChild(N);this.fontList.splice(M--,1);this.timeAttempted=0}}if(this.fontList.length===0){return false}return true},fontList:[],addedList:{},add:function(L){if(!this.initialized){this.initialize()}var P=typeof L==="object"?L.fontFace:L,O=typeof L==="object"?L.url:L;if(this.addedList[P]){return}var N=d.createElement("style");N.setAttribute("type","text/css");N.innerHTML="@font-face{\n  font-family: '"+P+"';\n  src:  url('"+O+"');\n}\n";d.head.appendChild(N);this.addedList[P]=true;var M=d.createElement("span");M.style.cssText="position: absolute; top: 0; left: 0; opacity: 0;";M.style.fontFamily='"'+P+'", "PjsEmptyFont", fantasy';M.innerHTML="AAAAAAAA";d.body.appendChild(M);this.fontList.push(M)}};g.PFont=F;var D=this.Processing=function(ba,a6){if(!(this instanceof D)){throw"called Processing constructor as if it were a function: missing 'new'."}var ac,cU=ba===r&&a6===r;if(cU){ac=d.createElement("canvas")}else{ac=typeof ba==="string"?d.getElementById(ba):ba}if(!(ac instanceof HTMLCanvasElement)){throw"called Processing constructor without passing canvas element reference or id."}function dt(d7){D.debug("Unimplemented - "+d7)}var cV=this;cV.externals={canvas:ac,context:r,sketch:r};cV.name="Processing.js Instance";cV.use3DContext=false;cV.focused=false;cV.breakShape=false;cV.glyphTable={};cV.pmouseX=0;cV.pmouseY=0;cV.mouseX=0;cV.mouseY=0;cV.mouseButton=0;cV.mouseScroll=0;cV.mouseClicked=r;cV.mouseDragged=r;cV.mouseMoved=r;cV.mousePressed=r;cV.mouseReleased=r;cV.mouseScrolled=r;cV.mouseOver=r;cV.mouseOut=r;cV.touchStart=r;cV.touchEnd=r;cV.touchMove=r;cV.touchCancel=r;cV.key=r;cV.keyCode=r;cV.keyPressed=E;cV.keyReleased=E;cV.keyTyped=E;cV.draw=r;cV.setup=r;cV.__mousePressed=false;cV.__keyPressed=false;cV.__frameRate=60;cV.frameCount=0;cV.width=100;cV.height=100;var d4,cP,dU,bA=true,aF=true,bl=[1,1,1,1],aX=4294967295,ap=true,cd=true,cZ=[0,0,0,1],cu=4278190080,b2=true,dS=1,aw=false,dK=false,aB=true,b3=0,bI=0,cM=3,a4=0,a3=0,a2=0,aY=0,dQ=60,ay=1000/dQ,X="default",cj=ac.style.cursor,dN=20,ci=0,d2=[],aH=0,O=20,cL=false,a0=-3355444,cx=20,bR=255,bG=255,bF=255,bD=255,cY=false,aI=false,dJ=0,d1=0,cX=1,bb=null,bt=null,a1=false,dm=Date.now(),dq=dm,N=0,cD,c2,aN,aJ,bw,cc,S,dz={attributes:{},locations:{}},du,dM,bQ,bd,cI,di,aA,b1,bc,b7,ar,aE,bz,av,ae,c6,bP,cr={width:0,height:0},d0=2,dP=false,cG,aa,P,L=37,c0=0,cH=4,W="Arial",dW=12,aZ=9,dx=2,d3=14,U=F.get(W,dW),ai,cm=null,dR=false,dZ,bY=1000,af=[],dE=null,dT=[16,17,18,20,33,34,35,36,37,38,39,40,144,155,112,113,114,115,116,117,118,119,120,121,122,123,157];var ab,dl,aR,bV;if(d.defaultView&&d.defaultView.getComputedStyle){ab=parseInt(d.defaultView.getComputedStyle(ac,null)["paddingLeft"],10)||0;dl=parseInt(d.defaultView.getComputedStyle(ac,null)["paddingTop"],10)||0;aR=parseInt(d.defaultView.getComputedStyle(ac,null)["borderLeftWidth"],10)||0;bV=parseInt(d.defaultView.getComputedStyle(ac,null)["borderTopWidth"],10)||0}var dH=0;var bJ=0,bK=0,bq=[],bp=[],bo=[],ag=new e(720),bi=new e(720),cE,cz;var bT,cg,dF,aQ,al,c9,Z,da,ao=false,ch=false,cJ=60*(o.PI/180),dj=cV.width/2,dh=cV.height/2,dg=dh/o.tan(cJ/2),aW=dg/10,au=dg*10,b4=cV.width/cV.height;var a7=[],ca=[],c1=0,dL=false,Y=false,dr=true;var Q=0;var bj=[];var df=new e([0.5,0.5,-0.5,0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,0.5,-0.5,0.5,0.5,-0.5,0.5,0.5,0.5,-0.5,0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,0.5,-0.5,0.5,0.5,0.5,0.5,0.5,0.5,-0.5,0.5,0.5,0.5,0.5,-0.5,0.5,0.5,-0.5,0.5,0.5,-0.5,-0.5,0.5,0.5,-0.5,0.5,-0.5,-0.5,0.5,-0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,-0.5,0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,0.5,-0.5,0.5,0.5,-0.5,0.5,0.5,-0.5,0.5,-0.5,-0.5,-0.5,-0.5,0.5,0.5,0.5,0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,0.5,0.5,0.5,0.5]);var bE=new e([0.5,0.5,0.5,0.5,-0.5,0.5,0.5,0.5,-0.5,0.5,-0.5,-0.5,-0.5,0.5,-0.5,-0.5,-0.5,-0.5,-0.5,0.5,0.5,-0.5,-0.5,0.5,0.5,0.5,0.5,0.5,0.5,-0.5,0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,0.5,-0.5,0.5,0.5,0.5,0.5,0.5,0.5,-0.5,0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,0.5,-0.5,0.5]);var de=new e([0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0]);var aj=new e([0,0,0,0,1,0,1,1,0,1,0,0]);var ah=new e([0,0,1,0,0,1,0,0,1,0,0,1]);var bS="varying vec4 frontColor;attribute vec3 aVertex;attribute vec4 aColor;uniform mat4 uView;uniform mat4 uProjection;uniform float pointSize;void main(void) {  frontColor = aColor;  gl_PointSize = pointSize;  gl_Position = uProjection * uView * vec4(aVertex, 1.0);}";var bf="#ifdef GL_ES\nprecision highp float;\n#endif\nvarying vec4 frontColor;void main(void){  gl_FragColor = frontColor;}";var ad="varying vec4 frontColor;attribute vec3 Vertex;attribute vec2 aTextureCoord;uniform vec4 color;uniform mat4 model;uniform mat4 view;uniform mat4 projection;uniform float pointSize;varying vec2 vTextureCoord;void main(void) {  gl_PointSize = pointSize;  frontColor = color;  gl_Position = projection * view * model * vec4(Vertex, 1.0);  vTextureCoord = aTextureCoord;}";var bX="#ifdef GL_ES\nprecision highp float;\n#endif\nvarying vec4 frontColor;varying vec2 vTextureCoord;uniform sampler2D uSampler;uniform int picktype;void main(void){  if(picktype == 0){    gl_FragColor = frontColor;  }  else if(picktype == 1){    float alpha = texture2D(uSampler, vTextureCoord).a;    gl_FragColor = vec4(frontColor.rgb*alpha, alpha);\n  }}";var bx=/Windows/.test(navigator.userAgent);var d5="varying vec4 frontColor;attribute vec3 Vertex;attribute vec3 Normal;attribute vec4 aColor;attribute vec2 aTexture;varying   vec2 vTexture;uniform vec4 color;uniform bool usingMat;uniform vec3 specular;uniform vec3 mat_emissive;uniform vec3 mat_ambient;uniform vec3 mat_specular;uniform float shininess;uniform mat4 model;uniform mat4 view;uniform mat4 projection;uniform mat4 normalTransform;uniform int lightCount;uniform vec3 falloff;struct Light {  int type;  vec3 color;  vec3 position;  vec3 direction;  float angle;  vec3 halfVector;  float concentration;};uniform Light lights0;uniform Light lights1;uniform Light lights2;uniform Light lights3;uniform Light lights4;uniform Light lights5;uniform Light lights6;uniform Light lights7;Light getLight(int index){  if(index == 0) return lights0;  if(index == 1) return lights1;  if(index == 2) return lights2;  if(index == 3) return lights3;  if(index == 4) return lights4;  if(index == 5) return lights5;  if(index == 6) return lights6;  return lights7;}void AmbientLight( inout vec3 totalAmbient, in vec3 ecPos, in Light light ) {  float d = length( light.position - ecPos );  float attenuation = 1.0 / ( falloff[0] + ( falloff[1] * d ) + ( falloff[2] * d * d ));  totalAmbient += light.color * attenuation;}void DirectionalLight( inout vec3 col, inout vec3 spec, in vec3 vertNormal, in vec3 ecPos, in Light light ) {  float powerfactor = 0.0;  float nDotVP = max(0.0, dot( vertNormal, normalize(-light.position) ));  float nDotVH = max(0.0, dot( vertNormal, normalize(-light.position-normalize(ecPos) )));  if( nDotVP != 0.0 ){    powerfactor = pow( nDotVH, shininess );  }  col += light.color * nDotVP;  spec += specular * powerfactor;}void PointLight( inout vec3 col, inout vec3 spec, in vec3 vertNormal, in vec3 ecPos, in Light light ) {  float powerfactor;   vec3 VP = light.position - ecPos;  float d = length( VP );   VP = normalize( VP );  float attenuation = 1.0 / ( falloff[0] + ( falloff[1] * d ) + ( falloff[2] * d * d ));  float nDotVP = max( 0.0, dot( vertNormal, VP ));  vec3 halfVector = normalize( VP - normalize(ecPos) );  float nDotHV = max( 0.0, dot( vertNormal, halfVector ));  if( nDotVP == 0.0) {    powerfactor = 0.0;  }  else{    powerfactor = pow( nDotHV, shininess );  }  spec += specular * powerfactor * attenuation;  col += light.color * nDotVP * attenuation;}void SpotLight( inout vec3 col, inout vec3 spec, in vec3 vertNormal, in vec3 ecPos, in Light light ) {  float spotAttenuation;  float powerfactor;  vec3 VP = light.position - ecPos;   vec3 ldir = normalize( -light.direction );  float d = length( VP );  VP = normalize( VP );  float attenuation = 1.0 / ( falloff[0] + ( falloff[1] * d ) + ( falloff[2] * d * d ) );  float spotDot = dot( VP, ldir );"+(bx?"  spotAttenuation = 1.0; ":"  if( spotDot > cos( light.angle ) ) {    spotAttenuation = pow( spotDot, light.concentration );  }  else{    spotAttenuation = 0.0;  }  attenuation *= spotAttenuation;")+"  float nDotVP = max( 0.0, dot( vertNormal, VP ));  vec3 halfVector = normalize( VP - normalize(ecPos) );  float nDotHV = max( 0.0, dot( vertNormal, halfVector ));  if( nDotVP == 0.0 ) {    powerfactor = 0.0;  }  else {    powerfactor = pow( nDotHV, shininess );  }  spec += specular * powerfactor * attenuation;  col += light.color * nDotVP * attenuation;}void main(void) {  vec3 finalAmbient = vec3( 0.0, 0.0, 0.0 );  vec3 finalDiffuse = vec3( 0.0, 0.0, 0.0 );  vec3 finalSpecular = vec3( 0.0, 0.0, 0.0 );  vec4 col = color;  if(color[0] == -1.0){    col = aColor;  }  vec3 norm = normalize(vec3( normalTransform * vec4( Normal, 0.0 ) ));  vec4 ecPos4 = view * model * vec4(Vertex,1.0);  vec3 ecPos = (vec3(ecPos4))/ecPos4.w;  if( lightCount == 0 ) {    frontColor = col + vec4(mat_specular,1.0);  }  else {    for( int i = 0; i < 8; i++ ) {      Light l = getLight(i);      if( i >= lightCount ){        break;      }      if( l.type == 0 ) {        AmbientLight( finalAmbient, ecPos, l );      }      else if( l.type == 1 ) {        DirectionalLight( finalDiffuse, finalSpecular, norm, ecPos, l );      }      else if( l.type == 2 ) {        PointLight( finalDiffuse, finalSpecular, norm, ecPos, l );      }      else {        SpotLight( finalDiffuse, finalSpecular, norm, ecPos, l );      }    }   if( usingMat == false ) {     frontColor = vec4(       vec3(col) * finalAmbient +       vec3(col) * finalDiffuse +       vec3(col) * finalSpecular,       col[3] );   }   else{     frontColor = vec4(        mat_emissive +        (vec3(col) * mat_ambient * finalAmbient) +        (vec3(col) * finalDiffuse) +        (mat_specular * finalSpecular),        col[3] );    }  }  vTexture.xy = aTexture.xy;  gl_Position = projection * view * model * vec4( Vertex, 1.0 );}";var bH="#ifdef GL_ES\nprecision highp float;\n#endif\nvarying vec4 frontColor;uniform sampler2D sampler;uniform bool usingTexture;varying vec2 vTexture;void main(void){  if(usingTexture){    gl_FragColor = vec4(texture2D(sampler, vTexture.xy)) * frontColor;  }  else{    gl_FragColor = frontColor;  }}";function dY(d9,d8,eb,ea){var d7=dz.locations[d9];if(d7===r){d7=d4.getUniformLocation(d8,eb);dz.locations[d9]=d7}if(d7!==null){if(ea.length===4){d4.uniform4fv(d7,ea)}else{if(ea.length===3){d4.uniform3fv(d7,ea)}else{if(ea.length===2){d4.uniform2fv(d7,ea)}else{d4.uniform1f(d7,ea)}}}}}function dV(d9,d8,eb,ea){var d7=dz.locations[d9];if(d7===r){d7=d4.getUniformLocation(d8,eb);dz.locations[d9]=d7}if(d7!==null){if(ea.length===4){d4.uniform4iv(d7,ea)}else{if(ea.length===3){d4.uniform3iv(d7,ea)}else{if(ea.length===2){d4.uniform2iv(d7,ea)}else{d4.uniform1i(d7,ea)}}}}}function a5(eb,d9,ec,ea,d8){var d7=dz.locations[eb];if(d7===r){d7=d4.getUniformLocation(d9,ec);dz.locations[eb]=d7}if(d7!==-1){if(d8.length===16){d4.uniformMatrix4fv(d7,ea,d8)}else{if(d8.length===9){d4.uniformMatrix3fv(d7,ea,d8)}else{d4.uniformMatrix2fv(d7,ea,d8)}}}}function db(eb,d9,ec,d8,ea){var d7=dz.attributes[eb];if(d7===r){d7=d4.getAttribLocation(d9,ec);dz.attributes[eb]=d7}if(d7!==-1){d4.bindBuffer(d4.ARRAY_BUFFER,ea);d4.vertexAttribPointer(d7,d8,d4.FLOAT,false,0,0);d4.enableVertexAttribArray(d7)}}function cf(d9,d8,ea){var d7=dz.attributes[d9];if(d7===r){d7=d4.getAttribLocation(d8,ea);dz.attributes[d9]=d7}if(d7!==-1){d4.disableVertexAttribArray(d7)}}var bC=function(d9,eb,d8){var ec=d9.createShader(d9.VERTEX_SHADER);d9.shaderSource(ec,eb);d9.compileShader(ec);if(!d9.getShaderParameter(ec,d9.COMPILE_STATUS)){throw d9.getShaderInfoLog(ec)}var ea=d9.createShader(d9.FRAGMENT_SHADER);d9.shaderSource(ea,d8);d9.compileShader(ea);if(!d9.getShaderParameter(ea,d9.COMPILE_STATUS)){throw d9.getShaderInfoLog(ea)}var d7=d9.createProgram();d9.attachShader(d7,ec);d9.attachShader(d7,ea);d9.linkProgram(d7);if(!d9.getProgramParameter(d7,d9.LINK_STATUS)){throw"Error linking shaders."}return d7};var aV=function(d7,eb,d8,ea,d9){return{x:d7,y:eb,w:d8,h:ea}};var bh=aV;var b0=function(d7,eb,d8,ea,d9){return{x:d7,y:eb,w:d9?d8:d8-d7,h:d9?ea:ea-eb}};var aL=function(d7,eb,d8,ea,d9){return{x:d7-d8/2,y:eb-ea/2,w:d8,h:ea}};var dp=function(){};var bO=function(){};var by=function(){};var b9=function(){};bO.prototype=new dp;bO.prototype.constructor=bO;by.prototype=new dp;by.prototype.constructor=by;b9.prototype=new dp;b9.prototype.constructor=b9;dp.prototype.a3DOnlyFunction=E;var ck={};var bN=cV.Character=function(d7){if(typeof d7==="string"&&d7.length===1){this.code=d7.charCodeAt(0)}else{if(typeof d7==="number"){this.code=d7}else{if(d7 instanceof bN){this.code=d7}else{this.code=NaN}}}return ck[this.code]===r?ck[this.code]=this:ck[this.code]};bN.prototype.toString=function(){return String.fromCharCode(this.code)};bN.prototype.valueOf=function(){return this.code};var M=cV.PShape=function(d7){this.family=d7||0;this.visible=true;this.style=true;this.children=[];this.nameTable=[];this.params=[];this.name="";this.image=null;this.matrix=null;this.kind=null;this.close=null;this.width=null;this.height=null;this.parent=null};M.prototype={isVisible:function(){return this.visible},setVisible:function(d7){this.visible=d7},disableStyle:function(){this.style=false;for(var d8=0,d7=this.children.length;d8<d7;d8++){this.children[d8].disableStyle()}},enableStyle:function(){this.style=true;for(var d8=0,d7=this.children.length;d8<d7;d8++){this.children[d8].enableStyle()}},getFamily:function(){return this.family},getWidth:function(){return this.width},getHeight:function(){return this.height},setName:function(d7){this.name=d7},getName:function(){return this.name},draw:function(){if(this.visible){this.pre();this.drawImpl();this.post()}},drawImpl:function(){if(this.family===0){this.drawGroup()}else{if(this.family===1){this.drawPrimitive()}else{if(this.family===3){this.drawGeometry()}else{if(this.family===21){this.drawPath()}}}}},drawPath:function(){var d9,d8;if(this.vertices.length===0){return}cV.beginShape();if(this.vertexCodes.length===0){if(this.vertices[0].length===2){for(d9=0,d8=this.vertices.length;d9<d8;d9++){cV.vertex(this.vertices[d9][0],this.vertices[d9][1])}}else{for(d9=0,d8=this.vertices.length;d9<d8;d9++){cV.vertex(this.vertices[d9][0],this.vertices[d9][1],this.vertices[d9][2])}}}else{var d7=0;if(this.vertices[0].length===2){for(d9=0,d8=this.vertexCodes.length;d9<d8;d9++){if(this.vertexCodes[d9]===0){cV.vertex(this.vertices[d7][0],this.vertices[d7][1]);if(this.vertices[d7]["moveTo"]===true){a7[a7.length-1]["moveTo"]=true}else{if(this.vertices[d7]["moveTo"]===false){a7[a7.length-1]["moveTo"]=false}}cV.breakShape=false;d7++}else{if(this.vertexCodes[d9]===1){cV.bezierVertex(this.vertices[d7+0][0],this.vertices[d7+0][1],this.vertices[d7+1][0],this.vertices[d7+1][1],this.vertices[d7+2][0],this.vertices[d7+2][1]);d7+=3}else{if(this.vertexCodes[d9]===2){cV.curveVertex(this.vertices[d7][0],this.vertices[d7][1]);d7++}else{if(this.vertexCodes[d9]===3){cV.breakShape=true}}}}}}else{for(d9=0,d8=this.vertexCodes.length;d9<d8;d9++){if(this.vertexCodes[d9]===0){cV.vertex(this.vertices[d7][0],this.vertices[d7][1],this.vertices[d7][2]);if(this.vertices[d7]["moveTo"]===true){a7[a7.length-1]["moveTo"]=true}else{if(this.vertices[d7]["moveTo"]===false){a7[a7.length-1]["moveTo"]=false}}cV.breakShape=false}else{if(this.vertexCodes[d9]===1){cV.bezierVertex(this.vertices[d7+0][0],this.vertices[d7+0][1],this.vertices[d7+0][2],this.vertices[d7+1][0],this.vertices[d7+1][1],this.vertices[d7+1][2],this.vertices[d7+2][0],this.vertices[d7+2][1],this.vertices[d7+2][2]);d7+=3}else{if(this.vertexCodes[d9]===2){cV.curveVertex(this.vertices[d7][0],this.vertices[d7][1],this.vertices[d7][2]);d7++}else{if(this.vertexCodes[d9]===3){cV.breakShape=true}}}}}}}cV.endShape(this.close?2:1)},drawGeometry:function(){var d9,d8;cV.beginShape(this.kind);if(this.style){for(d9=0,d8=this.vertices.length;d9<d8;d9++){cV.vertex(this.vertices[d9])}}else{for(d9=0,d8=this.vertices.length;d9<d8;d9++){var d7=this.vertices[d9];if(d7[2]===0){cV.vertex(d7[0],d7[1])}else{cV.vertex(d7[0],d7[1],d7[2])}}}cV.endShape()},drawGroup:function(){for(var d8=0,d7=this.children.length;d8<d7;d8++){this.children[d8].draw()}},drawPrimitive:function(){if(this.kind===2){cV.point(this.params[0],this.params[1])}else{if(this.kind===4){if(this.params.length===4){cV.line(this.params[0],this.params[1],this.params[2],this.params[3])}else{cV.line(this.params[0],this.params[1],this.params[2],this.params[3],this.params[4],this.params[5])}}else{if(this.kind===8){cV.triangle(this.params[0],this.params[1],this.params[2],this.params[3],this.params[4],this.params[5])}else{if(this.kind===16){cV.quad(this.params[0],this.params[1],this.params[2],this.params[3],this.params[4],this.params[5],this.params[6],this.params[7])}else{if(this.kind===30){if(this.image!==null){cV.imageMode(0);cV.image(this.image,this.params[0],this.params[1],this.params[2],this.params[3])}else{cV.rectMode(0);cV.rect(this.params[0],this.params[1],this.params[2],this.params[3])}}else{if(this.kind===31){cV.ellipseMode(0);cV.ellipse(this.params[0],this.params[1],this.params[2],this.params[3])}else{if(this.kind===32){cV.ellipseMode(0);cV.arc(this.params[0],this.params[1],this.params[2],this.params[3],this.params[4],this.params[5])}else{if(this.kind===41){if(this.params.length===1){cV.box(this.params[0])}else{cV.box(this.params[0],this.params[1],this.params[2])}}else{if(this.kind===40){cV.sphere(this.params[0])}}}}}}}}}},pre:function(){if(this.matrix){cV.pushMatrix();d4.transform(this.matrix.elements[0],this.matrix.elements[3],this.matrix.elements[1],this.matrix.elements[4],this.matrix.elements[2],this.matrix.elements[5])}if(this.style){cV.pushStyle();this.styles()}},post:function(){if(this.matrix){cV.popMatrix()}if(this.style){cV.popStyle()}},styles:function(){if(this.stroke){cV.stroke(this.strokeColor);cV.strokeWeight(this.strokeWeight);cV.strokeCap(this.strokeCap);cV.strokeJoin(this.strokeJoin)}else{cV.noStroke()}if(this.fill){cV.fill(this.fillColor)}else{cV.noFill()}},getChild:function(ea){var d8,d7;if(typeof ea==="number"){return this.children[ea]}var d9;if(ea===""||this.name===ea){return this}if(this.nameTable.length>0){for(d8=0,d7=this.nameTable.length;d8<d7||d9;d8++){if(this.nameTable[d8].getName===ea){d9=this.nameTable[d8];break}}if(d9){return d9}}for(d8=0,d7=this.children.length;d8<d7;d8++){d9=this.children[d8].getChild(ea);if(d9){return d9}}return null},getChildCount:function(){return this.children.length},addChild:function(d7){this.children.push(d7);d7.parent=this;if(d7.getName()!==null){this.addName(d7.getName(),d7)}},addName:function(d8,d7){if(this.parent!==null){this.parent.addName(d8,d7)}else{this.nameTable.push([d8,d7])}},translate:function(){if(arguments.length===2){this.checkMatrix(2);this.matrix.translate(arguments[0],arguments[1])}else{this.checkMatrix(3);this.matrix.translate(arguments[0],arguments[1],0)}},checkMatrix:function(d7){if(this.matrix===null){if(d7===2){this.matrix=new cV.PMatrix2D}else{this.matrix=new cV.PMatrix3D}}else{if(d7===3&&this.matrix instanceof cV.PMatrix2D){this.matrix=new cV.PMatrix3D}}},rotateX:function(d7){this.rotate(d7,1,0,0)},rotateY:function(d7){this.rotate(d7,0,1,0)},rotateZ:function(d7){this.rotate(d7,0,0,1)},rotate:function(){if(arguments.length===1){this.checkMatrix(2);this.matrix.rotate(arguments[0])}else{this.checkMatrix(3);this.matrix.rotate(arguments[0],arguments[1],arguments[2],arguments[3])}},scale:function(){if(arguments.length===2){this.checkMatrix(2);this.matrix.scale(arguments[0],arguments[1])}else{if(arguments.length===3){this.checkMatrix(2);this.matrix.scale(arguments[0],arguments[1],arguments[2])}else{this.checkMatrix(2);this.matrix.scale(arguments[0])}}},resetMatrix:function(){this.checkMatrix(2);this.matrix.reset()},applyMatrix:function(d7){if(arguments.length===1){this.applyMatrix(d7.elements[0],d7.elements[1],0,d7.elements[2],d7.elements[3],d7.elements[4],0,d7.elements[5],0,0,1,0,0,0,0,1)}else{if(arguments.length===6){this.checkMatrix(2);this.matrix.apply(arguments[0],arguments[1],arguments[2],0,arguments[3],arguments[4],arguments[5],0,0,0,1,0,0,0,0,1)}else{if(arguments.length===16){this.checkMatrix(3);this.matrix.apply(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],arguments[11],arguments[12],arguments[13],arguments[14],arguments[15])}}}}};var cq=cV.PShapeSVG=function(){cV.PShape.call(this);if(arguments.length===1){this.element=arguments[0];this.vertexCodes=[];this.vertices=[];this.opacity=1;this.stroke=false;this.strokeColor=4278190080;this.strokeWeight=1;this.strokeCap="butt";this.strokeJoin="miter";this.strokeGradient=null;this.strokeGradientPaint=null;this.strokeName=null;this.strokeOpacity=1;this.fill=true;this.fillColor=4278190080;this.fillGradient=null;this.fillGradientPaint=null;this.fillName=null;this.fillOpacity=1;if(this.element.getName()!=="svg"){throw"root is not <svg>, it's <"+this.element.getName()+">"}}else{if(arguments.length===2){if(typeof arguments[1]==="string"){if(arguments[1].indexOf(".svg")>-1){this.element=new cV.XMLElement(null,arguments[1]);this.vertexCodes=[];this.vertices=[];this.opacity=1;this.stroke=false;this.strokeColor=4278190080;this.strokeWeight=1;this.strokeCap="butt";this.strokeJoin="miter";this.strokeGradient="";this.strokeGradientPaint="";this.strokeName="";this.strokeOpacity=1;this.fill=true;this.fillColor=4278190080;this.fillGradient=null;this.fillGradientPaint=null;this.fillOpacity=1}}else{if(arguments[0]){this.element=arguments[1];this.vertexCodes=arguments[0].vertexCodes.slice();this.vertices=arguments[0].vertices.slice();this.stroke=arguments[0].stroke;this.strokeColor=arguments[0].strokeColor;this.strokeWeight=arguments[0].strokeWeight;this.strokeCap=arguments[0].strokeCap;this.strokeJoin=arguments[0].strokeJoin;this.strokeGradient=arguments[0].strokeGradient;this.strokeGradientPaint=arguments[0].strokeGradientPaint;this.strokeName=arguments[0].strokeName;this.fill=arguments[0].fill;this.fillColor=arguments[0].fillColor;this.fillGradient=arguments[0].fillGradient;this.fillGradientPaint=arguments[0].fillGradientPaint;this.fillName=arguments[0].fillName;this.strokeOpacity=arguments[0].strokeOpacity;this.fillOpacity=arguments[0].fillOpacity;this.opacity=arguments[0].opacity}}}}this.name=this.element.getStringAttribute("id");var d7=this.element.getStringAttribute("display","inline");this.visible=d7!=="none";var ec=this.element.getAttribute("transform");if(ec){this.matrix=this.parseMatrix(ec)}var d9=this.element.getStringAttribute("viewBox");if(d9!==null){var eb=d9.split(" ");this.width=eb[2];this.height=eb[3]}var d8=this.element.getStringAttribute("width");var ea=this.element.getStringAttribute("height");if(d8!==null){this.width=this.parseUnitSize(d8);this.height=this.parseUnitSize(ea)}else{if(this.width===0||this.height===0){this.width=1;this.height=1;throw"The width and/or height is not readable in the <svg> tag of this file."}}this.parseColors(this.element);this.parseChildren(this.element)};cq.prototype=new M;cq.prototype.parseMatrix=function(){function d7(d9){var d8=[];d9.replace(/\((.*?)\)/,function(){return function(ea,eb){d8=eb.replace(/,+/g," ").split(/\s+/)}}());return d8}return function(ef){this.checkMatrix(2);var d8=[];ef.replace(/\s*(\w+)\((.*?)\)/g,function(ei){d8.push(cV.trim(ei))});if(d8.length===0){return null}for(var ed=0,eb=d8.length;ed<eb;ed++){var d9=d7(d8[ed]);if(d8[ed].indexOf("matrix")!==-1){this.matrix.set(d9[0],d9[2],d9[4],d9[1],d9[3],d9[5])}else{if(d8[ed].indexOf("translate")!==-1){var ee=d9[0];var ec=d9.length===2?d9[1]:0;this.matrix.translate(ee,ec)}else{if(d8[ed].indexOf("scale")!==-1){var eh=d9[0];var eg=d9.length===2?d9[1]:d9[0];this.matrix.scale(eh,eg)}else{if(d8[ed].indexOf("rotate")!==-1){var ea=d9[0];if(d9.length===1){this.matrix.rotate(cV.radians(ea))}else{if(d9.length===3){this.matrix.translate(d9[1],d9[2]);this.matrix.rotate(cV.radians(d9[0]));this.matrix.translate(-d9[1],-d9[2])}}}else{if(d8[ed].indexOf("skewX")!==-1){this.matrix.skewX(parseFloat(d9[0]))}else{if(d8[ed].indexOf("skewY")!==-1){this.matrix.skewY(d9[0])}}}}}}}return this.matrix}}();cq.prototype.parseChildren=function(ec){var d8=ec.getChildren();var eb=new cV.PShape;for(var ea=0,d9=d8.length;ea<d9;ea++){var d7=this.parseChild(d8[ea]);if(d7){eb.addChild(d7)}}this.children.push(eb)};cq.prototype.getName=function(){return this.name};cq.prototype.parseChild=function(d9){var d8=d9.getName();var d7;if(d8==="g"){d7=new cq(this,d9)}else{if(d8==="defs"){d7=new cq(this,d9)}else{if(d8==="line"){d7=new cq(this,d9);d7.parseLine()}else{if(d8==="circle"){d7=new cq(this,d9);d7.parseEllipse(true)}else{if(d8==="ellipse"){d7=new cq(this,d9);d7.parseEllipse(false)}else{if(d8==="rect"){d7=new cq(this,d9);d7.parseRect()}else{if(d8==="polygon"){d7=new cq(this,d9);d7.parsePoly(true)}else{if(d8==="polyline"){d7=new cq(this,d9);d7.parsePoly(false)}else{if(d8==="path"){d7=new cq(this,d9);d7.parsePath()}else{if(d8==="radialGradient"){dt("PShapeSVG.prototype.parseChild, name = radialGradient")}else{if(d8==="linearGradient"){dt("PShapeSVG.prototype.parseChild, name = linearGradient")}else{if(d8==="text"){dt("PShapeSVG.prototype.parseChild, name = text")}else{if(d8==="filter"){dt("PShapeSVG.prototype.parseChild, name = filter")}else{if(d8==="mask"){dt("PShapeSVG.prototype.parseChild, name = mask")}else{E()}}}}}}}}}}}}}}return d7};cq.prototype.parsePath=function(){this.family=21;this.kind=0;var ec=[];var ew;var ev=cV.trim(this.element.getStringAttribute("d").replace(/[\s,]+/g," "));if(ev===null){return}ev=cV.__toCharArray(ev);var ea=0,d9=0,eh=0,ef=0,eg=0,ee=0,en=0,em=0,d8=0,d7=0,ej=0,ei=0,el=0,ek=0,eu=0,eq=0;var eo="";var es=[];var et=false;var ed;var eb;var er,ep;while(eu<ev.length){eq=ev[eu].valueOf();if(eq>=65&&eq<=90||eq>=97&&eq<=122){er=eu;eu++;if(eu<ev.length){es=[];eq=ev[eu].valueOf();while(!(eq>=65&&eq<=90||eq>=97&&eq<=100||eq>=102&&eq<=122)&&et===false){if(eq===32){if(eo!==""){es.push(parseFloat(eo));eo=""}eu++}else{if(eq===45){if(ev[eu-1].valueOf()===101){eo+=ev[eu].toString();eu++}else{if(eo!==""){es.push(parseFloat(eo))}eo=ev[eu].toString();eu++}}else{eo+=ev[eu].toString();eu++}}if(eu===ev.length){et=true}else{eq=ev[eu].valueOf()}}}if(eo!==""){es.push(parseFloat(eo));eo=""}eb=ev[er];eq=eb.valueOf();if(eq===77){if(es.length>=2&&es.length%2===0){ea=es[0];d9=es[1];this.parsePathMoveto(ea,d9);if(es.length>2){for(er=2,ep=es.length;er<ep;er+=2){ea=es[er];d9=es[er+1];this.parsePathLineto(ea,d9)}}}}else{if(eq===109){if(es.length>=2&&es.length%2===0){ea+=es[0];d9+=es[1];this.parsePathMoveto(ea,d9);if(es.length>2){for(er=2,ep=es.length;er<ep;er+=2){ea+=es[er];d9+=es[er+1];this.parsePathLineto(ea,d9)}}}}else{if(eq===76){if(es.length>=2&&es.length%2===0){for(er=0,ep=es.length;er<ep;er+=2){ea=es[er];d9=es[er+1];this.parsePathLineto(ea,d9)}}}else{if(eq===108){if(es.length>=2&&es.length%2===0){for(er=0,ep=es.length;er<ep;er+=2){ea+=es[er];d9+=es[er+1];this.parsePathLineto(ea,d9)}}}else{if(eq===72){for(er=0,ep=es.length;er<ep;er++){ea=es[er];this.parsePathLineto(ea,d9)}}else{if(eq===104){for(er=0,ep=es.length;er<ep;er++){ea+=es[er];this.parsePathLineto(ea,d9)}}else{if(eq===86){for(er=0,ep=es.length;er<ep;er++){d9=es[er];this.parsePathLineto(ea,d9)}}else{if(eq===118){for(er=0,ep=es.length;er<ep;er++){d9+=es[er];this.parsePathLineto(ea,d9)}}else{if(eq===67){if(es.length>=6&&es.length%6===0){for(er=0,ep=es.length;er<ep;er+=6){eg=es[er];en=es[er+1];ee=es[er+2];em=es[er+3];d8=es[er+4];d7=es[er+5];this.parsePathCurveto(eg,en,ee,em,d8,d7);ea=d8;d9=d7}}}else{if(eq===99){if(es.length>=6&&es.length%6===0){for(er=0,ep=es.length;er<ep;er+=6){eg=ea+es[er];en=d9+es[er+1];ee=ea+es[er+2];em=d9+es[er+3];d8=ea+es[er+4];d7=d9+es[er+5];this.parsePathCurveto(eg,en,ee,em,d8,d7);ea=d8;d9=d7}}}else{if(eq===83){if(es.length>=4&&es.length%4===0){for(er=0,ep=es.length;er<ep;er+=4){if(ed.toLowerCase()==="c"||ed.toLowerCase()==="s"){ej=this.vertices[this.vertices.length-2][0];ei=this.vertices[this.vertices.length-2][1];el=this.vertices[this.vertices.length-1][0];ek=this.vertices[this.vertices.length-1][1];eg=el+(el-ej);en=ek+(ek-ei)}else{eg=this.vertices[this.vertices.length-1][0];en=this.vertices[this.vertices.length-1][1]}ee=es[er];em=es[er+1];d8=es[er+2];d7=es[er+3];this.parsePathCurveto(eg,en,ee,em,d8,d7);ea=d8;d9=d7}}}else{if(eq===115){if(es.length>=4&&es.length%4===0){for(er=0,ep=es.length;er<ep;er+=4){if(ed.toLowerCase()==="c"||ed.toLowerCase()==="s"){ej=this.vertices[this.vertices.length-2][0];ei=this.vertices[this.vertices.length-2][1];el=this.vertices[this.vertices.length-1][0];ek=this.vertices[this.vertices.length-1][1];eg=el+(el-ej);en=ek+(ek-ei)}else{eg=this.vertices[this.vertices.length-1][0];en=this.vertices[this.vertices.length-1][1]}ee=ea+es[er];em=d9+es[er+1];d8=ea+es[er+2];d7=d9+es[er+3];this.parsePathCurveto(eg,en,ee,em,d8,d7);ea=d8;d9=d7}}}else{if(eq===81){if(es.length>=4&&es.length%4===0){for(er=0,ep=es.length;er<ep;er+=4){eh=es[er];ef=es[er+1];d8=es[er+2];d7=es[er+3];this.parsePathQuadto(ea,d9,eh,ef,d8,d7);ea=d8;d9=d7}}}else{if(eq===113){if(es.length>=4&&es.length%4===0){for(er=0,ep=es.length;er<ep;er+=4){eh=ea+es[er];ef=d9+es[er+1];d8=ea+es[er+2];d7=d9+es[er+3];this.parsePathQuadto(ea,d9,eh,ef,d8,d7);ea=d8;d9=d7}}}else{if(eq===84){if(es.length>=2&&es.length%2===0){for(er=0,ep=es.length;er<ep;er+=2){if(ed.toLowerCase()==="q"||ed.toLowerCase()==="t"){ej=this.vertices[this.vertices.length-2][0];ei=this.vertices[this.vertices.length-2][1];el=this.vertices[this.vertices.length-1][0];ek=this.vertices[this.vertices.length-1][1];eh=el+(el-ej);ef=ek+(ek-ei)}else{eh=ea;ef=d9}d8=es[er];d7=es[er+1];this.parsePathQuadto(ea,d9,eh,ef,d8,d7);ea=d8;d9=d7}}}else{if(eq===116){if(es.length>=2&&es.length%2===0){for(er=0,ep=es.length;er<ep;er+=2){if(ed.toLowerCase()==="q"||ed.toLowerCase()==="t"){ej=this.vertices[this.vertices.length-2][0];ei=this.vertices[this.vertices.length-2][1];el=this.vertices[this.vertices.length-1][0];ek=this.vertices[this.vertices.length-1][1];eh=el+(el-ej);ef=ek+(ek-ei)}else{eh=ea;ef=d9}d8=ea+es[er];d7=d9+es[er+1];this.parsePathQuadto(ea,d9,eh,ef,d8,d7);ea=d8;d9=d7}}}else{if(eq===90||eq===122){this.close=true}}}}}}}}}}}}}}}}}ed=eb.toString()}else{eu++}}};cq.prototype.parsePathQuadto=function(d9,eb,d7,ec,d8,ea){if(this.vertices.length>0){this.parsePathCode(1);this.parsePathVertex(d9+(d7-d9)*2/3,eb+(ec-eb)*2/3);this.parsePathVertex(d8+(d7-d8)*2/3,ea+(ec-ea)*2/3);this.parsePathVertex(d8,ea)}else{throw"Path must start with M/m"}};cq.prototype.parsePathCurveto=function(ea,ec,d8,eb,d7,d9){if(this.vertices.length>0){this.parsePathCode(1);this.parsePathVertex(ea,ec);this.parsePathVertex(d8,eb);this.parsePathVertex(d7,d9)}else{throw"Path must start with M/m"}};cq.prototype.parsePathLineto=function(d8,d7){if(this.vertices.length>0){this.parsePathCode(0);this.parsePathVertex(d8,d7);this.vertices[this.vertices.length-1]["moveTo"]=false}else{throw"Path must start with M/m"}};cq.prototype.parsePathMoveto=function(d8,d7){if(this.vertices.length>0){this.parsePathCode(3)}this.parsePathCode(0);this.parsePathVertex(d8,d7);this.vertices[this.vertices.length-1]["moveTo"]=true};cq.prototype.parsePathVertex=function(d7,d9){var d8=[];d8[0]=d7;d8[1]=d9;this.vertices.push(d8)};cq.prototype.parsePathCode=function(d7){this.vertexCodes.push(d7)};cq.prototype.parsePoly=function(eb){this.family=21;this.close=eb;var d8=cV.trim(this.element.getStringAttribute("points").replace(/[,\s]+/g," "));if(d8!==null){var d7=d8.split(" ");if(d7.length%2===0){for(var ea=0,d9=d7.length;ea<d9;ea++){var ec=[];ec[0]=d7[ea];ec[1]=d7[++ea];this.vertices.push(ec)}}else{throw"Error parsing polygon points: odd number of coordinates provided"}}};cq.prototype.parseRect=function(){this.kind=30;this.family=1;this.params=[];this.params[0]=this.element.getFloatAttribute("x");this.params[1]=this.element.getFloatAttribute("y");this.params[2]=this.element.getFloatAttribute("width");this.params[3]=this.element.getFloatAttribute("height");if(this.params[2]<0||this.params[3]<0){throw"svg error: negative width or height found while parsing <rect>"}};cq.prototype.parseEllipse=function(d9){this.kind=31;this.family=1;this.params=[];this.params[0]=this.element.getFloatAttribute("cx")|0;this.params[1]=this.element.getFloatAttribute("cy")|0;var d8,d7;if(d9){d8=d7=this.element.getFloatAttribute("r");if(d8<0){throw"svg error: negative radius found while parsing <circle>"}}else{d8=this.element.getFloatAttribute("rx");d7=this.element.getFloatAttribute("ry");if(d8<0||d7<0){throw"svg error: negative x-axis radius or y-axis radius found while parsing <ellipse>"}}this.params[0]-=d8;this.params[1]-=d7;this.params[2]=d8*2;this.params[3]=d7*2};cq.prototype.parseLine=function(){this.kind=4;this.family=1;this.params=[];this.params[0]=this.element.getFloatAttribute("x1");this.params[1]=this.element.getFloatAttribute("y1");this.params[2]=this.element.getFloatAttribute("x2");this.params[3]=this.element.getFloatAttribute("y2")};cq.prototype.parseColors=function(d9){if(d9.hasAttribute("opacity")){this.setOpacity(d9.getAttribute("opacity"))}if(d9.hasAttribute("stroke")){this.setStroke(d9.getAttribute("stroke"))}if(d9.hasAttribute("stroke-width")){this.setStrokeWeight(d9.getAttribute("stroke-width"))}if(d9.hasAttribute("stroke-linejoin")){this.setStrokeJoin(d9.getAttribute("stroke-linejoin"))}if(d9.hasAttribute("stroke-linecap")){this.setStrokeCap(d9.getStringAttribute("stroke-linecap"))}if(d9.hasAttribute("fill")){this.setFill(d9.getStringAttribute("fill"))}if(d9.hasAttribute("style")){var ec=d9.getStringAttribute("style");var ea=ec.toString().split(";");for(var d8=0,d7=ea.length;d8<d7;d8++){var eb=cV.trim(ea[d8].split(":"));if(eb[0]==="fill"){this.setFill(eb[1])}else{if(eb[0]==="fill-opacity"){this.setFillOpacity(eb[1])}else{if(eb[0]==="stroke"){this.setStroke(eb[1])}else{if(eb[0]==="stroke-width"){this.setStrokeWeight(eb[1])}else{if(eb[0]==="stroke-linecap"){this.setStrokeCap(eb[1])}else{if(eb[0]==="stroke-linejoin"){this.setStrokeJoin(eb[1])}else{if(eb[0]==="stroke-opacity"){this.setStrokeOpacity(eb[1])}else{if(eb[0]==="opacity"){this.setOpacity(eb[1])}}}}}}}}}}};cq.prototype.setFillOpacity=function(d7){this.fillOpacity=parseFloat(d7);this.fillColor=this.fillOpacity*255<<24|this.fillColor&16777215};cq.prototype.setFill=function(d7){var d8=this.fillColor&4278190080;if(d7==="none"){this.fill=false}else{if(d7.indexOf("#")===0){this.fill=true;if(d7.length===4){d7=d7.replace(/#(.)(.)(.)/,"#$1$1$2$2$3$3")}this.fillColor=d8|parseInt(d7.substring(1),16)&16777215}else{if(d7.indexOf("rgb")===0){this.fill=true;this.fillColor=d8|this.parseRGB(d7)}else{if(d7.indexOf("url(#")===0){this.fillName=d7.substring(5,d7.length-1)}else{if(C[d7]){this.fill=true;this.fillColor=d8|parseInt(C[d7].substring(1),16)&16777215}}}}}};cq.prototype.setOpacity=function(d7){this.strokeColor=parseFloat(d7)*255<<24|this.strokeColor&16777215;this.fillColor=parseFloat(d7)*255<<24|this.fillColor&16777215};cq.prototype.setStroke=function(d7){var d8=this.strokeColor&4278190080;if(d7==="none"){this.stroke=false}else{if(d7.charAt(0)==="#"){this.stroke=true;if(d7.length===4){d7=d7.replace(/#(.)(.)(.)/,"#$1$1$2$2$3$3")}this.strokeColor=d8|parseInt(d7.substring(1),16)&16777215}else{if(d7.indexOf("rgb")===0){this.stroke=true;this.strokeColor=d8|this.parseRGB(d7)}else{if(d7.indexOf("url(#")===0){this.strokeName=d7.substring(5,d7.length-1)}else{if(C[d7]){this.stroke=true;this.strokeColor=d8|parseInt(C[d7].substring(1),16)&16777215}}}}}};cq.prototype.setStrokeWeight=function(d7){this.strokeWeight=this.parseUnitSize(d7)};cq.prototype.setStrokeJoin=function(d7){if(d7==="miter"){this.strokeJoin="miter"}else{if(d7==="round"){this.strokeJoin="round"}else{if(d7==="bevel"){this.strokeJoin="bevel"}}}};cq.prototype.setStrokeCap=function(d7){if(d7==="butt"){this.strokeCap="butt"}else{if(d7==="round"){this.strokeCap="round"}else{if(d7==="square"){this.strokeCap="square"}}}};cq.prototype.setStrokeOpacity=function(d7){this.strokeOpacity=parseFloat(d7);this.strokeColor=this.strokeOpacity*255<<24|this.strokeColor&16777215};cq.prototype.parseRGB=function(d8){var d9=d8.substring(d8.indexOf("(")+1,d8.indexOf(")"));var d7=d9.split(", ");return d7[0]<<16|d7[1]<<8|d7[2]};cq.prototype.parseUnitSize=function(d8){var d7=d8.length-2;if(d7<0){return d8}if(d8.indexOf("pt")===d7){return parseFloat(d8.substring(0,d7))*1.25}if(d8.indexOf("pc")===d7){return parseFloat(d8.substring(0,d7))*15}if(d8.indexOf("mm")===d7){return parseFloat(d8.substring(0,d7))*3.543307}if(d8.indexOf("cm")===d7){return parseFloat(d8.substring(0,d7))*35.43307}if(d8.indexOf("in")===d7){return parseFloat(d8.substring(0,d7))*90}if(d8.indexOf("px")===d7){return parseFloat(d8.substring(0,d7))}return parseFloat(d8)};cV.shape=function(d9,d8,eb,ea,d7){if(arguments.length>=1&&arguments[0]!==null){if(d9.isVisible()){cV.pushMatrix();if(Q===3){if(arguments.length===5){cV.translate(d8-ea/2,eb-d7/2);cV.scale(ea/d9.getWidth(),d7/d9.getHeight())}else{if(arguments.length===3){cV.translate(d8-d9.getWidth()/2,-d9.getHeight()/2)}else{cV.translate(-d9.getWidth()/2,-d9.getHeight()/2)}}}else{if(Q===0){if(arguments.length===5){cV.translate(d8,eb);cV.scale(ea/d9.getWidth(),d7/d9.getHeight())}else{if(arguments.length===3){cV.translate(d8,eb)}}}else{if(Q===1){if(arguments.length===5){ea-=d8;d7-=eb;cV.translate(d8,eb);cV.scale(ea/d9.getWidth(),d7/d9.getHeight())}else{if(arguments.length===3){cV.translate(d8,eb)}}}}}d9.draw();if(arguments.length===1&&Q===3||arguments.length>1){cV.popMatrix()}}}};cV.shapeMode=function(d7){Q=d7};cV.loadShape=function(d7){if(arguments.length===1){if(d7.indexOf(".svg")>-1){return new cq(null,d7)}}return null};var cS=function(eb,ea,d7,d8,d9){this.fullName=eb||"";this.name=ea||"";this.namespace=d7||"";this.value=d8;this.type=d9};cS.prototype={getName:function(){return this.name},getFullName:function(){return this.fullName},getNamespace:function(){return this.namespace},getValue:function(){return this.value},getType:function(){return this.type},setValue:function(d7){this.value=d7}};var b8=cV.XMLElement=function(){this.attributes=[];this.children=[];this.fullName=null;this.name=null;this.namespace="";this.content=null;this.parent=null;this.lineNr="";this.systemID="";this.type="ELEMENT";if(arguments.length===4){this.fullName=arguments[0]||"";if(arguments[1]){this.name=arguments[1]}else{var d7=this.fullName.indexOf(":");if(d7>=0){this.name=this.fullName.substring(d7+1)}else{this.name=this.fullName}}this.namespace=arguments[1];this.lineNr=arguments[3];this.systemID=arguments[2]}else{if(arguments.length===2&&arguments[1].indexOf(".")>-1){this.parse(arguments[arguments.length-1])}else{if(arguments.length===1&&typeof arguments[0]==="string"){this.parse(arguments[0])}}}};b8.prototype={parse:function(d7){var d9;try{var eb=d7.substring(d7.length-4);if(eb===".xml"||eb===".svg"){d7=u(d7)}d9=(new DOMParser).parseFromString(d7,"text/xml");var d8=d9.documentElement;if(d8){this.parseChildrenRecursive(null,d8)}else{throw"Error loading document"}return this}catch(ea){throw ea}},parseChildrenRecursive:function(ef,ed){var ec,d8,ee,eb,ea,d7;if(!ef){this.fullName=ed.localName;this.name=ed.nodeName;ec=this}else{ec=new b8(ed.localName,ed.nodeName,"","");ec.parent=ef}if(ed.nodeType===3&&ed.textContent!==""){return this.createPCDataElement(ed.textContent)}for(eb=0,ea=ed.attributes.length;eb<ea;eb++){ee=ed.attributes[eb];d8=new cS(ee.getname,ee.nodeName,ee.namespaceURI,ee.nodeValue,ee.nodeType);ec.attributes.push(d8)}for(eb=0,ea=ed.childNodes.length;eb<ea;eb++){var d9=ed.childNodes[eb];if(d9.nodeType===1||d9.nodeType===3){d7=ec.parseChildrenRecursive(ec,d9);if(d7!==null){ec.children.push(d7)}}}return ec},createElement:function(){if(arguments.length===2){return new b8(arguments[0],arguments[1],null,null)}return new b8(arguments[0],arguments[1],arguments[2],arguments[3])},createPCDataElement:function(d7){if(d7.replace(/^\s+$/g,"")===""){return null}var d8=new b8;d8.content=d7;d8.type="TEXT";return d8},hasAttribute:function(){if(arguments.length===1){return this.getAttribute(arguments[0])!==null}if(arguments.length===2){return this.getAttribute(arguments[0],arguments[1])!==null}},equals:function(ec){if(!(ec instanceof b8)){return false}var d9,d8;if(this.name!==ec.getLocalName()){return false}if(this.attributes.length!==ec.getAttributeCount()){return false}if(this.attributes.length!==ec.attributes.length){return false}var eg,ee,d7,ed,ef;for(d9=0,d8=this.attributes.length;d9<d8;d9++){eg=this.attributes[d9].getName();ee=this.attributes[d9].getNamespace();ef=ec.findAttribute(eg,ee);if(ef===null){return false}if(this.attributes[d9].getValue()!==ef.getValue()){return false}if(this.attributes[d9].getType()!==ef.getType()){return false}}if(this.children.length!==ec.getChildCount()){return false}if(this.children.length>0){var eb,ea;for(d9=0,d8=this.children.length;d9<d8;d9++){eb=this.getChild(d9);ea=ec.getChild(d9);if(!eb.equals(ea)){return false}}return true}return this.content===ec.content},getContent:function(){if(this.type==="TEXT"){return this.content}var d7=this.children;if(d7.length===1&&d7[0].type==="TEXT"){return d7[0].content}return null},getAttribute:function(){var d7;if(arguments.length===2){d7=this.findAttribute(arguments[0]);if(d7){return d7.getValue()}return arguments[1]}else{if(arguments.length===1){d7=this.findAttribute(arguments[0]);if(d7){return d7.getValue()}return null}else{if(arguments.length===3){d7=this.findAttribute(arguments[0],arguments[1]);if(d7){return d7.getValue()}return arguments[2]}}}},getStringAttribute:function(){if(arguments.length===1){return this.getAttribute(arguments[0])}if(arguments.length===2){return this.getAttribute(arguments[0],arguments[1])}return this.getAttribute(arguments[0],arguments[1],arguments[2])},getString:function(d7){return this.getStringAttribute(d7)},getFloatAttribute:function(){if(arguments.length===1){return parseFloat(this.getAttribute(arguments[0],0))}if(arguments.length===2){return this.getAttribute(arguments[0],arguments[1])}return this.getAttribute(arguments[0],arguments[1],arguments[2])},getFloat:function(d7){return this.getFloatAttribute(d7)},getIntAttribute:function(){if(arguments.length===1){return this.getAttribute(arguments[0],0)}if(arguments.length===2){return this.getAttribute(arguments[0],arguments[1])}return this.getAttribute(arguments[0],arguments[1],arguments[2])},getInt:function(d7){return this.getIntAttribute(d7)},hasChildren:function(){return this.children.length>0},addChild:function(d7){if(d7!==null){d7.parent=this;this.children.push(d7)}},insertChild:function(d9,d7){if(d9){if(d9.getLocalName()===null&&!this.hasChildren()){var d8=this.children[this.children.length-1];if(d8.getLocalName()===null){d8.setContent(d8.getContent()+d9.getContent());return}}d9.parent=this;this.children.splice(d7,0,d9)}},getChild:function(){if(typeof arguments[0]==="number"){return this.children[arguments[0]]}if(arguments[0].indexOf("/")!==-1){this.getChildRecursive(arguments[0].split("/"),0);return null}var d7,ea;for(var d9=0,d8=this.getChildCount();d9<d8;d9++){d7=this.getChild(d9);ea=d7.getName();if(ea!==null&&ea===arguments[0]){return d7}}return null},getChildren:function(){if(arguments.length===1){if(typeof arguments[0]==="number"){return this.getChild(arguments[0])}if(arguments[0].indexOf("/")!==-1){return this.getChildrenRecursive(arguments[0].split("/"),0)}var eb=[];var d7,ea;for(var d9=0,d8=this.getChildCount();d9<d8;d9++){d7=this.getChild(d9);ea=d7.getName();if(ea!==null&&ea===arguments[0]){eb.push(d7)}}return eb}return this.children},getChildCount:function(){return this.children.length},getChildRecursive:function(d8,ec){var d7,eb;for(var ea=0,d9=this.getChildCount();ea<d9;ea++){d7=this.getChild(ea);eb=d7.getName();if(eb!==null&&eb===d8[ec]){if(ec===d8.length-1){return d7}ec+=1;return d7.getChildRecursive(d8,ec)}}return null},getChildrenRecursive:function(d7,eb){if(eb===d7.length-1){return this.getChildren(d7[eb])}var ea=this.getChildren(d7[eb]);var d9=[];for(var d8=0;d8<ea.length;d8++){d9=d9.concat(ea[d8].getChildrenRecursive(d7,eb+1))}return d9},isLeaf:function(){return !this.hasChildren()},listChildren:function(){var d7=[];for(var d9=0,d8=this.children.length;d9<d8;d9++){d7.push(this.getChild(d9).getName())}return d7},removeAttribute:function(d8,ea){this.namespace=ea||"";for(var d9=0,d7=this.attributes.length;d9<d7;d9++){if(this.attributes[d9].getName()===d8&&this.attributes[d9].getNamespace()===this.namespace){this.attributes.splice(d9,1);break}}},removeChild:function(d9){if(d9){for(var d8=0,d7=this.children.length;d8<d7;d8++){if(this.children[d8].equals(d9)){this.children.splice(d8,1);break}}}},removeChildAtIndex:function(d7){if(this.children.length>d7){this.children.splice(d7,1)}},findAttribute:function(d8,ea){this.namespace=ea||"";for(var d9=0,d7=this.attributes.length;d9<d7;d9++){if(this.attributes[d9].getName()===d8&&this.attributes[d9].getNamespace()===this.namespace){return this.attributes[d9]}}return null},setAttribute:function(){var d7;if(arguments.length===3){var d9=arguments[0].indexOf(":");var d8=arguments[0].substring(d9+1);d7=this.findAttribute(d8,arguments[1]);if(d7){d7.setValue(arguments[2])}else{d7=new cS(arguments[0],d8,arguments[1],arguments[2],"CDATA");this.attributes.push(d7)}}else{d7=this.findAttribute(arguments[0]);if(d7){d7.setValue(arguments[1])}else{d7=new cS(arguments[0],arguments[0],null,arguments[1],"CDATA");this.attributes.push(d7)}}},setString:function(d7,d8){this.setAttribute(d7,d8)},setInt:function(d7,d8){this.setAttribute(d7,d8)},setFloat:function(d7,d8){this.setAttribute(d7,d8)},setContent:function(d7){if(this.children.length>0){D.debug("Tried to set content for XMLElement with children")}this.content=d7},setName:function(){if(arguments.length===1){this.name=arguments[0];this.fullName=arguments[0];this.namespace=null}else{var d7=arguments[0].indexOf(":");if(arguments[1]===null||d7<0){this.name=arguments[0]}else{this.name=arguments[0].substring(d7+1)}this.fullName=arguments[0];this.namespace=arguments[1]}},getName:function(){return this.fullName},getLocalName:function(){return this.name},getAttributeCount:function(){return this.attributes.length},toString:function(){if(this.type==="TEXT"){return this.content}var d9=(this.namespace!==""&&this.namespace!==this.name?this.namespace+":":"")+this.name;var ea="<"+d9;var d8,eb;for(d8=0;d8<this.attributes.length;d8++){var d7=this.attributes[d8];ea+=" "+d7.getName()+'="'+d7.getValue()+'"'}if(this.children.length===0){if(this.content===""){ea+="/>"}else{ea+=">"+this.content+"</"+d9+">"}}else{ea+=">";for(eb=0;eb<this.children.length;eb++){ea+=this.children[eb].toString()}ea+="</"+d9+">"}return ea}};b8.parse=function(d8){var d7=new b8;d7.parse(d8);return d7};var cl=function(ea){var d7=0;for(var d8=0;d8<ea.length;d8++){if(d8!==0){d7=o.max(d7,o.abs(ea[d8]))}else{d7=o.abs(ea[d8])}}var d9=(d7+"").indexOf(".");if(d9===0){d9=1}else{if(d9===-1){d9=(d7+"").length}}return d9};var aT=cV.PMatrix2D=function(){if(arguments.length===0){this.reset()}else{if(arguments.length===1&&arguments[0] instanceof aT){this.set(arguments[0].array())}else{if(arguments.length===6){this.set(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5])}}}};aT.prototype={set:function(){if(arguments.length===6){var d7=arguments;this.set([d7[0],d7[1],d7[2],d7[3],d7[4],d7[5]])}else{if(arguments.length===1&&arguments[0] instanceof aT){this.elements=arguments[0].array()}else{if(arguments.length===1&&arguments[0] instanceof Array){this.elements=arguments[0].slice()}}}},get:function(){var d7=new aT;d7.set(this.elements);return d7},reset:function(){this.set([1,0,0,0,1,0])},array:function aD(){return this.elements.slice()},translate:function(d8,d7){this.elements[2]=d8*this.elements[0]+d7*this.elements[1]+this.elements[2];this.elements[5]=d8*this.elements[3]+d7*this.elements[4]+this.elements[5]},invTranslate:function(d8,d7){this.translate(-d8,-d7)},transpose:function(){},mult:function(d8,d9){var d7,ea;if(d8 instanceof y){d7=d8.x;ea=d8.y;if(!d9){d9=new y}}else{if(d8 instanceof Array){d7=d8[0];ea=d8[1];if(!d9){d9=[]}}}if(d9 instanceof Array){d9[0]=this.elements[0]*d7+this.elements[1]*ea+this.elements[2];d9[1]=this.elements[3]*d7+this.elements[4]*ea+this.elements[5]}else{if(d9 instanceof y){d9.x=this.elements[0]*d7+this.elements[1]*ea+this.elements[2];d9.y=this.elements[3]*d7+this.elements[4]*ea+this.elements[5];d9.z=0}}return d9},multX:function(d7,d8){return d7*this.elements[0]+d8*this.elements[1]+this.elements[2]},multY:function(d7,d8){return d7*this.elements[3]+d8*this.elements[4]+this.elements[5]},skewX:function(d7){this.apply(1,0,1,d7,0,0)},skewY:function(d7){this.apply(1,0,1,0,d7,0)},determinant:function(){return this.elements[0]*this.elements[4]-this.elements[1]*this.elements[3]},invert:function(){var ec=this.determinant();if(o.abs(ec)>-2147483648){var d8=this.elements[0];var ed=this.elements[1];var eb=this.elements[2];var ea=this.elements[3];var d9=this.elements[4];var d7=this.elements[5];this.elements[0]=d9/ec;this.elements[3]=-ea/ec;this.elements[1]=-ed/ec;this.elements[4]=d8/ec;this.elements[2]=(ed*d7-d9*eb)/ec;this.elements[5]=(ea*eb-d8*d7)/ec;return true}return false},scale:function(d8,d7){if(d8&&!d7){d7=d8}if(d8&&d7){this.elements[0]*=d8;this.elements[1]*=d7;this.elements[3]*=d8;this.elements[4]*=d7}},invScale:function(d8,d7){if(d8&&!d7){d7=d8}this.scale(1/d8,1/d7)},apply:function(){var d9;if(arguments.length===1&&arguments[0] instanceof aT){d9=arguments[0].array()}else{if(arguments.length===6){d9=Array.prototype.slice.call(arguments)}else{if(arguments.length===1&&arguments[0] instanceof Array){d9=arguments[0]}}}var d7=[0,0,this.elements[2],0,0,this.elements[5]];var ea=0;for(var eb=0;eb<2;eb++){for(var d8=0;d8<3;d8++,ea++){d7[ea]+=this.elements[eb*3+0]*d9[d8+0]+this.elements[eb*3+1]*d9[d8+3]}}this.elements=d7.slice()},preApply:function(){var d8;if(arguments.length===1&&arguments[0] instanceof aT){d8=arguments[0].array()}else{if(arguments.length===6){d8=Array.prototype.slice.call(arguments)}else{if(arguments.length===1&&arguments[0] instanceof Array){d8=arguments[0]}}}var d7=[0,0,d8[2],0,0,d8[5]];d7[2]=d8[2]+this.elements[2]*d8[0]+this.elements[5]*d8[1];d7[5]=d8[5]+this.elements[2]*d8[3]+this.elements[5]*d8[4];d7[0]=this.elements[0]*d8[0]+this.elements[3]*d8[1];d7[3]=this.elements[0]*d8[3]+this.elements[3]*d8[4];d7[1]=this.elements[1]*d8[0]+this.elements[4]*d8[1];d7[4]=this.elements[1]*d8[3]+this.elements[4]*d8[4];this.elements=d7.slice()},rotate:function(d9){var eb=o.cos(d9);var d7=o.sin(d9);var ea=this.elements[0];var d8=this.elements[1];this.elements[0]=eb*ea+d7*d8;this.elements[1]=-d7*ea+eb*d8;ea=this.elements[3];d8=this.elements[4];this.elements[3]=eb*ea+d7*d8;this.elements[4]=-d7*ea+eb*d8},rotateZ:function(d7){this.rotate(d7)},invRotateZ:function(d7){this.rotateZ(d7-o.PI)},print:function(){var d8=cl(this.elements);var d7=""+cV.nfs(this.elements[0],d8,4)+" "+cV.nfs(this.elements[1],d8,4)+" "+cV.nfs(this.elements[2],d8,4)+"\n"+cV.nfs(this.elements[3],d8,4)+" "+cV.nfs(this.elements[4],d8,4)+" "+cV.nfs(this.elements[5],d8,4)+"\n\n";cV.println(d7)}};var aM=cV.PMatrix3D=function(){this.reset()};aM.prototype={set:function(){if(arguments.length===16){this.elements=Array.prototype.slice.call(arguments)}else{if(arguments.length===1&&arguments[0] instanceof aM){this.elements=arguments[0].array()}else{if(arguments.length===1&&arguments[0] instanceof Array){this.elements=arguments[0].slice()}}}},get:function(){var d7=new aM;d7.set(this.elements);return d7},reset:function(){this.elements=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]},array:function aD(){return this.elements.slice()},translate:function(d8,d7,d9){if(d9===r){d9=0}this.elements[3]+=d8*this.elements[0]+d7*this.elements[1]+d9*this.elements[2];this.elements[7]+=d8*this.elements[4]+d7*this.elements[5]+d9*this.elements[6];this.elements[11]+=d8*this.elements[8]+d7*this.elements[9]+d9*this.elements[10];this.elements[15]+=d8*this.elements[12]+d7*this.elements[13]+d9*this.elements[14]},transpose:function(){var d7=this.elements[4];this.elements[4]=this.elements[1];this.elements[1]=d7;d7=this.elements[8];this.elements[8]=this.elements[2];this.elements[2]=d7;d7=this.elements[6];this.elements[6]=this.elements[9];this.elements[9]=d7;d7=this.elements[3];this.elements[3]=this.elements[12];this.elements[12]=d7;d7=this.elements[7];this.elements[7]=this.elements[13];this.elements[13]=d7;d7=this.elements[11];this.elements[11]=this.elements[14];this.elements[14]=d7},mult:function(d9,ea){var d7,ec,eb,d8;if(d9 instanceof y){d7=d9.x;ec=d9.y;eb=d9.z;d8=1;if(!ea){ea=new y}}else{if(d9 instanceof Array){d7=d9[0];ec=d9[1];eb=d9[2];d8=d9[3]||1;if(!ea||ea.length!==3&&ea.length!==4){ea=[0,0,0]}}}if(ea instanceof Array){if(ea.length===3){ea[0]=this.elements[0]*d7+this.elements[1]*ec+this.elements[2]*eb+this.elements[3];ea[1]=this.elements[4]*d7+this.elements[5]*ec+this.elements[6]*eb+this.elements[7];ea[2]=this.elements[8]*d7+this.elements[9]*ec+this.elements[10]*eb+this.elements[11]}else{if(ea.length===4){ea[0]=this.elements[0]*d7+this.elements[1]*ec+this.elements[2]*eb+this.elements[3]*d8;ea[1]=this.elements[4]*d7+this.elements[5]*ec+this.elements[6]*eb+this.elements[7]*d8;ea[2]=this.elements[8]*d7+this.elements[9]*ec+this.elements[10]*eb+this.elements[11]*d8;ea[3]=this.elements[12]*d7+this.elements[13]*ec+this.elements[14]*eb+this.elements[15]*d8}}}if(ea instanceof y){ea.x=this.elements[0]*d7+this.elements[1]*ec+this.elements[2]*eb+this.elements[3];ea.y=this.elements[4]*d7+this.elements[5]*ec+this.elements[6]*eb+this.elements[7];ea.z=this.elements[8]*d7+this.elements[9]*ec+this.elements[10]*eb+this.elements[11]}return ea},preApply:function(){var d9;if(arguments.length===1&&arguments[0] instanceof aM){d9=arguments[0].array()}else{if(arguments.length===16){d9=Array.prototype.slice.call(arguments)}else{if(arguments.length===1&&arguments[0] instanceof Array){d9=arguments[0]}}}var d7=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];var ea=0;for(var eb=0;eb<4;eb++){for(var d8=0;d8<4;d8++,ea++){d7[ea]+=this.elements[d8+0]*d9[eb*4+0]+this.elements[d8+4]*d9[eb*4+1]+this.elements[d8+8]*d9[eb*4+2]+this.elements[d8+12]*d9[eb*4+3]}}this.elements=d7.slice()},apply:function(){var d9;if(arguments.length===1&&arguments[0] instanceof aM){d9=arguments[0].array()}else{if(arguments.length===16){d9=Array.prototype.slice.call(arguments)}else{if(arguments.length===1&&arguments[0] instanceof Array){d9=arguments[0]}}}var d7=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];var ea=0;for(var eb=0;eb<4;eb++){for(var d8=0;d8<4;d8++,ea++){d7[ea]+=this.elements[eb*4+0]*d9[d8+0]+this.elements[eb*4+1]*d9[d8+4]+this.elements[eb*4+2]*d9[d8+8]+this.elements[eb*4+3]*d9[d8+12]}}this.elements=d7.slice()},rotate:function(eb,d7,ed,ea){if(!ed){this.rotateZ(eb)}else{var ec=cV.cos(eb);var d9=cV.sin(eb);var d8=1-ec;this.apply(d8*d7*d7+ec,d8*d7*ed-d9*ea,d8*d7*ea+d9*ed,0,d8*d7*ed+d9*ea,d8*ed*ed+ec,d8*ed*ea-d9*d7,0,d8*d7*ea-d9*ed,d8*ed*ea+d9*d7,d8*ea*ea+ec,0,0,0,0,1)}},invApply:function(){if(Z===r){Z=new aM}var d7=arguments;Z.set(d7[0],d7[1],d7[2],d7[3],d7[4],d7[5],d7[6],d7[7],d7[8],d7[9],d7[10],d7[11],d7[12],d7[13],d7[14],d7[15]);if(!Z.invert()){return false}this.preApply(Z);return true},rotateX:function(d8){var d9=cV.cos(d8);var d7=cV.sin(d8);this.apply([1,0,0,0,0,d9,-d7,0,0,d7,d9,0,0,0,0,1])},rotateY:function(d8){var d9=cV.cos(d8);var d7=cV.sin(d8);this.apply([d9,0,d7,0,0,1,0,0,-d7,0,d9,0,0,0,0,1])},rotateZ:function(d8){var d9=o.cos(d8);var d7=o.sin(d8);this.apply([d9,-d7,0,0,d7,d9,0,0,0,0,1,0,0,0,0,1])},scale:function(d9,d8,d7){if(d9&&!d8&&!d7){d8=d7=d9}else{if(d9&&d8&&!d7){d7=1}}if(d9&&d8&&d7){this.elements[0]*=d9;this.elements[1]*=d8;this.elements[2]*=d7;this.elements[4]*=d9;this.elements[5]*=d8;this.elements[6]*=d7;this.elements[8]*=d9;this.elements[9]*=d8;this.elements[10]*=d7;this.elements[12]*=d9;this.elements[13]*=d8;this.elements[14]*=d7}},skewX:function(d8){var d7=o.tan(d8);this.apply(1,d7,0,0,0,1,0,0,0,0,1,0,0,0,0,1)},skewY:function(d8){var d7=o.tan(d8);this.apply(1,0,0,0,d7,1,0,0,0,0,1,0,0,0,0,1)},multX:function(d7,ea,d9,d8){if(!d9){return this.elements[0]*d7+this.elements[1]*ea+this.elements[3]}if(!d8){return this.elements[0]*d7+this.elements[1]*ea+this.elements[2]*d9+this.elements[3]}return this.elements[0]*d7+this.elements[1]*ea+this.elements[2]*d9+this.elements[3]*d8},multY:function(d7,ea,d9,d8){if(!d9){return this.elements[4]*d7+this.elements[5]*ea+this.elements[7]}if(!d8){return this.elements[4]*d7+this.elements[5]*ea+this.elements[6]*d9+this.elements[7]}return this.elements[4]*d7+this.elements[5]*ea+this.elements[6]*d9+this.elements[7]*d8},multZ:function(d7,ea,d9,d8){if(!d8){return this.elements[8]*d7+this.elements[9]*ea+this.elements[10]*d9+this.elements[11]}return this.elements[8]*d7+this.elements[9]*ea+this.elements[10]*d9+this.elements[11]*d8},multW:function(d7,ea,d9,d8){if(!d8){return this.elements[12]*d7+this.elements[13]*ea+this.elements[14]*d9+this.elements[15]}return this.elements[12]*d7+this.elements[13]*ea+this.elements[14]*d9+this.elements[15]*d8},invert:function(){var eg=this.elements[0]*this.elements[5]-this.elements[1]*this.elements[4];var ef=this.elements[0]*this.elements[6]-this.elements[2]*this.elements[4];var ee=this.elements[0]*this.elements[7]-this.elements[3]*this.elements[4];var ed=this.elements[1]*this.elements[6]-this.elements[2]*this.elements[5];var ec=this.elements[1]*this.elements[7]-this.elements[3]*this.elements[5];var eb=this.elements[2]*this.elements[7]-this.elements[3]*this.elements[6];var ea=this.elements[8]*this.elements[13]-this.elements[9]*this.elements[12];var d9=this.elements[8]*this.elements[14]-this.elements[10]*this.elements[12];var d8=this.elements[8]*this.elements[15]-this.elements[11]*this.elements[12];var el=this.elements[9]*this.elements[14]-this.elements[10]*this.elements[13];var ej=this.elements[9]*this.elements[15]-this.elements[11]*this.elements[13];var ei=this.elements[10]*this.elements[15]-this.elements[11]*this.elements[14];var ek=eg*ei-ef*ej+ee*el+ed*d8-ec*d9+eb*ea;if(o.abs(ek)<=1e-9){return false}var eh=[];eh[0]=+this.elements[5]*ei-this.elements[6]*ej+this.elements[7]*el;eh[4]=-this.elements[4]*ei+this.elements[6]*d8-this.elements[7]*d9;eh[8]=+this.elements[4]*ej-this.elements[5]*d8+this.elements[7]*ea;eh[12]=-this.elements[4]*el+this.elements[5]*d9-this.elements[6]*ea;eh[1]=-this.elements[1]*ei+this.elements[2]*ej-this.elements[3]*el;eh[5]=+this.elements[0]*ei-this.elements[2]*d8+this.elements[3]*d9;eh[9]=-this.elements[0]*ej+this.elements[1]*d8-this.elements[3]*ea;eh[13]=+this.elements[0]*el-this.elements[1]*d9+this.elements[2]*ea;eh[2]=+this.elements[13]*eb-this.elements[14]*ec+this.elements[15]*ed;eh[6]=-this.elements[12]*eb+this.elements[14]*ee-this.elements[15]*ef;eh[10]=+this.elements[12]*ec-this.elements[13]*ee+this.elements[15]*eg;eh[14]=-this.elements[12]*ed+this.elements[13]*ef-this.elements[14]*eg;eh[3]=-this.elements[9]*eb+this.elements[10]*ec-this.elements[11]*ed;eh[7]=+this.elements[8]*eb-this.elements[10]*ee+this.elements[11]*ef;eh[11]=-this.elements[8]*ec+this.elements[9]*ee-this.elements[11]*eg;eh[15]=+this.elements[8]*ed-this.elements[9]*ef+this.elements[10]*eg;var d7=1/ek;eh[0]*=d7;eh[1]*=d7;eh[2]*=d7;eh[3]*=d7;eh[4]*=d7;eh[5]*=d7;eh[6]*=d7;eh[7]*=d7;eh[8]*=d7;eh[9]*=d7;eh[10]*=d7;eh[11]*=d7;eh[12]*=d7;eh[13]*=d7;eh[14]*=d7;eh[15]*=d7;this.elements=eh.slice();return true},toString:function(){var d8="";for(var d7=0;d7<15;d7++){d8+=this.elements[d7]+", "}d8+=this.elements[15];return d8},print:function(){var d8=cl(this.elements);var d7=""+cV.nfs(this.elements[0],d8,4)+" "+cV.nfs(this.elements[1],d8,4)+" "+cV.nfs(this.elements[2],d8,4)+" "+cV.nfs(this.elements[3],d8,4)+"\n"+cV.nfs(this.elements[4],d8,4)+" "+cV.nfs(this.elements[5],d8,4)+" "+cV.nfs(this.elements[6],d8,4)+" "+cV.nfs(this.elements[7],d8,4)+"\n"+cV.nfs(this.elements[8],d8,4)+" "+cV.nfs(this.elements[9],d8,4)+" "+cV.nfs(this.elements[10],d8,4)+" "+cV.nfs(this.elements[11],d8,4)+"\n"+cV.nfs(this.elements[12],d8,4)+" "+cV.nfs(this.elements[13],d8,4)+" "+cV.nfs(this.elements[14],d8,4)+" "+cV.nfs(this.elements[15],d8,4)+"\n\n";cV.println(d7)},invTranslate:function(d8,d7,d9){this.preApply(1,0,0,-d8,0,1,0,-d7,0,0,1,-d9,0,0,0,1)},invRotateX:function(d8){var d9=o.cos(-d8);var d7=o.sin(-d8);this.preApply([1,0,0,0,0,d9,-d7,0,0,d7,d9,0,0,0,0,1])},invRotateY:function(d8){var d9=o.cos(-d8);var d7=o.sin(-d8);this.preApply([d9,0,d7,0,0,1,0,0,-d7,0,d9,0,0,0,0,1])},invRotateZ:function(d8){var d9=o.cos(-d8);var d7=o.sin(-d8);this.preApply([d9,-d7,0,0,d7,d9,0,0,0,0,1,0,0,0,0,1])},invScale:function(d7,d9,d8){this.preApply([1/d7,0,0,0,0,1/d9,0,0,0,0,1/d8,0,0,0,0,1])}};var T=cV.PMatrixStack=function(){this.matrixStack=[]};T.prototype.load=function(){var d7=dU.$newPMatrix();if(arguments.length===1){d7.set(arguments[0])}else{d7.set(arguments)}this.matrixStack.push(d7)};bO.prototype.$newPMatrix=function(){return new aT};by.prototype.$newPMatrix=function(){return new aM};T.prototype.push=function(){this.matrixStack.push(this.peek())};T.prototype.pop=function(){return this.matrixStack.pop()};T.prototype.peek=function(){var d7=dU.$newPMatrix();d7.set(this.matrixStack[this.matrixStack.length-1]);return d7};T.prototype.mult=function(d7){this.matrixStack[this.matrixStack.length-1].apply(d7)};cV.split=function(d8,d7){return d8.split(d7)};cV.splitTokens=function(ea,d9){if(arguments.length===1){d9="\n\t\r\u000c "}d9="["+d9+"]";var d8=[];var d7=0;var eb=ea.search(d9);while(eb>=0){if(eb===0){ea=ea.substring(1)}else{d8[d7]=ea.substring(0,eb);d7++;ea=ea.substring(eb)}eb=ea.search(d9)}if(ea.length>0){d8[d7]=ea}if(d8.length===0){d8=r}return d8};cV.append=function(d8,d7){d8[d8.length]=d7;return d8};cV.concat=function(d8,d7){return d8.concat(d7)};cV.sort=function(ec,ea){var d8=[];if(ec.length>0){var eb=ea>0?ea:ec.length;for(var d9=0;d9<eb;d9++){d8.push(ec[d9])}if(typeof ec[0]==="string"){d8.sort()}else{d8.sort(function(ee,ed){return ee-ed})}if(ea>0){for(var d7=d8.length;d7<ec.length;d7++){d8.push(ec[d7])}}}return d8};cV.splice=function(eb,ea,d8){if(ea.length===0){return eb}if(ea instanceof Array){for(var d9=0,d7=d8;d9<ea.length;d7++,d9++){eb.splice(d7,0,ea[d9])}}else{eb.splice(d8,0,ea)}return eb};cV.subset=function(ea,d9,d8){var d7=d8!==r?d9+d8:ea.length;return ea.slice(d9,d7)};cV.join=function(d8,d7){return d8.join(d7)};cV.shorten=function(ea){var d8=[];var d7=ea.length;for(var d9=0;d9<d7;d9++){d8[d9]=ea[d9]}d8.pop();return d8};cV.expand=function(d9,ea){var d8=d9.slice(0),d7=ea||d9.length*2;d8.length=d7;return d8};cV.arrayCopy=function(){var ed,eb=0,d9,d8=0,ec;if(arguments.length===2){ed=arguments[0];d9=arguments[1];ec=ed.length}else{if(arguments.length===3){ed=arguments[0];d9=arguments[1];ec=arguments[2]}else{if(arguments.length===5){ed=arguments[0];eb=arguments[1];d9=arguments[2];d8=arguments[3];ec=arguments[4]}}}for(var ea=eb,d7=d8;ea<ec+eb;ea++,d7++){if(d9[d7]!==r){d9[d7]=ed[ea]}else{throw"array index out of bounds exception"}}};cV.reverse=function(d7){return d7.reverse()};cV.mix=function(d8,d7,d9){return d8+((d7-d8)*d9>>8)};cV.peg=function(d7){return d7<0?0:d7>255?255:d7};cV.modes=function(){var ec=4278190080,d9=16711680,d8=65280,eb=255,ea=o.min,d7=o.max;function ed(ei,el,eh,eq,es,er,ej,en,em,ef,eg){var ep=ea(((ei&4278190080)>>>24)+el,255)<<24;var ee=eh+((em-eh)*el>>8);ee=(ee<0?0:ee>255?255:ee)<<16;var ek=eq+((ef-eq)*el>>8);ek=(ek<0?0:ek>255?255:ek)<<8;var eo=es+((eg-es)*el>>8);eo=eo<0?0:eo>255?255:eo;return ep|ee|ek|eo}return{replace:function(ef,ee){return ee},blend:function(eg,ef){var ei=(ef&ec)>>>24,ee=eg&d9,ek=eg&d8,em=eg&eb,el=ef&d9,eh=ef&d8,ej=ef&eb;return ea(((eg&ec)>>>24)+ei,255)<<24|ee+((el-ee)*ei>>8)&d9|ek+((eh-ek)*ei>>8)&d8|em+((ej-em)*ei>>8)&eb},add:function(ef,ee){var eg=(ee&ec)>>>24;return ea(((ef&ec)>>>24)+eg,255)<<24|ea((ef&d9)+((ee&d9)>>8)*eg,d9)&d9|ea((ef&d8)+((ee&d8)>>8)*eg,d8)&d8|ea((ef&eb)+((ee&eb)*eg>>8),eb)},subtract:function(ef,ee){var eg=(ee&ec)>>>24;return ea(((ef&ec)>>>24)+eg,255)<<24|d7((ef&d9)-((ee&d9)>>8)*eg,d8)&d9|d7((ef&d8)-((ee&d8)>>8)*eg,eb)&d8|d7((ef&eb)-((ee&eb)*eg>>8),0)},lightest:function(ef,ee){var eg=(ee&ec)>>>24;return ea(((ef&ec)>>>24)+eg,255)<<24|d7(ef&d9,((ee&d9)>>8)*eg)&d9|d7(ef&d8,((ee&d8)>>8)*eg)&d8|d7(ef&eb,(ee&eb)*eg>>8)},darkest:function(eg,ef){var ei=(ef&ec)>>>24,ee=eg&d9,ek=eg&d8,em=eg&eb,el=ea(eg&d9,((ef&d9)>>8)*ei),eh=ea(eg&d8,((ef&d8)>>8)*ei),ej=ea(eg&eb,(ef&eb)*ei>>8);return ea(((eg&ec)>>>24)+ei,255)<<24|ee+((el-ee)*ei>>8)&d9|ek+((eh-ek)*ei>>8)&d8|em+((ej-em)*ei>>8)&eb},difference:function(ei,eh){var ek=(eh&ec)>>>24,eg=(ei&d9)>>16,en=(ei&d8)>>8,ep=ei&eb,eo=(eh&d9)>>16,ej=(eh&d8)>>8,em=eh&eb,el=eg>eo?eg-eo:eo-eg,ee=en>ej?en-ej:ej-en,ef=ep>em?ep-em:em-ep;return ed(ei,ek,eg,en,ep,eo,ej,em,el,ee,ef)},exclusion:function(ei,eh){var ek=(eh&ec)>>>24,eg=(ei&d9)>>16,en=(ei&d8)>>8,ep=ei&eb,eo=(eh&d9)>>16,ej=(eh&d8)>>8,em=eh&eb,el=eg+eo-(eg*eo>>7),ee=en+ej-(en*ej>>7),ef=ep+em-(ep*em>>7);return ed(ei,ek,eg,en,ep,eo,ej,em,el,ee,ef)},multiply:function(ei,eh){var ek=(eh&ec)>>>24,eg=(ei&d9)>>16,en=(ei&d8)>>8,ep=ei&eb,eo=(eh&d9)>>16,ej=(eh&d8)>>8,em=eh&eb,el=eg*eo>>8,ee=en*ej>>8,ef=ep*em>>8;return ed(ei,ek,eg,en,ep,eo,ej,em,el,ee,ef)},screen:function(ei,eh){var ek=(eh&ec)>>>24,eg=(ei&d9)>>16,en=(ei&d8)>>8,ep=ei&eb,eo=(eh&d9)>>16,ej=(eh&d8)>>8,em=eh&eb,el=255-((255-eg)*(255-eo)>>8),ee=255-((255-en)*(255-ej)>>8),ef=255-((255-ep)*(255-em)>>8);return ed(ei,ek,eg,en,ep,eo,ej,em,el,ee,ef)},hard_light:function(ei,eh){var ek=(eh&ec)>>>24,eg=(ei&d9)>>16,en=(ei&d8)>>8,ep=ei&eb,eo=(eh&d9)>>16,ej=(eh&d8)>>8,em=eh&eb,el=eo<128?eg*eo>>7:255-((255-eg)*(255-eo)>>7),ee=ej<128?en*ej>>7:255-((255-en)*(255-ej)>>7),ef=em<128?ep*em>>7:255-((255-ep)*(255-em)>>7);return ed(ei,ek,eg,en,ep,eo,ej,em,el,ee,ef)},soft_light:function(ei,eh){var ek=(eh&ec)>>>24,eg=(ei&d9)>>16,en=(ei&d8)>>8,ep=ei&eb,eo=(eh&d9)>>16,ej=(eh&d8)>>8,em=eh&eb,el=(eg*eo>>7)+(eg*eg>>8)-(eg*eg*eo>>15),ee=(en*ej>>7)+(en*en>>8)-(en*en*ej>>15),ef=(ep*em>>7)+(ep*ep>>8)-(ep*ep*em>>15);return ed(ei,ek,eg,en,ep,eo,ej,em,el,ee,ef)},overlay:function(ei,eh){var ek=(eh&ec)>>>24,eg=(ei&d9)>>16,en=(ei&d8)>>8,ep=ei&eb,eo=(eh&d9)>>16,ej=(eh&d8)>>8,em=eh&eb,el=eg<128?eg*eo>>7:255-((255-eg)*(255-eo)>>7),ee=en<128?en*ej>>7:255-((255-en)*(255-ej)>>7),ef=ep<128?ep*em>>7:255-((255-ep)*(255-em)>>7);return ed(ei,ek,eg,en,ep,eo,ej,em,el,ee,ef)},dodge:function(ei,eh){var ek=(eh&ec)>>>24,eg=(ei&d9)>>16,en=(ei&d8)>>8,ep=ei&eb,eo=(eh&d9)>>16,ej=(eh&d8)>>8,em=eh&eb;var el=255;if(eo!==255){el=(eg<<8)/(255-eo);el=el<0?0:el>255?255:el}var ee=255;if(ej!==255){ee=(en<<8)/(255-ej);ee=ee<0?0:ee>255?255:ee}var ef=255;if(em!==255){ef=(ep<<8)/(255-em);ef=ef<0?0:ef>255?255:ef}return ed(ei,ek,eg,en,ep,eo,ej,em,el,ee,ef)},burn:function(ei,eh){var ek=(eh&ec)>>>24,eg=(ei&d9)>>16,en=(ei&d8)>>8,ep=ei&eb,eo=(eh&d9)>>16,ej=(eh&d8)>>8,em=eh&eb;var el=0;if(eo!==0){el=(255-eg<<8)/eo;el=255-(el<0?0:el>255?255:el)}var ee=0;if(ej!==0){ee=(255-en<<8)/ej;ee=255-(ee<0?0:ee>255?255:ee)}var ef=0;if(em!==0){ef=(255-ep<<8)/em;ef=255-(ef<0?0:ef>255?255:ef)}return ed(ei,ek,eg,en,ep,eo,ej,em,el,ee,ef)}}}();function dD(ec,eb,d9,d8){var d7,ea,ee,ef;if(cX===3){var ed=cV.color.toRGB(ec,eb,d9);d7=ed[0];ea=ed[1];ee=ed[2]}else{d7=o.round(255*(ec/bG));ea=o.round(255*(eb/bF));ee=o.round(255*(d9/bD))}ef=o.round(255*(d8/bR));d7=d7<0?0:d7;ea=ea<0?0:ea;ee=ee<0?0:ee;ef=ef<0?0:ef;d7=d7>255?255:d7;ea=ea>255?255:ea;ee=ee>255?255:ee;ef=ef>255?255:ef;return ef<<24&4278190080|d7<<16&16711680|ea<<8&65280|ee&255}function dG(d7,d9){var d8;if(d7&4278190080){d8=o.round(255*(d9/bR));d8=d8>255?255:d8;d8=d8<0?0:d8;return d7-(d7&4278190080)+(d8<<24&4278190080)}if(cX===1){return dD(d7,d7,d7,d9)}if(cX===3){return dD(0,0,d7/bG*bD,d9)}}function dI(d7){if(d7<=bG&&d7>=0){if(cX===1){return dD(d7,d7,d7,bR)}if(cX===3){return dD(0,0,d7/bG*bD,bR)}}if(d7){if(d7>2147483647){d7-=4294967296}return d7}}cV.color=function(d7,ea,d9,d8){if(d7!==r&&ea!==r&&d9!==r&&d8!==r){return dD(d7,ea,d9,d8)}if(d7!==r&&ea!==r&&d9!==r){return dD(d7,ea,d9,bR)}if(d7!==r&&ea!==r){return dG(d7,ea)}if(typeof d7==="number"){return dI(d7)}return dD(bG,bF,bD,bR)};cV.color.toString=function(d7){return"rgba("+((d7>>16)&255)+","+((d7>>8)&255)+","+(d7&255)+","+((d7>>24)&255)/255+")"};cV.color.toInt=function(ea,d9,d7,d8){return d8<<24&4278190080|ea<<16&16711680|d9<<8&65280|d7&255};cV.color.toArray=function(d7){return[(d7>>16)&255,(d7>>8)&255,d7&255,(d7>>24)&255]};cV.color.toGLArray=function(d7){return[((d7>>16)&255)/255,((d7>>8)&255)/255,(d7&255)/255,((d7&4278190080)>>>24)/255]};cV.color.toRGB=function(d9,ef,ec){d9=d9>bG?bG:d9;ef=ef>bF?bF:ef;ec=ec>bD?bD:ec;d9=d9/bG*360;ef=ef/bF*100;ec=ec/bD*100;var ee=o.round(ec/100*255);if(ef===0){return[ee,ee,ee]}var ea=d9%360;var eb=ea%60;var d8=o.round(ec*(100-ef)/10000*255);var d7=o.round(ec*(6000-ef*eb)/600000*255);var ed=o.round(ec*(6000-ef*(60-eb))/600000*255);switch(o.floor(ea/60)){case 0:return[ee,ed,d8];case 1:return[d7,ee,d8];case 2:return[d8,ee,ed];case 3:return[d8,d7,ee];case 4:return[ed,d8,ee];case 5:return[ee,d8,d7]}};function aP(ee){var ed,ec,d8;ed=((ee>>16)&255)/255;ec=((ee>>8)&255)/255;d8=(ee&255)/255;var d7=cV.max(cV.max(ed,ec),d8),ea=cV.min(cV.min(ed,ec),d8),d9,eb;if(ea===d7){return[0,0,d7*bD]}eb=(d7-ea)/d7;if(ed===d7){d9=(ec-d8)/(d7-ea)}else{if(ec===d7){d9=2+(d8-ed)/(d7-ea)}else{d9=4+(ed-ec)/(d7-ea)}}d9/=6;if(d9<0){d9+=1}else{if(d9>1){d9-=1}}return[d9*bG,eb*bF,d7*bD]}cV.brightness=function(d7){return aP(d7)[2]};cV.saturation=function(d7){return aP(d7)[1]};cV.hue=function(d7){return aP(d7)[0]};cV.red=function(d7){return((d7>>16)&255)/255*bG};cV.green=function(d7){return((d7>>8)&255)/255*bF};cV.blue=function(d7){return(d7&255)/255*bD};cV.alpha=function(d7){return((d7>>24)&255)/255*bR};cV.lerpColor=function(ej,ei,ec){var eh,en,eo,ep,el,d7,ed,er,ek,es,eb,eq;var ef,ee,d8,em,eg;var ea=cV.color(ej);var d9=cV.color(ei);if(cX===3){ef=aP(ea);er=((ea>>24)&255)/bR;ee=aP(d9);eq=((d9>>24)&255)/bR;em=cV.lerp(ef[0],ee[0],ec);eg=cV.lerp(ef[1],ee[1],ec);eo=cV.lerp(ef[2],ee[2],ec);d8=cV.color.toRGB(em,eg,eo);ep=cV.lerp(er,eq,ec)*bR;return ep<<24&4278190080|(d8[0]&255)<<16|(d8[1]&255)<<8|d8[2]&255}el=(ea>>16)&255;d7=(ea>>8)&255;ed=ea&255;er=((ea>>24)&255)/bR;ek=(d9>>16)&255;es=(d9>>8)&255;eb=d9&255;eq=((d9&4278190080)>>>24)/bR;eh=cV.lerp(el,ek,ec)|0;en=cV.lerp(d7,es,ec)|0;eo=cV.lerp(ed,eb,ec)|0;ep=cV.lerp(er,eq,ec)*bR;return ep<<24&4278190080|eh<<16&16711680|en<<8&65280|eo&255};cV.colorMode=function(){cX=arguments[0];if(arguments.length>1){bG=arguments[1];bF=arguments[2]||arguments[1];bD=arguments[3]||arguments[1];bR=arguments[4]||arguments[1]}};cV.blendColor=function(d8,d7,d9){if(d9===0){return cV.modes.replace(d8,d7)}else{if(d9===1){return cV.modes.blend(d8,d7)}else{if(d9===2){return cV.modes.add(d8,d7)}else{if(d9===4){return cV.modes.subtract(d8,d7)}else{if(d9===8){return cV.modes.lightest(d8,d7)}else{if(d9===16){return cV.modes.darkest(d8,d7)}else{if(d9===32){return cV.modes.difference(d8,d7)}else{if(d9===64){return cV.modes.exclusion(d8,d7)}else{if(d9===128){return cV.modes.multiply(d8,d7)}else{if(d9===256){return cV.modes.screen(d8,d7)}else{if(d9===1024){return cV.modes.hard_light(d8,d7)}else{if(d9===2048){return cV.modes.soft_light(d8,d7)}else{if(d9===512){return cV.modes.overlay(d8,d7)}else{if(d9===4096){return cV.modes.dodge(d8,d7)}else{if(d9===8192){return cV.modes.burn(d8,d7)}}}}}}}}}}}}}}}};function aC(){d4.save()}function cO(){d4.restore();b2=true;ap=true}cV.printMatrix=function(){dF.print()};bO.prototype.translate=function(d7,d8){dF.translate(d7,d8);aQ.invTranslate(d7,d8);d4.translate(d7,d8)};by.prototype.translate=function(d7,d9,d8){dF.translate(d7,d9,d8);aQ.invTranslate(d7,d9,d8)};bO.prototype.scale=function(d7,d8){dF.scale(d7,d8);aQ.invScale(d7,d8);d4.scale(d7,d8||d7)};by.prototype.scale=function(d7,d9,d8){dF.scale(d7,d9,d8);aQ.invScale(d7,d9,d8)};bO.prototype.pushMatrix=function(){al.load(dF);c9.load(aQ);aC()};by.prototype.pushMatrix=function(){al.load(dF);c9.load(aQ)};bO.prototype.popMatrix=function(){dF.set(al.pop());aQ.set(c9.pop());cO()};by.prototype.popMatrix=function(){dF.set(al.pop());aQ.set(c9.pop())};bO.prototype.resetMatrix=function(){dF.reset();aQ.reset();d4.setTransform(1,0,0,1,0,0)};by.prototype.resetMatrix=function(){dF.reset();aQ.reset()};dp.prototype.applyMatrix=function(){var d7=arguments;dF.apply(d7[0],d7[1],d7[2],d7[3],d7[4],d7[5],d7[6],d7[7],d7[8],d7[9],d7[10],d7[11],d7[12],d7[13],d7[14],d7[15]);aQ.invApply(d7[0],d7[1],d7[2],d7[3],d7[4],d7[5],d7[6],d7[7],d7[8],d7[9],d7[10],d7[11],d7[12],d7[13],d7[14],d7[15])};bO.prototype.applyMatrix=function(){var d7=arguments;for(var d8=d7.length;d8<16;d8++){d7[d8]=0}d7[10]=d7[15]=1;dp.prototype.applyMatrix.apply(this,d7)};cV.rotateX=function(d7){dF.rotateX(d7);aQ.invRotateX(d7)};bO.prototype.rotateZ=function(){throw"rotateZ() is not supported in 2D mode. Use rotate(float) instead."};by.prototype.rotateZ=function(d7){dF.rotateZ(d7);aQ.invRotateZ(d7)};cV.rotateY=function(d7){dF.rotateY(d7);aQ.invRotateY(d7)};bO.prototype.rotate=function(d7){dF.rotateZ(d7);aQ.invRotateZ(d7);d4.rotate(d7)};by.prototype.rotate=function(d7){cV.rotateZ(d7)};cV.pushStyle=function(){aC();cV.pushMatrix();var d7={doFill:aF,currentFillColor:aX,doStroke:cd,currentStrokeColor:cu,curTint:bb,curRectMode:bI,curColorMode:cX,colorModeX:bG,colorModeZ:bD,colorModeY:bF,colorModeA:bR,curTextFont:U,horizontalTextAlignment:L,verticalTextAlignment:c0,textMode:cH,curFontName:W,curTextSize:dW,curTextAscent:aZ,curTextDescent:dx,curTextLeading:d3};bj.push(d7)};cV.popStyle=function(){var d7=bj.pop();if(d7){cO();cV.popMatrix();aF=d7.doFill;aX=d7.currentFillColor;cd=d7.doStroke;cu=d7.currentStrokeColor;bb=d7.curTint;bI=d7.curRectmode;cX=d7.curColorMode;bG=d7.colorModeX;bD=d7.colorModeZ;bF=d7.colorModeY;bR=d7.colorModeA;U=d7.curTextFont;W=d7.curFontName;dW=d7.curTextSize;L=d7.horizontalTextAlignment;c0=d7.verticalTextAlignment;cH=d7.textMode;aZ=d7.curTextAscent;dx=d7.curTextDescent;d3=d7.curTextLeading}else{throw"Too many popStyle() without enough pushStyle()"}};cV.year=function(){return(new Date).getFullYear()};cV.month=function(){return(new Date).getMonth()+1};cV.day=function(){return(new Date).getDate()};cV.hour=function(){return(new Date).getHours()};cV.minute=function(){return(new Date).getMinutes()};cV.second=function(){return(new Date).getSeconds()};cV.millis=function(){return Date.now()-dm};function cs(){var d7=(Date.now()-dq)/1000;N++;var d8=N/d7;if(d7>0.5){dq=Date.now();N=0;cV.__frameRate=d8}cV.frameCount++}bO.prototype.redraw=function(){cs();d4.lineWidth=dS;var d7=cV.pmouseX,d8=cV.pmouseY;cV.pmouseX=dJ;cV.pmouseY=d1;aC();cV.draw();cO();dJ=cV.mouseX;d1=cV.mouseY;cV.pmouseX=d7;cV.pmouseY=d8};by.prototype.redraw=function(){cs();var d7=cV.pmouseX,d8=cV.pmouseY;cV.pmouseX=dJ;cV.pmouseY=d1;d4.clear(d4.DEPTH_BUFFER_BIT);dz={attributes:{},locations:{}};cV.noLights();cV.lightFalloff(1,0,0);cV.shininess(1);cV.ambient(255,255,255);cV.specular(0,0,0);cV.emissive(0,0,0);cV.camera();cV.draw();dJ=cV.mouseX;d1=cV.mouseY;cV.pmouseX=d7;cV.pmouseY=d8};cV.noLoop=function(){aB=false;aw=false;clearInterval(b3);cP.onPause()};cV.loop=function(){if(aw){return}dq=Date.now();N=0;b3=B.setInterval(function(){try{cP.onFrameStart();cV.redraw();cP.onFrameEnd()}catch(d7){B.clearInterval(b3);throw d7}},ay);aB=true;aw=true;cP.onLoop()};cV.frameRate=function(d7){dQ=d7;ay=1000/dQ;if(aB){cV.noLoop();cV.loop()}};var at=[];function bM(d9,d8,d7){if(d9.addEventListener){d9.addEventListener(d8,d7,false)}else{d9.attachEvent("on"+d8,d7)}at.push({elem:d9,type:d8,fn:d7})}function dd(d7){var ea=d7.elem,d9=d7.type,d8=d7.fn;if(ea.removeEventListener){ea.removeEventListener(d9,d8,false)}else{if(ea.detachEvent){ea.detachEvent("on"+d9,d8)}}}cV.exit=function(){B.clearInterval(b3);J(cV.externals.canvas.id);for(var d8 in D.lib){if(D.lib.hasOwnProperty(d8)){if(D.lib[d8].hasOwnProperty("detach")){D.lib[d8].detach(cV)}}}var d7=at.length;while(d7--){dd(at[d7])}cP.onExit()};cV.cursor=function(){if(arguments.length>1||arguments.length===1&&arguments[0] instanceof cV.PImage){var ea=arguments[0],d7,ec;if(arguments.length>=3){d7=arguments[1];ec=arguments[2];if(d7<0||ec<0||ec>=ea.height||d7>=ea.width){throw"x and y must be non-negative and less than the dimensions of the image"}}else{d7=ea.width>>>1;ec=ea.height>>>1}var d8=ea.toDataURL();var d9='url("'+d8+'") '+d7+" "+ec+", default";X=ac.style.cursor=d9}else{if(arguments.length===1){var eb=arguments[0];X=ac.style.cursor=eb}else{X=ac.style.cursor=cj}}};cV.noCursor=function(){X=ac.style.cursor=z.NOCURSOR};cV.link=function(d7,d8){if(d8!==r){B.open(d7,d8)}else{B.location=d7}};cV.beginDraw=E;cV.endDraw=E;bO.prototype.toImageData=function(d7,ea,d8,d9){d7=d7!==r?d7:0;ea=ea!==r?ea:0;d8=d8!==r?d8:cV.width;d9=d9!==r?d9:cV.height;return d4.getImageData(d7,ea,d8,d9)};by.prototype.toImageData=function(ef,ee,eg,eb){ef=ef!==r?ef:0;ee=ee!==r?ee:0;eg=eg!==r?eg:cV.width;eb=eb!==r?eb:cV.height;var ed=d.createElement("canvas"),eh=ed.getContext("2d"),ea=eh.createImageData(eg,eb),d8=new b(eg*eb*4);d4.readPixels(ef,ee,eg,eb,d4.RGBA,d4.UNSIGNED_BYTE,d8);for(var d9=0,ec=d8.length,d7=ea.data;d9<ec;d9++){d7[d9]=d8[(eb-1-o.floor(d9/4/eg))*eg*4+d9%(eg*4)]}return ea};cV.status=function(d7){B.status=d7};cV.binary=function(d8,d9){var ea;if(d9>0){ea=d9}else{if(d8 instanceof bN){ea=16;d8|=0}else{ea=32;while(ea>1&&!(d8>>>ea-1&1)){ea--}}}var d7="";while(ea>0){d7+=d8>>>--ea&1?"1":"0"}return d7};cV.unbinary=function(d8){var ea=d8.length-1,d9=1,d7=0;while(ea>=0){var eb=d8[ea--];if(eb!=="0"&&eb!=="1"){throw"the value passed into unbinary was not an 8 bit binary number"}if(eb==="1"){d7+=d9}d9<<=1}return d7};function cW(ej,eh,eb,em,ed,ek){var d9=ej<0?eb:eh;var d8=ed===0;var ei=ed===r||ed<0?0:ed;var eg=o.abs(ej);if(d8){ei=1;eg*=10;while(o.abs(o.round(eg)-eg)>0.000001&&ei<7){++ei;eg*=10}}else{if(ei!==0){eg*=o.pow(10,ei)}}var ea,ef=eg*2;if(o.floor(eg)===eg){ea=eg}else{if(o.floor(ef)===ef){var d7=o.floor(eg);ea=d7+d7%2}else{ea=o.round(eg)}}var ec="";var el=em+ei;while(el>0||ea>0){el--;ec=""+ea%10+ec;ea=o.floor(ea/10)}if(ek!==r){var ee=ec.length-3-ei;while(ee>0){ec=ec.substring(0,ee)+ek+ec.substring(ee);ee-=3}}if(ei>0){return d9+ec.substring(0,ec.length-ei)+"."+ec.substring(ec.length-ei,ec.length)}return d9+ec}function an(ed,ec,d7,ef,d8,ee){if(ed instanceof Array){var ea=[];for(var d9=0,eb=ed.length;d9<eb;d9++){ea.push(cW(ed[d9],ec,d7,ef,d8,ee))}return ea}return cW(ed,ec,d7,ef,d8,ee)}cV.nf=function(d9,d7,d8){return an(d9,"","-",d7,d8)};cV.nfs=function(d9,d7,d8){return an(d9," ","-",d7,d8)};cV.nfp=function(d9,d7,d8){return an(d9,"+","-",d7,d8)};cV.nfc=function(d9,d7,d8){return an(d9,"","-",d7,d8,",")};var aK=function(d9,d8){d8=d8===r||d8===null?d8=8:d8;if(d9<0){d9=4294967295+d9+1}var d7=Number(d9).toString(16).toUpperCase();while(d7.length<d8){d7="0"+d7}if(d7.length>=d8){d7=d7.substring(d7.length-d8,d7.length)}return d7};cV.hex=function(d8,d7){if(arguments.length===1){if(d8 instanceof bN){d7=4}else{d7=8}}return aK(d8,d7)};function dB(d7){var d8=parseInt("0x"+d7,16);if(d8>2147483647){d8-=4294967296}return d8}cV.unhex=function(d9){if(d9 instanceof Array){var d7=[];for(var d8=0;d8<d9.length;d8++){d7.push(dB(d9[d8]))}return d7}return dB(d9)};cV.loadStrings=function(d8){if(localStorage[d8]){return localStorage[d8].split("\n")}var d7=u(d8);if(typeof d7!=="string"||d7===""){return[]}d7=d7.replace(/(\r\n?)/g,"\n").replace(/\n$/,"");return d7.split("\n")};cV.saveStrings=function(d8,d7){localStorage[d8]=d7.join("\n")};cV.loadBytes=function(d9){var d8=u(d9);var d7=[];for(var ea=0;ea<d8.length;ea++){d7.push(d8.charCodeAt(ea))}return d7};function a8(d7){return Array.prototype.slice.call(d7,1)}cV.matchAll=function(d8,d7){var ea=[],d9;var eb=new RegExp(d7,"g");while((d9=eb.exec(d8))!==null){ea.push(d9);if(d9[0].length===0){++eb.lastIndex}}return ea.length>0?ea:null};cV.__contains=function(d8,d7){if(typeof d8!=="string"){return d8.contains.apply(d8,a8(arguments))}return d8!==null&&d7!==null&&typeof d7==="string"&&d8.indexOf(d7)>-1};cV.__replaceAll=function(d7,d9,d8){if(typeof d7!=="string"){return d7.replaceAll.apply(d7,a8(arguments))}return d7.replace(new RegExp(d9,"g"),d8)};cV.__replaceFirst=function(d7,d9,d8){if(typeof d7!=="string"){return d7.replaceFirst.apply(d7,a8(arguments))}return d7.replace(new RegExp(d9,""),d8)};cV.__replace=function(ea,ec,eb){if(typeof ea!=="string"){return ea.replace.apply(ea,a8(arguments))}if(ec instanceof RegExp){return ea.replace(ec,eb)}if(typeof ec!=="string"){ec=ec.toString()}if(ec===""){return ea}var d9=ea.indexOf(ec);if(d9<0){return ea}var d8=0,d7="";do{d7+=ea.substring(d8,d9)+eb;d8=d9+ec.length}while((d9=ea.indexOf(ec,d8))>=0);return d7+ea.substring(d8)};cV.__equals=function(d8,d7){if(d8.equals instanceof Function){return d8.equals.apply(d8,a8(arguments))}return d8.valueOf()===d7.valueOf()};cV.__equalsIgnoreCase=function(d8,d7){if(typeof d8!=="string"){return d8.equalsIgnoreCase.apply(d8,a8(arguments))}return d8.toLowerCase()===d7.toLowerCase()};cV.__toCharArray=function(d9){if(typeof d9!=="string"){return d9.toCharArray.apply(d9,a8(arguments))}var ea=[];for(var d8=0,d7=d9.length;d8<d7;++d8){ea[d8]=new bN(d9.charAt(d8))}return ea};cV.__split=function(ea,eb,d8){if(typeof ea!=="string"){return ea.split.apply(ea,a8(arguments))}var ed=new RegExp(eb);if(d8===r||d8<1){return ea.split(ed)}var d7=[],ec=ea,ee;while((ee=ec.search(ed))!==-1&&d7.length<d8-1){var d9=ed.exec(ec).toString();d7.push(ec.substring(0,ee));ec=ec.substring(ee+d9.length)}if(ee!==-1||ec!==""){d7.push(ec)}return d7};cV.__codePointAt=function(ea,d8){var eb=ea.charCodeAt(d8),d9,d7;if(55296<=eb&&eb<=56319){d9=eb;d7=ea.charCodeAt(d8+1);return(d9-55296)*1024+(d7-56320)+65536}return eb};cV.match=function(d8,d7){return d8.match(d7)};cV.__startsWith=function(d7,d9,d8){if(typeof d7!=="string"){return d7.startsWith.apply(d7,a8(arguments))}d8=d8||0;if(d8<0||d8>d7.length){return false}return d9===""||d9===d7?true:d7.indexOf(d9)===d8};cV.__endsWith=function(d8,d9){if(typeof d8!=="string"){return d8.endsWith.apply(d8,a8(arguments))}var d7=d9?d9.length:0;return d9===""||d9===d8?true:d8.indexOf(d9)===d8.length-d7};cV.__hashCode=function(d7){if(d7.hashCode instanceof Function){return d7.hashCode.apply(d7,a8(arguments))}return h(d7)};cV.__printStackTrace=function(d7){cV.println("Exception: "+d7.toString())};var d6=[];cV.println=function(d7){var d8=d6.length;if(d8){D.logger.log(d6.join(""));d6.length=0}if(arguments.length===0&&d8===0){D.logger.log("")}else{if(arguments.length!==0){D.logger.log(d7)}}};cV.print=function(d7){d6.push(d7)};cV.str=function(d9){if(d9 instanceof Array){var d7=[];for(var d8=0;d8<d9.length;d8++){d7.push(d9[d8].toString()+"")}return d7}return d9.toString()+""};cV.trim=function(d9){if(d9 instanceof Array){var d7=[];for(var d8=0;d8<d9.length;d8++){d7.push(d9[d8].replace(/^\s*/,"").replace(/\s*$/,"").replace(/\r*$/,""))}return d7}return d9.replace(/^\s*/,"").replace(/\s*$/,"").replace(/\r*$/,"")};function aO(d7){if(typeof d7==="number"){return d7!==0}if(typeof d7==="boolean"){return d7}if(typeof d7==="string"){return d7.toLowerCase()==="true"}if(d7 instanceof bN){return d7.code===49||d7.code===84||d7.code===116}}cV.parseBoolean=function(d9){if(d9 instanceof Array){var d7=[];for(var d8=0;d8<d9.length;d8++){d7.push(aO(d9[d8]))}return d7}return aO(d9)};cV.parseByte=function(d9){if(d9 instanceof Array){var d7=[];for(var d8=0;d8<d9.length;d8++){d7.push(0-(d9[d8]&128)|d9[d8]&127)}return d7}return 0-(d9&128)|d9&127};cV.parseChar=function(d9){if(typeof d9==="number"){return new bN(String.fromCharCode(d9&65535))}if(d9 instanceof Array){var d7=[];for(var d8=0;d8<d9.length;d8++){d7.push(new bN(String.fromCharCode(d9[d8]&65535)))}return d7}throw"char() may receive only one argument of type int, byte, int[], or byte[]."};function cN(d7){if(typeof d7==="number"){return d7}if(typeof d7==="boolean"){return d7?1:0}if(typeof d7==="string"){return parseFloat(d7)}if(d7 instanceof bN){return d7.code}}cV.parseFloat=function(d9){if(d9 instanceof Array){var d7=[];for(var d8=0;d8<d9.length;d8++){d7.push(cN(d9[d8]))}return d7}return cN(d9)};function ak(d9,d7){if(typeof d9==="number"){return d9&4294967295}if(typeof d9==="boolean"){return d9?1:0}if(typeof d9==="string"){var d8=parseInt(d9,d7||10);return d8&4294967295}if(d9 instanceof bN){return d9.code}}cV.parseInt=function(ea,d9){if(ea instanceof Array){var d7=[];for(var d8=0;d8<ea.length;d8++){if(typeof ea[d8]==="string"&&!/^\s*[+\-]?\d+\s*$/.test(ea[d8])){d7.push(0)}else{d7.push(ak(ea[d8],d9))}}return d7}return ak(ea,d9)};cV.__int_cast=function(d7){return 0|d7};cV.__instanceof=function(d9,d8){if(typeof d8!=="function"){throw"Function is expected as type argument for instanceof operator"}if(typeof d9==="string"){return d8===Object||d8===String}if(d9 instanceof d8){return true}if(typeof d9!=="object"||d9===null){return false}var eb=d9.constructor;if(d8.$isInterface){var ea=[];while(eb){if(eb.$interfaces){ea=ea.concat(eb.$interfaces)}eb=eb.$base}while(ea.length>0){var d7=ea.shift();if(d7===d8){return true}if(d7.$interfaces){ea=ea.concat(d7.$interfaces)}}return false}while(eb.hasOwnProperty("$base")){eb=eb.$base;if(eb===d8){return true}}return false};cV.abs=o.abs;cV.ceil=o.ceil;cV.constrain=function(d8,d9,d7){return d8>d7?d7:d8<d9?d9:d8};cV.dist=function(){var d9,d8,d7;if(arguments.length===4){d9=arguments[0]-arguments[2];d8=arguments[1]-arguments[3];return o.sqrt(d9*d9+d8*d8)}if(arguments.length===6){d9=arguments[0]-arguments[3];d8=arguments[1]-arguments[4];d7=arguments[2]-arguments[5];return o.sqrt(d9*d9+d8*d8+d7*d7)}};cV.exp=o.exp;cV.floor=o.floor;cV.lerp=function(d8,d7,d9){return(d7-d8)*d9+d8};cV.log=o.log;cV.mag=function(d8,d7,d9){if(d9){return o.sqrt(d8*d8+d7*d7+d9*d9)}return o.sqrt(d8*d8+d7*d7)};cV.map=function(ea,d8,d9,d7,eb){return d7+(eb-d7)*((ea-d8)/(d9-d8))};cV.max=function(){if(arguments.length===2){return arguments[0]<arguments[1]?arguments[1]:arguments[0]}var d8=arguments.length===1?arguments[0]:arguments;if(!("length" in d8&&d8.length>0)){throw"Non-empty array is expected"}var d7=d8[0],ea=d8.length;for(var d9=1;d9<ea;++d9){if(d7<d8[d9]){d7=d8[d9]}}return d7};cV.min=function(){if(arguments.length===2){return arguments[0]<arguments[1]?arguments[0]:arguments[1]}var d7=arguments.length===1?arguments[0]:arguments;if(!("length" in d7&&d7.length>0)){throw"Non-empty array is expected"}var d9=d7[0],ea=d7.length;for(var d8=1;d8<ea;++d8){if(d9>d7[d8]){d9=d7[d8]}}return d9};cV.norm=function(d8,d7,d9){return(d8-d7)/(d9-d7)};cV.pow=o.pow;cV.round=o.round;cV.sq=function(d7){return d7*d7};cV.sqrt=o.sqrt;cV.acos=o.acos;cV.asin=o.asin;cV.atan=o.atan;cV.atan2=o.atan2;cV.cos=o.cos;cV.degrees=function(d7){return d7*180/o.PI};cV.radians=function(d7){return d7/180*o.PI};cV.sin=o.sin;cV.tan=o.tan;var bW=o.random;cV.random=function(){if(arguments.length===0){return bW()}if(arguments.length===1){return bW()*arguments[0]}var d8=arguments[0],d7=arguments[1];return bW()*(d7-d8)+d8};function cn(d9,d8){var eb=d9||362436069,d7=d8||521288629;var ea=function(){eb=36969*(eb&65535)+(eb>>>16)&4294967295;d7=18000*(d7&65535)+(d7>>>16)&4294967295;return((eb&65535)<<16|d7&65535)&4294967295};this.nextDouble=function(){var ec=ea()/4294967296;return ec<0?1+ec:ec};this.nextInt=ea}cn.createRandomized=function(){var d7=new Date;return new cn(d7/60000&4294967295,d7&4294967295)};cV.randomSeed=function(d7){bW=(new cn(d7)).nextDouble};cV.Random=function(d7){var ea=false,d8,d9;this.nextGaussian=function(){if(ea){ea=false;return d8}var ee,ec,eb;do{ee=2*d9()-1;ec=2*d9()-1;eb=ee*ee+ec*ec}while(eb>=1||eb===0);var ed=o.sqrt(-2*o.log(eb)/eb);d8=ec*ed;ea=true;return ee*ed};d9=d7===r?o.random:(new cn(d7)).nextDouble};function dw(ee){var d8=ee!==r?new cn(ee):cn.createRandomized();var ed,eb;var ea=new b(512);for(ed=0;ed<256;++ed){ea[ed]=ed}for(ed=0;ed<256;++ed){var eg=ea[eb=d8.nextInt()&255];ea[eb]=ea[ed];ea[ed]=eg}for(ed=0;ed<256;++ed){ea[ed+256]=ea[ed]}function d7(ek,eh,en,em){var el=ek&15;var ej=el<8?eh:en,ei=el<4?en:el===12||el===14?eh:em;return((el&1)===0?ej:-ej)+((el&2)===0?ei:-ei)}function ec(ej,eh,ek){var ei=(ej&1)===0?eh:ek;return(ej&2)===0?-ei:ei}function ef(ei,eh){return(ei&1)===0?-eh:eh}function d9(ej,ei,eh){return ei+ej*(eh-ei)}this.noise3d=function(et,es,er){var ek=o.floor(et)&255,ei=o.floor(es)&255,eh=o.floor(er)&255;et-=o.floor(et);es-=o.floor(es);er-=o.floor(er);var eo=(3-2*et)*et*et,en=(3-2*es)*es*es,em=(3-2*er)*er*er;var ev=ea[ek]+ei,eq=ea[ev]+eh,ep=ea[ev+1]+eh,eu=ea[ek+1]+ei,el=ea[eu]+eh,ej=ea[eu+1]+eh;return d9(em,d9(en,d9(eo,d7(ea[eq],et,es,er),d7(ea[el],et-1,es,er)),d9(eo,d7(ea[ep],et,es-1,er),d7(ea[ej],et-1,es-1,er))),d9(en,d9(eo,d7(ea[eq+1],et,es,er-1),d7(ea[el+1],et-1,es,er-1)),d9(eo,d7(ea[ep+1],et,es-1,er-1),d7(ea[ej+1],et-1,es-1,er-1))))};this.noise2d=function(eh,eo){var en=o.floor(eh)&255,el=o.floor(eo)&255;eh-=o.floor(eh);eo-=o.floor(eo);var ej=(3-2*eh)*eh*eh,ei=(3-2*eo)*eo*eo;var em=ea[en]+el,ek=ea[en+1]+el;return d9(ei,d9(ej,ec(ea[em],eh,eo),ec(ea[ek],eh-1,eo)),d9(ej,ec(ea[em+1],eh,eo-1),ec(ea[ek+1],eh-1,eo-1)))};this.noise1d=function(eh){var ej=o.floor(eh)&255;eh-=o.floor(eh);var ei=(3-2*eh)*eh*eh;return d9(ei,ef(ea[ej],eh),ef(ea[ej+1],eh-1))}}var bU={generator:r,octaves:4,fallout:0.5,seed:r};cV.noise=function(d7,ee,ed){if(bU.generator===r){bU.generator=new dw(bU.seed)}var ec=bU.generator;var eb=1,d8=1,ea=0;for(var d9=0;d9<bU.octaves;++d9){eb*=bU.fallout;switch(arguments.length){case 1:ea+=eb*(1+ec.noise1d(d8*d7))/2;break;case 2:ea+=eb*(1+ec.noise2d(d8*d7,d8*ee))/2;break;case 3:ea+=eb*(1+ec.noise3d(d8*d7,d8*ee,d8*ed))/2;break}d8*=2}return ea};cV.noiseDetail=function(d8,d7){bU.octaves=d8;if(d7!==r){bU.fallout=d7}};cV.noiseSeed=function(d7){bU.seed=d7;bU.generator=r};dp.prototype.size=function(d8,eb,ea){if(cd){cV.stroke(0)}if(aF){cV.fill(255)}var d9={fillStyle:d4.fillStyle,strokeStyle:d4.strokeStyle,lineCap:d4.lineCap,lineJoin:d4.lineJoin};if(ac.style.length>0){ac.style.removeProperty("width");ac.style.removeProperty("height")}ac.width=cV.width=d8||100;ac.height=cV.height=eb||100;for(var ec in d9){if(d9.hasOwnProperty(ec)){d4[ec]=d9[ec]}}cV.textFont(U);cV.background();bY=o.max(1000,d8*eb*0.05);cV.externals.context=d4;for(var d7=0;d7<720;d7++){ag[d7]=cV.sin(d7*(o.PI/180)*0.5);bi[d7]=cV.cos(d7*(o.PI/180)*0.5)}};bO.prototype.size=function(d7,d9,d8){if(d4===r){d4=ac.getContext("2d");al=new T;c9=new T;dF=new aT;aQ=new aT}dp.prototype.size.apply(this,arguments)};by.prototype.size=function(){var d8=false;return function d7(ea,ec,eb){if(d8){throw"Multiple calls to size() for 3D renders are not allowed."}d8=true;function ed(ef){var ei=["experimental-webgl","webgl","webkit-3d"],eh;for(var eg=0,ee=ei.length;eg<ee;eg++){eh=ef.getContext(ei[eg],{antialias:false});if(eh){break}}return eh}try{ac.width=cV.width=ea||100;ac.height=cV.height=ec||100;d4=ed(ac);c6=d4.createTexture();bP=d4.createTexture()}catch(d9){D.debug(d9)}if(!d4){throw"WebGL context is not supported on this browser."}d4.viewport(0,0,ac.width,ac.height);d4.enable(d4.DEPTH_TEST);d4.enable(d4.BLEND);d4.blendFunc(d4.SRC_ALPHA,d4.ONE_MINUS_SRC_ALPHA);dM=bC(d4,ad,bX);bQ=bC(d4,bS,bf);cV.strokeWeight(1);du=bC(d4,d5,bH);d4.useProgram(du);dV("usingTexture3d",du,"usingTexture",dP);cV.lightFalloff(1,0,0);cV.shininess(1);cV.ambient(255,255,255);cV.specular(0,0,0);cV.emissive(0,0,0);bd=d4.createBuffer();d4.bindBuffer(d4.ARRAY_BUFFER,bd);d4.bufferData(d4.ARRAY_BUFFER,df,d4.STATIC_DRAW);cI=d4.createBuffer();d4.bindBuffer(d4.ARRAY_BUFFER,cI);d4.bufferData(d4.ARRAY_BUFFER,de,d4.STATIC_DRAW);di=d4.createBuffer();d4.bindBuffer(d4.ARRAY_BUFFER,di);d4.bufferData(d4.ARRAY_BUFFER,bE,d4.STATIC_DRAW);aA=d4.createBuffer();d4.bindBuffer(d4.ARRAY_BUFFER,aA);d4.bufferData(d4.ARRAY_BUFFER,aj,d4.STATIC_DRAW);b1=d4.createBuffer();d4.bindBuffer(d4.ARRAY_BUFFER,b1);d4.bufferData(d4.ARRAY_BUFFER,ah,d4.STATIC_DRAW);bc=d4.createBuffer();b7=d4.createBuffer();ar=d4.createBuffer();aE=d4.createBuffer();bz=d4.createBuffer();ae=d4.createBuffer();av=d4.createBuffer();d4.bindBuffer(d4.ARRAY_BUFFER,av);d4.bufferData(d4.ARRAY_BUFFER,new e([0,0,0]),d4.STATIC_DRAW);cG=d4.createBuffer();d4.bindBuffer(d4.ARRAY_BUFFER,cG);d4.bufferData(d4.ARRAY_BUFFER,new e([1,1,0,-1,1,0,-1,-1,0,1,-1,0]),d4.STATIC_DRAW);aa=d4.createBuffer();d4.bindBuffer(d4.ARRAY_BUFFER,aa);d4.bufferData(d4.ARRAY_BUFFER,new e([0,0,1,0,1,1,0,1]),d4.STATIC_DRAW);P=d4.createBuffer();d4.bindBuffer(d4.ELEMENT_ARRAY_BUFFER,P);d4.bufferData(d4.ELEMENT_ARRAY_BUFFER,new w([0,1,2,2,3,0]),d4.STATIC_DRAW);bT=new aM;cg=new aM;dF=new aM;aQ=new aM;da=new aM;cV.camera();cV.perspective();al=new T;c9=new T;c2=new aM;aN=new aM;aJ=new aM;bw=new aM;cc=new aM;S=new aM;S.set(-1,3,-3,1,3,-6,3,0,-3,3,0,0,1,0,0,0);dp.prototype.size.apply(this,arguments)}}();bO.prototype.ambientLight=dp.prototype.a3DOnlyFunction;by.prototype.ambientLight=function(d7,ea,ef,eg,ec,eb){if(dH===8){throw"can only create "+8+" lights"}var ed=new y(eg,ec,eb);var ee=new aM;ee.scale(1,-1,1);ee.apply(dF.array());ee.mult(ed,ed);var d8=dD(d7,ea,ef,0);var d9=[((d8>>16)&255)/255,((d8&65280)>>>8)/255,(d8&255)/255];d4.useProgram(du);dY("lights.color.3d."+dH,du,"lights"+dH+".color",d9);dY("lights.position.3d."+dH,du,"lights"+dH+".position",ed.array());dV("lights.type.3d."+dH,du,"lights"+dH+".type",0);dV("lightCount3d",du,"lightCount",++dH)};bO.prototype.directionalLight=dp.prototype.a3DOnlyFunction;by.prototype.directionalLight=function(d7,ed,ef,ee,ec,eb){if(dH===8){throw"can only create "+8+" lights"}d4.useProgram(du);var eg=new aM;eg.scale(1,-1,1);eg.apply(dF.array());eg=eg.array();var d9=[eg[0]*ee+eg[4]*ec+eg[8]*eb,eg[1]*ee+eg[5]*ec+eg[9]*eb,eg[2]*ee+eg[6]*ec+eg[10]*eb];var d8=dD(d7,ed,ef,0);var ea=[((d8>>16)&255)/255,((d8>>8)&255)/255,(d8&255)/255];dY("lights.color.3d."+dH,du,"lights"+dH+".color",ea);dY("lights.position.3d."+dH,du,"lights"+dH+".position",d9);dV("lights.type.3d."+dH,du,"lights"+dH+".type",1);dV("lightCount3d",du,"lightCount",++dH)};bO.prototype.lightFalloff=dp.prototype.a3DOnlyFunction;by.prototype.lightFalloff=function(d8,d7,d9){d4.useProgram(du);dY("falloff3d",du,"falloff",[d8,d7,d9])};bO.prototype.lightSpecular=dp.prototype.a3DOnlyFunction;by.prototype.lightSpecular=function(eb,ea,d7){var d8=dD(eb,ea,d7,0);var d9=[((d8>>16)&255)/255,((d8>>8)&255)/255,(d8&255)/255];d4.useProgram(du);dY("specular3d",du,"specular",d9)};cV.lights=function(){cV.ambientLight(128,128,128);cV.directionalLight(128,128,128,0,0,-1);cV.lightFalloff(1,0,0);cV.lightSpecular(0,0,0)};bO.prototype.pointLight=dp.prototype.a3DOnlyFunction;by.prototype.pointLight=function(d7,ea,ef,eg,ec,eb){if(dH===8){throw"can only create "+8+" lights"}var ed=new y(eg,ec,eb);var ee=new aM;ee.scale(1,-1,1);ee.apply(dF.array());ee.mult(ed,ed);var d8=dD(d7,ea,ef,0);var d9=[((d8>>16)&255)/255,((d8>>8)&255)/255,(d8&255)/255];d4.useProgram(du);dY("lights.color.3d."+dH,du,"lights"+dH+".color",d9);dY("lights.position.3d."+dH,du,"lights"+dH+".position",ed.array());dV("lights.type.3d."+dH,du,"lights"+dH+".type",2);dV("lightCount3d",du,"lightCount",++dH)};bO.prototype.noLights=dp.prototype.a3DOnlyFunction;by.prototype.noLights=function(){dH=0;d4.useProgram(du);dV("lightCount3d",du,"lightCount",dH)};bO.prototype.spotLight=dp.prototype.a3DOnlyFunction;by.prototype.spotLight=function(d7,ef,ek,el,ej,eh,eg,ee,ec,eb,ed){if(dH===8){throw"can only create "+8+" lights"}d4.useProgram(du);var ei=new y(el,ej,eh);var em=new aM;em.scale(1,-1,1);em.apply(dF.array());em.mult(ei,ei);em=em.array();var d9=[em[0]*eg+em[4]*ee+em[8]*ec,em[1]*eg+em[5]*ee+em[9]*ec,em[2]*eg+em[6]*ee+em[10]*ec];var d8=dD(d7,ef,ek,0);var ea=[((d8>>16)&255)/255,((d8>>8)&255)/255,(d8&255)/255];dY("lights.color.3d."+dH,du,"lights"+dH+".color",ea);dY("lights.position.3d."+dH,du,"lights"+dH+".position",ei.array());dY("lights.direction.3d."+dH,du,"lights"+dH+".direction",d9);dY("lights.concentration.3d."+dH,du,"lights"+dH+".concentration",ed);dY("lights.angle.3d."+dH,du,"lights"+dH+".angle",eb);dV("lights.type.3d."+dH,du,"lights"+dH+".type",3);dV("lightCount3d",du,"lightCount",++dH)};bO.prototype.beginCamera=function(){throw"beginCamera() is not available in 2D mode"};by.prototype.beginCamera=function(){if(ao){throw"You cannot call beginCamera() again before calling endCamera()"}ao=true;dF=cg;aQ=bT};bO.prototype.endCamera=function(){throw"endCamera() is not available in 2D mode"};by.prototype.endCamera=function(){if(!ao){throw"You cannot call endCamera() before calling beginCamera()"}dF.set(bT);aQ.set(cg);ao=false};cV.camera=function(ei,eh,ef,ed,eb,ea,eq,eo,em){if(ei===r){dj=cV.width/2;dh=cV.height/2;dg=dh/o.tan(cJ/2);ei=dj;eh=dh;ef=dg;ed=dj;eb=dh;ea=0;eq=0;eo=1;em=0}var ec=new y(ei-ed,eh-eb,ef-ea);var ee=new y(eq,eo,em);ec.normalize();var eg=y.cross(ee,ec);ee=y.cross(ec,eg);eg.normalize();ee.normalize();var er=eg.x,ep=eg.y,en=eg.z;var d9=ee.x,d8=ee.y,d7=ee.z;var el=ec.x,ek=ec.y,ej=ec.z;bT.set(er,ep,en,0,d9,d8,d7,0,el,ek,ej,0,0,0,0,1);bT.translate(-ei,-eh,-ef);cg.reset();cg.invApply(er,ep,en,0,d9,d8,d7,0,el,ek,ej,0,0,0,0,1);cg.translate(ei,eh,ef);dF.set(bT);aQ.set(cg)};cV.perspective=function(eb,d9,ec,d8){if(arguments.length===0){dh=ac.height/2;dg=dh/o.tan(cJ/2);aW=dg/10;au=dg*10;b4=cV.width/cV.height;eb=cJ;d9=b4;ec=aW;d8=au}var ed,d7,ee,ea;ed=ec*o.tan(eb/2);d7=-ed;ee=ed*d9;ea=d7*d9;cV.frustum(ea,ee,d7,ed,ec,d8)};bO.prototype.frustum=function(){throw"Processing.js: frustum() is not supported in 2D mode"};by.prototype.frustum=function(ed,d9,d8,ec,eb,d7){ch=true;da=new aM;da.set(2*eb/(d9-ed),0,(d9+ed)/(d9-ed),0,0,2*eb/(ec-d8),(ec+d8)/(ec-d8),0,0,0,-(d7+eb)/(d7-eb),-(2*d7*eb)/(d7-eb),0,0,-1,0);var ea=new aM;ea.set(da);ea.transpose();d4.useProgram(dM);a5("projection2d",dM,"projection",false,ea.array());d4.useProgram(du);a5("projection3d",du,"projection",false,ea.array());d4.useProgram(bQ);a5("uProjectionUS",bQ,"uProjection",false,ea.array())};cV.ortho=function(d8,ej,d7,eh,ee,ed){if(arguments.length===0){d8=0;ej=cV.width;d7=0;eh=cV.height;ee=-10;ed=10}var ei=2/(ej-d8);var eg=2/(eh-d7);var ef=-2/(ed-ee);var ec=-(ej+d8)/(ej-d8);var eb=-(eh+d7)/(eh-d7);var ea=-(ed+ee)/(ed-ee);da=new aM;da.set(ei,0,0,ec,0,eg,0,eb,0,0,ef,ea,0,0,0,1);var d9=new aM;d9.set(da);d9.transpose();d4.useProgram(dM);a5("projection2d",dM,"projection",false,d9.array());d4.useProgram(du);a5("projection3d",du,"projection",false,d9.array());d4.useProgram(bQ);a5("uProjectionUS",bQ,"uProjection",false,d9.array());ch=false};cV.printProjection=function(){da.print()};cV.printCamera=function(){bT.print()};bO.prototype.box=dp.prototype.a3DOnlyFunction;by.prototype.box=function(d9,ec,ee){if(!ec||!ee){ec=ee=d9}var eb=new aM;eb.scale(d9,ec,ee);var d8=new aM;d8.scale(1,-1,1);d8.apply(dF.array());d8.transpose();if(aF){d4.useProgram(du);a5("model3d",du,"model",false,eb.array());a5("view3d",du,"view",false,d8.array());d4.enable(d4.POLYGON_OFFSET_FILL);d4.polygonOffset(1,1);dY("color3d",du,"color",bl);if(dH>0){var ea=new aM;ea.set(d8);var d7=new aM;d7.set(eb);ea.mult(d7);var ed=new aM;ed.set(ea);ed.invert();ed.transpose();a5("normalTransform3d",du,"normalTransform",false,ed.array());db("normal3d",du,"Normal",3,cI)}else{cf("normal3d",du,"Normal")}db("vertex3d",du,"Vertex",3,bd);cf("aColor3d",du,"aColor");cf("aTexture3d",du,"aTexture");d4.drawArrays(d4.TRIANGLES,0,df.length/3);d4.disable(d4.POLYGON_OFFSET_FILL)}if(dS>0&&cd){d4.useProgram(dM);a5("model2d",dM,"model",false,eb.array());a5("view2d",dM,"view",false,d8.array());dY("color2d",dM,"color",cZ);dV("picktype2d",dM,"picktype",0);db("vertex2d",dM,"Vertex",3,di);cf("aTextureCoord2d",dM,"aTextureCoord");d4.drawArrays(d4.LINES,0,bE.length/3)}};var cC=function(){var d8;cE=[];for(d8=0;d8<bK;d8++){cE.push(0);cE.push(-1);cE.push(0);cE.push(bq[d8]);cE.push(bp[d8]);cE.push(bo[d8])}cE.push(0);cE.push(-1);cE.push(0);cE.push(bq[0]);cE.push(bp[0]);cE.push(bo[0]);var ec,d9,eb;var ea=0;for(d8=2;d8<bJ;d8++){ec=d9=ea;ea+=bK;eb=ea;for(var d7=0;d7<bK;d7++){cE.push(bq[ec]);cE.push(bp[ec]);cE.push(bo[ec++]);cE.push(bq[eb]);cE.push(bp[eb]);cE.push(bo[eb++])}ec=d9;eb=ea;cE.push(bq[ec]);cE.push(bp[ec]);cE.push(bo[ec]);cE.push(bq[eb]);cE.push(bp[eb]);cE.push(bo[eb])}for(d8=0;d8<bK;d8++){eb=ea+d8;cE.push(bq[eb]);cE.push(bp[eb]);cE.push(bo[eb]);cE.push(0);cE.push(1);cE.push(0)}cE.push(bq[ea]);cE.push(bp[ea]);cE.push(bo[ea]);cE.push(0);cE.push(1);cE.push(0);d4.bindBuffer(d4.ARRAY_BUFFER,bc);d4.bufferData(d4.ARRAY_BUFFER,new e(cE),d4.STATIC_DRAW)};cV.sphereDetail=function(d8,ej){var ee;if(arguments.length===1){d8=ej=arguments[0]}if(d8<3){d8=3}if(ej<2){ej=2}if(d8===bK&&ej===bJ){return}var ei=720/d8;var ec=new e(d8);var d9=new e(d8);for(ee=0;ee<d8;ee++){ec[ee]=bi[ee*ei%720|0];d9[ee]=ag[ee*ei%720|0]}var eh=d8*(ej-1)+2;var eg=0;bq=new e(eh);bp=new e(eh);bo=new e(eh);var ef=720*0.5/ej;var eb=ef;for(ee=1;ee<ej;ee++){var ea=ag[eb%720|0];var d7=-bi[eb%720|0];for(var ed=0;ed<d8;ed++){bq[eg]=ec[ed]*ea;bp[eg]=d7;bo[eg++]=d9[ed]*ea}eb+=ef}bK=d8;bJ=ej;cC()};bO.prototype.sphere=dp.prototype.a3DOnlyFunction;by.prototype.sphere=function(){var eb=arguments[0];if(bK<3||bJ<2){cV.sphereDetail(30)}var ea=new aM;ea.scale(eb,eb,eb);var d8=new aM;d8.scale(1,-1,1);d8.apply(dF.array());d8.transpose();if(aF){if(dH>0){var d9=new aM;d9.set(d8);var d7=new aM;d7.set(ea);d9.mult(d7);var ec=new aM;ec.set(d9);ec.invert();ec.transpose();a5("normalTransform3d",du,"normalTransform",false,ec.array());db("normal3d",du,"Normal",3,bc)}else{cf("normal3d",du,"Normal")}d4.useProgram(du);cf("aTexture3d",du,"aTexture");a5("model3d",du,"model",false,ea.array());a5("view3d",du,"view",false,d8.array());db("vertex3d",du,"Vertex",3,bc);cf("aColor3d",du,"aColor");d4.enable(d4.POLYGON_OFFSET_FILL);d4.polygonOffset(1,1);dY("color3d",du,"color",bl);d4.drawArrays(d4.TRIANGLE_STRIP,0,cE.length/3);d4.disable(d4.POLYGON_OFFSET_FILL)}if(dS>0&&cd){d4.useProgram(dM);a5("model2d",dM,"model",false,ea.array());a5("view2d",dM,"view",false,d8.array());db("vertex2d",dM,"Vertex",3,bc);cf("aTextureCoord2d",dM,"aTextureCoord");dY("color2d",dM,"color",cZ);dV("picktype2d",dM,"picktype",0);d4.drawArrays(d4.LINE_STRIP,0,cE.length/3)}};cV.modelX=function(ed,ec,eb){var ef=dF.array();var eh=cg.array();var d7=ef[0]*ed+ef[1]*ec+ef[2]*eb+ef[3];var eg=ef[4]*ed+ef[5]*ec+ef[6]*eb+ef[7];var ee=ef[8]*ed+ef[9]*ec+ef[10]*eb+ef[11];var d8=ef[12]*ed+ef[13]*ec+ef[14]*eb+ef[15];var d9=eh[0]*d7+eh[1]*eg+eh[2]*ee+eh[3]*d8;var ea=eh[12]*d7+eh[13]*eg+eh[14]*ee+eh[15]*d8;return ea!==0?d9/ea:d9};cV.modelY=function(ed,ec,eb){var ef=dF.array();var eh=cg.array();var d7=ef[0]*ed+ef[1]*ec+ef[2]*eb+ef[3];var eg=ef[4]*ed+ef[5]*ec+ef[6]*eb+ef[7];var ee=ef[8]*ed+ef[9]*ec+ef[10]*eb+ef[11];var d8=ef[12]*ed+ef[13]*ec+ef[14]*eb+ef[15];var d9=eh[4]*d7+eh[5]*eg+eh[6]*ee+eh[7]*d8;var ea=eh[12]*d7+eh[13]*eg+eh[14]*ee+eh[15]*d8;return ea!==0?d9/ea:d9};cV.modelZ=function(ed,ec,eb){var ef=dF.array();var eh=cg.array();var d7=ef[0]*ed+ef[1]*ec+ef[2]*eb+ef[3];var eg=ef[4]*ed+ef[5]*ec+ef[6]*eb+ef[7];var ee=ef[8]*ed+ef[9]*ec+ef[10]*eb+ef[11];var d9=ef[12]*ed+ef[13]*ec+ef[14]*eb+ef[15];var d8=eh[8]*d7+eh[9]*eg+eh[10]*ee+eh[11]*d9;var ea=eh[12]*d7+eh[13]*eg+eh[14]*ee+eh[15]*d9;return ea!==0?d8/ea:d8};bO.prototype.ambient=dp.prototype.a3DOnlyFunction;by.prototype.ambient=function(ea,d9,d8){d4.useProgram(du);dV("usingMat3d",du,"usingMat",true);var d7=cV.color(ea,d9,d8);dY("mat_ambient3d",du,"mat_ambient",cV.color.toGLArray(d7).slice(0,3))};bO.prototype.emissive=dp.prototype.a3DOnlyFunction;by.prototype.emissive=function(ea,d9,d8){d4.useProgram(du);dV("usingMat3d",du,"usingMat",true);var d7=cV.color(ea,d9,d8);dY("mat_emissive3d",du,"mat_emissive",cV.color.toGLArray(d7).slice(0,3))};bO.prototype.shininess=dp.prototype.a3DOnlyFunction;by.prototype.shininess=function(d7){d4.useProgram(du);dV("usingMat3d",du,"usingMat",true);dY("shininess3d",du,"shininess",d7)};bO.prototype.specular=dp.prototype.a3DOnlyFunction;by.prototype.specular=function(ea,d9,d8){d4.useProgram(du);dV("usingMat3d",du,"usingMat",true);var d7=cV.color(ea,d9,d8);dY("mat_specular3d",du,"mat_specular",cV.color.toGLArray(d7).slice(0,3))};cV.screenX=function(ee,ed,ec){var eg=dF.array();if(eg.length===16){var d7=eg[0]*ee+eg[1]*ed+eg[2]*ec+eg[3];var eh=eg[4]*ee+eg[5]*ed+eg[6]*ec+eg[7];var ef=eg[8]*ee+eg[9]*ed+eg[10]*ec+eg[11];var d8=eg[12]*ee+eg[13]*ed+eg[14]*ec+eg[15];var eb=da.array();var d9=eb[0]*d7+eb[1]*eh+eb[2]*ef+eb[3]*d8;var ea=eb[12]*d7+eb[13]*eh+eb[14]*ef+eb[15]*d8;if(ea!==0){d9/=ea}return cV.width*(1+d9)/2}return dF.multX(ee,ed)};cV.screenY=function az(ee,ed,ec){var eg=dF.array();if(eg.length===16){var d7=eg[0]*ee+eg[1]*ed+eg[2]*ec+eg[3];var eh=eg[4]*ee+eg[5]*ed+eg[6]*ec+eg[7];var ef=eg[8]*ee+eg[9]*ed+eg[10]*ec+eg[11];var d8=eg[12]*ee+eg[13]*ed+eg[14]*ec+eg[15];var eb=da.array();var d9=eb[4]*d7+eb[5]*eh+eb[6]*ef+eb[7]*d8;var ea=eb[12]*d7+eb[13]*eh+eb[14]*ef+eb[15]*d8;if(ea!==0){d9/=ea}return cV.height*(1+d9)/2}return dF.multY(ee,ed)};cV.screenZ=function ax(ee,ed,ec){var eg=dF.array();if(eg.length!==16){return 0}var eb=da.array();var d7=eg[0]*ee+eg[1]*ed+eg[2]*ec+eg[3];var eh=eg[4]*ee+eg[5]*ed+eg[6]*ec+eg[7];var ef=eg[8]*ee+eg[9]*ed+eg[10]*ec+eg[11];var d9=eg[12]*ee+eg[13]*ed+eg[14]*ec+eg[15];var d8=eb[8]*d7+eb[9]*eh+eb[10]*ef+eb[11]*d9;var ea=eb[12]*d7+eb[13]*eh+eb[14]*ef+eb[15]*d9;if(ea!==0){d8/=ea}return(d8+1)/2};dp.prototype.fill=function(){var d7=cV.color(arguments[0],arguments[1],arguments[2],arguments[3]);if(d7===aX&&aF){return}aF=true;aX=d7};bO.prototype.fill=function(){dp.prototype.fill.apply(this,arguments);ap=true};by.prototype.fill=function(){dp.prototype.fill.apply(this,arguments);bl=cV.color.toGLArray(aX)};function bk(){if(aF){if(ap){d4.fillStyle=cV.color.toString(aX);ap=false}d4.fill()}}cV.noFill=function(){aF=false};dp.prototype.stroke=function(){var d7=cV.color(arguments[0],arguments[1],arguments[2],arguments[3]);if(d7===cu&&cd){return}cd=true;cu=d7};bO.prototype.stroke=function(){dp.prototype.stroke.apply(this,arguments);b2=true};by.prototype.stroke=function(){dp.prototype.stroke.apply(this,arguments);cZ=cV.color.toGLArray(cu)};function dc(){if(cd){if(b2){d4.strokeStyle=cV.color.toString(cu);b2=false}d4.stroke()}}cV.noStroke=function(){cd=false};dp.prototype.strokeWeight=function(d7){dS=d7};bO.prototype.strokeWeight=function(d7){dp.prototype.strokeWeight.apply(this,arguments);d4.lineWidth=d7};by.prototype.strokeWeight=function(d7){dp.prototype.strokeWeight.apply(this,arguments);d4.useProgram(dM);dY("pointSize2d",dM,"pointSize",d7);d4.useProgram(bQ);dY("pointSizeUnlitShape",bQ,"pointSize",d7);d4.lineWidth(d7)};cV.strokeCap=function(d7){dU.$ensureContext().lineCap=d7};cV.strokeJoin=function(d7){dU.$ensureContext().lineJoin=d7};bO.prototype.smooth=function(){dK=true;var d7=ac.style;d7.setProperty("image-rendering","optimizeQuality","important");d7.setProperty("-ms-interpolation-mode","bicubic","important");if(d4.hasOwnProperty("mozImageSmoothingEnabled")){d4.mozImageSmoothingEnabled=true}};by.prototype.smooth=E;bO.prototype.noSmooth=function(){dK=false;var d7=ac.style;d7.setProperty("image-rendering","optimizeSpeed","important");d7.setProperty("image-rendering","-moz-crisp-edges","important");d7.setProperty("image-rendering","-webkit-optimize-contrast","important");d7.setProperty("image-rendering","optimize-contrast","important");d7.setProperty("-ms-interpolation-mode","nearest-neighbor","important");if(d4.hasOwnProperty("mozImageSmoothingEnabled")){d4.mozImageSmoothingEnabled=false}};by.prototype.noSmooth=E;bO.prototype.point=function(d7,d8){if(!cd){return}d7=o.round(d7);d8=o.round(d8);d4.fillStyle=cV.color.toString(cu);ap=true;if(dS>1){d4.beginPath();d4.arc(d7,d8,dS/2,0,6.283185307179586,false);d4.fill()}else{d4.fillRect(d7,d8,1,1)}};by.prototype.point=function(d7,eb,ea){var d9=new aM;d9.translate(d7,eb,ea||0);d9.transpose();var d8=new aM;d8.scale(1,-1,1);d8.apply(dF.array());d8.transpose();d4.useProgram(dM);a5("model2d",dM,"model",false,d9.array());a5("view2d",dM,"view",false,d8.array());if(dS>0&&cd){dY("color2d",dM,"color",cZ);dV("picktype2d",dM,"picktype",0);db("vertex2d",dM,"Vertex",3,av);cf("aTextureCoord2d",dM,"aTextureCoord");d4.drawArrays(d4.POINTS,0,1)}};cV.beginShape=function(d7){dN=d7;d2=[];a7=[]};bO.prototype.vertex=function(d7,eb,ea,d9){var d8=[];if(dr){dr=false}d8.isVert=true;d8[0]=d7;d8[1]=eb;d8[2]=0;d8[3]=ea;d8[4]=d9;d8[5]=aX;d8[6]=cu;a7.push(d8)};by.prototype.vertex=function(d7,ec,eb,ea,d9){var d8=[];if(dr){dr=false}d8.isVert=true;if(d9===r&&dP){d9=ea;ea=eb;eb=0}if(ea!==r&&d9!==r){if(d0===2){ea/=cr.width;d9/=cr.height}ea=ea>1?1:ea;ea=ea<0?0:ea;d9=d9>1?1:d9;d9=d9<0?0:d9}d8[0]=d7;d8[1]=ec;d8[2]=eb||0;d8[3]=ea||0;d8[4]=d9||0;d8[5]=bl[0];d8[6]=bl[1];d8[7]=bl[2];d8[8]=bl[3];d8[9]=cZ[0];d8[10]=cZ[1];d8[11]=cZ[2];d8[12]=cZ[3];d8[13]=a4;d8[14]=a3;d8[15]=a2;a7.push(d8)};var dX=function(d9,d8){var d7=new aM;d7.scale(1,-1,1);d7.apply(dF.array());d7.transpose();d4.useProgram(bQ);a5("uViewUS",bQ,"uView",false,d7.array());db("aVertexUS",bQ,"aVertex",3,av);d4.bufferData(d4.ARRAY_BUFFER,new e(d9),d4.STREAM_DRAW);db("aColorUS",bQ,"aColor",4,aE);d4.bufferData(d4.ARRAY_BUFFER,new e(d8),d4.STREAM_DRAW);d4.drawArrays(d4.POINTS,0,d9.length/3)};var bg=function(eb,ea,d9){var d8;if(ea==="LINES"){d8=d4.LINES}else{if(ea==="LINE_LOOP"){d8=d4.LINE_LOOP}else{d8=d4.LINE_STRIP}}var d7=new aM;d7.scale(1,-1,1);d7.apply(dF.array());d7.transpose();d4.useProgram(bQ);a5("uViewUS",bQ,"uView",false,d7.array());db("aVertexUS",bQ,"aVertex",3,b7);d4.bufferData(d4.ARRAY_BUFFER,new e(eb),d4.STREAM_DRAW);db("aColorUS",bQ,"aColor",4,bz);d4.bufferData(d4.ARRAY_BUFFER,new e(d9),d4.STREAM_DRAW);d4.drawArrays(d8,0,eb.length/3)};var dk=function(ec,eb,ea,d9){var d8;if(eb==="TRIANGLES"){d8=d4.TRIANGLES}else{if(eb==="TRIANGLE_FAN"){d8=d4.TRIANGLE_FAN}else{d8=d4.TRIANGLE_STRIP}}var d7=new aM;d7.scale(1,-1,1);d7.apply(dF.array());d7.transpose();d4.useProgram(du);a5("model3d",du,"model",false,[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]);a5("view3d",du,"view",false,d7.array());d4.enable(d4.POLYGON_OFFSET_FILL);d4.polygonOffset(1,1);dY("color3d",du,"color",[-1,0,0,0]);db("vertex3d",du,"Vertex",3,ar);d4.bufferData(d4.ARRAY_BUFFER,new e(ec),d4.STREAM_DRAW);if(dP&&bb!==null){bt(ea)}db("aColor3d",du,"aColor",4,aE);d4.bufferData(d4.ARRAY_BUFFER,new e(ea),d4.STREAM_DRAW);cf("normal3d",du,"Normal");if(dP){dV("usingTexture3d",du,"usingTexture",dP);db("aTexture3d",du,"aTexture",2,ae);d4.bufferData(d4.ARRAY_BUFFER,new e(d9),d4.STREAM_DRAW)}d4.drawArrays(d8,0,ec.length/3);d4.disable(d4.POLYGON_OFFSET_FILL)};function cR(){bk();dc();d4.closePath()}bO.prototype.endShape=function(ee){if(a7.length===0){return}var ea=ee===2;if(ea){a7.push(a7[0])}var d9=[];var d7=[];var eg=[];var ej=[];var ec=[];var ef;dr=true;var ed,eb,d8;var ei=a7.length;for(ed=0;ed<ei;ed++){ef=a7[ed];for(eb=0;eb<3;eb++){d7.push(ef[eb])}}for(ed=0;ed<ei;ed++){ef=a7[ed];for(eb=5;eb<9;eb++){eg.push(ef[eb])}}for(ed=0;ed<ei;ed++){ef=a7[ed];for(eb=9;eb<13;eb++){ej.push(ef[eb])}}for(ed=0;ed<ei;ed++){ef=a7[ed];ec.push(ef[3]);ec.push(ef[4])}if(dL&&(dN===20||dN===r)){if(ei>3){var eh=[],ek=1-aH;d4.beginPath();d4.moveTo(a7[1][0],a7[1][1]);for(ed=1;ed+2<ei;ed++){ef=a7[ed];eh[0]=[ef[0],ef[1]];eh[1]=[ef[0]+(ek*a7[ed+1][0]-ek*a7[ed-1][0])/6,ef[1]+(ek*a7[ed+1][1]-ek*a7[ed-1][1])/6];eh[2]=[a7[ed+1][0]+(ek*a7[ed][0]-ek*a7[ed+2][0])/6,a7[ed+1][1]+(ek*a7[ed][1]-ek*a7[ed+2][1])/6];eh[3]=[a7[ed+1][0],a7[ed+1][1]];d4.bezierCurveTo(eh[1][0],eh[1][1],eh[2][0],eh[2][1],eh[3][0],eh[3][1])}cR()}}else{if(Y&&(dN===20||dN===r)){d4.beginPath();for(ed=0;ed<ei;ed++){ef=a7[ed];if(a7[ed]["isVert"]){if(a7[ed]["moveTo"]){d4.moveTo(ef[0],ef[1])}else{d4.lineTo(ef[0],ef[1])}}else{d4.bezierCurveTo(a7[ed][0],a7[ed][1],a7[ed][2],a7[ed][3],a7[ed][4],a7[ed][5])}}cR()}else{if(dN===2){for(ed=0;ed<ei;ed++){ef=a7[ed];if(cd){cV.stroke(ef[6])}cV.point(ef[0],ef[1])}}else{if(dN===4){for(ed=0;ed+1<ei;ed+=2){ef=a7[ed];if(cd){cV.stroke(a7[ed+1][6])}cV.line(ef[0],ef[1],a7[ed+1][0],a7[ed+1][1])}}else{if(dN===9){for(ed=0;ed+2<ei;ed+=3){ef=a7[ed];d4.beginPath();d4.moveTo(ef[0],ef[1]);d4.lineTo(a7[ed+1][0],a7[ed+1][1]);d4.lineTo(a7[ed+2][0],a7[ed+2][1]);d4.lineTo(ef[0],ef[1]);if(aF){cV.fill(a7[ed+2][5]);bk()}if(cd){cV.stroke(a7[ed+2][6]);dc()}d4.closePath()}}else{if(dN===10){for(ed=0;ed+1<ei;ed++){ef=a7[ed];d4.beginPath();d4.moveTo(a7[ed+1][0],a7[ed+1][1]);d4.lineTo(ef[0],ef[1]);if(cd){cV.stroke(a7[ed+1][6])}if(aF){cV.fill(a7[ed+1][5])}if(ed+2<ei){d4.lineTo(a7[ed+2][0],a7[ed+2][1]);if(cd){cV.stroke(a7[ed+2][6])}if(aF){cV.fill(a7[ed+2][5])}}cR()}}else{if(dN===11){if(ei>2){d4.beginPath();d4.moveTo(a7[0][0],a7[0][1]);d4.lineTo(a7[1][0],a7[1][1]);d4.lineTo(a7[2][0],a7[2][1]);if(aF){cV.fill(a7[2][5]);bk()}if(cd){cV.stroke(a7[2][6]);dc()}d4.closePath();for(ed=3;ed<ei;ed++){ef=a7[ed];d4.beginPath();d4.moveTo(a7[0][0],a7[0][1]);d4.lineTo(a7[ed-1][0],a7[ed-1][1]);d4.lineTo(ef[0],ef[1]);if(aF){cV.fill(ef[5]);bk()}if(cd){cV.stroke(ef[6]);dc()}d4.closePath()}}}else{if(dN===16){for(ed=0;ed+3<ei;ed+=4){ef=a7[ed];d4.beginPath();d4.moveTo(ef[0],ef[1]);for(eb=1;eb<4;eb++){d4.lineTo(a7[ed+eb][0],a7[ed+eb][1])}d4.lineTo(ef[0],ef[1]);if(aF){cV.fill(a7[ed+3][5]);bk()}if(cd){cV.stroke(a7[ed+3][6]);dc()}d4.closePath()}}else{if(dN===17){if(ei>3){for(ed=0;ed+1<ei;ed+=2){ef=a7[ed];d4.beginPath();if(ed+3<ei){d4.moveTo(a7[ed+2][0],a7[ed+2][1]);d4.lineTo(ef[0],ef[1]);d4.lineTo(a7[ed+1][0],a7[ed+1][1]);d4.lineTo(a7[ed+3][0],a7[ed+3][1]);if(aF){cV.fill(a7[ed+3][5])}if(cd){cV.stroke(a7[ed+3][6])}}else{d4.moveTo(ef[0],ef[1]);d4.lineTo(a7[ed+1][0],a7[ed+1][1])}cR()}}}else{d4.beginPath();d4.moveTo(a7[0][0],a7[0][1]);for(ed=1;ed<ei;ed++){ef=a7[ed];if(ef.isVert){if(ef.moveTo){d4.moveTo(ef[0],ef[1])}else{d4.lineTo(ef[0],ef[1])}}}cR()}}}}}}}}}dL=false;Y=false;ca=[];c1=0;if(ea){a7.pop()}};by.prototype.endShape=function(ee){if(a7.length===0){return}var ea=ee===2;var d9=[];var d7=[];var eg=[];var ej=[];var ec=[];var ef;dr=true;var ed,eb,d8;var ei=a7.length;for(ed=0;ed<ei;ed++){ef=a7[ed];for(eb=0;eb<3;eb++){d7.push(ef[eb])}}for(ed=0;ed<ei;ed++){ef=a7[ed];for(eb=5;eb<9;eb++){eg.push(ef[eb])}}for(ed=0;ed<ei;ed++){ef=a7[ed];for(eb=9;eb<13;eb++){ej.push(ef[eb])}}for(ed=0;ed<ei;ed++){ef=a7[ed];ec.push(ef[3]);ec.push(ef[4])}if(ea){d7.push(a7[0][0]);d7.push(a7[0][1]);d7.push(a7[0][2]);for(ed=5;ed<9;ed++){eg.push(a7[0][ed])}for(ed=9;ed<13;ed++){ej.push(a7[0][ed])}ec.push(a7[0][3]);ec.push(a7[0][4])}if(dL&&(dN===20||dN===r)){d9=d7;if(cd){bg(d9,null,ej)}if(aF){dk(d7,null,eg)}}else{if(Y&&(dN===20||dN===r)){d9=d7;d9.splice(d9.length-3);ej.splice(ej.length-4);if(cd){bg(d9,null,ej)}if(aF){dk(d7,"TRIANGLES",eg)}}else{if(dN===2){for(ed=0;ed<ei;ed++){ef=a7[ed];for(eb=0;eb<3;eb++){d9.push(ef[eb])}}dX(d9,ej)}else{if(dN===4){for(ed=0;ed<ei;ed++){ef=a7[ed];for(eb=0;eb<3;eb++){d9.push(ef[eb])}}for(ed=0;ed<ei;ed++){ef=a7[ed];for(eb=5;eb<9;eb++){eg.push(ef[eb])}}bg(d9,"LINES",ej)}else{if(dN===9){if(ei>2){for(ed=0;ed+2<ei;ed+=3){d7=[];ec=[];d9=[];eg=[];ej=[];for(eb=0;eb<3;eb++){for(d8=0;d8<3;d8++){d9.push(a7[ed+eb][d8]);d7.push(a7[ed+eb][d8])}}for(eb=0;eb<3;eb++){for(d8=3;d8<5;d8++){ec.push(a7[ed+eb][d8])}}for(eb=0;eb<3;eb++){for(d8=5;d8<9;d8++){eg.push(a7[ed+eb][d8]);ej.push(a7[ed+eb][d8+4])}}if(cd){bg(d9,"LINE_LOOP",ej)}if(aF||dP){dk(d7,"TRIANGLES",eg,ec)}}}}else{if(dN===10){if(ei>2){for(ed=0;ed+2<ei;ed++){d9=[];d7=[];ej=[];eg=[];ec=[];for(eb=0;eb<3;eb++){for(d8=0;d8<3;d8++){d9.push(a7[ed+eb][d8]);d7.push(a7[ed+eb][d8])}}for(eb=0;eb<3;eb++){for(d8=3;d8<5;d8++){ec.push(a7[ed+eb][d8])}}for(eb=0;eb<3;eb++){for(d8=5;d8<9;d8++){ej.push(a7[ed+eb][d8+4]);eg.push(a7[ed+eb][d8])}}if(aF||dP){dk(d7,"TRIANGLE_STRIP",eg,ec)}if(cd){bg(d9,"LINE_LOOP",ej)}}}}else{if(dN===11){if(ei>2){for(ed=0;ed<3;ed++){ef=a7[ed];for(eb=0;eb<3;eb++){d9.push(ef[eb])}}for(ed=0;ed<3;ed++){ef=a7[ed];for(eb=9;eb<13;eb++){ej.push(ef[eb])}}if(cd){bg(d9,"LINE_LOOP",ej)}for(ed=2;ed+1<ei;ed++){d9=[];ej=[];d9.push(a7[0][0]);d9.push(a7[0][1]);d9.push(a7[0][2]);ej.push(a7[0][9]);ej.push(a7[0][10]);ej.push(a7[0][11]);ej.push(a7[0][12]);for(eb=0;eb<2;eb++){for(d8=0;d8<3;d8++){d9.push(a7[ed+eb][d8])}}for(eb=0;eb<2;eb++){for(d8=9;d8<13;d8++){ej.push(a7[ed+eb][d8])}}if(cd){bg(d9,"LINE_STRIP",ej)}}if(aF||dP){dk(d7,"TRIANGLE_FAN",eg,ec)}}}else{if(dN===16){for(ed=0;ed+3<ei;ed+=4){d9=[];for(eb=0;eb<4;eb++){ef=a7[ed+eb];for(d8=0;d8<3;d8++){d9.push(ef[d8])}}if(cd){bg(d9,"LINE_LOOP",ej)}if(aF){d7=[];eg=[];ec=[];for(eb=0;eb<3;eb++){d7.push(a7[ed][eb])}for(eb=5;eb<9;eb++){eg.push(a7[ed][eb])}for(eb=0;eb<3;eb++){d7.push(a7[ed+1][eb])}for(eb=5;eb<9;eb++){eg.push(a7[ed+1][eb])}for(eb=0;eb<3;eb++){d7.push(a7[ed+3][eb])}for(eb=5;eb<9;eb++){eg.push(a7[ed+3][eb])}for(eb=0;eb<3;eb++){d7.push(a7[ed+2][eb])}for(eb=5;eb<9;eb++){eg.push(a7[ed+2][eb])}if(dP){ec.push(a7[ed+0][3]);ec.push(a7[ed+0][4]);ec.push(a7[ed+1][3]);ec.push(a7[ed+1][4]);ec.push(a7[ed+3][3]);ec.push(a7[ed+3][4]);ec.push(a7[ed+2][3]);ec.push(a7[ed+2][4])}dk(d7,"TRIANGLE_STRIP",eg,ec)}}}else{if(dN===17){var eh=[];if(ei>3){for(ed=0;ed<2;ed++){ef=a7[ed];for(eb=0;eb<3;eb++){d9.push(ef[eb])}}for(ed=0;ed<2;ed++){ef=a7[ed];for(eb=9;eb<13;eb++){ej.push(ef[eb])}}bg(d9,"LINE_STRIP",ej);if(ei>4&&ei%2>0){eh=d7.splice(d7.length-3);a7.pop()}for(ed=0;ed+3<ei;ed+=2){d9=[];ej=[];for(eb=0;eb<3;eb++){d9.push(a7[ed+1][eb])}for(eb=0;eb<3;eb++){d9.push(a7[ed+3][eb])}for(eb=0;eb<3;eb++){d9.push(a7[ed+2][eb])}for(eb=0;eb<3;eb++){d9.push(a7[ed+0][eb])}for(eb=9;eb<13;eb++){ej.push(a7[ed+1][eb])}for(eb=9;eb<13;eb++){ej.push(a7[ed+3][eb])}for(eb=9;eb<13;eb++){ej.push(a7[ed+2][eb])}for(eb=9;eb<13;eb++){ej.push(a7[ed+0][eb])}if(cd){bg(d9,"LINE_STRIP",ej)}}if(aF||dP){dk(d7,"TRIANGLE_LIST",eg,ec)}}}else{if(ei===1){for(eb=0;eb<3;eb++){d9.push(a7[0][eb])}for(eb=9;eb<13;eb++){ej.push(a7[0][eb])}dX(d9,ej)}else{for(ed=0;ed<ei;ed++){ef=a7[ed];for(eb=0;eb<3;eb++){d9.push(ef[eb])}for(eb=5;eb<9;eb++){ej.push(ef[eb])}}if(cd&&ea){bg(d9,"LINE_LOOP",ej)}else{if(cd&&!ea){bg(d9,"LINE_STRIP",ej)}}if(aF||dP){dk(d7,"TRIANGLE_FAN",eg,ec)}}}}}}}}}dP=false;d4.useProgram(du);dV("usingTexture3d",du,"usingTexture",dP)}}dL=false;Y=false;ca=[];c1=0};var aU=function(ea,d9){var eb=1/ea;var d8=eb*eb;var d7=d8*eb;d9.set(0,0,0,1,d7,d8,eb,0,6*d7,2*d8,0,0,6*d7,0,0,0)};var dn=function(){if(!aJ){c2=new aM;aJ=new aM;cL=true}var d7=aH;c2.set((d7-1)/2,(d7+3)/2,(-3-d7)/2,(1-d7)/2,1-d7,(-5-d7)/2,d7+2,(d7-1)/2,(d7-1)/2,0,(1-d7)/2,0,0,1,0,0);aU(O,aJ);if(!cc){aN=new aM}aN.set(c2);aN.preApply(cc);aJ.apply(c2)};bO.prototype.bezierVertex=function(){Y=true;var d7=[];if(dr){throw"vertex() must be used at least once before calling bezierVertex()"}for(var d8=0;d8<arguments.length;d8++){d7[d8]=arguments[d8]}a7.push(d7);a7[a7.length-1]["isVert"]=false};by.prototype.bezierVertex=function(){Y=true;var ee=[];if(dr){throw"vertex() must be used at least once before calling bezierVertex()"}if(arguments.length===9){if(bw===r){bw=new aM}var ej=a7.length-1;aU(cx,bw);bw.apply(S);var el=bw.array();var ea=a7[ej][0],ek=a7[ej][1],ed=a7[ej][2];var eg=el[4]*ea+el[5]*arguments[0]+el[6]*arguments[3]+el[7]*arguments[6];var ef=el[8]*ea+el[9]*arguments[0]+el[10]*arguments[3]+el[11]*arguments[6];var ec=el[12]*ea+el[13]*arguments[0]+el[14]*arguments[3]+el[15]*arguments[6];var em=el[4]*ek+el[5]*arguments[1]+el[6]*arguments[4]+el[7]*arguments[7];var ei=el[8]*ek+el[9]*arguments[1]+el[10]*arguments[4]+el[11]*arguments[7];var eh=el[12]*ek+el[13]*arguments[1]+el[14]*arguments[4]+el[15]*arguments[7];var d9=el[4]*ed+el[5]*arguments[2]+el[6]*arguments[5]+el[7]*arguments[8];var d8=el[8]*ed+el[9]*arguments[2]+el[10]*arguments[5]+el[11]*arguments[8];var d7=el[12]*ed+el[13]*arguments[2]+el[14]*arguments[5]+el[15]*arguments[8];for(var eb=0;eb<cx;eb++){ea+=eg;eg+=ef;ef+=ec;ek+=em;em+=ei;ei+=eh;ed+=d9;d9+=d8;d8+=d7;cV.vertex(ea,ek,ed)}cV.vertex(arguments[6],arguments[7],arguments[8])}};cV.texture=function(ea){var d8=dU.$ensureContext();if(ea.__texture){d8.bindTexture(d8.TEXTURE_2D,ea.__texture)}else{if(ea.localName==="canvas"){d8.bindTexture(d8.TEXTURE_2D,c6);d8.texImage2D(d8.TEXTURE_2D,0,d8.RGBA,d8.RGBA,d8.UNSIGNED_BYTE,ea);d8.texParameteri(d8.TEXTURE_2D,d8.TEXTURE_MAG_FILTER,d8.LINEAR);d8.texParameteri(d8.TEXTURE_2D,d8.TEXTURE_MIN_FILTER,d8.LINEAR);d8.generateMipmap(d8.TEXTURE_2D);cr.width=ea.width;cr.height=ea.height}else{var d9=d8.createTexture(),ec=d.createElement("canvas"),d7=ec.getContext("2d"),eb;if(ea.width&ea.width-1===0){ec.width=ea.width}else{eb=1;while(eb<ea.width){eb*=2}ec.width=eb}if(ea.height&ea.height-1===0){ec.height=ea.height}else{eb=1;while(eb<ea.height){eb*=2}ec.height=eb}d7.drawImage(ea.sourceImg,0,0,ea.width,ea.height,0,0,ec.width,ec.height);d8.bindTexture(d8.TEXTURE_2D,d9);d8.texParameteri(d8.TEXTURE_2D,d8.TEXTURE_MIN_FILTER,d8.LINEAR_MIPMAP_LINEAR);d8.texParameteri(d8.TEXTURE_2D,d8.TEXTURE_MAG_FILTER,d8.LINEAR);d8.texParameteri(d8.TEXTURE_2D,d8.TEXTURE_WRAP_T,d8.CLAMP_TO_EDGE);d8.texParameteri(d8.TEXTURE_2D,d8.TEXTURE_WRAP_S,d8.CLAMP_TO_EDGE);d8.texImage2D(d8.TEXTURE_2D,0,d8.RGBA,d8.RGBA,d8.UNSIGNED_BYTE,ec);d8.generateMipmap(d8.TEXTURE_2D);ea.__texture=d9;cr.width=ea.width;cr.height=ea.height}}dP=true;d8.useProgram(du);dV("usingTexture3d",du,"usingTexture",dP)};cV.textureMode=function(d7){d0=d7};var aq=function(es,ed,ej,eq,ec,ei,eo,eb,eh,em,ea,ef){var et=eq;var ee=ec;var ek=ei;var eg=aJ.array();var er=eg[4]*es+eg[5]*eq+eg[6]*eo+eg[7]*em;var ep=eg[8]*es+eg[9]*eq+eg[10]*eo+eg[11]*em;var en=eg[12]*es+eg[13]*eq+eg[14]*eo+eg[15]*em;var ew=eg[4]*ed+eg[5]*ec+eg[6]*eb+eg[7]*ea;var ev=eg[8]*ed+eg[9]*ec+eg[10]*eb+eg[11]*ea;var eu=eg[12]*ed+eg[13]*ec+eg[14]*eb+eg[15]*ea;var d9=eg[4]*ej+eg[5]*ei+eg[6]*eh+eg[7]*ef;var d8=eg[8]*ej+eg[9]*ei+eg[10]*eh+eg[11]*ef;var d7=eg[12]*ej+eg[13]*ei+eg[14]*eh+eg[15]*ef;cV.vertex(et,ee,ek);for(var el=0;el<O;el++){et+=er;er+=ep;ep+=en;ee+=ew;ew+=ev;ev+=eu;ek+=d9;d9+=d8;d8+=d7;cV.vertex(et,ee,ek)}};bO.prototype.curveVertex=function(d7,d8){dL=true;cV.vertex(d7,d8)};by.prototype.curveVertex=function(d7,ea,d9){dL=true;if(!cL){dn()}var d8=[];d8[0]=d7;d8[1]=ea;d8[2]=d9;ca.push(d8);c1++;if(c1>3){aq(ca[c1-4][0],ca[c1-4][1],ca[c1-4][2],ca[c1-3][0],ca[c1-3][1],ca[c1-3][2],ca[c1-2][0],ca[c1-2][1],ca[c1-2][2],ca[c1-1][0],ca[c1-1][1],ca[c1-1][2])}};bO.prototype.curve=function(){if(arguments.length===8){cV.beginShape();cV.curveVertex(arguments[0],arguments[1]);cV.curveVertex(arguments[2],arguments[3]);cV.curveVertex(arguments[4],arguments[5]);cV.curveVertex(arguments[6],arguments[7]);cV.endShape()}};by.prototype.curve=function(){if(arguments.length===12){cV.beginShape();cV.curveVertex(arguments[0],arguments[1],arguments[2]);cV.curveVertex(arguments[3],arguments[4],arguments[5]);cV.curveVertex(arguments[6],arguments[7],arguments[8]);cV.curveVertex(arguments[9],arguments[10],arguments[11]);cV.endShape()}};cV.curveTightness=function(d7){aH=d7};cV.curveDetail=function(d7){O=d7;dn()};cV.rectMode=function(d7){bI=d7};cV.imageMode=function(d7){switch(d7){case 0:bh=aV;break;case 1:bh=b0;break;case 3:bh=aL;break;default:throw"Invalid imageMode"}};cV.ellipseMode=function(d7){cM=d7};cV.arc=function(ej,eh,ea,el,d9,ei){if(ea<=0||ei<d9){return}if(cM===1){ea=ea-ej;el=el-eh}else{if(cM===2){ej=ej-ea;eh=eh-el;ea=ea*2;el=el*2}else{if(cM===3){ej=ej-ea/2;eh=eh-el/2}}}while(d9<0){d9+=6.283185307179586;ei+=6.283185307179586}if(ei-d9>6.283185307179586){d9=0;ei=6.283185307179586}var ek=ea/2;var em=el/2;var ee=ej+ek;var ec=eh+em;var d8=0|-0.5+d9*cV.RAD_TO_DEG*2;var eg=0|0.5+ei*cV.RAD_TO_DEG*2;var ef,ed;if(aF){var eb=cd;cd=false;cV.beginShape();cV.vertex(ee,ec);for(ef=d8;ef<=eg;ef++){ed=ef%720;cV.vertex(ee+bi[ed]*ek,ec+ag[ed]*em)}cV.endShape(2);cd=eb}if(cd){var d7=aF;aF=false;cV.beginShape();for(ef=d8;ef<=eg;ef++){ed=ef%720;cV.vertex(ee+bi[ed]*ek,ec+ag[ed]*em)}cV.endShape();aF=d7}};bO.prototype.line=function(d8,ef,d7,ed){if(!cd){return}d8=o.round(d8);d7=o.round(d7);ef=o.round(ef);ed=o.round(ed);if(d8===d7&&ef===ed){cV.point(d8,ef);return}var d9=r,eg=r,ec=true,ee=dF.array(),ea=[1,0,0,0,1,0];for(var eb=0;eb<6&&ec;eb++){ec=ee[eb]===ea[eb]}if(ec){if(d8===d7){if(ef>ed){d9=ef;ef=ed;ed=d9}ed++;if(dS%2===1){d4.translate(0.5,0)}}else{if(ef===ed){if(d8>d7){d9=d8;d8=d7;d7=d9}d7++;if(dS%2===1){d4.translate(0,0.5)}}}if(dS===1){eg=d4.lineCap;d4.lineCap="butt"}}d4.beginPath();d4.moveTo(d8||0,ef||0);d4.lineTo(d7||0,ed||0);dc();if(ec){if(d8===d7&&dS%2===1){d4.translate(-0.5,0)}else{if(ef===ed&&dS%2===1){d4.translate(0,-0.5)}}if(dS===1){d4.lineCap=eg}}};by.prototype.line=function(d9,ec,ee,d8,ea,ed){if(ea===r||ed===r){ed=0;ea=d8;d8=ee;ee=0}if(d9===d8&&ec===ea&&ee===ed){cV.point(d9,ec,ee);return}var eb=[d9,ec,ee,d8,ea,ed];var d7=new aM;d7.scale(1,-1,1);d7.apply(dF.array());d7.transpose();if(dS>0&&cd){d4.useProgram(dM);a5("model2d",dM,"model",false,[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]);a5("view2d",dM,"view",false,d7.array());dY("color2d",dM,"color",cZ);dV("picktype2d",dM,"picktype",0);db("vertex2d",dM,"Vertex",3,b7);cf("aTextureCoord2d",dM,"aTextureCoord");d4.bufferData(d4.ARRAY_BUFFER,new e(eb),d4.STREAM_DRAW);d4.drawArrays(d4.LINES,0,2)}};bO.prototype.bezier=function(){if(arguments.length!==8){throw"You must use 8 parameters for bezier() in 2D mode"}cV.beginShape();cV.vertex(arguments[0],arguments[1]);cV.bezierVertex(arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7]);cV.endShape()};by.prototype.bezier=function(){if(arguments.length!==12){throw"You must use 12 parameters for bezier() in 3D mode"}cV.beginShape();cV.vertex(arguments[0],arguments[1],arguments[2]);cV.bezierVertex(arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],arguments[11]);cV.endShape()};cV.bezierDetail=function(d7){cx=d7};cV.bezierPoint=function(d8,d7,eb,ea,d9){return(1-d9)*(1-d9)*(1-d9)*d8+3*(1-d9)*(1-d9)*d9*d7+3*(1-d9)*d9*d9*eb+d9*d9*d9*ea};cV.bezierTangent=function(d8,d7,eb,ea,d9){return 3*d9*d9*(-d8+3*d7-3*eb+ea)+6*d9*(d8-2*d7+eb)+3*(-d8+d7)};cV.curvePoint=function(d8,d7,eb,ea,d9){return 0.5*(2*d7+(-d8+eb)*d9+(2*d8-5*d7+4*eb-ea)*d9*d9+(-d8+3*d7-3*eb+ea)*d9*d9*d9)};cV.curveTangent=function(d8,d7,eb,ea,d9){return 0.5*(-d8+eb+2*(2*d8-5*d7+4*eb-ea)*d9+3*(-d8+3*d7-3*eb+ea)*d9*d9)};cV.triangle=function(ea,ec,d8,eb,d7,d9){cV.beginShape(9);cV.vertex(ea,ec,0);cV.vertex(d8,eb,0);cV.vertex(d7,d9,0);cV.endShape()};cV.quad=function(ec,ee,ea,ed,d8,eb,d7,d9){cV.beginShape(16);cV.vertex(ec,ee,0);cV.vertex(ea,ed,0);cV.vertex(d8,eb,0);cV.vertex(d7,d9,0);cV.endShape()};var bL=function(ed,ec,d7,ee,eg,eb,ef,d8){if(d8===r){eb=eg;ef=eg;d8=eg}var d9=d7/2,ea=ee/2;if(eg>d9||eg>ea){eg=o.min(d9,ea)}if(eb>d9||eb>ea){eb=o.min(d9,ea)}if(ef>d9||ef>ea){ef=o.min(d9,ea)}if(d8>d9||d8>ea){d8=o.min(d9,ea)}if(!aF||cd){d4.translate(0.5,0.5)}d4.beginPath();d4.moveTo(ed+eg,ec);d4.lineTo(ed+d7-eb,ec);d4.quadraticCurveTo(ed+d7,ec,ed+d7,ec+eb);d4.lineTo(ed+d7,ec+ee-ef);d4.quadraticCurveTo(ed+d7,ec+ee,ed+d7-ef,ec+ee);d4.lineTo(ed+d8,ec+ee);d4.quadraticCurveTo(ed,ec+ee,ed,ec+ee-d8);d4.lineTo(ed,ec+eg);d4.quadraticCurveTo(ed,ec,ed+eg,ec);if(!aF||cd){d4.translate(-0.5,-0.5)}bk();dc()};bO.prototype.rect=function(d8,ee,eb,d7,d9,ec,ea,ed){if(!eb&&!d7){return}if(bI===1){eb-=d8;d7-=ee}else{if(bI===2){eb*=2;d7*=2;d8-=eb/2;ee-=d7/2}else{if(bI===3){d8-=eb/2;ee-=d7/2}}}d8=o.round(d8);ee=o.round(ee);eb=o.round(eb);d7=o.round(d7);if(d9!==r){bL(d8,ee,eb,d7,d9,ec,ea,ed);return}if(cd&&dS%2===1){d4.translate(0.5,0.5)}d4.beginPath();d4.rect(d8,ee,eb,d7);bk();dc();if(cd&&dS%2===1){d4.translate(-0.5,-0.5)}};by.prototype.rect=function(ef,ee,d7,eh,ej,ec,ei,d8){if(ej!==r){throw"rect() with rounded corners is not supported in 3D mode"}if(bI===1){d7-=ef;eh-=ee}else{if(bI===2){d7*=2;eh*=2;ef-=d7/2;ee-=eh/2}else{if(bI===3){ef-=d7/2;ee-=eh/2}}}var eb=new aM;eb.translate(ef,ee,0);eb.scale(d7,eh,1);eb.transpose();var ed=new aM;ed.scale(1,-1,1);ed.apply(dF.array());ed.transpose();if(dS>0&&cd){d4.useProgram(dM);a5("model2d",dM,"model",false,eb.array());a5("view2d",dM,"view",false,ed.array());dY("color2d",dM,"color",cZ);dV("picktype2d",dM,"picktype",0);db("vertex2d",dM,"Vertex",3,aA);cf("aTextureCoord2d",dM,"aTextureCoord");d4.drawArrays(d4.LINE_LOOP,0,aj.length/3)}if(aF){d4.useProgram(du);a5("model3d",du,"model",false,eb.array());a5("view3d",du,"view",false,ed.array());d4.enable(d4.POLYGON_OFFSET_FILL);d4.polygonOffset(1,1);dY("color3d",du,"color",bl);if(dH>0){var eg=new aM;eg.set(ed);var d9=new aM;d9.set(eb);eg.mult(d9);var ea=new aM;ea.set(eg);ea.invert();ea.transpose();a5("normalTransform3d",du,"normalTransform",false,ea.array());db("normal3d",du,"Normal",3,b1)}else{cf("normal3d",du,"Normal")}db("vertex3d",du,"Vertex",3,aA);d4.drawArrays(d4.TRIANGLE_FAN,0,aj.length/3);d4.disable(d4.POLYGON_OFFSET_FILL)}};bO.prototype.ellipse=function(ed,ec,d8,ef){ed=ed||0;ec=ec||0;if(d8<=0&&ef<=0){return}if(cM===2){d8*=2;ef*=2}else{if(cM===1){d8=d8-ed;ef=ef-ec;ed+=d8/2;ec+=ef/2}else{if(cM===0){ed+=d8/2;ec+=ef/2}}}if(d8===ef){d4.beginPath();d4.arc(ed,ec,d8/2,0,6.283185307179586,false);bk();dc()}else{var ee=d8/2,eb=ef/2,d7=0.5522847498307933,ea=d7*ee,d9=d7*eb;cV.beginShape();cV.vertex(ed+ee,ec);cV.bezierVertex(ed+ee,ec-d9,ed+ea,ec-eb,ed,ec-eb);cV.bezierVertex(ed-ea,ec-eb,ed-ee,ec-d9,ed-ee,ec);cV.bezierVertex(ed-ee,ec+d9,ed-ea,ec+eb,ed,ec+eb);cV.bezierVertex(ed+ea,ec+eb,ed+ee,ec+d9,ed+ee,ec);cV.endShape()}};by.prototype.ellipse=function(ek,ej,d9,em){ek=ek||0;ej=ej||0;if(d9<=0&&em<=0){return}if(cM===2){d9*=2;em*=2}else{if(cM===1){d9=d9-ek;em=em-ej;ek+=d9/2;ej+=em/2}else{if(cM===0){ek+=d9/2;ej+=em/2}}}var el=d9/2,eg=em/2,d7=0.5522847498307933,eb=d7*el,ea=d7*eg;cV.beginShape();cV.vertex(ek+el,ej);cV.bezierVertex(ek+el,ej-ea,0,ek+eb,ej-eg,0,ek,ej-eg,0);cV.bezierVertex(ek-eb,ej-eg,0,ek-el,ej-ea,0,ek-el,ej,0);cV.bezierVertex(ek-el,ej+ea,0,ek-eb,ej+eg,0,ek,ej+eg,0);cV.bezierVertex(ek+eb,ej+eg,0,ek+el,ej+ea,0,ek+el,ej,0);cV.endShape();if(aF){var ec=0,eh=0,ee,ed;for(ee=0;ee<a7.length;ee++){ec+=a7[ee][0];eh+=a7[ee][1]}ec/=a7.length;eh/=a7.length;var ef=[],d8=[],ei=[];ef[0]=ec;ef[1]=eh;ef[2]=0;ef[3]=0;ef[4]=0;ef[5]=bl[0];ef[6]=bl[1];ef[7]=bl[2];ef[8]=bl[3];ef[9]=cZ[0];ef[10]=cZ[1];ef[11]=cZ[2];ef[12]=cZ[3];ef[13]=a4;ef[14]=a3;ef[15]=a2;a7.unshift(ef);for(ee=0;ee<a7.length;ee++){for(ed=0;ed<3;ed++){d8.push(a7[ee][ed])}for(ed=5;ed<9;ed++){ei.push(a7[ee][ed])}}dk(d8,"TRIANGLE_FAN",ei)}};cV.normal=function(d7,d9,d8){if(arguments.length!==3||!(typeof d7==="number"&&typeof d9==="number"&&typeof d8==="number")){throw"normal() requires three numeric arguments."}a4=d7;a3=d9;a2=d8;if(dN!==0){if(aY===0){aY=1}else{if(aY===1){aY=2}}}};cV.save=function(d8,d7){if(d7!==r){return B.open(d7.toDataURL(),"_blank")}return B.open(cV.externals.canvas.toDataURL(),"_blank")};var cv=0;cV.saveFrame=function(d7){if(d7===r){d7="screen-####.png"}var d8=d7.replace(/#+/,function(ea){var d9=""+cv++;while(d9.length<ea.length){d9="0"+d9}return d9});cV.save(d8)};var cb=d.createElement("canvas").getContext("2d");var V=[r,r,r];function bv(ee,d8,ed){var ea=V.shift();if(ea===r){ea={};ea.canvas=d.createElement("canvas");ea.context=ea.canvas.getContext("2d")}V.push(ea);var d9=ea.canvas,eb=ea.context,ec=d8||ee.width,d7=ed||ee.height;d9.width=ec;d9.height=d7;if(!ee){eb.clearRect(0,0,ec,d7)}else{if("data" in ee){eb.putImageData(ee,0,0)}else{eb.clearRect(0,0,ec,d7);eb.drawImage(ee,0,0,ec,d7)}}return ea}function bZ(d7){return{getLength:function(d8){return function(){if(d8.isRemote){throw"Image is loaded remotely. Cannot get length."}else{return d8.imageData.data.length?d8.imageData.data.length/4:0}}}(d7),getPixel:function(d8){return function(d9){var eb=d9*4,ea=d8.imageData.data;if(d8.isRemote){throw"Image is loaded remotely. Cannot get pixels."}return(ea[eb+3]&255)<<24|(ea[eb]&255)<<16|(ea[eb+1]&255)<<8|ea[eb+2]&255}}(d7),setPixel:function(d8){return function(d9,ec){var eb=d9*4,ea=d8.imageData.data;if(d8.isRemote){throw"Image is loaded remotely. Cannot set pixel."}ea[eb+0]=(ec>>16)&255;ea[eb+1]=(ec>>8)&255;ea[eb+2]=ec&255;ea[eb+3]=(ec>>24)&255;d8.__isDirty=true}}(d7),toArray:function(d8){return function(){var d9=[],ec=d8.imageData.data,eb=d8.width*d8.height;if(d8.isRemote){throw"Image is loaded remotely. Cannot get pixels."}for(var ea=0,ed=0;ea<eb;ea++,ed+=4){d9.push((ec[ed+3]&255)<<24|(ec[ed]&255)<<16|(ec[ed+1]&255)<<8|ec[ed+2]&255)}return d9}}(d7),set:function(d8){return function(d9){var ed,ec,ee;if(this.isRemote){throw"Image is loaded remotely. Cannot set pixels."}ec=d8.imageData.data;for(var ea=0,eb=d9.length;ea<eb;ea++){ee=d9[ea];ed=ea*4;ec[ed+0]=(ee>>16)&255;ec[ed+1]=(ee>>8)&255;ec[ed+2]=ee&255;ec[ed+3]=(ee>>24)&255}d8.__isDirty=true}}(d7)}}var cF=function(ea,ed,eb){this.__isDirty=false;if(ea instanceof HTMLImageElement){this.fromHTMLImageData(ea)}else{if(ed||eb){this.width=ea||1;this.height=ed||1;var d8=this.sourceImg=d.createElement("canvas");d8.width=this.width;d8.height=this.height;var ee=this.imageData=d8.getContext("2d").createImageData(this.width,this.height);this.format=eb===2||eb===4?eb:1;if(this.format===1){for(var d9=3,ec=this.imageData.data,d7=ec.length;d9<d7;d9+=4){ec[d9]=255}}this.__isDirty=true;this.updatePixels()}else{this.width=0;this.height=0;this.imageData=cb.createImageData(1,1);this.format=2}}this.pixels=bZ(this)};cF.prototype={__isPImage:true,updatePixels:function(){var d7=this.sourceImg;if(d7&&d7 instanceof HTMLCanvasElement&&this.__isDirty){d7.getContext("2d").putImageData(this.imageData,0,0)}this.__isDirty=false},fromHTMLImageData:function(d7){var d8=bv(d7);try{var ea=d8.context.getImageData(0,0,d7.width,d7.height);this.fromImageData(ea)}catch(d9){if(d7.width&&d7.height){this.isRemote=true;this.width=d7.width;this.height=d7.height}}this.sourceImg=d7},get:function(d7,ea,d8,d9){if(!arguments.length){return cV.get(this)}if(arguments.length===2){return cV.get(d7,ea,this)}if(arguments.length===4){return cV.get(d7,ea,d8,d9,this)}},set:function(d7,d9,d8){cV.set(d7,d9,d8,this);this.__isDirty=true},blend:function(ef,eb,ea,d8,ed,eg,ee,ec,d7,d9){if(arguments.length===9){cV.blend(this,ef,eb,ea,d8,ed,eg,ee,ec,d7,this)}else{if(arguments.length===10){cV.blend(ef,eb,ea,d8,ed,eg,ee,ec,d7,d9,this)}}delete this.sourceImg},copy:function(ee,eb,ea,d9,d8,ef,ed,ec,d7){if(arguments.length===8){cV.blend(this,ee,eb,ea,d9,d8,ef,ed,ec,0,this)}else{if(arguments.length===9){cV.blend(ee,eb,ea,d9,d8,ef,ed,ec,d7,0,this)}}delete this.sourceImg},filter:function(d8,d7){if(arguments.length===2){cV.filter(d8,d7,this)}else{if(arguments.length===1){cV.filter(d8,null,this)}}delete this.sourceImg},save:function(d7){cV.save(d7,this)},resize:function(d7,d9){if(this.isRemote){throw"Image is loaded remotely. Cannot resize."}if(this.width!==0||this.height!==0){if(d7===0&&d9!==0){d7=o.floor(this.width/this.height*d9)}else{if(d9===0&&d7!==0){d9=o.floor(this.height/this.width*d7)}}var d8=bv(this.imageData).canvas;var ea=bv(d8,d7,d9).context.getImageData(0,0,d7,d9);this.fromImageData(ea)}},mask:function(d7){var ea=this.toImageData(),d9,d8;if(d7 instanceof cF||d7.__isPImage){if(d7.width===this.width&&d7.height===this.height){d7=d7.toImageData();for(d9=2,d8=this.width*this.height*4;d9<d8;d9+=4){ea.data[d9+1]=d7.data[d9]}}else{throw"mask must have the same dimensions as PImage."}}else{if(d7 instanceof Array){if(this.width*this.height===d7.length){for(d9=0,d8=d7.length;d9<d8;++d9){ea.data[d9*4+3]=d7[d9]}}else{throw"mask array must be the same length as PImage pixels array."}}}this.fromImageData(ea)},loadPixels:E,toImageData:function(){if(this.isRemote){return this.sourceImg}if(!this.__isDirty){return this.imageData}var d7=bv(this.imageData);return d7.context.getImageData(0,0,this.width,this.height)},toDataURL:function(){if(this.isRemote){throw"Image is loaded remotely. Cannot create dataURI."}var d7=bv(this.imageData);return d7.canvas.toDataURL()},fromImageData:function(eb){var d8=eb.width,ea=eb.height,d9=d.createElement("canvas"),d7=d9.getContext("2d");this.width=d9.width=d8;this.height=d9.height=ea;d7.putImageData(eb,0,0);this.format=2;this.imageData=eb;this.sourceImg=d9}};cV.PImage=cF;cV.createImage=function(d7,d8,d9){return new cF(d7,d8,d9)};cV.loadImage=function(d8,d9,eb){if(d9){d8=d8+"."+d9}var ea;if(cP.imageCache.images[d8]){ea=new cF(cP.imageCache.images[d8]);ea.loaded=true;return ea}ea=new cF;var d7=d.createElement("img");ea.sourceImg=d7;d7.onload=function(ef,ed,ec){var eg=ef;var ee=ed;var eh=ec;return function(){ee.fromHTMLImageData(eg);ee.loaded=true;if(eh){eh()}}}(d7,ea,eb);d7.src=d8;return ea};cV.requestImage=cV.loadImage;function c8(d7,ea){var d8;if(d7>=cV.width||d7<0||ea<0||ea>=cV.height){return 0}if(dR){var d9=((0|d7)+cV.width*(0|ea))*4;d8=cV.imageData.data;return(d8[d9+3]&255)<<24|(d8[d9]&255)<<16|(d8[d9+1]&255)<<8|d8[d9+2]&255}d8=cV.toImageData(0|d7,0|ea,1,1).data;return(d8[3]&255)<<24|(d8[0]&255)<<16|(d8[1]&255)<<8|d8[2]&255}function c7(d7,eb,d8){if(d8.isRemote){throw"Image is loaded remotely. Cannot get x,y."}var ea=eb*d8.width*4+d7*4,d9=d8.imageData.data;return(d9[ea+3]&255)<<24|(d9[ea]&255)<<16|(d9[ea+1]&255)<<8|d9[ea+2]&255}function c5(d7,eb,d8,d9){var ea=new cF(d8,d9,2);ea.fromImageData(cV.toImageData(d7,eb,d8,d9));return ea}function c4(ec,eb,ed,ei,eo){if(eo.isRemote){throw"Image is loaded remotely. Cannot get x,y,w,h."}var em=new cF(ed,ei,2),d9=em.imageData.data,ea=eo.width,ej=eo.height,el=eo.imageData.data;var d7=o.max(0,-eb),d8=o.max(0,-ec),ee=o.min(ei,ej-eb),ef=o.min(ed,ea-ec);for(var eh=d7;eh<ee;++eh){var ek=((eb+eh)*ea+(ec+d8))*4;var en=(eh*ed+d8)*4;for(var eg=d8;eg<ef;++eg){d9[en++]=el[ek++];d9[en++]=el[ek++];d9[en++]=el[ek++];d9[en++]=el[ek++]}}em.__isDirty=true;return em}cV.get=function(d7,eb,d8,ea,d9){if(d9!==undefined){return c4(d7,eb,d8,ea,d9)}if(ea!==undefined){return c5(d7,eb,d8,ea)}if(d8!==undefined){return c7(d7,eb,d8)}if(eb!==undefined){return c8(d7,eb)}if(d7!==undefined){return c4(0,0,d7.width,d7.height,d7)}return c5(0,0,cV.width,cV.height)};cV.createGraphics=function(d7,d9,d8){var ea=new D;ea.size(d7,d9,d8);return ea};function R(){if(dR){d4=ai;dR=false;cV.updatePixels()}}function cp(){function d8(ec,ea){function eb(){R();d4[ea].apply(d4,arguments)}ec[ea]=eb}function d7(ed,eb){function ea(){R();return d4[eb]}function ec(ee){R();d4[eb]=ee}cV.defineProperty(ed,eb,{get:ea,set:ec})}for(var d9 in d4){if(typeof d4[d9]==="function"){d8(this,d9)}else{d7(this,d9)}}}function cB(){if(dR){return}cV.loadPixels();if(cm===null){ai=d4;cm=new cp}dR=true;d4=cm;dZ=0}function bu(d7,d9,d8){if(d7<cV.width&&d7>=0&&d9>=0&&d9<cV.height){cB();cV.pixels.setPixel((0|d7)+cV.width*(0|d9),d8);if(++dZ>bY){R()}}}function bs(d7,ed,ea,d8){if(d8.isRemote){throw"Image is loaded remotely. Cannot set x,y."}var ec=cV.color.toArray(ea);var eb=ed*d8.width*4+d7*4;var d9=d8.imageData.data;d9[eb]=ec[0];d9[eb+1]=ec[1];d9[eb+2]=ec[2];d9[eb+3]=ec[3]}cV.set=function(d7,ec,ea,d9){var d8,eb;if(arguments.length===3){if(typeof ea==="number"){bu(d7,ec,ea)}else{if(ea instanceof cF||ea.__isPImage){cV.image(ea,d7,ec)}}}else{if(arguments.length===4){bs(d7,ec,ea,d9)}}};cV.imageData={};cV.pixels={getLength:function(){return cV.imageData.data.length?cV.imageData.data.length/4:0},getPixel:function(d7){var d9=d7*4,d8=cV.imageData.data;return d8[d9+3]<<24&4278190080|d8[d9+0]<<16&16711680|d8[d9+1]<<8&65280|d8[d9+2]&255},setPixel:function(d7,ea){var d9=d7*4,d8=cV.imageData.data;d8[d9+0]=(ea&16711680)>>>16;d8[d9+1]=(ea&65280)>>>8;d8[d9+2]=ea&255;d8[d9+3]=(ea&4278190080)>>>24},toArray:function(){var d7=[],d9=cV.imageData.width*cV.imageData.height,ea=cV.imageData.data;for(var d8=0,eb=0;d8<d9;d8++,eb+=4){d7.push(ea[eb+3]<<24&4278190080|ea[eb+0]<<16&16711680|ea[eb+1]<<8&65280|ea[eb+2]&255)}return d7},set:function(d7){for(var d8=0,d9=d7.length;d8<d9;d8++){this.setPixel(d8,d7[d8])}}};cV.loadPixels=function(){cV.imageData=dU.$ensureContext().getImageData(0,0,cV.width,cV.height)};cV.updatePixels=function(){if(cV.imageData){dU.$ensureContext().putImageData(cV.imageData,0,0)}};cV.hint=function(d8){var d7=dU.$ensureContext();if(d8===4){d7.disable(d7.DEPTH_TEST);d7.depthMask(false);d7.clear(d7.DEPTH_BUFFER_BIT)}else{if(d8===-4){d7.enable(d7.DEPTH_TEST);d7.depthMask(true)}}};var bB=function(ea,d9,d8,d7){var eb;if(ea instanceof cF||ea.__isPImage){eb=ea;if(!eb.loaded){throw"Error using image in background(): PImage not loaded."}if(eb.width!==cV.width||eb.height!==cV.height){throw"Background image must be the same dimensions as the canvas."}}else{eb=cV.color(ea,d9,d8,d7)}a0=eb};bO.prototype.background=function(ea,d9,d8,d7){if(ea!==r){bB(ea,d9,d8,d7)}if(a0 instanceof cF||a0.__isPImage){aC();d4.setTransform(1,0,0,1,0,0);cV.image(a0,0,0);cO()}else{aC();d4.setTransform(1,0,0,1,0,0);if(cV.alpha(a0)!==bR){d4.clearRect(0,0,cV.width,cV.height)}d4.fillStyle=cV.color.toString(a0);d4.fillRect(0,0,cV.width,cV.height);ap=true;cO()}};by.prototype.background=function(ea,d9,d8,d7){if(arguments.length>0){bB(ea,d9,d8,d7)}var eb=cV.color.toGLArray(a0);d4.clearColor(eb[0],eb[1],eb[2],eb[3]);d4.clear(d4.COLOR_BUFFER_BIT|d4.DEPTH_BUFFER_BIT)};bO.prototype.image=function(ea,ef,ed,eg,eb){ef=o.round(ef);ed=o.round(ed);if(ea.width>0){var eh=eg||ea.width;var ee=eb||ea.height;var d7=bh(ef||0,ed||0,eg||ea.width,eb||ea.height,arguments.length<4);var ec=!!ea.sourceImg&&bb===null;if(ec){var d8=ea.sourceImg;if(ea.__isDirty){ea.updatePixels()}d4.drawImage(d8,0,0,d8.width,d8.height,d7.x,d7.y,d7.w,d7.h)}else{var d9=ea.toImageData();if(bb!==null){bb(d9);ea.__isDirty=true}d4.drawImage(bv(d9).canvas,0,0,ea.width,ea.height,d7.x,d7.y,d7.w,d7.h)}}};by.prototype.image=function(d9,d7,eb,d8,ea){if(d9.width>0){d7=o.round(d7);eb=o.round(eb);d8=d8||d9.width;ea=ea||d9.height;cV.beginShape(cV.QUADS);cV.texture(d9);cV.vertex(d7,eb,0,0,0);cV.vertex(d7,eb+ea,0,0,ea);cV.vertex(d7+d8,eb+ea,0,d8,ea);cV.vertex(d7+d8,eb,0,d8,0);cV.endShape()}};cV.tint=function(ea,d9,d7,ef){var ec=cV.color(ea,d9,d7,ef);var d8=cV.red(ec)/bG;var eb=cV.green(ec)/bF;var ed=cV.blue(ec)/bD;var ee=cV.alpha(ec)/bR;bb=function(ej){var ei=ej.data,eh=4*ej.width*ej.height;for(var eg=0;eg<eh;){ei[eg++]*=d8;ei[eg++]*=eb;ei[eg++]*=ed;ei[eg++]*=ee}};bt=function(eh){for(var eg=0;eg<eh.length;){eh[eg++]=d8;eh[eg++]=eb;eh[eg++]=ed;eh[eg++]=ee}}};cV.noTint=function(){bb=null;bt=null};cV.copy=function(d7,ec,eb,ed,d9,ef,ee,d8,ea){if(ea===r){ea=d8;d8=ee;ee=ef;ef=d9;d9=ed;ed=eb;eb=ec;ec=d7;d7=cV}cV.blend(d7,ec,eb,ed,d9,ef,ee,d8,ea,0)};cV.blend=function(d7,eh,eg,ek,ec,em,el,d8,ee,ed,ea){if(d7.isRemote){throw"Image is loaded remotely. Cannot blend image."}if(ed===r){ed=ee;ee=d8;d8=el;el=em;em=ec;ec=ek;ek=eg;eg=eh;eh=d7;d7=cV}var d9=eh+ek,ef=eg+ec,ej=em+d8,eb=el+ee,ei=ea||cV;if(ea===r||ed===r){cV.loadPixels()}d7.loadPixels();if(d7===cV&&cV.intersect(eh,eg,d9,ef,em,el,ej,eb)){cV.blit_resize(cV.get(eh,eg,d9-eh,ef-eg),0,0,d9-eh-1,ef-eg-1,ei.imageData.data,ei.width,ei.height,em,el,ej,eb,ed)}else{cV.blit_resize(d7,eh,eg,d9,ef,ei.imageData.data,ei.width,ei.height,em,el,ej,eb,ed)}if(ea===r){cV.updatePixels()}};var bm=function(eb){var d7=cV.floor(eb*3.5),d9,d8;d7=d7<1?1:d7<248?d7:248;if(cV.shared.blurRadius!==d7){cV.shared.blurRadius=d7;cV.shared.blurKernelSize=1+(cV.shared.blurRadius<<1);cV.shared.blurKernel=new e(cV.shared.blurKernelSize);var ed=cV.shared.blurKernel;var ec=cV.shared.blurKernelSize;var ea=cV.shared.blurRadius;for(d9=0;d9<ec;d9++){ed[d9]=0}var ee=(d7-1)*(d7-1);for(d9=1;d9<d7;d9++){ed[d7+d9]=ed[d8]=ee}ed[d7]=d7*d7}};var b6=function(el,eq){var d9,ec,ei,en,eo,ex,ep;var es,ek,ew,ev,em;var ef=eq.pixels.getLength();var er=new e(ef);var eA=new e(ef);var ee=new e(ef);var ez=new e(ef);var ey=0;var eh,eg,eu,eb;bm(el);var d8=eq.height;var d7=eq.width;var et=cV.shared.blurKernelSize;var ej=cV.shared.blurRadius;var ed=cV.shared.blurKernel;var ea=eq.imageData.data;for(eg=0;eg<d8;eg++){for(eh=0;eh<d7;eh++){en=ei=ec=eo=d9=0;es=eh-ej;if(es<0){em=-es;es=0}else{if(es>=d7){break}em=0}for(eu=em;eu<et;eu++){if(es>=d7){break}eb=(es+ey)*4;ep=ed[eu];eo+=ep*ea[eb+3];ec+=ep*ea[eb];ei+=ep*ea[eb+1];en+=ep*ea[eb+2];d9+=ep;es++}ek=ey+eh;ez[ek]=eo/d9;er[ek]=ec/d9;eA[ek]=ei/d9;ee[ek]=en/d9}ey+=d7}ey=0;ew=-ej;ev=ew*d7;for(eg=0;eg<d8;eg++){for(eh=0;eh<d7;eh++){en=ei=ec=eo=d9=0;if(ew<0){em=ek=-ew;es=eh}else{if(ew>=d8){break}em=0;ek=ew;es=eh+ev}for(eu=em;eu<et;eu++){if(ek>=d8){break}ep=ed[eu];eo+=ep*ez[es];ec+=ep*er[es];ei+=ep*eA[es];en+=ep*ee[es];d9+=ep;ek++;es+=d7}eb=(eh+ey)*4;ea[eb]=ec/d9;ea[eb+1]=ei/d9;ea[eb+2]=en/d9;ea[eb+3]=eo/d9}ey+=d7;ev+=d7;ew++}};var ce=function(eo,ei){var ee=0;var es=ei.pixels.getLength();var ej=new I(es);var em,d8,eh,eg,ea;var en,eb,ed,ef,d9,ek,er,d7,ep,ec,eq,el;if(!eo){while(ee<es){em=ee;d8=ee+ei.width;while(ee<d8){eh=eg=ei.pixels.getPixel(ee);eb=ee-1;en=ee+1;ed=ee-ei.width;ef=ee+ei.width;if(eb<em){eb=ee}if(en>=d8){en=ee}if(ed<0){ed=0}if(ef>=es){ef=ee}er=ei.pixels.getPixel(ed);ek=ei.pixels.getPixel(eb);d7=ei.pixels.getPixel(ef);d9=ei.pixels.getPixel(en);ea=77*(eh>>16&255)+151*(eh>>8&255)+28*(eh&255);ec=77*(ek>>16&255)+151*(ek>>8&255)+28*(ek&255);ep=77*(d9>>16&255)+151*(d9>>8&255)+28*(d9&255);eq=77*(er>>16&255)+151*(er>>8&255)+28*(er&255);el=77*(d7>>16&255)+151*(d7>>8&255)+28*(d7&255);if(ec>ea){eg=ek;ea=ec}if(ep>ea){eg=d9;ea=ep}if(eq>ea){eg=er;ea=eq}if(el>ea){eg=d7;ea=el}ej[ee++]=eg}}}else{while(ee<es){em=ee;d8=ee+ei.width;while(ee<d8){eh=eg=ei.pixels.getPixel(ee);eb=ee-1;en=ee+1;ed=ee-ei.width;ef=ee+ei.width;if(eb<em){eb=ee}if(en>=d8){en=ee}if(ed<0){ed=0}if(ef>=es){ef=ee}er=ei.pixels.getPixel(ed);ek=ei.pixels.getPixel(eb);d7=ei.pixels.getPixel(ef);d9=ei.pixels.getPixel(en);ea=77*(eh>>16&255)+151*(eh>>8&255)+28*(eh&255);ec=77*(ek>>16&255)+151*(ek>>8&255)+28*(ek&255);ep=77*(d9>>16&255)+151*(d9>>8&255)+28*(d9&255);eq=77*(er>>16&255)+151*(er>>8&255)+28*(er&255);el=77*(d7>>16&255)+151*(d7>>8&255)+28*(d7&255);if(ec<ea){eg=ek;ea=ec}if(ep<ea){eg=d9;ea=ep}if(eq<ea){eg=er;ea=eq}if(el<ea){eg=d7;ea=el}ej[ee++]=eg}}}ei.pixels.set(ej)};cV.filter=function(ee,ed,ea){var eh,ec,d8,eg;if(arguments.length===3){ea.loadPixels();eh=ea}else{cV.loadPixels();eh=cV}if(ed===r){ed=null}if(eh.isRemote){throw"Image is loaded remotely. Cannot filter image."}var ei=eh.pixels.getLength();switch(ee){case 11:var ej=ed||1;b6(ej,eh);break;case 12:if(eh.format===4){for(eg=0;eg<ei;eg++){ec=255-eh.pixels.getPixel(eg);eh.pixels.setPixel(eg,4278190080|ec<<16|ec<<8|ec)}eh.format=1}else{for(eg=0;eg<ei;eg++){ec=eh.pixels.getPixel(eg);d8=77*(ec>>16&255)+151*(ec>>8&255)+28*(ec&255)>>8;eh.pixels.setPixel(eg,ec&4278190080|d8<<16|d8<<8|d8)}}break;case 13:for(eg=0;eg<ei;eg++){eh.pixels.setPixel(eg,eh.pixels.getPixel(eg)^16777215)}break;case 15:if(ed===null){throw"Use filter(POSTERIZE, int levels) instead of filter(POSTERIZE)"}var em=cV.floor(ed);if(em<2||em>255){throw"Levels must be between 2 and 255 for filter(POSTERIZE, levels)"}var ef=em-1;for(eg=0;eg<ei;eg++){var d7=eh.pixels.getPixel(eg)>>16&255;var ek=eh.pixels.getPixel(eg)>>8&255;var d9=eh.pixels.getPixel(eg)&255;d7=(d7*em>>8)*255/ef;ek=(ek*em>>8)*255/ef;d9=(d9*em>>8)*255/ef;eh.pixels.setPixel(eg,4278190080&eh.pixels.getPixel(eg)|d7<<16|ek<<8|d9)}break;case 14:for(eg=0;eg<ei;eg++){eh.pixels.setPixel(eg,eh.pixels.getPixel(eg)|4278190080)}eh.format=1;break;case 16:if(ed===null){ed=0.5}if(ed<0||ed>1){throw"Level must be between 0 and 1 for filter(THRESHOLD, level)"}var eb=cV.floor(ed*255);for(eg=0;eg<ei;eg++){var el=cV.max((eh.pixels.getPixel(eg)&16711680)>>16,cV.max((eh.pixels.getPixel(eg)&65280)>>8,eh.pixels.getPixel(eg)&255));eh.pixels.setPixel(eg,eh.pixels.getPixel(eg)&4278190080|(el<eb?0:16777215))}break;case 17:ce(true,eh);break;case 18:ce(false,eh);break}eh.updatePixels()};cV.shared={fracU:0,ifU:0,fracV:0,ifV:0,u1:0,u2:0,v1:0,v2:0,sX:0,sY:0,iw:0,iw1:0,ih1:0,ul:0,ll:0,ur:0,lr:0,cUL:0,cLL:0,cUR:0,cLR:0,srcXOffset:0,srcYOffset:0,r:0,g:0,b:0,a:0,srcBuffer:null,blurRadius:0,blurKernelSize:0,blurKernel:null};cV.intersect=function(d9,eg,d8,ef,ek,ed,ej,ec){var ei=d8-d9+1;var eb=ef-eg+1;var d7=ej-ek+1;var ee=ec-ed+1;if(ek<d9){d7+=ek-d9;if(d7>ei){d7=ei}}else{var eh=ei+d9-ek;if(d7>eh){d7=eh}}if(ed<eg){ee+=ed-eg;if(ee>eb){ee=eb}}else{var ea=eb+eg-ed;if(ee>ea){ee=ea}}return !(d7<=0||ee<=0)};var dO={};dO[1]=cV.modes.blend;dO[2]=cV.modes.add;dO[4]=cV.modes.subtract;dO[8]=cV.modes.lightest;dO[16]=cV.modes.darkest;dO[0]=cV.modes.replace;dO[32]=cV.modes.difference;dO[64]=cV.modes.exclusion;dO[128]=cV.modes.multiply;dO[256]=cV.modes.screen;dO[512]=cV.modes.overlay;dO[1024]=cV.modes.hard_light;dO[2048]=cV.modes.soft_light;dO[4096]=cV.modes.dodge;dO[8192]=cV.modes.burn;cV.blit_resize=function(ek,ew,eq,ev,ep,eB,eg,eo,eu,el,et,ej,em){var ez,ey;if(ew<0){ew=0}if(eq<0){eq=0}if(ev>=ek.width){ev=ek.width-1}if(ep>=ek.height){ep=ek.height-1}var eF=ev-ew;var eK=ep-eq;var d7=et-eu;var eh=ej-el;if(d7<=0||eh<=0||eF<=0||eK<=0||eu>=eg||el>=eo||ew>=ek.width||eq>=ek.height){return}var ee=o.floor(eF/d7*32768);var eb=o.floor(eK/eh*32768);var eD=cV.shared;eD.srcXOffset=o.floor(eu<0?-eu*ee:ew*32768);eD.srcYOffset=o.floor(el<0?-el*eb:eq*32768);if(eu<0){d7+=eu;eu=0}if(el<0){eh+=el;el=0}d7=o.min(d7,eg-eu);eh=o.min(eh,eo-el);var er=el*eg+eu;var eN;eD.srcBuffer=ek.imageData.data;eD.iw=ek.width;eD.iw1=ek.width-1;eD.ih1=ek.height-1;var es=cV.filter_bilinear,eH=cV.filter_new_scanline,ef=dO[em],eE,eJ,eC,eG,d9,ea,d8=4278190080,eI=16711680,ex=65280,ed=255,eM=32767,eA=15,ei=1,en=9,ec=eD.srcBuffer,eL=o.min;for(ey=0;ey<eh;ey++){eD.sX=eD.srcXOffset;eD.fracV=eD.srcYOffset&eM;eD.ifV=eM-eD.fracV;eD.v1=(eD.srcYOffset>>eA)*eD.iw;eD.v2=eL((eD.srcYOffset>>eA)+1,eD.ih1)*eD.iw;for(ez=0;ez<d7;ez++){eJ=(er+ez)*4;eN=eB[eJ+3]<<24&d8|eB[eJ]<<16&eI|eB[eJ+1]<<8&ex|eB[eJ+2]&ed;eD.fracU=eD.sX&eM;eD.ifU=eM-eD.fracU;eD.ul=eD.ifU*eD.ifV>>eA;eD.ll=eD.ifU*eD.fracV>>eA;eD.ur=eD.fracU*eD.ifV>>eA;eD.lr=eD.fracU*eD.fracV>>eA;eD.u1=eD.sX>>eA;eD.u2=eL(eD.u1+1,eD.iw1);eC=(eD.v1+eD.u1)*4;eG=(eD.v1+eD.u2)*4;d9=(eD.v2+eD.u1)*4;ea=(eD.v2+eD.u2)*4;eD.cUL=ec[eC+3]<<24&d8|ec[eC]<<16&eI|ec[eC+1]<<8&ex|ec[eC+2]&ed;eD.cUR=ec[eG+3]<<24&d8|ec[eG]<<16&eI|ec[eG+1]<<8&ex|ec[eG+2]&ed;eD.cLL=ec[d9+3]<<24&d8|ec[d9]<<16&eI|ec[d9+1]<<8&ex|ec[d9+2]&ed;eD.cLR=ec[ea+3]<<24&d8|ec[ea]<<16&eI|ec[ea+1]<<8&ex|ec[ea+2]&ed;eD.r=eD.ul*((eD.cUL&eI)>>16)+eD.ll*((eD.cLL&eI)>>16)+eD.ur*((eD.cUR&eI)>>16)+eD.lr*((eD.cLR&eI)>>16)<<ei&eI;eD.g=eD.ul*(eD.cUL&ex)+eD.ll*(eD.cLL&ex)+eD.ur*(eD.cUR&ex)+eD.lr*(eD.cLR&ex)>>>eA&ex;eD.b=eD.ul*(eD.cUL&ed)+eD.ll*(eD.cLL&ed)+eD.ur*(eD.cUR&ed)+eD.lr*(eD.cLR&ed)>>>eA;eD.a=eD.ul*((eD.cUL&d8)>>>24)+eD.ll*((eD.cLL&d8)>>>24)+eD.ur*((eD.cUR&d8)>>>24)+eD.lr*((eD.cLR&d8)>>>24)<<en&d8;eE=ef(eN,eD.a|eD.r|eD.g|eD.b);eB[eJ]=(eE&eI)>>>16;eB[eJ+1]=(eE&ex)>>>8;eB[eJ+2]=eE&ed;eB[eJ+3]=(eE&d8)>>>24;eD.sX+=ee}er+=eg;eD.srcYOffset+=eb}};cV.loadFont=function(d8,d9){if(d8===r){throw"font name required in loadFont."}if(d8.indexOf(".svg")===-1){if(d9===r){d9=U.size}return F.get(d8,d9)}var d7=cV.loadGlyphs(d8);return{name:d8,css:"12px sans-serif",glyph:true,units_per_em:d7.units_per_em,horiz_adv_x:1/d7.units_per_em*d7.horiz_adv_x,ascent:d7.ascent,descent:d7.descent,width:function(ee){var ec=0;var ea=ee.length;for(var eb=0;eb<ea;eb++){try{ec+=parseFloat(cV.glyphLook(cV.glyphTable[d8],ee[eb]).horiz_adv_x)}catch(ed){D.debug(ed)}}return ec/cV.glyphTable[d8].units_per_em}}};cV.createFont=function(d7,d8){return cV.loadFont(d7,d8)};cV.textFont=function(d7,d9){if(d9!==r){if(!d7.glyph){d7=F.get(d7.name,d9)}dW=d9}U=d7;W=U.name;aZ=U.ascent;dx=U.descent;d3=U.leading;var d8=dU.$ensureContext();d8.font=U.css};cV.textSize=function(d8){if(d8!==dW){U=F.get(W,d8);dW=d8;aZ=U.ascent;dx=U.descent;d3=U.leading;var d7=dU.$ensureContext();d7.font=U.css}};cV.textAscent=function(){return aZ};cV.textDescent=function(){return dx};cV.textLeading=function(d7){d3=d7};cV.textAlign=function(d8,d7){L=d8;c0=d7||0};function br(d7){if(d7 instanceof String){return d7}if(typeof d7==="number"){if(d7===(0|d7)){return d7.toString()}return cV.nf(d7,0,3)}if(d7===null||d7===r){return""}return d7.toString()}bO.prototype.textWidth=function(eb){var d7=br(eb).split(/\r?\n/g),d9=0;var d8,ea=d7.length;d4.font=U.css;for(d8=0;d8<ea;++d8){d9=o.max(d9,U.measureTextWidth(d7[d8]))}return d9|0};by.prototype.textWidth=function(ec){var d7=br(ec).split(/\r?\n/g),ea=0;var d9,eb=d7.length;if(cD===r){cD=d.createElement("canvas")}var d8=cD.getContext("2d");d8.font=U.css;for(d9=0;d9<eb;++d9){ea=o.max(ea,d8.measureText(d7[d9]).width)}return ea|0};cV.glyphLook=function(d7,d8){try{switch(d8){case"1":return d7.one;case"2":return d7.two;case"3":return d7.three;case"4":return d7.four;case"5":return d7.five;case"6":return d7.six;case"7":return d7.seven;case"8":return d7.eight;case"9":return d7.nine;case"0":return d7.zero;case" ":return d7.space;case"$":return d7.dollar;case"!":return d7.exclam;case'"':return d7.quotedbl;case"#":return d7.numbersign;case"%":return d7.percent;case"&":return d7.ampersand;case"'":return d7.quotesingle;case"(":return d7.parenleft;case")":return d7.parenright;case"*":return d7.asterisk;case"+":return d7.plus;case",":return d7.comma;case"-":return d7.hyphen;case".":return d7.period;case"/":return d7.slash;case"_":return d7.underscore;case":":return d7.colon;case";":return d7.semicolon;case"<":return d7.less;case"=":return d7.equal;case">":return d7.greater;case"?":return d7.question;case"@":return d7.at;case"[":return d7.bracketleft;case"\\":return d7.backslash;case"]":return d7.bracketright;case"^":return d7.asciicircum;case"`":return d7.grave;case"{":return d7.braceleft;case"|":return d7.bar;case"}":return d7.braceright;case"~":return d7.asciitilde;default:return d7[d8]}}catch(d9){D.debug(d9)}};bO.prototype.text$line=function(ef,ei,eh,eg,ec){var ee=0,ed=0;if(!U.glyph){if(ef&&"fillText" in d4){if(ap){d4.fillStyle=cV.color.toString(aX);ap=false}if(ec===39||ec===3){ee=U.measureTextWidth(ef);if(ec===39){ed=-ee}else{ed=-ee/2}}d4.fillText(ef,ei+ed,eh)}}else{var d7=cV.glyphTable[W];aC();d4.translate(ei,eh+dW);if(ec===39||ec===3){ee=d7.width(ef);if(ec===39){ed=-ee}else{ed=-ee/2}}var ej=d7.units_per_em,eb=1/ej*dW;d4.scale(eb,eb);for(var d8=0,d9=ef.length;d8<d9;d8++){try{cV.glyphLook(d7,ef[d8]).draw()}catch(ea){D.debug(ea)}}cO()}};by.prototype.text$line=function(ee,ei,eh,ef,ec){if(cD===r){cD=d.createElement("canvas")}var d8=d4;d4=cD.getContext("2d");d4.font=U.css;var ed=U.measureTextWidth(ee);cD.width=ed;cD.height=dW;d4=cD.getContext("2d");d4.font=U.css;d4.textBaseline="top";bO.prototype.text$line(ee,0,0,0,37);var d7=cD.width/cD.height;d4=d8;d4.bindTexture(d4.TEXTURE_2D,bP);d4.texImage2D(d4.TEXTURE_2D,0,d4.RGBA,d4.RGBA,d4.UNSIGNED_BYTE,cD);d4.texParameteri(d4.TEXTURE_2D,d4.TEXTURE_MAG_FILTER,d4.LINEAR);d4.texParameteri(d4.TEXTURE_2D,d4.TEXTURE_MIN_FILTER,d4.LINEAR);d4.texParameteri(d4.TEXTURE_2D,d4.TEXTURE_WRAP_T,d4.CLAMP_TO_EDGE);d4.texParameteri(d4.TEXTURE_2D,d4.TEXTURE_WRAP_S,d4.CLAMP_TO_EDGE);var eb=0;if(ec===39){eb=-ed}else{if(ec===3){eb=-ed/2}}var d9=new aM;var ea=dW*0.5;d9.translate(ei+eb-ea/2,eh-ea,ef);d9.scale(-d7*ea,-ea,ea);d9.translate(-1,-1,-1);d9.transpose();var eg=new aM;eg.scale(1,-1,1);eg.apply(dF.array());eg.transpose();d4.useProgram(dM);db("vertex2d",dM,"Vertex",3,cG);db("aTextureCoord2d",dM,"aTextureCoord",2,aa);dV("uSampler2d",dM,"uSampler",[0]);dV("picktype2d",dM,"picktype",1);a5("model2d",dM,"model",false,d9.array());a5("view2d",dM,"view",false,eg.array());dY("color2d",dM,"color",bl);d4.bindBuffer(d4.ELEMENT_ARRAY_BUFFER,P);d4.drawElements(d4.TRIANGLES,6,d4.UNSIGNED_SHORT,0)};function be(ea,ed,ec,eb){var ef,d9;if(ea.indexOf("\n")<0){ef=[ea];d9=1}else{ef=ea.split(/\r?\n/g);d9=ef.length}var d7=0;if(c0===101){d7=aZ+dx}else{if(c0===3){d7=aZ/2-(d9-1)*d3/2}else{if(c0===102){d7=-(dx+(d9-1)*d3)}}}for(var d8=0;d8<d9;++d8){var ee=ef[d8];dU.text$line(ee,ed,ec+d7,eb,L);d7+=d3}}function a9(en,ei,eh,em,ek,eg){if(en.length===0||em===0||ek===0){return}if(dW>ek){return}var ej=-1;var eb=0;var d7=0;var ed=[];for(var ec=0,ep=en.length;ec<ep;ec++){var ee=en[ec];var es=ee===" ";var el=U.measureTextWidth(ee);if(ee!=="\n"&&d7+el<=em){if(es){ej=ec}d7+=el}else{if(ej+1===eb){if(ec>0){ej=ec}else{return}}if(ee==="\n"){ed.push({text:en.substring(eb,ec),width:d7});eb=ec+1}else{ed.push({text:en.substring(eb,ej+1),width:d7});eb=ej+1}d7=0;ec=eb-1}}if(eb<ep){ed.push({text:en.substring(eb),width:d7})}var er=1,ef=aZ;if(L===3){er=em/2}else{if(L===39){er=em}}var eo=ed.length,d8=o.min(eo,o.floor(ek/d3));if(c0===101){ef=aZ+dx}else{if(c0===3){ef=ek/2-d3*(d8/2-1)}else{if(c0===102){ef=dx+d3}}}var d9,ea,eq;for(d9=0;d9<eo;d9++){eq=d9*d3;if(ef+eq>ek-dx){break}ea=ed[d9];dU.text$line(ea.text,ei+er,eh+ef+eq,eg,L)}}cV.text=function(){if(cH===5){return}if(arguments.length===3){be(br(arguments[0]),arguments[1],arguments[2],0)}else{if(arguments.length===4){be(br(arguments[0]),arguments[1],arguments[2],arguments[3])}else{if(arguments.length===5){a9(br(arguments[0]),arguments[1],arguments[2],arguments[3],arguments[4],0)}else{if(arguments.length===6){a9(br(arguments[0]),arguments[1],arguments[2],arguments[3],arguments[4],arguments[5])}}}}};cV.textMode=function(d7){cH=d7};cV.loadGlyphs=function(ed){var ef,ee,eb,d9,em,el,ek,en,eh,eo,ei,ej="[0-9\\-]+",eg;var ec=function(eu,et){var er=0,eq=[],ep,es=new RegExp(eu,"g");ep=eq[er]=es.exec(et);while(ep){er++;ep=eq[er]=es.exec(et)}return eq};var d8=function(eu){var ev=ec("[A-Za-z][0-9\\- ]+|Z",eu);var et=function(){aC();return dU.$ensureContext()};var er=function(){bk();dc();cO()};eg="return {draw:function(){var curContext=beforePathDraw();curContext.beginPath();";ef=0;ee=0;eb=0;d9=0;em=0;el=0;eu=0;en=0;eh="";eo=ev.length-1;for(var eq=0;eq<eo;eq++){var ep=ev[eq][0],es=ec(ej,ep);switch(ep[0]){case"M":ef=parseFloat(es[0][0]);ee=parseFloat(es[1][0]);eg+="curContext.moveTo("+ef+","+-ee+");";break;case"L":ef=parseFloat(es[0][0]);ee=parseFloat(es[1][0]);eg+="curContext.lineTo("+ef+","+-ee+");";break;case"H":ef=parseFloat(es[0][0]);eg+="curContext.lineTo("+ef+","+-ee+");";break;case"V":ee=parseFloat(es[0][0]);eg+="curContext.lineTo("+ef+","+-ee+");";break;case"T":em=parseFloat(es[0][0]);el=parseFloat(es[1][0]);if(eh==="Q"||eh==="T"){eu=o.sqrt(o.pow(ef-eb,2)+o.pow(d9-ee,2));en=o.PI+o.atan2(eb-ef,d9-ee);eb=ef+o.sin(en)*eu;d9=ee+o.cos(en)*eu}else{eb=ef;d9=ee}eg+="curContext.quadraticCurveTo("+eb+","+-d9+","+em+","+-el+");";ef=em;ee=el;break;case"Q":eb=parseFloat(es[0][0]);d9=parseFloat(es[1][0]);em=parseFloat(es[2][0]);el=parseFloat(es[3][0]);eg+="curContext.quadraticCurveTo("+eb+","+-d9+","+em+","+-el+");";ef=em;ee=el;break;case"Z":eg+="curContext.closePath();";break}eh=ep[0]}eg+="afterPathDraw();";eg+="curContext.translate("+ei+",0);";eg+="}}";return(new Function("beforePathDraw","afterPathDraw",eg))(et,er)};var d7=function(es){var er=es.getElementsByTagName("font");cV.glyphTable[ed].horiz_adv_x=er[0].getAttribute("horiz-adv-x");var eu=es.getElementsByTagName("font-face")[0];cV.glyphTable[ed].units_per_em=parseFloat(eu.getAttribute("units-per-em"));cV.glyphTable[ed].ascent=parseFloat(eu.getAttribute("ascent"));cV.glyphTable[ed].descent=parseFloat(eu.getAttribute("descent"));var ew=es.getElementsByTagName("glyph"),eq=ew.length;for(var ev=0;ev<eq;ev++){var ep=ew[ev].getAttribute("unicode");var et=ew[ev].getAttribute("glyph-name");ei=ew[ev].getAttribute("horiz-adv-x");if(ei===null){ei=cV.glyphTable[ed].horiz_adv_x}ek=ew[ev].getAttribute("d");if(ek!==r){eg=d8(ek);cV.glyphTable[ed][et]={name:et,unicode:ep,horiz_adv_x:ei,draw:eg.draw}}}};var ea=function(){var er;try{er=d.implementation.createDocument("","",null)}catch(et){D.debug(et.message);return}try{er.async=false;er.load(ed);d7(er.getElementsByTagName("svg")[0])}catch(eq){D.debug(eq);try{var ep=new B.XMLHttpRequest;ep.open("GET",ed,false);ep.send(null);d7(ep.responseXML.documentElement)}catch(es){D.debug(eq)}}};cV.glyphTable[ed]={};ea(ed);return cV.glyphTable[ed]};cV.param=function(d9){var d8="data-processing-"+d9;if(ac.hasAttribute(d8)){return ac.getAttribute(d8)}for(var ea=0,d7=ac.childNodes.length;ea<d7;++ea){var eb=ac.childNodes.item(ea);if(eb.nodeType!==1||eb.tagName.toLowerCase()!=="param"){continue}if(eb.getAttribute("name")===d9){return eb.getAttribute("value")}}if(cP.params.hasOwnProperty(d9)){return cP.params[d9]}return null};function cK(d8){if(d8==="3D"){dU=new by}else{if(d8==="2D"){dU=new bO}else{dU=new b9}}for(var d7 in b9.prototype){if(b9.prototype.hasOwnProperty(d7)&&d7.indexOf("$")<0){cV[d7]=dU[d7]}}dU.$init()}function cT(d7){return function(){cK("2D");return dU[d7].apply(this,arguments)}}b9.prototype.translate=cT("translate");b9.prototype.scale=cT("scale");b9.prototype.pushMatrix=cT("pushMatrix");b9.prototype.popMatrix=cT("popMatrix");b9.prototype.resetMatrix=cT("resetMatrix");b9.prototype.applyMatrix=cT("applyMatrix");b9.prototype.rotate=cT("rotate");b9.prototype.rotateZ=cT("rotateZ");b9.prototype.redraw=cT("redraw");b9.prototype.toImageData=cT("toImageData");b9.prototype.ambientLight=cT("ambientLight");b9.prototype.directionalLight=cT("directionalLight");b9.prototype.lightFalloff=cT("lightFalloff");b9.prototype.lightSpecular=cT("lightSpecular");b9.prototype.pointLight=cT("pointLight");b9.prototype.noLights=cT("noLights");b9.prototype.spotLight=cT("spotLight");b9.prototype.beginCamera=cT("beginCamera");b9.prototype.endCamera=cT("endCamera");b9.prototype.frustum=cT("frustum");b9.prototype.box=cT("box");b9.prototype.sphere=cT("sphere");b9.prototype.ambient=cT("ambient");b9.prototype.emissive=cT("emissive");b9.prototype.shininess=cT("shininess");b9.prototype.specular=cT("specular");b9.prototype.fill=cT("fill");b9.prototype.stroke=cT("stroke");b9.prototype.strokeWeight=cT("strokeWeight");b9.prototype.smooth=cT("smooth");b9.prototype.noSmooth=cT("noSmooth");b9.prototype.point=cT("point");b9.prototype.vertex=cT("vertex");b9.prototype.endShape=cT("endShape");b9.prototype.bezierVertex=cT("bezierVertex");b9.prototype.curveVertex=cT("curveVertex");b9.prototype.curve=cT("curve");b9.prototype.line=cT("line");b9.prototype.bezier=cT("bezier");b9.prototype.rect=cT("rect");b9.prototype.ellipse=cT("ellipse");b9.prototype.background=cT("background");b9.prototype.image=cT("image");b9.prototype.textWidth=cT("textWidth");b9.prototype.text$line=cT("text$line");b9.prototype.$ensureContext=cT("$ensureContext");b9.prototype.$newPMatrix=cT("$newPMatrix");b9.prototype.size=function(d7,d9,d8){cK(d8===2?"3D":"2D");cV.size(d7,d9,d8)};b9.prototype.$init=E;bO.prototype.$init=function(){cV.size(cV.width,cV.height);d4.lineCap="round";cV.noSmooth();cV.disableContextMenu()};by.prototype.$init=function(){cV.use3DContext=true};dp.prototype.$ensureContext=function(){return d4};function dv(d8,ea){var d9=d8,d7=0,eb=0;cV.pmouseX=cV.mouseX;cV.pmouseY=cV.mouseY;if(d9.offsetParent){do{d7+=d9.offsetLeft;eb+=d9.offsetTop}while(!!(d9=d9.offsetParent))}d9=d8;do{d7-=d9.scrollLeft||0;eb-=d9.scrollTop||0}while(!!(d9=d9.parentNode));d7+=ab;eb+=dl;d7+=aR;eb+=bV;d7+=B.pageXOffset;eb+=B.pageYOffset;return{X:d7,Y:eb}}function aG(d7,d8){var d9=dv(d7,d8);cV.mouseX=d8.pageX-d9.X;cV.mouseY=d8.pageY-d9.Y}function ct(d8){var ea=dv(d8.changedTouches[0].target,d8.changedTouches[0]),d7;for(d7=0;d7<d8.touches.length;d7++){var ec=d8.touches[d7];ec.offsetX=ec.pageX-ea.X;ec.offsetY=ec.pageY-ea.Y}for(d7=0;d7<d8.targetTouches.length;d7++){var d9=d8.targetTouches[d7];d9.offsetX=d9.pageX-ea.X;d9.offsetY=d9.pageY-ea.Y}for(d7=0;d7<d8.changedTouches.length;d7++){var eb=d8.changedTouches[d7];eb.offsetX=eb.pageX-ea.X;eb.offsetY=eb.pageY-ea.Y}return d8}bM(ac,"touchstart",function(d9){ac.setAttribute("style","-webkit-user-select: none");ac.setAttribute("onclick","void(0)");ac.setAttribute("style","-webkit-tap-highlight-color:rgba(0,0,0,0)");for(var d8=0,d7=at.length;d8<d7;d8++){var ea=at[d8].type;if(ea==="mouseout"||ea==="mousemove"||ea==="mousedown"||ea==="mouseup"||ea==="DOMMouseScroll"||ea==="mousewheel"||ea==="touchstart"){dd(at[d8])}}if(cV.touchStart!==r||cV.touchMove!==r||cV.touchEnd!==r||cV.touchCancel!==r){bM(ac,"touchstart",function(eb){if(cV.touchStart!==r){eb=ct(eb);cV.touchStart(eb)}});bM(ac,"touchmove",function(eb){if(cV.touchMove!==r){eb.preventDefault();eb=ct(eb);cV.touchMove(eb)}});bM(ac,"touchend",function(eb){if(cV.touchEnd!==r){eb=ct(eb);cV.touchEnd(eb)}});bM(ac,"touchcancel",function(eb){if(cV.touchCancel!==r){eb=ct(eb);cV.touchCancel(eb)}})}else{bM(ac,"touchstart",function(eb){aG(ac,eb.touches[0]);cV.__mousePressed=true;cV.mouseDragging=false;cV.mouseButton=37;if(typeof cV.mousePressed==="function"){cV.mousePressed()}});bM(ac,"touchmove",function(eb){eb.preventDefault();aG(ac,eb.touches[0]);if(typeof cV.mouseMoved==="function"&&!cV.__mousePressed){cV.mouseMoved()}if(typeof cV.mouseDragged==="function"&&cV.__mousePressed){cV.mouseDragged();cV.mouseDragging=true}});bM(ac,"touchend",function(eb){cV.__mousePressed=false;if(typeof cV.mouseClicked==="function"&&!cV.mouseDragging){cV.mouseClicked()}if(typeof cV.mouseReleased==="function"){cV.mouseReleased()}})}ac.dispatchEvent(d9)});(function(){var d7=true,d8=function(d9){d9.preventDefault();d9.stopPropagation()};cV.disableContextMenu=function(){if(!d7){return}bM(ac,"contextmenu",d8);d7=false};cV.enableContextMenu=function(){if(d7){return}dd({elem:ac,type:"contextmenu",fn:d8});d7=true}})();bM(ac,"mousemove",function(d7){aG(ac,d7);if(typeof cV.mouseMoved==="function"&&!cV.__mousePressed){cV.mouseMoved()}if(typeof cV.mouseDragged==="function"&&cV.__mousePressed){cV.mouseDragged();cV.mouseDragging=true}});bM(ac,"mouseout",function(d7){if(typeof cV.mouseOut==="function"){cV.mouseOut()}});bM(ac,"mouseover",function(d7){aG(ac,d7);if(typeof cV.mouseOver==="function"){cV.mouseOver()}});bM(ac,"mousedown",function(d7){cV.__mousePressed=true;cV.mouseDragging=false;switch(d7.which){case 1:cV.mouseButton=37;break;case 2:cV.mouseButton=3;break;case 3:cV.mouseButton=39;break}if(typeof cV.mousePressed==="function"){cV.mousePressed()}});bM(ac,"mouseup",function(d7){cV.__mousePressed=false;if(typeof cV.mouseClicked==="function"&&!cV.mouseDragging){cV.mouseClicked()}if(typeof cV.mouseReleased==="function"){cV.mouseReleased()}});var am=function(d7){var d8=0;if(d7.wheelDelta){d8=d7.wheelDelta/120;if(B.opera){d8=-d8}}else{if(d7.detail){d8=-d7.detail/3}}cV.mouseScroll=d8;if(d8&&typeof cV.mouseScrolled==="function"){cV.mouseScrolled()}};bM(d,"DOMMouseScroll",am);bM(d,"mousewheel",am);if(typeof ac==="string"){ac=d.getElementById(ac)}if(!ac.getAttribute("tabindex")){ac.setAttribute("tabindex",0)}function dA(d8){var d7=d8.which||d8.keyCode;switch(d7){case 13:return 10;case 91:case 93:case 224:return 157;case 57392:return 17;case 46:return 127;case 45:return 155}return d7}function cA(d8){var d9=d8.which||d8.keyCode;var d7=d8.shiftKey||d8.ctrlKey||d8.altKey||d8.metaKey;switch(d9){case 13:d9=d7?13:10;break;case 8:d9=d7?127:8;break}return new bN(d9)}function cQ(d7){if(typeof d7.preventDefault==="function"){d7.preventDefault()}else{if(typeof d7.stopPropagation==="function"){d7.stopPropagation()}}return false}function dC(){var d7;for(d7 in af){if(af.hasOwnProperty(d7)){cV.__keyPressed=true;return}}cV.__keyPressed=false}function cw(){cV.__keyPressed=false;af=[];dE=null}function bn(d7,d8){af[d7]=d8;dE=null;cV.key=d8;cV.keyCode=d7;cV.keyPressed();cV.keyCode=0;cV.keyTyped();dC()}function cy(d8){var d7=dA(d8);if(d7===127){bn(d7,new bN(127));return}if(dT.indexOf(d7)<0){dE=d7;return}var d9=new bN(65535);cV.key=d9;cV.keyCode=d7;af[d7]=d9;cV.keyPressed();dE=null;dC();return cQ(d8)}function ds(d8){if(dE===null){return}var d7=dE,d9=cA(d8);bn(d7,d9);return cQ(d8)}function co(d8){var d7=dA(d8),d9=af[d7];if(d9===r){return}cV.key=d9;cV.keyCode=d7;cV.keyReleased();delete af[d7];dC()}if(!cU){if(a6 instanceof D.Sketch){cP=a6}else{if(typeof a6==="function"){cP=new D.Sketch(a6)}else{if(!a6){cP=new D.Sketch(function(){})}else{cP=D.compile(a6)}}}cV.externals.sketch=cP;cK();ac.onfocus=function(){cV.focused=true};ac.onblur=function(){cV.focused=false;if(!cP.options.globalKeyEvents){cw()}};if(cP.options.pauseOnBlur){bM(B,"focus",function(){if(aB){cV.loop()}});bM(B,"blur",function(){if(aB&&aw){cV.noLoop();aB=true}cw()})}var aS=cP.options.globalKeyEvents?B:ac;bM(aS,"keydown",cy);bM(aS,"keypress",ds);bM(aS,"keyup",co);for(var c3 in D.lib){if(D.lib.hasOwnProperty(c3)){if(D.lib[c3].hasOwnProperty("attach")){D.lib[c3].attach(cV)}else{if(D.lib[c3] instanceof Function){D.lib[c3].call(this)}}}}var dy=100;var b5=function(ea){if(!(cP.imageCache.pending||F.preloading.pending(dy))){if(B.opera){var d9,d8,d7=cP.imageCache.operaCache;for(d9 in d7){if(d7.hasOwnProperty(d9)){d8=d7[d9];if(d8!==null){d.body.removeChild(d8)}delete d7[d9]}}}cP.attach(ea,g);cP.onLoad(ea);if(ea.setup){ea.setup();ea.resetMatrix();cP.onSetup()}R();if(ea.draw){if(!aB){ea.redraw()}else{ea.loop()}}}else{B.setTimeout(function(){b5(ea)},dy)}};a(this);b5(cV)}else{cP=new D.Sketch;cK();cV.size=function(d7,d9,d8){if(d8&&d8===2){cK("3D")}else{cK("2D")}cV.size(d7,d9,d8)}}};D.debug=q;D.prototype=g;function s(){var P=["abs","acos","alpha","ambient","ambientLight","append","applyMatrix","arc","arrayCopy","asin","atan","atan2","background","beginCamera","beginDraw","beginShape","bezier","bezierDetail","bezierPoint","bezierTangent","bezierVertex","binary","blend","blendColor","blit_resize","blue","box","breakShape","brightness","camera","ceil","Character","color","colorMode","concat","constrain","copy","cos","createFont","createGraphics","createImage","cursor","curve","curveDetail","curvePoint","curveTangent","curveTightness","curveVertex","day","degrees","directionalLight","disableContextMenu","dist","draw","ellipse","ellipseMode","emissive","enableContextMenu","endCamera","endDraw","endShape","exit","exp","expand","externals","fill","filter","floor","focused","frameCount","frameRate","frustum","get","glyphLook","glyphTable","green","height","hex","hint","hour","hue","image","imageMode","intersect","join","key","keyCode","keyPressed","keyReleased","keyTyped","lerp","lerpColor","lightFalloff","lights","lightSpecular","line","link","loadBytes","loadFont","loadGlyphs","loadImage","loadPixels","loadShape","loadStrings","log","loop","mag","map","match","matchAll","max","millis","min","minute","mix","modelX","modelY","modelZ","modes","month","mouseButton","mouseClicked","mouseDragged","mouseMoved","mouseOut","mouseOver","mousePressed","mouseReleased","mouseScroll","mouseScrolled","mouseX","mouseY","name","nf","nfc","nfp","nfs","noCursor","noFill","noise","noiseDetail","noiseSeed","noLights","noLoop","norm","normal","noSmooth","noStroke","noTint","ortho","param","parseBoolean","parseByte","parseChar","parseFloat","parseInt","peg","perspective","PImage","pixels","PMatrix2D","PMatrix3D","PMatrixStack","pmouseX","pmouseY","point","pointLight","popMatrix","popStyle","pow","print","printCamera","println","printMatrix","printProjection","PShape","PShapeSVG","pushMatrix","pushStyle","quad","radians","random","Random","randomSeed","rect","rectMode","red","redraw","requestImage","resetMatrix","reverse","rotate","rotateX","rotateY","rotateZ","round","saturation","save","saveFrame","saveStrings","scale","screenX","screenY","screenZ","second","set","setup","shape","shapeMode","shared","shininess","shorten","sin","size","smooth","sort","specular","sphere","sphereDetail","splice","split","splitTokens","spotLight","sq","sqrt","status","str","stroke","strokeCap","strokeJoin","strokeWeight","subset","tan","text","textAlign","textAscent","textDescent","textFont","textLeading","textMode","textSize","texture","textureMode","textWidth","tint","toImageData","touchCancel","touchEnd","touchMove","touchStart","translate","triangle","trim","unbinary","unhex","updatePixels","use3DContext","vertex","width","XMLElement","year","__contains","__equals","__equalsIgnoreCase","__frameRate","__hashCode","__int_cast","__instanceof","__keyPressed","__mousePressed","__printStackTrace","__replace","__replaceAll","__replaceFirst","__toCharArray","__split","__codePointAt","__startsWith","__endsWith"];var N={};var O,M;for(O=0,M=P.length;O<M;++O){N[P[O]]=null}for(var Q in D.lib){if(D.lib.hasOwnProperty(Q)){if(D.lib[Q].exports){var L=D.lib[Q].exports;for(O=0,M=L.length;O<M;++O){N[L[O]]=null}}}}return N}function c(ap){var aV=s();function aC(bo){var br=[];var bt=bo.split(/([\{\[\(\)\]\}])/);var bw=bt[0];var bu=[];for(var bq=1;bq<bt.length;bq+=2){var bv=bt[bq];if(bv==="["||bv==="{"||bv==="("){bu.push(bw);bw=bv}else{if(bv==="]"||bv==="}"||bv===")"){var bp=bv==="}"?"A":bv===")"?"B":"C";var bs=br.length;br.push(bw+bv);bw=bu.pop()+'"'+bp+(bs+1)+'"'}}bw+=bt[bq+1]}br.unshift(bw);return br}function ah(bp,bo){return bp.replace(/'(\d+)'/g,function(br,bq){var bs=bo[bq];if(bs.charAt(0)==="/"){return bs}return/^'((?:[^'\\\n])|(?:\\.[0-9A-Fa-f]*))'$/.test(bs)?"(new $p.Character("+bs+"))":bs})}function aN(br){var bq=/^\s*/.exec(br),bo;if(bq[0].length===br.length){bo={left:bq[0],middle:"",right:""}}else{var bp=/\s*$/.exec(br);bo={left:bq[0],middle:br.substring(bq[0].length,bp.index),right:bp[0]}}bo.untrim=function(bs){return this.left+bs+this.right};return bo}function a4(bo){return bo.replace(/^\s+/,"").replace(/\s+$/,"")}function at(bq,br){for(var bp=0,bo=br.length;bp<bo;++bp){bq[br[bp]]=null}return bq}function a8(bp){for(var bo in bp){if(bp.hasOwnProperty(bo)){return false}}return true}function aO(bo){return bo.substring(2,bo.length-1)}var be=ap.replace(/\r\n?|\n\r/g,"\n");var L=[];var a1=be.replace(/("(?:[^"\\\n]|\\.)*")|('(?:[^'\\\n]|\\.)*')|(([\[\(=|&!\^:?]\s*)(\/(?![*\/])(?:[^\/\\\n]|\\.)*\/[gim]*)\b)|(\/\/[^\n]*\n)|(\/\*(?:(?!\*\/)(?:.|\n))*\*\/)/g,function(bw,bp,bt,bu,br,bv,bo,bq){var bs;if(bp||bt){bs=L.length;L.push(bw);return"'"+bs+"'"}if(bu){bs=L.length;L.push(bv);return br+"'"+bs+"'"}return bq!==""?" ":"\n"});var X;var ay=a1;var Y=function(bp,bq,bo,br){if(!!bq||!!br){return bp}X=true;return""};do{X=false;ay=ay.replace(/([<]?)<\s*((?:\?|[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*)(?:\s+(?:extends|super)\s+[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*)?(?:\s*,\s*(?:\?|[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*)(?:\s+(?:extends|super)\s+[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*)?)*)\s*>([=]?)/g,Y)}while(X);var bi=aC(ay);var aj;var aH={},a7,ax=0;function ba(bp,bo){var bq=bi.length;bi.push(bp);return'"'+bo+bq+'"'}function a5(){return"class"+ ++ax}function bj(bp,bq,bo){bp.classId=bq;bp.scopeId=bo;aH[bq]=bp}var T,Q,an,aT,bg,aX;var M=/\b((?:(?:public|private|final|protected|static|abstract)\s+)*)(class|interface)\s+([A-Za-z_$][\w$]*\b)(\s+extends\s+[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*(?:\s*,\s*[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*\b)*)?(\s+implements\s+[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*(?:\s*,\s*[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*\b)*)?\s*("A\d+")/g;var a9=/\b((?:(?:public|private|final|protected|static|abstract|synchronized)\s+)*)((?!(?:else|new|return|throw|function|public|private|protected)\b)[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*(?:\s*"C\d+")*)\s*([A-Za-z_$][\w$]*\b)\s*("B\d+")(\s*throws\s+[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*(?:\s*,\s*[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*)*)?\s*("A\d+"|;)/g;var aK=/^((?:(?:public|private|final|protected|static)\s+)*)((?!(?:else|new|return|throw)\b)[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*(?:\s*"C\d+")*)\s*([A-Za-z_$][\w$]*\b)\s*(?:"C\d+"\s*)*([=,]|$)/;var bk=/\b((?:(?:public|private|final|protected|static|abstract)\s+)*)((?!(?:new|return|throw)\b)[A-Za-z_$][\w$]*\b)\s*("B\d+")(\s*throws\s+[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*(?:\s*,\s*[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*)*)?\s*("A\d+")/g;var U=/^((?:(?:public|private|final|protected|static)\s+)*)((?!(?:new|return|throw)\b)[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*(?:\s*"C\d+")*)\s*/;var ar=/\bfunction(?:\s+([A-Za-z_$][\w$]*))?\s*("B\d+")\s*("A\d+")/g;function ac(bp){var bo=bp;bo=bo.replace(M,function(bq){return ba(bq,"E")});bo=bo.replace(a9,function(bq){return ba(bq,"D")});bo=bo.replace(ar,function(bq){return ba(bq,"H")});return bo}function bb(bq,bp){var bo=bq.replace(bk,function(bv,bs,bt,bw,bu,br){if(bt!==bp){return bv}return ba(bv,"G")});return bo}function aF(bo){this.name=bo}aF.prototype.toString=function(){return this.name};function am(bo){this.params=bo}am.prototype.getNames=function(){var bq=[];for(var bp=0,bo=this.params.length;bp<bo;++bp){bq.push(this.params[bp].name)}return bq};am.prototype.toString=function(){if(this.params.length===0){return"()"}var bo="(";for(var bq=0,bp=this.params.length;bq<bp;++bq){bo+=this.params[bq]+", "}return bo.substring(0,bo.length-2)+")"};function aB(bt){var br=a4(bt.substring(1,bt.length-1));var bo=[];if(br!==""){var bp=br.split(",");for(var bq=0;bq<bp.length;++bq){var bs=/\b([A-Za-z_$][\w$]*\b)(\s*"[ABC][\d]*")*\s*$/.exec(bp[bq]);bo.push(new aF(bs[1]))}}return new am(bo)}function ao(bs){var br=bs;br=br.replace(/\bnew\s+([A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*)(?:\s*"C\d+")+\s*("A\d+")/g,function(bu,bt,bv){return bv});br=br.replace(/\bnew\s+([A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*)(?:\s*"B\d+")\s*("A\d+")/g,function(bu,bt,bv){return ba(bu,"F")});br=br.replace(ar,function(bt){return ba(bt,"H")});br=br.replace(/\bnew\s+([A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*)\s*("C\d+"(?:\s*"C\d+")*)/g,function(by,bx,bv){var bu=bv.replace(/"C(\d+)"/g,function(bA,bz){return bi[bz]}).replace(/\[\s*\]/g,"[null]").replace(/\s*\]\s*\[\s*/g,", ");var bw="{"+bu.substring(1,bu.length-1)+"}";var bt="('"+bx+"', "+ba(bw,"A")+")";return"$p.createJavaArray"+ba(bt,"B")});br=br.replace(/(\.\s*length)\s*"B\d+"/g,"$1");br=br.replace(/#([0-9A-Fa-f]{6})\b/g,function(bt,bu){return"0xFF"+bu});br=br.replace(/"B(\d+)"(\s*(?:[\w$']|"B))/g,function(bw,bu,bv){var bx=bi[bu];if(!/^\(\s*[A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*\s*(?:"C\d+"\s*)*\)$/.test(bx)){return bw}if(/^\(\s*int\s*\)$/.test(bx)){return"(int)"+bv}var bt=bx.split(/"C(\d+)"/g);if(bt.length>1){if(!/^\[\s*\]$/.test(bi[bt[1]])){return bw}}return""+bv});br=br.replace(/\(int\)([^,\]\)\}\?\:\*\+\-\/\^\|\%\&\~<\>\=]+)/g,function(bu,bt){var bv=aN(bt);return bv.untrim("__int_cast("+bv.middle+")")});br=br.replace(/\bsuper(\s*"B\d+")/g,"$$superCstr$1").replace(/\bsuper(\s*\.)/g,"$$super$1");br=br.replace(/\b0+((\d*)(?:\.[\d*])?(?:[eE][\-\+]?\d+)?[fF]?)\b/,function(bv,bu,bt){if(bu===bt){return bv}return bt===""?"0"+bu:bu});br=br.replace(/\b(\.?\d+\.?)[fF]\b/g,"$1");br=br.replace(/([^\s])%([^=\s])/g,"$1 % $2");br=br.replace(/\b(frameRate|keyPressed|mousePressed)\b(?!\s*"B)/g,"__$1");br=br.replace(/\b(boolean|byte|char|float|int)\s*"B/g,function(bu,bt){return"parse"+bt.substring(0,1).toUpperCase()+bt.substring(1)+'"B'});br=br.replace(/\bpixels\b\s*(("C(\d+)")|\.length)?(\s*=(?!=)([^,\]\)\}]+))?/g,function(bu,by,bt,bx,bw,bz){if(bt){var bv=bi[bx];if(bw){return"pixels.setPixel"+ba("("+bv.substring(1,bv.length-1)+","+bz+")","B")}return"pixels.getPixel"+ba("("+bv.substring(1,bv.length-1)+")","B")}if(by){return"pixels.getLength"+ba("()","B")}if(bw){return"pixels.set"+ba("("+bz+")","B")}return"pixels.toArray"+ba("()","B")});var bq;function bp(bu,bt,by,bw){var bv=bi[bw];bq=true;var bx=aN(bv.substring(1,bv.length-1));return"__"+by+(bx.middle===""?ba("("+bt.replace(/\.\s*$/,"")+")","B"):ba("("+bt.replace(/\.\s*$/,"")+","+bx.middle+")","B"))}do{bq=false;br=br.replace(/((?:'\d+'|\b[A-Za-z_$][\w$]*\s*(?:"[BC]\d+")*)\s*\.\s*(?:[A-Za-z_$][\w$]*\s*(?:"[BC]\d+"\s*)*\.\s*)*)(replace|replaceAll|replaceFirst|contains|equals|equalsIgnoreCase|hashCode|toCharArray|printStackTrace|split|startsWith|endsWith|codePointAt)\s*"B(\d+)"/g,bp)}while(bq);function bo(bv,bt,bu){bq=true;return"__instanceof"+ba("("+bt+", "+bu+")","B")}do{bq=false;br=br.replace(/((?:'\d+'|\b[A-Za-z_$][\w$]*\s*(?:"[BC]\d+")*)\s*(?:\.\s*[A-Za-z_$][\w$]*\s*(?:"[BC]\d+"\s*)*)*)instanceof\s+([A-Za-z_$][\w$]*\s*(?:\.\s*[A-Za-z_$][\w$]*)*)/g,bo)}while(bq);br=br.replace(/\bthis(\s*"B\d+")/g,"$$constr$1");return br}function aA(bp,bo){this.baseInterfaceName=bp;this.body=bo;bo.owner=this}aA.prototype.toString=function(){return"new ("+this.body+")"};function ag(bq){var bp=(new RegExp(/\bnew\s*([A-Za-z_$][\w$]*\s*(?:\.\s*[A-Za-z_$][\w$]*)*)\s*"B\d+"\s*"A(\d+)"/)).exec(bq);var bt=a7,bs=a5();a7=bs;var bo=bp[1]+"$"+bs;var br=new aA(bo,T(bi[bp[2]],bo,"","implements "+bp[1]));bj(br,bs,bt);a7=bt;return br}function ad(bp,bq,bo){this.name=bp;this.params=bq;this.body=bo}ad.prototype.toString=function(){var bp=aj;var bq=at({"this":null},this.params.getNames());aj=function(br){return bq.hasOwnProperty(br.name)?br.name:bp(br)};var bo="function";if(this.name){bo+=" "+this.name}bo+=this.params+" "+this.body;aj=bp;return bo};function aI(bp){var bo=(new RegExp(/\b([A-Za-z_$][\w$]*)\s*"B(\d+)"\s*"A(\d+)"/)).exec(bp);return new ad(bo[1]!=="function"?bo[1]:null,aB(bi[bo[2]]),an(bi[bo[3]]))}function ab(bo){this.members=bo}ab.prototype.toString=function(){var bq=aj;aj=function(bs){return bs.name==="this"?"this":bq(bs)};var bo="";for(var br=0,bp=this.members.length;br<bp;++br){if(this.members[br].label){bo+=this.members[br].label+": "}bo+=this.members[br].value.toString()+", "}aj=bq;return bo.substring(0,bo.length-2)};function aD(br){var bo=br.split(",");for(var bq=0;bq<bo.length;++bq){var bp=bo[bq].indexOf(":");if(bp<0){bo[bq]={value:aX(bo[bq])}}else{bo[bq]={label:a4(bo[bq].substring(0,bp)),value:aX(a4(bo[bq].substring(bp+1)))}}}return new ab(bo)}function aw(bq){if(bq.charAt(0)==="("||bq.charAt(0)==="["){return bq.charAt(0)+aw(bq.substring(1,bq.length-1))+bq.charAt(bq.length-1)}if(bq.charAt(0)==="{"){if(/^\{\s*(?:[A-Za-z_$][\w$]*|'\d+')\s*:/.test(bq)){return"{"+ba(bq.substring(1,bq.length-1),"I")+"}"}return"["+aw(bq.substring(1,bq.length-1))+"]"}var bp=aN(bq);var bo=ao(bp.middle);bo=bo.replace(/"[ABC](\d+)"/g,function(bs,br){return aw(bi[br])});return bp.untrim(bo)}function P(bo){return bo.replace(/(\.\s*)?((?:\b[A-Za-z_]|\$)[\w$]*)(\s*\.\s*([A-Za-z_$][\w$]*)(\s*\()?)?/g,function(br,bt,bp,bv,bu,bs){if(bt){return br}var bq={name:bp,member:bu,callSign:!!bs};return aj(bq)+(bv===r?"":bv)})}function bn(bp,bo){this.expr=bp;this.transforms=bo}bn.prototype.toString=function(){var bo=this.transforms;var bp=P(this.expr);return bp.replace(/"!(\d+)"/g,function(br,bq){return bo[bq].toString()})};aX=function(bq){var bp=[];var bo=aw(bq);bo=bo.replace(/"H(\d+)"/g,function(bs,br){bp.push(aI(bi[br]));return'"!'+(bp.length-1)+'"'});bo=bo.replace(/"F(\d+)"/g,function(bs,br){bp.push(ag(bi[br]));return'"!'+(bp.length-1)+'"'});bo=bo.replace(/"I(\d+)"/g,function(bs,br){bp.push(aD(bi[br]));return'"!'+(bp.length-1)+'"'});return new bn(bo,bp)};function a2(bo,bq,bp){this.name=bo;this.value=bq;this.isDefault=bp}a2.prototype.toString=function(){return this.name+" = "+this.value};function ai(bs,bp){var bt=bs.indexOf("=");var bo,br,bq;if(bt<0){bo=bs;br=bp;bq=true}else{bo=bs.substring(0,bt);br=aX(bs.substring(bt+1));bq=false}return new a2(a4(bo.replace(/(\s*"C\d+")+/g,"")),br,bq)}function aR(bo){if(bo==="int"||bo==="float"){return"0"}if(bo==="boolean"){return"false"}if(bo==="color"){return"0x00000000"}return"null"}function aG(bp,bo){this.definitions=bp;this.varType=bo}aG.prototype.getNames=function(){var bq=[];for(var bp=0,bo=this.definitions.length;bp<bo;++bp){bq.push(this.definitions[bp].name)}return bq};aG.prototype.toString=function(){return"var "+this.definitions.join(",")};function af(bo){this.expression=bo}af.prototype.toString=function(){return this.expression.toString()};function bl(bs){if(aK.test(bs)){var br=U.exec(bs);var bq=bs.substring(br[0].length).split(",");var bo=aR(br[2]);for(var bp=0;bp<bq.length;++bp){bq[bp]=ai(bq[bp],bo)}return new aG(bq,br[2])}return new af(aX(bs))}function aZ(bo,bq,bp){this.initStatement=bo;this.condition=bq;this.step=bp}aZ.prototype.toString=function(){return"("+this.initStatement+"; "+this.condition+"; "+this.step+")"};function aQ(bp,bo){this.initStatement=bp;this.container=bo}aQ.prototype.toString=function(){var bo=this.initStatement.toString();if(bo.indexOf("=")>=0){bo=bo.substring(0,bo.indexOf("="))}return"("+bo+" in "+this.container+")"};function aW(bp,bo){this.initStatement=bp;this.container=bo}aW.iteratorId=0;aW.prototype.toString=function(){var bs=this.initStatement.toString();var bp="$it"+aW.iteratorId++;var br=bs.replace(/^\s*var\s*/,"").split("=")[0];var bq="var "+bp+" = new $p.ObjectIterator("+this.container+"), "+br+" = void(0)";var bo=bp+".hasNext() && (("+br+" = "+bp+".next()) || true)";return"("+bq+"; "+bo+";)"};function W(bp){var bo;if(/\bin\b/.test(bp)){bo=bp.substring(1,bp.length-1).split(/\bin\b/g);return new aQ(bl(a4(bo[0])),aX(bo[1]))}if(bp.indexOf(":")>=0&&bp.indexOf(";")<0){bo=bp.substring(1,bp.length-1).split(":");return new aW(bl(a4(bo[0])),aX(bo[1]))}bo=bp.substring(1,bp.length-1).split(";");return new aZ(bl(a4(bo[0])),aX(bo[1]),aX(bo[2]))}function a0(bo){bo.sort(function(bq,bp){return bp.weight-bq.weight})}function Z(bq,bo,bp){this.name=bq;this.body=bo;this.isStatic=bp;bo.owner=this}Z.prototype.toString=function(){return""+this.body};function al(bq,bo,bp){this.name=bq;this.body=bo;this.isStatic=bp;bo.owner=this}al.prototype.toString=function(){return""+this.body};function R(bq){var bp=M.exec(bq);M.lastIndex=0;var br=bp[1].indexOf("static")>=0;var bo=bi[aO(bp[6])],bt;var bu=a7,bs=a5();a7=bs;if(bp[2]==="interface"){bt=new Z(bp[3],Q(bo,bp[3],bp[4]),br)}else{bt=new al(bp[3],T(bo,bp[3],bp[4],bp[5]),br)}bj(bt,bs,bu);a7=bu;return bt}function aa(bq,br,bo,bp){this.name=bq;this.params=br;this.body=bo;this.isStatic=bp}aa.prototype.toString=function(){var bq=at({},this.params.getNames());var bp=aj;aj=function(br){return bq.hasOwnProperty(br.name)?br.name:bp(br)};var bo="function "+this.methodId+this.params+" "+this.body+"\n";aj=bp;return bo};function N(br){var bp=a9.exec(br);a9.lastIndex=0;var bq=bp[1].indexOf("static")>=0;var bo=bp[6]!==";"?bi[aO(bp[6])]:"{}";return new aa(bp[3],aB(bi[aO(bp[4])]),an(bo),bq)}function ak(bq,bp,bo){this.definitions=bq;this.fieldType=bp;this.isStatic=bo}ak.prototype.getNames=function(){var bq=[];for(var bp=0,bo=this.definitions.length;bp<bo;++bp){bq.push(this.definitions[bp].name)}return bq};ak.prototype.toString=function(){var bv=aj({name:"[this]"});if(this.isStatic){var bu=this.owner.name;var bs=[];for(var bt=0,br=this.definitions.length;bt<br;++bt){var bq=this.definitions[bt];var bo=bq.name,bw=bu+"."+bo;var bp="if("+bw+" === void(0)) {\n "+bw+" = "+bq.value+"; }\n$p.defineProperty("+bv+", '"+bo+"', { get: function(){return "+bw+";}, set: function(val){"+bw+" = val;} });\n";bs.push(bp)}return bs.join("")}return bv+"."+this.definitions.join("; "+bv+".")};function bd(bt){var bs=U.exec(bt);var bo=bs[1].indexOf("static")>=0;var br=bt.substring(bs[0].length).split(/,\s*/g);var bp=aR(bs[2]);for(var bq=0;bq<br.length;++bq){br[bq]=ai(br[bq],bp)}return new ak(br,bs[2],bo)}function aL(bp,bo){this.params=bp;this.body=bo}aL.prototype.toString=function(){var br=at({},this.params.getNames());var bp=aj;aj=function(bs){return br.hasOwnProperty(bs.name)?bs.name:bp(bs)};var bq="function $constr_"+this.params.params.length+this.params.toString();var bo=this.body.toString();if(!/\$(superCstr|constr)\b/.test(bo)){bo="{\n$superCstr();\n"+bo.substring(1)}aj=bp;return bq+bo+"\n"};function aq(bq){var bo=(new RegExp(/"B(\d+)"\s*"A(\d+)"/)).exec(bq);var bp=aB(bi[bo[1]]);return new aL(bp,an(bi[bo[2]]))}function aM(bq,bt,bs,bo,bu,bv){var br,bp;this.name=bq;this.interfacesNames=bt;this.methodsNames=bs;this.fields=bo;this.innerClasses=bu;this.misc=bv;for(br=0,bp=bo.length;br<bp;++br){bo[br].owner=this}}aM.prototype.getMembers=function(bv,bo,bt){if(this.owner.base){this.owner.base.body.getMembers(bv,bo,bt)}var bs,br,bq,bp;for(bs=0,bq=this.fields.length;bs<bq;++bs){var bx=this.fields[bs].getNames();for(br=0,bp=bx.length;br<bp;++br){bv[bx[br]]=this.fields[bs]}}for(bs=0,bq=this.methodsNames.length;bs<bq;++bs){var bu=this.methodsNames[bs];bo[bu]=true}for(bs=0,bq=this.innerClasses.length;bs<bq;++bs){var bw=this.innerClasses[bs];bt[bw.name]=bw}};aM.prototype.toString=function(){function bp(bF){var bE=0;while(bF){++bE;bF=bF.scope}return bE}var by=bp(this.owner);var bz=this.name;var bv="";var bA="";var bC={},bx={},bw={};this.getMembers(bC,bx,bw);var bu,bs,bt,br;if(this.owner.interfaces){var bo=[],bq;for(bu=0,bs=this.interfacesNames.length;bu<bs;++bu){if(!this.owner.interfaces[bu]){continue}bq=aj({name:this.interfacesNames[bu]});bo.push(bq);bv+="$p.extendInterfaceMembers("+bz+", "+bq+");\n"}bA+=bz+".$interfaces = ["+bo.join(", ")+"];\n"}bA+=bz+".$isInterface = true;\n";bA+=bz+".$methods = ['"+this.methodsNames.join("', '")+"'];\n";a0(this.innerClasses);for(bu=0,bs=this.innerClasses.length;bu<bs;++bu){var bD=this.innerClasses[bu];if(bD.isStatic){bv+=bz+"."+bD.name+" = "+bD+";\n"}}for(bu=0,bs=this.fields.length;bu<bs;++bu){var bB=this.fields[bu];if(bB.isStatic){bv+=bz+"."+bB.definitions.join(";\n"+bz+".")+";\n"}}return"(function() {\nfunction "+bz+"() { throw 'Unable to create the interface'; }\n"+bv+bA+"return "+bz+";\n})()"};Q=function(bu,bp,bz){var bA=bu.substring(1,bu.length-1);bA=ac(bA);bA=bb(bA,bp);var bx=[],br=[];bA=bA.replace(/"([DE])(\d+)"/g,function(bD,bC,bB){if(bC==="D"){bx.push(bB)}else{if(bC==="E"){br.push(bB)}}return""});var bv=bA.split(/;(?:\s*;)*/g);var bs;var bt,bq;if(bz!==r){bs=bz.replace(/^\s*extends\s+(.+?)\s*$/g,"$1").split(/\s*,\s*/g)}for(bt=0,bq=bx.length;bt<bq;++bt){var bo=N(bi[bx[bt]]);bx[bt]=bo.name}for(bt=0,bq=bv.length-1;bt<bq;++bt){var by=aN(bv[bt]);bv[bt]=bd(by.middle)}var bw=bv.pop();for(bt=0,bq=br.length;bt<bq;++bt){br[bt]=R(bi[br[bt]])}return new aM(bp,bs,bx,bv,br,{tail:bw})};function az(bp,bw,bv,bu,bq,bx,by,bs,bo){var bt,br;this.name=bp;this.baseClassName=bw;this.interfacesNames=bv;this.functions=bu;this.methods=bq;this.fields=bx;this.cstrs=by;this.innerClasses=bs;this.misc=bo;for(bt=0,br=bx.length;bt<br;++bt){bx[bt].owner=this}}az.prototype.getMembers=function(bv,bp,bu){if(this.owner.base){this.owner.base.body.getMembers(bv,bp,bu)}var bt,bs,br,bq;for(bt=0,br=this.fields.length;bt<br;++bt){var bx=this.fields[bt].getNames();for(bs=0,bq=bx.length;bs<bq;++bs){bv[bx[bs]]=this.fields[bt]}}for(bt=0,br=this.methods.length;bt<br;++bt){var bo=this.methods[bt];bp[bo.name]=bo}for(bt=0,br=this.innerClasses.length;bt<br;++bt){var bw=this.innerClasses[bt];bu[bw.name]=bw}};az.prototype.toString=function(){function bJ(bR){var bQ=0;while(bR){++bQ;bR=bR.scope}return bQ}var bz=bJ(this.owner);var bC="$this_"+bz;var bq=this.name;var bv="var "+bC+" = this;\n";var bD="";var bx="";var bO={},bP={},bF={};this.getMembers(bO,bP,bF);var bN=aj;aj=function(bR){var bQ=bR.name;if(bQ==="this"){return bR.callSign||!bR.member?bC+".$self":bC}if(bO.hasOwnProperty(bQ)){return bO[bQ].isStatic?bq+"."+bQ:bC+"."+bQ}if(bF.hasOwnProperty(bQ)){return bC+"."+bQ}if(bP.hasOwnProperty(bQ)){return bP[bQ].isStatic?bq+"."+bQ:bC+".$self."+bQ}return bN(bR)};var by;if(this.baseClassName){by=bN({name:this.baseClassName});bv+="var $super = { $upcast: "+bC+" };\n";bv+="function $superCstr(){"+by+".apply($super,arguments);if(!('$self' in $super)) $p.extendClassChain($super)}\n";bx+=bq+".$base = "+by+";\n"}else{bv+="function $superCstr(){$p.extendClassChain("+bC+")}\n"}if(this.owner.base){bD+="$p.extendStaticMembers("+bq+", "+by+");\n"}var bI,bG,bH,bE;if(this.owner.interfaces){var bu=[],bo;for(bI=0,bG=this.interfacesNames.length;bI<bG;++bI){if(!this.owner.interfaces[bI]){continue}bo=bN({name:this.interfacesNames[bI]});bu.push(bo);bD+="$p.extendInterfaceMembers("+bq+", "+bo+");\n"}bx+=bq+".$interfaces = ["+bu.join(", ")+"];\n"}if(this.functions.length>0){bv+=this.functions.join("\n")+"\n"}a0(this.innerClasses);for(bI=0,bG=this.innerClasses.length;bI<bG;++bI){var bB=this.innerClasses[bI];if(bB.isStatic){bD+=bq+"."+bB.name+" = "+bB+";\n";bv+=bC+"."+bB.name+" = "+bq+"."+bB.name+";\n"}else{bv+=bC+"."+bB.name+" = "+bB+";\n"}}for(bI=0,bG=this.fields.length;bI<bG;++bI){var bp=this.fields[bI];if(bp.isStatic){bD+=bq+"."+bp.definitions.join(";\n"+bq+".")+";\n";for(bH=0,bE=bp.definitions.length;bH<bE;++bH){var bs=bp.definitions[bH].name,bw=bq+"."+bs;bv+="$p.defineProperty("+bC+", '"+bs+"', {get: function(){return "+bw+"}, set: function(val){"+bw+" = val}});\n"}}else{bv+=bC+"."+bp.definitions.join(";\n"+bC+".")+";\n"}}var bA={};for(bI=0,bG=this.methods.length;bI<bG;++bI){var br=this.methods[bI];var bL=bA[br.name];var bt=br.name+"$"+br.params.params.length;if(bL){++bL;bt+="_"+bL}else{bL=1}br.methodId=bt;bA[br.name]=bL;if(br.isStatic){bD+=br;bD+="$p.addMethod("+bq+", '"+br.name+"', "+bt+");\n";bv+="$p.addMethod("+bC+", '"+br.name+"', "+bt+");\n"}else{bv+=br;bv+="$p.addMethod("+bC+", '"+br.name+"', "+bt+");\n"}}bv+=a4(this.misc.tail);if(this.cstrs.length>0){bv+=this.cstrs.join("\n")+"\n"}bv+="function $constr() {\n";var bM=[];for(bI=0,bG=this.cstrs.length;bI<bG;++bI){var bK=this.cstrs[bI].params.params.length;bM.push("if(arguments.length === "+bK+") { $constr_"+bK+".apply("+bC+", arguments); }")}if(bM.length>0){bv+=bM.join(" else ")+" else "}bv+="$superCstr();\n}\n";bv+="$constr.apply(null, arguments);\n";aj=bN;return"(function() {\nfunction "+bq+"() {\n"+bv+"}\n"+bD+bx+"return "+bq+";\n})()"};T=function(bx,bp,bo,bA){var bC=bx.substring(1,bx.length-1);bC=ac(bC);bC=bb(bC,bp);var bq=[],br=[],bB=[],bu=[];bC=bC.replace(/"([DEGH])(\d+)"/g,function(bF,bE,bD){if(bE==="D"){bq.push(bD)}else{if(bE==="E"){br.push(bD)}else{if(bE==="H"){bu.push(bD)}else{bB.push(bD)}}}return""});var bw=bC.replace(/^(?:\s*;)+/,"").split(/;(?:\s*;)*/g);var bv,bt;var bs;if(bo!==r){bv=bo.replace(/^\s*extends\s+([A-Za-z_$][\w$]*\b(?:\s*\.\s*[A-Za-z_$][\w$]*\b)*)\s*$/g,"$1")}if(bA!==r){bt=bA.replace(/^\s*implements\s+(.+?)\s*$/g,"$1").split(/\s*,\s*/g)}for(bs=0;bs<bu.length;++bs){bu[bs]=aI(bi[bu[bs]])}for(bs=0;bs<bq.length;++bs){bq[bs]=N(bi[bq[bs]])}for(bs=0;bs<bw.length-1;++bs){var bz=aN(bw[bs]);bw[bs]=bd(bz.middle)}var by=bw.pop();for(bs=0;bs<bB.length;++bs){bB[bs]=aq(bi[bB[bs]])}for(bs=0;bs<br.length;++bs){br[bs]=R(bi[br[bs]])}return new az(bp,bv,bt,bu,bq,bw,bB,br,{tail:by})};function au(bp,bo){this.name=bp;this.body=bo;bo.owner=this}au.prototype.toString=function(){return"var "+this.name+" = "+this.body+";\n$p."+this.name+" = "+this.name+";\n"};function a3(bp,bo){this.name=bp;this.body=bo;bo.owner=this}a3.prototype.toString=function(){return"var "+this.name+" = "+this.body+";\n$p."+this.name+" = "+this.name+";\n"};function bm(bq){var bp=M.exec(bq);M.lastIndex=0;var bo=bi[aO(bp[6])];var bt=a7,br=a5();a7=br;var bs;if(bp[2]==="interface"){bs=new au(bp[3],Q(bo,bp[3],bp[4]))}else{bs=new a3(bp[3],T(bo,bp[3],bp[4],bp[5]))}bj(bs,br,bt);a7=bt;return bs}function aP(bp,bq,bo){this.name=bp;this.params=bq;this.body=bo}aP.prototype.toString=function(){var bq=at({},this.params.getNames());var bp=aj;aj=function(br){return bq.hasOwnProperty(br.name)?br.name:bp(br)};var bo="function "+this.name+this.params+" "+this.body+"\n$p."+this.name+" = "+this.name+";";aj=bp;return bo};function aU(bq){var bp=a9.exec(bq);var bo=a9.lastIndex=0;return new aP(bp[3],aB(bi[aO(bp[4])]),an(bi[aO(bp[6])]))}function ae(bo){var bp=bo;bp=bp.replace(/\b(catch\s*"B\d+"\s*"A\d+")(\s*catch\s*"B\d+"\s*"A\d+")+/g,"$1");return bp}function aS(bo,bp){this.argument=bo;this.misc=bp}aS.prototype.toString=function(){return this.misc.prefix+this.argument.toString()};function O(bo,bp){this.argument=bo;this.misc=bp}O.prototype.toString=function(){return this.misc.prefix+this.argument.toString()};function av(bo,bp,bq){this.name=bo;this.argument=bp;this.misc=bq}av.prototype.toString=function(){var bo=this.misc.prefix;if(this.argument!==r){bo+=this.argument.toString()}return bo};function aJ(bo){this.expr=bo}aJ.prototype.toString=function(){return"case "+this.expr+":"};function V(bo){this.label=bo}V.prototype.toString=function(){return this.label};aT=function(bw,bx,bq){var bB=new RegExp(/\b(catch|for|if|switch|while|with)\s*"B(\d+)"|\b(do|else|finally|return|throw|try|break|continue)\b|("[ADEH](\d+)")|\b(case)\s+([^:]+):|\b([A-Za-z_$][\w$]*\s*:)|(;)/g);var by=[];bw=ae(bw);var bv=0,br,bp;while((br=bB.exec(bw))!==null){if(br[1]!==r){var bu=bw.lastIndexOf('"B',bB.lastIndex);var bA=bw.substring(bv,bu);if(br[1]==="for"){by.push(new aS(W(bi[br[2]]),{prefix:bA}))}else{if(br[1]==="catch"){by.push(new O(aB(bi[br[2]]),{prefix:bA}))}else{by.push(new av(br[1],aX(bi[br[2]]),{prefix:bA}))}}}else{if(br[3]!==r){by.push(new av(br[3],r,{prefix:bw.substring(bv,bB.lastIndex)}))}else{if(br[4]!==r){bp=bw.substring(bv,bB.lastIndex-br[4].length);if(a4(bp).length!==0){continue}by.push(bp);var bs=br[4].charAt(1),bo=br[5];if(bs==="D"){by.push(bx(bi[bo]))}else{if(bs==="E"){by.push(bq(bi[bo]))}else{if(bs==="H"){by.push(aI(bi[bo]))}else{by.push(an(bi[bo]))}}}}else{if(br[6]!==r){by.push(new aJ(aX(a4(br[7]))))}else{if(br[8]!==r){bp=bw.substring(bv,bB.lastIndex-br[8].length);if(a4(bp).length!==0){continue}by.push(new V(bw.substring(bv,bB.lastIndex)))}else{var bz=aN(bw.substring(bv,bB.lastIndex-1));by.push(bz.left);by.push(bl(bz.middle));by.push(bz.right+";")}}}}}bv=bB.lastIndex}var bt=aN(bw.substring(bv));by.push(bt.left);if(bt.middle!==""){by.push(bl(bt.middle));by.push(";"+bt.right)}return by};function bc(bp){var bq=[];for(var br=0,bo=bp.length;br<bo;++br){var bs=bp[br];if(bs instanceof aG){bq=bq.concat(bs.getNames())}else{if(bs instanceof aS&&bs.argument.initStatement instanceof aG){bq=bq.concat(bs.argument.initStatement.getNames())}else{if(bs instanceof Z||bs instanceof al||bs instanceof au||bs instanceof a3||bs instanceof aP||bs instanceof ad){bq.push(bs.name)}}}}return at({},bq)}function S(bo){this.statements=bo}S.prototype.toString=function(){var bq=bc(this.statements);var bp=aj;if(!a8(bq)){aj=function(br){return bq.hasOwnProperty(br.name)?br.name:bp(br)}}var bo="{\n"+this.statements.join("")+"\n}";aj=bp;return bo};an=function(bp){var bo=aN(bp.substring(1,bp.length-1));return new S(aT(bo.middle))};function aE(bo){this.statements=bo}aE.prototype.toString=function(){var bs=[],bt=[],bu;for(var br=0,bp=this.statements.length;br<bp;++br){bu=this.statements[br];if(bu instanceof a3||bu instanceof au){bs.push(bu)}else{bt.push(bu)}}a0(bs);var bq=bc(this.statements);aj=function(bw){var bv=bw.name;if(bq.hasOwnProperty(bv)){return bv}if(aV.hasOwnProperty(bv)||z.hasOwnProperty(bv)||g.hasOwnProperty(bv)){return"$p."+bv}return bv};var bo="// this code was autogenerated from PJS\n(function($p) {\n"+bs.join("")+"\n"+bt.join("")+"\n})";aj=null;return bo};bg=function(){var bo=ac(bi[0]);bo=bo.replace(/\bimport\s+[^;]+;/g,"");return new aE(aT(bo,aU,bm))};function bh(bo){var bs={};var bq,bw;for(bq in aH){if(aH.hasOwnProperty(bq)){bw=aH[bq];var bC=bw.scopeId,bp=bw.name;if(bC){var bB=aH[bC];bw.scope=bB;if(bB.inScope===r){bB.inScope={}}bB.inScope[bp]=bw}else{bs[bp]=bw}}}function bz(bD,bG){var bJ=bG.split(".");var bF=bD.scope,bI;while(bF){if(bF.hasOwnProperty(bJ[0])){bI=bF[bJ[0]];break}bF=bF.scope}if(bI===r){bI=bs[bJ[0]]}for(var bH=1,bE=bJ.length;bH<bE&&bI;++bH){bI=bI.inScope[bJ[bH]]}return bI}for(bq in aH){if(aH.hasOwnProperty(bq)){bw=aH[bq];var bv=bw.body.baseClassName;if(bv){var by=bz(bw,bv);if(by){bw.base=by;if(!by.derived){by.derived=[]}by.derived.push(bw)}}var bu=bw.body.interfacesNames,bA=[],bt,br;if(bu&&bu.length>0){for(bt=0,br=bu.length;bt<br;++bt){var bx=bz(bw,bu[bt]);bA.push(bx);if(!bx){continue}if(!bx.derived){bx.derived=[]}bx.derived.push(bw)}if(bA.length>0){bw.interfaces=bA}}}}}function a6(bo){var bt=[],bq={};var bp,bw,bu;for(bp in aH){if(aH.hasOwnProperty(bp)){bu=aH[bp];if(!bu.inScope&&!bu.derived){bt.push(bp);bu.weight=0}else{var bv=[];if(bu.inScope){for(bw in bu.inScope){if(bu.inScope.hasOwnProperty(bw)){bv.push(bu.inScope[bw])}}}if(bu.derived){bv=bv.concat(bu.derived)}bq[bp]=bv}}}function bx(bz,bB){var by=bq[bz];if(!by){return false}var bA=by.indexOf(bB);if(bA<0){return false}by.splice(bA,1);if(by.length>0){return false}delete bq[bz];return true}while(bt.length>0){bp=bt.shift();bu=aH[bp];if(bu.scopeId&&bx(bu.scopeId,bu)){bt.push(bu.scopeId);aH[bu.scopeId].weight=bu.weight+1}if(bu.base&&bx(bu.base.classId,bu)){bt.push(bu.base.classId);bu.base.weight=bu.weight+1}if(bu.interfaces){var bs,br;for(bs=0,br=bu.interfaces.length;bs<br;++bs){if(!bu.interfaces[bs]||!bx(bu.interfaces[bs].classId,bu)){continue}bt.push(bu.interfaces[bs].classId);bu.interfaces[bs].weight=bu.weight+1}}}}var bf=bg();bh(bf);a6(bf);var aY=bf.toString();aY=aY.replace(/\s*\n(?:[\t ]*\n)+/g,"\n\n");return ah(aY,L)}function x(M,ab){var V=(new RegExp(/\/\*\s*@pjs\s+((?:[^\*]|\*+[^\*\/])*)\*\//g)).exec(M);if(V&&V.length===2){var L=[],O=V.splice(1,2)[0].replace(/\{([\s\S]*?)\}/g,function(){return function(ae,af){L.push(af);return"{"+(L.length-1)+"}"}}()).replace("\n","").replace("\r","").split(";");var U=function(ae){return ae.replace(/^\s*["']?/,"").replace(/["']?\s*$/,"")};for(var Y=0,W=O.length;Y<W;Y++){var S=O[Y].split("=");if(S&&S.length===2){var ad=U(S[0]),T=U(S[1]),ac=[];if(ad==="preload"){ac=T.split(",");for(var X=0,Z=ac.length;X<Z;X++){var aa=U(ac[X]);ab.imageCache.add(aa)}}else{if(ad==="font"){ac=T.split(",");for(var P=0,R=ac.length;P<R;P++){var Q=U(ac[P]),N=/^\{(\d*?)\}$/.exec(Q);F.preloading.add(N?JSON.parse("{"+L[N[1]]+"}"):Q)}}else{if(ad==="pauseOnBlur"){ab.options.pauseOnBlur=T==="true"}else{if(ad==="globalKeyEvents"){ab.options.globalKeyEvents=T==="true"}else{if(ad.substring(0,6)==="param-"){ab.params[ad.substring(6)]=T}else{ab.options[ad]=T}}}}}}}}return M}D.compile=function(L){var O=new D.Sketch;var M=x(L,O);var N=c(M);O.sourceCode=N;return O};var j=function(){var R={},O="undefined",P="function",L=!1,Q=!0,M=512,N="log";if(typeof tinylog!==O&&typeof tinylog[N]===P){R[N]=tinylog[N]}else{if(typeof d!==O&&!d.fake){(function(){var am=d,ak="div",aa="style",ae="title",Z={zIndex:10000,position:"fixed",bottom:"0px",width:"100%",height:"15%",fontFamily:"sans-serif",color:"#ccc",backgroundColor:"black"},ac={position:"relative",fontFamily:"monospace",overflow:"auto",height:"100%",paddingTop:"5px"},ag={height:"5px",marginTop:"-5px",cursor:"n-resize",backgroundColor:"darkgrey"},al={position:"absolute",top:"5px",right:"20px",color:"#111",MozBorderRadius:"4px",webkitBorderRadius:"4px",borderRadius:"4px",cursor:"pointer",fontWeight:"normal",textAlign:"center",padding:"3px 5px",backgroundColor:"#333",fontSize:"12px"},W={minHeight:"16px"},ad={fontSize:"12px",margin:"0 8px 0 8px",maxWidth:"100%",whiteSpace:"pre-wrap",overflow:"auto"},ab=am.defaultView,aj=am.documentElement,S=aj[aa],U=function(){var ao=arguments.length,an,aq,ap;while(ao--){aq=arguments[ao--];an=arguments[ao][aa];for(ap in aq){if(aq.hasOwnProperty(ap)){an[ap]=aq[ap]}}}},ah=function(ap,ao,an){if(ap.addEventListener){ap.addEventListener(ao,an,L)}else{if(ap.attachEvent){ap.attachEvent("on"+ao,an)}}return[ap,ao,an]},T=function(ap,ao,an){if(ap.removeEventListener){ap.removeEventListener(ao,an,L)}else{if(ap.detachEvent){ap.detachEvent("on"+ao,an)}}},Y=function(ao){var an=ao.childNodes,ap=an.length;while(ap--){ao.removeChild(an.item(0))}},ai=function(ao,an){return ao.appendChild(an)},af=function(an){return am.createElement(an)},X=function(an){return am.createTextNode(an)},V=R[N]=function(aC){var au,av=S.paddingBottom,ap=af(ak),az=ap[aa],aA=ai(ap,af(ak)),ar=ai(ap,af(ak)),aq=ai(ap,af(ak)),aB=L,at=L,ao=L,aw=0,an=function(){S.paddingBottom=ap.clientHeight+"px"},ay=function(aD){var aE=ab.innerHeight,aF=aA.clientHeight;if(aD<0){aD=0}else{if(aD+aF>aE){aD=aE-aF}}az.height=aD/aE*100+"%";an()},ax=[ah(am,"mousemove",function(aD){if(aB){ay(ab.innerHeight-aD.clientY);ar.scrollTop=ao}}),ah(am,"mouseup",function(){if(aB){aB=ao=L}}),ah(aA,"dblclick",function(aD){aD.preventDefault();if(at){ay(at);at=L}else{at=ap.clientHeight;az.height="0px"}}),ah(aA,"mousedown",function(aD){aD.preventDefault();aB=Q;ao=ar.scrollTop}),ah(aA,"contextmenu",function(){aB=L}),ah(aq,"click",function(){au()})];au=function(){var aD=ax.length;while(aD--){T.apply(R,ax[aD])}aj.removeChild(ap);S.paddingBottom=av;Y(ar);Y(ap);R[N]=V};U(ap,Z,ar,ac,aA,ag,aq,al);aq[ae]="Close Log";ai(aq,X("\u2716"));aA[ae]="Double-click to toggle log minimization";aj.insertBefore(ap,aj.firstChild);R[N]=function(aF){if(aw===M){ar.removeChild(ar.firstChild)}else{aw++}var aE=ai(ar,af(ak)),aD=ai(aE,af(ak));aE[ae]=(new Date).toLocaleTimeString();U(aE,W,aD,ad);ai(aD,X(aF));ar.scrollTop=ar.scrollHeight};R[N](aC);an()}})()}else{if(typeof print===P){R[N]=print}}}return R}();D.logger=j;D.version="1.3.6";D.lib={};D.registerLibrary=function(L,M){D.lib[L]=M;if(M.hasOwnProperty("init")){M.init(g)}};D.instances=k;D.getInstanceById=function(L){return k[H[L]]};D.Sketch=function(L){this.attachFunction=L;this.options={pauseOnBlur:false,globalKeyEvents:false};this.onLoad=E;this.onSetup=E;this.onPause=E;this.onLoop=E;this.onFrameStart=E;this.onFrameEnd=E;this.onExit=E;this.params={};this.imageCache={pending:0,images:{},operaCache:{},add:function(N,M){if(this.images[N]){return}if(!l){this.images[N]=null}if(!M){M=new Image;M.onload=function(P){return function(){P.pending--}}(this);this.pending++;M.src=N}this.images[N]=M;if(B.opera){var O=d.createElement("div");O.appendChild(M);O.style.position="absolute";O.style.opacity=0;O.style.width="1px";O.style.height="1px";if(!this.operaCache[N]){d.body.appendChild(O);this.operaCache[N]=O}}}};this.sourceCode=undefined;this.attach=function(N){if(typeof this.attachFunction==="function"){this.attachFunction(N)}else{if(this.sourceCode){var M=(new Function("return ("+this.sourceCode+");"))();M(N);this.attachFunction=M}else{throw"Unable to attach sketch to the processing instance"}}};this.toString=function(){var M;var N="((function(Sketch) {\n";N+="var sketch = new Sketch(\n"+this.sourceCode+");\n";for(M in this.options){if(this.options.hasOwnProperty(M)){var O=this.options[M];N+="sketch.options."+M+" = "+(typeof O==="string"?'"'+O+'"':""+O)+";\n"}}for(M in this.imageCache){if(this.options.hasOwnProperty(M)){N+='sketch.imageCache.add("'+M+'");\n'}}N+="return sketch;\n})(Processing.Sketch))";return N}};var t=function(O,L){var M=[],S=[],T=L.length,Q=0;function R(U,W){var V=new XMLHttpRequest;V.onreadystatechange=function(){if(V.readyState===4){var X;if(V.status!==200&&V.status!==0){X="Invalid XHR status "+V.status}else{if(V.responseText===""){if("withCredentials" in new XMLHttpRequest&&(new XMLHttpRequest).withCredentials===false&&B.location.protocol==="file:"){X="XMLHttpRequest failure, possibly due to a same-origin policy violation. You can try loading this page in another browser, or load it from http://localhost using a local webserver. See the Processing.js README for a more detailed explanation of this problem and solutions."}else{X="File is empty."}}}W(V.responseText,X)}};V.open("GET",U,true);if(V.overrideMimeType){V.overrideMimeType("application/json")}V.setRequestHeader("If-Modified-Since","Fri, 01 Jan 1960 00:00:00 GMT");V.send(null)}function N(V,U){function X(aa,Y){M[V]=aa;++Q;if(Y){S.push(U+" ==> "+Y)}if(Q===T){if(S.length===0){try{return new D(O,M.join("\n"))}catch(Z){throw"Processing.js: Unable to execute pjs sketch: "+Z}}else{throw"Processing.js: Unable to load pjs sketch files: "+S.join("\n")}}}if(U.charAt(0)==="#"){var W=d.getElementById(U.substring(1));if(W){X(W.text||W.textContent)}else{X("","Unable to load pjs sketch: element with id '"+U.substring(1)+"' was not found")}return}R(U,X)}for(var P=0;P<T;++P){N(P,L[P])}};var G=function(){d.removeEventListener("DOMContentLoaded",G,false);var M=d.getElementsByTagName("canvas"),S;for(var R=0,N=M.length;R<N;R++){var U=M[R].getAttribute("data-processing-sources");if(U===null){U=M[R].getAttribute("data-src");if(U===null){U=M[R].getAttribute("datasrc")}}if(U){S=U.split(" ");for(var Q=0;Q<S.length;){if(S[Q]){Q++}else{S.splice(Q,1)}}t(M[R],S)}}var O=d.getElementsByTagName("script");var Y,L,X;for(Y=0;Y<O.length;Y++){var W=O[Y];if(!W.getAttribute){continue}var V=W.getAttribute("type");if(V&&(V.toLowerCase()==="text/processing"||V.toLowerCase()==="application/processing")){var T=W.getAttribute("data-processing-target");M=r;if(T){M=d.getElementById(T)}else{var P=W.nextSibling;while(P&&P.nodeType!==1){P=P.nextSibling}if(P.nodeName.toLowerCase()==="canvas"){M=P}}if(M){if(W.getAttribute("src")){S=W.getAttribute("src").split(/\s+/);t(M,S);continue}L=W.textContent||W.text;X=new D(M,L)}}}};D.loadSketchFromSources=t;D.disableInit=function(){if(l){d.removeEventListener("DOMContentLoaded",G,false)}};if(l){B.Processing=D;d.addEventListener("DOMContentLoaded",G,false)}else{this.Processing=D}})(window,window.document,Math);
