class sysconfig::django_init (
    $superuser_name = hiera('sysconfig::params::superuser_name', $sysconfig::params::superuser_name ),
    $superuser_pw   = hiera('sysconfig::params::superuser_pw'  , $sysconfig::params::superuser_pw   ),
    $path_to_virtualenv = hiera('sysconfig::params::path_to_virtualenv', $sysconfig::params::path_to_virtualenv )
) inherits sysconfig::params {
    
    notify {'django_init': name => "django init \$superuser_name : ${superuser_name}, \$superuser_pw : ${superuser_pw}", withpath => true }->

    exec { 'syncdb':
        command => ". ${path_to_virtualenv}/bin/activate && ${path_to_virtualenv}/bin/python manage.py syncdb --noinput",
        cwd     => '/srv/spel/src',
        user    => 'vagrant',
        provider => 'shell'
    }

    exec { 'loaddata':
        command => ". ${path_to_virtualenv}/bin/activate && ${path_to_virtualenv}/bin/python manage.py loaddata roles_generic",
        cwd     => '/srv/spel/src',
        user    => 'vagrant',
        provider => 'shell',
        require => Exec['syncdb']
    }

    exec { 'createsuperuser':
        command => "/bin/echo \"from django.contrib.auth.models import User; User.objects.create_superuser('${superuser_name}', 'admin@example.com', '${superuser_pw}')\" | . ${path_to_virtualenv}/bin/activate && ${path_to_virtualenv}/bin/python manage.py shell",
        cwd     => '/srv/spel/src',
        user    => 'vagrant',
        provider => 'shell',
        onlyif  => "/bin/echo \"from django.contrib.auth.models import User; exit(User.objects.filter(username='${superuser_name}').count())\" | . ${path_to_virtualenv}/bin/activate && ${path_to_virtualenv}/bin/python manage.py shell",
       require => Exec['syncdb']
    }

}