from django.template import Library, TemplateSyntaxError

register = Library()

import logging
logger = logging.getLogger(__name__)

@register.filter
def get_tags(value, arg=None):
    """ Takes a segment's tag list and returns an array of values from argument. Example seg_obj|get_tags:"personnages" will return "Romeo, Juliette" """
    # Error management
    if value is None :
        return ""
    if not isinstance(value, (str,unicode)) :
        raise TemplateSyntaxError('get_tags value error : string is required')
    # If no arg, we join all values
    a = value.split(u",")
    val = []
    if arg is None :
        for t in a:
            try:
                t.index(":")
            except:
                continue
            val.append(t[t.index(":")+2:])
    elif arg=="ref_text_2":
        for t in a:
            try:
                t.index(":")
            except:
                continue
            if t[:t.index(":")]=="ref_text":
                tag_split = t.split(":")
                if len(tag_split)>2:
                    val.append( ":".join(tag_split[2:]) )
                else:
                    val.append(t[t.index(":")+2:])
    elif arg=="modscen_and_perso":
        for t in a:
            try:
                t.index(":")
            except:
                continue
            if t[:t.index(":")]=="modalites_sceniques" or t[:t.index(":")]=="personnages":
                val.append(t[t.index(":")+2:])
    elif arg in ["type_inter", "personnages", "ref_text"]:
        for t in a:
            try:
                t.index(":")
            except:
                continue
            if t[:t.index(":")]==arg:
                val.append(t[t.index(":")+2:])
    elif arg=="group":
        key_vals = {}
        for t in a:
            try:
                t.index(":")
            except:
                continue
            k = t[:t.index(":")]
            v = t[t.index(":")+2:]
            if k not in key_vals:
                key_vals[k] = []
            key_vals[k].append(v)
        output = ""
        for k,v in key_vals.items():
            if output != "":
                output += "<br/>"
            output += "<strong>" + k.capitalize() + "</strong>" + ": " + ", ".join(v)
        return output
             
    return val
get_tags.is_safe = True

