function Player(dimensions) {
	
	var events = {},
        self = this,
        loaded = false,
        tvWindow,
        destination = document.location.href.replace(/^(https?:\/\/[^\/]+).*$/,'$1'),
        timeAtLoad,
        timeDelta = 0,
        timeOut,
        playAtLoad = false,
        winDimensions = dimensions || { left: 0, top: 0, width: 640, height:360 };
    
    this.currentTime = 0;
    this.duration = 0;
    this.paused = true;
    
	function receiveMessage(evt) {
		var dataparts = evt.data.split(":");
		loaded = true;
		switch(dataparts[0]) {
			case "loadedmetadata":
				self.duration = parseFloat(dataparts[1]);
				self.setCurrentTime(self.currentTime);
				if (!self.paused) {
					self.play();
				}
			break;
			case "play":
				self.paused = false;
				self.trigger("play");
			break;
			case "pause":
				self.paused = true;
				self.trigger("pause");
			break;
			case "timeupdate":
				self.currentTime = parseFloat(dataparts[1])
				self.trigger("timeupdate", self.currentTime);
			break;
			case "unload":
				loaded = false;
				self.pause();
			break;
		}
	}
	
    function updateTime() {
    	clearTimeout(timeOut);
        if (!loaded && !self.paused) {
            self.currentTime = (new Date().valueOf() / 1000 - timeDelta);
            if (self.currentTime <= self.duration) {
                self.trigger("timeupdate", self.currentTime);
                timeOut = setTimeout(updateTime, 100);
            } else {
                self.currentTime = self.duration;
                self.pause();
            }
        }
    }
	
	function sendMessage(msg) {
		if (tvWindow) {
			tvWindow.postMessage(msg, destination);
		}
	}
	
	$(".tv").click(function() {
		tvWindow = window.open("tv.html","TV", _(winDimensions).reduce(function(mem, v, k) { return mem + k + "=" + v + "," },"") + "toolbar=0,location=0,status=0,titlebar=0");
		window.addEventListener("message",receiveMessage,false);
	});
	
	$(window).on("unload", function() {
	    if (typeof tvWindow !== "undefined" && tvWindow) {
	        tvWindow.close();
	    }
	})
	
	this.setCurrentTime = function(t) {
		if (loaded) {
			sendMessage("timeupdate:" + t);
		} else {
        	timeDelta = (new Date().valueOf() / 1000 - t);
			self.currentTime = t;
			self.trigger("timeupdate",t);
		}
	}
	this.play = function() {
		if (loaded) {
			sendMessage("play")
		} else {
	        self.paused = false;
	        timeDelta = (new Date().valueOf() / 1000 - self.currentTime)
	        self.trigger("play");
	        updateTime();
		}
	}
	this.pause = function() {
		if (loaded) {
			sendMessage("pause");
		} else {
			self.paused = true;
			self.trigger("pause");
		}
	}
	
	this.on = function(_event, _callback) {
	    if (typeof events[_event] === "undefined") {
	        events[_event] = [];
	    }
	    events[_event].push(_callback);
	}
	this.off = function(_event, _callback) {
	    if (typeof events[_event] !== "undefined") {
	        events[_event] = _(events[_event]).reject(function(_fn) {
	            return _fn === _callback;
	        });
	    }
	}
	this.trigger = function(_event, _data) {
	    var _list = this;
	    _(events[_event]).each(function(_callback) {
	        _callback.call(_list, _data);
	    });
	}
}
