window.addEventListener("DOMContentLoaded", function() {
	
	var video = document.querySelector("video"),
		destination = document.location.href.replace(/^(https?:\/\/[^\/]+).*$/,'$1');
	
	function receiveMessage(evt) {
		var dataparts = evt.data.split(":");
		switch(dataparts[0]) {
			case "play":
				video.play();
			break;
			case "pause":
				video.pause();
			break;
			case "timeupdate":
				video.currentTime = parseFloat(dataparts[1]);
			break;
		}
	}
	
	function sendMessage(msg) {
		if (window.opener) {
			window.opener.postMessage(msg, destination);
		}
	}
	
	window.addEventListener("message", receiveMessage, false);
	
	window.addEventListener("unload", function() {
		sendMessage("unload");
	}, false);
	
	video.addEventListener("loadedmetadata", function() {
		sendMessage("loadedmetadata:"+video.duration);
	}, false);
	video.addEventListener("timeupdate", function() {
		sendMessage("timeupdate:"+video.currentTime);
	}, false);
	video.addEventListener("play", function() {
		sendMessage("play");
	}, false);
	video.addEventListener("pause", function() {
		sendMessage("pause");
	}, false);
	
}, false);
