function showData() {
    
    var nmmso = data.segments.length;
	
    data.topics.forEach(function(topic) {
        topic.score = 0;
        topic.weights = [];
        for (var i = 0; i < nmmso; i++) {
            topic.weights.push(0);
        }
    });
    
    data.segments.forEach(function(mmso, i) {
        mmso.topics.forEach(function(t) {
            data.topics[t.topic].weights[i] = t.weight;
            data.topics[t.topic].score += t.weight;
        });
    });
    
    var topicPoubelle = removeBiggestTopic ? _(data.topics.slice()).sortBy(function(t) { return -t.score; })[0].index : -1;
    
	data.topiclabels.forEach(function(v) {
		var words = _(v.words).map(function(v, k) {
			return {
				word: k,
				weight: v
			}
		});
		words.sort(function(a,b) {
			return b.weight - a.weight;
		})
		data.topics[v.topic_id].words = words;
	});
	    
    var ordertag = 0;

    function secsToString(seconds) {
        var hours = Math.floor(seconds/3600),
            minutes = Math.floor(seconds/60) % 60,
            secs = Math.floor(seconds % 60);
        function pad(n) {
            var r = n.toString();
            while (r.length < 2) {
                r = "0" + r;
            }
            return r;
        }
        return (hours ? (hours + ":") : "") + pad(minutes) + ":" + pad(secs);
    }
    
    $(".duration").text(secsToString(data.duration));
  
    
    var sortedTopics = data.topics.filter(function(t) {
        return t.index !== topicPoubelle;
    }).sort(function(a,b) {
        return b.score - a.score;
    });
    
    var selectedWords = [], topicscache = {};
    
    function showTopicsForWord(word) {
    	var topicweights = topicscache[word];
    	var topiclist = data.topics.filter(function(topic) {
            return topicweights[topic.index] > .01 && topic.index !== topicPoubelle;
        });
        topiclist.sort(function(a,b) {
            return topicweights[b.index] - topicweights[b.index]
        });
        showTopics(topiclist);
    }
    
    function wordFilter() {
        selectedWords = $(".keyword-search").tagit("assignedTags");
        
        if (selectedWords.length) {
        	var k = selectedWords.join(",");
        	console.log(k);
        	if (typeof topicscache[k] === "undefined") {
        		TopicsBean.topicsForKeywords(k,{
	                callback: function(topicweights) {
	                    topicscache[k] = topicweights;
	                    showTopicsForWord(k);
	                }
	            });
        	} else {
        		showTopicsForWord(k);
        	}
            
        } else {
            showTopics(sortedTopics);
        }
    }
    
    var currenttopics;
    
    function showTopics(topiclist) {
        var tb = $(".topics-block");
        if (topiclist.join(",") !== currenttopics) {
            currenttopics = topiclist.join(",");
            var topicHtmls = ["", "", ""];
            topiclist.forEach(function(topic,i) {
                var wordsToShow = topic.words.slice(),
                    max = wordsToShow[0].weight,
                    min = Math.min(wordsToShow[wordsToShow.length - 1].weight, max - .01),
                    scale = 10 / (max - min);
                var li = '<li class="shadow-block topic" data-topic-id="'
                    + topic.index
                    + '" data-timestamp="999999"><ul class="topic-words">'
                    + wordsToShow.reduce(function(memwords, word) {
                        return memwords
                            + '<li style="font-size: '
                            + ( 10 + scale * (word.weight - min) )
                            + 'px;">'
                            + word.word
                            + '</li>';
                    },"")
                    + '</ul></li>';
                topicHtmls[i % 3] += li;
            });
            tb.html(topicHtmls.reduce(function(mem,html) {
               return mem + '<ul class="topic-column">' + html + '</ul>' 
            },""));
        }
        if (selectedWords.length) {
            var replaceRx = new RegExp('(' + selectedWords.map(function(w) {
                return w.replace(/(\W)/g,'\\$1')
            }).join("|") + ')', "gim");
        }
        tb.find(".topic-words li").each(function() {
            var el = $(this);
            if (selectedWords.length) {
                var w = _(el.text()).escape().replace(replaceRx,'<span class="highlight">$1</span>');
                el.html(w);
            } else {
                el.text(el.text());
            }
        });
        tb.css("top",0);
        
        showTopicViz();
    }
    
    var allwords = [];
    
    data.topics.forEach(function(topic) {
        topic.words.forEach(function(topicword) {
        	topicword.word.split(" ").filter(function(w) {
        		return w.length > 2;
        	}).forEach(function(w) {
        		allwords.push(w);
        	});
        });
    });
        
    data.topwords.forEach(function(v, k) {
    	v.split(" ").filter(function(w) {
    		return w.length > 2;
    	}).forEach(function(w) {
    		allwords.push(w);
    	});
    });
        
    var allwords = _(allwords).uniq();
        
    allwords.sort();
    
    $(".keyword-search").tagit({
        availableTags: allwords,
        afterTagAdded: wordFilter,
        afterTagRemoved: wordFilter
    })
    
/*    
    $(".keyword-search").autocomplete({
        source: allwords,
        change: function() {
        	window.setTimeout(wordFilter,0);
        },
        select: function() {
        	window.setTimeout(wordFilter,0);
        }
    }).on("keyup change paste", wordFilter);
// */
    
    function showTopicViz() {
        var selectedBlocks = $(".topic.selected, .topic.hover"),
            sbl = selectedBlocks.length,
            topicBlocks = $(".topic");
        var topicsAndColors = [];
        selectedBlocks.each(function() {
            var el = $(this),
                topicid = parseInt(el.attr("data-topic-id"));
            topicsAndColors.push({
                "$": el,
                timestamp: parseInt(el.attr("data-timestamp")),
                hovered: el.hasClass("hover"),
                id: topicid,
                topic: data.topics[topicid]
            });
        });
        topicsAndColors.sort(function(a,b) {
           return ( a.timestamp - b.timestamp ) || ( a.id - b.id );
        });
        topicBlocks.css("background","");
        topicsAndColors.forEach(function(topic, i) {
            topic.color = topic.hovered ? "#ffff00" : colorset[i % colorset.length];
            topic.$.css("background", topic.color);
        });
        
        for (var i = 0; i < nmmso; i++) {
            var opacity = 0,
                rgb = [0,0,0];
            topicsAndColors.forEach(function(topic) {
                var c = Raphael.getRGB(topic.color),
                    o = topic.topic.weights[i];
                rgb[0] += c.r * o;
                rgb[1] += c.g * o;
                rgb[2] += c.b * o;
                opacity += o;
            });
            if (opacity) {
                color = Raphael.rgb.apply(Raphael, rgb.map(function(c) {
                    return c/opacity;
                }));
                segmentrects[i].show();
                segmentrects[i].attr({
                    fill: color,
                    opacity: .5 + .5 * opacity
                });
            } else {
                segmentrects[i].hide();
            }
        }
        
        var hash = "#visibletopics="
        	+ Array.prototype.join.call($(".topic:visible").map(function(){return $(this).attr("data-topic-id")}))
        	+ "&selectedtopics="
        	+ Array.prototype.slice.call(topicsAndColors.map(function(t){return t.id}))
        	+ "&keywords="
        	+ selectedWords.map(function(w) {
        		return encodeURIComponent(w);
        	}).join(",");
        	
    	document.querySelector(".play-button").hash = hash;
        
    }
    
    var jqsvg = $(".start-svg");
        paper = new Raphael(jqsvg[0]),
        ph = jqsvg.height(),
        pw = jqsvg.width(),
        yscale = (ph - 20) / data.duration,
        mx = Math.max.apply(Math, data.minutes.map(function(s) { return s.count})),
        xscale = (pw - 50)/mx;
    
    var segmentrects = data.segments.map(function(mmso) {
        var rect = paper.rect(0, yscale * mmso.start, pw - 50, 1+yscale * mmso.duration);
        rect.attr({stroke: "none"});
        return rect;
    });
    
    var d = "M" + data.minutes.map(function(s) {
            var x = xscale * s.count;
            return x
                + ","
                + yscale * (s.from + 20)
                + "L"
                + x
                + ","
                + yscale * (s.from + 40);
        }).join("L");
        
    paper.path(d).attr({
        "stroke-width": 4,
        "stroke": "#000000",
        opacity: .5
    });
    paper.path(d).attr({
        "stroke-width": 1,
        "stroke": "#ffffff"
    });
    
    for (var i=0; i < data.duration; i += 1800) {
        var y = yscale * i;
        paper.path("M0," + y + "L" + pw + "," + y).attr({
            stroke: "#666"
        });
        paper.text(pw - 2, y + 6, secsToString(i)).attr({
            "text-anchor": "end",
            "fill": "#ffffff"
        });
    }
    paper.text(pw-2, ph-14, secsToString(data.duration)).attr({
        "text-anchor": "end",
        "fill": "#ffffff"
    });
    paper.path("M0," + (ph-20) + "L" + pw + "," + (ph-20)).attr({
        stroke: "#666"
    });
    paper.text(0, ph - 14,"tweets/min.").attr({
        "text-anchor": "start",
        "fill": "#ffffff"
    });
    
    for (var k = 2; k < 6; k++) {
        var x = xscale * k * 1000;
        paper.path("M" + x + ",0L" + x + "," + (ph - 10)).attr({
            stroke: "#666"
        });
        
        paper.text(x-2, ph - 14,k+"k").attr({
            "fill": "#ffffff"
        });
    }
    
    wordFilter();
    
    $(".topics-block").on("mouseenter", ".topic", function() {
        var el = $(this);
        el.addClass("hover");
        showTopicViz();
    }).on("mouseleave", ".topic", function() {
        $(this).removeClass("hover");
        showTopicViz();
    }).on("click", ".topic", function() {
        var el = $(this);
        $(this).toggleClass("selected");
        el.attr("data-timestamp", el.hasClass("selected") ? ++ordertag : 999999);
        showTopicViz();
    });
}

var data = { duration: 10200, topics: [] },
    colorset = ["#E41A1C", "#377EB8", "#4DAF4A", "#984EA3", "#FF7F00", "#A65628", "#F781BF"];

$(function() {
    
    $(".topics-block").draggable({axis:"y"});
    
    var loadedSteps = 0,
        stepsToFullyLoaded = 0;
    
    function checkIfLoaded() {
        loadedSteps++;
        if (loadedSteps >= stepsToFullyLoaded) {
            setTimeout(showData,0);
        }
    }
    
    function loadJson(url, propname, callback) {
        stepsToFullyLoaded++;
        $.getJSON(url, function(d) {
            if (callback) {
                var res = callback(d);
            } else {
                var res = d;
            }
            if (propname) {
                data[propname] = res;
            }
            checkIfLoaded();
        });
    }
    
    function solrUrl(table, params) {
        return solrUrlBase + table + "/select?" + $.param(params) + "&wt=json&json.wrf=?";
    }
    
    function loadFromTopicsBean(method, propname, args, callback) {
        stepsToFullyLoaded++;
        var arg = args || [],
            cb = function(d) {
                if (callback) {
                    var res = callback(d);
                } else {
                    var res = d;
                }
                if (propname) {
                    data[propname] = res;
                }
                checkIfLoaded();
            }
        arg.push({callback: cb});
        TopicsBean[method].apply(TopicsBean,arg);
    }
    
    loadJson("data/minutes.json", "minutes");
    loadJson("data/topiclabels.json", "topiclabels");
    
    loadJson(
        solrUrl("MMSO", {q: "*:*", fl: "topic*,MMSO_id,multimediaSegment", rows: 250 }),
        "segments",
        function(d) {
            return d.response.docs.map(function(mmso) {
                var tc = mmso.multimediaSegment.match(/\d+/g),
                    start = parseInt(tc[0]),
                    end = parseInt(tc[1]),
                    topics = [];
                for (var k in mmso) {
                    if (k.substr(0,5) === "topic" && mmso[k] > .01) {
                        topics.push({
                            topic: parseInt(k.substr(5)),
                            weight: mmso[k]
                        })
                    }
                }
                topics.sort(function(a,b) {
                    return b.weight - a.weight;
                });
                return {
                    id: mmso.MMSO_id,
                    start: start,
                    end: end,
                    duration: end - start,
                    topics: topics
                }
            }).sort(function(a,b) {
                return a.start - b.start;
            });
        })
    
    dwr.engine.setTimeout(60000);
    TopicsBean._path = "http://159.217.144.101:8050/sia-solr/dwr";
    
    loadFromTopicsBean("getTopicsNumber",false,false,function(topic_count) {
        for (var i = 0; i < topic_count; i++) {
            data.topics.push({ index: i, words: [ { word: "(no label)", weight: 1 }] });
        }
    });
    
    loadFromTopicsBean("getTopWords","topwords",[200]);
    
});
