var deltaT = tweetStartDate / 1000 + tweetTimeDelta;

function secsToString(seconds) {
    var hours = Math.floor(seconds/3600),
        minutes = Math.floor(seconds/60) % 60,
        secs = Math.floor(seconds % 60);
    function pad(n) {
        var r = n.toString();
        while (r.length < 2) {
            r = "0" + r;
        }
        return r;
    }
    return (hours ? (hours + ":") : "") + pad(minutes) + ":" + pad(secs);
}

function solrUrl(table, params) {
    var u = solrUrlBase + table + "/select?" + $.param(params) + "&wt=json&json.wrf=?";
    return u;
}

function showData() {
    
    data.duration = data.segments[data.segments.length - 1].end;
    
    data.chapters = [];
    
    var nmmso = data.segments.length;
    
    data.topics.forEach(function(topic) {
        topic.score = 0;
        topic.weights = [];
        for (var i = 0; i < nmmso; i++) {
            topic.weights.push(0);
        }
    });
    
    data.segments.forEach(function(mmso, i) {
        mmso.topics.forEach(function(t) {
            data.topics[t.topic].weights[i] = t.weight;
            data.topics[t.topic].score += t.weight;
        });
    });
    
    var topicPoubelle = removeBiggestTopic ? _(data.topics.slice()).sortBy(function(t) { return -t.score; })[0].index : -1;
        
    data.segments.forEach(function(segment, index) {
    	var topics = segment.topics.filter(function(t) {
    		return t.topic !== topicPoubelle;
    	}).map(function(t) {
    		return t.topic
		});
    	var openchapters = data.chapters.filter(function(c) {
    		return c.open;
    	});
    	openchapters.forEach(function(c) {
    		var i = topics.indexOf(c.topic);
    		if (i == -1) {
    			c.open = false;
    		} else {
    			c.endMMSO = index;
    			c.endTime = segment.end;
    			topics.splice(i, 1);
    		}
    	});
    	
    	if (topics.length) {
    		topics.forEach(function(t) {
    			data.chapters.push({
    				startMMSO: index,
    				endMMSO: index,
    				startTime: segment.start,
    				endTime: segment.end,
    				topic: t,
    				open: true
    			})
    		})
    	}
    });
    
	data.topiclabels.forEach(function(v) {
		var words = _(v.words).map(function(v, k) {
			return {
				word: k,
				weight: v
			}
		});
		words.sort(function(a,b) {
			return b.weight - a.weight;
		})
		data.topics[v.topic_id].words = words;
	});
	
    var topicHash = document.location.hash || "#selectedtopics=5,15&visibletopics=5,10,15";
    
    var pageParams = {};
        
    topicHash
    	.replace(/^#/,'')
    	.split('&')
    	.forEach(function(p) {
    		var s = p.split('=');
    		pageParams[s[0]] = s[1].split(",").map(function(t) { return decodeURIComponent(t)});
    	})
    
    var ordertag = 0;
    
    $(".duration").text(secsToString(data.duration));
       
    var sortedTopics = data.topics.filter(function(t) {
        return pageParams.visibletopics.indexOf(t.index.toString()) !==-1 && t.index !== topicPoubelle;
    });
    
    function hasTopics(mmso, topics) {
    	for (var j = 0; j < mmso.topics.length; j++) {
			if (topics.indexOf(mmso.topics[j].topic) !== -1) {
				return true;
			}
		}
		return false;
    }
    
    function checkOrGoNext() {
    	var topics = Array.prototype.slice.call(
    		$(".topic.selected").map(function() {
    			return parseInt($(this).attr("data-topic-id"))
			})
		);
		var currentMmso = _(data.segments).find(function(s) {
			return s.start <= player.currentTime && s.end > player.currentTime;
		});
		
		if (hasTopics(currentMmso, topics)) {
			throttledShowLocal();
		} else {
			goToNext();
		}
		
    }
    
    function goToNext() {
    	var topics = Array.prototype.slice.call(
    		$(".topic.selected").map(function() {
    			return parseInt($(this).attr("data-topic-id"));
			})
		);
    	for (var i = 0; i < data.chapters.length; i++) {
    		var chap = data.chapters[i];
    		if (chap.startTime > player.currentTime && topics.indexOf(chap.topic) !== -1) {
    			player.setCurrentTime(chap.startTime);
				return;
    		}
    	}
    	/* If next not found, loop around ! */
    	for (var i = 0; i < data.chapters.length; i++) {
    		var chap = data.chapters[i];
    		if (topics.indexOf(chap.topic) !== -1) {
    			player.setCurrentTime(chap.startTime);
				return;
    		}
    	}
    }
    
    function goToPrev() {
    	var topics = Array.prototype.slice.call(
    		$(".topic.selected").map(function() {
    			return parseInt($(this).attr("data-topic-id"));
			})
		);
    	for (var i = data.chapters.length; i--;) {
    		var chap = data.chapters[i];
    		if (chap.startTime < (player.currentTime - 2) && topics.indexOf(chap.topic) !== -1) {
    			player.setCurrentTime(chap.startTime);
				throttledShowLocal();
				return;
    		}
    	}
    	/* If previous not found, loop around ! */
    	for (var i = data.chapters.length; i--;) {
    		var chap = data.chapters[i];
    		if (topics.indexOf(chap.topic) !== -1) {
    			player.setCurrentTime(chap.startTime);
				throttledShowLocal();
				return;
    		}
    	}
    }
    
    function showTopics(topiclist) {
    	
    	
        var tbhtml = topiclist.reduce(function(mem, topic) {
            var wordsToShow = topic.words.slice(0,4),
                max = wordsToShow[0].weight,
                min = Math.min(wordsToShow[wordsToShow.length - 1].weight, max - .01),
                scale = 8 / (max - min);
            
	    	function line(words) {
	    		return '<ul class="topic-words">' + words.reduce(function(memwords, word) {
	                return memwords
	                    + '<li style="font-size: '
	                    + ( 8 + scale * (word.weight - min) )
	                    + 'px;">'
	                    + word.word
	                    + '</li>';
	            },"") + '</ul>';
	    	}
	    	
            var li = '<li class="shadow-block topic" data-topic-id="'
                + topic.index
                + '" data-timestamp="999999">'
                + line(wordsToShow.filter(function( v, k ) {
                	return !(k % 2);
                }))
                + line(wordsToShow.filter(function( v, k ) {
                	return !!(k % 2);
                }))
            	+ '</li>';
            return mem + li;
        },'');
        var tb = $(".topics-list");
        tb.html(tbhtml);
        tb.css("top",0);
        
        throttledShowLocal();
    }
           
    
    
    var images = {},
    	playTime = $(".current-time");
    
	var globW = 85,
        globL = 40,
        entonnoirR = 155,
        localL = 235,
        localW = 85,
        localR = (localL + localW),
        localTimeR = (localL + localW) + globL,
        globR = (globW + globL),
        mx = Math.max.apply(Math, data.minutes.map(function(s) { return s.count})),
        xscale = globW/mx,
        yscale,
        localyscale,
        filteredSegments = [],
        currentTweetTc = -1;
    
    function showLocal() {
    	var $c = $(".play-canvas"),
    		c = $c[0],
    		ph = $c.height(),
    		pw = $c.width();
        
        yscale = ph / data.duration;
		localyscale = ph / localduration;
		
		var localstart = localpos - localduration/2;
    		localend = localpos + localduration/2;
    		globtop = yscale * localstart,
    		globbottom = yscale * localend,
    		betweenx = (globR + entonnoirR) / 2,
    		betweenyt = (globtop) / 2,
    		betweenyb = (globbottom + ph) / 2,
    		curve = (entonnoirR - globR) / 2,
        
    	c.width = pw;
    	c.height = ph;
    	
    	var ctx = c.getContext('2d');
    	
    	ctx.clearRect(0,0, pw, ph);
    	
    	/* Tracé de l'entonnoir */
    	
    	ctx.beginPath();
    	
    	ctx.moveTo(0, globtop);
    	ctx.lineTo(globR, globtop);
    	ctx.quadraticCurveTo(betweenx, globtop, betweenx, Math.max(globtop - curve, betweenyt));
    	ctx.lineTo(betweenx, Math.min(curve, betweenyt));
    	ctx.quadraticCurveTo(betweenx, 0, entonnoirR, 0 );
    	ctx.lineTo(localR,0);
    	ctx.lineTo(localR, ph);
    	ctx.lineTo(entonnoirR, ph);
    	ctx.quadraticCurveTo(betweenx, ph, betweenx, Math.max(ph - curve, betweenyb));
    	ctx.lineTo(betweenx, Math.min(globbottom + curve, betweenyb));
    	ctx.quadraticCurveTo(betweenx, globbottom, globR, globbottom, globbottom);
    	ctx.lineTo(0,globbottom);
    	ctx.fillStyle = '#222222';
    	ctx.fill();

		
        var selectedBlocks = $(".topic.selected, .topic.hover"),
            sbl = selectedBlocks.length,
            topicBlocks = $(".topic"),
            topicsAndColors = [],
        	colors = {};
        selectedBlocks.each(function() {
            var el = $(this),
                topicid = parseInt(el.attr("data-topic-id"));
            topicsAndColors.push({
                "$": el,
                timestamp: parseInt(el.attr("data-timestamp")),
                hovered: el.hasClass("hover"),
                id: topicid,
                topic: data.topics[topicid]
            });
        });
        topicsAndColors.sort(function(a,b) {
           return ( a.timestamp - b.timestamp ) || ( a.id - b.id );
        });
        topicBlocks.css("background","");
        topicsAndColors.forEach(function(topic, i) {
            topic.color = topic.hovered ? "#ffff00" : colorset[i % colorset.length];
            colors[topic.id] = topic.color;
            topic.$.css("background", topic.color);
        });

		/* Tracé des MMSOs */
		
		var localkeywords = {};
		
		filteredSegments = [];
		
        for (var i = 0; i < nmmso; i++) {
            var mmso = data.segments[i],
            	opacity = 0,
                rgb = [0,0,0];
            topicsAndColors.forEach(function(topic) {
            	var o = topic.topic.weights[i];
                rgb[0] += parseInt(topic.color.substr(1,2),16) * o;
                rgb[1] += parseInt(topic.color.substr(3,2),16) * o;
                rgb[2] += parseInt(topic.color.substr(5,2),16) * o;
                opacity += o;
            });
            var isinlocal = (mmso.end > localstart && mmso.start < localend);
            if (isinlocal) {
            	filteredSegments.push(mmso);
				var y = localyscale * (mmso.start - localstart),
					h = localyscale * mmso.duration,
					visibled = (
						mmso.start < localstart
						? mmso.duration - localstart + mmso.start
						: (
							mmso.end > localend
							? mmso.duration - mmso.end + localend
							: mmso.duration
						)
					);
				_(mmso.keywords).each(function(v,k) {
					localkeywords[k] = (v * visibled) + (localkeywords[k] || 0);
				});
            }
            if (opacity) {
                rgb = rgb.map(function(c) {
                    return parseInt(c/opacity);
                });
                ctx.fillStyle = 'rgba(' + rgb.join(',') + ',' + (.25+.75*opacity) + ')';
                ctx.fillRect(globL, yscale * mmso.start, globW, yscale * mmso.duration);
                if (isinlocal) {
					ctx.fillRect( localL, y, localW, h );
                }
            }
        }
        
        /* Tracé des courbes de nombres de tweets */
        
        var styles = [
	        {
	        	lineWidth: 4,
	        	strokeStyle: "rgba(0,0,0,.5)"
	        },
	        {
	        	lineWidth: 1,
	        	strokeStyle: "#ffffff"
	        }
        ]
        
        styles.forEach(function(s) {
        	ctx.beginPath();
        	data.minutes.forEach(function(m, i) {
        		var x = globL + xscale * m.count,
        			y1 = yscale * (m.from + 20),
        			y2 = yscale * (m.from + 40);
        		if (i) {
        			ctx.lineTo(x,y1);
        		} else {
        			ctx.moveTo(x,y1);
        		}
        		ctx.lineTo(x,y2);
        	});
        	_(s).each(function(v, k) {
        		ctx[k] = v;
        	});
        	ctx.stroke();
        });
        
		var filteredFiveSecs = data.fiveseconds.slice(Math.floor(localstart / 5), Math.ceil(localend / 5));
        var counts = filteredFiveSecs.map(function(s) { return s.count}),
        	lmx = Math.max.apply(Math, counts),
        	lmi = Math.min.apply(Math, counts.concat([lmx - 1]))
        	lxscale = localW/(lmx-lmi);
        	
       	styles.forEach(function(s) {
        	ctx.beginPath();
        	filteredFiveSecs.forEach(function(m, i) {
        		var x = localL + lxscale * (m.count - lmi),
        			y1 = localyscale * (m.from + 1 - localstart),
        			y2 = localyscale * (m.from + 4 - localstart);
        		if (i) {
        			ctx.lineTo(x,y1);
        		} else {
        			ctx.moveTo(x,y1);
        		}
        		ctx.lineTo(x,y2);
        	});
        	_(s).each(function(v, k) {
        		ctx[k] = v;
        	});
        	ctx.stroke();
        });
        
        var deltaY = $(".play-bottom").offset().top;
        
		ctx.strokeStyle = "#ccc";
		
        $(".play-localtweets .tweet").each(function() {
        	var el = $(this),
        		liY = + el.offset().top + el.outerHeight() / 2 - deltaY;
    		if (liY < 0 || liY > ph) {
    		    return;
    		}
        	var t = +el.attr("data-timestamp"),
        		tY = localyscale * (t - localpos + localduration / 2),
                tX = localL + lxscale * (data.fiveseconds[Math.floor(t / 5)].count - lmi);
    		ctx.beginPath();
    		ctx.moveTo(tX, tY);
    		ctx.lineTo(localR, tY);
    		ctx.lineTo(400, liY);
    		ctx.stroke();
    		$(this).css("background",colors[el.attr("data-topic-id")] || "");
        });
        
		ctx.strokeStyle = "#000";
        ctx.fillStyle = "#ff0";
		
        $(".user-tweets .tweet:visible").each(function() {
            var el = $(this),
                t = +el.attr("data-timestamp"),
                hover = (t === currentTweetTc);
            if (hover) {
                ctx.strokeStyle = "#900";
                ctx.lineWidth = 3;
            }
            if (t > localstart && t < localend) {
                var tY = localyscale * (t - localpos + localduration / 2),
                    tX = localL + lxscale * (data.fiveseconds[Math.floor(t / 5)].count - lmi);
        		ctx.beginPath();
        		ctx.arc(tX,tY,hover ? 6 : 3,0,2*Math.PI,true);
        		ctx.fill();
        		ctx.stroke();
            }
            var n = Math.floor(t / 60),
                x = globL + xscale * data.minutes[n].count,
                y = yscale * t;
            ctx.beginPath();
            ctx.arc(x,y,hover ? 6 : 3,0,2*Math.PI,true);
            ctx.fill();
            ctx.stroke();
            if (hover) {
                ctx.strokeStyle = "#000";
                ctx.lineWidth = 1;
            }
        });
        
        ctx.fillStyle = '#ffffff';
        ctx.strokeStyle = '#999999';
        ctx.font = '10px Arial,Helvetica';
        
        function line(x1,y1,x2,y2) {
        	ctx.beginPath();
			ctx.moveTo(x1, y1);
			ctx.lineTo(x2, y2);
			ctx.stroke();
        }
        
		line(0, 0, localTimeR, 0);
		line(0, ph-1, localTimeR, ph-1 );
		line(globR, 0, globR, ph);
		line(localL, 0, localL, ph);
		
		/* Global Times */
		ctx.fillText(secsToString(data.duration), 0, ph - 3);
		 
	    for (var i=0; i < data.duration; i += 1800) {
	        var y = yscale * i;
	        line(0, y, globR, y);
	        ctx.fillText(secsToString(i), 0, y+9);
	    }
		
        /* Local Times */
        ctx.fillText(secsToString(localstart), localTimeR - 30, 9);
        ctx.fillText(secsToString(localend), localTimeR - 30, ph - 3);
	    
		for ( var i = (1 + Math.floor(localstart / 120)) * 120; i < localend; i += 120 ) {
			var y = localyscale*(i - localstart);
			ctx.fillText(secsToString(i), localTimeR - 30, 9+y);
			line(localL, y, localTimeR, y);
		}
		
		
		var imgw = 80,
			imgh = 45,
			imgrate = localduration / 12,
			imgstart = imgrate * Math.floor(localstart / imgrate),
			imgend = imgrate * Math.ceil(localend / imgrate);
		
		for (var i = imgstart; i <= imgend; i+= imgrate) {
	    	var imgsrc = i + '.png';
	    	while (imgsrc.length < 9) {
	    		imgsrc = '0' + imgsrc;
	    	}
	    	if (images[i]) {
	    		if (images[i].width) {
	    			ctx.drawImage(images[i], entonnoirR, localyscale * (i - localstart) - imgh / 2, imgw, imgh);
	    		}
	    	} else {
	    		var img = new Image();
	    		img.onload = function() {
	    			throttledShowLocal();
	    		}
	    		img.src = 'thumbnails/' + imgsrc;
	    		images[i] = img;
	    	}
	    }
	    
		if (player) {
			var yg = yscale * player.currentTime,
				yl = (player.currentTime - localstart) * localyscale,
				betweeny = (yg + yl) / 2,
				styles = [
			        {
			        	lineWidth: 4,
			        	strokeStyle: "rgba(0,0,0,.5)"
			        },
			        {
			        	lineWidth: 1,
			        	strokeStyle: "#ff00cc"
			        }
		        ];
	        
	        styles.forEach(function(s) {
	        	ctx.beginPath();
				ctx.moveTo(0, yg);
				if (player.currentTime >= localstart && player.currentTime <= localend) {
					ctx.lineTo(globR, yg);
			    	ctx.quadraticCurveTo(betweenx + 3, yg, betweenx + 3, yg > yl ? Math.max(yg - curve, betweeny) : Math.min(yg + curve, betweeny));
			    	ctx.lineTo(betweenx + 3, yg < yl ? Math.max(yl - curve, betweeny) : Math.min(yl + curve, betweeny));
			    	ctx.quadraticCurveTo(betweenx + 3, yl, entonnoirR + 6, yl );
			    	ctx.lineTo(localR, yl);
			    } else {
			    	ctx.lineTo(betweenx, yg);
			    }
	        	
	        	_(s).each(function(v, k) {
	        		ctx[k] = v;
	        	});
	        	ctx.stroke();
	        });
			
		}
		
	    $(".play-localtweets .tweet").each(function() {
	    	var el = $(this),
	    		t = parseInt(el.attr("data-timestamp"));
    		if (t > localstart && t < localend) {
    			el.show();
    		} else {
    			el.hide();
    		}
	    });
	    
	    localkeywords = _(localkeywords)
	    	.chain()
	    	.map(function(v,k) {
	    		return { word: k, score: v }
	    	})
	    	.sortBy(function(w) {
	    		return -w.score;
	    	})
	    	.first(tcLength)
	    	.value();
    	
    	var values = _(localkeywords).pluck('score'),
    		max = Math.max.apply(Math, values),
    		min = Math.min.apply(Math, values),
    		scale = 10 / (max - Math.min(max - .1, min)),
    		selectedVisible = false,
    		tc = $(".play-tagcloud li");
    		
		localkeywords.forEach(function(w, i) {
			var size = 12 + (w.score - min) * scale,
				selected = (w.word === selectedWord),
				e = $(tc[i]),
				t = e.text();
			if (t !== w.word) {
				e.text(w.word);
			}
			e.css("font-size", size + "px");
			if (selected) {
				e.addClass("selected");
			} else {
				e.removeClass("selected");
			}
			selectedVisible = selectedVisible || selected;
		});
		if (localkeywords.length < tcLength) {
			for (var i = localkeywords.length; i < tcLength; i++) {
				$(tc[i]).text("").removeClass("selected");
			}
		}
    	
    	if (!selectedVisible) {
    		selectedWord = false;
    	}
    	    
		throttledGetTweets();
    }
    
    var tcLength = 20;
    
    for (var i = 0; i < tcLength; i++) {
    	$(".play-tagcloud").append("<li>");
    }
    
    $(".play-tagcloud li").click(function() {
    	
    	var w = $(this).text();
    	if (w === selectedWord) {
    		selectedWord = false;
    	} else {
    		selectedWord = w;
    	}
    	throttledShowLocal();
    });
    
    
    var lastPos, lastDuration, lastTopics;
    
    var tweetTemplate = _.template(
    		'<li class="tweet" data-timestamp="<%= timestamp %>" data-topic-id="<%= topic.topic %>" data-tweet-id="<%- data.id_str %>">'
    		+ '<% if (show_link) { %><a href="#" data-user-id="<%- data.from_user_id %>"><% } %>'
    		+ '<img src="<%- data.profile_image_url %>" /><% if (show_link) { %></a><% } %>'
    		+ '<p><% if (show_link) { %><a href="#" data-user-id="<%- data.from_user_id %>"><% } %>'
    		+ '@<%- data.from_user_name %>:<% if (show_link) { %></a><% } %> <%= htext %></p>'
    		+ '<% if (show_time) { %><p><%- secsToString(timestamp) %></p><% } %>'
    		+ '</li>'),
    	callnum = 0,
    	tweetstructure = {},
    	requestedtweets = {},
    	_NTWEETS = 50,
    	selectedWord = false,
    	lastHtml = "";
    
    
    function showTweets() {
    	var toshow = [];
    	var topics = Array.prototype.join.call($(".topic.selected").map(function(){return $(this).attr("data-topic-id")})).split(",");
    	
    	filteredSegments.forEach(function(mmso) {
    		var mmsostruct = tweetstructure[mmso.id];
    		if (mmsostruct) {
	    		for (var j = 0; j < topics.length; j++) {
	    			var topicid = topics[j];
					if (mmsostruct.tweetids) {
						var tweetids = mmsostruct.tweetids[topicid];
						for (var k = 0; k < tweetids.length; k++) {
							toshow.push(tweetids[k]);
						}
					}
	    		}
    		}
   		});
    	toshow = _(toshow).uniq();
    	    	
    	var tweetstoshow = toshow.map(function(tid) {
    		return requestedtweets[tid];
    	}).filter(function(tw) {
    		return ((tw.status == 2) && (tw.timestamp > (localpos - localduration / 2)) && (tw.timestamp < (localpos + localduration / 2)));
		});
				
		if (selectedWord) {
			var rx = new RegExp(selectedWord.replace(/(\W)/gm,'\\$1'),'im');
			tweetstoshow = tweetstoshow.filter(function(tw) {
				return rx.test(tw.data.text);
			});
		}
		
		tweetstoshow.forEach(function(tw) {
			tw.topic = tw.topics.filter(function(t) {
				return topics.indexOf(t.topic.toString()) !== -1;
			}).sort(function(a,b) {
				return b.weight - a.weight
			})[0];
		});
		
		tweetstoshow = tweetstoshow.filter(function(t) {
			return !!t.topic;
		});
				
		tweetstoshow.sort(function(a, b) {
			return b.topic.weight - a.topic.weight; 
		});
		
		if (tweetstoshow.length < 4) {
			var randtweets = data.randomtweets.filter(function(tw) {
				return (tw.timestamp > (localpos - localduration / 2)) && (tw.timestamp < (localpos + localduration / 2))
			});
			if (selectedWord) {
				var rx = new RegExp(selectedWord.replace(/(\W)/gm,'\\$1'),'im');
				randtweets = randtweets.filter(function(tw) {
					return rx.test(tw.data.text);
				});
			}
			var mod = Math.ceil(randtweets.length / 5);
			randtweets = randtweets.filter(function(v,k) {
				return !(k % mod);
			});
			tweetstoshow = tweetstoshow.concat(randtweets);
		}
		
		tweetstoshow = tweetstoshow.slice(0,6);
		
		if (selectedWord) {
			var rx = new RegExp( '(' + selectedWord.replace(/(\W)/gm,'\\$1') + ')', 'gim' );
			tweetstoshow.forEach(function(tw) {
				tw.htext = _(tw.data.text).escape().replace(rx,'<span class="highlight">$1</span>');
			});
		} else {
			tweetstoshow.forEach(function(tw) {
				tw.htext = _(tw.data.text).escape();
			});
		}
		
		tweetstoshow.forEach(function(tw) {
			tw.show_link = true;
			tw.show_time = false;
		});
		
		tweetstoshow.sort(function(a, b) {
			return a.timestamp - b.timestamp;
		});
		
		var html = tweetstoshow.map(tweetTemplate).join("");
		
		if (lastHtml !== html) {
		    $(".play-localtweets").html(html);
		}
		lastHtml = html;
		var h = 0;
		$(".play-localtweets .tweet").each(function() {
			h += $(this).outerHeight();
		});
		$(".play-localtweets .tweet").css("margin-top",Math.max(0,($(".play-bottom").height() - h)/(tweetstoshow.length+1)));
		showLocal();
    	
    }
    
    function getMmsoTweetIds(mmstruct) {
    	TopicsBean.bestSocialInteractionsIdsMatching(mmstruct.mmsoid, 0, _NTWEETS, {
			callback: function(res) {
				mmstruct.status = 2;
				mmstruct.tweetids = res;
				for (var j = 0; j < res.length; j++) {
					var tweetids = res[j],
						ntw = tweetids.length,
						topicweight = data.topics[j].weights[mmstruct.mmsoindex];
					for (var k = 0; k < tweetids.length; k++) {
						var relevance = topicweight + .5 * (ntw - k) / ntw,
							tweetid = tweetids[k];
						if (!requestedtweets[tweetid]) {
							requestedtweets[tweetid] = {
								id: tweetid,
								status: 0,
								topics: []
							}
						}
						requestedtweets[tweetid].topics.push({
							topic: j,
							weight: relevance
						});
					}
				}
				debouncedGetTweetData();
			},
			errorHandler: function(err,info) {
				mmstruct.status = 0;
				console.error(err,info);
				debouncedGetTweetIds();
			}
		});
    }
    
    var _MAX_BATCH = 20;
    
    function getTweetIds() {
    	    	
    	var toload = [];
    	
    	_(tweetstructure).each(function(w) {
			if (!w.status) {
				w.status = 1;
				toload.push(w);
			}
    	});
    	
    	if (toload.length) {
    		
    		if (toload.length > _MAX_BATCH) {
    			toload = _(toload).shuffle().slice(0,_MAX_BATCH);
    			window.setInterval(throttledGetTweetIds,0);
    		}
    		
    		dwr.engine.beginBatch();
    		toload.forEach(getMmsoTweetIds);
    		dwr.engine.endBatch();
    	}
    }
    
    function getTweetData() {
    	
    	var toload = [];
    	
    	_(requestedtweets).each(function(v) {
			if (!v.status) {
				toload.push(v.id);
			}
		});
		
		if (toload.length) {
			toload = toload.slice(0,200);
			toload.forEach(function(twid) {
				requestedtweets[twid].status = 1;
			})
			$.getJSON(
			solrUrl(
				"twitter",
				{
					q:"id:(" + toload.join(" OR ") + ")",
					fl: "id_str,created_at,from_user_name,text,profile_image_url,from_user_id",
					rows: toload.length
				}
			),
			function(t) {
				var tweets = t.response.docs;
				tweets.forEach(function(tweet) {
					var timestamp = new Date(tweet.created_at).valueOf() / 1000 - deltaT;
					requestedtweets[tweet.id_str].data = tweet;
					requestedtweets[tweet.id_str].status = 2;
					requestedtweets[tweet.id_str].timestamp = timestamp;
				});
				throttledShowTweets();
				debouncedGetTweetData();
			});
		}
		
		
		
    }
    
    debouncedGetTweetData = _(getTweetData).debounce(125);
    
    throttledGetTweetIds = _(getTweetIds).throttle(10000);
    
    debouncedGetTweetIds = _(throttledGetTweetIds).debounce(125);
    
    throttledShowTweets = _(showTweets).throttle(200);
    
    function getLocalTweets() {
    	
    	var topics = Array.prototype.join.call($(".topic.selected").map(function(){return $(this).attr("data-topic-id")})).split(",");
    	
    	filteredSegments.forEach(function(mmso) {
    		if (!tweetstructure[mmso.id]) {
    			tweetstructure[mmso.id] = {
    				mmsoid: mmso.id,
    				mmsoindex: parseInt(mmso.id.replace(/^\w+_/,'')),
    				status: 0
    			}
    		}
    	});
    	
    	throttledGetTweetIds();
    	throttledShowTweets();
    }
    
    var throttledGetTweets = _.throttle(getLocalTweets, 500),
    	throttledShowLocal = _.throttle(showLocal, 50);
    
    showTopics(sortedTopics);
    
    pageParams.selectedtopics.forEach(function(id) {
    	$(".topic[data-topic-id=" + id + "]").addClass("selected").attr("data-timestamp",++ordertag);
    });
    
    var localpos = 300,
    	localduration = 600;
   	
   	var player = new Player(typeof tvCoords !== "undefined" ? tvCoords : null);
   	
   	player.duration = data.duration;
   	
   	player.on("play", function() {
   		$(".play-button").attr("title","Pause").addClass("playing");
   	});
   	player.on("pause", function() {
   		$(".play-button").attr("title","Lecture").removeClass("playing");
   	});
   	player.on("timeupdate", function(t) {
   		playTime.text(secsToString(t));
    	if (timelock) {
    		localpos = Math.max(localduration / 2, Math.min(data.duration - localduration / 2, t + localduration / 6));
    	}
    	throttledShowLocal();
   	});
   	
   	$(".play-button").click(function() {
   		if (player.paused) {
   			player.play();
   		} else {
   			player.pause();
   		}
   		return false;
   	});
    
    $(".next-button").click(function() {
    	goToNext();
    	return false;
	});
    
    $(".prev-button").click(function() {
    	goToPrev();
    	return false;
	});
	
    $(".topics-list").on("mouseenter", ".topic", function() {
        var el = $(this);
        el.addClass("hover");
        throttledShowLocal();
    }).on("mouseleave", ".topic", function() {
        $(this).removeClass("hover");
        throttledShowLocal();
    }).on("click", ".topic", function() {
        var el = $(this);
        $(this).toggleClass("selected");
        el.attr("data-timestamp", el.hasClass("selected") ? ++ordertag : 999999);
		throttledGetTweets();
		throttledShowLocal();
    });

	var h = Hammer($(".play-bottom")[0]);
	
	var scrollGlobal, isDragging, startPos, startLevel, scaleStep = 1/Math.log(Math.sqrt(2));
	
	h.on("tap", function(e) {
		var _o = $(this).offset(),
			posX = e.gesture.center.pageX - _o.left,
			posY = e.gesture.center.pageY - _o.top;
		if (posX < 140) {
			if (timelock) {
    			player.setCurrentTime(Math.max(0, Math.min(data.duration, Math.floor(posY / yscale))));
			} else {
				localpos = Math.max(localduration / 2, Math.min(data.duration - localduration / 2, Math.floor(posY / yscale) + localduration / 6));
				throttledShowLocal();
			}
		}
	})
	.on("dragstart", function(e) {
		startPos = localpos;
		var x = e.gesture.center.pageX - $(this).offset().left;
		isDragging = (x < 380);
		scrollGlobal = (x < 140);
	})
	.on("drag", function(e) {
		if (isDragging && e.gesture) {
			var delta = Math.floor(e.gesture.deltaY / (scrollGlobal ? yscale : - localyscale));
			if (timelock) {
    			player.setCurrentTime(Math.max(0, Math.min(data.duration, startPos + delta)));
			} else {
				localpos = Math.max(localduration / 2, Math.min(data.duration - localduration / 2, startPos + delta));
				throttledShowLocal();
			}
		}
	})
	.on("touch", function(e) {
		startLevel = currentlevel;
	})
	.on("pinchin pinchout", function(e) {
		var x = e.gesture.center.pageX - $(this).offset().left;
		if (x > 380) {
			return;
		}
		var newlevel = Math.max(
			0,
			Math.min(
				zoomlevels.length - 1,
				startLevel + Math.round(Math.log(e.gesture.scale)*scaleStep) * (x > 140 ? 1 : -1)
			)
		);
		if (newlevel !== currentlevel) {
			currentlevel = newlevel;
			localduration = zoomlevels[currentlevel];
			localpos = Math.max(localduration / 2, Math.min(data.duration - localduration / 2, localpos));
			throttledShowLocal();
		}
	});
   
    var totalScroll = 0, zoomlevels = [ 1800, 900, 600, 300, 120, 60 ], currentlevel = 2;
    
    $(".play-canvas")
    .on("touchstart", function(_e) {
        _e.preventDefault();
    })
    .mousedown(function(_e) {
    	_e.preventDefault();
    })
    .mousewheel(function(_event, _scrolldelta) {
    	totalScroll += _scrolldelta;
	    if (Math.abs(totalScroll) >= 1) {
	    	var d = (totalScroll > 0 ? 1 : -1),
	    		newlevel = Math.max(0, Math.min(zoomlevels.length - 1, currentlevel + d));
    		if (newlevel !== currentlevel) {
    			currentlevel = newlevel;
    			var oldduration = localduration;
    			localduration = zoomlevels[currentlevel];
    			localpos = Math.max(localduration / 2, Math.min(data.duration - localduration / 2, localpos - (oldduration - localduration) / 6 ));
    			throttledShowLocal();
    		}
	        totalScroll = 0;
	    }
	    _event.preventDefault();
    });
    
    if (pageParams.keywords && pageParams.keywords.join("").length) {
    	$(".keyword-search a").removeClass("placeholder").text(pageParams.keywords.join(", "));
    }
    
    var moveInterval;
    
    $(".left-arrow").data("direction", 3);
    $(".right-arrow").data("direction", -3);
    
    $(".left-arrow,.right-arrow")
    	.on("mouseenter touchstart", function() {
    		clearInterval(moveInterval);
    		var moveDirection = $(this).data("direction");
    		moveInterval = setInterval(function() {
    			var t = $(".topics-block");
    			var newcss =  + moveDirection + parseFloat(t.css("left"));
    			if ((moveDirection > 0 && newcss > 30) || (moveDirection < 0 && newcss < (t.parent().width() - t.children().width() - 30))) {
    				clearInterval(moveInterval);
    				return;
    			}
    			t.css("left", newcss);
    		}, 20);
    	})
    	.on("mouseleave touchend", function() {
    		clearInterval(moveInterval);
    	});
    var usersCache = {};
    
    function showUserTweets(userid) {
        var tweets = usersCache[userid];
		tweets.forEach(function(tweet) {
			tweet.timestamp = new Date(tweet.created_at).valueOf() / 1000 - deltaT;
		});
		tweets = tweets.filter(function(tweet) {
		    return tweet.timestamp > 0 && tweet.timestamp < data.duration;
		});
		tweets.sort(function(a,b) {
			return a.timestamp - b.timestamp;
		})
		var html = tweets.reduce(function(mem, tweet) {
			return mem + tweetTemplate({
				timestamp: tweet.timestamp,
				topic: {topic: -1},
				weight: 0,
				data: tweet,
				htext: _(tweet.text).escape(),
				show_link: false,
				show_time: true
			});
		},"");
		var utl = $(".user-tweets-list");
		utl.html(html);
		var currentTweetLi = $(".user-tweets-list").find(".tweet[data-tweet-id='" + currentTweet + "']");
		if (currentTweetLi.length) {
		    currentTweetLi.css("margin-left",0);
		    utl.scrollTop(currentTweetLi.offset().top - utl.offset().top + utl.scrollTop() - utl.height() / 2 + currentTweetLi.height() / 2);
		}
		  
		$(".user-name").text(tweets[0].from_user_name);
    }
    
    var currentTweet = 0;
    
    $(".play-localtweets").on("click", "li a", function() {
    	var userid = $(this).attr("data-user-id");
    	currentTweet = $(this).parents("li.tweet").attr("data-tweet-id");
        $(".user-tweets").css({
            display: "block",
            left: $(".contents").width() + 20
        }).animate({
            left: "420px"
        });
        $(".user-tweets-list").html("<li class='loading'>Chargement en cours</li>");
        $(".user-name").text($(this).parents("li.tweet").find("p a").text().replace(/(^@|:$)/g,""));
    	if (!usersCache[userid]) {
    	    usersCache[userid] = [];
        	$.getJSON(
    			solrUrl(
    				"twitter",
    				{
    					q: "from_user_id:" + userid,
    					fl: "id_str,created_at,from_user_name,text,profile_image_url,from_user_id",
    					rows: 500
    				}
    			),
    			function(t) {
    				usersCache[userid] = t.response.docs;
                    showUserTweets(userid);
    			}
    		);
		} else {
		    showUserTweets(userid);
		}
		return false;
    });
    
    $(".user-tweets").on("click", "li", function() {
        player.setCurrentTime(parseInt($(this).attr("data-timestamp")));
        return false;
    }).on("mouseenter", "li", function() {
        currentTweetTc = parseInt($(this).attr("data-timestamp"));
        throttledShowLocal();
    }).on("mouseleave", "li", function() {
        currentTweetTc = -1;
        throttledShowLocal();
    });
    
    var timelock = true;
    
    $(".lock-button").click(function() {
    	timelock = !timelock;
    	if (timelock) {
    		$(this).addClass("locked").attr("title", "Découpler la lecture et la visualisation");
    	} else {
    		$(this).removeClass("locked").attr("title", "Coupler la lecture et la visualisation");
    	}
    	return false;
    });
    
    $(window).on("resize", function() {
        throttledShowLocal
        $(".user-tweets").width($(".contents").width()-480);
    });
    
    $(".close-user-tweets").click(function() {
        currentTweetTc = -1;
        $(".user-tweets").animate({
            left: $(".contents").width() + 20
        }, function(){
            $(this).hide();
        });
        return false;
    })
    
    $(".user-tweets").width($(".contents").width()-480);
    checkOrGoNext();
}

var data = { topics: [] },
    colorset = ["#E41A1C", "#377EB8", "#4DAF4A", "#984EA3", "#FF7F00", "#A65628", "#F781BF"];

$(function() {
	
	dwr.engine.setErrorHandler(function(a, b) { console.error("DWR", b); });
    
    $(".topics-block").draggable({axis:"x"});
    
    var loadedSteps = 0,
        stepsToFullyLoaded = 0;
    
    function checkIfLoaded() {
        loadedSteps++;
        if (loadedSteps >= stepsToFullyLoaded) {
            setTimeout(showData,0);
        }
    }
    
    function loadJson(url, propname, callback) {
        stepsToFullyLoaded++;
        $.getJSON(url, function(d) {
            if (callback) {
                var res = callback(d);
            } else {
                var res = d;
            }
            if (propname) {
                data[propname] = res;
            }
            checkIfLoaded();
        });
    }
    
    function loadFromTopicsBean(method, propname, args, callback) {
        stepsToFullyLoaded++;
        var arg = args || [],
            cb = function(d) {
                if (callback) {
                    var res = callback(d);
                } else {
                    var res = d;
                }
                if (propname) {
                    data[propname] = res;
                }
                checkIfLoaded();
            }
        arg.push({callback: cb});
        TopicsBean[method].apply(TopicsBean,arg);
    }
    
    loadJson("data/minutes.json", "minutes");
    loadJson("data/5secs.json", "fiveseconds");
    
    var t = Math.floor(30*Math.random());
    
    function pad(n) {
        var r = n.toString();
        while (r.length < 2) {
            r = "0" + r;
        }
        return r;
    }
        
    loadJson(
    	solrUrl(
    		"twitter",
    		{
    			q: "created_at:(*\\:*\\:"
    				+ pad(t)
    				+ "* OR *\\:*\\:"
    				+ (30+t)
    				+ "*)",
    			group: "true",
    			"group.field": "created_at",
    			"fl": "id_str,created_at,from_user_name,text,profile_image_url,from_user_id",
    			"rows": 800
    		}
		),
		"randomtweets",
		function(d) {
			var randtweets = d.grouped.created_at.groups.map(function(g) {
				var tweet = g.doclist.docs[0];
				return {
					topic: { topic: -1, weight: 0 },
					timestamp: (new Date(tweet.created_at).valueOf() / 1000 - deltaT),
					data: tweet
				}
			});
			randtweets.sort(function(a,b) {
				return a.timestamp - b.timestamp;
			});
			return randtweets;
		}
    )
    
    loadJson("data/topiclabels.json", "topiclabels");
    
    loadJson(
        solrUrl("MMSO", {q: "*:*", fl: "topic*,MMSO_id,multimediaSegment,keywordsFromSocial", rows: 250 }),
        "segments",
        function(d) {
            return d.response.docs.map(function(mmso) {
                var tc = mmso.multimediaSegment.match(/\d+/g),
                    start = parseInt(tc[0]),
                    end = parseInt(tc[1]),
                    topics = [],
                    keywords = {};
                
                function getKeywords(field) {
                	var keywordtexts = mmso[field].replace(/[{}]/g,'').split(", ");
	                keywordtexts.forEach(function(k) {
	                	var t = k.split('='),
	                		s = parseFloat(t[1]),
	                		w = t[0].split(" ");
	            		w.forEach(function(m) {
	            			if (m.length > 2) {
	            				keywords[m] = s + (keywords[m] || 0);
	            			}
	            		});
	                });
                }
                
                //getKeywords("keywordsFromAudio");
                getKeywords("keywordsFromSocial");
                
                for (var k in mmso) {
                    if (k.substr(0,5) === "topic" && mmso[k] > .01) {
                        topics.push({
                            topic: parseInt(k.substr(5)),
                            weight: mmso[k]
                        })
                    }
                }
                topics.sort(function(a,b) {
                    return b.weight - a.weight;
                });

                return {
                    id: mmso.MMSO_id,
                    start: start,
                    end: end,
                    duration: end - start,
                    topics: topics,
                    keywords: keywords
                }
            }).sort(function(a,b) {
                return a.start - b.start;
            });
        })
    
    dwr.engine.setTimeout(60000);
    TopicsBean._path = "http://159.217.144.101:8050/sia-solr/dwr";
    
    loadFromTopicsBean("getTopicsNumber",false,false,function(topic_count) {
        for (var i = 0; i < topic_count; i++) {
            data.topics.push({ index: i, words: [ { word: "(no label)", weight: 1 }] });
        }
    });
    
    
});
