$(function() {
    
    var colorset = ["#1f77b4 ", "#aec7e8 ", "#ff7f0e ", "#ffbb78 ", "#2ca02c ", "#98df8a ", "#d62728 ", "#ff9896 ", "#9467bd ", "#c5b0d5 ", "#8c564b ", "#c49c94 ", "#e377c2 ", "#f7b6d2 ", "#7f7f7f ", "#c7c7c7 ", "#bcbd22 ", "#dbdb8d ", "#17becf ", "#9edae5"]
    
    $.getJSON("fakedata/data.json", function(data) {
        $(".topwords-block").html(data.top_words.reduce(function(mem, d) {
            return mem + '<li>' + d.word + '</li>'
        },""));
        
        var nmmso = data.segments.length;
        
        data.topics.forEach(function(topic) {
            topic.score = 0;
            topic.curve = [];
            for (var i = 0; i < nmmso; i++) {
                topic.curve.push(0);
            }
        });
        
        data.segments.forEach(function(mmso, i) {
            mmso.topics.forEach(function(t) {
                var score = t.weight * mmso.tweet_count;
                data.topics[t.topic].curve[i] = score;
                data.topics[t.topic].score += score;
            });
        });
        
        data.topics = data.topics.sort(function(a,b) {
            return b.score - a.score;
        });
        
        var topicHtmls = ["", "", ""]
        
        data.topics.forEach(function(topic,i) {
            var li = '<li class="shadow-block topic" style="background:'
                + colorset[topic.index % colorset.length]
                + '" data-topic-id="'
                + topic.index
                + '"><ul class="topic-words">'
                + topic.words.reduce(function(memwords, word) {
                    return memwords + '<li>' + word.word + '</li>';
                },"")
                + '</ul></li>';
            topicHtmls[i % 3] += li;
        });
        console.log(topicHtmls);
        $(".topics-block").html(topicHtmls.reduce(function(mem,html) {
           return mem + '<ul class="topic-column">' + html + '</ul>' 
        },""));
        
        $(".topic").mouseenter(function() {
            var datavizheight = $(".start-dataviz").height(),
                scale = datavizheight / data.duration,
                topicid = parseInt($(this).attr("data-topic-id")),
                topic;
            for (var i = 0; i < data.topics.length; i++) {
                if (data.topics[i].index == topicid) {
                    topic = data.topics[i];
                    break;
                }
            }
            if (!topic) {
                return;
            }
            var color = colorset[topicid % colorset.length];
            $(".start-dataviz").html(topic.curve.reduce(function(mem, c, i) {
                if (!c) {
                    return mem;
                } else {
                    var mmso = data.segments[i];
                    return mem + '<div style="position: absolute; background: '
                        + color
                        +'; opacity: '
                        + c
                        +'; left: 0; ; top: '
                        + scale * mmso.start
                        +'px; height: '
                        + scale * mmso.duration
                        +'px; width: 266px"></div>'
                }
            },""));
        })//.mouseleave(function() {$(".start-dataviz").empty(); });
        
    });
});
