/*
 * $Id: film.h 108 2007-02-15 11:37:39Z johmathe $
 * $Date: 2007-02-15 12:37:39 +0100 (jeu, 15 fv 2007) $
 */

#ifndef __FILM_H__
#define __FILM_H__

#include <stdio.h>
#include <stdlib.h>
#include <list>
#include <ffmpeg/avcodec.h>
#include <ffmpeg/avformat.h>

#ifdef BDD
#include <postgresql/libpq-fe.h>
#endif
#include <wx/wx.h>

#include "image.h"
#include "shot.h"
#include "xml.h"
#include "graph.h"

#include <string>
#include <iostream>

#define MAX_STR 254
#define MAX_CUTS 200
#define abs(x) ((x) < 0 ? - (x) : (x))
#define HAVE_THREADS
#define MAX_QUERY 400

#define DEFAULT_BDD_PORT 5432
#define DEFAULT_THUMB_HEIGHT 85

using namespace std;

class image;
class conf;
class shot;
class xml;
class DialogShotDetect_c;
class graph;
class film
{

private:

  void do_stats (int frame, AVFormatContext * ic);	//, wxWindow *dialogParent);
  void CompareFrame (AVFrame * pFrame, AVFrame * pFramePrev, int width,
		     int height, int i);
  graph *g;
public:
  DialogShotDetect_c *dialogParent;
  struct
  {
    int id;
    string name;
    string surname;
  } author;

  struct
  {
    string video;
    string audio;
  }codec;

  struct
  {
      int hours;
      int mins;
      int  secs;
      int  us;
      int mstotal;
  }duration;

  int myid;
  static int idfilm;

  int progress_state_prev;
  /* Nom du film */
  string film_name;
  /* Title of the movie */
  string title;
  /* Abstract of the movie */
  string abstract;
  /* Path to the film */
  string path;
  /* Film height */
  int height;
  /* Film width */
  int width;
  /* Film fps */
  double fps;
  /* Number of audio chanels */
  int nchannel;
  /* Year of the movie */
  int year;
 /* Shots */
  list < shot > shots;
  /* Prev Score in compare_frame */
  int prev_score;
  /* ID BDD Film */
  int id;
  /* id du plan en cours de traitement */
  int id_plan;
  /* Code de la langue */
  string code_lang;
  /* Seuil de traitement */
  int threseold;
  /* Id alphanumrique du film */
  string alphaid;
  /* Chemin absolu */
  string global_path;
   /* Percent accomplished */
  double percent;
  /* Showing state started */
  bool show_started;
  xml *x;
  int process ();
  bool display;
  /* Constructeur */
  film (DialogShotDetect_c *);
  film ();
};


#endif /* !__FILM_H__ */
