/* Copyright (C) 2007 Johan MATHE - johan.mathe@tremplin-utc.net -  Centre Pompidou - IRI 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * $Id: main.cpp 142 2007-04-02 16:18:49Z johmathe $
 */

#include <wx/wx.h>
#include <wx/image.h>
#include "DialogShotDetect_c.h"
#include <wx/cmdline.h>
#include <film.h>
#include <stdlib.h>
#include <xml.h>

class xml;
class film;

class ShotApp:public wxApp
{
public:
  virtual bool OnInit ();

};

IMPLEMENT_APP_NO_MAIN (ShotApp)

bool ShotApp::OnInit ()
{
	DialogShotDetect_c *DialogShotDetect =
	new DialogShotDetect_c (0, -1, wxT (""));
	SetTopWindow (DialogShotDetect);
	DialogShotDetect->Show ();
}

void show_help (char **argv)
{
  printf
    ("usage: %s \n"
     "Shotdetect (IRI - johmathe - $Id: main.cpp 142 2007-04-02 16:18:49Z johmathe $)\n"
     "-n 	: 	Mode ligne de commande", argv[0] );
}



int
main (int argc, char **argv)
{
	bool gui = true;
	bool ifile_set = false;
	bool ofile_set = false;
    bool id_set = false;
    bool xsl_path_set = false;
	string title = "Not set";
	string year  = "Not set";
	string input_file = "Not set";
	string output_path = "Not set";
    string id_film = "Not set";
    string xsl_path = "Not set";
	extern char *optarg;
	extern int optind, opterr, optopt;

	
	for (;;)
	{
		int c  = getopt (argc, argv, "?hnt:y:i:o:a:x:");

        if(c < 0)
        {
        break;
        }

		switch (c)
		{
		case '?':
		case 'h':
		show_help(argv);
		exit(EXIT_SUCCESS);
		break;
        
        case 'a':
        id_film = optarg;
        id_set = true;
        break;
        	
        case 'x':
        xsl_path = optarg;
        xsl_path_set =true;
        break;

		case 'n':
		gui = false;
		break;
			
		/* Recuperation du titre */
		case 't':
		title = optarg;
		break;
	
		/* Recuperation de l'annee */
		case 'y':
		year = optarg;
		break;
	
		case 'i':
		input_file = optarg;
		ifile_set = true;
		break;
	
		case 'o':
		output_path = optarg;
		ofile_set = true;
		break;
        
		default:
		break;
		}
	
	}

	if (!gui)
	{
           /* Traitement des erreurs */
        if(!ifile_set || !ofile_set || !id_set ||!xsl_path_set)
       {
            if(!ifile_set) perror("please spec an input file");
            if(!ofile_set)  perror("please spec an output path");
            if(!id_set) perror("please spec an alphanumeric id");
            if(!xsl_path_set) perror("please spec an xsl path");
            exit(EXIT_FAILURE);
        }

		film f = film ();
		xml *x = new xml (&f);
		x->set_xsl_path(xsl_path);


    /* extraction du nom de la feuille de style sans l'extension */
      #ifdef __WINDOWS__
      x->xsl_name.assign (x->xsl_path, x->xsl_path.rfind ("\\") + 1,
              x->xsl_path.rfind (".") - x->xsl_path.rfind ("\\") -
              1);
      #else
            x->xsl_name.assign (x->xsl_path, x->xsl_path.rfind ("/") + 1,
              x->xsl_path.rfind (".") - x->xsl_path.rfind ("/") -
              1);
      #endif

        f.x = x;
		
		f.set_file(input_file);
		f.set_alphaid(id_film);
		f.set_output_path(output_path);
		f.process ();
		
		string xml_path = f.alphaid;
		xml_path += "_";
		xml_path += f.x->xsl_name;
		xml_path += ".xml";
		
		string xml_own_path = f.alphaid;
		xml_own_path += ".xml";
		f.x->write_data (xml_own_path);
		f.x->apply_xsl (xml_path);
	}
	else
	{
	wxEntry (argc, argv);
	return true;
	}
  exit (0);
}
