<?php
/*
Plugin Name: Pikslider
Plugin URI: http://iri.centrepompidou.fr/
Description: Carousel slideshow pour la home du site de l'Iri, taille d'une image 568x300
Version: 0.1
Author: Anthony Ly
Author URI: http://anthonyly.com
*/

add_action('init', 'pikslider_init');
add_action('add_meta_boxes','pikslider_metaboxes');
add_action('save_post','pikslider_savepost', 10, 2);
add_action('manage_edit-slide_columns', 'pikslider_columnfilter');
add_action('manage_posts_custom_column', 'pikslider_column');

/**
* Initialise le carousel
**/
function pikslider_init(){

	$labels = array(
		'name'=>'Slide',
		'singular_name'=>'Slide',
		'add_new'=>'Ajouter une slide',
		'add_new_item'=>'Ajouter une slide',
		'edit_item'=>'Editer unde slide',
		'new_item'=>'Nouveau',
		'view_item'=>'Voir la slide',
		'search_items'=>'Rechercher une slide',
		'not_found'=>'Aucun slide',
		'not_found_in_trash'=>'Aucune slide dans la corbeille',
		'parent_item_colon'=>'',
		'menu_name'=>'Slides'
	);

	register_post_type('slide', array(
		'public' => true,
		'publicly_queryable'=>false,
		'labels'	=> $labels,
		'capability_type'=>'post',
		'supports'=>array('title','editor', 'thumbnail')
	));

	add_image_size('slider',568,300,true);
}
	
function pikslider_columnfilter($columns){
	$thumb = array('thumbnail'=>'Image');
	$columns = 
		array_slice($columns,0,1) +
		$thumb +
		array_slice($columns,1,null);
	return $columns;
}

function pikslider_column($column){
	global $post;
	if($column == 'thumbnail'){
		edit_post_link(get_the_post_thumbnail($post->ID),'','');
	}
}

/**
* Permet de gérer les métaboxes
**/
function pikslider_metaboxes(){

	add_meta_box('pikslider','Lien','pikslider_metaboxe','slide','normal','high');
}

function pikslider_metaboxe($object){
	wp_nonce_field('pikslider','pikslider_nonce');
	?>
	<div class="meta-box-item-title">
		<h4>Lien du slide</h4>
	</div>
	<div class="meta-box-item-content">
		<input type="text" name="pikslider_link" style="width:100%" value="<?php echo esc_attr(get_post_meta($object->ID, '_link', true)); ?>" />
	</div>
	<?php
}

function pikslider_savepost($post_id, $post){

	if(!isset($_POST['pikslider_link']) || !wp_verify_nonce($_POST['pikslider_nonce'],'pikslider')){
		return $post_id;
	}

	$type = get_post_type_object($post->post_type);
	if(!current_user_can($type->cap->edit_post)){
		return $post_id;
	}

	update_post_meta($post_id,'_link',$_POST['pikslider_link']);
}


/**
* Permet d'afficher le carousel
**/
function pikslider_show(){
	//import du javascript
	wp_enqueue_script(
		'caroufredsel', 
		plugins_url().'/pik-slider/js/jquery.carouFredSel-6.1.0-packed.js',
		array('jquery'), 
		'6.1.0', 
		true 
	);
	wp_enqueue_style(
		'pikslider_style', 
		plugins_url().'/pik-slider/css/pikslider-style.css',
		null, 
		'1.0', 
		'screen' 
	);
	
	add_action('wp_footer','pikslider_script',30);
	// HTML
	$slides = new WP_query('post_type=slide&posts_per_page=100');
	?>
	<div id="pikslider">
       	<ul>
	<?php
	while($slides->have_posts()){
		$slides->the_post();
		global $post;
		//détection de la langue
		if (class_exists('xili_language')) {
			$current_lang = the_cur_lang_dir();
			if (get_cur_language($post->ID)!=$current_lang['lang']){continue;}
		}
		$url = get_post_meta($post->ID, '_link', true);
		$blank = false;
		if (preg_match("/^http:\/{2}/",$url)){
		    $blank = true;
		}
		?>
		<li><a <?php if($blank){echo 'target="_blank"';}?> href="<?php echo $url; ?>">
            <?php the_post_thumbnail('slider'); ?>
            <div class="pikslider-content">
                <h2><?php echo the_title(); ?></h2>
                <?php echo the_content(); ?>
            </div>
        </a></li>
		<?php
	}
	?>
		</ul>
        <a id="pikslider-prev" href="#"></a>
        <a id="pikslider-next" href="#"></a>
    </div>
    <?php
}

function pikslider_script(){
	?>
	<script type="text/javascript">
		(function($){
			$('#pikslider ul').carouFredSel({
				prev: '#pikslider-prev',
    			next: '#pikslider-next',
    			auto : { pauseOnHover: "resume"},
                scroll: 1000  
			});
			$('#pikslider .caroufredsel_wrapper').css("margin",0);
		})(jQuery);
	</script>
	<?php
}