﻿--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: access; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE access (
    aid integer NOT NULL,
    mask character varying(255) DEFAULT ''::character varying NOT NULL,
    type character varying(255) DEFAULT ''::character varying NOT NULL,
    status smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.access OWNER TO postgres;

--
-- Name: actions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE actions (
    aid character varying(255) DEFAULT '0'::character varying NOT NULL,
    type character varying(32) DEFAULT ''::character varying NOT NULL,
    callback character varying(255) DEFAULT ''::character varying NOT NULL,
    parameters text NOT NULL,
    description character varying(255) DEFAULT '0'::character varying NOT NULL
);


ALTER TABLE public.actions OWNER TO postgres;

--
-- Name: actions_aid; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE actions_aid (
    aid integer NOT NULL,
    CONSTRAINT actions_aid_aid_check CHECK ((aid >= 0))
);


ALTER TABLE public.actions_aid OWNER TO postgres;

--
-- Name: authmap; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE authmap (
    aid integer NOT NULL,
    uid integer DEFAULT 0 NOT NULL,
    authname character varying(128) DEFAULT ''::character varying NOT NULL,
    module character varying(128) DEFAULT ''::character varying NOT NULL,
    CONSTRAINT authmap_aid_check CHECK ((aid >= 0))
);


ALTER TABLE public.authmap OWNER TO postgres;

--
-- Name: batch; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE batch (
    bid integer NOT NULL,
    token character varying(64) NOT NULL,
    "timestamp" integer NOT NULL,
    batch text,
    CONSTRAINT batch_bid_check CHECK ((bid >= 0))
);


ALTER TABLE public.batch OWNER TO postgres;

--
-- Name: blocks; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE blocks (
    bid integer NOT NULL,
    module character varying(64) DEFAULT ''::character varying NOT NULL,
    delta character varying(32) DEFAULT '0'::character varying NOT NULL,
    theme character varying(64) DEFAULT ''::character varying NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    weight smallint DEFAULT 0 NOT NULL,
    region character varying(64) DEFAULT ''::character varying NOT NULL,
    custom smallint DEFAULT 0 NOT NULL,
    throttle smallint DEFAULT 0 NOT NULL,
    visibility smallint DEFAULT 0 NOT NULL,
    pages text NOT NULL,
    title character varying(64) DEFAULT ''::character varying NOT NULL,
    cache smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.blocks OWNER TO postgres;

--
-- Name: int_unsigned; Type: DOMAIN; Schema: public; Owner: postgres
--

CREATE DOMAIN int_unsigned AS integer
	CONSTRAINT int_unsigned_check CHECK ((VALUE >= 0));


ALTER DOMAIN public.int_unsigned OWNER TO postgres;

--
-- Name: blocks_roles; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE blocks_roles (
    module character varying(64) NOT NULL,
    delta character varying(32) NOT NULL,
    rid int_unsigned NOT NULL
);


ALTER TABLE public.blocks_roles OWNER TO postgres;

--
-- Name: boxes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE boxes (
    bid integer NOT NULL,
    body text,
    info character varying(128) DEFAULT ''::character varying NOT NULL,
    format smallint DEFAULT 0 NOT NULL,
    CONSTRAINT boxes_bid_check CHECK ((bid >= 0))
);


ALTER TABLE public.boxes OWNER TO postgres;

--
-- Name: cache; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cache (
    cid character varying(255) DEFAULT ''::character varying NOT NULL,
    data bytea,
    expire integer DEFAULT 0 NOT NULL,
    created integer DEFAULT 0 NOT NULL,
    headers text,
    serialized smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.cache OWNER TO postgres;

--
-- Name: cache_block; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cache_block (
    cid character varying(255) DEFAULT ''::character varying NOT NULL,
    data bytea,
    expire integer DEFAULT 0 NOT NULL,
    created integer DEFAULT 0 NOT NULL,
    headers text,
    serialized smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.cache_block OWNER TO postgres;

--
-- Name: cache_filter; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cache_filter (
    cid character varying(255) DEFAULT ''::character varying NOT NULL,
    data bytea,
    expire integer DEFAULT 0 NOT NULL,
    created integer DEFAULT 0 NOT NULL,
    headers text,
    serialized smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.cache_filter OWNER TO postgres;

--
-- Name: cache_form; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cache_form (
    cid character varying(255) DEFAULT ''::character varying NOT NULL,
    data bytea,
    expire integer DEFAULT 0 NOT NULL,
    created integer DEFAULT 0 NOT NULL,
    headers text,
    serialized smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.cache_form OWNER TO postgres;

--
-- Name: cache_menu; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cache_menu (
    cid character varying(255) DEFAULT ''::character varying NOT NULL,
    data bytea,
    expire integer DEFAULT 0 NOT NULL,
    created integer DEFAULT 0 NOT NULL,
    headers text,
    serialized smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.cache_menu OWNER TO postgres;

--
-- Name: cache_page; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cache_page (
    cid character varying(255) DEFAULT ''::character varying NOT NULL,
    data bytea,
    expire integer DEFAULT 0 NOT NULL,
    created integer DEFAULT 0 NOT NULL,
    headers text,
    serialized smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.cache_page OWNER TO postgres;

--
-- Name: cache_update; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cache_update (
    cid character varying(255) DEFAULT ''::character varying NOT NULL,
    data bytea,
    expire integer DEFAULT 0 NOT NULL,
    created integer DEFAULT 0 NOT NULL,
    headers text,
    serialized smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.cache_update OWNER TO postgres;

--
-- Name: smallint_unsigned; Type: DOMAIN; Schema: public; Owner: postgres
--

CREATE DOMAIN smallint_unsigned AS smallint
	CONSTRAINT smallint_unsigned_check CHECK ((VALUE >= 0));


ALTER DOMAIN public.smallint_unsigned OWNER TO postgres;

--
-- Name: comments; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE comments (
    cid integer NOT NULL,
    pid integer DEFAULT 0 NOT NULL,
    nid integer DEFAULT 0 NOT NULL,
    uid integer DEFAULT 0 NOT NULL,
    subject character varying(64) DEFAULT ''::character varying NOT NULL,
    comment text NOT NULL,
    hostname character varying(128) DEFAULT ''::character varying NOT NULL,
    "timestamp" integer DEFAULT 0 NOT NULL,
    status smallint_unsigned DEFAULT 0 NOT NULL,
    format smallint DEFAULT 0 NOT NULL,
    thread character varying(255) NOT NULL,
    name character varying(60),
    mail character varying(64),
    homepage character varying(255)
);


ALTER TABLE public.comments OWNER TO postgres;

--
-- Name: fckeditor_role; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE fckeditor_role (
    name character varying(128) DEFAULT ''::character varying NOT NULL,
    rid integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.fckeditor_role OWNER TO postgres;

--
-- Name: fckeditor_settings; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE fckeditor_settings (
    name character varying(128) DEFAULT ''::character varying NOT NULL,
    settings text
);


ALTER TABLE public.fckeditor_settings OWNER TO postgres;

--
-- Name: files; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE files (
    fid integer NOT NULL,
    uid int_unsigned DEFAULT 0 NOT NULL,
    filename character varying(255) DEFAULT ''::character varying NOT NULL,
    filepath character varying(255) DEFAULT ''::character varying NOT NULL,
    filemime character varying(255) DEFAULT ''::character varying NOT NULL,
    filesize int_unsigned DEFAULT 0 NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    "timestamp" int_unsigned DEFAULT 0 NOT NULL,
    CONSTRAINT files_fid_check CHECK ((fid >= 0))
);


ALTER TABLE public.files OWNER TO postgres;

--
-- Name: filter_formats; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE filter_formats (
    format integer NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    roles character varying(255) DEFAULT ''::character varying NOT NULL,
    cache smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.filter_formats OWNER TO postgres;

--
-- Name: filters; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE filters (
    fid integer NOT NULL,
    format integer DEFAULT 0 NOT NULL,
    module character varying(64) DEFAULT ''::character varying NOT NULL,
    delta smallint DEFAULT 0 NOT NULL,
    weight smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.filters OWNER TO postgres;

--
-- Name: flood; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE flood (
    fid integer NOT NULL,
    event character varying(64) DEFAULT ''::character varying NOT NULL,
    hostname character varying(128) DEFAULT ''::character varying NOT NULL,
    "timestamp" integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.flood OWNER TO postgres;

--
-- Name: history; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE history (
    uid integer DEFAULT 0 NOT NULL,
    nid integer DEFAULT 0 NOT NULL,
    "timestamp" integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.history OWNER TO postgres;

--
-- Name: languages; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE languages (
    language character varying(12) DEFAULT ''::character varying NOT NULL,
    name character varying(64) DEFAULT ''::character varying NOT NULL,
    native character varying(64) DEFAULT ''::character varying NOT NULL,
    direction integer DEFAULT 0 NOT NULL,
    enabled integer DEFAULT 0 NOT NULL,
    plurals integer DEFAULT 0 NOT NULL,
    formula character varying(128) DEFAULT ''::character varying NOT NULL,
    domain character varying(128) DEFAULT ''::character varying NOT NULL,
    prefix character varying(128) DEFAULT ''::character varying NOT NULL,
    weight integer DEFAULT 0 NOT NULL,
    javascript character varying(32) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.languages OWNER TO postgres;

--
-- Name: locales_source; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE locales_source (
    lid integer NOT NULL,
    location character varying(255) DEFAULT ''::character varying NOT NULL,
    textgroup character varying(255) DEFAULT 'default'::character varying NOT NULL,
    source text NOT NULL,
    version character varying(20) DEFAULT 'none'::character varying NOT NULL
);


ALTER TABLE public.locales_source OWNER TO postgres;

--
-- Name: locales_target; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE locales_target (
    lid integer DEFAULT 0 NOT NULL,
    translation text NOT NULL,
    language character varying(12) DEFAULT ''::character varying NOT NULL,
    plid integer DEFAULT 0 NOT NULL,
    plural integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.locales_target OWNER TO postgres;

--
-- Name: menu_custom; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE menu_custom (
    menu_name character varying(32) DEFAULT ''::character varying NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    description text
);


ALTER TABLE public.menu_custom OWNER TO postgres;

--
-- Name: menu_links; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE menu_links (
    menu_name character varying(32) DEFAULT ''::character varying NOT NULL,
    mlid integer NOT NULL,
    plid int_unsigned DEFAULT 0 NOT NULL,
    link_path character varying(255) DEFAULT ''::character varying NOT NULL,
    router_path character varying(255) DEFAULT ''::character varying NOT NULL,
    link_title character varying(255) DEFAULT ''::character varying NOT NULL,
    options text,
    module character varying(255) DEFAULT 'system'::character varying NOT NULL,
    hidden smallint DEFAULT 0 NOT NULL,
    external smallint DEFAULT 0 NOT NULL,
    has_children smallint DEFAULT 0 NOT NULL,
    expanded smallint DEFAULT 0 NOT NULL,
    weight integer DEFAULT 0 NOT NULL,
    depth smallint DEFAULT 0 NOT NULL,
    customized smallint DEFAULT 0 NOT NULL,
    p1 int_unsigned DEFAULT 0 NOT NULL,
    p2 int_unsigned DEFAULT 0 NOT NULL,
    p3 int_unsigned DEFAULT 0 NOT NULL,
    p4 int_unsigned DEFAULT 0 NOT NULL,
    p5 int_unsigned DEFAULT 0 NOT NULL,
    p6 int_unsigned DEFAULT 0 NOT NULL,
    p7 int_unsigned DEFAULT 0 NOT NULL,
    p8 int_unsigned DEFAULT 0 NOT NULL,
    p9 int_unsigned DEFAULT 0 NOT NULL,
    updated smallint DEFAULT 0 NOT NULL,
    CONSTRAINT menu_links_mlid_check CHECK ((mlid >= 0))
);


ALTER TABLE public.menu_links OWNER TO postgres;

--
-- Name: menu_router; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE menu_router (
    path character varying(255) DEFAULT ''::character varying NOT NULL,
    load_functions text NOT NULL,
    to_arg_functions text NOT NULL,
    access_callback character varying(255) DEFAULT ''::character varying NOT NULL,
    access_arguments text,
    page_callback character varying(255) DEFAULT ''::character varying NOT NULL,
    page_arguments text,
    fit integer DEFAULT 0 NOT NULL,
    number_parts smallint DEFAULT 0 NOT NULL,
    tab_parent character varying(255) DEFAULT ''::character varying NOT NULL,
    tab_root character varying(255) DEFAULT ''::character varying NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    title_callback character varying(255) DEFAULT ''::character varying NOT NULL,
    title_arguments character varying(255) DEFAULT ''::character varying NOT NULL,
    type integer DEFAULT 0 NOT NULL,
    block_callback character varying(255) DEFAULT ''::character varying NOT NULL,
    description text NOT NULL,
    "position" character varying(255) DEFAULT ''::character varying NOT NULL,
    weight integer DEFAULT 0 NOT NULL,
    file text
);


ALTER TABLE public.menu_router OWNER TO postgres;

--
-- Name: node; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE node (
    nid integer NOT NULL,
    vid int_unsigned DEFAULT 0 NOT NULL,
    type character varying(32) DEFAULT ''::character varying NOT NULL,
    language character varying(12) DEFAULT ''::character varying NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    uid integer DEFAULT 0 NOT NULL,
    status integer DEFAULT 1 NOT NULL,
    created integer DEFAULT 0 NOT NULL,
    changed integer DEFAULT 0 NOT NULL,
    comment integer DEFAULT 0 NOT NULL,
    promote integer DEFAULT 0 NOT NULL,
    moderate integer DEFAULT 0 NOT NULL,
    sticky integer DEFAULT 0 NOT NULL,
    tnid int_unsigned DEFAULT 0 NOT NULL,
    translate integer DEFAULT 0 NOT NULL,
    CONSTRAINT node_nid_check CHECK ((nid >= 0))
);


ALTER TABLE public.node OWNER TO postgres;

--
-- Name: node_access; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE node_access (
    nid int_unsigned DEFAULT 0 NOT NULL,
    gid int_unsigned DEFAULT 0 NOT NULL,
    realm character varying(255) DEFAULT ''::character varying NOT NULL,
    grant_view smallint_unsigned DEFAULT 0 NOT NULL,
    grant_update smallint_unsigned DEFAULT 0 NOT NULL,
    grant_delete smallint_unsigned DEFAULT 0 NOT NULL
);


ALTER TABLE public.node_access OWNER TO postgres;

--
-- Name: node_comment_statistics; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE node_comment_statistics (
    nid int_unsigned DEFAULT 0 NOT NULL,
    last_comment_timestamp integer DEFAULT 0 NOT NULL,
    last_comment_name character varying(60),
    last_comment_uid integer DEFAULT 0 NOT NULL,
    comment_count int_unsigned DEFAULT 0 NOT NULL
);


ALTER TABLE public.node_comment_statistics OWNER TO postgres;

--
-- Name: bigint_unsigned; Type: DOMAIN; Schema: public; Owner: postgres
--

CREATE DOMAIN bigint_unsigned AS bigint
	CONSTRAINT bigint_unsigned_check CHECK ((VALUE >= 0));


ALTER DOMAIN public.bigint_unsigned OWNER TO postgres;

--
-- Name: node_counter; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE node_counter (
    nid integer DEFAULT 0 NOT NULL,
    totalcount bigint_unsigned DEFAULT 0 NOT NULL,
    daycount int_unsigned DEFAULT 0 NOT NULL,
    "timestamp" int_unsigned DEFAULT 0 NOT NULL
);


ALTER TABLE public.node_counter OWNER TO postgres;

--
-- Name: node_revisions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE node_revisions (
    nid int_unsigned DEFAULT 0 NOT NULL,
    vid integer NOT NULL,
    uid integer DEFAULT 0 NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    body text NOT NULL,
    teaser text NOT NULL,
    log text NOT NULL,
    "timestamp" integer DEFAULT 0 NOT NULL,
    format integer DEFAULT 0 NOT NULL,
    CONSTRAINT node_revisions_vid_check CHECK ((vid >= 0))
);


ALTER TABLE public.node_revisions OWNER TO postgres;

--
-- Name: node_type; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE node_type (
    type character varying(32) NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    module character varying(255) NOT NULL,
    description text NOT NULL,
    help text NOT NULL,
    has_title smallint_unsigned NOT NULL,
    title_label character varying(255) DEFAULT ''::character varying NOT NULL,
    has_body smallint_unsigned NOT NULL,
    body_label character varying(255) DEFAULT ''::character varying NOT NULL,
    min_word_count smallint_unsigned NOT NULL,
    custom smallint DEFAULT 0 NOT NULL,
    modified smallint DEFAULT 0 NOT NULL,
    locked smallint DEFAULT 0 NOT NULL,
    orig_type character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.node_type OWNER TO postgres;

--
-- Name: permission; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE permission (
    pid integer NOT NULL,
    rid int_unsigned DEFAULT 0 NOT NULL,
    perm text,
    tid int_unsigned DEFAULT 0 NOT NULL
);


ALTER TABLE public.permission OWNER TO postgres;

--
-- Name: role; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE role (
    rid integer NOT NULL,
    name character varying(64) DEFAULT ''::character varying NOT NULL,
    CONSTRAINT role_rid_check CHECK ((rid >= 0))
);


ALTER TABLE public.role OWNER TO postgres;

--
-- Name: search_dataset; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE search_dataset (
    sid int_unsigned DEFAULT 0 NOT NULL,
    type character varying(16),
    data text NOT NULL,
    reindex int_unsigned DEFAULT 0 NOT NULL
);


ALTER TABLE public.search_dataset OWNER TO postgres;

--
-- Name: search_index; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE search_index (
    word character varying(50) DEFAULT ''::character varying NOT NULL,
    sid int_unsigned DEFAULT 0 NOT NULL,
    type character varying(16),
    score real
);


ALTER TABLE public.search_index OWNER TO postgres;

--
-- Name: search_node_links; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE search_node_links (
    sid int_unsigned DEFAULT 0 NOT NULL,
    type character varying(16) DEFAULT ''::character varying NOT NULL,
    nid int_unsigned DEFAULT 0 NOT NULL,
    caption text
);


ALTER TABLE public.search_node_links OWNER TO postgres;

--
-- Name: search_total; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE search_total (
    word character varying(50) DEFAULT ''::character varying NOT NULL,
    count real
);


ALTER TABLE public.search_total OWNER TO postgres;

--
-- Name: sessions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE sessions (
    uid int_unsigned NOT NULL,
    sid character varying(64) DEFAULT ''::character varying NOT NULL,
    hostname character varying(128) DEFAULT ''::character varying NOT NULL,
    "timestamp" integer DEFAULT 0 NOT NULL,
    cache integer DEFAULT 0 NOT NULL,
    session text
);


ALTER TABLE public.sessions OWNER TO postgres;

--
-- Name: system; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE system (
    filename character varying(255) DEFAULT ''::character varying NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    type character varying(255) DEFAULT ''::character varying NOT NULL,
    owner character varying(255) DEFAULT ''::character varying NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    throttle smallint DEFAULT 0 NOT NULL,
    bootstrap integer DEFAULT 0 NOT NULL,
    schema_version smallint DEFAULT (-1) NOT NULL,
    weight integer DEFAULT 0 NOT NULL,
    info text
);


ALTER TABLE public.system OWNER TO postgres;

--
-- Name: term_data; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE term_data (
    tid integer NOT NULL,
    vid int_unsigned DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    weight smallint DEFAULT 0 NOT NULL,
    CONSTRAINT term_data_tid_check CHECK ((tid >= 0))
);


ALTER TABLE public.term_data OWNER TO postgres;

--
-- Name: term_hierarchy; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE term_hierarchy (
    tid int_unsigned DEFAULT 0 NOT NULL,
    parent int_unsigned DEFAULT 0 NOT NULL
);


ALTER TABLE public.term_hierarchy OWNER TO postgres;

--
-- Name: term_node; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE term_node (
    nid int_unsigned DEFAULT 0 NOT NULL,
    vid int_unsigned DEFAULT 0 NOT NULL,
    tid int_unsigned DEFAULT 0 NOT NULL
);


ALTER TABLE public.term_node OWNER TO postgres;

--
-- Name: term_relation; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE term_relation (
    trid integer NOT NULL,
    tid1 int_unsigned DEFAULT 0 NOT NULL,
    tid2 int_unsigned DEFAULT 0 NOT NULL
);


ALTER TABLE public.term_relation OWNER TO postgres;

--
-- Name: term_synonym; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE term_synonym (
    tsid integer NOT NULL,
    tid int_unsigned DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.term_synonym OWNER TO postgres;

--
-- Name: url_alias; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE url_alias (
    pid integer NOT NULL,
    src character varying(128) DEFAULT ''::character varying NOT NULL,
    dst character varying(128) DEFAULT ''::character varying NOT NULL,
    language character varying(12) DEFAULT ''::character varying NOT NULL,
    CONSTRAINT url_alias_pid_check CHECK ((pid >= 0))
);


ALTER TABLE public.url_alias OWNER TO postgres;

--
-- Name: users; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE users (
    uid integer NOT NULL,
    name character varying(60) DEFAULT ''::character varying NOT NULL,
    pass character varying(32) DEFAULT ''::character varying NOT NULL,
    mail character varying(64) DEFAULT ''::character varying,
    mode smallint DEFAULT 0 NOT NULL,
    sort smallint DEFAULT 0,
    threshold smallint DEFAULT 0,
    theme character varying(255) DEFAULT ''::character varying NOT NULL,
    signature character varying(255) DEFAULT ''::character varying NOT NULL,
    signature_format smallint DEFAULT 0 NOT NULL,
    created integer DEFAULT 0 NOT NULL,
    access integer DEFAULT 0 NOT NULL,
    login integer DEFAULT 0 NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    timezone character varying(8),
    language character varying(12) DEFAULT ''::character varying NOT NULL,
    picture character varying(255) DEFAULT ''::character varying NOT NULL,
    init character varying(64) DEFAULT ''::character varying,
    data text,
    CONSTRAINT users_uid_check CHECK ((uid >= 0))
);


ALTER TABLE public.users OWNER TO postgres;

--
-- Name: users_roles; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE users_roles (
    uid int_unsigned DEFAULT 0 NOT NULL,
    rid int_unsigned DEFAULT 0 NOT NULL
);


ALTER TABLE public.users_roles OWNER TO postgres;

--
-- Name: variable; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE variable (
    name character varying(128) DEFAULT ''::character varying NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.variable OWNER TO postgres;

--
-- Name: vocabulary; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vocabulary (
    vid integer NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    help character varying(255) DEFAULT ''::character varying NOT NULL,
    relations smallint_unsigned DEFAULT 0 NOT NULL,
    hierarchy smallint_unsigned DEFAULT 0 NOT NULL,
    multiple smallint_unsigned DEFAULT 0 NOT NULL,
    required smallint_unsigned DEFAULT 0 NOT NULL,
    tags smallint_unsigned DEFAULT 0 NOT NULL,
    module character varying(255) DEFAULT ''::character varying NOT NULL,
    weight smallint DEFAULT 0 NOT NULL,
    CONSTRAINT vocabulary_vid_check CHECK ((vid >= 0))
);


ALTER TABLE public.vocabulary OWNER TO postgres;

--
-- Name: vocabulary_node_types; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vocabulary_node_types (
    vid int_unsigned DEFAULT 0 NOT NULL,
    type character varying(32) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.vocabulary_node_types OWNER TO postgres;

--
-- Name: watchdog; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE watchdog (
    wid integer NOT NULL,
    uid integer DEFAULT 0 NOT NULL,
    type character varying(16) DEFAULT ''::character varying NOT NULL,
    message text NOT NULL,
    variables text NOT NULL,
    severity smallint_unsigned DEFAULT 0 NOT NULL,
    link character varying(255) DEFAULT ''::character varying NOT NULL,
    location text NOT NULL,
    referer character varying(128) DEFAULT ''::character varying NOT NULL,
    hostname character varying(128) DEFAULT ''::character varying NOT NULL,
    "timestamp" integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.watchdog OWNER TO postgres;

--
-- Name: xmlsitemap; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE xmlsitemap (
    lid integer NOT NULL,
    loc character varying(255) DEFAULT ''::character varying NOT NULL,
    module character varying(255) DEFAULT ''::character varying NOT NULL,
    type character varying(32) DEFAULT ''::character varying NOT NULL,
    id int_unsigned DEFAULT 0 NOT NULL,
    sid int_unsigned DEFAULT 0 NOT NULL,
    language character varying(12) DEFAULT ''::character varying NOT NULL,
    changed int_unsigned DEFAULT 0 NOT NULL,
    changefreq int_unsigned DEFAULT 0 NOT NULL,
    priority real DEFAULT 0.5 NOT NULL
);


ALTER TABLE public.xmlsitemap OWNER TO postgres;

--
-- Name: xmlsitemap_node; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE xmlsitemap_node (
    nid int_unsigned DEFAULT 0 NOT NULL,
    changed int_unsigned DEFAULT 0 NOT NULL,
    previously_changed int_unsigned DEFAULT 0 NOT NULL,
    comment_ratio real DEFAULT 0 NOT NULL,
    priority_override real DEFAULT (-2) NOT NULL
);


ALTER TABLE public.xmlsitemap_node OWNER TO postgres;

--
-- Name: xmlsitemap_taxonomy; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE xmlsitemap_taxonomy (
    tid int_unsigned DEFAULT 0 NOT NULL,
    vid int_unsigned DEFAULT 0 NOT NULL,
    changed int_unsigned DEFAULT 0 NOT NULL,
    previously_changed int_unsigned DEFAULT 0 NOT NULL,
    priority_override real DEFAULT (-2) NOT NULL
);


ALTER TABLE public.xmlsitemap_taxonomy OWNER TO postgres;

--
-- Name: xmlsitemap_user; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE xmlsitemap_user (
    uid int_unsigned DEFAULT 0 NOT NULL,
    changed int_unsigned DEFAULT 0 NOT NULL,
    previously_changed int_unsigned DEFAULT 0 NOT NULL,
    comments int_unsigned DEFAULT 0 NOT NULL,
    priority_override real DEFAULT (-2) NOT NULL
);


ALTER TABLE public.xmlsitemap_user OWNER TO postgres;

--
-- Name: xmlsitemap_user_role; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE xmlsitemap_user_role (
    rid int_unsigned DEFAULT 0 NOT NULL,
    priority real DEFAULT 0.5 NOT NULL
);


ALTER TABLE public.xmlsitemap_user_role OWNER TO postgres;

--
-- Name: concat(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION concat(text, text) RETURNS text
    AS $_$SELECT $1 || $2;$_$
    LANGUAGE sql;


ALTER FUNCTION public.concat(text, text) OWNER TO postgres;

--
-- Name: greatest(numeric, numeric); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION "greatest"(numeric, numeric) RETURNS numeric
    AS $_$SELECT CASE WHEN (($1 > $2) OR ($2 IS NULL)) THEN $1 ELSE $2 END;$_$
    LANGUAGE sql;


ALTER FUNCTION public."greatest"(numeric, numeric) OWNER TO postgres;

--
-- Name: greatest(numeric, numeric, numeric); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION "greatest"(numeric, numeric, numeric) RETURNS numeric
    AS $_$SELECT greatest($1, greatest($2, $3));$_$
    LANGUAGE sql;


ALTER FUNCTION public."greatest"(numeric, numeric, numeric) OWNER TO postgres;

--
-- Name: if(boolean, text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION if(boolean, text, text) RETURNS text
    AS $_$SELECT CASE WHEN $1 THEN $2 ELSE $3 END;$_$
    LANGUAGE sql;


ALTER FUNCTION public.if(boolean, text, text) OWNER TO postgres;

--
-- Name: if(boolean, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION if(boolean, integer, integer) RETURNS integer
    AS $_$SELECT CASE WHEN $1 THEN $2 ELSE $3 END;$_$
    LANGUAGE sql;


ALTER FUNCTION public.if(boolean, integer, integer) OWNER TO postgres;

--
-- Name: rand(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION rand() RETURNS double precision
    AS $$SELECT random();$$
    LANGUAGE sql;


ALTER FUNCTION public.rand() OWNER TO postgres;

--
-- Name: access_aid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE access_aid_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.access_aid_seq OWNER TO postgres;

--
-- Name: access_aid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE access_aid_seq OWNED BY access.aid;


--
-- Name: access_aid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('access_aid_seq', 1, false);


--
-- Name: actions_aid_aid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE actions_aid_aid_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.actions_aid_aid_seq OWNER TO postgres;

--
-- Name: actions_aid_aid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE actions_aid_aid_seq OWNED BY actions_aid.aid;


--
-- Name: actions_aid_aid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('actions_aid_aid_seq', 1, false);


--
-- Name: authmap_aid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE authmap_aid_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.authmap_aid_seq OWNER TO postgres;

--
-- Name: authmap_aid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE authmap_aid_seq OWNED BY authmap.aid;


--
-- Name: authmap_aid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('authmap_aid_seq', 1, false);


--
-- Name: batch_bid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE batch_bid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.batch_bid_seq OWNER TO postgres;

--
-- Name: batch_bid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE batch_bid_seq OWNED BY batch.bid;


--
-- Name: batch_bid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('batch_bid_seq', 7, true);


--
-- Name: blocks_bid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE blocks_bid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.blocks_bid_seq OWNER TO postgres;

--
-- Name: blocks_bid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE blocks_bid_seq OWNED BY blocks.bid;


--
-- Name: blocks_bid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('blocks_bid_seq', 14, true);


--
-- Name: boxes_bid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE boxes_bid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.boxes_bid_seq OWNER TO postgres;

--
-- Name: boxes_bid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE boxes_bid_seq OWNED BY boxes.bid;


--
-- Name: boxes_bid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('boxes_bid_seq', 3, true);


--
-- Name: comments_cid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE comments_cid_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.comments_cid_seq OWNER TO postgres;

--
-- Name: comments_cid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE comments_cid_seq OWNED BY comments.cid;


--
-- Name: comments_cid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('comments_cid_seq', 1, false);


--
-- Name: files_fid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE files_fid_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.files_fid_seq OWNER TO postgres;

--
-- Name: files_fid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE files_fid_seq OWNED BY files.fid;


--
-- Name: files_fid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('files_fid_seq', 1, false);


--
-- Name: filter_formats_format_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE filter_formats_format_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.filter_formats_format_seq OWNER TO postgres;

--
-- Name: filter_formats_format_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE filter_formats_format_seq OWNED BY filter_formats.format;


--
-- Name: filter_formats_format_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('filter_formats_format_seq', 2, true);


--
-- Name: filters_fid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE filters_fid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.filters_fid_seq OWNER TO postgres;

--
-- Name: filters_fid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE filters_fid_seq OWNED BY filters.fid;


--
-- Name: filters_fid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('filters_fid_seq', 7, true);


--
-- Name: flood_fid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE flood_fid_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.flood_fid_seq OWNER TO postgres;

--
-- Name: flood_fid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE flood_fid_seq OWNED BY flood.fid;


--
-- Name: flood_fid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('flood_fid_seq', 1, false);


--
-- Name: locales_source_lid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE locales_source_lid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.locales_source_lid_seq OWNER TO postgres;

--
-- Name: locales_source_lid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE locales_source_lid_seq OWNED BY locales_source.lid;


--
-- Name: locales_source_lid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('locales_source_lid_seq', 3056, true);


--
-- Name: menu_links_mlid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE menu_links_mlid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.menu_links_mlid_seq OWNER TO postgres;

--
-- Name: menu_links_mlid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE menu_links_mlid_seq OWNED BY menu_links.mlid;


--
-- Name: menu_links_mlid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('menu_links_mlid_seq', 144, true);


--
-- Name: node_nid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE node_nid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.node_nid_seq OWNER TO postgres;

--
-- Name: node_nid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE node_nid_seq OWNED BY node.nid;


--
-- Name: node_nid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('node_nid_seq', 42, true);


--
-- Name: node_revisions_vid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE node_revisions_vid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.node_revisions_vid_seq OWNER TO postgres;

--
-- Name: node_revisions_vid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE node_revisions_vid_seq OWNED BY node_revisions.vid;


--
-- Name: node_revisions_vid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('node_revisions_vid_seq', 42, true);


--
-- Name: permission_pid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE permission_pid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.permission_pid_seq OWNER TO postgres;

--
-- Name: permission_pid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE permission_pid_seq OWNED BY permission.pid;


--
-- Name: permission_pid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('permission_pid_seq', 9, true);


--
-- Name: role_rid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE role_rid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.role_rid_seq OWNER TO postgres;

--
-- Name: role_rid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE role_rid_seq OWNED BY role.rid;


--
-- Name: role_rid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('role_rid_seq', 3, true);


--
-- Name: term_data_tid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE term_data_tid_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.term_data_tid_seq OWNER TO postgres;

--
-- Name: term_data_tid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE term_data_tid_seq OWNED BY term_data.tid;


--
-- Name: term_data_tid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('term_data_tid_seq', 1, false);


--
-- Name: term_relation_trid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE term_relation_trid_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.term_relation_trid_seq OWNER TO postgres;

--
-- Name: term_relation_trid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE term_relation_trid_seq OWNED BY term_relation.trid;


--
-- Name: term_relation_trid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('term_relation_trid_seq', 1, false);


--
-- Name: term_synonym_tsid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE term_synonym_tsid_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.term_synonym_tsid_seq OWNER TO postgres;

--
-- Name: term_synonym_tsid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE term_synonym_tsid_seq OWNED BY term_synonym.tsid;


--
-- Name: term_synonym_tsid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('term_synonym_tsid_seq', 1, false);


--
-- Name: url_alias_pid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE url_alias_pid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.url_alias_pid_seq OWNER TO postgres;

--
-- Name: url_alias_pid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE url_alias_pid_seq OWNED BY url_alias.pid;


--
-- Name: url_alias_pid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('url_alias_pid_seq', 40, true);


--
-- Name: users_uid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE users_uid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.users_uid_seq OWNER TO postgres;

--
-- Name: users_uid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE users_uid_seq OWNED BY users.uid;


--
-- Name: users_uid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('users_uid_seq', 3, true);


--
-- Name: vocabulary_vid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vocabulary_vid_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vocabulary_vid_seq OWNER TO postgres;

--
-- Name: vocabulary_vid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vocabulary_vid_seq OWNED BY vocabulary.vid;


--
-- Name: vocabulary_vid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('vocabulary_vid_seq', 1, false);


--
-- Name: watchdog_wid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE watchdog_wid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.watchdog_wid_seq OWNER TO postgres;

--
-- Name: watchdog_wid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE watchdog_wid_seq OWNED BY watchdog.wid;


--
-- Name: watchdog_wid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('watchdog_wid_seq', 386, true);


--
-- Name: xmlsitemap_lid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE xmlsitemap_lid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.xmlsitemap_lid_seq OWNER TO postgres;

--
-- Name: xmlsitemap_lid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE xmlsitemap_lid_seq OWNED BY xmlsitemap.lid;


--
-- Name: xmlsitemap_lid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('xmlsitemap_lid_seq', 41, true);


--
-- Name: aid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE access ALTER COLUMN aid SET DEFAULT nextval('access_aid_seq'::regclass);


--
-- Name: aid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE actions_aid ALTER COLUMN aid SET DEFAULT nextval('actions_aid_aid_seq'::regclass);


--
-- Name: aid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE authmap ALTER COLUMN aid SET DEFAULT nextval('authmap_aid_seq'::regclass);


--
-- Name: bid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE batch ALTER COLUMN bid SET DEFAULT nextval('batch_bid_seq'::regclass);


--
-- Name: bid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE blocks ALTER COLUMN bid SET DEFAULT nextval('blocks_bid_seq'::regclass);


--
-- Name: bid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE boxes ALTER COLUMN bid SET DEFAULT nextval('boxes_bid_seq'::regclass);


--
-- Name: cid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE comments ALTER COLUMN cid SET DEFAULT nextval('comments_cid_seq'::regclass);


--
-- Name: fid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE files ALTER COLUMN fid SET DEFAULT nextval('files_fid_seq'::regclass);


--
-- Name: format; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE filter_formats ALTER COLUMN format SET DEFAULT nextval('filter_formats_format_seq'::regclass);


--
-- Name: fid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE filters ALTER COLUMN fid SET DEFAULT nextval('filters_fid_seq'::regclass);


--
-- Name: fid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE flood ALTER COLUMN fid SET DEFAULT nextval('flood_fid_seq'::regclass);


--
-- Name: lid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE locales_source ALTER COLUMN lid SET DEFAULT nextval('locales_source_lid_seq'::regclass);


--
-- Name: mlid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE menu_links ALTER COLUMN mlid SET DEFAULT nextval('menu_links_mlid_seq'::regclass);


--
-- Name: nid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE node ALTER COLUMN nid SET DEFAULT nextval('node_nid_seq'::regclass);


--
-- Name: vid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE node_revisions ALTER COLUMN vid SET DEFAULT nextval('node_revisions_vid_seq'::regclass);


--
-- Name: pid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE permission ALTER COLUMN pid SET DEFAULT nextval('permission_pid_seq'::regclass);


--
-- Name: rid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE role ALTER COLUMN rid SET DEFAULT nextval('role_rid_seq'::regclass);


--
-- Name: tid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE term_data ALTER COLUMN tid SET DEFAULT nextval('term_data_tid_seq'::regclass);


--
-- Name: trid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE term_relation ALTER COLUMN trid SET DEFAULT nextval('term_relation_trid_seq'::regclass);


--
-- Name: tsid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE term_synonym ALTER COLUMN tsid SET DEFAULT nextval('term_synonym_tsid_seq'::regclass);


--
-- Name: pid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE url_alias ALTER COLUMN pid SET DEFAULT nextval('url_alias_pid_seq'::regclass);


--
-- Name: uid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE users ALTER COLUMN uid SET DEFAULT nextval('users_uid_seq'::regclass);


--
-- Name: vid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vocabulary ALTER COLUMN vid SET DEFAULT nextval('vocabulary_vid_seq'::regclass);


--
-- Name: wid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE watchdog ALTER COLUMN wid SET DEFAULT nextval('watchdog_wid_seq'::regclass);


--
-- Name: lid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE xmlsitemap ALTER COLUMN lid SET DEFAULT nextval('xmlsitemap_lid_seq'::regclass);


--
-- Data for Name: access; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY access (aid, mask, type, status) FROM stdin;
\.


--
-- Data for Name: actions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY actions (aid, type, callback, parameters, description) FROM stdin;
comment_unpublish_action	comment	comment_unpublish_action		Retirer le commentaire
node_publish_action	node	node_publish_action		Publier le contenu
node_unpublish_action	node	node_unpublish_action		Retirer le contenu de la publication
node_make_sticky_action	node	node_make_sticky_action		Mettre en lumière le contenu
node_make_unsticky_action	node	node_make_unsticky_action		Retirer le contenu de la mise en lumière
node_promote_action	node	node_promote_action		Promouvoir le contenu en page d'accueil
node_unpromote_action	node	node_unpromote_action		Retirer le contenu de la page d'accueil
node_save_action	node	node_save_action		Enregistrer le contenu
user_block_user_action	user	user_block_user_action		Bloquer cet utilisateur
user_block_ip_action	user	user_block_ip_action		Bannir l'adresse IP de l'utilisateur courant
\.


--
-- Data for Name: actions_aid; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY actions_aid (aid) FROM stdin;
\.


--
-- Data for Name: authmap; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY authmap (aid, uid, authname, module) FROM stdin;
\.


--
-- Data for Name: batch; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY batch (bid, token, "timestamp", batch) FROM stdin;
\.


--
-- Data for Name: blocks; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY blocks (bid, module, delta, theme, status, weight, region, custom, throttle, visibility, pages, title, cache) FROM stdin;
1	user	0	garland	1	-6	left	0	0	0			-1
2	user	1	garland	1	-5	left	0	0	0			-1
14	search	0	garland	1	-4	left	0	0	0			-1
13	block	3	garland	1	-7	footer	0	0	0		<none>	-1
3	system	0	garland	1	-6	footer	0	0	0			-1
4	comment	0	garland	0	-5		0	0	0			1
6	menu	primary-links	garland	0	-4		0	0	0			-1
7	menu	secondary-links	garland	0	-3		0	0	0			-1
9	user	2	garland	0	-2		0	0	0			1
8	node	0	garland	0	-1		0	0	0			-1
5	locale	0	garland	1	-3	left	0	0	0			-1
10	user	3	garland	0	1		0	0	0			-1
12	block	2	garland	1	-7	right	0	0	0		Ressources	-1
11	block	1	garland	1	-7	left	0	0	0		Activités	-1
\.


--
-- Data for Name: blocks_roles; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY blocks_roles (module, delta, rid) FROM stdin;
\.


--
-- Data for Name: boxes; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY boxes (bid, body, info, format) FROM stdin;
3	<p><a target="_blank" href="http://www.centrepompidou.fr/"><img width="120" height="40" border="0" alt="" src="/res/img/cgp-petit.png" /></a> <a target="_blank" href="http://www.cccb.org/ca/"><img width="54" height="41" border="0" alt="" src="/res/img/logo_cccb.jpg" /></a> <a target="_blank" href="http://www.microsoft.com/fr/fr/"><img width="153" height="25" border="0" alt="" src="/res/img/Microsoft-logo.jpg" /></a> <a target="_blank" href="http://www.gold.ac.uk/"><img width="82" height="40" border="0" alt="" src="/res/img/logo_goldsmith.png" /></a> <a target="_blank" href="http://www.iii.u-tokyo.ac.jp/english/"><img width="45" height="40" border="0" alt="" src="/res/img/logo_univ_tokyo.png" /></a> <a target="_blank" href="http://www.institut-telecom.fr/fr_accueil.html"><img width="40" height="40" border="0" alt="" src="/res/img/logo_telecom.png" /></a> <a target="_blank" href="http://www.ensci.com/"><img width="121" height="40" border="0" alt="" src="/res/img/logo_ENSCI.png" /></a></p>	Logos	2
1	<ul>\r\n    <li><a href="/agenda">Agenda</a></li>\r\n    <li><a href="/ateliers">Ateliers</a></li>\r\n    <li><a href="/seminaires">S&eacute;minaires</a></li>\r\n    <li><a href="/colloques">Colloques</a></li>\r\n    <li><a href="/inscriptions">Inscriptions</a></li>\r\n</ul>	Activités	2
2	<ul>\r\n    <li><a href="/telecharger_lignes_de_temps">T&eacute;l&eacute;charger Lignes De Temps</a></li>\r\n    <li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire">S&eacute;minaires index&eacute;s dans Lignes De Temps</a>\r\n        <ul> <font size="1">\r\n                <li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/1">Figures de l'amateur</a></li>\r\n                <li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/6">Mus&eacute;ologie 2007-2008</a></li>\r\n                <li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/8">Mus&eacute;ologie 2008-2009</a></li>\r\n                <li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/9">Politiques et technologies de l&rsquo;amateur</a></li>\r\n                <li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/10">THD Cap Digital</a></li>\r\n                <li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/11">Nanotechnologies</a></li>\r\n                <li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/12">Modernisation</a></li>\r\n    </font>\r\n    </ul>\r\n            </li>\r\n            <li><a href="http://www.iri.centrepompidou.fr/privatedoc/">S&eacute;minaires en audio</a></li>\r\n            <li><a href="http://www.thdculture.fr" target="_blank">THD Culture</a></li>\r\n            <li><a href="http://amateur.iri.centrepompidou.fr/nouveaumonde/enmi/conf/">Entretiens du Nouveau Monde Industriel</a></li>\r\n            <li><a href="/espaces_critiques">Espaces critiques</a></li>\r\n        </ul>	Ressources	2
\.


--
-- Data for Name: cache; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY cache (cid, data, expire, created, headers, serialized) FROM stdin;
locale:fr	a:1203:{s:23:"!datetime \\342\\200\\224 !username";s:23:"!datetime \\342\\200\\224 !username";s:11:"Save blocks";s:21:"Enregistrer les blocs";s:6:"Region";s:7:"R\\303\\251gion";s:24:"No blocks in this region";s:29:"Aucun bloc dans cette r\\303\\251gion";s:40:"When working with blocks, remember that:";s:40:"En manipulant les blocs, se souvenir de:";s:60:"disabled blocks, or blocks not in a region, are never shown.";s:92:"les blocs d\\303\\251sactiv\\303\\251s, ou les blocs non affect\\303\\251s \\303\\240 une r\\303\\251gion, ne sont jamais affich\\303\\251s.";s:61:"blocks can be configured to be visible only on certain pages.";s:76:"les blocs peuvent \\303\\252tre configur\\303\\251s pour \\303\\252tre visibles sur certaines pages.";s:67:"blocks can be configured to be visible only for certain user roles.";s:96:"les blocs peuvent \\303\\252tre configur\\303\\251s pour n'\\303\\252tre visibles que pour certains r\\303\\264les utilisateurs.";s:23:"Block specific settings";s:32:"Param\\303\\250tres sp\\303\\251cifiques du bloc";s:11:"Block title";s:13:"Titre du bloc";s:44:"The title of the block as shown to the user.";s:56:"Le titre du bloc tel qu'il est affich\\303\\251 \\303\\240 l'utilisateur";s:33:"User specific visibility settings";s:56:"Param\\303\\250tres de visibilit\\303\\251 sp\\303\\251cifiques \\303\\240 l'utilisateur";s:26:"Custom visibility settings";s:41:"Param\\303\\250tres de visibilit\\303\\251 personnalis\\303\\251s";s:56:"Users cannot control whether or not they see this block.";s:81:"Les utilisateurs ne peuvent pas contr\\303\\264ler s'ils veulent afficher ce bloc ou non.";s:61:"Show this block by default, but let individual users hide it.";s:72:"Afficher ce bloc par d\\303\\251faut mais autoriser l'utilisateur \\303\\240 le masquer.";s:60:"Hide this block by default but let individual users show it.";s:72:"Masquer ce bloc par d\\303\\251faut, mais autoriser l'utilisateur \\303\\240 l'afficher.";s:33:"Role specific visibility settings";s:49:"Param\\303\\250tres de visibilit\\303\\251 sp\\303\\251cifiques au r\\303\\264les";s:29:"Show block for specific roles";s:45:"Afficher le bloc pour des r\\303\\264les sp\\303\\251cifiques";s:33:"Page specific visibility settings";s:50:"Param\\303\\250tres de visibilit\\303\\251 sp\\303\\251cifiques \\303\\240 la page";s:43:"Show on every page except the listed pages.";s:65:"Afficher le bloc sur toutes les pages except\\303\\251es celles list\\303\\251es.";s:30:"Show on only the listed pages.";s:50:"Afficher le bloc seulement sur les pages list\\303\\251es.";s:28:"Show block on specific pages";s:46:"Afficher le bloc sur certaines pages seulement";s:5:"Pages";s:5:"Pages";s:10:"Save block";s:19:"Enregistrer le bloc";s:27:"The block has been created.";s:23:"Le bloc a \\303\\251t\\303\\251 cr\\303\\251\\303\\251.";s:37:"The block settings have been updated.";s:46:"Les param\\303\\250tres du bloc ont \\303\\251t\\303\\251 mis \\303\\240 jour.";s:13:"'%name' block";s:18:"Bloc \\302\\253\\302\\240%name\\302\\240\\302\\273";s:39:"The block configuration has been saved.";s:47:"La configuration du bloc \\303\\240 \\303\\251t\\303\\251 enregistr\\303\\251e.";s:8:"Disabled";s:11:"D\\303\\251sactiv\\303\\251";s:7:"Enabled";s:7:"Activ\\303\\251";s:20:"Update notifications";s:30:"Notification des mises \\303\\240 jour";s:8:"Username";s:17:"Nom d'utilisateur";s:6:"Blocks";s:5:"Blocs";s:10:"Clean URLs";s:18:"URLs\\302\\240simplifi\\303\\251es";s:16:"Site information";s:12:"Informations";s:17:"Default time zone";s:26:"Fuseau horaire par d\\303\\251faut";s:9:"Site name";s:11:"Nom du site";s:5:"block";s:4:"bloc";s:15:"Configure block";s:18:"Configurer le bloc";s:12:"Delete block";s:17:"Supprimer le bloc";s:20:"JavaScript List Form";s:30:"Formulaire de liste javascript";s:17:"administer blocks";s:21:"administrer les blocs";s:28:"use PHP for block visibility";s:42:"utiliser PHP pour la visibilit\\303\\251 des blocs";s:16:"Advanced options";s:17:"Options avanc\\303\\251es";s:14:"E-mail address";s:21:"Adresse \\303\\251lectronique";s:9:"Add block";s:15:"Ajouter un bloc";s:17:"Block description";s:19:"Description du bloc";s:10:"Block body";s:13:"Corps du bloc";s:46:"The content of the block as shown to the user.";s:40:"Le contenu du bloc vu par l'utilisateur.";s:6:"Delete";s:9:"Supprimer";s:4:"Home";s:7:"Accueil";s:5:"Error";s:6:"Erreur";s:9:"Languages";s:18:"Toutes les langues";s:18:"Save configuration";s:28:"Enregistrer la configuration";s:10:"Processing";s:10:"Ex\\303\\251cution";s:7:"Default";s:11:"Par d\\303\\251faut";s:4:"edit";s:8:"modifier";s:6:"delete";s:9:"supprimer";s:6:"locale";s:10:"traduction";s:6:"Weight";s:5:"Poids";s:8:"Language";s:6:"Langue";s:9:"Anonymous";s:7:"Anonyme";s:2:"MB";s:2:"Mo";s:18:"View user profile.";s:27:"Voir le profil utilisateur.";s:9:"@time ago";s:12:"il y a @time";s:40:"The directory %directory does not exist.";s:39:"Le r\\303\\251pertoire %directory n'existe pas.";s:6:"Search";s:9:"Recherche";s:12:"Add language";s:18:"Ajouter une langue";s:10:"Operations";s:11:"Op\\303\\251rations";s:9:"configure";s:10:"configurer";s:4:"List";s:5:"Liste";s:9:"Configure";s:10:"Configurer";s:11:"Description";s:11:"Description";s:57:"Aggregates syndicated content (RSS, RDF, and Atom feeds).";s:53:"Agr\\303\\250ge du contenu syndiqu\\303\\251 (flux RSS, RDF et Atom).";s:62:"Controls the boxes that are displayed around the main content.";s:77:"Contr\\303\\264le l'affichage des bo\\303\\256tes apparaissant en marge du contenu principal.";s:69:"Enables keeping easily and regularly updated user web pages or blogs.";s:106:"Permet de maintenir des pages web d'utilisateurs ou des blogs tenus \\303\\240 jour facilement et r\\303\\251guli\\303\\250rement.";s:15:"Core - optional";s:17:"Core - facultatif";s:15:"Core - required";s:18:"Core - obligatoire";s:4:"Save";s:11:"Enregistrer";s:4:"none";s:5:"aucun";s:28:"Maximum file size per upload";s:33:"Taille maximale de chaque fichier";s:66:"Your PHP settings limit the maximum file size per upload to %size.";s:80:"Vos param\\303\\250tres de PHP limitent la taille maximale de chaque transfert \\303\\240 %size.";s:25:"Permitted file extensions";s:22:"Extensions autoris\\303\\251es";s:4:"View";s:4:"Voir";s:5:"Block";s:4:"Bloc";s:8:"Settings";s:11:"Param\\303\\250tres";s:2:"No";s:3:"Non";s:11:"Send e-mail";s:19:"Envoyer un courriel";s:8:"Comments";s:12:"Commentaires";s:7:"Preview";s:7:"Aper\\303\\247u";s:14:"Update options";s:23:"Options de mise \\303\\240 jour";s:6:"Update";s:12:"Mise \\303\\240 jour";s:6:"Author";s:6:"Auteur";s:6:"Status";s:6:"Statut";s:8:"Optional";s:10:"Facultatif";s:8:"Required";s:11:"Obligatoire";s:7:"Subject";s:5:"Objet";s:4:"Time";s:4:"Date";s:63:"Allows users to structure site pages in a hierarchy or outline.";s:84:"Permet aux utilisateurs de structurer les contenus du site de mani\\303\\250re hierarchique.";s:61:"Allows the user to change the color scheme of certain themes.";s:78:"Permet \\303\\240 l'utilisateur de modifier le sch\\303\\251ma de couleur de certains th\\303\\250mes.";s:57:"Allows users to comment on and discuss published content.";s:71:"Permet aux utilisateurs de commenter et de discuter le contenu publi\\303\\251.";s:61:"Enables the use of both personal and site-wide contact forms.";s:109:"Permet l'utilisation de formulaires de contact \\303\\240 la fois pour l'ensemble du site et pour chaque utilisateur.";s:11:"Authored by";s:10:"\\303\\211crit par";s:11:"Authored on";s:9:"\\303\\211crit le";s:9:"Published";s:7:"Publi\\303\\251";s:11:"Parent item";s:15:"El\\303\\251ment parent";s:9:"Your name";s:9:"Votre nom";s:7:"Comment";s:11:"Commentaire";s:9:"1 comment";s:13:"1 commentaire";s:7:"Message";s:7:"Message";s:8:"Saturday";s:6:"samedi";s:6:"Header";s:7:"Ent\\303\\252te";s:4:"Help";s:4:"Aide";s:6:"Sunday";s:8:"dimanche";s:6:"Monday";s:5:"lundi";s:7:"Tuesday";s:5:"mardi";s:9:"Wednesday";s:8:"mercredi";s:8:"Thursday";s:5:"jeudi";s:4:"Name";s:3:"Nom";s:13:"Primary links";s:15:"Liens primaires";s:15:"Secondary links";s:17:"Liens secondaires";s:4:"Type";s:4:"Type";s:16:"Language neutral";s:25:"Ind\\303\\251pendant de la langue";s:6:"Filter";s:6:"Filtre";s:4:"menu";s:4:"menu";s:16:"Database logging";s:34:"Journalisation en base de donn\\303\\251es";s:8:"disabled";s:11:"d\\303\\251sactiv\\303\\251";s:47:"Logs and records system events to the database.";s:60:"Consigne les \\303\\251venements syst\\303\\250mes dans la base de donn\\303\\251es.";s:60:"Handles the filtering of content in preparation for display.";s:49:"G\\303\\250re le filtrage du contenu avant son affichage.";s:50:"Enables threaded discussions about general topics.";s:78:"Rend\\302\\240possible\\302\\240les\\302\\240fils\\302\\240de\\302\\240discussion\\302\\240\\303\\240\\302\\240propos\\302\\240de\\302\\240sujets\\302\\240g\\303\\251n\\303\\251raux.";s:35:"Manages the display of online help.";s:48:"Permet de g\\303\\251rer l'affichage de l'aide en ligne.";s:60:"Allows administrators to customize the site navigation menu.";s:74:"Permet aux administrateurs de personnaliser le menu de navigation du site.";s:41:"More information about formatting options";s:48:"Plus d'informations sur les options de formatage";s:13:"Menu settings";s:19:"Param\\303\\250tres du menu";s:15:"Menu link title";s:26:"Titre du lien dans le menu";s:4:"Edit";s:8:"Modifier";s:16:"Add input format";s:27:"Ajouter un format d'entr\\303\\251e";s:10:"Navigation";s:10:"Navigation";s:4:"Date";s:4:"Date";s:4:"Path";s:6:"Chemin";s:7:"Content";s:7:"Contenu";s:13:"Content types";s:16:"Types de contenu";s:15:"Error reporting";s:17:"Rapports d'erreur";s:20:"Administration theme";s:26:"Th\\303\\250me de l'administration";s:42:"The configuration options have been saved.";s:53:"Les options de configuration ont \\303\\251t\\303\\251 enregistr\\303\\251es.";s:15:"Locale settings";s:33:"Langues et param\\303\\250tres r\\303\\251gionaux";s:27:"Screenshot for %theme theme";s:33:"Capture d'\\303\\251cran du th\\303\\250me %theme";s:4:"Page";s:4:"Page";s:6:"status";s:6:"statut";s:2:"is";s:3:"est";s:19:"No posts available.";s:31:"Aucune contribution disponible.";s:19:"Rebuild permissions";s:32:"Reconstruire les droits d'acc\\303\\250s";s:9:"Unlimited";s:9:"Illimit\\303\\251";s:4:"node";s:4:"node";s:9:"Uninstall";s:13:"D\\303\\251sinstaller";s:66:"Allows content to be submitted to the site and displayed on pages.";s:70:"Permet de soumettre du contenu au site et de l'afficher sur les pages.";s:48:"Allows users to log into your site using OpenID.";s:72:"Permet aux utilisateurs de s'identifier sur votre site avec leur OpenID.";s:28:"Allows users to rename URLs.";s:44:"Permet aux utilisateurs de renommer les url.";s:50:"Allows embedded PHP code/snippets to be evaluated.";s:68:"Permet \\303\\240 du code PHP d'\\303\\252tre \\303\\251valu\\303\\251 \\303\\240 l'int\\303\\251rieur des contenus.";s:51:"Alerts other sites when your site has been updated.";s:56:"Alerte d'autres sites quand votre site a \\303\\251t\\303\\251 modifi\\303\\251.";s:36:"Supports configurable user profiles.";s:45:"G\\303\\250re des profils utilisateurs configurables.";s:36:"Enables site-wide keyword searching.";s:59:"Permet la recherche par mots-cl\\303\\251s dans l'ensemble du site.";s:37:"Logs access statistics for your site.";s:51:"Enregistre les statistiques d'acc\\303\\250s \\303\\240 votre site.";s:41:"Logs and records system events to syslog.";s:50:"Enregistre les \\303\\251vements syst\\303\\250mes dans le syslog.";s:54:"Only site administrators can create new user accounts.";s:69:"Seuls les administrateurs du site peuvent cr\\303\\251er de nouveaux comptes.";s:7:"Profile";s:6:"Profil";s:7:"profile";s:7:"profils";s:19:"Create new revision";s:20:"Cr\\303\\251er une r\\303\\251vision";s:22:"Promoted to front page";s:23:"Promu en page d'accueil";s:22:"Sticky at top of lists";s:27:"Epingl\\303\\251 en haut des listes";s:6:"Active";s:5:"Actif";s:6:"System";s:8:"Syst\\303\\250me";s:6:"search";s:10:"rechercher";s:12:"Left sidebar";s:15:"Barre de gauche";s:13:"Right sidebar";s:15:"Barre de droite";s:3:"PHP";s:3:"PHP";s:11:"File system";s:20:"Syst\\303\\250me de fichiers";s:10:"Up to date";s:7:"\\303\\200 jour";s:6:"Log in";s:12:"Se connecter";s:18:"Create new account";s:24:"Cr\\303\\251er un nouveau compte";s:8:"Taxonomy";s:9:"Taxonomie";s:7:"Modules";s:7:"Modules";s:6:"Themes";s:7:"Th\\303\\250mes";s:5:"Users";s:12:"Utilisateurs";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:72:"Th\\303\\250me multicolonnes, bas\\303\\251 sur des tables, aux tons marins et cendr\\303\\251s.";s:42:"Minimalist tabled theme with light colors.";s:57:"Th\\303\\250me minimaliste bas\\303\\251 sur des tables, aux tons clairs.";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:95:"Th\\303\\250me \\303\\240 largeur variable, multi-colonnes, recolorable, bas\\303\\251 sur les standards (par d\\303\\251faut).";s:31:"Boxy tabled theme in all grays.";s:57:"Th\\303\\250me bas\\303\\251 sur des tables, aux nombreux encadr\\303\\251s gris.";s:7:"Garland";s:7:"Garland";s:21:"Blue Lagoon (Default)";s:25:"Blue Lagoon (par d\\303\\251faut)";s:3:"Ash";s:6:"Cendre";s:10:"Aquamarine";s:12:"Aigue-marine";s:17:"Belgian Chocolate";s:14:"Chocolat belge";s:12:"Citrus Blast";s:18:"Explosion d'agrume";s:8:"Cold Day";s:15:"Froide journ\\303\\251e";s:9:"Greenbeam";s:10:"Rayon vert";s:11:"Mediterrano";s:11:"Mediterrano";s:7:"Mercury";s:7:"Mercure";s:9:"Nocturnal";s:8:"Nocturne";s:4:"user";s:11:"utilisateur";s:8:"taxonomy";s:9:"taxonomie";s:6:"update";s:6:"update";s:54:"Handles general site configuration for administrators.";s:75:"Permet aux administrateurs de modifier la configuration g\\303\\251n\\303\\251rale du site.";s:38:"Enables the categorization of content.";s:36:"Permet la classification du contenu.";s:66:"Handles the auto-throttling mechanism, to control site congestion.";s:87:"Assure un m\\303\\251canisme d'autor\\303\\251gulation permettant de contr\\303\\264ler l'encombrement du site.";s:43:"Enables tracking of recent posts for users.";s:62:"Permet le suivi des derni\\303\\250res contributions des utilisateurs.";s:51:"Allows users to upload and attach files to content.";s:77:"Permet aux utilisateurs d'envoyer des fichiers et de les attacher au contenu.";s:47:"Manages the user registration and login system.";s:69:"G\\303\\250re l'inscription des utilisateurs et le syst\\303\\250me d'identification.";s:14:"@module module";s:14:"module @module";s:28:"The changes have been saved.";s:39:"Les changements ont \\303\\251t\\303\\251 enregistr\\303\\251s.";s:8:"Add rule";s:18:"Ajouter une r\\303\\250gle";s:6:"active";s:5:"actif";s:7:"blocked";s:7:"bloqu\\303\\251";s:10:"Member for";s:13:"Membre depuis";s:6:"Upload";s:21:"Transfert de fichiers";s:13:"Access denied";s:14:"Acc\\303\\250s refus\\303\\251";s:43:"You are not authorized to access this page.";s:56:"Vous n'\\303\\252tes pas autoris\\303\\251(e) \\303\\240 acc\\303\\251der \\303\\240 cette page.";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:76:"Theme \\303\\240 largeur fixe, multi-colonnes, recolorable, bas\\303\\251 sur les standards.";s:52:"Tabled, multi-column theme in blue and orange tones.";s:69:"Th\\303\\250me multicolonnes bas\\303\\251 sur des tables, aux tons bleus et oranges.";s:6:"Olivia";s:6:"Olivia";s:12:"Pink Plastic";s:14:"Plastique rose";s:12:"Shiny Tomato";s:16:"Tomate brillante";s:8:"Teal Top";s:13:"Bleu sarcelle";s:42:"The directory %directory has been created.";s:49:"Le r\\303\\251pertoire \\302\\253\\302\\240%directory\\302\\240\\302\\273 a \\303\\251t\\303\\251 cr\\303\\251\\303\\251.";s:2:"KB";s:2:"Ko";s:13:"@size @suffix";s:13:"@size @suffix";s:14:"Page not found";s:17:"Page non trouv\\303\\251e";s:38:"The requested page could not be found.";s:40:"La page demand\\303\\251e n'a pu \\303\\252tre trouv\\303\\251e.";s:12:"@count hours";s:13:"@count heures";s:10:"@count min";s:10:"@count min";s:10:"@count sec";s:10:"@count sec";s:6:"1 byte";s:7:"1 octet";s:12:"@count bytes";s:13:"@count octets";s:11:"@count days";s:12:"@count jours";s:5:"1 min";s:5:"1 min";s:5:"0 sec";s:4:"0\\302\\240s";s:5:"1 sec";s:5:"1 sec";s:6:"1 week";s:9:"1 semaine";s:6:"1 hour";s:7:"1 heure";s:12:"@count weeks";s:15:"@count semaines";s:37:"The specified passwords do not match.";s:39:"Les mots de passe ne correspondent pas.";s:23:"This field is required.";s:25:"Ce champ est obligatoire.";s:17:"!title: !required";s:19:"!title\\302\\240: !required";s:13:"Initializing.";s:15:"Initialisation.";s:31:"Remaining @remaining of @total.";s:40:"Reste @remaining sur un total de @total.";s:22:"An error has occurred.";s:26:"Une erreur s'est produite.";s:58:"Please continue to <a href="@error_url">the error page</a>";s:64:"Merci de continuer sur la <a href="@error_url">page d'erreur</a>";s:24:"!name field is required.";s:31:"Le champ !name est obligatoire.";s:13:"Left to right";s:19:"De gauche \\303\\240 droite";s:4:"Code";s:4:"Code";s:12:"English name";s:11:"Nom anglais";s:11:"Native name";s:9:"Nom natif";s:9:"Direction";s:9:"Direction";s:19:"Predefined language";s:19:"Langue pr\\303\\251d\\303\\251finie";s:13:"Language name";s:16:"Nom de la langue";s:15:"Custom language";s:21:"Langue personnalis\\303\\251e";s:13:"Language code";s:17:"Code de la langue";s:24:"Language name in English";s:27:"Nom de la langue en anglais";s:20:"Native language name";s:22:"Nom natif de la langue";s:49:"Name of the language in the language being added.";s:53:"Nom de la langue en question dans cette m\\303\\252me langue.";s:11:"Path prefix";s:17:"Prefixe de chemin";s:15:"Language domain";s:20:"Domaine de la langue";s:50:"Direction that text in this language is presented.";s:31:"Direction d'\\303\\251criture du texte.";s:13:"Right to left";s:19:"De droite \\303\\240 gauche";s:19:"Add custom language";s:33:"Ajouter une langue personnalis\\303\\251e";s:7:"English";s:7:"Anglais";s:15:"Starting import";s:23:"D\\303\\251but de l'importation";s:38:"Error importing interface translations";s:40:"Erreur \\303\\240 l'importation de la traduction";s:62:"One translation file imported for the newly installed modules.";s:83:"Un fichier de traduction a \\303\\251t\\303\\251 import\\303\\251 pour les modules nouvellement install\\303\\251s.";s:4:"Afar";s:4:"Afar";s:9:"Abkhazian";s:7:"Abkhaze";s:7:"Avestan";s:7:"Avestan";s:9:"Afrikaans";s:9:"Afrikaans";s:4:"Akan";s:4:"Akan";s:7:"Amharic";s:9:"Amharique";s:6:"Arabic";s:5:"Arabe";s:8:"Assamese";s:8:"Assamese";s:4:"Avar";s:4:"Avar";s:6:"Aymara";s:6:"Aymara";s:11:"Azerbaijani";s:15:"Azerba\\303\\257djanais";s:7:"Bashkir";s:7:"Bashkir";s:10:"Belarusian";s:11:"Belorussien";s:9:"Bulgarian";s:7:"Bulgare";s:6:"Bihari";s:6:"Bihari";s:7:"Bislama";s:7:"Bislama";s:7:"Bambara";s:7:"Bambara";s:7:"Bengali";s:7:"Bengali";s:7:"Tibetan";s:9:"Tib\\303\\251tain";s:6:"Breton";s:6:"Breton";s:7:"Bosnian";s:9:"Bosniaque";s:7:"Catalan";s:7:"Catalan";s:7:"Chechen";s:12:"Tch\\303\\251tch\\303\\250ne";s:8:"Chamorro";s:8:"Chamorro";s:4:"Cree";s:4:"Cree";s:5:"Czech";s:8:"Tch\\303\\250que";s:12:"Old Slavonic";s:11:"Vieux Slave";s:7:"Chuvash";s:7:"Chuvash";s:5:"Welsh";s:7:"Gallois";s:6:"Danish";s:6:"Danois";s:6:"German";s:8:"Allemand";s:9:"Maldivian";s:9:"Maldivian";s:7:"Bhutani";s:7:"Bhutani";s:3:"Ewe";s:4:"Ew\\303\\251";s:5:"Greek";s:4:"Grec";s:9:"Esperanto";s:10:"Esp\\303\\251ranto";s:7:"Spanish";s:8:"Espagnol";s:8:"Estonian";s:8:"Estonien";s:6:"Basque";s:6:"Basque";s:7:"Persian";s:5:"Perse";s:5:"Fulah";s:5:"Fulah";s:7:"Finnish";s:10:"Finlandais";s:4:"Fiji";s:4:"Fiji";s:8:"Faeroese";s:9:"F\\303\\251ro\\303\\257en";s:5:"Irish";s:9:"Irlandais";s:12:"Scots Gaelic";s:20:"Ga\\303\\251liques \\303\\251cossais";s:8:"Galician";s:8:"Galicien";s:7:"Guarani";s:7:"Guarani";s:8:"Gujarati";s:8:"Gujarati";s:4:"Manx";s:7:"Mannois";s:5:"Hausa";s:5:"Hausa";s:6:"Hebrew";s:8:"H\\303\\251breux";s:5:"Hindi";s:6:"Hindou";s:9:"Hiri Motu";s:9:"Hiri Motu";s:8:"Croatian";s:6:"Croate";s:9:"Hungarian";s:8:"Hongrois";s:8:"Armenian";s:9:"Arm\\303\\251nien";s:6:"Herero";s:6:"Herero";s:11:"Interlingua";s:11:"Interlingua";s:10:"Indonesian";s:11:"Indon\\303\\251sien";s:4:"Igbo";s:4:"Igbo";s:7:"Inupiak";s:7:"Inupiak";s:9:"Icelandic";s:9:"Islandais";s:7:"Italian";s:7:"Italien";s:9:"Inuktitut";s:9:"Inuktitut";s:8:"Japanese";s:8:"Japonais";s:8:"Javanese";s:8:"Javanais";s:8:"Georgian";s:9:"G\\303\\251orgien";s:5:"Kongo";s:9:"Congolais";s:6:"Kikuyu";s:6:"Kikuyu";s:8:"Kwanyama";s:8:"Kwanyama";s:6:"Kazakh";s:6:"Kazakh";s:11:"Greenlandic";s:12:"Groenlandais";s:9:"Cambodian";s:10:"Cambodgien";s:6:"Korean";s:7:"Cor\\303\\251en";s:6:"Kanuri";s:6:"Kanuri";s:8:"Kashmiri";s:8:"Kashmiri";s:7:"Kurdish";s:5:"Kurde";s:4:"Komi";s:4:"Komi";s:7:"Cornish";s:8:"Cornique";s:7:"Kirghiz";s:7:"Kirghiz";s:5:"Latin";s:5:"Latin";s:13:"Luxembourgish";s:14:"Luxembourgeois";s:7:"Luganda";s:7:"Luganda";s:7:"Lingala";s:7:"Lingala";s:8:"Laothian";s:7:"Laotien";s:10:"Lithuanian";s:10:"Lithuanien";s:7:"Latvian";s:7:"Latvian";s:8:"Malagasy";s:8:"Malgache";s:11:"Marshallese";s:11:"Marshallese";s:5:"Maori";s:5:"Maori";s:10:"Macedonian";s:11:"Mac\\303\\251donien";s:9:"Malayalam";s:9:"Malayalam";s:9:"Mongolian";s:9:"Mongolien";s:7:"Marathi";s:7:"Marathi";s:5:"Malay";s:6:"Malais";s:7:"Maltese";s:7:"Maltais";s:7:"Burmese";s:6:"Birman";s:5:"Nauru";s:8:"Le Nauru";s:13:"North Ndebele";s:15:"Ndebele du nord";s:6:"Nepali";s:9:"N\\303\\251palien";s:6:"Ndonga";s:6:"Ndonga";s:5:"Dutch";s:10:"Hollandais";s:17:"Norwegian Bokm\\303\\245l";s:20:"Norv\\303\\251gien classique";s:17:"Norwegian Nynorsk";s:15:"N\\303\\251o-norv\\303\\251gien";s:13:"South Ndebele";s:14:"Ndebele du sud";s:6:"Navajo";s:6:"Navajo";s:8:"Chichewa";s:8:"Chichewa";s:7:"Occitan";s:7:"Occitan";s:5:"Oromo";s:5:"Oromo";s:5:"Oriya";s:5:"Oriya";s:8:"Ossetian";s:7:"Oss\\303\\250te";s:7:"Punjabi";s:8:"Pendjabi";s:4:"Pali";s:4:"Pali";s:6:"Pashto";s:6:"Pashto";s:20:"Portuguese, Portugal";s:19:"Portugais, Portugal";s:18:"Portuguese, Brazil";s:18:"Portugais, Br\\303\\251sil";s:7:"Quechua";s:7:"Quechua";s:14:"Rhaeto-Romance";s:12:"Rhaeto-Roman";s:7:"Kirundi";s:7:"Kirundi";s:8:"Romanian";s:7:"Roumain";s:7:"Russian";s:5:"Russe";s:11:"Kinyarwanda";s:11:"Kinyarwanda";s:8:"Sanskrit";s:8:"Sanskrit";s:9:"Sardinian";s:5:"Sarde";s:6:"Sindhi";s:6:"Shindi";s:13:"Northern Sami";s:13:"Sami Nordique";s:5:"Sango";s:5:"Sango";s:14:"Serbo-Croatian";s:12:"Serbo-Croate";s:6:"Slovak";s:8:"Slovaque";s:9:"Slovenian";s:8:"Slov\\303\\250ne";s:6:"Samoan";s:6:"Samoan";s:5:"Shona";s:5:"Shona";s:6:"Somali";s:8:"Somalien";s:7:"Serbian";s:5:"Serbe";s:7:"Siswati";s:7:"Siswati";s:7:"Sesotho";s:7:"Sesotho";s:8:"Sudanese";s:9:"Soudanais";s:7:"Swedish";s:8:"Su\\303\\250dois";s:7:"Swahili";s:7:"Swahili";s:5:"Tamil";s:5:"Tamil";s:6:"Telugu";s:6:"Telugu";s:5:"Tajik";s:6:"Tadjik";s:4:"Thai";s:12:"Tha\\303\\257landais";s:8:"Tigrinya";s:8:"Tigrinya";s:7:"Turkmen";s:9:"Turkm\\303\\250ne";s:7:"Tagalog";s:7:"Tagalog";s:8:"Setswana";s:8:"Setswana";s:5:"Tonga";s:7:"Tongien";s:7:"Turkish";s:6:"Turque";s:15:"Unicode library";s:17:"Librairie Unicode";s:8:"\\302\\253 first";s:11:"\\302\\253\\302\\240premier";s:12:"\\342\\200\\271 previous";s:16:"\\342\\200\\271\\302\\240pr\\303\\251c\\303\\251dent";s:8:"next \\342\\200\\272";s:12:"suivant\\302\\240\\342\\200\\272";s:7:"last \\302\\273";s:11:"dernier\\302\\240\\302\\273";s:34:"[<a href="@link">more help...</a>]";s:36:"[<a href="@link">plus d'aide...</a>]";s:10:"sort by @s";s:12:"trier par @s";s:9:"sort icon";s:12:"icone de tri";s:14:"sort ascending";s:25:"trier par ordre croissant";s:17:"Syndicate content";s:20:"Syndiquer le contenu";s:15:"sort descending";s:28:"trier par ordre d\\303\\251croissant";s:7:"updated";s:11:"mis \\303\\240 jour";s:6:"Tsonga";s:6:"Tsonga";s:5:"Tatar";s:6:"Tatare";s:3:"Twi";s:3:"Twi";s:8:"Tahitian";s:8:"Tahitien";s:6:"Uighur";s:6:"Uighur";s:9:"Ukrainian";s:9:"Ukrainien";s:4:"Urdu";s:4:"Urdu";s:5:"Uzbek";s:6:"Ouzbek";s:5:"Venda";s:5:"Venda";s:10:"Vietnamese";s:10:"Vietnamien";s:5:"Wolof";s:5:"Wolof";s:5:"Xhosa";s:5:"Xhosa";s:7:"Yiddish";s:7:"Yiddish";s:6:"Yoruba";s:6:"Yoruba";s:6:"Zhuang";s:6:"Zhuang";s:19:"Chinese, Simplified";s:19:"Chinois, Simplifi\\303\\251";s:20:"Chinese, Traditional";s:21:"Chinois, Traditionnel";s:4:"Zulu";s:6:"Zoulou";s:44:"Use administration theme for content editing";s:83:"Utiliser le th\\303\\250me d'administration pour les formulaires de modification du contenu";s:4:"Logo";s:4:"Logo";s:11:"Site slogan";s:14:"Slogan du site";s:17:"Mission statement";s:16:"Objectif du site";s:22:"User pictures in posts";s:48:"Portrait des utilisateurs dans les contributions";s:25:"User pictures in comments";s:47:"Portrait des utilisateurs dans les commentaires";s:10:"Search box";s:18:"Champ de recherche";s:13:"Shortcut icon";s:19:"Ic\\303\\264ne de raccourci";s:14:"Toggle display";s:31:"Activer/d\\303\\251sactiver l'affichage";s:55:"Enable or disable the display of certain page elements.";s:68:"Activer ou d\\303\\251sactiver l'affichage de certains \\303\\251l\\303\\251ments des pages.";s:19:"Logo image settings";s:19:"Param\\303\\250tres du logo";s:52:"If toggled on, the following logo will be displayed.";s:57:"Si cette case est coch\\303\\251e, le logo suivant sera affich\\303\\251.";s:20:"Use the default logo";s:28:"Utiliser le logo par d\\303\\251faut";s:66:"Check here if you want the theme to use the logo supplied with it.";s:65:"Cochez si vous voulez que le th\\303\\250me utilise son logo par d\\303\\251faut.";s:19:"Path to custom logo";s:33:"Chemin vers le logo personnalis\\303\\251";s:17:"Upload logo image";s:15:"Envoyer le logo";s:22:"Shortcut icon settings";s:36:"Param\\303\\250tres de l'ic\\303\\264ne de raccourci";s:30:"Use the default shortcut icon.";s:43:"Utiliser l'ic\\303\\264ne de raccourci par d\\303\\251faut.";s:66:"Check here if you want the theme to use the default shortcut icon.";s:86:"Cocher ceci si vous souhaitez que le th\\303\\250me utilise l'ic\\303\\264ne de raccourci par d\\303\\251faut.";s:19:"Path to custom icon";s:35:"Chemin vers l'ic\\303\\264ne personnalis\\303\\251e";s:17:"Upload icon image";s:20:"Transf\\303\\251rer l'ic\\303\\264ne";s:22:"Required by: !required";s:24:"Requis par \\302\\240: !required";s:25:"Depends on: !dependencies";s:27:"D\\303\\251pend de\\302\\240: !dependencies";s:27:"Display post information on";s:62:"Afficher l'auteur et la date de la contribution pour les types";s:8:"Get help";s:4:"Aide";s:25:"The name of this website.";s:18:"Le nom de ce site.";s:6:"Slogan";s:6:"Slogan";s:7:"Mission";s:9:"Objectifs";s:14:"Footer message";s:23:"Message de pied de page";s:14:"Anonymous user";s:19:"Utilisateur anonyme";s:42:"The name used to indicate anonymous users.";s:54:"Le nom utilis\\303\\251 pour nommer les utilisateurs anonymes.";s:18:"Default front page";s:25:"Page de garde par d\\303\\251faut";s:19:"Temporary directory";s:22:"R\\303\\251pertoire temporaire";s:71:"A file system path where uploaded files will be stored during previews.";s:113:"Chemin du dossier dans lequel les fichiers t\\303\\251l\\303\\251charg\\303\\251s pourront \\303\\252tre stock\\303\\251s durant les pr\\303\\251-visualisations.";s:15:"Download method";s:28:"M\\303\\251thode de t\\303\\251l\\303\\251chargement";s:49:"Public - files are available using HTTP directly.";s:76:"Publique - Les fichiers sont disponibles directement, via le protocole http.";s:48:"<a href="@clean_url">Run the clean url test</a>.";s:67:"<a href="@clean_url">Lancer le test pour les URLs simplifi\\303\\251es</a>.";s:13:"Custom format";s:30:"Format d'entr\\303\\251e personnalis\\303\\251";s:34:"Select the default site time zone.";s:49:"Choisissez le fuseau horaire par d\\303\\251faut du site.";s:28:"User-configurable time zones";s:33:"Fuseaux horaires personnalisables";s:17:"First day of week";s:26:"Premier jour de la semaine";s:45:"The first day of the week for calendar views.";s:64:"Le premier jour de la semaine, pour les vues de type calendrier.";s:10:"Formatting";s:7:"Formats";s:17:"Short date format";s:22:"Format court des dates";s:33:"The short format of date display.";s:48:"Le format court d'affichage des dates et heures.";s:24:"Custom short date format";s:53:"Personalisation du format court d'affichage des dates";s:18:"Medium date format";s:22:"Format moyen des dates";s:30:"The medium sized date display.";s:48:"Le format moyen d'affichage des dates et heures.";s:25:"Custom medium date format";s:53:"Personalisation du format moyen d'affichage des dates";s:16:"Long date format";s:21:"Format long des dates";s:45:"Longer date format used for detailed display.";s:61:"Le format d'affichage des dates et heures le plus d\\303\\251taill\\303\\251.";s:23:"Custom long date format";s:52:"Personalisation du format long d'affichage des dates";s:28:"Number of items in each feed";s:36:"Nombre d'\\303\\251l\\303\\251ments pour chaque flux";s:48:"Default number of items to include in each feed.";s:63:"Le nombre d'\\303\\251l\\303\\251ments par d\\303\\251faut \\303\\240 inclure dans chaque flux.";s:12:"Feed content";s:15:"Contenu du flux";s:11:"Titles only";s:16:"Titres seulement";s:18:"Titles plus teaser";s:19:"Titres et accroches";s:9:"Full text";s:12:"Texte entier";s:69:"Global setting for the default display of content items in each feed.";s:77:"Param\\303\\250tres globaux pour l'affichage, par d\\303\\251faut, du contenu de chaque flux.";s:42:"Private - files are transferred by Drupal.";s:52:"Priv\\303\\251e - les fichiers sont transf\\303\\251r\\303\\251s par Drupal.";s:22:"Cron ran successfully.";s:36:"Traitement r\\303\\251gulier (cron) r\\303\\251ussi.";s:17:"Hide descriptions";s:24:"Masquer les descriptions";s:39:"Compress layout by hiding descriptions.";s:67:"Produit une mise en page plus compacte en cachant les descriptions.";s:10:"Screenshot";s:16:"Capture d'\\303\\251cran";s:7:"Version";s:7:"Version";s:5:"Other";s:5:"Autre";s:27:"The system module provides:";s:28:"Le module syst\\303\\250me fourni\\302\\240:";s:71:"This page shows you all available administration tasks for each module.";s:77:"Cette page liste les t\\303\\242ches d'administration disponibles pour chaque module.";s:17:"Show descriptions";s:25:"Afficher les descriptions";s:38:"Expand layout to include descriptions.";s:68:"Produit une mise en page moins compacte qui inclut des descriptions.";s:15:"Redirect to URL";s:24:"Redirection vers une URL";s:6:"Create";s:6:"Cr\\303\\251er";s:17:"Powered by Drupal";s:20:"Propuls\\303\\251 par Drupal";s:21:"Configure permissions";s:30:"Configurer les droits d'acc\\303\\250s";s:10:"Administer";s:11:"Administrer";s:13:"File download";s:16:"T\\303\\251l\\303\\251chargement";s:18:"Content management";s:18:"Gestion du contenu";s:27:"Manage your site's content.";s:32:"G\\303\\251rer le contenu de votre site.";s:14:"RSS publishing";s:15:"Publication RSS";s:7:"Reports";s:8:"Rapports";s:59:"View reports from system logs and other status information.";s:68:"Voir les rapports des journaux du syst\\303\\250me et d'autres informations.";s:13:"Status report";s:15:"Tableau de bord";s:74:"Get a status report about your site's operation and any detected problems.";s:80:"Obtenir un rapport du fonctionnement de votre site et des probl\\303\\250mes d\\303\\251tect\\303\\251s.";s:13:"Site building";s:20:"Construction du site";s:38:"Control how your site looks and feels.";s:56:"Contr\\303\\264ler l'affichage et le comportement de votre site.";s:47:"Enable or disable add-on modules for your site.";s:64:"Activer ou d\\303\\251sactiver les modules additionnels pour votre site.";s:57:"Change which theme your site uses or allows users to set.";s:107:"Modifier le th\\303\\250me que votre site utilise et autoriser les utilisateurs \\303\\240 choisir un th\\303\\250me personnalis\\303\\251.";s:18:"Site configuration";s:21:"Configuration du site";s:40:"Adjust basic site configuration options.";s:41:"Ajuster la configuration de base du site.";s:13:"Date and time";s:13:"Date et heure";s:68:"Tell Drupal where to store uploaded files and how they are accessed.";s:85:"Indiquer \\303\\240 Drupal o\\303\\271 stocker les fichiers transf\\303\\251r\\303\\251s et la mani\\303\\250re d'y acc\\303\\251der.";s:7:"Actions";s:7:"Actions";s:41:"Manage the actions defined for your site.";s:45:"G\\303\\251rer les actions d\\303\\251finies pour votre site.";s:43:"Enable or disable clean URLs for your site.";s:61:"Activer ou d\\303\\251sactiver les URLs simplifi\\303\\251es pour votre site.";s:55:"Settings for how your administrative pages should look.";s:64:"Param\\303\\250tres d\\303\\251finissant l'affichage des pages d'administration.";s:13:"Image toolkit";s:22:"Bo\\303\\256te \\303\\240 outils image";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";s:105:"Choisir quelle bo\\303\\256te \\303\\240 outils image utiliser si vous avez install\\303\\251 des bo\\303\\256tes \\303\\240 outils optionnelles.";s:11:"Performance";s:11:"Performance";s:16:"Site maintenance";s:19:"Maintenance du site";s:63:"Take the site off-line for maintenance or bring it back online.";s:67:"Mettre le site hors ligne pour maintenance ou le remettre en ligne.";s:18:"Logging and alerts";s:25:"Journalisation et alertes";s:12:"Compact mode";s:12:"Mode compact";s:7:"By task";s:10:"Par t\\303\\242che";s:9:"By module";s:10:"Par module";s:15:"Clean URL check";s:26:"Test des URLs simplifi\\303\\251es";s:20:"Date and time lookup";s:29:"Consultation de date et heure";s:15:"Global settings";s:19:"Param\\303\\250tres globaux";s:25:"Select the default theme.";s:30:"Choisir le th\\303\\250me par d\\303\\251faut.";s:6:"system";s:6:"system";s:8:"Run cron";s:37:"Lancer le traitement r\\303\\251gulier (cron)";s:3:"SQL";s:3:"SQL";s:28:"Configure an advanced action";s:30:"Configurer une action avanc\\303\\251e";s:14:"Remove orphans";s:32:"Supprimer les actions orphelines";s:27:"access administration pages";s:35:"acc\\303\\251der aux pages d'administration";s:19:"access site reports";s:29:"acc\\303\\251der aux rapports du site";s:18:"administer actions";s:23:"administrer les actions";s:16:"administer files";s:24:"administrer les fichiers";s:29:"administer site configuration";s:36:"administrer la configuration du site";s:22:"select different theme";s:28:"choisir un th\\303\\250me diff\\303\\251rent";s:10:"Web server";s:11:"Serveur web";s:20:"PHP register globals";s:22:"PHP 'register globals'";s:16:"PHP memory limit";s:23:"Plafond m\\303\\251moire de PHP";s:9:"Protected";s:9:"Prot\\303\\251g\\303\\251";s:18:"Configuration file";s:24:"Fichier de configuration";s:9:"Never run";s:16:"Jamais ex\\303\\251cut\\303\\251";s:17:"Cron has not run.";s:29:"Cron n'a pas \\303\\251t\\303\\251 ex\\303\\251cut\\303\\251.";s:22:"Cron maintenance tasks";s:27:"T\\303\\242ches de maintenance cron";s:46:"You can <a href="@cron">run cron manually</a>.";s:60:"Vous pouvez <a href="@cron">lancer le cron manuellement</a>.";s:42:"Writable (<em>public</em> download method)";s:61:"Inscriptible (m\\303\\251thode de t\\303\\251l\\303\\251chargement <em>publique</em>)";s:16:"Database updates";s:35:"Mise \\303\\240 jour de la base de donn\\303\\251es";s:20:"Access to update.php";s:28:"Acc\\303\\250s au fichier update.php";s:12:"Not writable";s:27:"Non accessible en \\303\\251criture";s:18:"Last run !time ago";s:34:"Derni\\303\\250re ex\\303\\251cution, il y a !time";s:26:"Cron has not run recently.";s:37:"Cron n'a pas \\303\\251t\\303\\251 lanc\\303\\251 r\\303\\251cemment.";s:12:"Color scheme";s:19:"Sch\\303\\251ma de couleurs";s:6:"Custom";s:13:"Personnalis\\303\\251";s:9:"Color set";s:15:"Jeu de couleurs";s:10:"Base color";s:15:"Couleur de base";s:10:"Link color";s:17:"Couleur des liens";s:10:"Header top";s:18:"Haut de l'en-t\\303\\252te";s:13:"Header bottom";s:17:"Bas de l'en-t\\303\\252te";s:9:"Posted in";s:10:"Post\\303\\251 sur";s:22:"No comments available.";s:29:"Aucun commentaire disponible.";s:5:"color";s:5:"color";s:5:"Reply";s:9:"R\\303\\251pondre";s:28:"Delete the selected comments";s:41:"Supprimer les commentaires s\\303\\251lectionn\\303\\251s";s:16:"Comment settings";s:28:"Param\\303\\250tres des commentaires";s:9:"Read only";s:18:"Lecture uniquement";s:10:"Read/Write";s:17:"Lecture/\\303\\211criture";s:15:"Add new comment";s:22:"Ajouter un commentaire";s:31:"Add a new comment to this page.";s:45:"Ajouter un nouveau commentaire \\303\\240 cette page.";s:15:"Recent comments";s:21:"Commentaires r\\303\\251cents";s:17:"Unpublish comment";s:22:"Retirer le commentaire";s:39:"Unpublish comment containing keyword(s)";s:55:"Retirer les commentaires contenant ce(s) mot(s) cl\\303\\251(s)";s:14:"Delete comment";s:24:"Supprimer le commentaire";s:12:"Edit comment";s:23:"Modifier le commentaire";s:61:"List and edit site comments and the comment moderation queue.";s:53:"Afficher et modifier les commentaires du site et file";s:18:"Published comments";s:21:"Commentaires publi\\303\\251s";s:14:"Approval queue";s:28:"File d'attente d'approbation";s:7:"comment";s:11:"commentaire";s:15:"access comments";s:25:"acc\\303\\251der aux commentaires";s:19:"administer comments";s:28:"administrer les commentaires";s:13:"post comments";s:26:"soumettre des commentaires";s:30:"post comments without approval";s:43:"soumettre des commentaires sans approbation";s:16:"Reply to comment";s:24:"R\\303\\251pondre au commentaire";s:5:"Count";s:6:"Nombre";s:26:"Top 'access denied' errors";s:44:"Principales erreurs de type 'acc\\303\\250s refus\\303\\251'";s:35:"View 'access denied' errors (403s).";s:40:"Voir les erreurs 'acc\\303\\250s refus\\303\\251' (403).";s:27:"Top 'page not found' errors";s:47:"Principales erreurs de type 'page non trouv\\303\\251e'";s:36:"View 'page not found' errors (404s).";s:43:"Voir les erreurs 'page non trouv\\303\\251e' (404).";s:5:"dblog";s:5:"dblog";s:24:"Allowed HTML tags: @tags";s:29:"Tags HTML autoris\\303\\251s\\302\\240: @tags";s:32:"All roles may use default format";s:42:"Tous les r\\303\\264les peuvent utiliser ce format";s:28:"No roles may use this format";s:38:"Aucun r\\303\\264le ne peut utiliser ce format";s:18:"Set default format";s:30:"D\\303\\251finir le format par d\\303\\251faut";s:23:"Default format updated.";s:31:"Format par d\\303\\251faut mis \\303\\240 jour.";s:20:"Line break converter";s:30:"Convertisseur de saut de ligne";s:10:"URL filter";s:10:"filtre URL";s:14:"HTML corrector";s:15:"Correcteur HTML";s:12:"Input format";s:16:"Format d'entr\\303\\251e";s:70:"Web page addresses and e-mail addresses turn into links automatically.";s:101:"Les adresses de pages web et de messagerie \\303\\251lectronique sont transform\\303\\251es en liens automatiquement.";s:41:"Lines and paragraphs break automatically.";s:63:"Les lignes et les paragraphes vont \\303\\240 la ligne automatiquement.";s:12:"Compose tips";s:22:"Astuces de composition";s:13:"Input formats";s:17:"Formats d'entr\\303\\251e";s:6:"filter";s:6:"filtre";s:4:"help";s:11:"Aide (Help)";s:19:"Delete input format";s:29:"Supprimer un format d'entr\\303\\251e";s:18:"administer filters";s:23:"administrer les filtres";s:32:"Translations may be provided by:";s:45:"Les traductions peuvent \\303\\252tre fournies par\\302\\240:";s:17:"Language switcher";s:20:"S\\303\\251lecteur de langue";s:3:"Fri";s:3:"ven";s:19:"Translate interface";s:25:"Traduction de l'interface";s:59:"Translate the built in interface and optionally other text.";s:75:"Traduire l'interface utilisateur ainsi que potentiellement d'autres textes.";s:55:"Configure languages for content and the user interface.";s:64:"Configurer les langues du contenu et de l'interface utilisateur.";s:2:"pm";s:2:"pm";s:3:"Jul";s:6:"juill.";s:9:"Menu item";s:16:"El\\303\\251ment de menu";s:8:"Expanded";s:8:"D\\303\\251pli\\303\\251";s:20:"administer languages";s:23:"administrer les langues";s:19:"translate interface";s:20:"traduire l'interface";s:28:"There are no menu items yet.";s:45:"Il n'y a actuellement aucune entr\\303\\251e de menu.";s:3:"Mon";s:3:"lun";s:5:"Menus";s:5:"Menus";s:10:"List menus";s:15:"Liste les menus";s:8:"Add menu";s:15:"Ajouter un menu";s:15:"administer menu";s:19:"administrer le menu";s:72:"The link text corresponding to this item that should appear in the menu.";s:63:"Texte correspond au nom du lien qui sera affich\\303\\251 dans le menu.";s:57:"The description displayed when hovering over a menu item.";s:73:"La description affich\\303\\251e quand le pointeur survole cet \\303\\251l\\303\\251ment de menu.";s:63:"Menu items that are not enabled will not be listed in any menu.";s:87:"Les \\303\\251l\\303\\251ments du menu qui ne sont pas activ\\303\\251s ne seront pas affich\\303\\251s dans les menus.";s:22:"Delete this menu item.";s:31:"Supprime cette entr\\303\\251e de menu.";s:10:"List items";s:26:"Liste les entr\\303\\251es de menu";s:8:"Add item";s:20:"Ajouter un \\303\\251l\\303\\251ment";s:9:"Edit menu";s:16:"Modifier le menu";s:14:"Edit menu item";s:28:"Modifier l'\\303\\251l\\303\\251ment de menu";s:13:"not published";s:11:"non publi\\303\\251";s:8:"promoted";s:5:"promu";s:12:"not promoted";s:9:"non promu";s:6:"sticky";s:9:"\\303\\251pingl\\303\\251";s:10:"not sticky";s:13:"non \\303\\251pingl\\303\\251";s:4:"type";s:7:"le type";s:8:"language";s:6:"langue";s:7:"Publish";s:7:"Publier";s:9:"Unpublish";s:10:"D\\303\\251publier";s:21:"Promote to front page";s:24:"Placer en page d'accueil";s:22:"Demote from front page";s:28:"Retirer de la page d'accueil";s:11:"Make sticky";s:9:"\\303\\211pingler";s:17:"Remove stickiness";s:20:"Retirer l'\\303\\251pinglage";s:18:"Node access status";s:44:"Statut des droits d'acc\\303\\250s aux contributions";s:28:"Number of posts on main page";s:46:"Nombre de contributions sur la page principale";s:23:"Length of trimmed posts";s:37:"Longueur des contributions abr\\303\\251g\\303\\251es";s:14:"200 characters";s:15:"200 caract\\303\\250res";s:14:"400 characters";s:15:"400 caract\\303\\250res";s:14:"600 characters";s:15:"600 caract\\303\\250res";s:14:"800 characters";s:15:"800 caract\\303\\250res";s:15:"1000 characters";s:16:"1000 caract\\303\\250res";s:15:"1200 characters";s:16:"1200 caract\\303\\250res";s:15:"1400 characters";s:16:"1400 caract\\303\\250res";s:15:"1600 characters";s:16:"1600 caract\\303\\250res";s:15:"1800 characters";s:16:"1800 caract\\303\\250res";s:15:"2000 characters";s:16:"2000 caract\\303\\250res";s:12:"Preview post";s:26:"Aper\\303\\247u de la contribution";s:43:"Must users preview posts before submitting?";s:39:"Aper\\303\\247u obligatoire avant soumission\\302\\240?";s:12:"Create @name";s:14:"Cr\\303\\251er '@name'";s:25:"Show summary in full view";s:40:"Afficher le r\\303\\251sum\\303\\251 en mode pleine page";s:20:"Revision information";s:31:"Informations sur les r\\303\\251visions";s:11:"Log message";s:18:"Message de journal";s:21:"Authoring information";s:27:"Informations de publication";s:27:"Leave blank for %anonymous.";s:29:"Laisser vide pour %anonymous.";s:62:"Format: %time. Leave blank to use the time of form submission.";s:80:"Format\\302\\240: %time. Laissez vide pour utiliser la date de soumission du formulaire.";s:18:"Publishing options";s:22:"Options de publication";s:30:"@type %title has been created.";s:53:"Le contenu '%title', de type '@type', a \\303\\251t\\303\\251 cr\\303\\251\\303\\251.";s:30:"@type %title has been updated.";s:58:"Le contenu '%title', de type '@type', a \\303\\251t\\303\\251 mis \\303\\240 jour.";s:3:"RSS";s:3:"RSS";s:9:"Syndicate";s:11:"Syndication";s:15:"Advanced search";s:18:"Recherche avanc\\303\\251e";s:27:"Containing any of the words";s:23:"Contenant l'un des mots";s:21:"Containing the phrase";s:31:"Contenant l'expression enti\\303\\250re";s:28:"Containing none of the words";s:25:"Ne contenant pas les mots";s:19:"Only of the type(s)";s:15:"Du ou des types";s:14:"Unpublish post";s:36:"Retirer le contenu de la publication";s:16:"Make post sticky";s:29:"Mettre en lumi\\303\\250re le contenu";s:18:"Make post unsticky";s:41:"Retirer le contenu de la mise en lumi\\303\\250re";s:26:"Promote post to front page";s:39:"Promouvoir le contenu en page d'accueil";s:27:"Remove post from front page";s:39:"Retirer le contenu de la page d'accueil";s:27:"Change the author of a post";s:27:"Changer l'auteur du contenu";s:9:"Save post";s:22:"Enregistrer le contenu";s:36:"Unpublish post containing keyword(s)";s:69:"Retirer de la publication les contenus contenant le ou les mots cl\\303\\251s";s:14:"Create content";s:17:"Cr\\303\\251er un contenu";s:43:"View, edit, and delete your site's content.";s:53:"Voir, modifier et supprimer le contenu de votre site.";s:13:"Post settings";s:27:"Param\\303\\250tres de contribution";s:16:"Add content type";s:7:"Ajouter";s:14:"access content";s:19:"acc\\303\\251der au contenu";s:24:"administer content types";s:32:"administrer les types de contenu";s:16:"administer nodes";s:22:"administrer les n\\305\\223uds";s:16:"revert revisions";s:26:"revenir sur les r\\303\\251visions";s:14:"view revisions";s:19:"voir les r\\303\\251visions";s:16:"Save permissions";s:31:"Enregistrer les droits d'acc\\303\\250s";s:10:"Permission";s:14:"Droit d'acc\\303\\250s";s:26:"User registration settings";s:34:"Param\\303\\250tres de cr\\303\\251ation de compte";s:20:"Public registrations";s:39:"Cr\\303\\251ations de comptes par les visiteurs";s:68:"Visitors can create accounts but administrator approval is required.";s:100:"Les visiteurs peuvent cr\\303\\251er leur propre compte, mais l'approbation d'un administrateur est requise.";s:61:"Require e-mail verification when a visitor creates an account";s:77:"Exiger la v\\303\\251rification de l'adresse e-mail quand un visiteur cr\\303\\251e un compte";s:28:"User registration guidelines";s:40:"Directives pour la cr\\303\\251ation d'un compte";s:20:"User e-mail settings";s:35:"Param\\303\\250tres de l'e-mail utilisateur";s:24:"Available variables are:";s:33:"Les variables disponibles sont\\302\\240:";s:42:"Welcome, new user created by administrator";s:57:"Bienvenue, nouvel utilisateur cr\\303\\251\\303\\251 par l'administrateur";s:29:"Welcome, no approval required";s:36:"Bienvenue, pas d'approbation requise";s:40:"Welcome, awaiting administrator approval";s:35:"Bienvenue, en attente d'approbation";s:23:"Password recovery email";s:28:"Mail d'oubli de mot de passe";s:67:"Customize e-mail messages sent to users who request a new password.";s:86:"Personnalise les emails envoy\\303\\251s aux utilisateurs qui demande un nouveau mot de passe.";s:24:"Account activation email";s:28:"Email d'activation du compte";s:38:"Notify user when account is activated.";s:60:"Notifier l'utilisateur quand son nouveau compte est activ\\303\\251.";s:21:"Account blocked email";s:44:"Email de notification d'un blocage de compte";s:36:"Notify user when account is blocked.";s:54:"Notifier l'utilisateur lorsque son compte est bloqu\\303\\251.";s:21:"Account deleted email";s:49:"Email de notification d'une suppression de compte";s:36:"Notify user when account is deleted.";s:56:"Notifier l'utilisateur lorsque son compte est supprim\\303\\251.";s:10:"Signatures";s:10:"Signatures";s:17:"Signature support";s:22:"Gestion des signatures";s:8:"Pictures";s:9:"Portraits";s:15:"Picture support";s:36:"Support des portraits d'utilisateurs";s:18:"Picture image path";s:31:"Dossier contenant les portraits";s:65:"Subdirectory in the directory %dir where pictures will be stored.";s:79:"Sous-r\\303\\251pertoire du r\\303\\251pertoire %dir dans lequel les portraits seront stock\\303\\251s.";s:15:"Default picture";s:20:"Portrait par d\\303\\251faut";s:26:"Picture maximum dimensions";s:32:"Dimensions maximales du portrait";s:43:"Maximum dimensions for pictures, in pixels.";s:46:"Dimensions maximales des portraits, en pixels.";s:25:"Picture maximum file size";s:51:"Taille de fichier maximale des fichiers de portrait";s:38:"Maximum file size for pictures, in kB.";s:48:"Taille de fichier maximale des portraits, en Ko.";s:18:"Picture guidelines";s:35:"Directives concernant les portraits";s:21:"Show only users where";s:40:"Afficher uniquement les utilisateurs o\\303\\271";s:11:"Last access";s:14:"Dernier acc\\303\\250s";s:8:"Add role";s:16:"Ajouter un r\\303\\264le";s:16:"edit permissions";s:28:"modifier les droits d'acc\\303\\250s";s:6:"locked";s:11:"verrouill\\303\\251";s:24:"The role has been added.";s:25:"Le r\\303\\264le a \\303\\251t\\303\\251 ajout\\303\\251.";s:9:"edit role";s:17:"modifier le r\\303\\264le";s:11:"Access type";s:13:"Type d'acc\\303\\250s";s:9:"Rule type";s:14:"Type de r\\303\\250gle";s:4:"Mask";s:6:"Masque";s:8:"username";s:17:"nom d'utilisateur";s:6:"e-mail";s:6:"e-mail";s:4:"host";s:14:"nom de domaine";s:36:"There are currently no access rules.";s:45:"Il n'y a actuellement aucune r\\303\\250gle d'acc\\303\\250s.";s:16:"Account settings";s:21:"Param\\303\\250tres de compte";s:49:"Account details for !username at !site (approved)";s:53:"D\\303\\251tails du compte de !username sur !site (approuv\\303\\251)";s:10:"My account";s:10:"Mon compte";s:10:"User login";s:21:"Connexion utilisateur";s:26:"Create a new user account.";s:39:"Cr\\303\\251er un nouveau compte d'utilisateur.";s:20:"Request new password";s:32:"Demander un nouveau mot de passe";s:32:"Request new password via e-mail.";s:44:"Demander un nouveau mot de passe par e-mail.";s:52:"An administrator created an account for you at !site";s:56:"Un administrateur a cr\\303\\251\\303\\251 un compte pour vous sur !site";s:38:"Account details for !username at !site";s:38:"D\\303\\251tails du compte !username sur !site";s:63:"Account details for !username at !site (pending admin approval)";s:89:"D\\303\\251tails du compte de !username sur !site (en attente de validation par l'administrateur)";s:52:"Replacement login information for !username at !site";s:66:"Information de changement de mot de passe pour !username sur !site";s:19:"Account information";s:22:"Informations du compte";s:54:"Provide a password for the new account in both fields.";s:67:"Entrez un mot de passe pour le nouveau compte dans les deux champs.";s:7:"Blocked";s:7:"Bloqu\\303\\251";s:9:"Who's new";s:16:"Nouveaux membres";s:12:"Who's online";s:21:"Utilisateurs en ligne";s:23:"Enter your @s username.";s:39:"Entrez votre nom d'utilisateur pour @s.";s:50:"Enter the password that accompanies your username.";s:64:"Entrez le mot de passe correspondant \\303\\240 votre nom d'utilisateur.";s:7:"History";s:10:"Historique";s:3:"Low";s:6:"Faible";s:4:"High";s:5:"Haute";s:65:"The password does not include enough variation to be secure. Try:";s:71:"Le mot de passe n'est pas assez complexe pour \\303\\252tre s\\303\\273r. Essayer de\\302\\240:";s:40:"Adding both upper and lowercase letters.";s:71:"Varier la casse avec des lettres en majuscule et d'autres en minuscule.";s:15:"Adding numbers.";s:20:"Ajouter des nombres.";s:19:"Adding punctuation.";s:34:"Ajouter des signes de ponctuation.";s:67:"It is recommended to choose a password different from the username.";s:85:"Il est recommand\\303\\251 que votre mot de passe soit diff\\303\\251rent de votre nom d'utilisateur.";s:16:"Passwords match:";s:32:"Concordance des mots de passe\\302\\240:";s:48:"Account details for !username at !site (blocked)";s:51:"D\\303\\251tails du compte de !username sur !site (bloqu\\303\\251)";s:51:"!username,\\012\\012Your account on !site has been blocked.";s:55:"!username,\\012\\012Votre compte sur !site a \\303\\251t\\303\\251 verrouill\\303\\251.";s:48:"Account details for !username at !site (deleted)";s:53:"D\\303\\251tails du compte de !username sur !site (supprim\\303\\251)";s:51:"!username,\\012\\012Your account on !site has been deleted.";s:53:"!username,\\012\\012Votre compte sur !site a \\303\\251t\\303\\251 supprim\\303\\251.";s:10:"permission";s:10:"permission";s:4:"role";s:5:"r\\303\\264le";s:26:"Unblock the selected users";s:43:"D\\303\\251bloquer les utilisateurs s\\303\\251lectionn\\303\\251s.";s:24:"Block the selected users";s:40:"Bloquer les utilisateurs s\\303\\251lectionn\\303\\251s.";s:25:"Delete the selected users";s:42:"Supprimer les utilisateurs s\\303\\251lectionn\\303\\251s.";s:32:"Add a role to the selected users";s:49:"Ajouter un r\\303\\264le aux utilisateurs s\\303\\251lectionn\\303\\251s.";s:37:"Remove a role from the selected users";s:49:"Retirer un r\\303\\264le aux utilisateurs s\\303\\251lectionn\\303\\251s.";s:30:"Ban IP address of current user";s:44:"Bannir l'adresse IP de l'utilisateur courant";s:7:"Log out";s:15:"Se d\\303\\251connecter";s:12:"User account";s:20:"Compte d'utilisateur";s:17:"User autocomplete";s:46:"Saisie semi-automatique des noms d'utilisateur";s:15:"User management";s:24:"Gestion des utilisateurs";s:61:"Manage your site's users, groups and access to site features.";s:84:"G\\303\\251rer les utilisateurs de votre site, les groupes et l'acc\\303\\250s aux fonctionnalit\\303\\251s.";s:12:"Access rules";s:16:"R\\303\\250gles d'acc\\303\\250s";s:13:"User settings";s:28:"Param\\303\\250tres des utilisateurs";s:26:"List, add, and edit users.";s:47:"Afficher, ajouter ou modifier des utilisateurs.";s:30:"List, edit, or add user roles.";s:55:"Afficher, ajouter ou modifier des r\\303\\264les d'utilisateur.";s:11:"Permissions";s:15:"Droits d'acc\\303\\250s";s:64:"Determine access to features by selecting permissions for roles.";s:76:"D\\303\\251finir l'acc\\303\\250s aux fonctions en affectant des droits d'acc\\303\\250s aux r\\303\\264les.";s:11:"Delete rule";s:20:"Supprimer une r\\303\\250gle";s:9:"Edit rule";s:19:"Modifier une r\\303\\250gle";s:9:"Edit role";s:17:"Modifier le r\\303\\264le";s:14:"anonymous user";s:19:"utilisateur anonyme";s:18:"authenticated user";s:22:"utilisateur identifi\\303\\251";s:20:"access user profiles";s:32:"acc\\303\\251der aux profils des membres";s:22:"administer permissions";s:31:"administrer les droits d'acc\\303\\250s";s:16:"administer users";s:28:"administrer les utilisateurs";s:19:"change own username";s:29:"changer son nom d'utilisateur";s:8:"Add user";s:22:"Ajouter un utilisateur";s:26:"Notify user of new account";s:44:"Notifier l'utilisateur de son nouveau compte";s:11:"Check rules";s:21:"V\\303\\251rifier les r\\303\\250gles";s:7:"Account";s:18:"Compte utilisateur";s:26:"No vocabularies available.";s:29:"Aucun vocabulaire disponible.";s:61:"Type of Meal: <em>Appetizer, Main Course, Salad, Dessert</em>";s:71:"Type de repas\\302\\240: <em>entr\\303\\251e, plat de r\\303\\251sistance, salade, dessert</em>";s:62:"Preparation Time: <em>0-30mins, 30-60mins, 1-2 hrs, 2hrs+</em>";s:63:"Temps de pr\\303\\251paration: <em>0-30mn., 30-60mn., 1-2 h., +2h.</em>";s:19:"administer taxonomy";s:29:"administrer la classification";s:6:"Friday";s:8:"vendredi";s:21:"!long-month-name July";s:24:"!long-month-name juillet";s:8:"Password";s:12:"Mot de passe";s:16:"Confirm password";s:25:"Confirmer le mot de passe";s:18:"Password strength:";s:29:"S\\303\\251curit\\303\\251 du mot de passe\\302\\240:";s:6:"Medium";s:5:"Moyen";s:3:"Yes";s:3:"Oui";s:6:"French";s:9:"Fran\\303\\247ais";s:21:"Autocomplete taxonomy";s:44:"Compl\\303\\251ter la classification automatiquement";s:9:"Edit term";s:17:"Modifier le terme";s:14:"Add vocabulary";s:22:"Ajouter un vocabulaire";s:5:"Title";s:5:"Titre";s:4:"Body";s:5:"Corps";s:73:"Unable to fetch any information about available new releases and updates.";s:79:"Impossible de recup\\303\\251rer l'information des nouvelles versions et mises \\303\\240 jour.";s:6:"Weekly";s:19:"Toutes les semaines";s:5:"Daily";s:14:"Tous les jours";s:12:"Publish post";s:18:"Publier le contenu";s:29:"Display a message to the user";s:37:"Afficher une message \\303\\240 l'utilisateur";s:18:"Block current user";s:23:"Bloquer cet utilisateur";s:6:"Footer";s:12:"Pied de page";s:0:"";b:1;s:8:"RSS feed";s:8:"flux RSS";s:59:"Powered by Drupal, an open source content management system";s:76:"Cr\\303\\251\\303\\251 avec l'aide de Drupal, un syst\\303\\250me de gestion de contenu "opensource"";s:6:"Drupal";s:6:"Drupal";s:19:"PostgreSQL database";s:27:"Base de donn\\303\\251es PostgreSQL";s:12:"Standard PHP";s:12:"PHP standard";s:22:"PHP Mbstring Extension";s:22:"Extension PHP mbstring";s:4:"view";s:4:"voir";s:24:"No update data available";s:42:"Pas de donn\\303\\251es de mise \\303\\240 jour disponible";s:17:"Available updates";s:25:"Mises \\303\\240 jour disponibles";s:19:"Manual update check";s:39:"V\\303\\251rification manuelle de mises \\303\\240 jour";s:25:"Drupal core update status";s:35:"Etat de mise \\303\\240 jour de Drupal core";s:67:"Manage tagging, categorization, and classification of your content.";s:78:"G\\303\\251rer les \\303\\251tiquettes, les cat\\303\\251gories et la classification de votre contenu.";s:18:"Recent log entries";s:29:"Entr\\303\\251es r\\303\\251centes du journal";s:43:"View events that have recently been logged.";s:60:"Voir les \\303\\251v\\303\\251nements qui ont \\303\\251t\\303\\251 enregistr\\303\\251s r\\303\\251cemment.";s:5:"Roles";s:6:"R\\303\\264les";s:17:"Reset to defaults";s:21:"R\\303\\251tablir par d\\303\\251faut";s:14:"System default";s:30:"Th\\303\\250me par d\\303\\251faut du syst\\303\\250me";s:10:"Bluemarine";s:11:"Bleu marine";s:10:"Text color";s:16:"Couleur du texte";s:7:"Article";b:1;s:9:"published";s:7:"publi\\303\\251";s:21:"Show only items where";s:37:"Montrer seulement les \\303\\251l\\303\\251ments dont";s:31:"Unpublish the selected comments";s:39:"Retirer les commentaires s\\303\\251lectionn\\303\\251s";s:54:"@module (<span class="admin-disabled">disabled</span>)";b:1;s:52:"@module (<span class="admin-enabled">enabled</span>)";b:1;s:70:"Enables the usage of FCKeditor (WYSIWYG) instead of plain text fields.";b:1;s:5:"Autre";b:1;s:32:"Importing interface translations";s:53:"Importation de traductions de l'interface utilisateur";s:18:"create url aliases";s:22:"cr\\303\\251er des alias d'url";s:17:"URL path settings";s:27:"Param\\303\\250tres du chemin d'URL";s:14:"Filter aliases";s:15:"Alias de filtre";s:5:"Alias";s:5:"Alias";s:25:"No URL aliases available.";s:29:"Aucun alias d'URL disponible.";s:11:"URL aliases";s:11:"Alias d'url";s:46:"Change your site's URL paths by aliasing them.";s:60:"Modifier les chemins url de votre site en cr\\303\\251ant des alias.";s:12:"File browser";b:1;s:10:"XSS Filter";b:1;s:11:"XSS Filter.";b:1;s:4:"IMCE";b:1;s:42:"Control how your image/file browser works.";b:1;s:9:"FCKeditor";b:1;s:26:"Configure the rich editor.";b:1;s:9:"Save role";s:20:"Enregistrer le r\\303\\264le";s:11:"Delete role";s:18:"Supprimer le r\\303\\264le";s:16:"access fckeditor";b:1;s:20:"administer fckeditor";b:1;s:28:"allow fckeditor file uploads";b:1;s:19:"create page content";b:1;s:20:"create story content";b:1;s:23:"delete any page content";b:1;s:24:"delete any story content";b:1;s:23:"delete own page content";b:1;s:24:"delete own story content";b:1;s:16:"delete revisions";b:1;s:21:"edit any page content";b:1;s:22:"edit any story content";b:1;s:21:"edit own page content";b:1;s:22:"edit own story content";b:1;s:22:"administer url aliases";s:22:"g\\303\\251rer les alias d'url";s:71:"Visitors can create accounts and no administrator approval is required.";s:85:"Les visiteurs peuvent cr\\303\\251er leur propre compte sans approbation de l'administrateur.";s:27:"Switch to plain text editor";b:1;s:26:"Switch to rich text editor";b:1;s:22:"excluding or including";b:1;s:63:"The ID for !excluding this element is: !id - the path is: !path";b:1;s:14:"Create profile";b:1;s:14:"Update profile";b:1;s:21:"Create global profile";b:1;s:21:"Update global profile";b:1;s:18:"FCKeditor settings";b:1;s:8:"Profiles";b:1;s:18:"Create new profile";b:1;s:15:"Global Settings";b:1;s:24:"FCKeditor Global Profile";b:1;s:18:"FCKeditor homepage";b:1;s:19:"FCKeditor userguide";b:1;s:43:"Administer > Site configuration > FCKeditor";b:1;s:42:"Administer > User Management > Permissions";b:1;s:7:"filters";b:1;s:12:"Delete alias";s:18:"Supprimer un alias";s:10:"Edit alias";s:17:"Modifier un alias";s:9:"Add alias";s:16:"Ajouter un alias";s:13:"Image Browser";b:1;s:16:"Web File Manager";b:1;s:19:"separate permission";b:1;s:21:"File browser settings";b:1;s:55:"<li>Lastly, adjust the !fb for each !profile.</li></ol>";b:1;s:10:"administer";b:1;s:9:"fckeditor";b:1;s:25:"Add new FCKeditor profile";b:1;s:11:"Basic setup";b:1;s:12:"Profile name";b:1;s:33:"Roles allowed to use this profile";b:1;s:45:"Allow users to customize FCKeditor appearance";b:1;s:5:"false";b:1;s:4:"true";b:1;s:8:"Security";b:1;s:11:"HTML filter";s:11:"filtre HTML";s:16:"Security filters";b:1;s:49:"Corrects faulty and chopped off HTML in postings.";b:1;s:17:"Security settings";b:1;s:42:"Always run security filters for FCKeditor.";b:1;s:71:"Run security filters only when FCKeditor is set to start automatically.";b:1;s:19:"Visibility settings";b:1;s:12:"Minimum rows";b:1;s:31:"Use inclusion or exclusion mode";b:1;s:7:"exclude";b:1;s:7:"include";b:1;s:25:"Fields to exclude/include";b:1;s:24:"Paths to exclude/include";b:1;s:48:"Force simplified toolbar on the following fields";b:1;s:47:"Force simplified toolbar on the following paths";b:1;s:17:"Editor appearance";b:1;s:13:"Default state";b:1;s:7:"enabled";b:1;s:43:"Show disable/enable rich text editor toggle";b:1;s:31:"Use FCKeditor in a popup window";b:1;s:4:"Skin";b:1;s:22:"Choose a default skin.";b:1;s:7:"Toolbar";b:1;s:26:"Start the toolbar expanded";b:1;s:40:"The toolbar start expanded or collapsed.";b:1;s:5:"Width";b:1;s:43:"Width in pixels or percent. Ex: 400 or 100%";b:1;s:41:"The language for the FCKeditor interface.";b:1;s:20:"Auto-detect language";b:1;s:38:"Use auto detect user language feature.";b:1;s:18:"Cleanup and output";b:1;s:10:"Enter mode";b:1;s:63:"Set which tag FCKeditor should use when [Enter] key is pressed.";b:1;s:18:"Shift + Enter mode";b:1;s:69:"Set which tag FCKeditor should use when [Shift] + [Enter] is pressed.";b:1;s:12:"Font formats";b:1;s:23:"Apply source formatting";b:1;s:13:"Format output";b:1;s:3:"CSS";b:1;s:10:"Editor CSS";b:1;s:13:"use theme css";b:1;s:10:"define css";b:1;s:17:"FCKeditor default";b:1;s:8:"CSS path";b:1;s:17:"Predefined styles";b:1;s:23:"use theme fckstyles.xml";b:1;s:28:"define path to fckstyles.xml";b:1;s:22:"Predefined styles path";b:1;s:4:"None";b:1;s:20:"Built-in filebrowser";b:1;s:17:"File browser type";b:1;s:19:"Allow quick uploads";b:1;s:22:"Path to uploaded files";b:1;s:31:"Absolute path to uploaded files";b:1;s:40:"Load fckeditor.config.js from theme path";b:1;s:31:"Custom javascript configuration";b:1;s:23:"FCKeditor documentation";b:1;s:40:"Your FCKeditor profile has been created.";b:1;s:22:"Edit FCKeditor profile";b:1;s:40:"Your FCKeditor profile has been updated.";b:1;s:10:"Main setup";b:1;s:15:"Role precedence";b:1;s:62:"Here is the id-name pairs of roles having access to FCKeditor:";b:1;s:4:"path";s:6:"chemin";s:15:"Add new profile";b:1;s:22:"Configuration profiles";b:1;s:15:"Common settings";b:1;s:55:"Enable inline image/file insertion into plain textareas";b:1;s:13:"Absolute URLs";b:1;s:52:"Check if you want IMCE to return absolute file URLs.";b:1;s:56:"Default behaviour for existing files during file uploads";b:1;s:43:"Keep the existing file renaming the new one";b:1;s:44:"Keep the existing file rejecting the new one";b:1;s:42:"Replace the existing file with the new one";b:1;s:38:"Default method for creating thumbnails";b:1;s:57:"Scale the image with respect to the thumbnail dimensions.";b:1;s:64:"First scale then crop the image to fit the thumbnail dimensions.";b:1;s:9:"User role";b:1;s:16:"Assigned profile";b:1;s:7:"user #1";b:1;s:24:"Role-profile assignments";b:1;s:30:"Assign profiles to user roles.";b:1;s:23:"Directory creation tool";b:1;s:28:"Give a name to this profile.";b:1;s:35:"Import settings from other profiles";b:1;s:44:"Set to 0 to use the maximum value avaliable.";b:1;s:15:"Directory quota";b:1;s:16:"Total user quota";b:1;s:35:"Set to * to remove the restriction.";b:1;s:24:"Maximum image resolution";b:1;s:12:"WIDTHxHEIGHT";b:1;s:37:"Maximum number of files per operation";b:1;s:24:"Including subdirectories";b:1;s:6:"Browse";b:1;s:10:"Thumbnails";b:1;s:6:"Resize";b:1;s:14:"Directory path";b:1;s:11:"Directories";b:1;s:10:"Dimensions";b:1;s:6:"Prefix";b:1;s:6:"Suffix";b:1;s:16:"File system path";s:29:"Chemin du dossier de stockage";s:24:"Changes have been saved.";b:1;s:17:"Language settings";s:23:"Param\\303\\250tres des langues";s:44:"This account's default language for e-mails.";s:69:"La langue par d\\303\\251faut de ce compte pour les courriers \\303\\251lectroniques.";s:4:"File";b:1;s:17:"Create thumbnails";b:1;s:11:"Upload file";b:1;s:14:"Selected files";b:1;s:14:"Width x Height";b:1;s:18:"Create a new image";b:1;s:4:"Tips";b:1;s:65:"Select a file by clicking the corresponding row in the file list.";b:1;s:60:"Sort the files by clicking a column header of the file list.";b:1;s:74:"Resize the work-spaces by dragging the horizontal or vertical resize-bars.";b:1;s:68:"Keyboard shortcuts for file list: up, down, left, home, end, ctrl+A.";b:1;s:72:"Keyboard shortcuts for directory list: up, down, left, right, home, end.";b:1;s:11:"Limitations";b:1;s:3:"all";b:1;s:9:"File name";b:1;s:4:"Size";b:1;s:6:"Height";b:1;s:15:"unlimited quota";b:1;s:35:"!num files using !dirsize of !quota";b:1;s:9:"Clear log";b:1;s:12:"File Browser";b:1;s:9:"unlimited";b:1;s:57:"Share your thoughts and opinions related to this posting.";s:63:"Partager vos id\\303\\251es et opinions au sujet de cette contribution.";s:52:"%dirname is not accepted as a proper directory name.";b:1;s:18:"Top search phrases";s:29:"Phrases les plus recherch\\303\\251es";s:33:"View most popular search phrases.";s:39:"Voir les phrases les plus recherch\\303\\251es.";s:15:"Search settings";s:24:"Param\\303\\250tres de recherche";s:11:"Clear index";s:13:"Vider l'index";s:11:"Search form";s:23:"Formulaire de recherche";s:17:"administer search";s:24:"administrer la recherche";s:14:"search content";s:26:"rechercher dans le contenu";s:19:"use advanced search";s:30:"utiliser la recherche avanc\\303\\251e";s:16:"Search this site";s:21:"Chercher dans ce site";s:39:"Enter the terms you wish to search for.";s:48:"Saisissez les termes que vous voulez rechercher.";s:7:"results";s:10:"r\\303\\251sultats";s:14:"Search results";s:26:"R\\303\\251sultats de la recherche";s:19:"Enter your keywords";s:21:"Entrez vos mots-cl\\303\\251s";s:66:"Configure relevance settings for search and other indexing options";s:87:"Configurer les crit\\303\\250res de pertinence pour la recherche et d'autres options d'indexage";s:8:"Corsican";s:5:"Corse";s:7:"Frisian";s:7:"Frisian";s:11:"Interlingue";s:11:"Interlingue";s:7:"Kannada";s:7:"Kannada";s:9:"Moldavian";s:7:"Moldave";s:6:"Polish";s:8:"Polonais";s:7:"Sinhala";b:1;s:8:"Albanian";s:8:"Albanais";s:66:"The configuration options have been reset to their default values.";s:85:"Les options de configuration ont \\303\\251t\\303\\251 r\\303\\251initialis\\303\\251es \\303\\240 leurs valeurs par d\\303\\251faut.";s:63:"Create a XML sitemap conforming to sitemaps.org specifications.";s:64:"Cr\\303\\251er un sitemap XML conforme aux sp\\303\\251cifications sitemaps.org.";s:30:"Add node links to the sitemap.";s:38:"Ajouter les liens de noeud au sitemap.";s:39:"Add taxonomy term links to the sitemap.";s:52:"Ajouter les liens de termes de taxonomie au sitemap.";s:38:"Add user profile links to the sitemap.";s:54:"Ajouter les liens des profils utilisateurs au sitemap.";s:49:"Add all the links to the default language sitemap";s:56:"Ajouter tous les liens au sitemap du langage par d\\303\\251faut";s:10:"Cron limit";s:13:"Limit du cron";s:15:"Cache directory";s:20:"R\\303\\251pertoire du cache";s:14:"Use stylesheet";s:29:"Utiliser une feuille de style";s:11:"XML sitemap";s:11:"XML sitemap";s:13:"Sitemap index";s:12:"Index itemap";s:29:"Submit the sitemap to Ask.com";s:31:"Soumettre le sitemap \\303\\240 Ask.com";s:30:"Delete the sitemap cache files";s:29:"Supprimer le cache du sitemap";s:14:"Not in sitemap";s:19:"Pas dans le sitemap";s:18:"Supporting modules";s:20:"Supporte les modules";s:22:"override node settings";s:34:"remplacer les param\\303\\250tres de noeud";s:25:"override profile settings";s:35:"remplacer les param\\303\\250tres de profil";s:26:"Configure the XML sitemap.";s:26:"Configurer le sitemap XML.";s:9:"2000 rows";s:13:"2000 rang\\303\\251es";s:9:"1500 rows";s:13:"1500 rang\\303\\251es";s:9:"1000 rows";s:13:"1000 rang\\303\\251es";s:8:"500 rows";s:12:"500 rang\\303\\251es";s:8:"250 rows";s:12:"250 rang\\303\\251es";s:8:"100 rows";s:12:"100 rang\\303\\251es";s:7:"50 rows";s:11:"50 rang\\303\\251es";s:7:"25 rows";s:11:"25 rang\\303\\251es";s:7:"20 rows";s:11:"20 rang\\303\\251es";s:7:"15 rows";s:11:"15 rang\\303\\251es";s:7:"10 rows";s:11:"10 rang\\303\\251es";s:6:"5 rows";s:10:"5 rang\\303\\251es";s:23:"Do not process via cron";s:26:"Ne pas traiter par le cron";s:41:"Specify a xml stylesheet for the sitemap?";s:53:"Sp\\303\\251cifier une feuille de style xml pour le sitemap ?";s:10:"Front page";s:14:"Page d'accueil";s:27:"Front page change frequency";s:47:"Fr\\303\\251quence de modification de la page d'accueil";s:52:"The change frequency associated with the front page.";s:61:"La fr\\303\\251quence de modification associ\\303\\251e \\303\\240 la page d'accueil.";s:6:"Hourly";s:17:"Toutes les Heures";s:7:"Monthly";s:13:"Mensuellement";s:6:"Yearly";s:12:"Annuellement";s:19:"Front page priority";s:30:"Priorit\\303\\251 de la page d'acceuil";s:41:"The absolute priority for the front page.";s:44:"La priorit\\303\\251 absolue pour la page d'accueil.";s:3:"1.0";s:3:"1.0";s:3:"0.9";s:3:"0.9";s:3:"0.8";s:3:"0.8";s:3:"0.7";s:3:"0.7";s:3:"0.6";s:3:"0.6";s:3:"0.5";s:3:"0.5";s:3:"0.4";s:3:"0.4";s:3:"0.3";s:3:"0.3";s:3:"0.2";s:3:"0.2";s:3:"0.1";s:3:"0.1";s:3:"0.0";s:3:"0.0";s:7:"Sitemap";s:7:"Sitemap";s:5:"Tools";s:6:"Outils";s:14:"Sitemap tools.";s:15:"Outils sitemap.";s:19:"Submission settings";s:25:"Param\\303\\250tres de soumission";s:39:"Submit the sitemap when content changes";s:46:"Soumettre le sitemap lorsque le contenu change";s:31:"Frequency of sitemap submission";s:35:"Fr\\303\\251quence de soumission du sitemap";s:65:"The rate at which the sitemap is submitted to the search engines.";s:73:"La fr\\303\\251quence \\303\\240 laquelle le sitemap est soumis aux moteurs de recherche.";s:14:"Every 6 months";s:15:"Tous les 6 mois";s:13:"Every 15 days";s:17:"Tous les 15 jours";s:5:"Never";s:6:"Jamais";s:7:"Ask.com";s:7:"Ask.com";s:14:"Submission URL";s:17:"URL de soumission";s:36:"Flag the sitemap as requiring update";s:54:"Marquer le sitemap comme n\\303\\251cessitant une mise \\303\\240 jour";s:5:"Apply";s:9:"Appliquer";s:10:"xmlsitemap";s:10:"xmlsitemap";s:37:"Submit the sitemap to search engines.";s:46:"Soumettre le sitemap aux moteurs de recherche.";s:34:"Submit the sitemap to Moreover.com";s:36:"Soumettre le sitemap \\303\\240 Moreover.com";s:28:"Submit the sitemap to Yahoo!";s:30:"Soumettre le sitemap \\303\\240 Yahoo!";s:74:"Yahoo! will ask you to put an authentication key in the verification file.";s:93:"Yahoo! vous demandera de mettre une cl\\303\\251 d'authentification dans le fichier de v\\303\\251rification.";s:51:"Submit the sitemap to all the active search engines";s:60:"Soumettre le sitemap \\303\\240 tous les moteurs de recherche actifs";s:34:"The default priority is %priority.";s:39:"La priorit\\303\\251 par d\\303\\251faut est %priority.";s:16:"XML sitemap node";s:16:"XML sitemap node";s:33:"Comment ratio priority adjustment";s:47:"Ajustement de priorit\\303\\251 de ratio de commentaire";s:14:"Search engines";s:20:"Moteurs de recherche";s:41:"Add the selected posts to the XML sitemap";s:50:"Ajouter les contenus s\\303\\251lectionn\\303\\251s au sitemap XML";s:13:"Node settings";s:22:"Param\\303\\250tres des noeuds";s:53:"The settings for the nodes to include in the sitemap.";s:54:"Les param\\303\\250tres des noeuds \\303\\240 inclure dans le sitemap.";s:29:"Promotion priority adjustment";s:36:"Ajustement de priorit\\303\\251 de promotion";s:28:"Submit the sitemap to Google";s:30:"Soumettre le sitemap \\303\\240 Google";s:17:"Verification link";s:21:"Lien de v\\303\\251rification";s:12:"Moreover.com";s:12:"Moreover.com";s:27:"Bing (formerly Live Search)";s:31:"Bing (anciennement Live Search)";s:26:"Submit the sitemap to Bing";s:28:"Soumettre le sitemap \\303\\240 Bing";s:19:"Authentication file";s:26:"Fichier d'authentification";s:23:"Bing authentication tag";s:33:"Etiquette d'authentification Bing";s:41:"Bing will give you an authentication tag.";s:53:"Bing vous fournira une \\303\\251tiquette d'authentification.";s:6:"Yahoo!";s:6:"Yahoo!";s:18:"Authentication key";s:23:"Cl\\303\\251 d'authentification";s:8:"Priority";s:9:"Priorit\\303\\251";s:64:"Change the XML sitemap priority of the selected posts to default";s:86:"Modifier la priorit\\303\\251 XML sitemap des contenus s\\303\\251lectionn\\303\\251s \\303\\240 la valeur par d\\303\\251faut";s:46:"Remove the selected posts from the XML sitemap";s:52:"Supprimer les contenus s\\303\\251lectionn\\303\\251s du sitemap XML";s:20:"XML sitemap taxonomy";s:20:"XML sitemap taxonomy";s:16:"XML sitemap user";s:16:"XML sitemap user";s:6:"Google";s:6:"Google";s:66:"@count translation files imported for the newly installed modules.";s:91:"@count fichiers de traduction ont \\303\\251t\\303\\251 import\\303\\251s pour les modules nouvellement install\\303\\251s.";s:58:"The sitemap is located at <a href="@sitemap">@sitemap</a>.";s:76:"Le plan du site est accessible \\303\\240 l'adresse <a href="@sitemap">@sitemap</a>.";}	0	1250500124		1
variables	a:75:{s:13:"theme_default";s:7:"garland";s:13:"filter_html_1";i:1;s:18:"node_options_forum";a:1:{i:0;s:6:"status";}s:9:"clean_url";s:1:"1";s:18:"drupal_private_key";s:64:"8d650c188b062554cf10c18a324edd3436e1d717930a7da25b9f138baf58ab56";s:13:"menu_expanded";a:0:{}s:19:"file_directory_temp";s:15:"c:\\\\windows\\\\temp";s:14:"language_count";i:2;s:17:"update_last_check";i:1248699224;s:25:"drupal_http_request_fails";b:0;s:10:"menu_masks";a:17:{i:0;i:62;i:1;i:61;i:2;i:59;i:3;i:31;i:4;i:30;i:5;i:29;i:6;i:24;i:7;i:21;i:8;i:15;i:9;i:14;i:10;i:11;i:11;i:7;i:12;i:6;i:13;i:5;i:14;i:3;i:15;i:2;i:16;i:1;}s:16:"language_default";O:8:"stdClass":11:{s:8:"language";s:2:"fr";s:4:"name";s:6:"French";s:6:"native";s:9:"Fran\\303\\247ais";s:9:"direction";s:1:"0";s:7:"enabled";s:1:"1";s:7:"plurals";s:1:"2";s:7:"formula";s:6:"($n>1)";s:6:"domain";s:0:"";s:6:"prefix";s:2:"fr";s:6:"weight";s:1:"0";s:10:"javascript";s:32:"b4513796a6eeb16def9d1cd7615f8cd1";}s:14:"theme_settings";a:18:{s:11:"toggle_logo";i:1;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:0;s:14:"toggle_mission";i:1;s:24:"toggle_node_user_picture";i:0;s:27:"toggle_comment_user_picture";i:0;s:13:"toggle_search";i:0;s:14:"toggle_favicon";i:1;s:20:"toggle_primary_links";i:1;s:22:"toggle_secondary_links";i:1;s:22:"toggle_node_info_story";i:1;s:21:"toggle_node_info_page";i:0;s:12:"default_logo";i:0;s:9:"logo_path";s:41:"../res/img/logo_iri_transparent_petit.png";s:11:"logo_upload";s:0:"";s:15:"default_favicon";i:0;s:12:"favicon_path";s:22:"../res/img/favicon.ico";s:14:"favicon_upload";s:0:"";}s:17:"javascript_parsed";a:18:{i:0;s:14:"misc/jquery.js";i:1;s:14:"misc/drupal.js";i:2;s:16:"misc/progress.js";i:3;s:13:"misc/batch.js";i:4;s:19:"misc/tableheader.js";i:5;s:16:"misc/collapse.js";i:6;s:40:"modules/fckeditor/fckeditor/fckeditor.js";i:7;s:36:"modules/fckeditor/fckeditor.utils.js";i:8;s:20:"misc/autocomplete.js";i:9;s:14:"misc/teaser.js";i:10;s:16:"misc/textarea.js";i:11;s:17:"misc/tabledrag.js";i:12;s:22:"modules/block/block.js";i:13;s:12:"misc/form.js";i:14;s:19:"misc/tableselect.js";i:15;s:19:"misc/jquery.form.js";i:16;s:23:"modules/imce/js/imce.js";i:17;s:30:"modules/imce/js/imce_extras.js";}s:9:"site_name";s:37:"Institut de recherche et d'innovation";s:9:"site_mail";s:33:"thibaut.cavalie@centrepompidou.fr";s:21:"date_default_timezone";s:4:"7200";s:23:"user_email_verification";b:1;s:12:"install_time";i:1247828945;s:17:"node_options_page";a:1:{i:0;s:6:"status";}s:12:"comment_page";i:0;s:15:"install_profile";s:7:"default";s:12:"install_task";s:4:"done";s:19:"css_js_query_string";s:20:"rK000000000000000000";s:19:"file_directory_path";s:3:"res";s:14:"file_downloads";s:1:"1";s:21:"filter_default_format";s:1:"2";s:19:"imce_roles_profiles";a:3:{i:3;a:1:{s:3:"pid";s:1:"1";}i:2;a:1:{s:3:"pid";s:1:"0";}i:1;a:1:{s:3:"pid";s:1:"0";}}s:22:"imce_settings_textarea";s:0:"";s:21:"imce_settings_absurls";i:0;s:21:"imce_settings_replace";s:1:"0";s:26:"imce_settings_thumb_method";s:14:"scale_and_crop";s:13:"imce_profiles";a:2:{i:1;a:9:{s:4:"name";s:6:"User-1";s:8:"filesize";s:1:"0";s:5:"quota";s:1:"0";s:7:"tuquota";s:1:"0";s:10:"extensions";s:1:"*";s:10:"dimensions";s:9:"1200x1200";s:7:"filenum";s:1:"0";s:11:"directories";a:3:{i:0;a:7:{s:4:"name";s:1:".";s:6:"subnav";i:1;s:6:"browse";i:1;s:6:"upload";i:1;s:5:"thumb";i:1;s:6:"delete";i:1;s:6:"resize";i:1;}i:1;a:7:{s:4:"name";s:3:"img";s:6:"subnav";i:1;s:6:"browse";i:1;s:6:"upload";i:1;s:5:"thumb";i:1;s:6:"delete";i:1;s:6:"resize";i:1;}i:2;a:7:{s:4:"name";s:5:"media";s:6:"subnav";i:1;s:6:"browse";i:1;s:6:"upload";i:1;s:5:"thumb";i:1;s:6:"delete";i:1;s:6:"resize";i:1;}}s:10:"thumbnails";a:3:{i:0;a:4:{s:4:"name";s:5:"Small";s:10:"dimensions";s:5:"90x90";s:6:"prefix";s:6:"small_";s:6:"suffix";s:0:"";}i:1;a:4:{s:4:"name";s:6:"Medium";s:10:"dimensions";s:7:"120x120";s:6:"prefix";s:7:"medium_";s:6:"suffix";s:0:"";}i:2;a:4:{s:4:"name";s:5:"Large";s:10:"dimensions";s:7:"180x180";s:6:"prefix";s:6:"large_";s:6:"suffix";s:0:"";}}}i:2;a:9:{s:4:"name";s:14:"Sample profile";s:8:"filesize";i:1;s:5:"quota";i:2;s:7:"tuquota";i:0;s:10:"extensions";s:16:"gif png jpg jpeg";s:10:"dimensions";s:7:"800x600";s:7:"filenum";i:1;s:11:"directories";a:1:{i:0;a:7:{s:4:"name";s:5:"u%uid";s:6:"subnav";i:0;s:6:"browse";i:1;s:6:"upload";i:1;s:5:"thumb";i:1;s:6:"delete";i:0;s:6:"resize";i:0;}}s:10:"thumbnails";a:1:{i:0;a:4:{s:4:"name";s:5:"Thumb";s:10:"dimensions";s:5:"90x90";s:6:"prefix";s:6:"thumb_";s:6:"suffix";s:0:"";}}}}s:14:"node_cron_last";s:10:"1248698533";s:24:"node_cron_comments_scale";d:1;s:21:"node_cron_views_scale";d:1;s:9:"cron_last";i:1248699224;s:21:"color_garland_palette";a:5:{s:4:"base";s:7:"#788597";s:4:"link";s:7:"#3f728d";s:3:"top";s:7:"#c4c6cf";s:6:"bottom";s:7:"#e6e5e5";s:4:"text";s:7:"#707070";}s:18:"color_garland_logo";s:35:"res/color/garland-5d26e3f9/logo.png";s:24:"color_garland_screenshot";s:41:"res/color/garland-5d26e3f9/screenshot.png";s:25:"color_garland_stylesheets";a:2:{i:0;s:36:"res/color/garland-5d26e3f9/style.css";i:1;s:40:"res/color/garland-5d26e3f9/style-rtl.css";}s:19:"color_garland_files";a:19:{i:0;s:45:"res/color/garland-5d26e3f9/menu-collapsed.gif";i:1;s:49:"res/color/garland-5d26e3f9/menu-collapsed-rtl.gif";i:2;s:44:"res/color/garland-5d26e3f9/menu-expanded.gif";i:3;s:40:"res/color/garland-5d26e3f9/menu-leaf.gif";i:4;s:35:"res/color/garland-5d26e3f9/body.png";i:5;s:37:"res/color/garland-5d26e3f9/bg-bar.png";i:6;s:43:"res/color/garland-5d26e3f9/bg-bar-white.png";i:7;s:37:"res/color/garland-5d26e3f9/bg-tab.png";i:8;s:44:"res/color/garland-5d26e3f9/bg-navigation.png";i:9;s:46:"res/color/garland-5d26e3f9/bg-content-left.png";i:10;s:47:"res/color/garland-5d26e3f9/bg-content-right.png";i:11;s:41:"res/color/garland-5d26e3f9/bg-content.png";i:12;s:49:"res/color/garland-5d26e3f9/bg-navigation-item.png";i:13;s:55:"res/color/garland-5d26e3f9/bg-navigation-item-hover.png";i:14;s:45:"res/color/garland-5d26e3f9/gradient-inner.png";i:15;s:35:"res/color/garland-5d26e3f9/logo.png";i:16;s:41:"res/color/garland-5d26e3f9/screenshot.png";i:17;s:36:"res/color/garland-5d26e3f9/style.css";i:18;s:40:"res/color/garland-5d26e3f9/style-rtl.css";}s:21:"xmlsitemap_chunk_size";i:1000;s:22:"theme_garland_settings";a:20:{s:11:"toggle_logo";i:1;s:11:"toggle_name";i:0;s:13:"toggle_slogan";i:0;s:14:"toggle_mission";i:1;s:24:"toggle_node_user_picture";i:0;s:27:"toggle_comment_user_picture";i:0;s:13:"toggle_search";i:0;s:14:"toggle_favicon";i:1;s:20:"toggle_primary_links";i:1;s:22:"toggle_secondary_links";i:1;s:12:"default_logo";i:0;s:9:"logo_path";s:41:"../res/img/logo_iri_transparent_petit.png";s:11:"logo_upload";s:0:"";s:15:"default_favicon";i:0;s:12:"favicon_path";s:22:"../res/img/favicon.ico";s:14:"favicon_upload";s:0:"";s:6:"scheme";s:0:"";s:7:"palette";a:5:{s:4:"base";s:7:"#788597";s:4:"link";s:7:"#3f728d";s:3:"top";s:7:"#c4c6cf";s:6:"bottom";s:7:"#e6e5e5";s:4:"text";s:7:"#707070";}s:5:"theme";s:7:"garland";s:4:"info";a:10:{s:7:"schemes";a:16:{s:39:"#0072b9,#027ac6,#2385c2,#5ab5ee,#494949";s:25:"Blue Lagoon (par d\\303\\251faut)";s:39:"#464849,#2f416f,#2a2b2d,#5d6779,#494949";s:6:"Cendre";s:39:"#55c0e2,#000000,#085360,#007e94,#696969";s:12:"Aigue-marine";s:39:"#d5b048,#6c420e,#331900,#971702,#494949";s:14:"Chocolat belge";s:39:"#3f3f3f,#336699,#6598cb,#6598cb,#000000";s:11:"Bleu marine";s:39:"#d0cb9a,#917803,#efde01,#e6fb2d,#494949";s:18:"Explosion d'agrume";s:39:"#0f005c,#434f8c,#4d91ff,#1a1575,#000000";s:15:"Froide journ\\303\\251e";s:39:"#c9c497,#0c7a00,#03961e,#7be000,#494949";s:10:"Rayon vert";s:39:"#ffe23d,#a9290a,#fc6d1d,#a30f42,#494949";s:11:"Mediterrano";s:39:"#788597,#3f728d,#a9adbc,#d4d4d4,#707070";s:7:"Mercure";s:39:"#5b5fa9,#5b5faa,#0a2352,#9fa8d5,#494949";s:8:"Nocturne";s:39:"#7db323,#6a9915,#b5d52a,#7db323,#191a19";s:6:"Olivia";s:39:"#12020b,#1b1a13,#f391c6,#f41063,#898080";s:14:"Plastique rose";s:39:"#b7a0ba,#c70000,#a1443a,#f21107,#515d52";s:16:"Tomate brillante";s:39:"#18583d,#1b5f42,#34775a,#52bf90,#2d2d2d";s:13:"Bleu sarcelle";s:0:"";s:13:"Personnalis\\303\\251";}s:4:"copy";a:4:{i:0;s:25:"images/menu-collapsed.gif";i:1;s:29:"images/menu-collapsed-rtl.gif";i:2;s:24:"images/menu-expanded.gif";i:3;s:20:"images/menu-leaf.gif";}s:3:"css";a:1:{i:0;s:9:"style.css";}s:8:"gradient";a:4:{i:0;i:0;i:1;i:37;i:2;i:760;i:3;i:121;}s:4:"fill";a:2:{s:4:"base";a:4:{i:0;i:0;i:1;i:0;i:2;i:760;i:3;i:568;}s:4:"link";a:4:{i:0;i:107;i:1;i:533;i:2;i:41;i:3;i:23;}}s:6:"slices";a:13:{s:15:"images/body.png";a:4:{i:0;i:0;i:1;i:37;i:2;i:1;i:3;i:280;}s:17:"images/bg-bar.png";a:4:{i:0;i:202;i:1;i:530;i:2;i:76;i:3;i:14;}s:23:"images/bg-bar-white.png";a:4:{i:0;i:202;i:1;i:506;i:2;i:76;i:3;i:14;}s:17:"images/bg-tab.png";a:4:{i:0;i:107;i:1;i:533;i:2;i:41;i:3;i:23;}s:24:"images/bg-navigation.png";a:4:{i:0;i:0;i:1;i:0;i:2;i:7;i:3;i:37;}s:26:"images/bg-content-left.png";a:4:{i:0;i:40;i:1;i:117;i:2;i:50;i:3;i:352;}s:27:"images/bg-content-right.png";a:4:{i:0;i:510;i:1;i:117;i:2;i:50;i:3;i:352;}s:21:"images/bg-content.png";a:4:{i:0;i:299;i:1;i:117;i:2;i:7;i:3;i:200;}s:29:"images/bg-navigation-item.png";a:4:{i:0;i:32;i:1;i:37;i:2;i:17;i:3;i:12;}s:35:"images/bg-navigation-item-hover.png";a:4:{i:0;i:54;i:1;i:37;i:2;i:17;i:3;i:12;}s:25:"images/gradient-inner.png";a:4:{i:0;i:646;i:1;i:307;i:2;i:112;i:3;i:42;}s:8:"logo.png";a:4:{i:0;i:622;i:1;i:51;i:2;i:64;i:3;i:73;}s:14:"screenshot.png";a:4:{i:0;i:0;i:1;i:37;i:2;i:400;i:3;i:240;}}s:12:"blend_target";s:7:"#ffffff";s:13:"preview_image";s:17:"color/preview.png";s:11:"preview_css";s:17:"color/preview.css";s:10:"base_image";s:14:"color/base.png";}}s:33:"xmlsitemap_create_cache_result_fr";b:1;s:40:"xmlsitemap_all_links_to_default_language";i:1;s:21:"xmlsitemap_cron_limit";s:3:"100";s:26:"xmlsitemap_cache_directory";s:14:"res/xmlsitemap";s:25:"xmlsitemap_use_stylesheet";i:0;s:32:"xmlsitemap_front_page_changefreq";s:6:"604800";s:30:"xmlsitemap_front_page_priority";s:1:"1";s:32:"xmlsitemap_node_promote_priority";s:3:"0.3";s:32:"xmlsitemap_node_comment_priority";s:3:"0.2";s:40:"xmlsitemap_engines_cron_timestamp_submit";i:1248699057;s:32:"xmlsitemap_previous_chunks_count";d:0.001000000000000000020816681711721685132943093776702880859375;s:27:"xmlsitemap_update_timestamp";i:1248699222;s:25:"xmlsitemap_engines_submit";i:0;s:40:"xmlsitemap_engines_cron_submit_frequency";s:6:"604800";s:29:"xmlsitemap_engines_ask_submit";i:0;s:26:"xmlsitemap_engines_ask_url";s:49:"http://submissions.ask.com/ping?sitemap=[sitemap]";s:32:"xmlsitemap_engines_google_submit";i:0;s:29:"xmlsitemap_engines_google_url";s:61:"http://www.google.com/webmasters/tools/ping?sitemap=[sitemap]";s:32:"xmlsitemap_engines_google_verify";s:0:"";s:34:"xmlsitemap_engines_moreover_submit";i:0;s:31:"xmlsitemap_engines_moreover_url";s:40:"http://api.moreover.com/ping?u=[sitemap]";s:30:"xmlsitemap_engines_bing_submit";i:0;s:27:"xmlsitemap_engines_bing_url";s:57:"http://www.bing.com/webmaster/ping.aspx?siteMap=[sitemap]";s:30:"xmlsitemap_engines_bing_verify";s:0:"";s:37:"xmlsitemap_engines_bing_verify_string";s:0:"";s:31:"xmlsitemap_engines_yahoo_submit";i:0;s:28:"xmlsitemap_engines_yahoo_url";s:73:"http://search.yahooapis.com/SiteExplorerService/V1/ping?sitemap=[sitemap]";s:31:"xmlsitemap_engines_yahoo_verify";s:0:"";s:38:"xmlsitemap_engines_yahoo_verify_string";s:0:"";s:29:"xmlsitemap_sitemap_is_changed";b:1;s:31:"xmlsitemap_sitemap_needs_update";b:1;}	0	1250867119		1
schema	a:60:{s:6:"blocks";a:7:{s:11:"description";s:62:"Stores block settings, such as region and visibility settings.";s:6:"fields";a:13:{s:3:"bid";a:3:{s:4:"type";s:6:"serial";s:8:"not null";b:1;s:11:"description";s:29:"Primary Key: Unique block ID.";}s:6:"module";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:126:"The module from which the block originates; for example, 'user' for the Who's Online block, and 'block' for any custom blocks.";}s:5:"delta";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:1:"0";s:11:"description";s:36:"Unique ID for block within a module.";}s:5:"theme";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:47:"The theme under which the block settings apply.";}s:6:"status";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:49:"Block enabled status. (1 = enabled, 0 = disabled)";}s:6:"weight";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:27:"Block weight within region.";}s:6:"region";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:43:"Theme region within which the block is set.";}s:6:"custom";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:169:"Flag to indicate how users may control visibility of the block. (0 = Users cannot control, 1 = On by default, but can be hidden, 2 = Hidden by default, but can be shown)";}s:8:"throttle";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:113:"Flag to indicate whether or not to remove block when website traffic is high. (1 = throttle, 0 = do not throttle)";}s:10:"visibility";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:169:"Flag to indicate how to show blocks on pages. (0 = Show on all pages except listed pages, 1 = Show only on listed pages, 2 = Use custom PHP code to determine visibility)";}s:5:"pages";a:3:{s:4:"type";s:4:"text";s:8:"not null";b:1;s:11:"description";s:148:"Contents of the "Pages" block; contains either a list of paths on which to include/exclude the block or PHP code, depending on "visibility" setting.";}s:5:"title";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:154:"Custom title for the block. (Empty string will use block default title, &lt;none&gt; will remove the title, text will cause block to use specified title.)";}s:5:"cache";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:1;s:4:"size";s:4:"tiny";s:11:"description";s:215:"Binary flag to indicate block cache mode. (-1: Do not cache, 1: Cache per role, 2: Cache per user, 4: Cache per page, 8: Block cache global) See BLOCK_CACHE_* constants in block.module for more detailed information.";}}s:11:"primary key";a:1:{i:0;s:3:"bid";}s:11:"unique keys";a:1:{s:3:"tmd";a:3:{i:0;s:5:"theme";i:1;s:6:"module";i:2;s:5:"delta";}}s:7:"indexes";a:1:{s:4:"list";a:5:{i:0;s:5:"theme";i:1;s:6:"status";i:2;s:6:"region";i:3;s:6:"weight";i:4;s:6:"module";}}s:6:"module";s:5:"block";s:4:"name";s:6:"blocks";}s:12:"blocks_roles";a:6:{s:11:"description";s:57:"Sets up access permissions for blocks based on user roles";s:6:"fields";a:3:{s:6:"module";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:1;s:11:"description";s:48:"The block's origin module, from {blocks}.module.";}s:5:"delta";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:8:"not null";b:1;s:11:"description";s:60:"The block's unique delta within module, from {blocks}.delta.";}s:3:"rid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:42:"The user's role ID from {users_roles}.rid.";}}s:11:"primary key";a:3:{i:0;s:6:"module";i:1;s:5:"delta";i:2;s:3:"rid";}s:7:"indexes";a:1:{s:3:"rid";a:1:{i:0;s:3:"rid";}}s:6:"module";s:5:"block";s:4:"name";s:12:"blocks_roles";}s:5:"boxes";a:6:{s:11:"description";s:38:"Stores contents of custom-made blocks.";s:6:"fields";a:4:{s:3:"bid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:25:"The block's {blocks}.bid.";}s:4:"body";a:4:{s:4:"type";s:4:"text";s:8:"not null";b:0;s:4:"size";s:3:"big";s:11:"description";s:15:"Block contents.";}s:4:"info";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:18:"Block description.";}s:6:"format";a:5:{s:4:"type";s:3:"int";s:4:"size";s:5:"small";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:69:"Block body's {filter_formats}.format; for example, 1 = Filtered HTML.";}}s:11:"unique keys";a:1:{s:4:"info";a:1:{i:0;s:4:"info";}}s:11:"primary key";a:1:{i:0;s:3:"bid";}s:6:"module";s:5:"block";s:4:"name";s:5:"boxes";}s:11:"cache_block";a:6:{s:11:"description";s:204:"Cache table for the Block module to store already built blocks, identified by module, delta, and various contexts which may change the block, such as theme, locale, and caching mode defined for the block.";s:6:"fields";a:6:{s:3:"cid";a:5:{s:11:"description";s:29:"Primary Key: Unique cache ID.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:4:"data";a:4:{s:11:"description";s:30:"A collection of data to cache.";s:4:"type";s:4:"blob";s:8:"not null";b:0;s:4:"size";s:3:"big";}s:6:"expire";a:4:{s:11:"description";s:79:"A Unix timestamp indicating when the cache entry should expire, or 0 for never.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"created";a:4:{s:11:"description";s:61:"A Unix timestamp indicating when the cache entry was created.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"headers";a:3:{s:11:"description";s:51:"Any custom HTTP headers to be added to cached data.";s:4:"type";s:4:"text";s:8:"not null";b:0;}s:10:"serialized";a:5:{s:11:"description";s:64:"A flag to indicate whether content is serialized (1) or not (0).";s:4:"type";s:3:"int";s:4:"size";s:5:"small";s:8:"not null";b:1;s:7:"default";i:0;}}s:7:"indexes";a:1:{s:6:"expire";a:1:{i:0;s:6:"expire";}}s:11:"primary key";a:1:{i:0;s:3:"cid";}s:6:"module";s:5:"block";s:4:"name";s:11:"cache_block";}s:8:"comments";a:6:{s:11:"description";s:36:"Stores comments and associated data.";s:6:"fields";a:14:{s:3:"cid";a:3:{s:4:"type";s:6:"serial";s:8:"not null";b:1;s:11:"description";s:31:"Primary Key: Unique comment ID.";}s:3:"pid";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:117:"The {comments}.cid to which this comment is a reply. If set to 0, this comment is not a reply to an existing comment.";}s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:48:"The {node}.nid to which this comment is a reply.";}s:3:"uid";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:101:"The {users}.uid who authored the comment. If set to 0, this comment was created by an anonymous user.";}s:7:"subject";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:18:"The comment title.";}s:7:"comment";a:4:{s:4:"type";s:4:"text";s:8:"not null";b:1;s:4:"size";s:3:"big";s:11:"description";s:17:"The comment body.";}s:8:"hostname";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:23:"The author's host name.";}s:9:"timestamp";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:89:"The time that the comment was created, or last edited by its author, as a Unix timestamp.";}s:6:"status";a:6:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:69:"The published status of a comment. (0 = Published, 1 = Not Published)";}s:6:"format";a:5:{s:4:"type";s:3:"int";s:4:"size";s:5:"small";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:48:"The {filter_formats}.format of the comment body.";}s:6:"thread";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:11:"description";s:62:"The vancode representation of the comment's place in a thread.";}s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:60;s:8:"not null";b:0;s:11:"description";s:124:"The comment author's name. Uses {users}.name if the user is logged in, otherwise uses the value typed into the comment form.";}s:4:"mail";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:0;s:11:"description";s:169:"The comment author's e-mail address from the comment form, if user is anonymous, and the 'Anonymous users may/must leave their contact information' setting is turned on.";}s:8:"homepage";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;s:11:"description";s:172:"The comment author's home page address from the comment form, if user is anonymous, and the 'Anonymous users may/must leave their contact information' setting is turned on.";}}s:7:"indexes";a:3:{s:3:"pid";a:1:{i:0;s:3:"pid";}s:3:"nid";a:1:{i:0;s:3:"nid";}s:6:"status";a:1:{i:0;s:6:"status";}}s:11:"primary key";a:1:{i:0;s:3:"cid";}s:6:"module";s:7:"comment";s:4:"name";s:8:"comments";}s:23:"node_comment_statistics";a:6:{s:11:"description";s:82:"Maintains statistics of node and comments posts to show "new" and "updated" flags.";s:6:"fields";a:5:{s:3:"nid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:53:"The {node}.nid for which the statistics are compiled.";}s:22:"last_comment_timestamp";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:99:"The Unix timestamp of the last comment that was posted within this node, from {comments}.timestamp.";}s:17:"last_comment_name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:60;s:8:"not null";b:0;s:11:"description";s:83:"The name of the latest author to post a comment on this node, from {comments}.name.";}s:16:"last_comment_uid";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:85:"The user ID of the latest author to post a comment on this node, from {comments}.uid.";}s:13:"comment_count";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:42:"The total number of comments on this node.";}}s:11:"primary key";a:1:{i:0;s:3:"nid";}s:7:"indexes";a:1:{s:22:"node_comment_timestamp";a:1:{i:0;s:22:"last_comment_timestamp";}}s:6:"module";s:7:"comment";s:4:"name";s:23:"node_comment_statistics";}s:8:"watchdog";a:6:{s:11:"description";s:46:"Table that contains logs of all system events.";s:6:"fields";a:11:{s:3:"wid";a:3:{s:4:"type";s:6:"serial";s:8:"not null";b:1;s:11:"description";s:38:"Primary Key: Unique watchdog event ID.";}s:3:"uid";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:52:"The {users}.uid of the user who triggered the event.";}s:4:"type";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:16;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:60:"Type of log message, for example "user" or "page not found."";}s:7:"message";a:4:{s:4:"type";s:4:"text";s:8:"not null";b:1;s:4:"size";s:3:"big";s:11:"description";s:55:"Text of log message to be passed into the t() function.";}s:9:"variables";a:4:{s:4:"type";s:4:"text";s:8:"not null";b:1;s:4:"size";s:3:"big";s:11:"description";s:101:"Serialized array of variables that match the message string and that is passed into the t() function.";}s:8:"severity";a:6:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:71:"The severity level of the event; ranges from 0 (Emergency) to 7 (Debug)";}s:4:"link";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"Link to view the result of the event.";}s:8:"location";a:3:{s:4:"type";s:4:"text";s:8:"not null";b:1;s:11:"description";s:31:"URL of the origin of the event.";}s:7:"referer";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:22:"URL of referring page.";}s:8:"hostname";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:45:"Hostname of the user who triggered the event.";}s:9:"timestamp";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:38:"Unix timestamp of when event occurred.";}}s:11:"primary key";a:1:{i:0;s:3:"wid";}s:7:"indexes";a:1:{s:4:"type";a:1:{i:0;s:4:"type";}}s:6:"module";s:5:"dblog";s:4:"name";s:8:"watchdog";}s:18:"fckeditor_settings";a:5:{s:11:"description";s:33:"Stores FCKeditor profile settings";s:6:"fields";a:2:{s:4:"name";a:5:{s:4:"type";s:7:"varchar";s:8:"not null";b:1;s:7:"default";s:0:"";s:6:"length";i:128;s:11:"description";s:29:"Name of the FCKeditor profile";}s:8:"settings";a:2:{s:4:"type";s:4:"text";s:11:"description";s:16:"Profile settings";}}s:11:"primary key";a:1:{i:0;s:4:"name";}s:6:"module";s:9:"fckeditor";s:4:"name";s:18:"fckeditor_settings";}s:14:"fckeditor_role";a:5:{s:11:"description";s:36:"Stores FCKeditor profile assignments";s:6:"fields";a:2:{s:4:"name";a:5:{s:4:"type";s:7:"varchar";s:8:"not null";b:1;s:7:"default";s:0:"";s:6:"length";i:128;s:11:"description";s:26:"Name of the FCKeditor role";}s:3:"rid";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:14:"Drupal role id";}}s:11:"primary key";a:2:{i:0;s:4:"name";i:1;s:3:"rid";}s:6:"module";s:9:"fckeditor";s:4:"name";s:14:"fckeditor_role";}s:7:"filters";a:7:{s:11:"description";s:74:"Table that maps filters (HTML corrector) to input formats (Filtered HTML).";s:6:"fields";a:5:{s:3:"fid";a:3:{s:4:"type";s:6:"serial";s:8:"not null";b:1;s:11:"description";s:41:"Primary Key: Auto-incrementing filter ID.";}s:6:"format";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:74:"Foreign key: The {filter_formats}.format to which this filter is assigned.";}s:6:"module";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:32:"The origin module of the filter.";}s:5:"delta";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:62:"ID to identify which filter within module is being referenced.";}s:6:"weight";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:31:"Weight of filter within format.";}}s:11:"primary key";a:1:{i:0;s:3:"fid";}s:11:"unique keys";a:1:{s:3:"fmd";a:3:{i:0;s:6:"format";i:1;s:6:"module";i:2;s:5:"delta";}}s:7:"indexes";a:1:{s:4:"list";a:4:{i:0;s:6:"format";i:1;s:6:"weight";i:2;s:6:"module";i:3;s:5:"delta";}}s:6:"module";s:6:"filter";s:4:"name";s:7:"filters";}s:14:"filter_formats";a:6:{s:11:"description";s:73:"Stores input formats: custom groupings of filters, such as Filtered HTML.";s:6:"fields";a:4:{s:6:"format";a:3:{s:4:"type";s:6:"serial";s:8:"not null";b:1;s:11:"description";s:34:"Primary Key: Unique ID for format.";}s:4:"name";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:41:"Name of the input format (Filtered HTML).";}s:5:"roles";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:57:"A comma-separated string of roles; references {role}.rid.";}s:5:"cache";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:77:"Flag to indicate whether format is cachable. (1 = cachable, 0 = not cachable)";}}s:11:"primary key";a:1:{i:0;s:6:"format";}s:11:"unique keys";a:1:{s:4:"name";a:1:{i:0;s:4:"name";}}s:6:"module";s:6:"filter";s:4:"name";s:14:"filter_formats";}s:12:"cache_filter";a:6:{s:11:"description";s:128:"Cache table for the Filter module to store already filtered pieces of text, identified by input format and md5 hash of the text.";s:6:"fields";a:6:{s:3:"cid";a:5:{s:11:"description";s:29:"Primary Key: Unique cache ID.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:4:"data";a:4:{s:11:"description";s:30:"A collection of data to cache.";s:4:"type";s:4:"blob";s:8:"not null";b:0;s:4:"size";s:3:"big";}s:6:"expire";a:4:{s:11:"description";s:79:"A Unix timestamp indicating when the cache entry should expire, or 0 for never.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"created";a:4:{s:11:"description";s:61:"A Unix timestamp indicating when the cache entry was created.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"headers";a:3:{s:11:"description";s:51:"Any custom HTTP headers to be added to cached data.";s:4:"type";s:4:"text";s:8:"not null";b:0;}s:10:"serialized";a:5:{s:11:"description";s:64:"A flag to indicate whether content is serialized (1) or not (0).";s:4:"type";s:3:"int";s:4:"size";s:5:"small";s:8:"not null";b:1;s:7:"default";i:0;}}s:7:"indexes";a:1:{s:6:"expire";a:1:{i:0;s:6:"expire";}}s:11:"primary key";a:1:{i:0;s:3:"cid";}s:6:"module";s:6:"filter";s:4:"name";s:12:"cache_filter";}s:9:"languages";a:6:{s:11:"description";s:46:"List of all available languages in the system.";s:6:"fields";a:11:{s:8:"language";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:12;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:36:"Language code, e.g. 'de' or 'en-US'.";}s:4:"name";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:25:"Language name in English.";}s:6:"native";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:21:"Native language name.";}s:9:"direction";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:61:"Direction of language (Left-to-Right = 0, Right-to-Left = 1).";}s:7:"enabled";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:41:"Enabled flag (1 = Enabled, 0 = Disabled).";}s:7:"plurals";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:42:"Number of plural indexes in this language.";}s:7:"formula";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:61:"Plural formula in PHP code to evaluate to get plural indexes.";}s:6:"domain";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:32:"Domain to use for this language.";}s:6:"prefix";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"Path prefix to use for this language.";}s:6:"weight";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:35:"Weight, used in lists of languages.";}s:10:"javascript";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:40:"Location of JavaScript translation file.";}}s:11:"primary key";a:1:{i:0;s:8:"language";}s:7:"indexes";a:1:{s:4:"list";a:2:{i:0;s:6:"weight";i:1;s:4:"name";}}s:6:"module";s:6:"locale";s:4:"name";s:9:"languages";}s:14:"locales_source";a:6:{s:11:"description";s:31:"List of English source strings.";s:6:"fields";a:5:{s:3:"lid";a:3:{s:4:"type";s:6:"serial";s:8:"not null";b:1;s:11:"description";s:33:"Unique identifier of this string.";}s:8:"location";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:95:"Drupal path in case of online discovered translations or file path in case of imported strings.";}s:9:"textgroup";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:7:"default";s:11:"description";s:58:"A module defined group of translations, see hook_locale().";}s:6:"source";a:4:{s:4:"type";s:4:"text";s:10:"mysql_type";s:4:"blob";s:8:"not null";b:1;s:11:"description";s:31:"The original string in English.";}s:7:"version";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:20;s:8:"not null";b:1;s:7:"default";s:4:"none";s:11:"description";s:77:"Version of Drupal, where the string was last used (for locales optimization).";}}s:11:"primary key";a:1:{i:0;s:3:"lid";}s:7:"indexes";a:1:{s:6:"source";a:1:{i:0;a:2:{i:0;s:6:"source";i:1;i:30;}}}s:6:"module";s:6:"locale";s:4:"name";s:14:"locales_source";}s:14:"locales_target";a:6:{s:11:"description";s:38:"Stores translated versions of strings.";s:6:"fields";a:5:{s:3:"lid";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:50:"Source string ID. References {locales_source}.lid.";}s:11:"translation";a:4:{s:4:"type";s:4:"text";s:10:"mysql_type";s:4:"blob";s:8:"not null";b:1;s:11:"description";s:42:"Translation string value in this language.";}s:8:"language";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:12;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:47:"Language code. References {languages}.language.";}s:4:"plid";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:119:"Parent lid (lid of the previous string in the plural chain) in case of plural strings. References {locales_source}.lid.";}s:6:"plural";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:46:"Plural index number in case of plural strings.";}}s:11:"primary key";a:3:{i:0;s:8:"language";i:1;s:3:"lid";i:2;s:6:"plural";}s:7:"indexes";a:3:{s:3:"lid";a:1:{i:0;s:3:"lid";}s:4:"plid";a:1:{i:0;s:4:"plid";}s:6:"plural";a:1:{i:0;s:6:"plural";}}s:6:"module";s:6:"locale";s:4:"name";s:14:"locales_target";}s:11:"menu_custom";a:5:{s:11:"description";s:74:"Holds definitions for top-level custom menus (for example, Primary Links).";s:6:"fields";a:3:{s:9:"menu_name";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:80:"Primary Key: Unique key for menu. This is used as a block delta so length is 32.";}s:5:"title";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:38:"Menu title; displayed at top of block.";}s:11:"description";a:3:{s:4:"type";s:4:"text";s:8:"not null";b:0;s:11:"description";s:17:"Menu description.";}}s:11:"primary key";a:1:{i:0;s:9:"menu_name";}s:6:"module";s:4:"menu";s:4:"name";s:11:"menu_custom";}s:4:"node";a:7:{s:11:"description";s:25:"The base table for nodes.";s:6:"fields";a:15:{s:3:"nid";a:4:{s:11:"description";s:34:"The primary identifier for a node.";s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:3:"vid";a:5:{s:11:"description";s:52:"The current {node_revisions}.vid version identifier.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:4:"type";a:5:{s:11:"description";s:34:"The {node_type}.type of this node.";s:4:"type";s:7:"varchar";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";}s:8:"language";a:5:{s:11:"description";s:38:"The {languages}.language of this node.";s:4:"type";s:7:"varchar";s:6:"length";i:12;s:8:"not null";b:1;s:7:"default";s:0:"";}s:5:"title";a:5:{s:11:"description";s:64:"The title of this node, always treated as non-markup plain text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:3:"uid";a:4:{s:11:"description";s:81:"The {users}.uid that owns this node; initially, this is the user that created it.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:6:"status";a:4:{s:11:"description";s:81:"Boolean indicating whether the node is published (visible to non-administrators).";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:1;}s:7:"created";a:4:{s:11:"description";s:45:"The Unix timestamp when the node was created.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"changed";a:4:{s:11:"description";s:57:"The Unix timestamp when the node was most recently saved.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"comment";a:4:{s:11:"description";s:81:"Whether comments are allowed on this node: 0 = no, 1 = read only, 2 = read/write.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"promote";a:4:{s:11:"description";s:74:"Boolean indicating whether the node should be displayed on the front page.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:8:"moderate";a:4:{s:11:"description";s:93:"Previously, a boolean indicating whether the node was "in moderation"; mostly no longer used.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:6:"sticky";a:4:{s:11:"description";s:96:"Boolean indicating whether the node should be displayed at the top of lists in which it appears.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:4:"tnid";a:5:{s:11:"description";s:94:"The translation set id for this node, which equals the node id of the source post in each set.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:9:"translate";a:4:{s:11:"description";s:71:"A boolean indicating whether this translation page needs to be updated.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}}s:7:"indexes";a:10:{s:12:"node_changed";a:1:{i:0;s:7:"changed";}s:12:"node_created";a:1:{i:0;s:7:"created";}s:13:"node_moderate";a:1:{i:0;s:8:"moderate";}s:19:"node_promote_status";a:2:{i:0;s:7:"promote";i:1;s:6:"status";}s:16:"node_status_type";a:3:{i:0;s:6:"status";i:1;s:4:"type";i:2;s:3:"nid";}s:15:"node_title_type";a:2:{i:0;s:5:"title";i:1;a:2:{i:0;s:4:"type";i:1;i:4;}}s:9:"node_type";a:1:{i:0;a:2:{i:0;s:4:"type";i:1;i:4;}}s:3:"uid";a:1:{i:0;s:3:"uid";}s:4:"tnid";a:1:{i:0;s:4:"tnid";}s:9:"translate";a:1:{i:0;s:9:"translate";}}s:11:"unique keys";a:1:{s:3:"vid";a:1:{i:0;s:3:"vid";}}s:11:"primary key";a:1:{i:0;s:3:"nid";}s:6:"module";s:4:"node";s:4:"name";s:4:"node";}s:11:"node_access";a:5:{s:11:"description";s:106:"Identifies which realm/grant pairs a user must possess in order to view, update, or delete specific nodes.";s:6:"fields";a:6:{s:3:"nid";a:5:{s:11:"description";s:35:"The {node}.nid this record affects.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:3:"gid";a:5:{s:11:"description";s:98:"The grant ID a user must possess in the specified realm to gain this row's privileges on the node.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:5:"realm";a:5:{s:11:"description";s:107:"The realm in which the user must possess the grant ID. Each node access node can define one or more realms.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:10:"grant_view";a:6:{s:11:"description";s:79:"Boolean indicating whether a user with the realm/grant pair can view this node.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";}s:12:"grant_update";a:6:{s:11:"description";s:79:"Boolean indicating whether a user with the realm/grant pair can edit this node.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";}s:12:"grant_delete";a:6:{s:11:"description";s:81:"Boolean indicating whether a user with the realm/grant pair can delete this node.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";}}s:11:"primary key";a:3:{i:0;s:3:"nid";i:1;s:3:"gid";i:2;s:5:"realm";}s:6:"module";s:4:"node";s:4:"name";s:11:"node_access";}s:12:"node_counter";a:5:{s:11:"description";s:30:"Access statistics for {node}s.";s:6:"fields";a:4:{s:3:"nid";a:4:{s:11:"description";s:36:"The {node}.nid for these statistics.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:10:"totalcount";a:6:{s:11:"description";s:53:"The total number of times the {node} has been viewed.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:3:"big";}s:8:"daycount";a:6:{s:11:"description";s:59:"The total number of times the {node} has been viewed today.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:6:"medium";}s:9:"timestamp";a:5:{s:11:"description";s:48:"The most recent time the {node} has been viewed.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}}s:11:"primary key";a:1:{i:0;s:3:"nid";}s:6:"module";s:4:"node";s:4:"name";s:12:"node_counter";}s:14:"node_revisions";a:6:{s:11:"description";s:56:"Stores information about each saved version of a {node}.";s:6:"fields";a:9:{s:3:"nid";a:5:{s:11:"description";s:35:"The {node} this version belongs to.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:3:"vid";a:4:{s:11:"description";s:40:"The primary identifier for this version.";s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:3:"uid";a:4:{s:11:"description";s:42:"The {users}.uid that created this version.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:5:"title";a:5:{s:11:"description";s:26:"The title of this version.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:4:"body";a:4:{s:11:"description";s:25:"The body of this version.";s:4:"type";s:4:"text";s:8:"not null";b:1;s:4:"size";s:3:"big";}s:6:"teaser";a:4:{s:11:"description";s:27:"The teaser of this version.";s:4:"type";s:4:"text";s:8:"not null";b:1;s:4:"size";s:3:"big";}s:3:"log";a:4:{s:11:"description";s:53:"The log entry explaining the changes in this version.";s:4:"type";s:4:"text";s:8:"not null";b:1;s:4:"size";s:3:"big";}s:9:"timestamp";a:4:{s:11:"description";s:58:"A Unix timestamp indicating when this version was created.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:6:"format";a:4:{s:11:"description";s:45:"The input format used by this version's body.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}}s:7:"indexes";a:2:{s:3:"nid";a:1:{i:0;s:3:"nid";}s:3:"uid";a:1:{i:0;s:3:"uid";}}s:11:"primary key";a:1:{i:0;s:3:"vid";}s:6:"module";s:4:"node";s:4:"name";s:14:"node_revisions";}s:9:"node_type";a:5:{s:11:"description";s:50:"Stores information about all defined {node} types.";s:6:"fields";a:14:{s:4:"type";a:4:{s:11:"description";s:39:"The machine-readable name of this type.";s:4:"type";s:7:"varchar";s:6:"length";i:32;s:8:"not null";b:1;}s:4:"name";a:5:{s:11:"description";s:37:"The human-readable name of this type.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:6:"module";a:4:{s:11:"description";s:76:"The base string used to construct callbacks corresponding to this node type.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;}s:11:"description";a:4:{s:11:"description";s:33:"A brief description of this type.";s:4:"type";s:4:"text";s:8:"not null";b:1;s:4:"size";s:6:"medium";}s:4:"help";a:4:{s:11:"description";s:71:"Help information shown to the user when creating a {node} of this type.";s:4:"type";s:4:"text";s:8:"not null";b:1;s:4:"size";s:6:"medium";}s:9:"has_title";a:5:{s:11:"description";s:65:"Boolean indicating whether this type uses the {node}.title field.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:4:"size";s:4:"tiny";}s:11:"title_label";a:5:{s:11:"description";s:57:"The label displayed for the title field on the edit form.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:8:"has_body";a:5:{s:11:"description";s:74:"Boolean indicating whether this type uses the {node_revisions}.body field.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:4:"size";s:4:"tiny";}s:10:"body_label";a:5:{s:11:"description";s:56:"The label displayed for the body field on the edit form.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:14:"min_word_count";a:5:{s:11:"description";s:50:"The minimum number of words the body must contain.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:4:"size";s:5:"small";}s:6:"custom";a:5:{s:11:"description";s:137:"A boolean indicating whether this type is defined by a module (FALSE) or by a user via a module like the Content Construction Kit (TRUE).";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";}s:8:"modified";a:5:{s:11:"description";s:108:"A boolean indicating whether this type has been modified by an administrator; currently not used in any way.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";}s:6:"locked";a:5:{s:11:"description";s:88:"A boolean indicating whether the administrator can change the machine name of this type.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";}s:9:"orig_type";a:5:{s:11:"description";s:128:"The original machine-readable name of this node type. This may be different from the current type name if the locked field is 0.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}}s:11:"primary key";a:1:{i:0;s:4:"type";}s:6:"module";s:4:"node";s:4:"name";s:9:"node_type";}s:14:"search_dataset";a:5:{s:11:"description";s:35:"Stores items that will be searched.";s:6:"fields";a:4:{s:3:"sid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:39:"Search item ID, e.g. node ID for nodes.";}s:4:"type";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:16;s:8:"not null";b:0;s:11:"description";s:24:"Type of item, e.g. node.";}s:4:"data";a:4:{s:4:"type";s:4:"text";s:8:"not null";b:1;s:4:"size";s:3:"big";s:11:"description";s:44:"List of space-separated words from the item.";}s:7:"reindex";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:29:"Set to force node reindexing.";}}s:11:"unique keys";a:1:{s:8:"sid_type";a:2:{i:0;s:3:"sid";i:1;s:4:"type";}}s:6:"module";s:6:"search";s:4:"name";s:14:"search_dataset";}s:12:"search_index";a:6:{s:11:"description";s:61:"Stores the search index, associating words, items and scores.";s:6:"fields";a:4:{s:4:"word";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:50;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:64:"The {search_total}.word that is associated with the search item.";}s:3:"sid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:74:"The {search_dataset}.sid of the searchable item to which the word belongs.";}s:4:"type";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:16;s:8:"not null";b:0;s:11:"description";s:75:"The {search_dataset}.type of the searchable item to which the word belongs.";}s:5:"score";a:3:{s:4:"type";s:5:"float";s:8:"not null";b:0;s:11:"description";s:59:"The numeric score of the word, higher being more important.";}}s:7:"indexes";a:2:{s:8:"sid_type";a:2:{i:0;s:3:"sid";i:1;s:4:"type";}s:4:"word";a:1:{i:0;s:4:"word";}}s:11:"unique keys";a:1:{s:13:"word_sid_type";a:3:{i:0;s:4:"word";i:1;s:3:"sid";i:2;s:4:"type";}}s:6:"module";s:6:"search";s:4:"name";s:12:"search_index";}s:12:"search_total";a:5:{s:11:"description";s:31:"Stores search totals for words.";s:6:"fields";a:2:{s:4:"word";a:5:{s:11:"description";s:45:"Primary Key: Unique word in the search index.";s:4:"type";s:7:"varchar";s:6:"length";i:50;s:8:"not null";b:1;s:7:"default";s:0:"";}s:5:"count";a:3:{s:11:"description";s:93:"The count of the word in the index using Zipf's law to equalize the probability distribution.";s:4:"type";s:5:"float";s:8:"not null";b:0;}}s:11:"primary key";a:1:{i:0;s:4:"word";}s:6:"module";s:6:"search";s:4:"name";s:12:"search_total";}s:17:"search_node_links";a:6:{s:11:"description";s:122:"Stores items (like nodes) that link to other nodes, used to improve search scores for nodes that are frequently linked to.";s:6:"fields";a:4:{s:3:"sid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:80:"The {search_dataset}.sid of the searchable item containing the link to the node.";}s:4:"type";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:16;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:81:"The {search_dataset}.type of the searchable item containing the link to the node.";}s:3:"nid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:39:"The {node}.nid that this item links to.";}s:7:"caption";a:4:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;s:11:"description";s:40:"The text used to link to the {node}.nid.";}}s:11:"primary key";a:3:{i:0;s:3:"sid";i:1;s:4:"type";i:2;s:3:"nid";}s:7:"indexes";a:1:{s:3:"nid";a:1:{i:0;s:3:"nid";}}s:6:"module";s:6:"search";s:4:"name";s:17:"search_node_links";}s:8:"variable";a:5:{s:11:"description";s:215:"Named variable/value pairs created by Drupal core or any other module or theme. All variables are cached in memory at the start of every Drupal request so developers should not be careless about what is stored here.";s:6:"fields";a:2:{s:4:"name";a:5:{s:11:"description";s:25:"The name of the variable.";s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";}s:5:"value";a:4:{s:11:"description";s:26:"The value of the variable.";s:4:"type";s:4:"text";s:8:"not null";b:1;s:4:"size";s:3:"big";}}s:11:"primary key";a:1:{i:0;s:4:"name";}s:6:"module";s:6:"system";s:4:"name";s:8:"variable";}s:7:"actions";a:5:{s:11:"description";s:26:"Stores action information.";s:6:"fields";a:5:{s:3:"aid";a:5:{s:11:"description";s:31:"Primary Key: Unique actions ID.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:1:"0";}s:4:"type";a:5:{s:11:"description";s:82:"The object that that action acts on (node, user, comment, system or custom types.)";s:4:"type";s:7:"varchar";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";}s:8:"callback";a:5:{s:11:"description";s:57:"The callback function that executes when the action runs.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:10:"parameters";a:4:{s:11:"description";s:49:"Parameters to be passed to the callback function.";s:4:"type";s:4:"text";s:8:"not null";b:1;s:4:"size";s:3:"big";}s:11:"description";a:5:{s:11:"description";s:26:"Description of the action.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:1:"0";}}s:11:"primary key";a:1:{i:0;s:3:"aid";}s:6:"module";s:6:"system";s:4:"name";s:7:"actions";}s:11:"actions_aid";a:5:{s:11:"description";s:42:"Stores action IDs for non-default actions.";s:6:"fields";a:1:{s:3:"aid";a:4:{s:11:"description";s:31:"Primary Key: Unique actions ID.";s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:11:"primary key";a:1:{i:0;s:3:"aid";}s:6:"module";s:6:"system";s:4:"name";s:11:"actions_aid";}s:5:"batch";a:6:{s:11:"description";s:113:"Enregistrer les d\\303\\251tails concernant les traitements par lot (processus lanc\\303\\251s lors de requ\\303\\252tes HTTP multiples).";s:6:"fields";a:4:{s:3:"bid";a:4:{s:11:"description";s:29:"Primary Key: Unique batch ID.";s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:5:"token";a:4:{s:11:"description";s:165:"A string token generated against the current user's session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.";s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:1;}s:9:"timestamp";a:3:{s:11:"description";s:112:"A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.";s:4:"type";s:3:"int";s:8:"not null";b:1;}s:5:"batch";a:4:{s:11:"description";s:64:"A serialized array containing the processing data for the batch.";s:4:"type";s:4:"text";s:8:"not null";b:0;s:4:"size";s:3:"big";}}s:11:"primary key";a:1:{i:0;s:3:"bid";}s:7:"indexes";a:1:{s:5:"token";a:1:{i:0;s:5:"token";}}s:6:"module";s:6:"system";s:4:"name";s:5:"batch";}s:5:"cache";a:6:{s:11:"description";s:140:"Generic cache table for caching things not separated out into their own tables. Contributed modules may also use this to store cached items.";s:6:"fields";a:6:{s:3:"cid";a:5:{s:11:"description";s:29:"Primary Key: Unique cache ID.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:4:"data";a:4:{s:11:"description";s:30:"A collection of data to cache.";s:4:"type";s:4:"blob";s:8:"not null";b:0;s:4:"size";s:3:"big";}s:6:"expire";a:4:{s:11:"description";s:79:"A Unix timestamp indicating when the cache entry should expire, or 0 for never.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"created";a:4:{s:11:"description";s:61:"A Unix timestamp indicating when the cache entry was created.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"headers";a:3:{s:11:"description";s:51:"Any custom HTTP headers to be added to cached data.";s:4:"type";s:4:"text";s:8:"not null";b:0;}s:10:"serialized";a:5:{s:11:"description";s:64:"A flag to indicate whether content is serialized (1) or not (0).";s:4:"type";s:3:"int";s:4:"size";s:5:"small";s:8:"not null";b:1;s:7:"default";i:0;}}s:7:"indexes";a:1:{s:6:"expire";a:1:{i:0;s:6:"expire";}}s:11:"primary key";a:1:{i:0;s:3:"cid";}s:6:"module";s:6:"system";s:4:"name";s:5:"cache";}s:10:"cache_form";a:6:{s:11:"description";s:125:"Cache table for the form system to store recently built forms and their storage data, to be used in subsequent page requests.";s:6:"fields";a:6:{s:3:"cid";a:5:{s:11:"description";s:29:"Primary Key: Unique cache ID.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:4:"data";a:4:{s:11:"description";s:30:"A collection of data to cache.";s:4:"type";s:4:"blob";s:8:"not null";b:0;s:4:"size";s:3:"big";}s:6:"expire";a:4:{s:11:"description";s:79:"A Unix timestamp indicating when the cache entry should expire, or 0 for never.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"created";a:4:{s:11:"description";s:61:"A Unix timestamp indicating when the cache entry was created.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"headers";a:3:{s:11:"description";s:51:"Any custom HTTP headers to be added to cached data.";s:4:"type";s:4:"text";s:8:"not null";b:0;}s:10:"serialized";a:5:{s:11:"description";s:64:"A flag to indicate whether content is serialized (1) or not (0).";s:4:"type";s:3:"int";s:4:"size";s:5:"small";s:8:"not null";b:1;s:7:"default";i:0;}}s:7:"indexes";a:1:{s:6:"expire";a:1:{i:0;s:6:"expire";}}s:11:"primary key";a:1:{i:0;s:3:"cid";}s:6:"module";s:6:"system";s:4:"name";s:10:"cache_form";}s:10:"cache_page";a:6:{s:11:"description";s:91:"Cache table used to store compressed pages for anonymous users, if page caching is enabled.";s:6:"fields";a:6:{s:3:"cid";a:5:{s:11:"description";s:29:"Primary Key: Unique cache ID.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:4:"data";a:4:{s:11:"description";s:30:"A collection of data to cache.";s:4:"type";s:4:"blob";s:8:"not null";b:0;s:4:"size";s:3:"big";}s:6:"expire";a:4:{s:11:"description";s:79:"A Unix timestamp indicating when the cache entry should expire, or 0 for never.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"created";a:4:{s:11:"description";s:61:"A Unix timestamp indicating when the cache entry was created.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"headers";a:3:{s:11:"description";s:51:"Any custom HTTP headers to be added to cached data.";s:4:"type";s:4:"text";s:8:"not null";b:0;}s:10:"serialized";a:5:{s:11:"description";s:64:"A flag to indicate whether content is serialized (1) or not (0).";s:4:"type";s:3:"int";s:4:"size";s:5:"small";s:8:"not null";b:1;s:7:"default";i:0;}}s:7:"indexes";a:1:{s:6:"expire";a:1:{i:0;s:6:"expire";}}s:11:"primary key";a:1:{i:0;s:3:"cid";}s:6:"module";s:6:"system";s:4:"name";s:10:"cache_page";}s:10:"cache_menu";a:6:{s:11:"description";s:132:"Cache table for the menu system to store router information as well as generated link trees for various menu/page/user combinations.";s:6:"fields";a:6:{s:3:"cid";a:5:{s:11:"description";s:29:"Primary Key: Unique cache ID.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:4:"data";a:4:{s:11:"description";s:30:"A collection of data to cache.";s:4:"type";s:4:"blob";s:8:"not null";b:0;s:4:"size";s:3:"big";}s:6:"expire";a:4:{s:11:"description";s:79:"A Unix timestamp indicating when the cache entry should expire, or 0 for never.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"created";a:4:{s:11:"description";s:61:"A Unix timestamp indicating when the cache entry was created.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"headers";a:3:{s:11:"description";s:51:"Any custom HTTP headers to be added to cached data.";s:4:"type";s:4:"text";s:8:"not null";b:0;}s:10:"serialized";a:5:{s:11:"description";s:64:"A flag to indicate whether content is serialized (1) or not (0).";s:4:"type";s:3:"int";s:4:"size";s:5:"small";s:8:"not null";b:1;s:7:"default";i:0;}}s:7:"indexes";a:1:{s:6:"expire";a:1:{i:0;s:6:"expire";}}s:11:"primary key";a:1:{i:0;s:3:"cid";}s:6:"module";s:6:"system";s:4:"name";s:10:"cache_menu";}s:5:"files";a:6:{s:11:"description";s:38:"Stores information for uploaded files.";s:6:"fields";a:8:{s:3:"fid";a:4:{s:11:"description";s:29:"Primary Key: Unique files ID.";s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:3:"uid";a:5:{s:11:"description";s:60:"The {users}.uid of the user who is associated with the file.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:8:"filename";a:5:{s:11:"description";s:17:"Name of the file.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:8:"filepath";a:5:{s:11:"description";s:41:"Path of the file relative to Drupal root.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:8:"filemime";a:5:{s:11:"description";s:19:"The file MIME type.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:8:"filesize";a:5:{s:11:"description";s:30:"The size of the file in bytes.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:6:"status";a:4:{s:11:"description";s:65:"A flag indicating whether file is temporary (1) or permanent (0).";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:9:"timestamp";a:5:{s:11:"description";s:43:"UNIX timestamp for when the file was added.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}}s:7:"indexes";a:3:{s:3:"uid";a:1:{i:0;s:3:"uid";}s:6:"status";a:1:{i:0;s:6:"status";}s:9:"timestamp";a:1:{i:0;s:9:"timestamp";}}s:11:"primary key";a:1:{i:0;s:3:"fid";}s:6:"module";s:6:"system";s:4:"name";s:5:"files";}s:5:"flood";a:6:{s:11:"description";s:79:"Flood controls the threshold of events, such as the number of contact attempts.";s:6:"fields";a:4:{s:3:"fid";a:3:{s:11:"description";s:22:"Unique flood event ID.";s:4:"type";s:6:"serial";s:8:"not null";b:1;}s:5:"event";a:5:{s:11:"description";s:29:"Name of event (e.g. contact).";s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:1;s:7:"default";s:0:"";}s:8:"hostname";a:5:{s:11:"description";s:24:"Hostname of the visitor.";s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";}s:9:"timestamp";a:4:{s:11:"description";s:23:"Timestamp of the event.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}}s:11:"primary key";a:1:{i:0;s:3:"fid";}s:7:"indexes";a:1:{s:5:"allow";a:3:{i:0;s:5:"event";i:1;s:8:"hostname";i:2;s:9:"timestamp";}}s:6:"module";s:6:"system";s:4:"name";s:5:"flood";}s:7:"history";a:6:{s:11:"description";s:50:"A record of which {users} have read which {node}s.";s:6:"fields";a:3:{s:3:"uid";a:4:{s:11:"description";s:41:"The {users}.uid that read the {node} nid.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:3:"nid";a:4:{s:11:"description";s:29:"The {node}.nid that was read.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:9:"timestamp";a:4:{s:11:"description";s:46:"The Unix timestamp at which the read occurred.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}}s:11:"primary key";a:2:{i:0;s:3:"uid";i:1;s:3:"nid";}s:7:"indexes";a:1:{s:3:"nid";a:1:{i:0;s:3:"nid";}}s:6:"module";s:6:"system";s:4:"name";s:7:"history";}s:11:"menu_router";a:6:{s:11:"description";s:56:"Maps paths to various callbacks (access, page and title)";s:6:"fields";a:20:{s:4:"path";a:5:{s:11:"description";s:49:"Primary Key: the Drupal path this entry describes";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:14:"load_functions";a:3:{s:11:"description";s:129:"A serialized array of function names (like node_load) to be called to load an object corresponding to a part of the current path.";s:4:"type";s:4:"text";s:8:"not null";b:1;}s:16:"to_arg_functions";a:3:{s:11:"description";s:139:"A serialized array of function names (like user_uid_optional_to_arg) to be called to replace a part of the router path with another string.";s:4:"type";s:4:"text";s:8:"not null";b:1;}s:15:"access_callback";a:5:{s:11:"description";s:86:"The callback which determines the access to this router path. Defaults to user_access.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:16:"access_arguments";a:3:{s:11:"description";s:56:"A serialized array of arguments for the access callback.";s:4:"type";s:4:"text";s:8:"not null";b:0;}s:13:"page_callback";a:5:{s:11:"description";s:47:"The name of the function that renders the page.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:14:"page_arguments";a:3:{s:11:"description";s:54:"A serialized array of arguments for the page callback.";s:4:"type";s:4:"text";s:8:"not null";b:0;}s:3:"fit";a:4:{s:11:"description";s:53:"A numeric representation of how specific the path is.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:12:"number_parts";a:5:{s:11:"description";s:36:"Number of parts in this router path.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:5:"small";}s:10:"tab_parent";a:5:{s:11:"description";s:98:"Only for local tasks (tabs) - the router path of the parent page (which may also be a local task).";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:8:"tab_root";a:5:{s:11:"description";s:118:"Router path of the closest non-tab parent page. For pages that are not local tasks, this will be the same as the path.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:5:"title";a:5:{s:11:"description";s:81:"The title for the current page, or the title for the tab if this is a local task.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:14:"title_callback";a:5:{s:11:"description";s:54:"A function which will alter the title. Defaults to t()";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:15:"title_arguments";a:5:{s:11:"description";s:133:"A serialized array of arguments for the title callback. If empty, the title will be used as the sole argument for the title callback.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:4:"type";a:4:{s:11:"description";s:74:"Numeric representation of the type of the menu item, like MENU_LOCAL_TASK.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:14:"block_callback";a:5:{s:11:"description";s:92:"Name of a function used to render the block on the system administration page for this item.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:11:"description";a:3:{s:11:"description";s:27:"A description of this item.";s:4:"type";s:4:"text";s:8:"not null";b:1;}s:8:"position";a:5:{s:11:"description";s:90:"The position of the block (left or right) on the system administration page for this item.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:6:"weight";a:4:{s:11:"description";s:78:"Weight of the element. Lighter weights are higher up, heavier weights go down.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:4:"file";a:3:{s:11:"description";s:92:"The file to include for this element, usually the page callback function lives in this file.";s:4:"type";s:4:"text";s:4:"size";s:6:"medium";}}s:7:"indexes";a:2:{s:3:"fit";a:1:{i:0;s:3:"fit";}s:10:"tab_parent";a:1:{i:0;s:10:"tab_parent";}}s:11:"primary key";a:1:{i:0;s:4:"path";}s:6:"module";s:6:"system";s:4:"name";s:11:"menu_router";}s:10:"menu_links";a:6:{s:11:"description";s:44:"Contains the individual links within a menu.";s:6:"fields";a:25:{s:9:"menu_name";a:5:{s:11:"description";s:98:"The menu name. All links with the same menu name (such as 'navigation') are part of the same menu.";s:4:"type";s:7:"varchar";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";}s:4:"mlid";a:4:{s:11:"description";s:51:"The menu link ID (mlid) is the integer primary key.";s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:4:"plid";a:5:{s:11:"description";s:126:"The parent link ID (plid) is the mlid of the link above in the hierarchy, or zero if the link is at the top level in its menu.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:9:"link_path";a:5:{s:11:"description";s:53:"The Drupal path or external path this link points to.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:11:"router_path";a:5:{s:11:"description";s:114:"For links corresponding to a Drupal path (external = 0), this connects the link to a {menu_router}.path for joins.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:10:"link_title";a:5:{s:11:"description";s:99:"The text displayed for the link, which may be modified by a title callback stored in {menu_router}.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:7:"options";a:3:{s:11:"description";s:115:"A serialized array of options to be passed to the url() or l() function, such as a query string or HTML attributes.";s:4:"type";s:4:"text";s:8:"not null";b:0;}s:6:"module";a:5:{s:11:"description";s:48:"The name of the module that generated this link.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:6:"system";}s:6:"hidden";a:5:{s:11:"description";s:168:"A flag for whether the link should be rendered in menus. (1 = a disabled menu item that may be shown on admin screens, -1 = a menu callback, 0 = a normal, visible link)";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:5:"small";}s:8:"external";a:5:{s:11:"description";s:120:"A flag to indicate if the link points to a full URL starting with a protocol, like http:// (1 = external, 0 = internal).";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:5:"small";}s:12:"has_children";a:5:{s:11:"description";s:99:"Flag indicating whether any links have this link as a parent (1 = children exist, 0 = no children).";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:5:"small";}s:8:"expanded";a:5:{s:11:"description";s:210:"Flag for whether this link should be rendered as expanded in menus - expanded links always have their child links displayed, instead of only when the link is in the active trail (1 = expanded, 0 = not expanded)";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:5:"small";}s:6:"weight";a:4:{s:11:"description";s:59:"Link weight among links in the same menu at the same depth.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:5:"depth";a:5:{s:11:"description";s:80:"The depth relative to the top level. A link with plid == 0 will have depth == 1.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:5:"small";}s:10:"customized";a:5:{s:11:"description";s:110:"A flag to indicate that the user has manually created or edited the link (1 = customized, 0 = not customized).";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:5:"small";}s:2:"p1";a:5:{s:11:"description";s:219:"The first mlid in the materialized path. If N = depth, then pN must equal the mlid. If depth > 1 then p(N-1) must equal the plid. All pX where X > depth must equal zero. The columns p1 .. p9 are also called the parents.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:2:"p2";a:5:{s:11:"description";s:49:"The second mlid in the materialized path. See p1.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:2:"p3";a:5:{s:11:"description";s:48:"The third mlid in the materialized path. See p1.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:2:"p4";a:5:{s:11:"description";s:49:"The fourth mlid in the materialized path. See p1.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:2:"p5";a:5:{s:11:"description";s:48:"The fifth mlid in the materialized path. See p1.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:2:"p6";a:5:{s:11:"description";s:48:"The sixth mlid in the materialized path. See p1.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:2:"p7";a:5:{s:11:"description";s:50:"The seventh mlid in the materialized path. See p1.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:2:"p8";a:5:{s:11:"description";s:49:"The eighth mlid in the materialized path. See p1.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:2:"p9";a:5:{s:11:"description";s:48:"The ninth mlid in the materialized path. See p1.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:7:"updated";a:5:{s:11:"description";s:81:"Flag that indicates that this link was generated during the update from Drupal 5.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:5:"small";}}s:7:"indexes";a:4:{s:9:"path_menu";a:2:{i:0;a:2:{i:0;s:9:"link_path";i:1;i:128;}i:1;s:9:"menu_name";}s:22:"menu_plid_expand_child";a:4:{i:0;s:9:"menu_name";i:1;s:4:"plid";i:2;s:8:"expanded";i:3;s:12:"has_children";}s:12:"menu_parents";a:10:{i:0;s:9:"menu_name";i:1;s:2:"p1";i:2;s:2:"p2";i:3;s:2:"p3";i:4;s:2:"p4";i:5;s:2:"p5";i:6;s:2:"p6";i:7;s:2:"p7";i:8;s:2:"p8";i:9;s:2:"p9";}s:11:"router_path";a:1:{i:0;a:2:{i:0;s:11:"router_path";i:1;i:128;}}}s:11:"primary key";a:1:{i:0;s:4:"mlid";}s:6:"module";s:6:"system";s:4:"name";s:10:"menu_links";}s:8:"sessions";a:6:{s:11:"description";s:139:"Drupal's session handlers read and write into the sessions table. Each record represents a user session, either anonymous or authenticated.";s:6:"fields";a:6:{s:3:"uid";a:4:{s:11:"description";s:68:"The {users}.uid corresponding to a session, or 0 for anonymous user.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:3:"sid";a:5:{s:11:"description";s:71:"Primary key: A session ID. The value is generated by PHP's Session API.";s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:1;s:7:"default";s:0:"";}s:8:"hostname";a:5:{s:11:"description";s:52:"The IP address that last used this session ID (sid).";s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";}s:9:"timestamp";a:4:{s:11:"description";s:104:"The Unix timestamp when this session last requested a page. Old records are purged by PHP automatically.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:5:"cache";a:4:{s:11:"description";s:118:"The time of this user's last post. This is used when the site has specified a minimum_cache_lifetime. See cache_get().";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"session";a:4:{s:11:"description";s:208:"The serialized contents of $_SESSION, an array of name/value pairs that persists across page requests by this session ID. Drupal loads $_SESSION from here at the start of each request and saves it at the end.";s:4:"type";s:4:"text";s:8:"not null";b:0;s:4:"size";s:3:"big";}}s:11:"primary key";a:1:{i:0;s:3:"sid";}s:7:"indexes";a:2:{s:9:"timestamp";a:1:{i:0;s:9:"timestamp";}s:3:"uid";a:1:{i:0;s:3:"uid";}}s:6:"module";s:6:"system";s:4:"name";s:8:"sessions";}s:6:"system";a:6:{s:11:"description";s:105:"A list of all modules, themes, and theme engines that are or have been installed in Drupal's file system.";s:6:"fields";a:10:{s:8:"filename";a:5:{s:11:"description";s:103:"The path of the primary file for this item, relative to the Drupal root; e.g. modules/node/node.module.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:4:"name";a:5:{s:11:"description";s:32:"The name of the item; e.g. node.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:4:"type";a:5:{s:11:"description";s:60:"The type of the item, either module, theme, or theme_engine.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:5:"owner";a:5:{s:11:"description";s:55:"A theme's 'parent'. Can be either a theme or an engine.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:6:"status";a:4:{s:11:"description";s:55:"Boolean indicating whether or not this item is enabled.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:8:"throttle";a:5:{s:11:"description";s:102:"Boolean indicating whether this item is disabled when the throttle.module disables throttleable items.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";}s:9:"bootstrap";a:4:{s:11:"description";s:138:"Boolean indicating whether this module is loaded during Drupal's early bootstrapping phase (e.g. even before the page cache is consulted).";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:14:"schema_version";a:5:{s:11:"description";s:238:"The module's database schema version number. -1 if the module is not installed (its tables do not exist); 0 or the largest N of the module's hook_update_N() function that has either been run or existed when the module was first installed.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:-1;s:4:"size";s:5:"small";}s:6:"weight";a:4:{s:11:"description";s:127:"The order in which this module's hooks should be invoked relative to other modules. Equal-weighted modules are ordered by name.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:4:"info";a:3:{s:11:"description";s:166:"A serialized array containing information from the module's .info file; keys can include name, description, package, version, core, dependencies, dependents, and php.";s:4:"type";s:4:"text";s:8:"not null";b:0;}}s:11:"primary key";a:1:{i:0;s:8:"filename";}s:7:"indexes";a:2:{s:7:"modules";a:4:{i:0;a:2:{i:0;s:4:"type";i:1;i:12;}i:1;s:6:"status";i:2;s:6:"weight";i:3;s:8:"filename";}s:9:"bootstrap";a:5:{i:0;a:2:{i:0;s:4:"type";i:1;i:12;}i:1;s:6:"status";i:2;s:9:"bootstrap";i:3;s:6:"weight";i:4;s:8:"filename";}}s:6:"module";s:6:"system";s:4:"name";s:6:"system";}s:9:"url_alias";a:7:{s:11:"description";s:95:"A list of URL aliases for Drupal paths; a user may visit either the source or destination path.";s:6:"fields";a:4:{s:3:"pid";a:4:{s:11:"description";s:31:"A unique path alias identifier.";s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:3:"src";a:5:{s:11:"description";s:48:"The Drupal path this alias is for; e.g. node/12.";s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";}s:3:"dst";a:5:{s:11:"description";s:49:"The alias for this path; e.g. title-of-the-story.";s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";}s:8:"language";a:5:{s:11:"description";s:151:"The language this alias is for; if blank, the alias will be used for unknown languages. Each Drupal path can have an alias for each supported language.";s:4:"type";s:7:"varchar";s:6:"length";i:12;s:8:"not null";b:1;s:7:"default";s:0:"";}}s:11:"unique keys";a:1:{s:12:"dst_language";a:2:{i:0;s:3:"dst";i:1;s:8:"language";}}s:11:"primary key";a:1:{i:0;s:3:"pid";}s:7:"indexes";a:1:{s:12:"src_language";a:2:{i:0;s:3:"src";i:1;s:8:"language";}}s:6:"module";s:6:"system";s:4:"name";s:9:"url_alias";}s:9:"term_data";a:6:{s:11:"description";s:24:"Stores term information.";s:6:"fields";a:5:{s:3:"tid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:28:"Primary Key: Unique term ID.";}s:3:"vid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:69:"The {vocabulary}.vid of the vocabulary to which the term is assigned.";}s:4:"name";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:14:"The term name.";}s:11:"description";a:4:{s:4:"type";s:4:"text";s:8:"not null";b:0;s:4:"size";s:3:"big";s:11:"description";s:26:"A description of the term.";}s:6:"weight";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:51:"The weight of this term in relation to other terms.";}}s:11:"primary key";a:1:{i:0;s:3:"tid";}s:7:"indexes";a:2:{s:13:"taxonomy_tree";a:3:{i:0;s:3:"vid";i:1;s:6:"weight";i:2;s:4:"name";}s:8:"vid_name";a:2:{i:0;s:3:"vid";i:1;s:4:"name";}}s:6:"module";s:8:"taxonomy";s:4:"name";s:9:"term_data";}s:14:"term_hierarchy";a:6:{s:11:"description";s:51:"Stores the hierarchical relationship between terms.";s:6:"fields";a:2:{s:3:"tid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:45:"Primary Key: The {term_data}.tid of the term.";}s:6:"parent";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:77:"Primary Key: The {term_data}.tid of the term's parent. 0 indicates no parent.";}}s:7:"indexes";a:1:{s:6:"parent";a:1:{i:0;s:6:"parent";}}s:11:"primary key";a:2:{i:0;s:3:"tid";i:1;s:6:"parent";}s:6:"module";s:8:"taxonomy";s:4:"name";s:14:"term_hierarchy";}s:9:"term_node";a:6:{s:11:"description";s:42:"Stores the relationship of terms to nodes.";s:6:"fields";a:3:{s:3:"nid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:40:"Primary Key: The {node}.nid of the node.";}s:3:"vid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:40:"Primary Key: The {node}.vid of the node.";}s:3:"tid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:64:"Primary Key: The {term_data}.tid of a term assigned to the node.";}}s:7:"indexes";a:2:{s:3:"vid";a:1:{i:0;s:3:"vid";}s:3:"nid";a:1:{i:0;s:3:"nid";}}s:11:"primary key";a:2:{i:0;s:3:"tid";i:1;s:3:"vid";}s:6:"module";s:8:"taxonomy";s:4:"name";s:9:"term_node";}s:13:"term_relation";a:7:{s:11:"description";s:52:"Stores non-hierarchical relationships between terms.";s:6:"fields";a:3:{s:4:"trid";a:3:{s:4:"type";s:6:"serial";s:8:"not null";b:1;s:11:"description";s:37:"Primary Key: Unique term relation ID.";}s:4:"tid1";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:56:"The {term_data}.tid of the first term in a relationship.";}s:4:"tid2";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:57:"The {term_data}.tid of the second term in a relationship.";}}s:11:"unique keys";a:1:{s:9:"tid1_tid2";a:2:{i:0;s:4:"tid1";i:1;s:4:"tid2";}}s:7:"indexes";a:1:{s:4:"tid2";a:1:{i:0;s:4:"tid2";}}s:11:"primary key";a:1:{i:0;s:4:"trid";}s:6:"module";s:8:"taxonomy";s:4:"name";s:13:"term_relation";}s:12:"term_synonym";a:6:{s:11:"description";s:21:"Stores term synonyms.";s:6:"fields";a:3:{s:4:"tsid";a:3:{s:4:"type";s:6:"serial";s:8:"not null";b:1;s:11:"description";s:36:"Primary Key: Unique term synonym ID.";}s:3:"tid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:32:"The {term_data}.tid of the term.";}s:4:"name";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:24:"The name of the synonym.";}}s:7:"indexes";a:2:{s:3:"tid";a:1:{i:0;s:3:"tid";}s:8:"name_tid";a:2:{i:0;s:4:"name";i:1;s:3:"tid";}}s:11:"primary key";a:1:{i:0;s:4:"tsid";}s:6:"module";s:8:"taxonomy";s:4:"name";s:12:"term_synonym";}s:10:"vocabulary";a:6:{s:11:"description";s:30:"Stores vocabulary information.";s:6:"fields";a:11:{s:3:"vid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:34:"Primary Key: Unique vocabulary ID.";}s:4:"name";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:23:"Name of the vocabulary.";}s:11:"description";a:4:{s:4:"type";s:4:"text";s:8:"not null";b:0;s:4:"size";s:3:"big";s:11:"description";s:30:"Description of the vocabulary.";}s:4:"help";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:40:"Help text to display for the vocabulary.";}s:9:"relations";a:6:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:91:"Whether or not related terms are enabled within the vocabulary. (0 = disabled, 1 = enabled)";}s:9:"hierarchy";a:6:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:93:"The type of hierarchy allowed within the vocabulary. (0 = disabled, 1 = single, 2 = multiple)";}s:8:"multiple";a:6:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:105:"Whether or not multiple terms from this vocabulary may be assigned to a node. (0 = disabled, 1 = enabled)";}s:8:"required";a:6:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:94:"Whether or not terms are required for nodes using this vocabulary. (0 = disabled, 1 = enabled)";}s:4:"tags";a:6:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:86:"Whether or not free tagging is enabled for the vocabulary. (0 = disabled, 1 = enabled)";}s:6:"module";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:40:"The module which created the vocabulary.";}s:6:"weight";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:63:"The weight of the vocabulary in relation to other vocabularies.";}}s:11:"primary key";a:1:{i:0;s:3:"vid";}s:7:"indexes";a:1:{s:4:"list";a:2:{i:0;s:6:"weight";i:1;s:4:"name";}}s:6:"module";s:8:"taxonomy";s:4:"name";s:10:"vocabulary";}s:21:"vocabulary_node_types";a:6:{s:11:"description";s:54:"Stores which node types vocabularies may be used with.";s:6:"fields";a:2:{s:3:"vid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:52:"Primary Key: the {vocabulary}.vid of the vocabulary.";}s:4:"type";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:70:"The {node}.type of the node type for which the vocabulary may be used.";}}s:11:"primary key";a:2:{i:0;s:4:"type";i:1;s:3:"vid";}s:7:"indexes";a:1:{s:3:"vid";a:1:{i:0;s:3:"vid";}}s:6:"module";s:8:"taxonomy";s:4:"name";s:21:"vocabulary_node_types";}s:12:"cache_update";a:6:{s:11:"description";s:109:"Cache table for the Update module to store information about available releases, fetched from central server.";s:6:"fields";a:6:{s:3:"cid";a:5:{s:11:"description";s:29:"Primary Key: Unique cache ID.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:4:"data";a:4:{s:11:"description";s:30:"A collection of data to cache.";s:4:"type";s:4:"blob";s:8:"not null";b:0;s:4:"size";s:3:"big";}s:6:"expire";a:4:{s:11:"description";s:79:"A Unix timestamp indicating when the cache entry should expire, or 0 for never.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"created";a:4:{s:11:"description";s:61:"A Unix timestamp indicating when the cache entry was created.";s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;}s:7:"headers";a:3:{s:11:"description";s:51:"Any custom HTTP headers to be added to cached data.";s:4:"type";s:4:"text";s:8:"not null";b:0;}s:10:"serialized";a:5:{s:11:"description";s:64:"A flag to indicate whether content is serialized (1) or not (0).";s:4:"type";s:3:"int";s:4:"size";s:5:"small";s:8:"not null";b:1;s:7:"default";i:0;}}s:7:"indexes";a:1:{s:6:"expire";a:1:{i:0;s:6:"expire";}}s:11:"primary key";a:1:{i:0;s:3:"cid";}s:6:"module";s:6:"update";s:4:"name";s:12:"cache_update";}s:6:"access";a:5:{s:11:"description";s:25:"Stores site access rules.";s:6:"fields";a:4:{s:3:"aid";a:3:{s:4:"type";s:6:"serial";s:8:"not null";b:1;s:11:"description";s:30:"Primary Key: Unique access ID.";}s:4:"mask";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:36:"Text mask used for filtering access.";}s:4:"type";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:40:"Type of access rule: name, mail or host.";}s:6:"status";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:46:"Whether rule is to allow(1) or deny(0) access.";}}s:11:"primary key";a:1:{i:0;s:3:"aid";}s:6:"module";s:4:"user";s:4:"name";s:6:"access";}s:7:"authmap";a:6:{s:11:"description";s:42:"Stores distributed authentication mapping.";s:6:"fields";a:4:{s:3:"aid";a:4:{s:11:"description";s:31:"Primary Key: Unique authmap ID.";s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:3:"uid";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:19:"User's {users}.uid.";}s:8:"authname";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:27:"Unique authentication name.";}s:6:"module";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:47:"Module which is controlling the authentication.";}}s:11:"unique keys";a:1:{s:8:"authname";a:1:{i:0;s:8:"authname";}}s:11:"primary key";a:1:{i:0;s:3:"aid";}s:6:"module";s:4:"user";s:4:"name";s:7:"authmap";}s:10:"permission";a:6:{s:11:"description";s:29:"Stores permissions for users.";s:6:"fields";a:4:{s:3:"pid";a:3:{s:4:"type";s:6:"serial";s:8:"not null";b:1;s:11:"description";s:34:"Primary Key: Unique permission ID.";}s:3:"rid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:53:"The {role}.rid to which the permissions are assigned.";}s:4:"perm";a:4:{s:4:"type";s:4:"text";s:8:"not null";b:0;s:4:"size";s:3:"big";s:11:"description";s:35:"List of permissions being assigned.";}s:3:"tid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:67:"Originally intended for taxonomy-based permissions, but never used.";}}s:11:"primary key";a:1:{i:0;s:3:"pid";}s:7:"indexes";a:1:{s:3:"rid";a:1:{i:0;s:3:"rid";}}s:6:"module";s:4:"user";s:4:"name";s:10:"permission";}s:4:"role";a:6:{s:11:"description";s:18:"Stores user roles.";s:6:"fields";a:2:{s:3:"rid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:28:"Primary Key: Unique role id.";}s:4:"name";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:17:"Unique role name.";}}s:11:"unique keys";a:1:{s:4:"name";a:1:{i:0;s:4:"name";}}s:11:"primary key";a:1:{i:0;s:3:"rid";}s:6:"module";s:4:"user";s:4:"name";s:4:"role";}s:5:"users";a:7:{s:11:"description";s:17:"Stores user data.";s:6:"fields";a:19:{s:3:"uid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:28:"Primary Key: Unique user ID.";}s:4:"name";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:60;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:17:"Unique user name.";}s:4:"pass";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:27:"User's password (md5 hash).";}s:4:"mail";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:0;s:7:"default";s:0:"";s:11:"description";s:21:"User's email address.";}s:4:"mode";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:80:"Per-user comment display mode (threaded vs. flat), used by the {comment} module.";}s:4:"sort";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:84:"Per-user comment sort order (newest vs. oldest first), used by the {comment} module.";}s:9:"threshold";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:81:"Previously used by the {comment} module for per-user preferences; no longer used.";}s:5:"theme";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:21:"User's default theme.";}s:9:"signature";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:17:"User's signature.";}s:16:"signature_format";a:5:{s:4:"type";s:3:"int";s:4:"size";s:5:"small";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:45:"The {filter_formats}.format of the signature.";}s:7:"created";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:36:"Timestamp for when user was created.";}s:6:"access";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:51:"Timestamp for previous time user accessed the site.";}s:5:"login";a:4:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:32:"Timestamp for user's last login.";}s:6:"status";a:5:{s:4:"type";s:3:"int";s:8:"not null";b:1;s:7:"default";i:0;s:4:"size";s:4:"tiny";s:11:"description";s:44:"Whether the user is active(1) or blocked(0).";}s:8:"timezone";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:8;s:8:"not null";b:0;s:11:"description";s:16:"User's timezone.";}s:8:"language";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:12;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:24:"User's default language.";}s:7:"picture";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:36:"Path to the user's uploaded picture.";}s:4:"init";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:8:"not null";b:0;s:7:"default";s:0:"";s:11:"description";s:48:"Email address used for initial account creation.";}s:4:"data";a:4:{s:4:"type";s:4:"text";s:8:"not null";b:0;s:4:"size";s:3:"big";s:11:"description";s:269:"A serialized array of name value pairs that are related to the user. Any form values posted during user edit are stored and are loaded into the $user object during user_load(). Use of this field is discouraged and it will likely disappear in a future version of Drupal.";}}s:7:"indexes";a:3:{s:6:"access";a:1:{i:0;s:6:"access";}s:7:"created";a:1:{i:0;s:7:"created";}s:4:"mail";a:1:{i:0;s:4:"mail";}}s:11:"unique keys";a:1:{s:4:"name";a:1:{i:0;s:4:"name";}}s:11:"primary key";a:1:{i:0;s:3:"uid";}s:6:"module";s:4:"user";s:4:"name";s:5:"users";}s:11:"users_roles";a:6:{s:11:"description";s:20:"Maps users to roles.";s:6:"fields";a:2:{s:3:"uid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:34:"Primary Key: {users}.uid for user.";}s:3:"rid";a:5:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:33:"Primary Key: {role}.rid for role.";}}s:11:"primary key";a:2:{i:0;s:3:"uid";i:1;s:3:"rid";}s:7:"indexes";a:1:{s:3:"rid";a:1:{i:0;s:3:"rid";}}s:6:"module";s:4:"user";s:4:"name";s:11:"users_roles";}s:10:"xmlsitemap";a:6:{s:11:"description";s:30:"The base table for xmlsitemap.";s:6:"fields";a:10:{s:3:"lid";a:3:{s:11:"description";s:16:"The primary key.";s:4:"type";s:6:"serial";s:8:"not null";b:1;}s:3:"loc";a:5:{s:11:"description";s:17:"The relative URL.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:6:"module";a:5:{s:11:"description";s:30:"The module handling this link.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:1;s:7:"default";s:0:"";}s:4:"type";a:5:{s:11:"description";s:17:"The type of link.";s:4:"type";s:7:"varchar";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";}s:2:"id";a:5:{s:11:"description";s:32:"The ID associated with the link.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:3:"sid";a:5:{s:11:"description";s:36:"The sub ID associated with the link.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:8:"language";a:5:{s:11:"description";s:38:"The language associated with the link.";s:4:"type";s:7:"varchar";s:6:"length";i:12;s:8:"not null";b:1;s:7:"default";s:0:"";}s:7:"changed";a:5:{s:11:"description";s:38:"The Unix timestamp of the last change.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:10:"changefreq";a:5:{s:11:"description";s:29:"The frequency of the changes.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:8:"priority";a:4:{s:11:"description";s:41:"The priority of this node in the sitemap.";s:4:"type";s:5:"float";s:8:"not null";b:1;s:7:"default";d:0.5;}}s:7:"indexes";a:5:{s:11:"link_module";a:1:{i:0;a:2:{i:0;s:6:"module";i:1;i:25;}}s:13:"link_language";a:1:{i:0;s:8:"language";}s:12:"link_changed";a:1:{i:0;s:7:"changed";}s:13:"link_priority";a:1:{i:0;s:8:"priority";}s:7:"type_id";a:2:{i:0;s:4:"type";i:1;s:2:"id";}}s:11:"primary key";a:1:{i:0;s:3:"lid";}s:6:"module";s:10:"xmlsitemap";s:4:"name";s:10:"xmlsitemap";}s:15:"xmlsitemap_node";a:5:{s:11:"description";s:35:"The base table for xmlsitemap_node.";s:6:"fields";a:5:{s:3:"nid";a:5:{s:11:"description";s:12:"The node ID.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:7:"changed";a:5:{s:11:"description";s:38:"The Unix timestamp of the last change.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:18:"previously_changed";a:5:{s:11:"description";s:42:"The Unix timestamp of the previous change.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:13:"comment_ratio";a:4:{s:11:"description";s:87:"The ratio between the node comments and the maximum number of comments added to a node.";s:4:"type";s:5:"float";s:8:"not null";b:1;s:7:"default";d:0;}s:17:"priority_override";a:4:{s:11:"description";s:40:"The priority of the node in the sitemap.";s:4:"type";s:5:"float";s:8:"not null";b:1;s:7:"default";d:-2;}}s:11:"primary key";a:1:{i:0;s:3:"nid";}s:6:"module";s:15:"xmlsitemap_node";s:4:"name";s:15:"xmlsitemap_node";}s:19:"xmlsitemap_taxonomy";a:5:{s:11:"description";s:39:"The base table for xmlsitemap_taxonomy.";s:6:"fields";a:5:{s:3:"tid";a:5:{s:11:"description";s:23:"The vocabulary term ID.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:3:"vid";a:5:{s:11:"description";s:18:"The vocabulary ID.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:7:"changed";a:5:{s:11:"description";s:38:"The Unix timestamp of the last change.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:18:"previously_changed";a:5:{s:11:"description";s:42:"The Unix timestamp of the previous change.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:17:"priority_override";a:4:{s:11:"description";s:40:"The priority of the term in the sitemap.";s:4:"type";s:5:"float";s:8:"not null";b:1;s:7:"default";d:-2;}}s:11:"primary key";a:1:{i:0;s:3:"tid";}s:6:"module";s:19:"xmlsitemap_taxonomy";s:4:"name";s:19:"xmlsitemap_taxonomy";}s:15:"xmlsitemap_user";a:5:{s:11:"description";s:35:"The base table for xmlsitemap_user.";s:6:"fields";a:5:{s:3:"uid";a:5:{s:11:"description";s:12:"The user ID.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:7:"changed";a:5:{s:11:"description";s:38:"The Unix timestamp of the last change.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:18:"previously_changed";a:5:{s:11:"description";s:42:"The Unix timestamp of the previous change.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:8:"comments";a:5:{s:11:"description";s:46:"The number of comments authored from the user.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:17:"priority_override";a:4:{s:11:"description";s:40:"The priority of the term in the sitemap.";s:4:"type";s:5:"float";s:8:"not null";b:1;s:7:"default";d:-2;}}s:11:"primary key";a:1:{i:0;s:3:"uid";}s:6:"module";s:15:"xmlsitemap_user";s:4:"name";s:15:"xmlsitemap_user";}s:20:"xmlsitemap_user_role";a:5:{s:11:"description";s:30:"The user roles settings table.";s:6:"fields";a:2:{s:3:"rid";a:5:{s:11:"description";s:12:"The role ID.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:7:"default";i:0;}s:8:"priority";a:4:{s:11:"description";s:34:"The priority assigned to the role.";s:4:"type";s:5:"float";s:8:"not null";b:1;s:7:"default";d:0.5;}}s:11:"primary key";a:1:{i:0;s:3:"rid";}s:6:"module";s:15:"xmlsitemap_user";s:4:"name";s:20:"xmlsitemap_user_role";}}	0	1249308795		1
theme_registry:garland	a:133:{s:24:"block_admin_display_form";a:7:{s:8:"template";s:38:"modules/block/block-admin-display-form";s:4:"file";s:29:"modules/block/block.admin.inc";s:9:"arguments";a:1:{s:4:"form";N;}s:4:"type";s:6:"module";s:10:"theme path";s:13:"modules/block";s:11:"theme paths";a:1:{i:0;s:13:"modules/block";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:44:"template_preprocess_block_admin_display_form";}}s:17:"color_scheme_form";a:6:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"type";s:6:"module";s:10:"theme path";s:13:"modules/color";s:8:"function";s:23:"theme_color_scheme_form";s:11:"theme paths";a:1:{i:0;s:13:"modules/color";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:13:"comment_block";a:6:{s:9:"arguments";a:0:{}s:4:"type";s:6:"module";s:10:"theme path";s:15:"modules/comment";s:8:"function";s:19:"theme_comment_block";s:11:"theme paths";a:1:{i:0;s:15:"modules/comment";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:22:"comment_admin_overview";a:6:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"type";s:6:"module";s:10:"theme path";s:15:"modules/comment";s:8:"function";s:28:"theme_comment_admin_overview";s:11:"theme paths";a:1:{i:0;s:15:"modules/comment";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:15:"comment_preview";a:6:{s:9:"arguments";a:4:{s:7:"comment";N;s:4:"node";N;s:5:"links";a:0:{}s:7:"visible";i:1;}s:4:"type";s:6:"module";s:10:"theme path";s:15:"modules/comment";s:8:"function";s:21:"theme_comment_preview";s:11:"theme paths";a:1:{i:0;s:15:"modules/comment";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:12:"comment_view";a:6:{s:9:"arguments";a:4:{s:7:"comment";N;s:4:"node";N;s:5:"links";a:0:{}s:7:"visible";i:1;}s:4:"type";s:6:"module";s:10:"theme path";s:15:"modules/comment";s:8:"function";s:18:"theme_comment_view";s:11:"theme paths";a:1:{i:0;s:15:"modules/comment";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:16:"comment_controls";a:6:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"type";s:6:"module";s:10:"theme path";s:15:"modules/comment";s:8:"function";s:22:"theme_comment_controls";s:11:"theme paths";a:1:{i:0;s:15:"modules/comment";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:7:"comment";a:7:{s:8:"template";s:7:"comment";s:4:"path";s:14:"themes/garland";s:4:"type";s:12:"theme_engine";s:10:"theme path";s:14:"themes/garland";s:9:"arguments";a:3:{s:7:"comment";N;s:4:"node";N;s:5:"links";a:0:{}}s:11:"theme paths";a:2:{i:0;s:15:"modules/comment";i:1;s:14:"themes/garland";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:27:"template_preprocess_comment";}}s:14:"comment_folded";a:6:{s:8:"template";s:30:"modules/comment/comment-folded";s:9:"arguments";a:1:{s:7:"comment";N;}s:4:"type";s:6:"module";s:10:"theme path";s:15:"modules/comment";s:11:"theme paths";a:1:{i:0;s:15:"modules/comment";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:34:"template_preprocess_comment_folded";}}s:22:"comment_flat_collapsed";a:6:{s:9:"arguments";a:2:{s:7:"comment";N;s:4:"node";N;}s:4:"type";s:6:"module";s:10:"theme path";s:15:"modules/comment";s:8:"function";s:28:"theme_comment_flat_collapsed";s:11:"theme paths";a:1:{i:0;s:15:"modules/comment";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:21:"comment_flat_expanded";a:6:{s:9:"arguments";a:2:{s:7:"comment";N;s:4:"node";N;}s:4:"type";s:6:"module";s:10:"theme path";s:15:"modules/comment";s:8:"function";s:27:"theme_comment_flat_expanded";s:11:"theme paths";a:1:{i:0;s:15:"modules/comment";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:24:"comment_thread_collapsed";a:6:{s:9:"arguments";a:2:{s:7:"comment";N;s:4:"node";N;}s:4:"type";s:6:"module";s:10:"theme path";s:15:"modules/comment";s:8:"function";s:30:"theme_comment_thread_collapsed";s:11:"theme paths";a:1:{i:0;s:15:"modules/comment";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:23:"comment_thread_expanded";a:6:{s:9:"arguments";a:2:{s:7:"comment";N;s:4:"node";N;}s:4:"type";s:6:"module";s:10:"theme path";s:15:"modules/comment";s:8:"function";s:29:"theme_comment_thread_expanded";s:11:"theme paths";a:1:{i:0;s:15:"modules/comment";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:22:"comment_post_forbidden";a:6:{s:9:"arguments";a:1:{s:3:"nid";N;}s:4:"type";s:6:"module";s:10:"theme path";s:15:"modules/comment";s:8:"function";s:28:"theme_comment_post_forbidden";s:11:"theme paths";a:1:{i:0;s:15:"modules/comment";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:15:"comment_wrapper";a:6:{s:8:"function";s:27:"phptemplate_comment_wrapper";s:4:"type";s:12:"theme_engine";s:10:"theme path";s:14:"themes/garland";s:9:"arguments";a:2:{s:7:"content";N;s:4:"node";N;}s:11:"theme paths";a:2:{i:0;s:15:"modules/comment";i:1;s:14:"themes/garland";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:35:"template_preprocess_comment_wrapper";}}s:17:"comment_submitted";a:6:{s:8:"function";s:29:"phptemplate_comment_submitted";s:4:"type";s:12:"theme_engine";s:10:"theme path";s:14:"themes/garland";s:9:"arguments";a:1:{s:7:"comment";N;}s:11:"theme paths";a:2:{i:0;s:15:"modules/comment";i:1;s:14:"themes/garland";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:13:"dblog_filters";a:6:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"type";s:6:"module";s:10:"theme path";s:13:"modules/dblog";s:8:"function";s:19:"theme_dblog_filters";s:11:"theme paths";a:1:{i:0;s:13:"modules/dblog";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:21:"filter_admin_overview";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:31:"modules/filter/filter.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/filter";s:8:"function";s:27:"theme_filter_admin_overview";s:11:"theme paths";a:1:{i:0;s:14:"modules/filter";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:18:"filter_admin_order";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:31:"modules/filter/filter.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/filter";s:8:"function";s:24:"theme_filter_admin_order";s:11:"theme paths";a:1:{i:0;s:14:"modules/filter";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:11:"filter_tips";a:7:{s:9:"arguments";a:3:{s:4:"tips";N;s:4:"long";b:0;s:5:"extra";s:0:"";}s:4:"file";s:31:"modules/filter/filter.pages.inc";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/filter";s:8:"function";s:17:"theme_filter_tips";s:11:"theme paths";a:1:{i:0;s:14:"modules/filter";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:21:"filter_tips_more_info";a:6:{s:9:"arguments";a:0:{}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/filter";s:8:"function";s:27:"theme_filter_tips_more_info";s:11:"theme paths";a:1:{i:0;s:14:"modules/filter";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:10:"imce_admin";a:5:{s:8:"function";s:16:"imce_admin_theme";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/imce";s:11:"theme paths";a:1:{i:0;s:12:"modules/imce";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:16:"imce_directories";a:5:{s:8:"function";s:22:"imce_directories_theme";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/imce";s:11:"theme paths";a:1:{i:0;s:12:"modules/imce";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:15:"imce_thumbnails";a:5:{s:8:"function";s:21:"imce_thumbnails_theme";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/imce";s:11:"theme paths";a:1:{i:0;s:12:"modules/imce";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:14:"imce_file_list";a:7:{s:8:"template";s:14:"imce-file-list";s:9:"arguments";a:1:{s:8:"imce_ref";N;}s:4:"path";s:16:"modules/imce/tpl";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/imce";s:11:"theme paths";a:1:{i:0;s:16:"modules/imce/tpl";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:12:"imce_content";a:7:{s:8:"template";s:12:"imce-content";s:9:"arguments";a:3:{s:4:"tree";N;s:5:"forms";N;s:8:"imce_ref";N;}s:4:"path";s:16:"modules/imce/tpl";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/imce";s:11:"theme paths";a:1:{i:0;s:16:"modules/imce/tpl";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:9:"imce_page";a:7:{s:8:"template";s:9:"imce-page";s:9:"arguments";a:1:{s:7:"content";N;}s:4:"path";s:16:"modules/imce/tpl";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/imce";s:11:"theme paths";a:1:{i:0;s:16:"modules/imce/tpl";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:30:"locale_languages_overview_form";a:6:{s:9:"arguments";a:1:{s:4:"form";a:0:{}}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/locale";s:8:"function";s:36:"theme_locale_languages_overview_form";s:11:"theme paths";a:1:{i:0;s:14:"modules/locale";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:18:"menu_overview_form";a:7:{s:4:"file";s:27:"modules/menu/menu.admin.inc";s:9:"arguments";a:1:{s:4:"form";N;}s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/menu";s:8:"function";s:24:"theme_menu_overview_form";s:11:"theme paths";a:1:{i:0;s:12:"modules/menu";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:4:"node";a:7:{s:8:"template";s:4:"node";s:4:"path";s:14:"themes/garland";s:4:"type";s:12:"theme_engine";s:10:"theme path";s:14:"themes/garland";s:9:"arguments";a:3:{s:4:"node";N;s:6:"teaser";b:0;s:4:"page";b:0;}s:11:"theme paths";a:2:{i:0;s:12:"modules/node";i:1;s:14:"themes/garland";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:24:"template_preprocess_node";}}s:9:"node_list";a:6:{s:9:"arguments";a:2:{s:5:"items";N;s:5:"title";N;}s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/node";s:8:"function";s:15:"theme_node_list";s:11:"theme paths";a:1:{i:0;s:12:"modules/node";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:17:"node_search_admin";a:6:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/node";s:8:"function";s:23:"theme_node_search_admin";s:11:"theme paths";a:1:{i:0;s:12:"modules/node";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:16:"node_filter_form";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:27:"modules/node/node.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/node";s:8:"function";s:22:"theme_node_filter_form";s:11:"theme paths";a:1:{i:0;s:12:"modules/node";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:12:"node_filters";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:27:"modules/node/node.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/node";s:8:"function";s:18:"theme_node_filters";s:11:"theme paths";a:1:{i:0;s:12:"modules/node";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:16:"node_admin_nodes";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:27:"modules/node/node.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/node";s:8:"function";s:22:"theme_node_admin_nodes";s:11:"theme paths";a:1:{i:0;s:12:"modules/node";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:13:"node_add_list";a:7:{s:9:"arguments";a:1:{s:7:"content";N;}s:4:"file";s:27:"modules/node/node.pages.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/node";s:8:"function";s:19:"theme_node_add_list";s:11:"theme paths";a:1:{i:0;s:12:"modules/node";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:9:"node_form";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:27:"modules/node/node.pages.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/node";s:8:"function";s:15:"theme_node_form";s:11:"theme paths";a:1:{i:0;s:12:"modules/node";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:12:"node_preview";a:7:{s:9:"arguments";a:1:{s:4:"node";N;}s:4:"file";s:27:"modules/node/node.pages.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/node";s:8:"function";s:18:"theme_node_preview";s:11:"theme paths";a:1:{i:0;s:12:"modules/node";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:16:"node_log_message";a:6:{s:9:"arguments";a:1:{s:3:"log";N;}s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/node";s:8:"function";s:22:"theme_node_log_message";s:11:"theme paths";a:1:{i:0;s:12:"modules/node";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:14:"node_submitted";a:6:{s:8:"function";s:26:"phptemplate_node_submitted";s:4:"type";s:12:"theme_engine";s:10:"theme path";s:14:"themes/garland";s:9:"arguments";a:1:{s:4:"node";N;}s:11:"theme paths";a:2:{i:0;s:12:"modules/node";i:1;s:14:"themes/garland";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:17:"search_theme_form";a:6:{s:9:"arguments";a:1:{s:4:"form";N;}s:8:"template";s:32:"modules/search/search-theme-form";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/search";s:11:"theme paths";a:1:{i:0;s:14:"modules/search";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:37:"template_preprocess_search_theme_form";}}s:17:"search_block_form";a:6:{s:9:"arguments";a:1:{s:4:"form";N;}s:8:"template";s:32:"modules/search/search-block-form";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/search";s:11:"theme paths";a:1:{i:0;s:14:"modules/search";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:37:"template_preprocess_search_block_form";}}s:13:"search_result";a:7:{s:9:"arguments";a:2:{s:6:"result";N;s:4:"type";N;}s:4:"file";s:31:"modules/search/search.pages.inc";s:8:"template";s:28:"modules/search/search-result";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/search";s:11:"theme paths";a:1:{i:0;s:14:"modules/search";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:33:"template_preprocess_search_result";}}s:14:"search_results";a:7:{s:9:"arguments";a:2:{s:7:"results";N;s:4:"type";N;}s:4:"file";s:31:"modules/search/search.pages.inc";s:8:"template";s:29:"modules/search/search-results";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/search";s:11:"theme paths";a:1:{i:0;s:14:"modules/search";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:34:"template_preprocess_search_results";}}s:11:"placeholder";a:6:{s:9:"arguments";a:1:{s:4:"text";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:17:"theme_placeholder";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:4:"page";a:7:{s:8:"template";s:4:"page";s:4:"path";s:14:"themes/garland";s:4:"type";s:12:"theme_engine";s:10:"theme path";s:14:"themes/garland";s:9:"arguments";a:3:{s:7:"content";N;s:11:"show_blocks";b:1;s:13:"show_messages";b:1;}s:11:"theme paths";a:2:{i:0;s:14:"modules/system";i:1;s:14:"themes/garland";}s:20:"preprocess functions";a:3:{i:0;s:19:"template_preprocess";i:1;s:24:"template_preprocess_page";i:2;s:27:"phptemplate_preprocess_page";}}s:16:"maintenance_page";a:7:{s:8:"template";s:16:"maintenance-page";s:4:"path";s:14:"themes/garland";s:4:"type";s:12:"theme_engine";s:10:"theme path";s:14:"themes/garland";s:9:"arguments";a:3:{s:7:"content";N;s:11:"show_blocks";b:1;s:13:"show_messages";b:1;}s:11:"theme paths";a:2:{i:0;s:14:"modules/system";i:1;s:14:"themes/garland";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:11:"update_page";a:6:{s:9:"arguments";a:2:{s:7:"content";N;s:13:"show_messages";b:1;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:17:"theme_update_page";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:12:"install_page";a:6:{s:9:"arguments";a:1:{s:7:"content";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:18:"theme_install_page";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:9:"task_list";a:6:{s:9:"arguments";a:2:{s:5:"items";N;s:6:"active";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:15:"theme_task_list";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:15:"status_messages";a:6:{s:9:"arguments";a:1:{s:7:"display";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:21:"theme_status_messages";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:5:"links";a:6:{s:9:"arguments";a:2:{s:5:"links";N;s:10:"attributes";a:1:{s:5:"class";s:5:"links";}}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:11:"theme_links";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:5:"image";a:6:{s:9:"arguments";a:5:{s:4:"path";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:10:"attributes";N;s:7:"getsize";b:1;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:11:"theme_image";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:10:"breadcrumb";a:6:{s:8:"function";s:22:"phptemplate_breadcrumb";s:4:"type";s:12:"theme_engine";s:10:"theme path";s:14:"themes/garland";s:9:"arguments";a:1:{s:10:"breadcrumb";N;}s:11:"theme paths";a:2:{i:0;s:14:"modules/system";i:1;s:14:"themes/garland";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:4:"help";a:6:{s:9:"arguments";a:0:{}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:10:"theme_help";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:7:"submenu";a:6:{s:9:"arguments";a:1:{s:5:"links";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:13:"theme_submenu";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:5:"table";a:6:{s:9:"arguments";a:4:{s:6:"header";N;s:4:"rows";N;s:10:"attributes";a:0:{}s:7:"caption";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:11:"theme_table";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:24:"table_select_header_cell";a:6:{s:9:"arguments";a:0:{}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:30:"theme_table_select_header_cell";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:19:"tablesort_indicator";a:6:{s:9:"arguments";a:1:{s:5:"style";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:25:"theme_tablesort_indicator";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:3:"box";a:6:{s:9:"arguments";a:3:{s:5:"title";N;s:7:"content";N;s:6:"region";s:4:"main";}s:8:"template";s:18:"modules/system/box";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:5:"block";a:7:{s:8:"template";s:5:"block";s:4:"path";s:14:"themes/garland";s:4:"type";s:12:"theme_engine";s:10:"theme path";s:14:"themes/garland";s:9:"arguments";a:1:{s:5:"block";N;}s:11:"theme paths";a:2:{i:0;s:14:"modules/system";i:1;s:14:"themes/garland";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:25:"template_preprocess_block";}}s:4:"mark";a:6:{s:9:"arguments";a:1:{s:4:"type";i:1;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:10:"theme_mark";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:9:"item_list";a:6:{s:9:"arguments";a:4:{s:5:"items";a:0:{}s:5:"title";N;s:4:"type";s:2:"ul";s:10:"attributes";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:15:"theme_item_list";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:14:"more_help_link";a:6:{s:9:"arguments";a:1:{s:3:"url";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:20:"theme_more_help_link";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:8:"xml_icon";a:6:{s:9:"arguments";a:1:{s:3:"url";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:14:"theme_xml_icon";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:9:"feed_icon";a:6:{s:9:"arguments";a:2:{s:3:"url";N;s:5:"title";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:15:"theme_feed_icon";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:9:"more_link";a:6:{s:9:"arguments";a:2:{s:3:"url";N;s:5:"title";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:15:"theme_more_link";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:7:"closure";a:6:{s:9:"arguments";a:1:{s:4:"main";i:0;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:13:"theme_closure";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:6:"blocks";a:6:{s:9:"arguments";a:1:{s:6:"region";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:12:"theme_blocks";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:8:"username";a:6:{s:9:"arguments";a:1:{s:6:"object";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:14:"theme_username";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:12:"progress_bar";a:6:{s:9:"arguments";a:2:{s:7:"percent";N;s:7:"message";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:18:"theme_progress_bar";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:11:"indentation";a:6:{s:9:"arguments";a:1:{s:4:"size";i:1;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:17:"theme_indentation";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:5:"pager";a:6:{s:9:"arguments";a:4:{s:4:"tags";a:0:{}s:5:"limit";i:10;s:7:"element";i:0;s:10:"parameters";a:0:{}}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:11:"theme_pager";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:11:"pager_first";a:6:{s:9:"arguments";a:4:{s:4:"text";N;s:5:"limit";N;s:7:"element";i:0;s:10:"parameters";a:0:{}}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:17:"theme_pager_first";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:14:"pager_previous";a:6:{s:9:"arguments";a:5:{s:4:"text";N;s:5:"limit";N;s:7:"element";i:0;s:8:"interval";i:1;s:10:"parameters";a:0:{}}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:20:"theme_pager_previous";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:10:"pager_next";a:6:{s:9:"arguments";a:5:{s:4:"text";N;s:5:"limit";N;s:7:"element";i:0;s:8:"interval";i:1;s:10:"parameters";a:0:{}}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:16:"theme_pager_next";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:10:"pager_last";a:6:{s:9:"arguments";a:4:{s:4:"text";N;s:5:"limit";N;s:7:"element";i:0;s:10:"parameters";a:0:{}}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:16:"theme_pager_last";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:10:"pager_link";a:6:{s:9:"arguments";a:5:{s:4:"text";N;s:8:"page_new";N;s:7:"element";N;s:10:"parameters";a:0:{}s:10:"attributes";a:0:{}}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:16:"theme_pager_link";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:26:"locale_admin_manage_screen";a:6:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:32:"theme_locale_admin_manage_screen";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:14:"menu_item_link";a:6:{s:9:"arguments";a:1:{s:4:"item";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:20:"theme_menu_item_link";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:9:"menu_tree";a:6:{s:9:"arguments";a:1:{s:4:"tree";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:15:"theme_menu_tree";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:9:"menu_item";a:6:{s:9:"arguments";a:3:{s:4:"link";N;s:12:"has_children";N;s:4:"menu";s:0:"";}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:15:"theme_menu_item";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:15:"menu_local_task";a:6:{s:9:"arguments";a:2:{s:4:"link";N;s:6:"active";b:0;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:21:"theme_menu_local_task";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:16:"menu_local_tasks";a:6:{s:8:"function";s:28:"phptemplate_menu_local_tasks";s:4:"type";s:12:"theme_engine";s:10:"theme path";s:14:"themes/garland";s:9:"arguments";a:0:{}s:11:"theme paths";a:2:{i:0;s:14:"modules/system";i:1;s:14:"themes/garland";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:6:"select";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:12:"theme_select";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:8:"fieldset";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:14:"theme_fieldset";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:5:"radio";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:11:"theme_radio";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:6:"radios";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:12:"theme_radios";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:16:"password_confirm";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:22:"theme_password_confirm";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:4:"date";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:10:"theme_date";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:4:"item";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:10:"theme_item";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:8:"checkbox";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:14:"theme_checkbox";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:10:"checkboxes";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:16:"theme_checkboxes";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:6:"submit";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:12:"theme_submit";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:6:"button";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:12:"theme_button";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:12:"image_button";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:18:"theme_image_button";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:6:"hidden";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:12:"theme_hidden";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:5:"token";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:11:"theme_token";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:9:"textfield";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:15:"theme_textfield";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:4:"form";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:10:"theme_form";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:8:"textarea";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:14:"theme_textarea";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:6:"markup";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:12:"theme_markup";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:8:"password";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:14:"theme_password";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:4:"file";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:10:"theme_file";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:12:"form_element";a:6:{s:9:"arguments";a:2:{s:7:"element";N;s:5:"value";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:18:"theme_form_element";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:24:"system_theme_select_form";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:31:"modules/system/system.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:30:"theme_system_theme_select_form";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:18:"system_themes_form";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:31:"modules/system/system.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:24:"theme_system_themes_form";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:14:"system_modules";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:31:"modules/system/system.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:20:"theme_system_modules";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:24:"system_modules_uninstall";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:31:"modules/system/system.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:30:"theme_system_modules_uninstall";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:13:"status_report";a:7:{s:9:"arguments";a:1:{s:12:"requirements";N;}s:4:"file";s:31:"modules/system/system.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:19:"theme_status_report";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:10:"admin_page";a:7:{s:9:"arguments";a:1:{s:6:"blocks";N;}s:4:"file";s:31:"modules/system/system.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:16:"theme_admin_page";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:11:"admin_block";a:7:{s:9:"arguments";a:1:{s:5:"block";N;}s:4:"file";s:31:"modules/system/system.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:17:"theme_admin_block";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:19:"admin_block_content";a:7:{s:9:"arguments";a:1:{s:7:"content";N;}s:4:"file";s:31:"modules/system/system.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:25:"theme_admin_block_content";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:22:"system_admin_by_module";a:7:{s:9:"arguments";a:1:{s:10:"menu_items";N;}s:4:"file";s:31:"modules/system/system.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:28:"theme_system_admin_by_module";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:17:"system_powered_by";a:6:{s:9:"arguments";a:1:{s:10:"image_path";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/system";s:8:"function";s:23:"theme_system_powered_by";s:11:"theme paths";a:1:{i:0;s:14:"modules/system";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:20:"taxonomy_term_select";a:6:{s:9:"arguments";a:1:{s:7:"element";N;}s:4:"type";s:6:"module";s:10:"theme path";s:16:"modules/taxonomy";s:8:"function";s:26:"theme_taxonomy_term_select";s:11:"theme paths";a:1:{i:0;s:16:"modules/taxonomy";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:18:"taxonomy_term_page";a:6:{s:9:"arguments";a:2:{s:4:"tids";a:0:{}s:6:"result";N;}s:4:"type";s:6:"module";s:10:"theme path";s:16:"modules/taxonomy";s:8:"function";s:24:"theme_taxonomy_term_page";s:11:"theme paths";a:1:{i:0;s:16:"modules/taxonomy";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:30:"taxonomy_overview_vocabularies";a:6:{s:9:"arguments";a:1:{s:4:"form";a:0:{}}s:4:"type";s:6:"module";s:10:"theme path";s:16:"modules/taxonomy";s:8:"function";s:36:"theme_taxonomy_overview_vocabularies";s:11:"theme paths";a:1:{i:0;s:16:"modules/taxonomy";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:23:"taxonomy_overview_terms";a:6:{s:9:"arguments";a:1:{s:4:"form";a:0:{}}s:4:"type";s:6:"module";s:10:"theme path";s:16:"modules/taxonomy";s:8:"function";s:29:"theme_taxonomy_overview_terms";s:11:"theme paths";a:1:{i:0;s:16:"modules/taxonomy";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:15:"update_settings";a:6:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/update";s:8:"function";s:21:"theme_update_settings";s:11:"theme paths";a:1:{i:0;s:14:"modules/update";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:13:"update_report";a:6:{s:9:"arguments";a:1:{s:4:"data";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/update";s:8:"function";s:19:"theme_update_report";s:11:"theme paths";a:1:{i:0;s:14:"modules/update";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:14:"update_version";a:6:{s:9:"arguments";a:3:{s:7:"version";N;s:3:"tag";N;s:5:"class";N;}s:4:"type";s:6:"module";s:10:"theme path";s:14:"modules/update";s:8:"function";s:20:"theme_update_version";s:11:"theme paths";a:1:{i:0;s:14:"modules/update";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:12:"user_picture";a:6:{s:9:"arguments";a:1:{s:7:"account";N;}s:8:"template";s:25:"modules/user/user-picture";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/user";s:11:"theme paths";a:1:{i:0;s:12:"modules/user";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:32:"template_preprocess_user_picture";}}s:12:"user_profile";a:7:{s:9:"arguments";a:1:{s:7:"account";N;}s:8:"template";s:25:"modules/user/user-profile";s:4:"file";s:27:"modules/user/user.pages.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/user";s:11:"theme paths";a:1:{i:0;s:12:"modules/user";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:32:"template_preprocess_user_profile";}}s:21:"user_profile_category";a:7:{s:9:"arguments";a:1:{s:7:"element";N;}s:8:"template";s:34:"modules/user/user-profile-category";s:4:"file";s:27:"modules/user/user.pages.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/user";s:11:"theme paths";a:1:{i:0;s:12:"modules/user";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:41:"template_preprocess_user_profile_category";}}s:17:"user_profile_item";a:7:{s:9:"arguments";a:1:{s:7:"element";N;}s:8:"template";s:30:"modules/user/user-profile-item";s:4:"file";s:27:"modules/user/user.pages.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/user";s:11:"theme paths";a:1:{i:0;s:12:"modules/user";}s:20:"preprocess functions";a:2:{i:0;s:19:"template_preprocess";i:1;s:37:"template_preprocess_user_profile_item";}}s:9:"user_list";a:6:{s:9:"arguments";a:2:{s:5:"users";N;s:5:"title";N;}s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/user";s:8:"function";s:15:"theme_user_list";s:11:"theme paths";a:1:{i:0;s:12:"modules/user";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:15:"user_admin_perm";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:27:"modules/user/user.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/user";s:8:"function";s:21:"theme_user_admin_perm";s:11:"theme paths";a:1:{i:0;s:12:"modules/user";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:19:"user_admin_new_role";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:27:"modules/user/user.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/user";s:8:"function";s:25:"theme_user_admin_new_role";s:11:"theme paths";a:1:{i:0;s:12:"modules/user";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:18:"user_admin_account";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:27:"modules/user/user.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/user";s:8:"function";s:24:"theme_user_admin_account";s:11:"theme paths";a:1:{i:0;s:12:"modules/user";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:16:"user_filter_form";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:27:"modules/user/user.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/user";s:8:"function";s:22:"theme_user_filter_form";s:11:"theme paths";a:1:{i:0;s:12:"modules/user";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:12:"user_filters";a:7:{s:9:"arguments";a:1:{s:4:"form";N;}s:4:"file";s:27:"modules/user/user.admin.inc";s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/user";s:8:"function";s:18:"theme_user_filters";s:11:"theme paths";a:1:{i:0;s:12:"modules/user";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}s:14:"user_signature";a:6:{s:9:"arguments";a:1:{s:9:"signature";N;}s:4:"type";s:6:"module";s:10:"theme path";s:12:"modules/user";s:8:"function";s:20:"theme_user_signature";s:11:"theme paths";a:1:{i:0;s:12:"modules/user";}s:20:"preprocess functions";a:1:{i:0;s:19:"template_preprocess";}}}	0	1250867119		1
\.


--
-- Data for Name: cache_block; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY cache_block (cid, data, expire, created, headers, serialized) FROM stdin;
\.


--
-- Data for Name: cache_filter; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY cache_filter (cid, data, expire, created, headers, serialized) FROM stdin;
2:53a757655ca17c88dcdaaf28e3e7ecb0	<p><img width="100%" height="226" src="/res/img/ldt.jpg" alt="" /></p>\\012<p align="justify"><a href="../res/img/ldt_300dpi.jpg">Copie d'&eacute;cran de Lignes de temps en 300 dpi</a></p>\\012<p align="justify">Le logiciel Lignes de temps met &agrave; profit les possibilit&eacute;s d&rsquo;analyse et de synth&egrave;se offertes par le support num&eacute;rique. Inspir&eacute;es par les &laquo;timelines&raquo; ordinairement utilis&eacute;es sur les bancs de montage num&eacute;rique, Lignes de temps propose une repr&eacute;sentation graphique d&rsquo;un film, r&eacute;v&eacute;lant d&rsquo;embl&eacute;e, et in extenso, son d&eacute;coupage. Lignes de temps offre en cela un acc&egrave;s in&eacute;dit au film, en substituant &agrave; la logique du d&eacute;filement contraint qui constitue l&rsquo;exp&eacute;rience de tout spectateur de cin&eacute;ma, et pour les besoins de l&rsquo;analyse, la &laquo;cartographie&raquo; d&rsquo;un objet temporel. Aussi, en s&eacute;lectionnant un segment d&rsquo;une ligne de temps, l&rsquo;utilisateur a-t-il acc&egrave;s directement au plan ou &agrave; la s&eacute;quence correspondante dans le film, s&eacute;quence qui peut &ecirc;tre d&eacute;crite et analys&eacute;e par des commentaires textuels, audio, vid&eacute;o, ou document&eacute;e par des images ou des liens Internet.<a href="#more"><br />\\012</a></p>\\012<h3>T&Eacute;L&Eacute;CHARGEMENT de <i>Lignes de temps</i> :</h3>\\012<p><a href="faq_lignesdetemps.html">? FAQ ?</a></p>\\012<p align="justify">T&eacute;l&eacute;charger d&egrave;s maintenant le logiciel &quot;Lignes de temps&quot;. Gr&acirc;ce &agrave; lui, analysez et annotez les films de votre choix.</p>\\012<ul>\\012<li><b>PC</b> :\\012<ul>\\012<li><a href="../apps/LignesDeTemps-0.10.7-Setup.exe">Version 0.10.7 simple (35 Mo)</a></li>\\012<li><a href="../apps/LignesDeTempsNosferatu-0.10.7-Setup.exe">Version 0.10.7 contenant le film Nosferatu de F.W. Murnau d&eacute;crit et document&eacute; (205 Mo)</a> <a target="_blank" href="http://creativecommons.org/s/publicdomain/deed.fr"><img alt="Creative Commons" src="../res/img/creativecommons.jpg" /></a></li>\\012</ul>\\012</li>\\012</ul>\\012<ul>\\012<li><b>MAC</b> (voir la <a href="faq_lignesdetemps.html">FAQ</a> pour conna&icirc;tre votre configuration) :\\012<ul>\\012<li><a href="../apps/LignesDeTemps.0.10.7.ppc.dmg">Version 0.10.7 Power PC - OS 10.4 tiger (51 Mo)</a></li>\\012<li><a href="../apps/LignesdeTemps.0.10.7.intel.dmg">Version 0.10.7 Intel - OS 10.5 leopard (21 Mo)</a></li>\\012</ul>\\012</li>\\012</ul>\\012<p align="justify">Une fois t&eacute;l&eacute;charg&eacute;, lancez l'installeur et suivez les &eacute;tapes propos&eacute;es. Une fois install&eacute;, importez un contenu vid&eacute;o (formats avi, mpg, mov ou flv) ou audio (mp3) en passant par le menu Fichier -&gt; Importer.</p>\\012<p align="justify">Notes importantes sur l'utilisation de &quot;Lignes de temps&quot;:</p>\\012<ul>\\012<li>En fonction de la puissance de votre ordinateur et de la taille du fichier, l'import peut durer de quelques minutes &agrave; plusieurs dizaines de minutes.</li>\\012<li>Cette version est une <u>version beta</u>, c'est-&agrave;-dire qu'elle contient encore des bogues. Malgr&eacute; tous nos efforts, il se peut donc que le logiciel soit instable et se bloque par moments, rendant la sauvegarde du travail impossible, et que certaines vid&eacute;os ne soient pas importables. Voir les <a href="faq_lignesdetemps.html">FAQ</a></li>\\012</ul>\\012<p align="justify">En savoir plus sur le logiciel : <a target="_blank" href="../res/media/flyer_ldt_fr.pdf">Flyer de pr&eacute;sentation</a>, <a target="_blank" href="../res/media/ldt_userguide_fr.pdf">mode d'emploi</a> et <a target="_blank" href="../res/media/license_lignesdetemps.txt">Licence</a>.</p>\\012<p align="justify">Vous pouvez acc&eacute;der directement &agrave; la <a href="http://web.iri.centrepompidou.fr/demo_entretiens_lignesdetemps.html">d&eacute;monstration</a> et &agrave; la consultation du film <a href="http://web.iri.centrepompidou.fr/lignesdetemps_nosferatu.html"><i>Nosferatu</i> de F.W. Murnau dans &quot;Lignes de temps&quot;</a>.</p>\\012<p align="justify">Pour toute information, feedback ou probl&egrave;me, <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a>.</p>\\012<p align="justify"><b>Plus d'information :</b>              <br />\\012&Agrave; ce premier stade d&rsquo;analyse permettant de parcourir le film plan par plan, peuvent s&rsquo;ajouter d&rsquo;autres param&egrave;tres &agrave; partir desquels il est possible de              construire d&rsquo;autres &laquo;lignes de temps&raquo; parall&egrave;les au d&eacute;roulement du film, et d&rsquo;orienter des explorations multiples, en fonction des &eacute;chelles de plan,              des mouvements de cam&eacute;ra, des entr&eacute;es et sorties de champ et potentiellement de toute forme objectivable. Autant de mani&egrave;res de multiplier les approches,              mais plus encore de visualiser, par comparaison et combinaison des crit&egrave;res de pertinence, des effets de sens, d&rsquo;actualiser, par exemple, des r&eacute;currences et des sym&eacute;tries.</p>\\012<p align="justify"><b>Pour appareiller les pratiques &laquo;amateurs&raquo; :</b>             <br />\\012D&rsquo;ores et d&eacute;j&agrave; des historiens, des critiques, des th&eacute;oriciens, des &eacute;tudiants d&rsquo;&eacute;coles d&rsquo;art et de cin&eacute;ma ont accept&eacute; de s&rsquo;emparer de ces outils pour              v&eacute;rifier des hypoth&egrave;ses qu&rsquo;ils avaient formul&eacute;es, pour en explorer de nouvelles et permettre, &agrave; travers ce travail, l&rsquo;expertise, la critique, l&rsquo;enrichissement,              voire le d&eacute;tournement de ces dispositifs. B&eacute;n&eacute;ficiant de l&rsquo;exp&eacute;rience d&rsquo;une communaut&eacute; experte en mati&egrave;re d&rsquo;analyse cin&eacute;matographique, de nouveaux cercles              d&rsquo;amateurs d&eacute;veloppent progressivement de nouvelles &laquo;pratiques&raquo; de Lignes de temps. C&rsquo;est notamment le cas des professeurs de l&rsquo;enseignement primaire              et secondaire (&eacute;coles, coll&egrave;ges, lyc&eacute;es) abordant l&rsquo;&eacute;tude du cin&eacute;ma et plus largement des cin&eacute;philes d&eacute;sireux de concr&eacute;tiser leur appr&eacute;hension              d&rsquo;un film, leurs souvenirs, leurs impressions, leurs r&eacute;flexions, sur un support appropri&eacute; &agrave; ces contenus temporels.</p>\\012<p align="justify"><a target="_blank" href="http://shotdetect.nonutc.fr">Le logiciel shotdetect d&eacute;velopp&eacute; par l'IRI : d&eacute;tection automatique de plans</a></p>\\012<p><a target="_blank" href="http://www.carrefourdespossibles.org/jsp/fiche_actualite.jsp?STNAV=&amp;RUBNAV=&amp;CODE=1210934670659&amp;LANGUE=0&amp;RH=DESCRIPTIF"><i>Lignes de temps</i> pr&eacute;sent&eacute; au Carrefour des possibles de la FING le 15 mai 2008</a></p>\\012<p><a target="_blank" href="http://www.culture.gouv.fr/culture/editions/r-cr.htm">Lire un article sur <i>Lignes de temps</i> dans le num&eacute;ro 112 de <i>Culture &amp; Recherche</i></a><br />\\012<a target="_blank" href="../res/media/ArticleAmateurs_V.Puig-nov08.pdf">Lire un article sur <i>Les amateurs du XXI&egrave;me si&egrave;cle</i> dont un extrait a paru dans le num&eacute;ro 118-119 de <i>Culture &amp; Recherche</i></a></p>\\012	1249134515	1249048115		0
2:3dabb4733e90f8f32af7793aebe99370	<p class="rteright"><a href="/lignes_de_temps_faq">Version fran&ccedil;aise</a></p>\\012<p>The software <i>Lignes de temps</i> is divided in two parts: system and interface.           <br />\\012The first one is not visible for users; it allows to record the work done (notes, sequences, rough-cut) in a file. It also permits to launch programs necessary to import an audio or video file. These programs encode video in order that it can be visible in the interface and that it can produce the shot by shot and the sound wave. <br />\\012The interface is composed by all the elements visible and controlled by users. It is composed by the top left menu (File, Display) and by three windows: Informations, the media player, and the one who displays the lignes de temps. <br />\\012The two parts of the program are connected but the communication can sometimes be interrupted, without any notification. In this case, the work can not unfortunately be recorded. The Institute for research and innovation works on those different problems. For any information, feedback or problem : <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a><br />\\012A work on <i>Lignes de temps</i> is saved in a project file (ldt extension) which holds references towards the media used and the personal data (notes, sequences, rough-cut). The non-personal data on one media (shot by shot and sound wave for example) are recorded in an iri extension file.</p>\\012<ul>\\012<li><b>I use a Mac, how can I know which is my configuration ?</b><br />\\012    To know if your computer is &quot;Intel&quot; or &quot;Power PC&quot;, you have to go in the Apple menu up left on the screen. In the menu, click on &quot;About this Mac&quot;. The line &quot;Processor&quot; indicates the type of configuration &quot;Intel&quot; or &quot;Power PC&quot;.<br />\\012    After many tests, it seems that <i>Lignes de temps</i> just settles on the computers with the operating system 10.5 called &quot;leopard&quot;, the 10.4 one called &quot;tiger&quot;, the Intel processor, or with the Power PC processor.</li>\\012<li><b>I do not succeed in displaying movies :</b><br />\\012    To display those lignes de temps, you have to click on the movie title in the lignes de temps window then on the tab &quot;Cuttings&quot;. In this tab, appears the list of the available sequences; you just have to click on one of them to display the corresponding ligne de temps.</li>\\012<li><b>I do not succeed in importing an audio or video file :</b><br />\\012    You have to make sure that the file extension can match. <i>Lignes de temps</i> takes into account avi, mpg, mov, flv extension for video and mp3 for audio. Then, even if this one is accepted, the encoding can not match with the program (ffmpeg) which transforms this file in a video readable in <i>Lignes de temps</i>, that is to say in the flv format. Even if the file extension is correct, some characters block the import. Thus, you should prefer naming your file without the following characters : accented characters, space, &ccedil;, #, &amp;, %, !, *, (), [], |, {}, :, ;, @.</li>\\012<li><b>I do not succeed in saving my work :</b><br />\\012    As it is explained in the introduction, this problem can come from a communication failure between the interface and the program part which records the work in a file. To record the works, we can go through the up left menu (Fichier -- Enregistrer) or through the hot key Ctrl+S on PCs and Apple+S on Macs. In general, when a work has been modified since the last recording, a star appears close the movie title in order to warn about a required recording.</li>\\012</ul>\\012<p>&nbsp;</p>\\012<p><b>Release notes about Lignes de temps 0.10.8 :</b></p>\\012<ul>\\012<li>Possibility to display the video in fullscreen with black background</li>\\012<li>Possibility to display a permalink for a segment</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps from 0.10.4 to 0.10.7 :</b></p>\\012<ul>\\012<li>Possibility to import cuttings from an other ldt file</li>\\012<li>Possibility to stream a video with rtmp://...</li>\\012<li>Possibility to move timelines and contents by simple drag and drop</li>\\012<li>Ergonomic improvements (ldt file name int the information window, zoom more fluid, possibility to save our default language)</li>\\012<li>Possibility to duplicate a timeline's highlighted segments</li>\\012<li>Debug</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.10.3 :</b></p>\\012<ul>\\012<li>Japanese language added</li>\\012<li>Debug</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.10 :</b></p>\\012<ul>\\012<li>MULTILINGUAL INTERFACE with English and French available by default and possibility to add some languages by yourself (the steps are explained in the <a href="/res/media/ldt_userguide_en.pdf" target="_blank">user guide</a> thanks to the GETTEXT tool)</li>\\012<li>Interface and ergonomy completely rebuilt, with for exemple buttons with icons, new tabs more visible, tool tips, confirmation messages before deleting.</li>\\012<li>Views : rename and move by drag and drop.</li>\\012<li>Tags : the complete project's tags list can be displayed from the top left menu or the shortcut Shift + T.</li>\\012<li>Note taking : better management of scroll position, timecode indicated on seperator roll over.</li>\\012<li>Bout &agrave; bout (edit) : an edit can now be deleted.</li>\\012<li>Bug <a href="/dev/trac/ldt" target="_blank">trac</a> added.</li>\\012<li>Complete user guide in <a href="/res/media/ldt_userguide_fr.pdf" target="_blank">french</a> and <a href="/res/media/ldt_userguide_en.pdf" target="_blank">english</a>.</li>\\012<li>License added in the &quot;About&quot;.</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.9.4 :</b></p>\\012<ul>\\012<li>New note-taking functionnality, enabling to write notes on the fly, then to transform them into a cutting.</li>\\012<li>Views : the display states backup includes now the zoom level, the horizontal scroll position and if a &quot;bout &agrave; bout&quot; is playing.</li>\\012<li>Improvement of tags addition : possibility to display a window with all the timeline's tags and to add one of them by simple click.</li>\\012<li>Possibility to display all the project's tags in a large window thanks to the shortcut Shift + F.</li>\\012<li>Possibility to highlight the segments by clicking one of the timeline's tags. 5 colors are available (one per tag), then requested segments are displayed in white.</li>\\012<li>Possibility to duplicate a timeline from highlighted segments only.</li>\\012<li>Possibility to create a bout &agrave; bout from a complete timeline or highlighted segments.</li>\\012<li>Addition of error messages when the software crashes. They limit the risk of work loss.</li>\\012</ul>\\012<p>\\012<b>Release notes about Lignes de temps 0.9.2 :</b></p>\\012<ul>\\012<li>Possibility of duplicating any line (duplication button in the Informations window).</li>\\012<li>Presence of the tag field for segments.</li>\\012<li>Possibility of displaying a sequence's summary, that is to say the sequences'list as a clickable text.</li>\\012<li>Debug of identified bugs in the previous version.</li>\\012<li>Interface's modifications : the &quot;Informations&quot; window enlarged in height and width, and the read-out window enlarged in width.</li>\\012</ul>\\012<p>&nbsp;</p>\\012	1249137800	1249051400		0
2:dda21bdb03ac6a8518a391b4beea93f1	<p>Projet - Etapes - G&eacute;n&eacute;rique</p>\\012<p><strong>Un projet d&rsquo;&eacute;changes culturels entre&nbsp; jeunes de la Communaut&eacute; europ&eacute;enne / 2008-2009</strong><br />\\012&laquo; Films-essais &raquo; / &laquo; Films-regards &raquo; / &laquo; Regards sign&eacute;s Lignes de temps &raquo; / D&eacute;bats&hellip; </p>\\012<p>2008 &ndash; Ann&eacute;e europ&eacute;enne du dialogue interculturel<br />\\0122009 &ndash; Ann&eacute;e europ&eacute;enne de la cr&eacute;ativit&eacute; et de l&rsquo;innovation</p>\\012<p><strong>Regards crois&eacute;s sur la ville, &eacute;changes de points de vue, cr&eacute;ation&hellip; </strong><br />\\012&nbsp;&laquo; Ma ville vue par&hellip;&nbsp; &raquo; vise &agrave; encourager l&rsquo;&eacute;change culturel entre jeunes gens de l&rsquo;Union europ&eacute;enne via une approche analytique et cr&eacute;ative du cin&eacute;ma.</p>\\012<p><strong>Une collaboration</strong><br />\\012Centre Pompidou / Institut de recherche et d&rsquo;innovation / Maison du geste et de l&rsquo;image</p>\\012<p><strong>Liens :</strong><br />\\012<a href="http://www.mgi-paris.org/site2009/index.php" target="_blank">http://www.mgi-paris.org/site2009/index.php</a><br />\\012<a href="http://www.centrepompidou.fr/" target="_blank">http://www.centrepompidou.fr/</a></p>\\012<p><strong>Etablissements europ&eacute;ens partenaires</strong><br />\\012Berufskolleg, Herzogenrath, (Allemagne)<br />\\012Colegiul national B.P. Hasdeu, Buzau (Roumanie)<br />\\012Colegiul national I. C. Bratianu, Pitesti (Roumanie)<br />\\012Colegiul national Mihai Eminescu, Iasi (Roumanie)<br />\\012Colegiul national Radu Negru, Fagaras (Roumanie) <br />\\012Coll&egrave;ge Thomas Mann, Paris 13&egrave;me (France)<br />\\012Coll&egrave;ge Darius Milhaud, Sartrouville (France)<br />\\012Coll&egrave;ge Jean Moulin, Paris 14&egrave;me (France)<br />\\012Ecole &agrave; aires ouvertes Saint-Merri et Renard, Paris 4&egrave;me (France)<br />\\012Ecole &eacute;l&eacute;mentaire Maurice Genevoix, Paris 18&egrave;me (France)<br />\\012Liceo classico M. Gioia, Piacenza (Italie) <br />\\012Lyc&eacute;e Maurice Ravel, Paris 20&egrave;me (France)<br />\\012Lyc&eacute;e Paul Val&eacute;ry, Paris 12&egrave;me (France)<br />\\012Scuola centrala n&deg; 10, Bucarest (Roumanie)<br />\\012Scuola media Irnerio, Bologne (Italie)<br />\\012&nbsp;</p>\\012<p><div>Le projet europ&eacute;en &laquo;&nbsp;Ma ville vue par&hellip;&nbsp;&raquo; a &eacute;t&eacute; initi&eacute; dans le cadre du <b>D&eacute;partement du d&eacute;veloppement culturel / Centre Pompidou</b> en mai 2008. Il fait suite au travail d&rsquo;exp&eacute;rimentation sur le cin&eacute;ma avec le logiciel <i>Lignes de temps</i><span> men&eacute; lors de la programmation au Centre Pompidou des films de V&iacute;ctor Erice et d&rsquo;Abbas Kiarostami. </span></div>\\012<div>Fond&eacute;<span> en avril 2006 au sein du DDC-Centre Pompidou et constitu&eacute; en association depuis ao&ucirc;t 2008, <b>l</b><b>'Institut de recherche et d'innovation</b></span> travaille sur l'&eacute;tude et le d&eacute;veloppement de technologies culturelles et <span>cognitives favorisant l'&eacute;mergence de nouvelles pratiques amateurs. L&rsquo;Iri met librement &agrave; la disposition du public le logiciel <i>Lignes de temps,</i> accompagn&eacute; pour ce type de projet, d&rsquo;une analyse document&eacute;e et comment&eacute;e des films &eacute;tudi&eacute;s. </span></div>\\012<div>La <b>Maison du geste et de l&rsquo;image</b>, centre de recherche et d&rsquo;&eacute;ducation artistique est aussi une structure de &laquo;&nbsp;m&eacute;diation&nbsp;&raquo; culturelle. Interm&eacute;diaire entre les &eacute;tablissements scolaires et culturels, la MGI accompagne et coordonne des projets, en initie, propose des formations et des pr&eacute;sentations li&eacute;es &agrave; l&rsquo;initiation artistique des publics jeunes. Il s&rsquo;agit de mettre ce public au contact direct de la  cr&eacute;ation et des cr&eacute;ateurs, de lui permettre de s&rsquo;engager dans une d&eacute;marche de cr&eacute;ation collective.</div>\\012<div>&nbsp;</div>\\012<div>Le cin&eacute;ma et la citoyennet&eacute; <b><span>Rencontres</span></b><b> europ&eacute;ennes&nbsp;; &eacute;changes culturels&nbsp;; partage de connaissance&nbsp;; &eacute;changes de points de vue&hellip;</b></div>\\012<div><b>&nbsp;</b></div>\\012<div>Le cin&eacute;ma et la ville<span>  &nbsp;Regards crois&eacute;s sur la ville, &eacute;changes de points de vue, cr&eacute;ation&nbsp;; </span>Innovation&nbsp;; d&eacute;couverte du langage cin&eacute;matographique&nbsp;; cr&eacute;ativit&eacute;&nbsp;; parcours guid&eacute; de cr&eacute;ation aux fins d&rsquo;une correspondance entre bin&ocirc;mes sous forme de production de &laquo;&nbsp;films-essais&nbsp;&raquo; sur sa propre ville (sc&eacute;narisation, tournage, montage)&nbsp;; exploration du point de vue d&rsquo;autrui &agrave; travers la relecture de son propre film par les autres&nbsp;(montage d&rsquo;un &laquo;&nbsp;film-regard&nbsp;&raquo; &agrave; partir des rushes produits par son partenaire)&nbsp;; projections des films&nbsp;; rencontres des participants&hellip;.</div>\\012<div>Le cin&eacute;ma entretient, depuis son origine, (Les fr&egrave;res Lumi&egrave;re&nbsp;: <i>L&rsquo;Arriv&eacute;e d&rsquo;un train en gare de la Ciotat</i>) un rapport privil&eacute;gi&eacute; avec la  ville. D&eacute;cor autant que personnage la ville occupe une place centrale dans bien des &oelig;uvres, &agrave; tel point que son image fictionnelle prend parfois le pas sur la r&eacute;alit&eacute;. Sa pr&eacute;sence impr&egrave;gne les films d&rsquo;une aura particuli&egrave;re et les place sous le sceau d&rsquo;une culture.</div>\\012<div>L&rsquo;espace urbain comprend une identit&eacute; forte, r&eacute;v&eacute;latrice du pays et de son histoire. Il incarne une culture tout enti&egrave;re. Et, si chacun entretient un rapport affectif avec sa propre ville, celle de l&rsquo;autre ne repr&eacute;sente trop souvent qu&rsquo;une carte postale, un souvenir ou un voyage imaginaire. Parler de sa ville &agrave; l&rsquo;autre, ou de la ville de l&rsquo;autre, c&rsquo;est partager une intimit&eacute;, une identit&eacute;, bien au-del&agrave; des clich&eacute;s. C&rsquo;est offrir un quotidien, un regard authentique sur sa vie. Par l&rsquo;&eacute;change des exp&eacute;riences et des regards, le cin&eacute;ma peut devenir le lieu d&rsquo;une telle rencontre.</div>\\012<div>&nbsp;</div>\\012<div>Les films de r&eacute;f&eacute;rence Les films propos&eacute;s &agrave; l&rsquo;analyse aux &eacute;l&egrave;ves partenaires du projet &nbsp;sont &laquo;&nbsp;Le Cam&eacute;raman&nbsp;&raquo; d&rsquo;Edward Sedgwick et Buster Keaton, avec Buster Keaton et &laquo;&nbsp;L&rsquo;Aurore&nbsp;&raquo; de Wilhelm Friedrich Murnau.</div>\\012<div>&nbsp;</div>\\012<div>Le Cam&eacute;raman</div>\\012<div>Etats-Unis 1928</div>\\012<div>Cor&eacute;alisation&nbsp;: Buster Keaton, Edward Sedgwick</div>\\012<div>Avec Buster Keaton, Marceline Day, Harold Goodwin</div>\\012<div align="left">Les aventures de Buster, photographe de rue, sp&eacute;cialis&eacute; dans les daguerr&eacute;otypes dans le New York des ann&eacute;es 20.</div>\\012<div><a href="http://fr.wikipedia.org/wiki/Le_Cameraman" target="_blank">http://fr.wikipedia.org/wiki/Le_Cameraman</a></div>\\012<div align="left"><a href="http://www.cineclubdecaen.com/realisat/keaton/cameraman.htm" target="_blank">http://www.cineclubdecaen.com/realisat/keaton/cameraman.htm</a></div>\\012<div align="left"><a href="http://www.critikat.com/Le-Cameraman.html" target="_blank">http://www.critikat.com/Le-Cameraman.html</a></div>\\012<div>&nbsp;</div>\\012<div>Sunrise&nbsp;- Aurore (L')</div>\\012<div>Etats-Unis, 1927</div>\\012<div>R&eacute;alisation&nbsp; Friedrich-Wilhelm Murnau</div>\\012<div>Sc&eacute;nario : Friedrich-Wilhelm Murnau d'apr&egrave;s <i><span>Le Voyage &agrave; Tilsitt</span></i> de Hermann S&uuml;dermann</div>\\012<div>Avec George O'Brien, Janet Gaynor, Margaret Livingstone, Bodil Rosing</div>\\012<div>Photo Karl Struss, Charles Rosher</div>\\012<div>Musique&nbsp;Dr Hugo Riesenfeld</div>\\012<div>Dur&eacute;e&nbsp;1h20</div>\\012<div>S&eacute;duit par une intrigante de la ville, un fermier tente de noyer son &eacute;pouse lors d'une promenade sur le lac. Pris de remords, il ne parvient pas &agrave; commettre son crime. La jeune femme s&rsquo;enfuit.</div>\\012<div><a href="http://fr.wikipedia.org/wiki/L%27Aurore_%28film,_1927%29" target="_blank">http://fr.wikipedia.org/wiki/L'Aurore_(film,_1927)</a></div>\\012<div><a href="http://www.abc-lefrance.com/fiches/Aurore.pdf" target="_blank">http://www.abc-lefrance.com/fiches/Aurore.pdf</a></div>\\012<div><a href="http://www.cineclubdecaen.com/realisat/murnau/aurore.htm" target="_blank">http://www.cineclubdecaen.com/realisat/murnau/aurore.htm</a>).</div>\\012<div><b>&nbsp;</b></div>\\012<div>Le r&eacute;seau d&rsquo;&eacute;tablissements scolaires constitu&eacute; &agrave; partir des partenariats d&eacute;j&agrave; engag&eacute;s lors du projet Erice-Kiarostami s&rsquo;est &eacute;tendu &agrave; l&rsquo;Europe. Il r&eacute;unit une quinzaine d&rsquo;&eacute;tablissements pour une vingtaine de bin&ocirc;mes de m&ecirc;me niveau et qui travaillent selon les cas dans ou hors temps scolaire.</div>\\012<div>&nbsp;</div>\\012<div>Les pays participants Allemagne, France, Italie, Roumanie&hellip;</div>\\012<div>&nbsp;</div>\\012<div>Les (bin&ocirc;mes Une fois form&eacute;s - groupe ou classe fran&ccedil;aise et groupe ou classe d&rsquo;un pays europ&eacute;en -, r&eacute;unis en fonction de l&rsquo;&acirc;ge, du niveau, ainsi que des demandes sp&eacute;cifiques des participants), la relation &nbsp;des partenaires s&rsquo;organise autour d&rsquo;une s&eacute;rie d&rsquo;&eacute;tapes envisag&eacute;es avec les enseignants.</div>\\012</p>\\012	1249381823	1249295423		0
2:ed2276f8a4f61a112fab9d0b4bf8d4ff	<p>Projet - <a href="/ma_ville_vue_par/etapes">Etapes</a> - <a href="/ma_ville_vue_par/generique">G&eacute;n&eacute;rique</a> - <a href="/ma_ville_vue_par/binomes">Bin&ocirc;mes</a></p>\\012<p>&nbsp;</p>\\012<p><strong>Un projet d&rsquo;&eacute;changes culturels entre&nbsp; jeunes de la Communaut&eacute; europ&eacute;enne / 2008-2009</strong><br />\\012&laquo; Films-essais &raquo; / &laquo; Films-regards &raquo; / &laquo; Regards sign&eacute;s Lignes de temps &raquo; / D&eacute;bats&hellip;</p>\\012<p>2008 &ndash; Ann&eacute;e europ&eacute;enne du dialogue interculturel<br />\\0122009 &ndash; Ann&eacute;e europ&eacute;enne de la cr&eacute;ativit&eacute; et de l&rsquo;innovation</p>\\012<p><strong>Regards crois&eacute;s sur la ville, &eacute;changes de points de vue, cr&eacute;ation&hellip; </strong><br />\\012&nbsp;&laquo; Ma ville vue par&hellip;&nbsp; &raquo; vise &agrave; encourager l&rsquo;&eacute;change culturel entre jeunes gens de l&rsquo;Union europ&eacute;enne via une approche analytique et cr&eacute;ative du cin&eacute;ma.</p>\\012<p><strong>Une collaboration</strong><br />\\012Centre Pompidou / Institut de recherche et d&rsquo;innovation / Maison du geste et de l&rsquo;image</p>\\012<p><strong>Liens :</strong><br />\\012<a href="http://www.mgi-paris.org/site2009/index.php" target="_blank">http://www.mgi-paris.org/site2009/index.php</a><br />\\012<a href="http://www.centrepompidou.fr/" target="_blank">http://www.centrepompidou.fr/</a></p>\\012<p><strong>Etablissements europ&eacute;ens partenaires</strong><br />\\012Berufskolleg, Herzogenrath, (Allemagne)<br />\\012Colegiul national B.P. Hasdeu, Buzau (Roumanie)<br />\\012Colegiul national I. C. Bratianu, Pitesti (Roumanie)<br />\\012Colegiul national Mihai Eminescu, Iasi (Roumanie)<br />\\012Colegiul national Radu Negru, Fagaras (Roumanie) <br />\\012Coll&egrave;ge Thomas Mann, Paris 13&egrave;me (France)<br />\\012Coll&egrave;ge Darius Milhaud, Sartrouville (France)<br />\\012Coll&egrave;ge Jean Moulin, Paris 14&egrave;me (France)<br />\\012Ecole &agrave; aires ouvertes Saint-Merri et Renard, Paris 4&egrave;me (France)<br />\\012Ecole &eacute;l&eacute;mentaire Maurice Genevoix, Paris 18&egrave;me (France)<br />\\012Liceo classico M. Gioia, Piacenza (Italie) <br />\\012Lyc&eacute;e Maurice Ravel, Paris 20&egrave;me (France)<br />\\012Lyc&eacute;e Paul Val&eacute;ry, Paris 12&egrave;me (France)<br />\\012Scuola centrala n&deg; 10, Bucarest (Roumanie)<br />\\012Scuola media Irnerio, Bologne (Italie)<br />\\012&nbsp;</p>\\012<p>&nbsp;</p>\\012<div>Le projet europ&eacute;en &laquo;&nbsp;Ma ville vue par&hellip;&nbsp;&raquo; a &eacute;t&eacute; initi&eacute; dans le cadre du <b>D&eacute;partement du d&eacute;veloppement culturel / Centre Pompidou</b> en mai 2008. Il fait suite au travail d&rsquo;exp&eacute;rimentation sur le cin&eacute;ma avec le logiciel <i>Lignes de temps</i><span> men&eacute; lors de la programmation au Centre Pompidou des films de V&iacute;ctor Erice et d&rsquo;Abbas Kiarostami. </span></div>\\012<div>Fond&eacute;<span> en avril 2006 au sein du DDC-Centre Pompidou et constitu&eacute; en association depuis ao&ucirc;t 2008, <b>l</b><b>'Institut de recherche et d'innovation</b></span> travaille sur l'&eacute;tude et le d&eacute;veloppement de technologies culturelles et <span>cognitives favorisant l'&eacute;mergence de nouvelles pratiques amateurs. L&rsquo;Iri met librement &agrave; la disposition du public le logiciel <i>Lignes de temps,</i> accompagn&eacute; pour ce type de projet, d&rsquo;une analyse document&eacute;e et comment&eacute;e des films &eacute;tudi&eacute;s. </span></div>\\012<div>La <b>Maison du geste et de l&rsquo;image</b>, centre de recherche et d&rsquo;&eacute;ducation artistique est aussi une structure de &laquo;&nbsp;m&eacute;diation&nbsp;&raquo; culturelle. Interm&eacute;diaire entre les &eacute;tablissements scolaires et culturels, la MGI accompagne et coordonne des projets, en initie, propose des formations et des pr&eacute;sentations li&eacute;es &agrave; l&rsquo;initiation artistique des publics jeunes. Il s&rsquo;agit de mettre ce public au contact direct de la  cr&eacute;ation et des cr&eacute;ateurs, de lui permettre de s&rsquo;engager dans une d&eacute;marche de cr&eacute;ation collective.</div>\\012<div>&nbsp;</div>\\012<div>Le cin&eacute;ma et la citoyennet&eacute; <b><span>Rencontres</span></b><b> europ&eacute;ennes&nbsp;; &eacute;changes culturels&nbsp;; partage de connaissance&nbsp;; &eacute;changes de points de vue&hellip;</b></div>\\012<div><b>&nbsp;</b></div>\\012<div>Le cin&eacute;ma et la ville<span>  &nbsp;Regards crois&eacute;s sur la ville, &eacute;changes de points de vue, cr&eacute;ation&nbsp;; </span>Innovation&nbsp;; d&eacute;couverte du langage cin&eacute;matographique&nbsp;; cr&eacute;ativit&eacute;&nbsp;; parcours guid&eacute; de cr&eacute;ation aux fins d&rsquo;une correspondance entre bin&ocirc;mes sous forme de production de &laquo;&nbsp;films-essais&nbsp;&raquo; sur sa propre ville (sc&eacute;narisation, tournage, montage)&nbsp;; exploration du point de vue d&rsquo;autrui &agrave; travers la relecture de son propre film par les autres&nbsp;(montage d&rsquo;un &laquo;&nbsp;film-regard&nbsp;&raquo; &agrave; partir des rushes produits par son partenaire)&nbsp;; projections des films&nbsp;; rencontres des participants&hellip;.</div>\\012<div>Le cin&eacute;ma entretient, depuis son origine, (Les fr&egrave;res Lumi&egrave;re&nbsp;: <i>L&rsquo;Arriv&eacute;e d&rsquo;un train en gare de la Ciotat</i>) un rapport privil&eacute;gi&eacute; avec la  ville. D&eacute;cor autant que personnage la ville occupe une place centrale dans bien des &oelig;uvres, &agrave; tel point que son image fictionnelle prend parfois le pas sur la r&eacute;alit&eacute;. Sa pr&eacute;sence impr&egrave;gne les films d&rsquo;une aura particuli&egrave;re et les place sous le sceau d&rsquo;une culture.</div>\\012<div>L&rsquo;espace urbain comprend une identit&eacute; forte, r&eacute;v&eacute;latrice du pays et de son histoire. Il incarne une culture tout enti&egrave;re. Et, si chacun entretient un rapport affectif avec sa propre ville, celle de l&rsquo;autre ne repr&eacute;sente trop souvent qu&rsquo;une carte postale, un souvenir ou un voyage imaginaire. Parler de sa ville &agrave; l&rsquo;autre, ou de la ville de l&rsquo;autre, c&rsquo;est partager une intimit&eacute;, une identit&eacute;, bien au-del&agrave; des clich&eacute;s. C&rsquo;est offrir un quotidien, un regard authentique sur sa vie. Par l&rsquo;&eacute;change des exp&eacute;riences et des regards, le cin&eacute;ma peut devenir le lieu d&rsquo;une telle rencontre.</div>\\012<div>&nbsp;</div>\\012<div>Les films de r&eacute;f&eacute;rence Les films propos&eacute;s &agrave; l&rsquo;analyse aux &eacute;l&egrave;ves partenaires du projet &nbsp;sont &laquo;&nbsp;Le Cam&eacute;raman&nbsp;&raquo; d&rsquo;Edward Sedgwick et Buster Keaton, avec Buster Keaton et &laquo;&nbsp;L&rsquo;Aurore&nbsp;&raquo; de Wilhelm Friedrich Murnau.</div>\\012<div>&nbsp;</div>\\012<div>Le Cam&eacute;raman</div>\\012<div>Etats-Unis 1928</div>\\012<div>Cor&eacute;alisation&nbsp;: Buster Keaton, Edward Sedgwick</div>\\012<div>Avec Buster Keaton, Marceline Day, Harold Goodwin</div>\\012<div align="left">Les aventures de Buster, photographe de rue, sp&eacute;cialis&eacute; dans les daguerr&eacute;otypes dans le New York des ann&eacute;es 20.</div>\\012<div><a href="http://fr.wikipedia.org/wiki/Le_Cameraman" target="_blank">http://fr.wikipedia.org/wiki/Le_Cameraman</a></div>\\012<div align="left"><a href="http://www.cineclubdecaen.com/realisat/keaton/cameraman.htm" target="_blank">http://www.cineclubdecaen.com/realisat/keaton/cameraman.htm</a></div>\\012<div align="left"><a href="http://www.critikat.com/Le-Cameraman.html" target="_blank">http://www.critikat.com/Le-Cameraman.html</a></div>\\012<div>&nbsp;</div>\\012<div>Sunrise&nbsp;- Aurore (L')</div>\\012<div>Etats-Unis, 1927</div>\\012<div>R&eacute;alisation&nbsp; Friedrich-Wilhelm Murnau</div>\\012<div>Sc&eacute;nario : Friedrich-Wilhelm Murnau d'apr&egrave;s <i><span>Le Voyage &agrave; Tilsitt</span></i> de Hermann S&uuml;dermann</div>\\012<div>Avec George O'Brien, Janet Gaynor, Margaret Livingstone, Bodil Rosing</div>\\012<div>Photo Karl Struss, Charles Rosher</div>\\012<div>Musique&nbsp;Dr Hugo Riesenfeld</div>\\012<div>Dur&eacute;e&nbsp;1h20</div>\\012<div>S&eacute;duit par une intrigante de la ville, un fermier tente de noyer son &eacute;pouse lors d'une promenade sur le lac. Pris de remords, il ne parvient pas &agrave; commettre son crime. La jeune femme s&rsquo;enfuit.</div>\\012<div><a href="http://fr.wikipedia.org/wiki/L%27Aurore_%28film,_1927%29" target="_blank">http://fr.wikipedia.org/wiki/L'Aurore_(film,_1927)</a></div>\\012<div><a href="http://www.abc-lefrance.com/fiches/Aurore.pdf" target="_blank">http://www.abc-lefrance.com/fiches/Aurore.pdf</a></div>\\012<div><a href="http://www.cineclubdecaen.com/realisat/murnau/aurore.htm" target="_blank">http://www.cineclubdecaen.com/realisat/murnau/aurore.htm</a>).</div>\\012<div><b>&nbsp;</b></div>\\012<div>Le r&eacute;seau d&rsquo;&eacute;tablissements scolaires constitu&eacute; &agrave; partir des partenariats d&eacute;j&agrave; engag&eacute;s lors du projet Erice-Kiarostami s&rsquo;est &eacute;tendu &agrave; l&rsquo;Europe. Il r&eacute;unit une quinzaine d&rsquo;&eacute;tablissements pour une vingtaine de bin&ocirc;mes de m&ecirc;me niveau et qui travaillent selon les cas dans ou hors temps scolaire.</div>\\012<div>&nbsp;</div>\\012<div>Les pays participants Allemagne, France, Italie, Roumanie&hellip;</div>\\012<div>&nbsp;</div>\\012<div>Les (bin&ocirc;mes Une fois form&eacute;s - groupe ou classe fran&ccedil;aise et groupe ou classe d&rsquo;un pays europ&eacute;en -, r&eacute;unis en fonction de l&rsquo;&acirc;ge, du niveau, ainsi que des demandes sp&eacute;cifiques des participants), la relation &nbsp;des partenaires s&rsquo;organise autour d&rsquo;une s&eacute;rie d&rsquo;&eacute;tapes envisag&eacute;es avec les enseignants.</div>\\012<p>&nbsp;</p>\\012	1249384202	1249297802		0
2:e8047213c0ceff5022d91c56c22cfcf8	<p><a href="/ateliers/ma_ville_vue_par">Projet</a> - <a href="/ateliers/ma_ville_vue_par/etapes">Etapes</a> - <a href="/ateliers/ma_ville_vue_par/generique">G&eacute;n&eacute;rique</a> - Bin&ocirc;mes</p>\\012<p>&nbsp;</p>\\012<p><table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr style="height: 61.2pt;">\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt; height: 61.2pt;">\\012<div><a href="#binome1"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Ecole &agrave; aires ouvertes Saint-Merri et   Renard, Paris 4<sup>&egrave;me </sup>(France)</span></a></div>\\012<div><a href="#binome1"><span style="color: windowtext; text-transform: none;">CE1</span><span style="font-size: 11pt; color: windowtext; text-transform: none;"> &ndash; </span><span style="color: windowtext; text-transform: none;">Anne Laforge</span><span style="color: windowtext; text-transform: none;">,   institutrice</span></a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt; height: 61.2pt;">\\012<div><a href="#binome1"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Scuola   Elementare Federigo Tozzi, Sienne (Italie)</span></a></div>\\012<div><a href="#binome1"><span style="color: windowtext; text-transform: none;">CE1</span><span style="font-size: 11pt; color: windowtext; text-transform: none;"> &ndash; </span><span style="color: windowtext; text-transform: none;">Mariarita Fiori</span><span style="color: windowtext; text-transform: none;">,   institutrice</span></a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012</p>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr style="height: 47.5pt;">\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt; height: 47.5pt;">\\012<div><a href="#binome2"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Ecole &agrave; aires ouvertes Saint-Merri et   Renard, Paris 4<sup>&egrave;me </sup>(France)</span></a></div>\\012<div><a href="#binome2"><span style="color: windowtext; text-transform: none;">CE1</span><span style="font-size: 11pt; color: windowtext; text-transform: none;"> - </span><span style="color: windowtext; text-transform: none;">H&eacute;l&egrave;ne Valencien</span><span style="color: windowtext; text-transform: none;">,   institutrice</span></a></div>\\012<div><a href="#binome2">&nbsp;</a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt; height: 47.5pt;">\\012<div><a href="#binome2"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Scuola   Elementare Federigo Tozzi, Sienne (Italie) </span></a></div>\\012<div><a href="#binome2"><span style="color: windowtext; text-transform: none;">CE1</span><span style="font-size: 11pt; color: windowtext; text-transform: none;"> - </span><span style="color: windowtext; text-transform: none;">Donatella Bargis</span><span style="color: windowtext; text-transform: none;">,   institutrice</span></a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome3"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Ecole Saint-Merri, Paris (France)</span></a></div>\\012<div><a href="#binome3"><span style="color: windowtext; text-transform: none;">CE1</span><span style="font-size: 11pt; color: windowtext; text-transform: none;"> - </span><span style="color: windowtext; text-transform: none;">Agn&egrave;s   de Willecot, institutrice</span></a></div>\\012<div><a href="#binome3">&nbsp;</a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome3">&nbsp;</a></div>\\012<div><a href="#binome3">&nbsp;</a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome4"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Ecole &eacute;l&eacute;mentaire Maurice Genevoix,   Paris 18<sup>&egrave;me</sup> (France)</span></a></div>\\012<div><a href="#binome4"><span style="font-size: 10pt; color: windowtext;">6<sup>&egrave;me</sup> - Monique Dugu&eacute; Boyer, professeur de   frab&ccedil;ais</span></a></div>\\012<div><a href="#binome4">&nbsp;</a></div>\\012<div><a href="#binome4">&nbsp;</a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome4"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Scoala   centrala n&deg; 10, Bucarest</span></a></div>\\012<div><a href="#binome4"><span style="font-size: 10pt; color: windowtext;">5<sup>&egrave;me</sup> C - Mariana Visan, Isabelle   Bucurescu, A. Oslobeanu, Cecila Potescu</span></a></div>\\012<div><a href="#binome4">&nbsp;</a></div>\\012<div><a href="#binome4">&nbsp;</a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr style="height: 68.4pt;">\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt; height: 68.4pt;">\\012<div><a href="#binome5"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Coll&egrave;ge Thomas Mann, Paris 13<sup>&egrave;me </sup>(France)</span></a></div>\\012<div><a href="#binome5"><span style="color: windowtext; text-transform: none;">4<sup>&egrave;me</sup>D - Elisabeth Loupiac, </span><span style="font-size: 11pt; color: windowtext; text-transform: none;">professeur d&rsquo;arts plastiques</span></a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt; height: 68.4pt;">\\012<div><a href="#binome5"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Scuola   Media Irnerio, Bologne </span><span style="font-size: 14pt; color: windowtext; text-transform: none;">(Italie)</span></a></div>\\012<div><a href="#binome5"><span style="color: windowtext; text-transform: none;">5&egrave;meC - Elisa Cappi, </span><span style="font-size: 11pt; color: windowtext; text-transform: none;">professeur d&rsquo;histoire</span></a></div>\\012<div><a href="#binome5">&nbsp;</a></div>\\012<div><a href="#binome5">&nbsp;</a></div>\\012<div><a href="#binome5">&nbsp;</a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome6"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Coll&egrave;ge Thomas Mann, Paris 13<sup>&egrave;me </sup>(France)</span></a></div>\\012<div><a href="#binome6"><span style="font-size: 11pt; color: windowtext; text-transform: none;">4<sup>&egrave;me</sup>E - Elisabeth Loupiac</span><span style="color: windowtext; text-transform: none;">, </span><span style="font-size: 11pt; color: windowtext; text-transform: none;">professeur d&rsquo;arts plastiques</span></a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome6"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Scuola   Media Irnerio, Bologne (Italie)</span></a></div>\\012<div><a href="#binome6"><span style="font-size: 11pt; color: windowtext; text-transform: none;">5<sup>&egrave;me</sup>2B   - Daniela Amante</span><span style="color: windowtext; text-transform: none;">,</span><span style="font-size: 11pt; color: windowtext; text-transform: none;">professeur d&rsquo;histoire</span></a></div>\\012<div><a href="#binome6">&nbsp;</a></div>\\012<div><a href="#binome6">&nbsp;</a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome7"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Coll&egrave;ge Thomas Mann, Paris 13<sup>&egrave;me</sup>(France)</span></a></div>\\012<div><a href="#binome7"><span style="font-size: 11pt; color: windowtext; text-transform: none;">4<sup>&egrave;me</sup>C - Elisabeth Loupiac</span><span style="color: windowtext; text-transform: none;">, </span><span style="font-size: 11pt; color: windowtext; text-transform: none;">professeur d&rsquo;arts plastiques</span></a></div>\\012<div><a href="#binome7">&nbsp;</a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome7"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Colegiul   national Mihai Eminescu, Iasi (Roumanie)</span></a></div>\\012<div><a href="#binome7"><span style="font-size: 11pt; color: windowtext; text-transform: none;">4<sup>&egrave;me</sup> - Sorina Danaila</span><span style="color: windowtext; text-transform: none;">, </span><span style="font-size: 11pt; color: windowtext; text-transform: none;">professeur de fran&ccedil;ais langue &eacute;trang&egrave;re</span></a></div>\\012<div><a href="#binome7">&nbsp;</a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome8"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Lyc&eacute;e Maurice Ravel, Paris 19<sup>&egrave;me</sup>(France)</span></a></div>\\012<div><a href="#binome8"><span style="font-size: 10pt; color: windowtext;">BTS Assistant trilingue - Yola Le Ca&iuml;nec,   professeur de fran&ccedil;ais</span></a></div>\\012<div><a href="#binome8">&nbsp;</a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome8"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Colegiul Ion C. Bratianu, Pitesti   (Roumanie)</span></a></div>\\012<div><a href="#binome8"><span style="font-size: 10pt; color: windowtext;">Terminale - Iulian Untaru, professeur de fran&ccedil;ais langues   &eacute;trang&egrave;res</span></a></div>\\012<div><a href="#binome8">&nbsp;</a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table width="633" cellspacing="0" cellpadding="0" border="1" style="border: medium none ; width: 474.9pt; border-collapse: collapse;">\\012<tbody>\\012<tr style="height: 79.15pt;">\\012<td width="317" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 237.45pt; height: 79.15pt;">\\012<div><a href="#binome9"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Lyc&eacute;e Maurice Ravel, Paris 19<sup>&egrave;me</sup>   (France)</span></a></div>\\012<div><a href="#binome9"><span style="font-size: 11pt; color: windowtext; text-transform: none;">1<sup>&egrave;re</sup>ES - Isabelle Limon,   professeur d&rsquo;allemand</span></a></div>\\012</td>\\012<td width="317" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 237.45pt; height: 79.15pt;">\\012<div><a href="#binome9"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Berufskolleg Herzogenrath </span><span style="font-size: 14pt; color: windowtext; text-transform: none;">(Allemagne)</span></a></div>\\012<div><a href="#binome9"><span style="font-size: 11pt; color: windowtext; text-transform: none;">1&egrave;re &eacute;conomie-commerce, Jean-Paul Moreau,   professeur de fran&ccedil;ais</span></a></div>\\012<div><a href="#binome9">&nbsp;</a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome10"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Coll&egrave;ge Jean Moulin, Paris 14<sup>&egrave;me</sup> (France)</span></a></div>\\012<div><a href="#binome10"><span style="font-size: 11pt; color: windowtext; text-transform: none;">3<sup>&egrave;me</sup>A etgroupe d&rsquo;&eacute;l&egrave;ves de 3<sup>&egrave;me</sup> - Laurence Dauvergne,   professeur de technologie / Elisabeth Battistel et&nbsp;Dominique Vadet, professeur de fran&ccedil;ais/ C&eacute;line Noras, professeur   d&rsquo;anglais, Mme Amor Fahsi, professeur 1er degr&eacute; d&rsquo;UPI</span></a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome10"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Colegiul national Mihai Eminescu, Iasi (Roumanie)</span></a></div>\\012<div><a href="#binome10"><span style="font-size: 10pt; color: windowtext;">4<sup>&egrave;me</sup> et 3<sup>&egrave;me</sup> - Sorina Danaila, professeur   de fran&ccedil;ais langue &eacute;trang&egrave;re</span></a></div>\\012<div><a href="#binome10"><span style="font-size: 10pt; color: windowtext;">2<sup>&egrave;me</sup> -&nbsp;Corina Ungurean,   professeur de fran&ccedil;ais langues &eacute;trang&egrave;res</span></a></div>\\012<div><a href="#binome10">&nbsp;</a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome11">&nbsp;</a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome11"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Colegiul national Radu Negru, Fagaras   (Roumanie)</span></a></div>\\012<div><a href="#binome11"><span style="font-size: 10pt; color: windowtext;">1&egrave;re - prof. Raluca Ionescu</span></a></div>\\012<div><a href="#binome11">&nbsp;</a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome12"><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Coll&egrave;ge Darius Milhaud, Sartrouville   (France)</span></a></div>\\012<div><a href="#binome12"><span style="color: rgb(51, 51, 51); text-transform: none;">3<sup>&egrave;me</sup>1 - </span><span style="color: rgb(51, 51, 51); text-transform: none;">Anne-Catherine Mourgue</span><span style="color: rgb(51, 51, 51); text-transform: none;">,   professeur de lettres classiques / Aur&eacute;lie Pieterwas professeur de lettres   classiques / Philippe Roca et Julien Charlier, professeurs de technologie /   Christelle Musset, professeur d'anglais / Christophe Sayol, professeur   d'anglais / Nicolas Henry professeur de SVT</span></a></div>\\012<div><a href="#binome12">&nbsp;</a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome12"><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Liceo classico   M. Gioia, Piacenza (Italie)</span></a></div>\\012<div><a href="#binome12"><span style="font-size: 10pt; color: rgb(51, 51, 51);">2<sup>&egrave;me</sup>B classique - Maria Augusta Schippisi,   professeur de langages non verbaux</span></a></div>\\012<div><a href="#binome12">&nbsp;</a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome13"><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Coll&egrave;ge Darius Milhaud, Sartrouville   (France)</span></a></div>\\012<div><a href="#binome13"><span style="font-size: 11pt; color: rgb(51, 51, 51); text-transform: none;">3</span><sup><span style="color: rgb(51, 51, 51); text-transform: none;">&egrave;me</span></sup><span style="font-size: 11pt; color: rgb(51, 51, 51); text-transform: none;">4</span>&nbsp;<span style="color: rgb(51, 51, 51); text-transform: none;">- </span><span style="color: rgb(51, 51, 51); text-transform: none;">Anne-Catherine    Mourgue</span><span style="color: rgb(51, 51, 51); text-transform: none;">, professeur de lettres classiques /   Aur&eacute;lie Pieterwas professeur de lettres classiques / Philippe Roca et Julien   Charlier, professeurs de technologie / Christelle Musset, professeur   d'anglais / Christophe Sayol, professeur d'anglais / Nicolas Henry professeur   de SVT</span></a></div>\\012<div><a href="#binome13">&nbsp;</a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome13"><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Colegiul   national Mihai Eminescu, Iasi</span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">(Roumanie)</span></a></div>\\012<div><a href="#binome13"><span style="font-size: 10pt; color: windowtext;">3&egrave;me, Sorina    Danaila, professeur de fran&ccedil;ais langue &eacute;trang&egrave;re</span></a></div>\\012<div><a href="#binome13">&nbsp;</a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome14"><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Lyc&eacute;e Paul Val&eacute;ry, Paris 12<sup>&egrave;me</sup>(France)</span></a></div>\\012<div><a href="#binome14"><span style="font-size: 10pt; color: rgb(51, 51, 51);">1&egrave;re ES1 et 1er S2- et &eacute;tudiants du Lyc&eacute;e Charlemagne, option   facultative cin&eacute;ma - Philippe    Zill, professeur de cin&eacute;ma</span></a></div>\\012<div><a href="#binome14">&nbsp;</a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><a href="#binome14"><span style="font-size: 14pt; color: rgb(51, 51, 51);">Colegiul B. P. Hasdeu, Buzau (Roumanie)</span></a></div>\\012<div><a href="#binome14"><span style="font-size: 10pt; color: rgb(51, 51, 51);">3&egrave;me - Ioana    Voinea&nbsp;/ Dan    Solcan, professeurs de fran&ccedil;ais langue &eacute;trang&egrave;re</span></a></div>\\012<div><a href="#binome14">&nbsp;</a></div>\\012<div><a href="#binome14">&nbsp;</a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr style="height: 48.5pt;">\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt; height: 48.5pt;">\\012<div><a href="#binome15"><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Lyc&eacute;e Paul Val&eacute;ry, Paris 12<sup>&egrave;me</sup>(France)</span></a></div>\\012<div><a href="#binome15"><span style="font-size: 10pt; color: windowtext;">Philippe Zill</span><span style="font-size: 10pt; color: windowtext;">, professeur   de cin&eacute;ma </span></a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt; height: 48.5pt;">\\012<div><a href="#binome15"><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Liceo classico   M. Gioia, Piacenza (Italie)</span></a></div>\\012<div><a href="#binome15"><span style="font-size: 9pt; color: windowtext;">2&egrave;me   linguistique A - Paola    Gozzi, professeur de langages non verbaux</span></a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<p>&nbsp;</p>\\012<p>&nbsp;</p>\\012<p><span style="font-size: 11pt; color: red;"><br clear="all" /><br />\\012</span></p>\\012<h3>&nbsp;<span style="color: blue; text-transform: none;">BINOMES / REALISATIONS</span></h3>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div style="border: 1pt solid windowtext; padding: 1pt;">\\012<div style="border: medium none ; padding: 0cm;"><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div style="border: medium none ; padding: 0cm;"><span style="color: blue; text-transform: none;">Pr&eacute;sentation du projet</span><span style="color: blue; text-transform: none;"> par Bernard Stiegler, directeur de l&rsquo;Institut de recherche et d&rsquo;innovation /&nbsp;</span></div>\\012</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="614" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 460.6pt;">\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">00_intro</span></div>\\012<div><span style="font-size: 10pt; color: blue;">Pr&eacute;sentation des   exp&eacute;riences r&eacute;alis&eacute;s sur le logiciel &laquo;&nbsp;Lignes de temps&nbsp;&raquo; par Marta   Boni, doctorante en cin&eacute;ma, responsable des Ateliers &laquo;&nbsp;Lignes de&nbsp;temps&nbsp;&raquo;   dans les &eacute;coles partenaires.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="119" width="157" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image002.jpg" v:shapes="_x0000_i1026" /></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div><b>&nbsp;</b></div>\\012<div><b>&nbsp;</b></div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome1"></a>Ecole &agrave; aires ouvertes Saint-Merri et   Renard, Paris 4<sup>&egrave;me </sup>(France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">CE1<span style="color: rgb(51, 51, 51);"> &ndash; </span>Anne Laforge,   institutrice</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;Pr&eacute;sentation par   les enseignants&nbsp;: Anne    Laforge / H&eacute;l&egrave;ne Valencien</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">01_saint_merri</span></div>\\012<div><span style="color: blue; text-transform: none;">Ateliers &laquo;&nbsp;Lignes de temps&nbsp;&raquo;   par Marta Boni, interview d&rsquo;enfants, dur&eacute;e 4&rsquo;34&rsquo;&rsquo;</span></div>\\012<div>&nbsp;</div>\\012<div><img height="116" width="157" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image004.jpg" v:shapes="_x0000_i1027" /></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Scuola   Elementare Federigo Tozzi, Sienne (Italie)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">CE1<span style="color: rgb(51, 51, 51);"> &ndash; </span>Mariarita Fiori,   institutrice</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">0</span><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">2_PP</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation et dessins des &eacute;l&egrave;ves de   l&rsquo;&eacute;cole.</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<p><span style="font-size: 10pt; color: rgb(51, 51, 51);"><br clear="all" /><br />\\012</span></p>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome2"></a>Ecole &agrave; aires ouvertes Saint-Merri et   Renard, Paris</span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">4<sup>&egrave;me </sup>(France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">CE1<span style="color: rgb(51, 51, 51);"> - </span>H&eacute;l&egrave;ne Valencien,   institutrice</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">03_saint_merri</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;L&rsquo;&eacute;cole Saint-Merri&nbsp;&raquo;, dur&eacute;e   3&rsquo;19&rsquo;&rsquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">L&rsquo;&eacute;cole pr&eacute;sent&eacute;e par les enfants.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: red; text-transform: none;">Texte</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Les enfants nous pr&eacute;sentent, en fran&ccedil;ais et en italien,   les lieux les plus significatifs de leur&nbsp;quartier&nbsp;: leur &eacute;cole, le Centre Pompidou, le Bazar de l&rsquo;H&ocirc;tel de   ville, le fameux BHV.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="126" width="168" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image006.jpg" v:shapes="_x0000_i1028" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation du travail par les enseignantes</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;Apr&egrave;s avoir travaill&eacute; avec les &eacute;l&egrave;ves du coll&egrave;ge   Thomas Mann pour ce projet, j&rsquo;ai &eacute;t&eacute; mise en contact avec l'&eacute;cole Saint-Merri   qui avaient besoin d&rsquo;une aide pour concevoir et suivre le travail de tournage   de leurs &eacute;l&egrave;ves. La d&eacute;marche a &eacute;t&eacute; diff&eacute;rente de celle que nous avons suivie   avec les &eacute;l&egrave;ves de Thomas Mann (voir texte Lila Pinell / Coll&egrave;ge   Thomas Mann). Nous avions beaucoup moins de temps (je suis intervenue au   coll&egrave;ge pendant toute l'ann&eacute;e), mais Anne Laforge et H&eacute;l&egrave;ne Valencien avaient   travaill&eacute; en amont avec leurs &eacute;l&egrave;ves. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les enfants ont choisi de pr&eacute;senter leur Paris &agrave; la   mani&egrave;re de petits reporters. C'est pourquoi les lieux choisis sont plut&ocirc;t   dans leur quartier, et qu'&agrave; c&ocirc;t&eacute; du Centre Pompidou, on peut trouver la   boulangerie ou le BHV (Bazar de l&rsquo;H&ocirc;tel de ville). L'id&eacute;e est de parler d'un   Paris totalement subjectif, vu par des enfants qui y habitent, mais de leur   le pr&eacute;senter &agrave; travers une forme journalistique, connue de tous.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Nous avons d&eacute;cid&eacute; de continuer ce travail et de   l'&eacute;tendre &agrave; d'autres lieux de leur Paris, et cela dans la perspective   notamment de continuer le dialogue avec les &eacute;l&egrave;ves italiens.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J'esp&egrave;re que le projet va continuer et &eacute;voluer avec les   ann&eacute;es, parce que les enfants s'amusent, cr&eacute;ent et apprennent beaucoup gr&acirc;ce   &agrave; ce type d'initiatives. Et moi aussi.&nbsp;&raquo; Lila Pinell, juin 2009.</span></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Scuola   Elementare Federigo Tozzi, Sienne (Italie)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">CE1<span style="color: rgb(51, 51, 51);"> - </span>Donatella Bargis,   institutrice</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">03bis_sienne</span></div>\\012<div><span style="color: blue; text-transform: none;">&laquo;&nbsp;A scuola e   il quartiere&nbsp;&raquo;, dur&eacute;e 19&rsquo;27&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Une promenade &agrave; Sienne avec les enfants de l&rsquo;&eacute;cole.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: red; text-transform: none;">Texte</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;&laquo;&nbsp;Sienne est   une petite ville, tr&egrave;s ancienne, de Toscane entour&eacute;e de douces collines et de   grands espaces verts. Dans notre ville&nbsp;il n&rsquo;y a pas de grands b&acirc;timents et surtout il y a peu de trafic. Nous   pouvons marcher ou&nbsp;faire du v&eacute;lo   tranquillement.&nbsp;L&rsquo;ann&eacute;e derni&egrave;re avec   nos ma&icirc;tresses nous avonstravaill&eacute;   sur les <b>limites</b> et, gr&acirc;ce &agrave; cette   r&eacute;flexion, l&rsquo;envie est n&eacute;e de travailler avec la classe de CE1 de   l&rsquo;&eacute;cole &agrave; aires ouvertes Saint-Merri et Renard : nous avons envoy&eacute; des   dessins montrant nos moments pr&eacute;f&eacute;r&eacute;s du film   <i>Le&nbsp;Cam&eacute;raman</i>&nbsp;, ainsi que   nos portraits.&nbsp;&raquo;</span></div>\\012<div><span style="color: red; text-transform: none;"><br />\\012            </span></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome3"></a>Ecole Saint-Merri, Paris (France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">CE1<span style="color: rgb(51, 51, 51);"> - </span>Agn&egrave;s   de Willecot, institutrice</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par l&rsquo;enseignante&nbsp;Agn&egrave;s de&nbsp;Willecot</span><span style="color: red; text-transform: none;">faire interview   Willecot et Serre</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">03ter_saint_merri</span></div>\\012<div><span style="color: red; text-transform: none;">Film-essai&nbsp;:   titre&nbsp;??? </span></div>\\012<div><span style="color: red; text-transform: none;">Film voir chez   THIBAUT </span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome4"></a>Ecole &eacute;l&eacute;mentaire Maurice Genevoix, Paris   18<sup>&egrave;me</sup> (France)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">6<sup>&egrave;me</sup> - Monique Dugu&eacute; Boyer, professeur</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">16_Genevoix(1)</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Regards   crois&eacute;s de notre patrimoine&nbsp;: le mur&nbsp;&raquo;, dur&eacute;e 5&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Quatre   regards sur les murs du 18<sup>&egrave;me</sup> arrondissement de Paris.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: blue;">Texte</span></div>\\012<div><span style="font-size: 10pt; color: blue;">Pr&eacute;sentation du   travail par l&rsquo;enseignante</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">&laquo;&nbsp;En   &eacute;change avec l'Ecole centrale de Bucarest, un travail sur le patrimoine   architectural de chaque ville a &eacute;t&eacute; r&eacute;alis&eacute;. </span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">La classe de CM</span><span style="font-size: 10pt; color: windowtext;">1 et CM2 de l'&eacute;cole Maurice   Genevoix du 18<sup>&egrave;me</sup> arrondissement pr&eacute;sente un travail en cours<strong>.</strong><br />\\012            Ce qui est pr&eacute;sent&eacute; doit &ecirc;tre repris et compl&eacute;t&eacute;, pour &ecirc;tre plus &lsquo;lisible&rsquo;. <br />\\012            Le th&egrave;me g&eacute;n&eacute;ral est une interrogation et un regard sur les diff&eacute;rents   sens&nbsp;et regards que l'on peut porter sur le <i>mur</i>.<br />\\012            Des expositions nous ont servi de r&eacute;f&eacute;rence dans le montage et les   successions d'id&eacute;es, des textes &eacute;tudi&eacute;s en litt&eacute;rature, un travail en arts   visuels autour des maquettes et l'urbanisme&nbsp; en plein mouvement dans   notre quartier du 18<sup>&egrave;me</sup>, Porte de la Chapelle.<br />\\012            <strong><span style="font-weight: normal;">Photomontages sur le</span></strong><strong><span style="font-weight: normal;"> th&egrave;me du <i>mur</i></span></strong>&nbsp;:   les textes sont&nbsp;des po&egrave;mes de&nbsp;Paul Eluard, Pierre Reverdy, Gilles   Troillet, Charles Daubzynski, ainsi que des extraits d'Italo Calvino <i>Les Villes invisibles</i> &raquo;. \\012<p>            </p></span></div>\\012<div><img height="128" width="228" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image008.jpg" v:shapes="_x0000_i1042" /></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">16_Genevoix(2)</span></div>\\012<div><img height="129" width="228" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image010.jpg" v:shapes="_x0000_i1043" /></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">16_Genevoix(3)</span></div>\\012<div><img height="128" width="228" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image012.jpg" v:shapes="_x0000_i1032" /></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">16_Genevoix(4)</span></div>\\012<div><img height="128" width="228" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image014.jpg" v:shapes="_x0000_i1033" /></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: blue;">Texte</span></div>\\012<div><span style="font-size: 10pt; color: blue;">Italo Calvino, <i>Les Villes   invisibles,</i> Seuil Editions.</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">&laquo;&nbsp;En partant de l&agrave; et en allant trois jours vers le   levant, l'homme se trouve &agrave; Diomira, une ville avec soixante coupoles   d'argent, des statues en bronze de tous les dieux, des rues pav&eacute;es d'&eacute;tain,   un th&eacute;&acirc;tre en</span><br />\\012            <span style="font-size: 10pt; color: windowtext;">cristal,   un coq en or qui chante chaque matin sur une tour. Toutes ces beaut&eacute;s, le   voyageur les conna&icirc;t d&eacute;j&agrave; pour les avoir vues aussi dans d'autres villes.   Mais le propre de celle-ci est que si l'on y arrive un soir de septembre,   quand les jours raccourcissent et que les lampes multicolores s'allument   toutes ensemble aux portes des friteries, et que d'une terrasse une voix de   femme crie : hou !, on en vient &agrave; envier ceux qui &agrave; l'heure pr&eacute;sente pensent   qu'ils ont d&eacute;j&agrave; v&eacute;cu une soir&eacute;e pareille et qu'ils ont &eacute;t&eacute; cette fois-l&agrave;   heureux.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Scoala   centrala n&deg; 10, Bucarest</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">5<sup>&egrave;me</sup> C - Mariana Visan, Isabelle   Bucurescu, A. Oslobeanu, Cecila Potescu</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">17_Bucarest</span></div>\\012<div><b><span style="font-size: 10pt;">&nbsp;</span></b><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Bucarest d&rsquo;aujourd&rsquo;hui &ndash; Ancien &lsquo;Petit   Paris&rsquo;&nbsp;&raquo;, extrait 5&rsquo;30&rsquo;&rsquo; - dur&eacute;e 16&rsquo;50&rsquo;&rsquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Une balade dans la ville, &agrave; travers les yeux des enfants   de 6<sup>&egrave;me</sup> de l&rsquo;&eacute;cole de Bucarest.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="157" width="210" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image016.jpg" v:shapes="_x0000_i1029" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;</span><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;Nous   avons d&eacute;cid&eacute;&nbsp;de participer &agrave; ce projet   et de r&eacute;aliser ce film avec nos &eacute;l&egrave;ves de 6<sup>&egrave;me</sup> pour r&eacute;investir des   apprentissages scolaires dans un projet de communication vers l&rsquo;ext&eacute;rieur de   l`&eacute;cole, d&eacute;velopper le sens de la rigueur et pour donner un lien aux diff&eacute;rents   contenus scolaires.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les domaines concern&eacute;s plus particuli&egrave;rement ont   &eacute;t&eacute;&nbsp;:</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- Le fran&ccedil;ais</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- L&rsquo;histoire de l&rsquo;art&nbsp;: connaissance d&rsquo;&oelig;uvres dans   des domaines vari&eacute;s, d&eacute;couvertes, recherche sur Bucarest, dans l&rsquo;id&eacute;e de   mieux conna&icirc;tre sa ville.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">- </span></b><span style="color: windowtext; text-transform: none;">l`histoire<b>&nbsp;: </b>inclure l&rsquo;histoire dans une   d&eacute;marche globale de compr&eacute;hension du monde).</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">- </span></b><span style="color: windowtext; text-transform: none;">l`informatique&nbsp;:   s&rsquo;approprier un outil de travail et de communication, dans un esprit   responsable.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">- </span></b><span style="color: windowtext; text-transform: none;">sciences   et techniques<b>&nbsp;: </b>l&rsquo;&eacute;volution   des techniques, l&rsquo;image fabrication et perception.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">En participant &agrave; ce projet, nos &eacute;l&egrave;ves ont d&eacute;velopp&eacute; le   go&ucirc;t de la d&eacute;couverte, de la curiosit&eacute;, ont appris &agrave; regarder, &agrave; observer, &agrave;   r&eacute;fl&eacute;chir, &agrave; s&rsquo;interroger. Ils ont pris aussi conscience d&rsquo;un choix commun   dans lequel chacun peut avoir un r&ocirc;le. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">M&ecirc;me s&rsquo;ils ont eu des difficult&eacute;s dans la r&eacute;alisation de leur   petit film, la grande satisfaction qu&rsquo;ils ont ressentie &agrave; la fin de leur travail   les a effac&eacute;es totalement.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<p><span style="font-size: 10pt; color: rgb(51, 51, 51);"><br clear="all" /><br />\\012</span></p>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome5"></a>Coll&egrave;ge Thomas Mann, Paris 13<sup>&egrave;me </sup>(France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">4<sup>&egrave;me</sup>D - Elisabeth Loupiac, <span style="color: rgb(51, 51, 51);">professeur d&rsquo;arts plastiques</span></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par </span><span style="color: blue; text-transform: none;">Elisabeth    Loupiac</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">04_thomas_mann</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;</span><span style="color: blue; text-transform: none;">&laquo;&nbsp;Pas perdus&nbsp;&raquo;,&nbsp;dur&eacute;e 6&rsquo;18&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Sous   la direction d&rsquo;Antoine Petit, professeur d&rsquo;&eacute;ducation physique</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La classe et la ville de Paris&nbsp;: balades et   &laquo;&nbsp;effets sp&eacute;ciaux</span><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;&raquo;.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="153" width="204" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image018.jpg" v:shapes="_x0000_i1030" /></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Scuola Media   Irnerio, Bologne </span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">(Italie)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">5<sup>&egrave;me</sup>C - Elisa Cappi, <span style="color: rgb(51, 51, 51);">professeur d&rsquo;histoire</span></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par Elisa Cappi</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">05_scuola_irnerio_bologne</span></div>\\012<div><span style="color: blue; text-transform: none;">&laquo;&nbsp;La mia citt&agrave;&nbsp;&raquo;, dur&eacute;e 14&rsquo;29&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">D&eacute;couverte de la ville de Bologne par la classe, &agrave;   travers une chasse au tr&eacute;sor qui les conduira &agrave;&hellip; Paris.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="154" width="204" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image020.jpg" v:shapes="_x0000_i1031" /></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome6"></a>Coll&egrave;ge Thomas Mann, Paris 13<sup>&egrave;me </sup>(France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">4<sup>&egrave;me</sup>E - Elisabeth Loupiac</span><span style="color: rgb(51, 51, 51); text-transform: none;">, <span style="color: rgb(51, 51, 51);">professeur d&rsquo;arts plastiques</span></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">06_thomas_mann</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Cin&eacute;ma Paris&nbsp;&raquo;, dur&eacute;e 5&rsquo;55&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">R&eacute;alis&eacute; sous la direction de Lila Pinell (sc&eacute;nario,   tournage, montage).</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Un &laquo;&nbsp;journal t&eacute;l&eacute;vis&eacute;&nbsp;&raquo; sur la ville, r&eacute;alis&eacute;   par les &eacute;l&egrave;ves il s&rsquo;inspire de certains des films les plus c&eacute;l&egrave;bres de   l&rsquo;histoire du 7<sup>&egrave;me</sup> art.</span><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012<div><img height="135" width="180" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image022.jpg" v:shapes="_x0000_i1044" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par Lila Pinell</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;&laquo;&nbsp;J'ai   rencontr&eacute; Elisabeth Loupiac   il y a un an, au mois de juillet. Elle voulait monter une com&eacute;die musicale   avec quelques &eacute;l&egrave;ves inscrits &agrave; l'&eacute;cole ouverte du coll&egrave;ge Thomas Mann. Nous   avons donc travaill&eacute; ensemble pendant une semaine, l'exp&eacute;rience a &eacute;t&eacute; riche   et heureuse, et il en a r&eacute;sult&eacute; un film qui a &eacute;t&eacute; projet&eacute; aux &eacute;l&egrave;ves et &agrave;   leurs invit&eacute;s. Le tout s'est d&eacute;roul&eacute; au <i>b&eacute;tonsalon</i>,   un centre d'art au sein duquel j'organise ces diff&eacute;rents ateliers vid&eacute;o. Cette   ann&eacute;e elle m'a recontact&eacute; et je l'ai assist&eacute; sur le projet &laquo;&nbsp;Ma ville vue   par...&nbsp;&raquo;. J&rsquo;ai suivi deux classes : avec la premi&egrave;re, nous avons imagin&eacute;   un sc&eacute;nario dans lequel des &eacute;l&egrave;ves seraient projet&eacute;s dans le film <i>Le Cam&eacute;raman</i>. Cela a permis aux &eacute;l&egrave;ves   de comprendre la construction du film plan par plan. Pour ins&eacute;rer leur propre   image dans le film, ils ont d&ucirc; distinguer les champs et les contre-champs,   les plans serr&eacute;s et les plans larges, et trouver les moments opportuns pour   apparaitre. Ils avaient imagin&eacute; une histoire de vengeance lors de laquelle un   &eacute;l&egrave;ve deviendrait invisible.&nbsp;Nous   avons donc cr&eacute;&eacute; des effets sp&eacute;ciaux tr&egrave;s simples, et les &eacute;l&egrave;ves ont imagin&eacute;   des situations comiques mettant en jeu cette invisibilit&eacute;. Le temps nous   ayant un peu manqu&eacute;, j'ai mont&eacute; moi m&ecirc;me le petit film, mais j'aurais aim&eacute;   qu'ils puissent aussi participer &agrave; cette derni&egrave;re phase.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Avec le deuxi&egrave;me groupe, nous nous sommes concentr&eacute;s sur   Paris. Apr&egrave;s plusieurs discussions, nous sommes tomb&eacute;s d'accord sur l'id&eacute;e de   faire des remakes de sc&egrave;nes tr&egrave;s connues du cin&eacute;ma international, mais de les   transposer &agrave; Paris. Nous avons choisi les films, les sc&egrave;nes, les lieux. Puis   nous avons observ&eacute; le d&eacute;coupage exact des morceaux choisis et nous avons   tent&eacute; de les reproduire dans la mesure du possible. Nous avons utilis&eacute; des   plans larges, moyens, ou des contre-plong&eacute;es lorsqu'il y en avait dans la   sc&egrave;ne initiale.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Chaque fois, nous avons pos&eacute; la musique du film sur   l'extrait rejou&eacute; (ce qui aide beaucoup !). </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ainsi, durant plusieurs apr&egrave;s-midis, nous avons arpent&eacute; Paris   en bus, &agrave; pied ou en m&eacute;tro, en rejouant des sc&egrave;nes de film dans des c&eacute;l&egrave;bres   endroits de Paris ou certains n'avaient jamais &eacute;t&eacute;.&nbsp;&raquo; Lila Pinell, juin 2009</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Scuola Media Irnerio, Bologne (Italie)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">5<sup>&egrave;me</sup>2B - Daniela Amante</span><span style="color: rgb(51, 51, 51); text-transform: none;">,</span><span style="color: rgb(51, 51, 51); text-transform: none;"> <span style="color: rgb(51, 51, 51);">professeur d&rsquo;histoire</span></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">06bis_scuola_media_irnerio</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;</span><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;</span><span style="color: blue; text-transform: none;">&laquo;&nbsp;Bologne&nbsp;&raquo; dur&eacute;e 10&rsquo;20&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Une promenade dans Bologne avec   les &eacute;l&egrave;ves.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="139" width="185" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image024.jpg" v:shapes="_x0000_i1045" /></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome7"></a>Coll&egrave;ge Thomas Mann, Paris 13<sup>&egrave;me</sup>(France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">4<sup>&egrave;me</sup>C - Elisabeth Loupiac</span><span style="color: rgb(51, 51, 51); text-transform: none;">, <span style="color: rgb(51, 51, 51);">professeur d&rsquo;arts plastiques</span></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">07_thomas_mann</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Le Cam&eacute;raman&nbsp;&raquo;, dur&eacute;e 7&rsquo;37&rsquo;&rsquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Film r&eacute;alis&eacute; sous la direction de <span style="color: rgb(51, 51, 51);">Lila Pinell. (</span>coordination, tournage,   montage).</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Toute la classe disparait et se retrouve <b>dans</b> le   film &laquo;&nbsp;Le cam&eacute;raman&nbsp;&raquo;.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="145" width="193" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image026.jpg" v:shapes="_x0000_i1041" /></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Colegiul   national Mihai Eminescu, Iasi (Roumanie)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">4<sup>&egrave;me</sup> - Sorina Danaila</span><span style="color: rgb(51, 51, 51); text-transform: none;">, <span style="color: rgb(51, 51, 51);">professeur de fran&ccedil;ais langue   &eacute;trang&egrave;re</span></span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;">http://lme.is.edu.ro/</span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">12bis_iasi_mihai_eminescu</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Ma ville de jeunesse&nbsp;&raquo;, dur&eacute;e   7&rsquo;22&rsquo;&rsquo; / &laquo;&nbsp;Ma ville de tranquillit&eacute;&nbsp;&raquo;, dur&eacute;e 10&rsquo;08&rsquo;&rsquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">La classe a voulu mettre en opposition - par le sujet,   par le rythme et aussi par la mani&egrave;re d'entrevoir la gestuelle, la marche et   m&ecirc;me la fa&ccedil;on de filmer: le Iasi   de la jeunesse et le   Iasi de l'orthodoxie.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par les enseignants</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;&laquo;&nbsp;Pour les   petits films, c'est tr&egrave;s simple : l'un d'entre eux est une promenade joyeuse   et tr&egrave;s jeune dans une ville qui s'ouvre &agrave; la jeunesse malgr&eacute; son &acirc;ge   v&eacute;n&eacute;rable et sa v&eacute;tust&eacute;. Il a un rythme joyeux et alerte, qui voulait faire   pendant au deuxi&egrave;me film, qui veut mettre en &eacute;vidence un Iasi orthodoxe,   paisible, conservateur, calme, malgr&eacute; toute la modernit&eacute;, plein d'images   d'&eacute;glises qui projettent dans un autre espace et un autre temps. En fait, la   classe a&nbsp;voulu, finalement, se mettre   en opposition - par le sujet, par le rythme et aussi par la mani&egrave;re   d'entrevoir la gestuelle, la marche et m&ecirc;me la fa&ccedil;on de filmer le Iasi de la jeunesse et le   Iasi de l'orthodoxie.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<p><span style="font-size: 10pt; color: rgb(51, 51, 51);"><br clear="all" /><br />\\012</span></p>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome8"></a>Lyc&eacute;e Maurice Ravel, Paris 19<sup>&egrave;me</sup>(France)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">BTS Assistant trilingue - Yola Le Ca&iuml;nec,   professeur de fran&ccedil;ais</span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;"><a href="http://lyc-maurice-ravel.scola.ac-paris.fr/citscol/college.htm">http://lyc-maurice-ravel.scola.ac-paris.fr/citscol/college.htm</a></span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div><span style="font-size: 10pt; color: blue;">Pr&eacute;sentation par Yola Le Ca&iuml;nec, Ma&euml;lys Bourgoin,   Sophie&nbsp;Besson et&nbsp;Esther&nbsp;Baucher</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">08_maurice_ravel</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Ma ville vue   par moi&nbsp;&raquo;, r&eacute;alis&eacute;e par Ma&euml;lys Bourgoin, dur&eacute;e 2&rsquo;37&rsquo;&rsquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&laquo;&nbsp;J&rsquo;ai choisi de montrer diff&eacute;rents lieux du centre   de Paris &agrave; mes correspondants Roumains du Colegiul national I.C. Bratianu de Pitesti.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012<div><img height="143" width="193" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image028.jpg" v:shapes="_x0000_i1039" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;&laquo;&nbsp;J&rsquo;ai   travaill&eacute; dans l&rsquo;optique de d&eacute;finir comment mon regard per&ccedil;oit le caract&egrave;re   culturel de Paris. Jai souhait&eacute; donner deux grands axes &agrave; mon film&nbsp;tout   en restant fid&egrave;le au th&egrave;me de la promenade&nbsp;;&nbsp;donne &agrave; voir des lieux embl&eacute;matiques   comme&nbsp;: la    Cath&eacute;drale Notre Dame, le Marais ou encore le Centre Pompidou.&nbsp;&raquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">La chronologie&nbsp;: Je voulais que le mouvement de la cam&eacute;ra corresponde aux   trajectoires prises par mon corps et que l&rsquo;on puisse rep&eacute;rer sur une carte   les d&eacute;tours emprunt&eacute;s.</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Le rythme&nbsp;: Toujours dans un souci de r&eacute;alisme,   j&rsquo;ai fait co&iuml;ncider la    musique avec les acc&eacute;l&eacute;rations de la foule et j&rsquo;ai marqu&eacute;   les moments cl&eacute;s par des pauses dans la musique. </span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Gr&acirc;ce &agrave; la &laquo;&nbsp;Maison du Geste et de l&rsquo;Image&nbsp;&raquo;   de Paris, qui m&rsquo;a accueillie, j&rsquo;ai pu monter mon film sur le logiciel de   montage Final Cut Pro.&nbsp;&raquo; Ma&euml;lys Bourgoin</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">08bis_maurice_ravel</span></div>\\012<div><span style="color: blue; text-transform: uppercase;">&nbsp;</span><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Walk in Paris by Sophie B. et Esther B.&nbsp;&raquo;, r&eacute;alis&eacute;e   par Sophie Besson, Esther    Baucher, dur&eacute;e 3&rsquo;26&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Une promenade   &agrave; Paris.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="143" width="193" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image030.jpg" v:shapes="_x0000_i1036" /></div>\\012<div><u>&nbsp;</u></div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;&laquo;&nbsp;Nous avons   d&ucirc; faire vite avec deux cam&eacute;ras pour deux heures en ville avec une m&eacute;t&eacute;o tr&egrave;s   favorable ce jour. Ne disposant que de tr&egrave;s peu de temps, nous avons orient&eacute;   les images vers deux th&egrave;mes principaux, l'architecture et les animaux, les   rues servant plus de rep&egrave;res pour la promenade.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je dirais que l'architecture est le th&egrave;me dominant.&nbsp;&raquo;   Sophie Besson</span></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Colegiul Ion C. Bratianu, Pitesti (Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">Terminale - Iulian    Untaru, professeur de fran&ccedil;ais langues &eacute;trang&egrave;res</span></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: blue;">http://www.epitesti.ro/young/hi-school/</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">09_PP_pitesti</span><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: red; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">attention voir Lacie</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">La ville de   Pitesti</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);"><img height="125" width="171" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image032.jpg" alt="pitestiel panorama" v:shapes="Picture_x0020_5" /></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">09_colegiul_bratianu_pitesti(4)</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Notre lyc&eacute;e&nbsp;&raquo;,   dur&eacute;e 10&rsquo;45&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Visite   du coll&egrave;ge Ion C. Bratianu, homme politique roumain (1864-1927). Parcours   historique, pr&eacute;sentation des &eacute;l&egrave;ves c&eacute;l&egrave;bres&hellip;</span></div>\\012<div>&nbsp;</div>\\012<div><img height="139" width="185" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image034.jpg" v:shapes="_x0000_i1040" /></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">09_colegiul_bratianu_pitesti(3)</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&nbsp;&laquo;&nbsp;L&rsquo;Architecture de Pitesti&nbsp;&raquo;,   dur&eacute;e 10&rsquo;57&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Promenade   dans la ville de Pitesti.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="130" width="173" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image036.jpg" v:shapes="_x0000_i1046" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par les enseignants</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;&laquo;&nbsp;Nous avons   voulu pr&eacute;senter l&rsquo;architecture de notre ville d&rsquo;une mani&egrave;re originale, dans   le cadre d&rsquo;une petite histoire qui racontait une amourette. Le plus difficile   a &eacute;t&eacute; le montage. Il a &eacute;t&eacute; r&eacute;alis&eacute; par Adonis et George, qui ont de   l&rsquo;exp&eacute;rience dans ce domaine. La lecture a &eacute;t&eacute; faite par Iulia, qui a traduit   les textes et George a fait l&rsquo;enregistrement. Les autres membres de l&rsquo;&eacute;quipe   ont fait les recherches sur l&rsquo;architecture de Pitesti. L&rsquo;&eacute;quipe a &eacute;t&eacute;   coordonn&eacute;e par notre professeur, Iulian Untaru.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">09_Colegiul_Bratianu_Pitesti(1)</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&nbsp;&laquo;&nbsp;Les rues&nbsp;&raquo;, dur&eacute;e 10&rsquo;12&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">Une promenade   dans les rues de Pitesti.</span></div>\\012<div><img height="131" width="197" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image038.jpg" v:shapes="_x0000_i1037" /></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">09_Colegiul_Bratianu_Pitesti(2)</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;La   Foule&nbsp;&raquo;, dur&eacute;e 10&rsquo;26&rsquo;&rsquo;</span></div>\\012<div><img height="142" width="186" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image040.jpg" v:shapes="_x0000_i1038" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="font-size: 10pt;">&nbsp;&laquo;&nbsp;La   foule diverse, bigarr&eacute;e, anonyme repr&eacute;sente l&rsquo;&acirc;me quotidienne de notre ville,   elle peuple notre univers noy&eacute; dans le b&eacute;ton et dans l&rsquo;artificiel, cette </span><span style="font-size: 10pt;">civilisation urbanis&eacute;e et   pollu&eacute;e d&rsquo;aujourd&rsquo;hui. La foule, c&rsquo;est le triomphe de l&rsquo;homme vivant sur   l&rsquo;homme c&acirc;bl&eacute;, scotch&eacute; devant le moniteur.<br />\\012            Nous pouvons &eacute;couter aussi la voix myst&eacute;rieuse de   l'actrice Luminita Borta qui r&eacute;cite le po&egrave;me <i>L'Amour</i><span> de</span>&nbsp;Jacques Pr&eacute;vert.<br />\\012            Nous pensons que ce film   est un bon moyen de souligner la condition de l'homme   dans une ville qui ressemble &agrave; toutes les villes.<span style="color: rgb(51, 51, 51);">&nbsp;&raquo;</span></span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<p>&nbsp;</p>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table width="633" cellspacing="0" cellpadding="0" border="1" style="border: medium none ; width: 474.9pt; border-collapse: collapse;">\\012<tbody>\\012<tr style="height: 247.05pt;">\\012<td width="317" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 237.45pt; height: 247.05pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome9"></a>Lyc&eacute;e Maurice Ravel, Paris 19<sup>&egrave;me</sup>   (France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">1<sup>&egrave;re</sup>ES - Isabelle Limon,   professeur d&rsquo;allemand</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par Isabelle Limon</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_ PP_visite_a _aachen_annamarie</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_ PP_visite_a   _aachen_arthur</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_ PP_visite_a   _aachen_lisa</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_ PP_visite_a   _aachen_antoine</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_PP_ visite_a   _aachen_yoannd</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_ PP_ravel_limon   _visite_aix_la_chapelle</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10bis_PP_diapo_voyage_chazette</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_PP_   visite_aachen</span></div>\\012<div><span style="color: blue; text-transform: none;">Diaporamas   &laquo;&nbsp; Visite &agrave; Aix-la-Chapelle&nbsp;&raquo; dur&eacute;e 5&rsquo;</span></div>\\012<div>&nbsp;</div>\\012<div><img height="180" width="240" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image042.jpg" v:shapes="_x0000_i1047" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: windowtext; text-transform: none;">En   mars 2009, les &eacute;l&egrave;ves de la classe de 1<sup>&egrave;re</sup> ES d&eacute;j&agrave; en lien depuis   l&rsquo;ann&eacute;e pr&eacute;c&eacute;dente, avec le Berufskolleg d&rsquo;Herzogenrath, ont visit&eacute; leurs   partenaires. Promenades &agrave; Herzogenrath, Aix-la-Chapelle (Aachen), et &agrave; la   fronti&egrave;re entre l&rsquo;Allemagne, la Belgique et la Hollande&hellip;</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="317" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 237.45pt; height: 247.05pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Berufskolleg Herzogenrath</span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">(Allemagne)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">1&egrave;re &eacute;conomie-commerce, Jean-Paul Moreau,   professeur de fran&ccedil;ais</span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;"><a href="http://www.bkherzogenrath.de/">http://www.bkherzogenrath.de/</a></span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="color: red; text-transform: none;">Texte</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les &eacute;l&egrave;ves allemands proposent diff&eacute;rentes visions de   leur r&eacute;gion.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">11_ 1_aachen</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Aachen&nbsp;&raquo; dur&eacute;e 52&rsquo;&rsquo;</span></div>\\012<div><img height="135" width="101" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image044.jpg" v:shapes="_x0000_i1048" /></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">11_ 2_aachen</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Aachen&nbsp;&raquo;, dur&eacute;e 3&rsquo;24&rsquo;&rsquo;</span></div>\\012<div><img height="141" width="186" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image046.jpg" v:shapes="_x0000_i1049" /></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">11_3_baesweiler</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Baesweiler&nbsp;&raquo;, dur&eacute;e 44&rsquo;&rsquo;</span></div>\\012<div><img height="138" width="186" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image048.jpg" v:shapes="_x0000_i1050" /></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">11_ 4_alsdorf</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Alsdorf&nbsp;&raquo; dur&eacute;e 3&rsquo;06&rsquo;&rsquo;</span></div>\\012<div><img height="148" width="198" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image050.jpg" v:shapes="_x0000_i1051" /></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">11_PP_5_alsdorf</span></div>\\012<div><span style="color: blue; text-transform: none;">&laquo;&nbsp;Alsdorf&nbsp;&raquo; </span></div>\\012<div><img height="143" width="197" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image052.jpg" v:shapes="_x0000_i1052" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par l&rsquo;enseignant</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;&laquo;&nbsp;Les &eacute;l&egrave;ves   du Berufskolleg Herzogenrath de la classe G11 passeront l&rsquo;Abitur dans trois ans.   Dans le cours de fran&ccedil;ais ils ont particip&eacute; cette ann&eacute;e, avec leurs   correspondants du Lyc&eacute;e Maurice Ravel de Paris 20, au projet cin&eacute;ma propos&eacute;   par le Centre Pompidou et dont le th&egrave;me est&nbsp;: &laquo;&nbsp;Ma ville vue   par&hellip;&nbsp;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Le point de d&eacute;part a &eacute;t&eacute; l&rsquo;Atelier <i>Lignes de temps</i> qui a eu lieu &agrave; notre &eacute;cole au mois de novembre.   Les explications &eacute;taient en langue fran&ccedil;aise. Les &eacute;l&egrave;ves qui avaient quatre   ans de fran&ccedil;ais ont tr&egrave;s bien compris ce qu&rsquo;on leur a communiqu&eacute;. Le th&egrave;me   cin&eacute;matographique &eacute;tait tr&egrave;s motivant et la pr&eacute;sentation du logiciel <i>Lignes de temps</i> &eacute;tait parfaitement &agrave;   leur port&eacute;e. L&rsquo;intervention d&rsquo;experts extra scolaires a compl&egrave;tement capt&eacute;   leur attention et l&rsquo;introduction tr&egrave;s p&eacute;dagogique des intervenantes ne   pouvait que rencontrer la compr&eacute;hension de tous. Plusieurs coll&egrave;gues dont   notre directeur ont assist&eacute; &agrave; cette prestation exceptionnelle.</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Puis les &eacute;l&egrave;ves ont regard&eacute; le film &laquo;&nbsp;L&rsquo;Aurore&nbsp;&raquo;   de Murnau et ont &eacute;crit leurs impressions et leurs remarques. Celles-ci ont   &eacute;t&eacute; envoy&eacute;es aux correspondants parisiens, qui ont fait de m&ecirc;me.   L&rsquo;appr&eacute;hension du d&eacute;part pour un film en noir et blanc et muet par-dessus le   march&eacute; a &eacute;t&eacute; vite surmont&eacute;e. Les &eacute;l&egrave;ves ont reconnu la qualit&eacute; artistique du   film, les moyens techniques employ&eacute;s, l&rsquo;interpr&eacute;tation des acteurs. Certains   en ont parl&eacute; dans leur r&eacute;sum&eacute;, sans qu&rsquo;on ait au pr&eacute;alable attir&eacute; leur   attention sur ces points. Le th&egrave;me de la ville vue par Murnau a ensuite &eacute;t&eacute;   discut&eacute; en cours.</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Apr&egrave;s les vacances de No&euml;l les &eacute;l&egrave;ves ont form&eacute; de   petits groupes pour faire une pr&eacute;sentation film&eacute;e de leur ville ou leur   quartier. C&rsquo;est ainsi que nous avons obtenu plusieurs r&eacute;sultats&nbsp;: deux   sur la ville d&rsquo;Aix-la-Chapelle, un sur Alsdorf et un sur Baesweiler. Ces   films ont &eacute;t&eacute; envoy&eacute;s &agrave; Paris.</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Lors de la rencontre &agrave; Paris au mois de mars, les petits   groupes allemands se sont associ&eacute;s aux petits groupes fran&ccedil;ais et pour   prendre quelques images ou quelques vid&eacute;os sur la ville de Paris ou ses   quartiers selon des aspects qui ont pr&eacute;alablement &eacute;t&eacute; convenus au sein des   groupes franco-allemands. L&rsquo;&eacute;change n&rsquo;est pas encore termin&eacute; puisque nous   devons encore recevoir &agrave; Herzogenrath le groupe parisien. </span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Parmi les multiples effets positifs que nous a apport&eacute;s   le projet citons en quelques-uns au hasard : Le th&egrave;me de la ville est   particuli&egrave;rement bien adapt&eacute; aux &eacute;changes puisqu&rsquo;une partie des activit&eacute;s   d&rsquo;un &eacute;change ordinaire consiste &agrave; visiter les lieux o&ugrave; vivent les   partenaires. L&rsquo;aspect cin&eacute;matographique nous a apport&eacute; un grand plus, puisque   les &eacute;l&egrave;ves ont &eacute;t&eacute; sensibilis&eacute;s &agrave; certains c&ocirc;t&eacute;s de l&rsquo;art et de la technique   cin&eacute;matographique, qu&rsquo;ils ont communiqu&eacute; sur ce sujet, qu&rsquo;ils l&rsquo;ont m&ecirc;me   utilis&eacute; pour communiquer entre eux. Ce moyen de communication &eacute;tant, comme le   pensait Chaplin, universel, ils ont pu communiquer au-del&agrave; des mots par le   truchement de la cam&eacute;ra.    Ce ne sont pas uniquement les &eacute;l&egrave;ves qui ont tir&eacute; parti de   ce projet, mais aussi les professeurs car il leur a ouvert des horizons.&nbsp;&raquo;   J.P. M.</span></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<p><span style="font-size: 10pt; color: rgb(51, 51, 51);"><br clear="all" /><br />\\012</span></p>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome10"></a>Coll&egrave;ge Jean Moulin, Paris 14<sup>&egrave;me</sup> (France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">3<sup>&egrave;me</sup>A etgroupe d&rsquo;&eacute;l&egrave;ves de 3<sup>&egrave;me</sup> - Laurence Dauvergne,   professeur de technologie / Elisabeth Battistel et&nbsp;Dominique Vadet, professeurs de fran&ccedil;ais/ C&eacute;line Noras, professeur   d&rsquo;anglais / Mme Amor Fahsi, professeur 1<sup>er</sup> degr&eacute; d&rsquo;UPI</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">http://clg-jean-moulin.scola.ac   paris.fr/spip/spip.php?page=login</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: red; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">Film de la matin&eacute;e / pr&eacute;sentation   par&nbsp;?????</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">12_jean_moulin</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Une   rencontre &agrave; Paris&nbsp;&raquo;&nbsp;par des &eacute;l&egrave;ves de 3</span><sup><span style="font-size: 10pt; color: blue;">&egrave;me</span></sup><span style="font-size: 10pt; color: blue;">BCDE&nbsp;:   montage par Marie, dur&eacute;e 2&rsquo;25&rsquo;&rsquo; / montage par&nbsp;Vladimir, dur&eacute;e 5&rsquo;59&rsquo;&rsquo; / montage par Th&eacute;o, dur&eacute;e 5&rsquo;20&rsquo;&rsquo; / &nbsp;montage par&nbsp;Yixuan, dur&eacute;e 4&rsquo;41&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Un adolescent   visite Paris pour la premi&egrave;re fois. Il rencontre un &eacute;l&egrave;ve du coll&egrave;ge Jean   Moulin. Deux visions de Paris, l'une touristique, l'autre plus quotidienne,   se croisent. Diff&eacute;rents montages r&eacute;alis&eacute;s par les &eacute;l&egrave;ves &agrave; partir des m&ecirc;mes   images tourn&eacute;es par la classe.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Des tenues   pour Paris&nbsp;&raquo;, r&eacute;al. Odile, 4&rsquo;57&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Des &eacute;l&egrave;ves sont rejet&eacute;s par un groupe   en raison de leur habillement (diff&eacute;rent des leurs). Rejet&eacute;s, ils font le   tour de Paris et observent des tenues vestimentaires tr&egrave;s diverses. Ils   reviennent et sont finalement int&eacute;gr&eacute;s au groupe.</span></div>\\012<div><img height="135" width="180" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image054.jpg" v:shapes="_x0000_i1053" /></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">12_1_jean_moulin_upi</span></div>\\012<div><span style="color: red; text-transform: none;">Attention voir le DVD dans dossier, &nbsp;film upi / faire encodage / voir Thibaut</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Colegiul national Mihai Eminescu, Iasi (Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">4<sup>&egrave;me</sup> et 3<sup>&egrave;me</sup> - Sorina Danaila,   professeur de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">2<sup>&egrave;me</sup> -&nbsp;Corina Ungurean,   professeur de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">12bis_iasi_mihai_eminescu</span></div>\\012<div><span style="color: blue; text-transform: none;">&laquo;&nbsp;Ma   ville de jeunesse&nbsp;&raquo;, dur&eacute;e 7&rsquo;22&rsquo;&rsquo; / &laquo;&nbsp;Ma ville de   tranquillit&eacute;&nbsp;&raquo;, dur&eacute;e 10&rsquo;08&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La classe a voulu mettre en opposition - par le sujet,   par le rythme et aussi par la mani&egrave;re d'entrevoir la gestuelle, la marche et   m&ecirc;me la fa&ccedil;on de filmer - le Iasi de la jeunesse et le   Iasi de l'orthodoxie.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par les enseignantes</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;Les classes ont fait des   progr&egrave;s dans la pr&eacute;paration (th&egrave;mes des petits films, petits sc&eacute;narios,   travail technique de compr&eacute;hension des notions cin&eacute;matographiques...). Pour   ce qui est des collaborations avec le Coll&egrave;ge Thomas Mann &agrave; Paris les enfants   ont fait connaissance gr&acirc;ce &agrave; des blogs.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Nous avons aussi assist&eacute; &agrave; des projections d&rsquo;un festival   de documentaires sur la    ville de Iasi programm&eacute; pour la comm&eacute;moration des   600 ans de la    fondation de la ville. C'&eacute;tait l'illustration id&eacute;ale de   notre projet, et qui est tomb&eacute; fort &agrave; propos... Les enfants ont appr&eacute;ci&eacute; et   ont beaucoup argument&eacute; sur la valeur des films.&nbsp;&raquo; Sorina Danaila</span></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<p><span style="font-size: 10pt; color: rgb(51, 51, 51);"><br clear="all" /><br />\\012</span></p>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome11"></a>Colegiul national Radu Negru, </span><span style="font-size: 12pt; color: windowtext; text-transform: none;">F</span><span style="font-size: 12pt; color: windowtext; text-transform: none;">\\304\\203</span><span style="font-size: 12pt; color: windowtext; text-transform: none;">g</span><span style="font-size: 12pt; color: windowtext; text-transform: none;">\\304\\203</span><span style="font-size: 12pt; color: windowtext; text-transform: none;">ra</span><span style="font-size: 12pt; color: windowtext; text-transform: none;">\\305\\237</span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">(Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">1<sup>&egrave;re</sup> &nbsp;Raluca Ionescu,   professeur de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;"><a href="http://radunegru.licee.edu.ro/">http://radunegru.licee.edu.ro/</a></span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: red; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">Film matin&eacute;e / Pr&eacute;sentation par Raluca Ionescu et deux   &eacute;l&egrave;ves.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">13_F</span><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">\\304\\203</span><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">g</span><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">\\304\\203</span><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">ra</span><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">\\305\\237</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&nbsp;&laquo;&nbsp;Ma ville vue par&hellip; nous-m&ecirc;mes&nbsp;&raquo;,   dur&eacute;e 11&rsquo;07&rsquo;&rsquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Reportage sur la ville de F</span><span style="color: rgb(51, 51, 51); text-transform: none;">\\304\\203</span><span style="color: rgb(51, 51, 51); text-transform: none;">g</span><span style="color: rgb(51, 51, 51); text-transform: none;">\\304\\203</span><span style="color: rgb(51, 51, 51); text-transform: none;">ra</span><span style="color: rgb(51, 51, 51); text-transform: none;">\\305\\237</span><span style="color: rgb(51, 51, 51); text-transform: none;"> et ses   monuments historiques.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="155" width="217" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image056.jpg" v:shapes="_x0000_i1054" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Ann&eacute;e scolaire   2008-2008 / Programme de travail</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Ann&eacute;e scolaire 2008-2008 /   Programme de travail</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Septembre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Diffusion du projet dans le lyc&eacute;e: </span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- discussion avec: le Proviseur, le   Conseil d'Administration, le service comptable, les &eacute;l&egrave;ves</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- recherche de sponsors pour le   voyage &agrave; Paris, au mois de mai/ juin</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Septembre-octobre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">constitution du groupe des &eacute;l&egrave;ves participants</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Octobre-novembre </span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Avec le groupe d'&eacute;l&egrave;ves : </span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- visionnage du film <i>Le Cam&eacute;raman</i> de Buster Keaton.</span></div>\\012<div style="margin-left: 117pt; text-indent: -114pt;"><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">-installation du   logiciel <i>Lignes de temps</i>.</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- accueil de Fr&eacute;d&eacute;rique Mirotchnikoff et de Marta Boni:</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- explication de l'emploi de ce   logiciel</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- explication des &eacute;tapes du projet</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">-&nbsp;utilisation du logiciel <i>Lignes   de temps</i>.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Novembre-d&eacute;cembre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Mise en relation avec le bin&ocirc;me fran&ccedil;ais.</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- &eacute;change des lettres de pr&eacute;sentation,</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- mise au point du programme</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Janvier-f&eacute;vrier-mars</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Filmer dans la ville.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Mars-avril</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- sc&eacute;narisation, tournage, montage du film sur sa propre   ville.</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- correspondance entre bin&ocirc;mes sous forme de production   de &laquo;films-essais&raquo; sur sa&nbsp;propre ville </span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Mai</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- derniers aspects administratifs&nbsp;et mises au point - envoi du film au Centre   Pompidou.</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- participation au visionnage au Centre Pompidou. </span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Juin</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Diss&eacute;mination du projet dans le lyc&eacute;e</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Septembre 2009</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Avant la rentr&eacute;e: diss&eacute;mination du projet dans les   &eacute;coles de la ville et du   d&eacute;partement</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Responsable du projet</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Raluca Ionescu</span><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">,&nbsp;Professeur de   fran&ccedil;ais langue &eacute;trang&egrave;re. Colegiul National &laquo;&nbsp;Radu Negru&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Quelques courriers des &eacute;l&egrave;ves roumains &agrave; leurs   correspondants fran&ccedil;ais</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Bonjour</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je m&rsquo;appelle Cristian. J&rsquo;ai 17 ans.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis en XI&egrave;me E au Coll&egrave;ge National Radu Negru. En   Roumanie, les coll&egrave;ges nationaux sont les lyc&eacute;es les plus prestigieux.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Notre petite ville tranquille est situ&eacute;e au centre en   Transylvanie (r&eacute;gion du centre du pays), pr&egrave;s des montagnes.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis entr&eacute; dans ce projet parce que j&rsquo;aime le   fran&ccedil;ais, j&rsquo;aime le cin&eacute;ma, le&nbsp;th&eacute;&acirc;tre   et je serai tr&egrave;s heureux si, au mois de juin, on se voyait &agrave; Paris.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Mes passe-temps pr&eacute;f&eacute;r&eacute;s sont: les promenades avec mes   amis, le musique, &nbsp;l'ordinateur et   j'adore les voyages avec mes amis.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;attends impatiemment vos pr&eacute;sentations.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">A +,</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Cristian</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Bonjour!</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je m&rsquo;appelle Cyntia et j&rsquo;ai 17 ans.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J'&eacute;tudie au coll&egrave;ge &laquo; Radu Negru &raquo; (on   peut le voir dans la photo) de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;"> (Roumanie). Je suis   une jeune fille sociable.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le lyc&eacute;e est situ&eacute; au centre de la   ville, qui a 40.000 habitants. Je suis en XI-&egrave;me E (&ccedil;a</span></div>\\012<div><span style="color: windowtext; text-transform: none;">doit &ecirc;tre la premi&egrave;re d'un lyc&eacute;e   fran&ccedil;ais) <img height="118" width="157" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image058.gif" v:shapes="_x0000_i1055" /></span></div>\\012<div><span style="color: windowtext; text-transform: none;">Notre petite ville paisible est situ&eacute;e   au centre de la Roumanie, en Transylvanie, pr&egrave;s des montagnes de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;">. C'est tr&egrave;s beau.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis entr&eacute;e dans ce projet parce que   j&rsquo;aime le fran&ccedil;ais, j&rsquo;aime le cin&eacute;ma et je</span></div>\\012<div><span style="color: windowtext; text-transform: none;">serai bien heureuse si, au mois de   juin, on se voit &agrave; Paris.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Mes passe-temps pr&eacute;f&eacute;r&eacute;s sont le piano,   la lecture, les promenades avec mes amis.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;attends impatiemment vos   pr&eacute;sentations.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Au plaisir de vous lire,</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Cynthia</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="143" width="193" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image060.gif" v:shapes="_x0000_i1056" />&nbsp;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les montagnes de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;">. Cha&icirc;ne des Carpates.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut les copains!</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis Ioana, j&rsquo;ai 17 ans et je suis   &eacute;l&egrave;ve en XI&egrave;me au Coll&egrave;ge National Radu&nbsp;Negru.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;ai beaucoup de hobbies. Par exemple,   j&rsquo;aime danser et &eacute;couter de la musique.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis dans une &eacute;quipe de danses   populaires roumaines.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Eh bon! C&rsquo;est tout!</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Amiti&eacute;s,</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ioana</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Bonjour</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je m&rsquo;appelle Laurentiu .</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;ai 17 ans.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis en XI&egrave;me B &ndash;en France, &ccedil;a doit &ecirc;tre la premi&egrave;re,   du Coll&egrave;ge National Radu Negru. C'est un des meilleurs lyc&eacute;es de notre   d&eacute;partement.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Notre petite ville calme est situ&eacute;e au centre de la Roumanie,   en Transylvanie, pr&egrave;s des montagnes portant le m&ecirc;me nom: F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;">.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ce projet me pla&icirc;t parce que j&rsquo;aime le fran&ccedil;ais et le   cin&eacute;ma. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Mes passe-temps pr&eacute;f&eacute;r&eacute;s sont le football, la danse,   l'ordinateur.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je voudrais bien qu'on se voie au mois de juin &agrave; Paris.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;attends impatiemment vos pr&eacute;sentations.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Au plaisir de vous lire,</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Laurentiu</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Bonjour</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je m&rsquo;appelle Laurentiu Ionut. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;ai 17 ans.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis en XI&egrave;me E du Coll&egrave;ge National Radu Negru de la   ville de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;">. En Roumanie, on nomme coll&egrave;ge national les meilleurs   lyc&eacute;es.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Notre petite ville tranquille est situ&eacute;e au centre de la   Roumanie, en Transylvanie, pr&egrave;s des montagnes portant le m&ecirc;me nom.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis entr&eacute; dans ce projet parce que j&rsquo;aime le   fran&ccedil;ais, j&rsquo;aime le cin&eacute;ma.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je serais tr&egrave;s heureux si, au mois de juin, on se voyait   &agrave; Paris.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Mes passe-temps pr&eacute;f&eacute;r&eacute;s sont le football, l&rsquo;ordinateur,   la musique, les promenades avec mes amis.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">A l&rsquo;attente de vos pr&eacute;sentations,</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ionut</span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><a href="http://upload.wikimedia.org/wikipedia/commons/b/b4/Fagaras_IMG_5668.jpg"><span style="text-decoration: none;"><img height="139" width="185" border="0" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image062.jpg" alt="Fichier:Fagaras IMG 5668.jpg" v:shapes="_x0000_i1057" /></span></a></div>\\012<div><span style="color: windowtext; text-transform: none;">Le Ch&acirc;teau-fort de </span><span style="color: windowtext; text-transform: none;">F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Le ch&acirc;teau-fort de   F</span><span style="color: blue; text-transform: none;">\\304\\203</span><span style="color: blue; text-transform: none;">g</span><span style="color: blue; text-transform: none;">\\304\\203</span><span style="color: blue; text-transform: none;">ra</span><span style="color: blue; text-transform: none;">\\305\\237</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Le ch&acirc;teau-fort de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;(en roumain : Cetatea F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;">) est un   ch&acirc;teau fort situ&eacute; en plein centre ville de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;">. La construction   du ch&acirc;teau a d&eacute;but&eacute; en 1310,</span></div>\\012<div><span style="color: windowtext; text-transform: none;">sur le site   d'une ancienne fortification de terre et de bois du XII si&egrave;cle. Son but &eacute;tait   &eacute;minemment</span></div>\\012<div><span style="color: windowtext; text-transform: none;">strat&eacute;gique,   &agrave; savoir d&eacute;fendre le sud-est de la</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Transylvanie   contre les incursions des Tatars et des Ottomans. Actuellement le ch&acirc;teau   h&eacute;berge le mus&eacute;e du pays de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;"> avec des   sections sur l'histoire de la ville et du pays de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;"> ainsi que la   biblioth&egrave;que municipale.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ioana</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<p>&nbsp;</p>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;"><a name="binome12"></a>Coll&egrave;ge Darius Milhaud, Sartrouville   (France)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">3<sup>&egrave;me</sup>1 - </span><span style="color: windowtext; text-transform: none;">Anne-Catherine Mourgue</span><span style="color: windowtext; text-transform: none;">, professeur de lettres classiques / Aur&eacute;lie Pieterwas professeur de   lettres classiques / Philippe Roca et Julien Charlier, professeurs de   technologie / Christelle Musset, professeur d'anglais / Christophe Sayol,   professeur d'anglais / Nicolas Henry professeur de SVT</span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;"><a href="http://www.clg-milhaud-sartrouville.ac-versailles.fr/">http://www.clg-milhaud-sartrouville.ac-versailles.fr/</a></span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="background: lime none repeat scroll 0% 0%; color: windowtext; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">Clic</span><span style="color: blue; text-transform: none;"> pr&eacute;sentation   par Anne Catherine    Mourgue</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">14_Darius_Milhaud</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">&nbsp;</span><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Ma ville vue par&hellip; la m&egrave;re et sa fille&nbsp;&raquo;, dur&eacute;e 5&rsquo;40&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Les alentours   du coll&egrave;ge &agrave; travers deux points de vue&nbsp;: le regard du b&eacute;b&eacute; et celui de   sa m&egrave;re.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="147" width="197" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image064.jpg" v:shapes="_x0000_i1058" /></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: blue;">Texte</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;Nous avons &eacute;crit une trame de sc&eacute;nario : Ma ville   vue par... des personnes d'&acirc;ges diff&eacute;rents.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les deux angles de vues du film seront le regard d'un   b&eacute;b&eacute;/jeune enfant et de sa m&egrave;re.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Point de vue de l'enfant : Vision en contre-plong&eacute;e   et/ou depuis une poussette. Les choses sont vues d'en bas, on est au ras du   sol, on voit tout un tas d'aspect de la ville dont les plus grands n'ont pas   forc&eacute;ment conscience, ou qu'ils per&ccedil;oivent diff&eacute;remment : pots d'&eacute;chappements,   voitures qui passent tr&egrave;s pr&egrave;s de la poussette et qui sont effrayantes,   crottes de chiens, plaques d'&eacute;gouts, jambes des passants, chiens agressifs   juste au m&ecirc;me niveau (qui se jettent contre le grillage ou aboient en   montrant les dents au passage de la poussette), secousses du trajet en   poussette, descente du toboggan (chute en avant vers le vide), personnes qui   se penchent sur la poussette pour embrasser l'enfant ou le toucher (gros plan   d'une personne qui se penche vers la cam&eacute;ra) etc.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Par moments, flashes de lumi&egrave;re vive (rayons de soleil   selon la direction dans laquelle on roule) ou passages plus sombres.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La musique utilis&eacute;e devra &ecirc;tre angoissante, en   ad&eacute;quation avec les impressions de l'enfant. Les bruits (aboiements, etc.)   agressifs et tr&egrave;s forts par rapport &agrave; la musique.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Point de vue de la m&egrave;re : Vision positive de la balade,   atmosph&egrave;re d&eacute;tendue, gens vus d'en haut, souriants, les conducteurs des   v&eacute;hicules crois&eacute;s s'arr&ecirc;tent pour laisser passer la poussette, passants/connaissances   qui s'adressent &agrave; la cam&eacute;ra et lui sourient en restant &agrave; une distance   respectueuse et &agrave; la m&ecirc;me hauteur, parc aux couleurs gaies et agr&eacute;ables de   taille normale, etc.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La musique est plut&ocirc;t gaie, enjou&eacute;e et en tout les cas   agr&eacute;able pour faire un vrai contraste avec l'autre point de vue.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La raison des deux diff&eacute;rents points de vue ne devra pas   &ecirc;tre trop explicite d&egrave;s le d&eacute;but, ce serait bien de pouvoir intriguer et de   ne r&eacute;v&eacute;ler la cl&eacute; qu'&agrave; la fin, &agrave; l'aide d'une chute (m&egrave;re qui se penche sur   la cam&eacute;ra et dit quelque chose concernant la balade)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Lieux : rues voisines du coll&egrave;ge par exemple, parc pr&egrave;s   du coll&egrave;ge (en allant vers l'espace G&eacute;rard Philippe) ou parc du dispensaire&hellip;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Nous (le prof de techno) avons cr&eacute;&eacute; un logiciel pour   r&eacute;diger les sc&eacute;narios et allons commencer &agrave; monter le 31 mars sur un salon o&ugrave;   nous nos &eacute;l&egrave;ves pr&eacute;sentent les logiciels libres&nbsp;: </span><span style="color: blue; text-transform: none;"><a href="http://www.intertice.fr/">http://www.intertice.fr/</a>.</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Liceo   classico M. Gioia, Piacenza (Italie)</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">2<sup>&egrave;me</sup>B classique - Maria Augusta Schippisi,   professeur de langages non verbaux</span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;"><a href="http://www.liceogioia.it/">http://www.liceogioia.it/</a></span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">15_LiceoM.GioiaPiacenza</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;I Ragazzi con la machina da presa&nbsp;&ndash; Odessa adesso&nbsp;&raquo;,   dur&eacute;e 11&rsquo;49&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Fascin&eacute;s par <i>L&rsquo;Homme &agrave; la cam&eacute;ra<span style="font-style: normal;"> de Dziga</span><span style="font-style: normal;">   Vertov, les &eacute;l&egrave;ves ont construit leur film sur le mod&egrave;le du film.</span></i></span></div>\\012<div>&nbsp;</div>\\012<div><img height="149" width="197" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image066.jpg" v:shapes="_x0000_i1059" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par les enseignants</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Piacenza, 26 juin 2008</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Projet europ&eacute;en <i>La    mia citt&agrave; vista</i><i>   da&hellip;</i></span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Cadre :</span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Langages non verbaux et multim&eacute;dia (la communication    cin&eacute;matographique) et Informatique</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Autre disciplines&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Italien</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull; Langue   &eacute;trang&egrave;re</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Destinataires&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Les   &eacute;tudiants de deux classes de seconde jumel&eacute;s avec deux classes d&rsquo;un lyc&eacute;e   fran&ccedil;ais (m&ecirc;me type d&rsquo;&eacute;tudes et m&ecirc;me &acirc;ge)</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Enseignants&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Langages&nbsp;:   Paola Gozzi   et Maria    Augusta Schippisi</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Informatique&nbsp;:   Paolo Vermi</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Instruments&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><i><span style="color: windowtext; text-transform: none;">Lignes de temps</span></i></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Formation des enseignants&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Une   journ&eacute;e de pr&eacute;paration avec l&rsquo;expert de l&rsquo;Iri.</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Objectifs&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Approfondir les comp&eacute;tences d&rsquo;analyse du texte filmique.</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   R&eacute;aliser un court-m&eacute;trage inspir&eacute; par la structure narrative ou   formelle des films analys&eacute;s.</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull; Donner   l&rsquo;occasion d&rsquo;un &eacute;change culturel entre des &eacute;tudiants de l&rsquo;Union europ&eacute;enne.</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Plan des activit&eacute;s&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">1er p&eacute;riode de l&rsquo;ann&eacute;e scolaire   (septembre-d&eacute;cembre)</span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Activit&eacute;s pr&eacute;liminaires&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Exploration guid&eacute;e du logiciel (&eacute;tudiants et expert de l&rsquo;Iri).</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Analyse de textes litt&eacute;raires sur le th&egrave;me de la ville (enseignants d&rsquo;Italien   et de Langue &eacute;trang&egrave;re, pendant les horaires de cours).</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull; D&eacute;but   de la    d&eacute;codification du langage cin&eacute;matographique (avec les   enseignants de Langages, pendant les horaires de cours).</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Pr&eacute;-production d&rsquo;un court-m&eacute;trage sur le th&egrave;me de la ville&nbsp;: &eacute;criture du   sc&eacute;nario (20h- selon les disponibilit&eacute;s des enseignants- avec un expert   externe nomin&eacute; par le lyc&eacute;e).</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">2e p&eacute;riode de l&rsquo;ann&eacute;e scolaire   (janvier-mai)</span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Les   m&ecirc;mes &eacute;tapes seront suivies par les &eacute;tudiants des classes partenaires en   France. </span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">1&egrave;re &eacute;tape&nbsp;(janvier 2009- pendant   les cours de Langages et Informatique)&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull; Avec   le logiciel <i>Lignes de temps</i>,   analyse d&rsquo;un film sur la    ville &agrave; choisir entre un long-m&eacute;trage, un documentaire ou   un film exp&eacute;rimental (propos&eacute;s par l&rsquo;Iri).</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">2e &eacute;tape&nbsp;(janvier/f&eacute;vrier -   pendant les cours de Langages et Informatique)&nbsp;:</span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   &eacute;change de points de vue sur les films analys&eacute;s avec la classe partenaire.</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">3e &eacute;tape&nbsp;(f&eacute;vrier/mars- selon les   disponibilit&eacute;s du conseil de classe - 30h)&nbsp;:</span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Production du court-m&eacute;trage&nbsp;: r&eacute;alisation du court-m&eacute;trage sur le mod&egrave;le   du film analys&eacute; (intervention d&rsquo;un expert nomin&eacute; par le lyc&eacute;e).</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">4e &eacute;tape&nbsp;(avril/mai pendant les cours   de Langages et Informatique)&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull; Les   classes partenaires s&rsquo;&eacute;changent les courts-m&eacute;trages r&eacute;alis&eacute;s, ils les   analysent et s&rsquo;&eacute;changent leurs points de vue.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par les enseignants</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Piacenza, mai 2009</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;</span><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;Les   &eacute;l&egrave;ves ont analys&eacute; plusieurs films   sur la ville et ont &eacute;t&eacute; fascin&eacute;s par <i>L&rsquo;homme   &agrave; la cam&eacute;ra</i> de Dziga Vertov, film dans lequel on voit des images de   Moscou mais aussi les p&eacute;rip&eacute;ties de l&rsquo;op&eacute;rateur qui cherche ses images dans   la ville, ainsi que les spectateurs qui assistent, dans une salle de cin&eacute;ma,   &agrave; la projection    du film que la cam&eacute;ra a captur&eacute; pour eux.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">En r&eacute;fl&eacute;chissant &agrave; la mani&egrave;re de repr&eacute;senter   Piacenza, ils ont voulu se r&eacute;f&eacute;rer &agrave; ce mod&egrave;le qu&rsquo;ils consid&egrave;rent encore   d&rsquo;actualit&eacute;. Ils n&rsquo;ont donc pas suivi de sc&eacute;nario, et se sont montr&eacute;s dans   l&rsquo;acte de tourner. Leur cam&eacute;ra a essay&eacute; de saisir le rythme de la vie quotidienne.&nbsp;Le montage a eu un r&ocirc;le capital : la   comparaison entre les plans de la ville sovi&eacute;tique et   ceux de Piacenza montre que les villes, bien que distantes dans l&rsquo;espace et   dans le temps, se ressemblent un peu, lorsqu&rsquo;elles parlent de la vie de tout   les jours lorsque la    ville est vide parce qu&rsquo;elle dort ; lorsqu&rsquo;elle s&rsquo;anime et   se remplit, lorsqu&rsquo;elle travaille; mais, puisque le tournage s&rsquo;est fait le   jour o&ugrave; le pont sur le P&ocirc; s&rsquo;est &eacute;croul&eacute;, ils ont pu filmer aussi cet   &eacute;v&eacute;nement exceptionnel.<br />\\012            Le montage a eu un r&ocirc;le capital : la comparaison continue    entre les plans de la ville sovi&eacute;tique et   celles de Piacenza nous montrent que toutes les villes, bien que distantes   dans l&rsquo;espace et dans le temps, se ressemblent un peu, lorsqu&rsquo;elles parlent   de la vie.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome13"></a>Coll&egrave;ge Darius Milhaud, Sartrouville   (France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">3</span><sup><span style="color: rgb(51, 51, 51); text-transform: none;">&egrave;me</span></sup><span style="color: rgb(51, 51, 51); text-transform: none;">4</span>&nbsp;<span style="color: rgb(51, 51, 51); text-transform: none;">- </span><span style="color: rgb(51, 51, 51); text-transform: none;">Anne-Catherine Mourgue</span><span style="color: rgb(51, 51, 51); text-transform: none;">,   professeur de lettres classiques / Aur&eacute;lie Pieterwas professeur de lettres   classiques / Philippe Roca et Julien Charlier, professeurs de technologie /   Christelle Musset, professeur d'anglais / Christophe Sayol, professeur   d'anglais / Nicolas Henry professeur de SVT</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">NN&nbsp;: Le Coll&egrave;ge Darius Milhaud et le Colegiul   National Mihai Eminescu ayant plusieurs classes en bin&ocirc;me ont produit des   films communs. Voir ci-dessus.</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Colegiul   national Mihai Eminescu, Iasi</span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">(Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">3&egrave;me,</span><span style="font-size: 10pt; color: rgb(51, 51, 51);"> Sorina Danaila,   professeur de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<p><span style="font-size: 10pt; color: rgb(51, 51, 51);"><br clear="all" /><br />\\012</span></p>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome14"></a>Lyc&eacute;e Paul Val&eacute;ry, Paris 12<sup>&egrave;me</sup></span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">(France)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">1&egrave;re ES1 et 1er S2- et &eacute;tudiants du Lyc&eacute;e Charlemagne, option   facultative cin&eacute;ma - Philippe    Zill, professeur de cin&eacute;ma</span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;"><a href="http://lyc-paul-valery.scola.ac-paris.fr/PVpages/PCSI/index_pcsi.html">http://lyc-paul-valery.scola.ac-paris.fr/PVpages/PCSI/index_pcsi.html</a></span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">18_Charlemagne(1)</span></div>\\012<div><b><span style="font-size: 10pt; color: red;">&nbsp;</span></b><span style="font-size: 10pt; color: rgb(51, 51, 51);">&laquo;&nbsp;</span><span style="font-size: 10pt; color: blue;">Le Prince malheureux&nbsp;&raquo; dur&eacute;e 5&rsquo;26&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Sylvain, 20 ans se pr&eacute;sente confiant &agrave; une audition pour   l&rsquo;adaptation am&eacute;ricaine de <i>B&eacute;r&eacute;nice</i>,   dans le Marais.</span></div>\\012<div><b><span style="font-size: 10pt; color: red;">Attention Thibaut, le film ne commence   qu&rsquo;apr&egrave;s un grand noir, &agrave; 0&rsquo;38&rsquo;&rsquo;</span></b></div>\\012<div><b>&nbsp;</b></div>\\012<div><img height="135" width="180" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image068.jpg" v:shapes="_x0000_i1060" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;</span><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;Avant   de partir, sa copine ne l&rsquo;encourage qu&rsquo;&agrave; demi-mot. Pourtant, l&rsquo;enjeu est   important. Il &eacute;choue. A la    sortie de l&rsquo;audition, pris de d&eacute;sespoir il suit la directrice de casting   dans les rues du Marais, en vue d&rsquo;une seconde chance. R&eacute;alisant son&nbsp;   erreur, il reprend ses esprits et se r&eacute;concilie avec sa copine.&nbsp;&raquo; Laure   Massiet</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext;">&nbsp;</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51);">Colegiul B. P. Hasdeu, Buz</span><span style="font-size: 14pt; color: rgb(51, 51, 51);">\\304\\203</span><span style="font-size: 14pt; color: rgb(51, 51, 51);">u</span><span style="font-size: 14pt; color: rgb(51, 51, 51);"> (Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">3&egrave;me - Ioana    Voinea&nbsp;/ Dan    Solcan, professeurs de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);"><a href="http://bph.uv.ro/index.php?vidcateg=16">http://bph.uv.ro/index.php?vidcateg=16</a></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">19_Buz</span><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">\\304\\203</span><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">u</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Salut   Paris&nbsp;&raquo;, dur&eacute;e 24&rsquo;&rsquo; /&nbsp;&laquo;&nbsp;Ma   ville vue par&hellip; Buz</span><span style="font-size: 10pt; color: blue;">\\304\\203</span><span style="font-size: 10pt; color: blue;">u</span><span style="font-size: 10pt; color: blue;">&nbsp;&raquo;, dur&eacute;e   13&rsquo;08&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">L&rsquo;id&eacute;e g&eacute;n&eacute;rale du film, c'est   la ville, les rues, les parcs, des aspects de la vie des gens, des   animaux et des b&acirc;timents anciens, notre lyc&eacute;e et nos &eacute;l&egrave;ves.</span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><img height="140" width="186" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image070.jpg" v:shapes="_x0000_i1061" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par les enseignants</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;&laquo;&nbsp;Nous avons&nbsp;travaill&eacute; sur des s&eacute;quences&nbsp;:</span></div>\\012<div><span style="color: windowtext; text-transform: none;">1.&nbsp;tout d'abord notre lyc&eacute;e   avec l'entr&eacute;e.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">2. la gare, des images du parc   du lyc&eacute;e avec des &eacute;l&egrave;ves qui bougent.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">3. l</span><span style="color: windowtext; text-transform: none;">'&eacute;glise pr&egrave;s du lyc&eacute;e,&nbsp;le cours de religion ayant   comme fond sonore la    pri&egrave;re que les &eacute;l&egrave;ves disent au commencement, des images de   l'&eacute;glise avec des enfants qui embrassent les ic&ocirc;nes, une autre &eacute;glise datant   de l'ann&eacute;e 1922 et qui se trouve dans le Bocage, parc classique de la&nbsp;   ville.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">4. la biblioth&egrave;que du lyc&eacute;e.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">5. une s&eacute;quence d'un montage de   Guignol, inspir&eacute; d'un conte roumain. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">6. la r&eacute;p&eacute;tition d'une troupe   rock, dont la soliste est une de nos &eacute;l&egrave;ves de terminale ; les halls vides et   anim&eacute;s d'&eacute;l&egrave;ves&nbsp;pendant&nbsp;&nbsp;les r&eacute;cr&eacute;ations. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">7. le vieux b&acirc;timent d&rsquo;un   h&ocirc;pital un peu d&eacute;labr&eacute;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">8. des &eacute;l&egrave;ves qui sont entr&eacute;s   dans le livre des records, ils ont nou&eacute; le plus long fil.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">9. la vieille ville avec   la rue    commer&ccedil;ante la plus passanteC<em><span style="font-weight: normal;">uZa   Voda.</span></em></span></div>\\012<div><span style="color: windowtext; text-transform: none;">10. les &eacute;l&egrave;ves qui fl&acirc;nent sur   le boulevard et dans le Bocage.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">11. la ville pendant la   nuit avec le Palais Communal.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">12. retour au lyc&eacute;e avec le   portrait du patron, l'&eacute;crivain BP Hasdeu, les bustes de deux grandes   personnalit&eacute;s, anciens &eacute;l&egrave;ves, les halls , les fleurs tr&egrave;s ch&egrave;res &agrave; notre   directeur.&nbsp;&raquo; Ioana    Voinea</span></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: blue;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Quelques courriers des &eacute;l&egrave;ves roumains &agrave; leurs correspondants   fran&ccedil;ais</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Quelques   courriers des &eacute;l&egrave;ves roumains &agrave; leurs correspondants fran&ccedil;ais</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je m&rsquo;appelle   Patricia</span><span style="color: windowtext; text-transform: none;"> et je suis lyc&eacute;enne au college B. P. Hasdeu&nbsp;.Je suis n&eacute;e en novembre 1992 et j&rsquo;ai 16   ans. A l&rsquo;&eacute;cole je suis dans une classe ou nous &eacute;tudions les math&eacute;matiques,   informatique, chimie, biologie, physiques plus que les autres copains. Je   connais l`anglais tr&egrave;s bien et le fran&ccedil;ais de niveau moyen.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;aime communiquer avec d&rsquo;autres gens et me faire   beaucoup d&rsquo;amies. J`aime aussi lire tandis que ma classe est faite pour ceux   qui aiment les sciences. Mon r&ecirc;ve est de&nbsp;devenir un bon m&eacute;decin parce que je crois qu&rsquo;aider les hommes quand   ils sont malades est un des plus beaux m&eacute;tiers. Si on parle &laquo;&nbsp;&eacute;ducation   physique&nbsp;&raquo; je peux dire que j`aime le basket-ball et la danse sportive.   J&rsquo;aime aussi les promenades avec mes amis et&nbsp;mes copains.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les animaux&hellip; je les aime. J&rsquo;ai deux chiens qui s&rsquo;appellent   Fred et Lady et une petite chatte c&acirc;line qui s&rsquo;appelle Zuzu.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Quand j&rsquo;ai du temps j&rsquo;aime naviguer sur l&rsquo;internet et   &eacute;couter de la musique. J&rsquo;&eacute;coute   beaucoup de bandes qui chantent de la musique rock comme   Iron Maiden, AC/DC, Queen, Metallica et autres.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;esp&egrave;re que dans ce projet nous aurons la chance   d&rsquo;apprendre des choses fascinantes sur votre pays et faire beaucoup d`amis. C&rsquo;est   magnifique comme nous pouvons connaitre un autre homme avec des images et des   films.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut   ! Je suis Diana</span><span style="color: windowtext; text-transform: none;"> et j'ai 16 ans et 8 mois. J'aime bien la chimie et les   autres sciences. Dans mon temps libre j&rsquo;aime lire des livres divers, les   promenades et &nbsp;voir des films, surtout   en fin de semaine. Je suis une personne qui s'int&eacute;resse aux probl&egrave;mes de   l'humanit&eacute;, de la&nbsp;nature et des animaux et   je voudrais faire quelque chose pour les aider. Mon r&ecirc;ve est de devenir   m&eacute;decin ou travailler dans un domaine militaire, mais je ne suis s&ucirc;re pour le   moment.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut,   je m'appelle Ana-Maria.</span><span style="color: windowtext; text-transform: none;"> J'ai 16 ans, j'adore dessiner, lire,   chanter n'importe o&ugrave;, sortir avec mes amis, voyager et surfer sur le net.   Depuis que j'ai ma palette graphique, je dessine presque sans arr&ecirc;t sur mon   ordinateur.<br />\\012            En ce qui concerne mon caract&egrave;re : ...t&ecirc;te dans les nuages plut&ocirc;t qu&rsquo;avoir   les pieds sur terre, timide &agrave; certains moments et compl&egrave;tement d&eacute;jant&eacute;e &agrave;   d&rsquo;autres, ouverte d&rsquo;esprit plut&ocirc;t que ferm&eacute;e aux grandes th&eacute;ories, pas tr&egrave;s   expansive mais pas non plus introvertie, bavarde quand l&rsquo;envie m&rsquo;en prend   mais plut&ocirc;t discr&egrave;te quand il s&rsquo;agit de d&eacute;battre&hellip; et un brin cynique (qu&rsquo;est   ce que les gens peuvent me d&eacute;tester pour &ccedil;a <img height="15" width="15" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image071.gif" v:shapes="_x0000_i1062" />)   </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Je m&rsquo;appelle   Denisa</span><span style="color: windowtext; text-transform: none;">. Je suis n&eacute;e en 1992 donc j&rsquo;ai dix-sept ans.   J&rsquo;habite&nbsp;Buz</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">u</span><span style="color: windowtext; text-transform: none;">, une ville de Roumanie.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis lyc&eacute;enne en seconde classe. Mes objets d&rsquo;&eacute;tude   pr&eacute;f&eacute;r&eacute;s sont : les langues &eacute;trang&egrave;res (l&rsquo;anglais et le fran&ccedil;ais), la chimie,   et les maths. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Quand j&rsquo;ai beaucoup de temps libre j&rsquo;aime rencontrer mes   amis. Chaque fois, nous essayons de faire n&rsquo;importe quoi pour nous divertir.   Nous allons au disco, voyons des films, d`habitude des com&eacute;dies, ou nous nous   promenons dans le parc.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Quand je suis seule j&rsquo;adore &eacute;couter de la musique,   danser et pourquoi pas lire un bon livre. De m&ecirc;me j&rsquo;aime jouer avec les   animaux. J`adore les chats mais, comme je n&rsquo;en ai pas, je joue avec le chat   de ma meilleure amie.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis tr&egrave;s heureuse de&nbsp;prendre part a ce projet. J&rsquo;esp&egrave;re que nous deviendrons bons amis.<br clear="all" /><br />\\012            </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Salut !   Je m&rsquo;appelle Corina</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai 16 ans et demi.&nbsp;J&rsquo;habite avec mes parents et je suis fille unique. Moi, je voudrais   devenir un bon psychologue parce que j&rsquo;aime comprendre et expliquer la vie spirituelle de   quelqu'un. En ce qui concerne mes passions j&rsquo;aime voir des films quand j&rsquo;ai   du temps et jouer au volley-ball. </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Je   m&rsquo;appelle Corina</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai 16 ans. Je suis &eacute;l&egrave;ve en seconde au lyc&eacute;e   &ldquo;Bogdan Petriceicu Hasdeu&rdquo; de Buz</span><span style="">\\304\\203</span><span style="color: windowtext; text-transform: none;">u, Roumanie. Je suis toujours calme et   optimiste. Me balader, faire des excursions, passer le temps avec mes amis ou   avec ma famille, toutes ces choses me plaisent beaucoup. J&rsquo;aime aussi lire,   &eacute;couter de la musique, danser&hellip; </span></div>\\012<div><span style="color: windowtext; text-transform: none;">C&rsquo;est parce que je trouve les math&eacute;matiques tr&egrave;s   int&eacute;ressantes que j&rsquo;ai choisi d&rsquo;&ecirc;tre &eacute;l&egrave;ve dans cette classe au profil   math&eacute;matiques-informatiques, mais ce qui me pla&icirc;t le plus &agrave; l&rsquo;&eacute;cole c&rsquo;est la chimie. M&ecirc;me si   je sais que j&rsquo;ai encore beaucoup de choses &agrave; apprendre, je crois que la chimie est r&eacute;ellement   fascinante.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis une fille ambitieuse et je suis s&ucirc;re que mon   r&ecirc;ve d&rsquo;&ecirc;tre m&eacute;decin deviendra r&eacute;alit&eacute; un jour. Et, qui sait ? Peut-&ecirc;tre   j&rsquo;aurai m&ecirc;me l&rsquo;occasion d&rsquo;&eacute;tudier en France.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut mes   amis! Je suis Diana</span><span style="color: windowtext; text-transform: none;"> et j'ai 16   ans. J'habite Buz</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">u</span><span style="color: windowtext; text-transform: none;"> avec ma famille : mes parents, ma s&oelig;ur et mon grand-p&egrave;re. Comme tous   les jeunes j'aime &eacute;couter de la musique mais ce que j'aime le plus est   collectionner des monnaies. En ce qui concerne l'&eacute;cole, mes objets pr&eacute;f&eacute;r&eacute;s   sont l'anglais, la psychologie, la biologie&nbsp;mais aussi le fran&ccedil;ais.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Je   m&rsquo;appelle Maria. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;ai 16 ans.J&rsquo;habite en Buz</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">u</span><span style="color: windowtext; text-transform: none;"> et je suis &eacute;tudiante au </span><em><span style="color: windowtext; text-transform: none; font-weight: normal;">Coll&egrave;ge   National Bogdan Petriceicu Hasdeu.</span></em></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;aime la musique. Mes groupes pr&eacute;f&eacute;r&eacute;es sont Pink Floyd   et Nirvana. J&rsquo;aime aussi la    peinture et la photographie. Mes artists pr&eacute;f&eacute;r&eacute;es sont   Ren&eacute;e Magritte et Salvador Dali. J&rsquo;aime aussi &eacute;couter du th&eacute;&acirc;tre   radiophonique ou lire.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&Agrave; l&rsquo;&eacute;cole j&rsquo;aime beaucoup la chimie et je   voudrais devenir chimiste ou m&eacute;decin.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut !   Je m&rsquo;appelle Monica</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai seize ans. J&rsquo;&eacute;tudie au Coll&egrave;ge B.P.Hasdeu en   seconde. Je suis une fille sociable et&nbsp;toujours joyeuse. J&rsquo;adore la France et surtout le fran&ccedil;ais. J&rsquo;ai eu la   possibilit&eacute; d&rsquo;aller en France et j&rsquo;&eacute;tais vraiment impressionn&eacute;e.   J&rsquo;aimerais&nbsp;retourner dans la ville lumi&egrave;re   un jour.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le projet qu&rsquo;on avait commenc&eacute;&nbsp;ensemble m&rsquo;a donne la possibilit&eacute;   d&rsquo;apprendre beaucoup de nouvelles&nbsp;choses&nbsp;mais aussi que le   travail en &eacute;quipe c&rsquo;est tr&egrave;s important. J&rsquo;aime aussi la photographie et&nbsp;maintenant&nbsp;avec l&rsquo;aide de ce projet je peux combiner la photographie avec le   fran&ccedil;ais.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Mon&nbsp;r&ecirc;ve est de   faire le tour du monde apr&egrave;s que je finirai la Facult&eacute; de M&eacute;dicine. M&ecirc;me si   j&rsquo;aime beaucoup voyager je ne partirai jamais&nbsp;d&eacute;finitivement&nbsp;de&nbsp;Roumanie. J&rsquo;aime beaucoup mon pays&nbsp;et&nbsp;sa culture.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Chers amis, Je m&rsquo;appelle Andreea</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai   16 ans. Je suis une fille tr&egrave;s sociable ; j&rsquo;ai beaucoup d&rsquo;amis, mais mes   meilleures amies sont deux filles. J&rsquo;aime rencontrer mes amis et aussi   j&rsquo;adore quand nous sommes ensemble et nous faisons tout ce que les jeunes de   notre &acirc;ge font : aller dans le&nbsp;parc,   jouer sur l&rsquo;ordinateur, s&rsquo;amuser, lire un bon livre; mais la plus importante chose   et que nous nous &eacute;coutons entre nous et&nbsp;nous apprenons que l&rsquo;amiti&eacute; c&rsquo;est tr&egrave;s importante dans la vie des jeunes.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Apr&egrave;s le bac, je ne sais tr&egrave;s bien quel   m&eacute;tier je choisirai, mais je crois que je deviendrai &eacute;conomiste, avocate ou   professeur.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut&nbsp;!   Je m&rsquo;appelle Bianca,</span><span style="color: windowtext; text-transform: none;"> j&rsquo;ai&nbsp;16 ans et   j&rsquo;habite Buz</span><span style="">\\304\\203</span><span style="color: windowtext; text-transform: none;">u, Roumanie. J&rsquo;ai une s&oelig;ur, qui a 8 ans, mais avec   laquelle je ne m&rsquo;entends pas si bien. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">A l&rsquo;&eacute;cole j&rsquo;aime les langues (l&rsquo;anglais, le fran&ccedil;ais et   aussi l&rsquo;allemand), l&rsquo;histoire, la chimie. J&rsquo;adore lire des romans. Je viens de   finir&nbsp;<i>Le ch&acirc;teau</i> de Kafka),   j&rsquo;aime la photographie, voir des films. J&rsquo;&eacute;coute toujours de la musique &ndash; en   lisant, en &eacute;crivant mes devoirs&hellip; tout les temps. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Si c&rsquo;&eacute;tait selon moi, je resterais toujours dans des   caf&eacute;s, je lirais toujours, j&rsquo;irais aux concerts (m&ecirc;me si &agrave; Buz</span><span style="">\\304\\203</span><span style="color: windowtext; text-transform: none;">u il n&rsquo;y   a pas tant), mais il faut aussi penser aux &eacute;tudes, &agrave; l&rsquo;avenir, essayer de   r&eacute;pondre &agrave; cette question qui a commenc&eacute; &agrave; accaparer nos ann&eacute;es de   lyc&eacute;e&nbsp;: Quelle universit&eacute; veux-tu suivre de suite&nbsp;? Moi, j&rsquo;essaye   de rester &agrave; 16 ans, je ne me comporte pas comme un adulte, je fais toute   sorte de b&ecirc;tises &ndash; il reste encore du temps pour penser aux choses plus   s&eacute;rieuses,&nbsp;pour &lsquo;grandir&rsquo;. </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut!   Je m`appelle Claudia</span><span style="color: windowtext; text-transform: none;">, j&rsquo;ai 16 ans et j&rsquo;habite&nbsp;Buz</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">u</span><span style="color: windowtext; text-transform: none;">, une   ville de&nbsp;la Roumanie.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;ai un fr&egrave;re, il &lsquo;appelle Ciprian et il a 20 ans&hellip; donc   je suis la cadette de    ma famille. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">&Agrave; l&rsquo;&eacute;cole j`aime les langues &eacute;trang&egrave;res [l&rsquo;anglais, le   fran&ccedil;ais et l&rsquo;allemand],&nbsp;la biologie,   l`histoire et les arts plastiques.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Comme hobby, j&rsquo;aime &eacute;couter de la musique, mes artistes   pr&eacute;f&eacute;r&eacute;s sont : Metallica, Pink Floyd, Led Zeppelin, Norah Jones, Red Hot   Chili Peppers , Gorillaz, Urma [ils sont roumains]&nbsp;et beaucoup d&rsquo;autres, j`aime jouer du   tennis, j`aime la photographie.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pour l&rsquo;avenir je veux visiter&nbsp;tout le monde [s`il est&nbsp;possible].</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis tr&egrave;s enchant&eacute;e de ce projet et je le veux&nbsp;voir fini. </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut&nbsp;!   Je m&rsquo;appelle Elena</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai 16 ans. Comme tous les ados, j&rsquo;aime beaucoup &eacute;couter de la musique, surfer sur   l&rsquo;internet, jouer au basketball et j&rsquo;adore aussi voyager. Mon r&ecirc;ve est de   visiter tout le monde, sp&eacute;cialement l&rsquo;Extr&ecirc;me-Orient. </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut!   Je m&rsquo;appelle Ioana</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai 16 ans. J&rsquo;habite Buz</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">u</span><span style="color: windowtext; text-transform: none;">, Roumanie et j&rsquo;&eacute;tudie au Coll&egrave;ge National Bogdan   Petriceicu Hasdeu, dans une classe de math&eacute;matiques-informatique bilingue   anglais. &Agrave; la    diff&eacute;rence de la majorit&eacute; de mes camarades de classe, je ne   sais pas encore quel m&eacute;tier j&rsquo;aimerai exercer, mais j&rsquo;ai assez de temps pour   me d&eacute;cider.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pour me d&eacute;crire en quelques mots, je peux dire que,   d&rsquo;habitude, je suis une fille gaie, qui aime rire tout le temps&nbsp;et   passer le temps avec les amis et la famille. Faire    du sport est une chose que j&rsquo;aime beaucoup, c&rsquo;est pour &ccedil;a   que je&nbsp;pratique le volley &agrave; l&rsquo;&eacute;cole.   Ce n&rsquo;est que le volley que j&rsquo;aime, j&rsquo;aime bien aussi le parachutisme,   peut-&ecirc;tre que c&rsquo;est un trait g&eacute;n&eacute;tique h&eacute;rit&eacute; de mes parents, qui ont mille   sauts. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;esp&egrave;re me r&eacute;aliser en tous les plans&hellip; sentimentaux,   professionnels&nbsp;; en attendant, je ferai tout mon possible pour avoir une   belle vie. </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis   Diana Marina (Marina),</span><span style="color: windowtext; text-transform: none;"> j&rsquo;ai 16 ans et je vis en Buz</span><span style="">\\304\\203</span><span style="color: windowtext; text-transform: none;">u, une   ville assez grande de Roumanie. J&rsquo;ai un fr&egrave;re cadet qui s&rsquo;appelle Petru</span><span style="">\\305\\243</span><span style="color: windowtext; text-transform: none;"> Ciprian   (Pierre). Il a 14 ans, mais il se comporte comme s&rsquo;il &eacute;tait mon fr&egrave;re a&icirc;n&eacute; !   Ma m&egrave;re est m&eacute;decin et mon p&egrave;re est homme d&rsquo;affaires. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Mon lyc&eacute;e est&nbsp;Bogdan Petriceicu Hasdeu, le meilleur   coll&egrave;ge de ma ville et un des meilleurs coll&egrave;ges de Roumanie aussi. Je suis en   10&egrave;me (nous avons une structure diff&eacute;rente pour l&rsquo;&eacute;ducation en Roumanie) et   m&ecirc;me si mon profil est math&eacute;matique informatique bilingue anglais (ce qui   signifie sept heures d&rsquo;anglais par semaine et l&rsquo;histoire des &Eacute;tats-Unis   enseign&eacute;e par un am&eacute;ricain) le fran&ccedil;ais me pla&icirc;t beaucoup. J&rsquo;ai visit&eacute; la France cet &eacute;t&eacute;,   plus exactement Paris et la     prestigieuse Vall&eacute;e de la Loire. Je peux   dire que votre pays m&rsquo;a impressionn&eacute; extraordinairement. Pour moi, la cath&eacute;drale Notre-Dame    de Paris est un v&eacute;ritable joyau architectural et culturel autant   qu&rsquo;une source d&rsquo;inspiration artistique.&nbsp;</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&nbsp;Assez d&rsquo;information palpable ! Cela n&rsquo;est   qu&rsquo;une part minuscule de mon existence, puisqu&rsquo; il y a d&rsquo;autres choses qu&rsquo;on   pourrait dire sur moi. Pour commencer, je suis une antith&egrave;se. Vraiment, parce   qu&rsquo;il y a des tendances &agrave; peu pr&egrave;s contradictoires qui influencent mes   pens&eacute;es et mes id&eacute;es, en transformant ma vie en un m&eacute;lange tr&egrave;s bizarre. Mes   hobbies peuvent parler pout moi : j&rsquo;aime la litt&eacute;rature (lire et &eacute;crire), la   musique (je pr&eacute;f&egrave;re la    musique classique &ndash; Mozart, Beethoven, Bach, Strauss,   George Enescu, mais j&rsquo;&eacute;coute d&rsquo;autres sortes de musique &nbsp;aussi), j&rsquo;ai quelques inclinations pour la   peinture, le patinage&hellip; Voyager me rend presque toujours heureuse. Toutefois,   il y a des activit&eacute;s que je peux faire avec plaisir sans &ecirc;tre mes hobbies   (danser, nager, faire des g&acirc;teaux). </span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">J&rsquo;aime   les Math&eacute;matiques et les Sciences (nous &eacute;tudions la Physique, la Chimie et la   Biologie comme des objets distincts &ndash; je sais qu&rsquo;en France celles-ci sont   comprises dans une seule mati&egrave;re, les Sciences). La cin&eacute;matographie me    semble un domaine complexe qui r&eacute;unit plusieurs   manifestations de l&rsquo;art. C&rsquo;est la raison principale pour   laquelle je suis entr&eacute;e dans ce projet de partenariat.</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">J&rsquo;ai   commenc&eacute; &agrave; &eacute;crire quand j&rsquo;avais 8 ans&hellip; des po&eacute;sies et des petites   compositions. &Agrave; 13 ans j&rsquo;ai publi&eacute; le premier &nbsp;volume de mon roman, &quot;Les myst&egrave;res de   l&rsquo;&eacute;cole Shetland&quot; (&quot;Misterele </span><span style="">\\305\\237</span><span style="color: windowtext; text-transform: none;">colii Shetland&quot; &ndash; en roumain), et   l&rsquo;ann&eacute;e derni&egrave;re j&rsquo;ai lanc&eacute; le second volume. Maintenant, j&rsquo;&eacute;cris un nouveau   roman, quoique je n&rsquo;ai pas beaucoup de temps pour faire &ccedil;a (chaque jour, mes   copains et moi restons &agrave; l&rsquo;&eacute;cole sept ou huit heures et nous avons des   devoirs interminables &agrave; la maison!). La litt&eacute;rature est    essentielle&hellip; ma vie serait impossible sans &eacute;crire ou sans   lire. Ne m&rsquo;entendez pas mal ; je me consid&egrave;re une des plus fortun&eacute;es   personnes du monde. J&rsquo;ai le tout ! Une famille merveilleuse qui m&rsquo;adore et   qui me donne ce que je veux. Mais j&rsquo;ai le sentiment &quot;du temps   perdu&quot;, le sentiment que tout va dans une direction imminente,   implacable et douloureuse&hellip; &nbsp;est   l&rsquo;impression &eacute;pouvantable que l&rsquo;univers s&rsquo;&eacute;coule comme le sable d&rsquo;une   clepsydre et je m&rsquo;affaisse simultan&eacute;ment. Quand j&rsquo;&eacute;cris, je m&rsquo;illusionne   seule en croyant que dans cette mani&egrave;re mon empreinte restera sur la terre. Hm&hellip; l&rsquo;&eacute;criture   n&rsquo;est pas pour moi un simple jeu des chim&egrave;res&hellip; c&rsquo;est un <i>modus vivendi, </i>une<i>   ars poetica, </i>l&rsquo;art po&eacute;tique de l&rsquo;existence&hellip;&nbsp;</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&nbsp;Mes &eacute;crivains pr&eacute;f&eacute;r&eacute;s sont Dostoievski,   Goethe, Hermann Hesse et Mihai Eminescu (le po&egrave;te g&eacute;nial des roumains qui a &eacute;crit   quelque prose par ailleurs). Notre professeur de fran&ccedil;ais a stimul&eacute; mon   int&eacute;r&ecirc;t vers des lectures fran&ccedil;aises aussi. J&rsquo;ai l&rsquo;opinion que des &eacute;crivains   comme Balzac, Gustave Flaubert, Jules Verne, Victor Hugo, Antoine de Saint   &Eacute;xup&eacute;ry ou Jean-Paul Sartre ont eu un r&ocirc;le tr&egrave;s important dans l&rsquo;histoire   spirituelle de l&rsquo;humanit&eacute;.&nbsp;&nbsp;&nbsp; </span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Peut-&ecirc;tre   que je deviendrai un r&eacute;alisateur de films, ou un homme de science, ou une   femme d&rsquo;affaires. Je ne sais pas. Ce dont je suis s&ucirc;re c&rsquo;est seulement que   mon &quot;destin&quot; (je crois que le destin n&rsquo;existe pas mais j&rsquo;utilise ce   mot pour son pouvoir suggestif) est &eacute;ternellement reli&eacute; &agrave; celui de mes   &eacute;critures&hellip; </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut&nbsp;!   Je m&rsquo;appelle Alexandra</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai 16 ans. Je suis &eacute;l&egrave;ve en seconde F, au Coll&egrave;ge   National Bogdan Petriceicu Hasdeu, &agrave;&nbsp;Buz</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">u</span><span style="color: windowtext; text-transform: none;">.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Et maintenant quelques choses sur moi&nbsp;: je suis   tr&egrave;s sociable, j&rsquo;aime conna&icirc;tre de nouvelles personnes. J&rsquo;aime beaucoup lire,   surtout des romans et pi&egrave;ces&nbsp;de   th&eacute;&acirc;tre. J&rsquo;aime&nbsp;la nature, les excursions &agrave; la montagne avec mes   amis&hellip;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Cot&eacute; loisirs, je pr&eacute;f&egrave;re &eacute;couter de la musique, me   promener avec mes amis , mais j&rsquo;aime aussi rester &agrave; la maison et faire   diverses choses avec ma famille.</span></div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="122" width="184" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image073.jpg" v:shapes="_x0000_i1063" /></span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Journ&eacute;e   portes ouvertes, juin 2009.</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Projection   des &laquo;&nbsp;films-essais&nbsp;&raquo;.</span></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome15"></a>Lyc&eacute;e Paul Val&eacute;ry, Paris 12<sup>&egrave;me</sup>(France)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">Philippe    Zill</span><span style="font-size: 10pt; color: rgb(51, 51, 51);">,   professeur de cin&eacute;ma </span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">&nbsp;</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">18_Paul_Valery</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">&laquo;&nbsp;</span><span style="font-size: 10pt; color: blue;">Epreuve capitale&nbsp;&raquo; dur&eacute;e 4&rsquo;87&rsquo;&rsquo; fini   &agrave; 7&rsquo;22&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Suite &agrave; une   dispute avec sa m&egrave;re, un jeune homme sort de chez lui furieux le jour de   l&rsquo;examen du baccalaur&eacute;at. </span></div>\\012<div><b><span style="font-size: 10pt; color: red;">Attention, le film ne commence qu&rsquo;apr&egrave;s un   grand noir, &agrave; 2&rsquo;35&rsquo;&rsquo; </span></b></div>\\012<div>&nbsp;</div>\\012<div><img height="144" width="192" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image075.jpg" v:shapes="_x0000_i1064" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;&hellip; Il claque la porte et pr&eacute;tend   qu&rsquo;il se moque de l&rsquo;examen. Il prend le bus, mais n&rsquo;a pas son pass Navigo. Tout   le bus s&rsquo;en m&ecirc;le. Deuxi&egrave;me dispute, le chauffeur pile. Le jeune homme doit   sortir et croise deux jeunes gens &agrave; qui il demande son chemin. Les deux   jeunes l&rsquo;accompagnent sur la Petite ceinture, puis le laissent seul. Il   cherche son chemin et d&eacute;couvre un lieu tout &agrave; fait insoup&ccedil;onn&eacute; o&ugrave; l&rsquo;on   d&eacute;couvre les traces d'une capitale champ&ecirc;tre, fant&ocirc;me, abandonn&eacute;e. Finalement,   il panique &agrave; l&rsquo;id&eacute;e de rater son examen. En apercevant des individus peu rassurants,   il d&eacute;cide de quitter les lieux. par le premier moyen possible, et s&rsquo;aper&ccedil;oit que,   miraculeusement, il est arriv&eacute; au lyc&eacute;e Paul Val&eacute;ry. Il arrive &agrave;&nbsp;convaincre le gardien de le laiss&eacute; entrer <i>in extremis</i> et peut passer son examen,   l&rsquo;esprit tranquille, lib&eacute;r&eacute; de toute pression.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt; color: blue;">Texte</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt; color: blue;">Journal de bord   collectif</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Journal de bord collectif /   Compte-rendu de la s&eacute;ance du 3 D&eacute;cembre 2008</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Nous   avons d&rsquo;abord commenc&eacute; par faire un tour de table pour rassembler les id&eacute;es   de chacun pour le film&nbsp;:</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Eric</span></b><span style="font-size: 10pt;">&nbsp;:   les quais de seines, voyage au fil de l&rsquo;eau. Rencontre entre un homme riche   qui attend sa femme et un SDF assis l&agrave;. Les deux protagonistes se parlent, se   lient, deviennent presque amis.</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">&reg;</span><span style="font-size: 10pt;"> voir les films de Renoir,   <i>La r&egrave;gle du jeu</i>&nbsp;; <i>Boudu, Sauv&eacute; des eaux</i>.</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Elie&nbsp;:   voir chaque facette de Paris, du m&eacute;tro &agrave; la seine en passant pas les beaux   quartiers puis par Belleville etc.&hellip;.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Ma&iuml;a</span></b><span style="font-size: 10pt;">&nbsp;:   partie de ballon, puis perte du ballon apr&egrave;s un shoot malencontreux. Puis   recherche du ballon &agrave; travers la ville.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Laure</span></b><span style="font-size: 10pt;">&nbsp;:   coul&eacute;e verte.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Youri</span></b><span style="font-size: 10pt;">&nbsp;:   dispute entre un homme et une femme, l&rsquo;homme tente de la rattraper et tombe   dans une partie de la ville qu&rsquo;il ne soup&ccedil;onnait pas. Il est &eacute;tonn&eacute; puis   retour a la r&eacute;alit&eacute;.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Alexandre</span></b><span style="font-size: 10pt;">&nbsp;:   un homme cherche une femme apr&egrave;s une dispute, il la retrouve mais elle ne   veut plus de lui&hellip;D&eacute;prim&eacute; il rencontre alors une personne qui est oppos&eacute;e a   lui comme un artiste fou (opposition de deux personnages cf Eric )</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Guillaume&nbsp;:   deux personnes marchent dans la rue l&rsquo;un fait d&eacute;couvrir a l&rsquo;autre un lieu   secret puis dispara&icirc;t. Retrouv&eacute; seul le deuxi&egrave;me personnage se perd et d&eacute;couvre   des endroits &eacute;tranges (catacombes&nbsp;?)</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Jeu   d&rsquo;opposition entre le mouvement, le bruit, le gens de la ville ext&eacute;rieure et   la ville souterraine silencieuse et vide. (petite ceinture&nbsp;?) Ville du   haut </span><span style="font-size: 10pt;">&sup1;</span><span style="font-size: 10pt;">   ville du bas.</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">&reg;</span><span style="font-size: 10pt;"> voir le film d&rsquo;Antonioni, <i>L&rsquo;Avventura</i>.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Pierre</span></b><span style="font-size: 10pt;">&nbsp;:   Barbes, rue de la chapelle, m&eacute;tro a&eacute;rien, terrain de basket, lieux sales,   tristes&hellip; Comparaison avec un autre quartier.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Timoth&eacute;e</span></b><span style="font-size: 10pt;">&nbsp;:   Petite ceinture, maison abandonn&eacute;e lieux de la digression&nbsp;?</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">D&eacute;couverte   de la maison.</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">&reg;</span><span style="font-size: 10pt;"> Voir film de Richet, <i>Etat des lieux</i>.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Victorine</span></b><span style="font-size: 10pt;">&nbsp;:   Baladeur passant de mains en mains, chaque musique, chaque quartier.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Samuel</span></b><span style="font-size: 10pt;">&nbsp;:   Un homme rate une s&eacute;ance au MK2 Biblioth&egrave;que, il se perd dans les nouveaux   quartiers atroces qu&rsquo;il ne connaissait pas et est en quelque sorte absorb&eacute;   par cette ville. Il avance et se retrouve finalement sur les quais ou il   retrouve l&rsquo;humanit&eacute; des couleurs de la seine et va mieux.</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">&reg;</span><span style="font-size: 10pt;"> Voir le film d&rsquo;Antonioni, <i>La   Notte</i>. </span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Tim</span></b><span style="font-size: 10pt;"> :   Un adolescent qui doit aller acheter du pain t&ocirc;t le matin, il rencontre une   personne qui l&rsquo;intrigue et d&eacute;cide de la suivre. Cet homme se   dirige de&nbsp;magasins en magasins ( Galeries Lafayette&nbsp;?) l&rsquo;adolescent   le suit.</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">L&rsquo;homme   se r&eacute;v&egrave;le&nbsp;finalement &ecirc;tre une femme .</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Philippe &nbsp;Zill</span></b><span style="font-size: 10pt;">&nbsp;:   une personne rencontre une autre personne et la suit &agrave; travers Paris car il   est s&eacute;duit.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Timoth&eacute;e</span></b><span style="font-size: 10pt;">&nbsp;:   Une personne se rendant a un RDV passe devant la cin&eacute;math&egrave;que ou un   r&eacute;alisateur est en train de se faire interviewer. En arri&egrave;re plan des images   de son film sont projet&eacute;es on y voit Paris. Film dans le film.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Blandine</span></b><span style="font-size: 10pt;">&nbsp;:   Petite ceinture, une fille passe par plusieurs endroits anim&eacute;s et rencontre   des musiciens elle s&rsquo;installe avec eux.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Siham</span></b><span style="font-size: 10pt;">&nbsp;:   Une personne lisant un journal assis sur un banc, se crispe &agrave; la lecture d&rsquo;un   article. Il repense &agrave; plusieurs endroits de Paris de sa vie d&rsquo;avant en temps   que juif pendant la seconde guerre mondiale sous l&rsquo;occupation nazis. Il   revient ensuite &agrave; la r&eacute;alit&eacute;&nbsp;.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Louise</span></b><span style="font-size: 10pt;">&nbsp;:   Un homme a un entretient d&rsquo;embauche ou il est refus&eacute;. Pour tenter d&rsquo;oublier   ses ennuis il s&rsquo;&eacute;chappe dans un endroit qu&rsquo;il ne conna&icirc;t pas (coul&eacute;e   verte&nbsp;?)</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Igor</span></b><span style="font-size: 10pt;">&nbsp;:   Un groupe de jeunes ne savant pas ou passer leur soir&eacute;e du samedi soir. Ils   ont plusieurs possibilit&eacute;s. On film chacune d&rsquo;entres elles.</span></div>\\012<div align="left" style="margin-top: 0cm;">&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Propositions retenues&nbsp;: </span></b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Proposition   1</span></b><span style="color: windowtext; text-transform: none;">&nbsp;:</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Deux amis se retrouvent puis se perdent&nbsp;dans la petite ceinture.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">L&rsquo;un dispara&icirc;t et laisse l&rsquo;autre seul.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le premier manque son examen car il se perd.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Guillaume, Pierre, Timoth&eacute;e, Blandine, Samuel,   Alexandre, Antonin, Louis, Ga&eacute;tan, Timoth&eacute;e.</span></div>\\012<div>&nbsp;</div>\\012<div style="margin: 0cm 0cm 0.0001pt;"><b><font size="6"><span style="font-size: 10pt; color: windowtext; text-transform: none;">Proposition 2&nbsp;:</span></font></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Un homme passe un entretient d&rsquo;embauche&nbsp;auquel il   &eacute;choue.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Il sort et rencontre un adolescent. Il veut changer   oublier le r&eacute;el, son point de vue change.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Eric, Elie,   Tim, Laure, Igor, Ma&iuml;a</span><span style="color: windowtext; text-transform: none;">, </span><span style="color: windowtext; text-transform: none;">Louise, </span><span style="color: windowtext; text-transform: none;">Siham, Youri.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Questions</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">&middot;</span><span style="color: windowtext; text-transform: none;"> Les   personnages seront-ils dans une dure r&eacute;alit&eacute; ou bien la digression est elle   vecteur de cette r&eacute;alit&eacute;&nbsp;?</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Tristesse</span><span style="color: windowtext; text-transform: none;">&reg;</span><span style="color: windowtext; text-transform: none;">digression</span><span style="color: windowtext; text-transform: none;">&reg;</span><span style="color: windowtext; text-transform: none;">joie</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Joie</span><span style="color: windowtext; text-transform: none;">&reg;</span><span style="color: windowtext; text-transform: none;">digression</span><span style="color: windowtext; text-transform: none;">&reg;</span><span style="color: windowtext; text-transform: none;">tristesse.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&middot;</span><span style="color: windowtext; text-transform: none;"> La digression sert-elle &agrave;   s&rsquo;&eacute;chapper de la    r&eacute;alit&eacute; ou bien justement &agrave; la trouver&nbsp;?</span></div>\\012<div align="left" style="margin-top: 0cm;"><b>&nbsp;</b></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt; color: blue;">Texte</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt; color: blue;">Journal de bord </span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Journal de bord </span></div>\\012<div align="left" style="margin-top: 0cm;"><img height="136" width="180" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image077.jpg" v:shapes="_x0000_i1065" /></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Un   film &eacute;crit et r&eacute;alis&eacute; par la classe d&rsquo;option cin&eacute;ma audiovisuel facultative   de 1&egrave;re du Lyc&eacute;e Paul Val&eacute;ry&nbsp;:</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Timoth&eacute;e, 1&egrave;re S1</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Alexandre,</span><span style="color: windowtext; text-transform: none;"> 1&egrave;re ES1</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Timoth&eacute;e, 1&egrave;re S2</span></div>\\012<div style="margin: 0cm 0cm 0.0001pt;"><b><font size="4"><span style="font-size: 10pt; font-weight: normal;">Ga&eacute;tan,   1&egrave;re ES1</span></font></b></div>\\012<div style="margin: 0cm 0cm 0.0001pt;"><b><font size="4"><span style="font-size: 10pt; font-weight: normal;">Guillaume,   1&egrave;re STG</span></font></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Louis, 1&egrave;re ES1</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pierre,&nbsp;1&egrave;re S2</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Vlad</span><span style="color: windowtext; text-transform: none;">, 1&egrave;re L</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Table des mati&egrave;res</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le   calendrier du film </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le sujet   propos&eacute;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le synopsis </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Fiches personnages </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le s&eacute;quencier (continuit&eacute;   non-dialogu&eacute;e) </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le sc&eacute;nario </span></div>\\012<div><span style="color: windowtext; text-transform: none;">La note d&rsquo;intention </span></div>\\012<div><span style="color: windowtext; text-transform: none;">La r&eacute;partition aux    diff&eacute;rents</span><span style="color: windowtext; text-transform: none;"> postes techniques </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les rep&eacute;rages </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le d&eacute;coupage technique </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le plan de tournage </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le tournage </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le d&eacute;rushage </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le montage </span></div>\\012<div><span style="color: windowtext; text-transform: none;">La bande-son et le mixage </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le g&eacute;n&eacute;rique </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Le calendrier</span></div>\\012<div><b><u><span style="color: windowtext; text-transform: none;">S&eacute;ance du 21/01/2009</span></u></b><span style="color: windowtext; text-transform: none;"> (3h)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- <b>1&egrave;re id&eacute;e du synopsis</b> / </span><span style="color: red; text-transform: none;">manque</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Une personne du groupe est charg&eacute;e   d&rsquo;envoyer la version    &agrave; tout le monde.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- <b>Sc&eacute;nario</b> Nous avons cherch&eacute;   une id&eacute;e de sc&eacute;nario &agrave; partir du synopsis que nous avons imagin&eacute;. Puis nous   r&eacute;fl&eacute;chissons &agrave; un lieu de tournage (la petit ceinture en   l&rsquo;occurrence) et &agrave; &eacute;laborer des sc&egrave;nes et des situations.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La petite ceinture est</span><span style="color: windowtext; text-transform: none;"> un bon lieu de tournage car il y a peu de bruit.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pour la prochaine s&eacute;ance</span></b><span style="color: windowtext; text-transform: none;">&nbsp;Tourner des images de la petite ceinture,   avec une description des lieux (faire un essai avec les figurants, puis nous   regarderons les rushs que nous avons tourn&eacute;s.</span></div>\\012<div>&nbsp;</div>\\012<div><b><u><span style="color: windowtext; text-transform: none;">S&eacute;ance du 28/01/2009</span></u></b><span style="color: windowtext; text-transform: none;"> (3h)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Arriv&eacute;e d&rsquo;un nouveau membre de l&rsquo;&eacute;quipe&nbsp;: Vlad RATOYAN (1&egrave;re L2)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">En d&eacute;but de s&eacute;ance nous faisons un   r&eacute;capitulatif du sc&eacute;nario en apportant quelques modifications. </span><span style="color: red; text-transform: none;">manque</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Nous avons cherch&eacute; &agrave;   am&eacute;liorer la sc&egrave;ne du    bus&nbsp;: </span></b><span style="color: windowtext; text-transform: none;">Le protagoniste   descend &agrave; porte de Vincennes apr&egrave;s une altercation avec le conducteur du bus   (le conducteur contraint le protagoniste &agrave; descendre car les autres passagers   trouvent injuste qu&rsquo;il l&rsquo;ait laiss&eacute; entr&eacute; malgr&eacute; qu&rsquo;il ait oubli&eacute; son titre   de transport, m&ecirc;me s&rsquo;il passe son bac).</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Nous avons &eacute;galement <b>modifi&eacute; la sc&egrave;ne<span style="font-weight: normal;">    de la</span><span style="font-weight: normal;"> rencontre   entre les deux connaissances du protagoniste et celui-ci. Et du coup la fa&ccedil;on dont le il   est amen&eacute; &agrave; se rendre sur la petite ceinture.</span></b></span></div>\\012<div>&nbsp;</div>\\012<div><b><u><span style="color: windowtext; text-transform: none;">S&eacute;ance du 04/02/2009</span></u></b><span style="color: windowtext; text-transform: none;"> (3h)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- La quasi-totalit&eacute; de cette   s&eacute;ance a servi au groupe de r&eacute;aliser la mise au point du </span><b><span style="color: windowtext; text-transform: none;">s&eacute;quencier</span></b><span style="color: windowtext; text-transform: none;"> (12 s&eacute;quences). </span></div>\\012<div><span style="color: windowtext; text-transform: none;">- Une petite   partie du groupe s&rsquo;est occup&eacute; de r&eacute;dig&eacute; sur ordinateur le sujet propos&eacute;,   ainsi que les donn&eacute;es personnelles de chaque membre du groupe et de la r&eacute;partition de chacun   aux diff&eacute;rents postes techniques.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- Nous avons   &eacute;galement commenc&eacute; en fin de s&eacute;ance </span><b><span style="color: windowtext; text-transform: none;">le sc&eacute;nario de la 1&egrave;re s&eacute;quence<span style="font-weight: normal;">.</span></span></b></div>\\012<div><span style="color: red; text-transform: none;">Manque 1<sup>er</sup>   sc&eacute;nario</span></div>\\012<div>&nbsp;</div>\\012<div><b><u><span style="color: windowtext; text-transform: none;">S&eacute;ance du 11/02/2009</span></u></b><span style="color: windowtext; text-transform: none;"> (1h30)</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">- Visionnage des vid&eacute;os de rep&eacute;rage</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Discussion   autour d&rsquo;une table sur les choses importantes &agrave; mettre en &eacute;vidence dans le   sc&eacute;nario et sur le tournage. </span><span style="color: red; text-transform: none;">Manque texte</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pour la prochaine s&eacute;ance</span></b><span style="color: windowtext; text-transform: none;">&nbsp;: </span><span style="color: windowtext; text-transform: none;">Les trois acteurs devront &eacute;crire un paragraphe sur la vie et la personnalit&eacute;   du personnage qu&rsquo;ils joueront.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pour les autres membres du groupe,   chacun devra se charger d&rsquo;&eacute;crire le sc&eacute;nario de la s&eacute;quence qui lui   sera attribu&eacute;.</span></div>\\012<div>&nbsp;</div>\\012<div><b><u><span style="color: windowtext; text-transform: none;">S&eacute;ance du 04/03/2009</span></u></b><span style="color: windowtext; text-transform: none;"> (3h)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- R&eacute;daction   compl&egrave;te de tout le sc&eacute;nario.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- Derni&egrave;res   mises au point sur les fiches personnages.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Le sujet propos&eacute;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Au d&eacute;part, deux groupes ont &eacute;t&eacute; form&eacute;s,   il nous a &eacute;t&eacute; impos&eacute; deux th&eacute;matiques ; la premi&egrave;re traitait de   la digression    dont le protagoniste devait se d&eacute;tourner de son objectif,   s&rsquo;effacer et laisser place au d&eacute;cor.&nbsp;La seconde th&eacute;matique &eacute;tait   celle de la ville. Il fallait   filmer la ville d&rsquo;un   point de vue diff&eacute;rent de l&rsquo;image habituelle de Paris. Nous nous sommes alors   tourn&eacute; vers l&rsquo;id&eacute;e d&rsquo;une action sur la petite ceinture. Cette   voie ferr&eacute;e donnant un point de vue sur l&rsquo;arri&egrave;re des immeubles haussmanniens,   tr&egrave;s beaux sur la    devanture et n&eacute;glig&eacute;s sur la fa&ccedil;ade arri&egrave;re,   permet une opposition flagrante avec le d&eacute;cor du d&eacute;but du film. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pour nous faciliter la t&acirc;che on nous a   aussi donn&eacute; une trame narrative &agrave; suivre&nbsp;: notre personnage principal se   d&eacute;tourne de son objectif et laisse alors place &agrave; une digression qu&rsquo;il va   suivre un temps, avant de la laisser de c&ocirc;t&eacute; et de retourner &agrave; son objectif   initial. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pour nous, cet objectif initial &eacute;tait   celui du passage du BAC. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Une grande partie des id&eacute;es a &eacute;t&eacute;   trouv&eacute;e avec l&rsquo;aide des rep&eacute;rages. Ils nous ont permis de d&eacute;terminer les   commencements et fin de la digression. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">En revanche, nous avons eu quelques   probl&egrave;mes pour trouver l&rsquo;actrice pr&eacute;pos&eacute;e au r&ocirc;le de la m&egrave;re du film. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ici la digression sert &agrave;   r&eacute;v&eacute;ler au h&eacute;ros, sa volont&eacute; de passer le bac.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La    structure du r&eacute;cit</span><span style="color: windowtext; text-transform: none;"> sera   donc CONFLIT/DIGRESSION/RESOLUTION.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="146" width="193" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image079.jpg" v:shapes="_x0000_i1066" /></span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Synopsis</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Suite &agrave; une dispute avec sa m&egrave;re, un jeune homme sort de   chez lui furieux le jour de l&rsquo;examen du BAC. Il claque la porte et pr&eacute;tend   qu&rsquo;il se fiche du BAC. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Il prend le bus, mais n&rsquo;a pas son &laquo;&nbsp;PASS   NAVIGO&nbsp;&raquo; tout le bus s&rsquo;en m&ecirc;le. Deuxi&egrave;me dispute, le chauffeur pile, il   doit sortir et croise deux gar&ccedil;ons &agrave; qui il demande son chemin. Les deux   l&rsquo;accompagnent sur la    P.C. puis le laissent seul. Il cherche son chemin et   d&eacute;couvre un lieu tout &agrave; fait insoup&ccedil;onn&eacute; o&ugrave; l&rsquo;on d&eacute;couvre les traces d'une   capitale champ&ecirc;tre, fant&ocirc;me, abandonn&eacute;e. Et il panique &agrave; l&rsquo;id&eacute;e de rater son   BAC.</span></div>\\012<div style="margin: 0cm 0cm 0.0001pt;"><b><font size="6"><span style="font-size: 10pt; color: windowtext; text-transform: none; font-weight: normal;">En   apercevant des individus peu rassurants, il d&eacute;cide de quitter la P.C. par le premier   moyen possible, et s&rsquo;aper&ccedil;oit miraculeusement qu&rsquo;il est arriv&eacute; au lyc&eacute;e Paul   Val&eacute;ry. Il arrive &agrave;&nbsp;convaincre le   gardien de le laisser passer in extremis et peut passer son examen, l&rsquo;esprit   tranquille, lib&eacute;r&eacute; de toute pression.</span></font></b></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="139" width="104" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image081.jpg" v:shapes="_x0000_i1067" />&nbsp;<img height="139" width="104" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image083.jpg" v:shapes="_x0000_i1068" /></span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Fiches   personnages</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis&nbsp;:</span></b><span style="color: windowtext; text-transform: none;"> (par Louis)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Louis est un jeune gar&ccedil;on &acirc;g&eacute; de 16   ans, il vit seul avec sa m&egrave;re suite au d&eacute;part de son p&egrave;re qui n&rsquo;est jamais   revenu. D&eacute;part qui marque aussi la relation tumultueuse    avec sa m&egrave;re. Il aime le sport, et passer du temps avec ses   amis, il n&rsquo;est pas tr&egrave;s travailleur mais reste motiv&eacute; &agrave; l&rsquo;id&eacute;e d&rsquo;avoir son   bac. Il conna&icirc;t assez peu Pierre et Tim mais garde un souvenir plut&ocirc;t   sympathique des deux personnages qu&rsquo;il n&rsquo;a pas revu depuis longtemps. Il sort   assez souvent d&eacute;laissant un peu son travail. Son humeur est plut&ocirc;t joviale   mais reste quelque peu renferm&eacute; sur lui m&ecirc;me.</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre&nbsp;: </span></b><span style="color: windowtext; text-transform: none;">(par Pierre)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pierre est un jeune gar&ccedil;on &acirc;g&eacute;   d&rsquo;environ 16 ans, c&rsquo;est un adolescent au temp&eacute;rament assez joyeux, tout en   restant bien tremp&eacute;. Il a grandi dans les quartiers populaires parisiens aux   cot&eacute;s de ses amis de quartiers (y compris Tim). Apr&egrave;s une enfance   tumultueuse, et un &eacute;chec scolaire cuisant, il s&rsquo;immisce dans les trafiques de   quartiers ainsi que dans les d&eacute;lits mineurs afin de subvenir aux besoins financiers   de son m&eacute;nage. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Suite &agrave; une altercation muscl&eacute; face aux forces de   l&rsquo;ordre, il &eacute;vite de peut la prison et d&eacute;cide alors de quitt&eacute; ce milieu dans   lequel il commence &agrave; ressentir un mal-&ecirc;tre. Il trouve alors un petit boulot   tranquille, et occupe son temps libre &agrave; sortir avec son principal ami Tim.   Leur passe temps favori, bien que ill&eacute;gal, reste le graffiti&nbsp;; et leur   terrain de jeu pr&eacute;f&eacute;r&eacute;&nbsp;: Les chemins de fers d&eacute;saffect&eacute;s de &laquo;&nbsp;La Petite Ceinture&nbsp;&raquo;   (o&ugrave; il guidera, avec Louis, <i>voir synopsis</i>).</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim :</span></b><span style="color: windowtext; text-transform: none;"> (par Timoth&eacute;e)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">C&rsquo;est un jeune gar&ccedil;on, habitu&eacute; &agrave; sortir   dans la rue, il va souvent sur la petite ceinture de   Paris pour y faire du graffiti et y vagabonder avec des amis.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Il ne conna&icirc;t pas tr&egrave;s bien Louis (le   personnage principal) et cela faisait longtemps qu&rsquo;il ne l&rsquo;avait pas vue,   avant de le croiser dans la rue (voir synopsis).Il est d&rsquo;humeur plut&ocirc;t jovial   et plaisantin, tout comme son amis Pierre avec qui il passe le plus claire de   son temps &agrave; trainer dans les rues et &agrave; la petite ceinture.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Le s&eacute;quencier</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">1&egrave;re s&eacute;quence&nbsp;</span></b><span style="color: windowtext; text-transform: none;">: Louis,   le protagoniste du r&eacute;cit, est r&eacute;veill&eacute; par sa m&egrave;re vers 13h00, alors qu&rsquo;il a   pass&eacute; sa nuit &agrave; r&eacute;viser pour son BAC qu&rsquo;il doit passer le jour m&ecirc;me.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">2&egrave;me   s&eacute;quence</span></b><span style="color: windowtext; text-transform: none;">&nbsp;: Louis arrive dans la cuisine en dilettante,   il commence &agrave; petit d&eacute;jeuner. Sa m&egrave;re est assise pr&egrave;s de lui, et ne cesse de   le scruter en observant ces faits et gestes cherchant le moindre d&eacute;tail pour   le critiquer. Pouss&eacute; &agrave; bout, LOUIS sort de la cuisine en claquant   la porte, prend son sac et sort de chez lui pour aller passer son &eacute;preuve.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">3&egrave;me   s&eacute;quence&nbsp;</span></b><span style="color: windowtext; text-transform: none;">: Louis se dirige vers une boulangerie pour s&rsquo;acheter un   petit quelque chose &agrave; manger puisqu&rsquo;il n&rsquo;a pas eu le temps de petit d&eacute;jeuner   chez lui. Il se rend compte qu&rsquo;il n&rsquo;a pas assez d&rsquo;argent et demande &agrave; la boulang&egrave;re s&rsquo;il   peut la payer avec ce   qu&rsquo;il a, mais celle-ci refuse. Il se dirige alors vers l&rsquo;arr&ecirc;t du bus qu&rsquo;il   doit prendre.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">4&egrave;me   s&eacute;quence&nbsp;</span></b><span style="color: windowtext; text-transform: none;">: Il arrive sur la place Daumesnil,   et s&rsquo;aper&ccedil;oit que celle-ci est ferm&eacute;e &agrave; la circulation. Il    demande &agrave; un viel homme post&eacute; &agrave; l&rsquo;arr&ecirc;t de bus qui lui   indique qu&rsquo;il n&rsquo;y a pas de bus. Louis d&eacute;cide donc de partir au lieu d&rsquo;examen   &agrave; pied.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">5&egrave;me   s&eacute;quence</span></b><span style="color: windowtext; text-transform: none;">&nbsp;: En marchant dans les rues du XX&egrave;me   arrondissement, il croise deux de ses anciens camarades de classe, Pierre et Tim,   assis justement devant leur ancien coll&egrave;ge. Les trois gar&ccedil;ons discutent   bri&egrave;vement, et Louis explique au deux individus qu&rsquo;il va passer son baccalaur&eacute;at   au lyc&eacute;e Paul Val&eacute;ry, mais qu&rsquo;il ne conna&icirc;t pas la route. Les deux   comp&egrave;res lui propose de passer par un raccourci, qui se trouve &ecirc;tre le petite   ceinture. Louis accepte mais reste sur ses gardes.</span></div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="100" width="132" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image085.jpg" v:shapes="_x0000_i1069" />&nbsp;&nbsp;&nbsp; <img height="98" width="131" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image087.jpg" v:shapes="_x0000_i1070" /></span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">6&egrave;me   s&eacute;quence&nbsp;</span></b><span style="color: windowtext; text-transform: none;">: Les trois jeunes hommes prennent alors une petite rue,   qui les m&egrave;nent face &agrave; un mur, Louis est h&eacute;sitant &agrave; l&rsquo;id&eacute;e de p&eacute;n&eacute;trer sur les   rails, de braver l&rsquo;interdit. Finalement il c&egrave;de aux propositions des deux   autres et&nbsp;escalade le mur qui m&egrave;ne aux   rails. </span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">7&egrave;me   s&eacute;quence&nbsp;:</span></b><span style="color: windowtext; text-transform: none;"> Louis, Tim et Pierre commencent alors &agrave; marcher sur les   rails, les deux comp&egrave;res faisant les imb&eacute;ciles. Louis est constern&eacute; et   demande aux deux autres&nbsp;de se d&eacute;p&ecirc;cher   un peu.</span></div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="117" width="156" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image089.jpg" v:shapes="_x0000_i1071" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <img height="124" width="156" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image091.jpg" v:shapes="_x0000_i1072" /></span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">8&egrave;me   s&eacute;quence&nbsp;:</span></b><span style="color: windowtext; text-transform: none;"> Pierre et Tim veulent montrer &agrave; Louis leurs graffs   situ&eacute;s sur un mur en hauteur, mais Louis ne veut pas. Pierre et Tim grimpent sur le mur, pour montrer &agrave; Louis   leurs graffitis, cependant celui-ci ne monte pas, il&nbsp;regarde les graffitis d&rsquo;en bas.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Apr&egrave;s ce court arr&ecirc;t, les   trois comp&egrave;res repartent en chemin.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">9&egrave;me   s&eacute;quence&nbsp;</span></b><span style="color: windowtext; text-transform: none;">: En montant sur une &eacute;chelle, Tim aper&ccedil;oit un homme avec   qui, Pierre et Louis devaient s&rsquo;entretenir. Alors ils abandonnent Louis sur la voie d&eacute;serte en   lui assurant qu&rsquo;il all&eacute; revenir. Louis est perdu, il ne sait plus o&ugrave; aller.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="109" width="144" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image092.jpg" v:shapes="_x0000_i1073" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <img height="109" width="144" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image094.jpg" v:shapes="_x0000_i1074" /></span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">10&egrave;me   s&eacute;quence</span></b><span style="color: windowtext; text-transform: none;">&nbsp;: Au bout de dix minutes, Louis perd patience et   prend l&rsquo;initiative de continuer la route seul. Longue   s&eacute;ance de vagabondage de Louis sur la PC. Il &egrave;re, marchant sur les rails et observant   le d&eacute;cor autour de lui&nbsp;; d&eacute;couvrant des lieus tout &agrave; fait insoup&ccedil;onn&eacute; o&ugrave;   l&rsquo;on d&eacute;couvre les traces d'une capitale champ&ecirc;tre, fant&ocirc;me, abandonn&eacute;e.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">11&egrave;me   s&eacute;quence&nbsp;: </span></b><span style="color: windowtext; text-transform: none;">Sur le chemin, il croise un &laquo;&nbsp;fou&nbsp;&raquo; mais ne   r&eacute;pond pas &agrave; ses interpellations. Il continu de marcher.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">12&egrave;me   s&eacute;quence</span></b><span style="color: windowtext; text-transform: none;">&nbsp;: Au bout de plusieurs centaines de m&egrave;tres, Louis   aper&ccedil;oit une sortie et se pr&eacute;cipite sur celle-ci. La sortie l&rsquo;am&egrave;ne juste   devant son lyc&eacute;e.</span></div>\\012<div><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">13&egrave;me   s&eacute;quence&nbsp;</span></b><span style="color: windowtext; text-transform: none;">: Louis arrive en courant devant son lyc&eacute;e et le gardien   le laisse rentrer in extremis&nbsp;; heureux d&rsquo;avoir retrouv&eacute; son chemin et   de pouvoir passer son &eacute;preuve. </span></div>\\012<div><b>&nbsp;</b></div>\\012<div><span style="color: windowtext; text-transform: none;">Le sc&eacute;nario</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 1</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">La m&egrave;re    de Louis</span></i><i><span style="color: windowtext; text-transform: none;"> est   dans la cuisine en    train de se manucurer et Louis arrive pour prendre son petit-d&eacute;jeuner.</span></i></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">La m&egrave;re</span></b><span style="color: windowtext; text-transform: none;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></div>\\012<div><span style="color: windowtext; text-transform: none;">C&rsquo;est &agrave; cette heure l&agrave; que tu te l&egrave;ves&nbsp;?</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Et tu ne finis pas&nbsp;tes   c&eacute;r&eacute;ales ? Tu crois que c&rsquo;est gratuit ? Et tu aurais pu sortir la poubelle hier soir&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">(<i>Soupir d&rsquo;&eacute;nervement</i>)</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">La m&egrave;re</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Cause toujours tu m&rsquo;int&eacute;resses&hellip;</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">C&rsquo;est bon&nbsp;! Je passe mon bac   aujourd&rsquo;hui&nbsp;! Tu peux me l&acirc;cher deux secondes&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">La m&egrave;re</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Oh il a bon dos le BAC. Le BAC ceci, le   BAC cela, avec toi il y a toujours une bonne excuse.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">De toute fa&ccedil;on tu ne l&rsquo;auras pas ton   BAC. C&rsquo;est de p&egrave;re en fils et puis l&rsquo;ann&eacute;e prochaine je ne garde pas une   larve &agrave; la maison&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">De toute fa&ccedil;on je m&rsquo;en fiche du   BAC&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Louis quitte son domicile en claquant la porte&nbsp;!</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 2</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">LOUIS   s&rsquo;approche du bus tout en cherchant son pass dans sa poche. Arriv&eacute; au niveau   du chauffeur, il se rend compte qu&rsquo;il l&rsquo;a oubli&eacute;.</span></i></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ah merde&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Le   chauffeur</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Bonjour jeune homme, vous avez votre titre de   transport&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Bah en fait, j&rsquo;ai oubli&eacute; ma carte et comme je passe mon   bac aujourd&rsquo;hui, je me demandais si vous pouviez me laisser passer.</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Le   chauffeur</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">C&rsquo;est bon pour cette fois.</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Grognement   des voyageurs. Louis marche vers l&rsquo;arri&egrave;re du bus. Sans le vouloir, il marche   sur le pied d&rsquo;une jeune femme. Celle-ci s&rsquo;&eacute;nerve et commence alors&nbsp;une engueulade entre LOUIS et la FEMME.</span></i></div>\\012<div><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">La femme   </span></b><span style="color: windowtext; text-transform: none;">(<i>&eacute;nerv&eacute;e</i>)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Vous vous croyez tout permis&nbsp;! D&eacute;j&agrave; vous fraudez et   ensuite vous m&rsquo;agressez&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ouais c&rsquo;est bon&nbsp;! Je n&rsquo;ai pas fais expr&egrave;s   pardon&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Un HOMME   s&rsquo;en m&ecirc;le alors soutenu par les commentaires des autres voyageurs.</span></i></div>\\012<div><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">L&rsquo;homme</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Les jeunes de nos jours&nbsp;! Ils pensent que parce   qu&rsquo;ils sont jeunes ils ont tous les droits&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;ai pas fait expr&egrave;s, c&rsquo;est bon&nbsp;! C&rsquo;est pas la peine de s&rsquo;&eacute;nerver   pour si peu&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">L&rsquo;homme</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Et vulgaire en plus&nbsp;! Ah bah bravo&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">N&rsquo;importe quoi&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Le   CHAUFFEUR du bus se gare sur le bas-c&ocirc;t&eacute; et sort de sa cabine.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">LE   CHAUFFEUR&nbsp;: </span></b><span style="color: windowtext; text-transform: none;">(<i>&agrave; bout</i>)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Bon &ccedil;a suffit maintenant&nbsp;!   J&rsquo;ai &eacute;t&eacute; suffisamment patient pour vous&nbsp;laisser monter, et vous emb&ecirc;ter   tout le monde&nbsp;! Vous descendez et puis c&rsquo;est tout.</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Louis s&rsquo;ex&eacute;cute tout en grognant dans son coin.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 3</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Louis descend du bus &agrave; un endroit qu&rsquo;il   ne conna&icirc;t pas. Il est d&eacute;pit&eacute; et ne sait pas dans quelle direction aller. Il   se d&eacute;cide &agrave; suivre la    direction du bus, et croise des anciens copains du coll&egrave;ge,   qu&rsquo;il avait perdu de vue.</span></i></div>\\012<div><i><span style="color: windowtext; text-transform: none;">TIM et PIERRE, assis sur un banc   l&rsquo;aper&ccedil;oivent.</span></i></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Hey&nbsp;!   Regarde c&rsquo;est pas LOUIS l&agrave;-bas qui arrive&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">LOUIS   lequel&nbsp;? Du coll&egrave;ge&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ouais&nbsp;!   Viens on va le voir.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Hey&nbsp;!   LOUIS&nbsp;! &Ccedil;a va&nbsp;? Tu te rappels de nous&nbsp;!? Au coll&egrave;ge et   tout&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ah, euh ouais   ouais &hellip; &ccedil;a va et vous&nbsp;? Ca fait longtemps&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;avoue&nbsp;!   Ca fait grave longtemps&nbsp;! Bien ou quoi&nbsp;? Tu fais quoi ici&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Bah l&agrave;, j&rsquo;vais passer le bac   (rire)&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">T&rsquo;es   s&eacute;rieux&nbsp;? L&agrave;,    maintenant&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Oui mais   j&rsquo;ai eu des probl&egrave;mes dans le bus, le chauffeur il m&rsquo;a oblig&eacute; &agrave;   descendre&nbsp;! J&rsquo;suis un peux perdu l&agrave;.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Tu dois le   passer dans quel lyc&eacute;e&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Paul   Val&eacute;ry&nbsp;! Vous connaissez&nbsp;? Vous pouvez pas m&rsquo;aider&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Bien s&ucirc;r   qu&rsquo;on conna&icirc;t&nbsp;! On y &eacute;t&eacute; en seconde, avant d&rsquo;&ecirc;tre r&eacute;orient&eacute; en BEP (<i>rire</i>).   Si tu veux on t&rsquo;y am&egrave;ne. On conna&icirc;t un petit raccourci sympa (<i>sourire</i>).</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ouais   j&rsquo;avoue&nbsp;! Un chemin direct d&rsquo;ici &agrave; PV&nbsp;! Si tu veux on t&rsquo;emm&egrave;ne   jusqu'&agrave; l&agrave;-bas&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ouais je   veux bien, mais j&rsquo;esp&egrave;re que vous me faites pas un plan foireux&nbsp;! Jouez   pas les gamins (<i>sourire</i>).</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Louis suit alors Tim et Pierre.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 4</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Louis et ses deux amis, Pierre et Tim, sont devant la petite ceinture,   soudain Louis h&eacute;site&nbsp;&agrave; p&eacute;n&eacute;trer sur   les rails, car il faut escalader une grille.</span></i></div>\\012<div style="text-indent: 16.35pt;"><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b><i><span style="color: windowtext; text-transform: none;">(vex&eacute;)</span></i></div>\\012<div><span style="color: windowtext; text-transform: none;">Allez viens&nbsp;! Je t&rsquo;assure c&rsquo;est des rails   abandonn&eacute;es,&nbsp;y a rien &agrave; craindre.</span></div>\\012<div><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b><span style="color: windowtext; text-transform: none;"> (<i>h&eacute;sitant</i>)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">On sait jamais&nbsp;! Imagine que quelqu'un nous voit.</span></div>\\012<div style="text-indent: 16.35pt;"><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Mais si allez viens on te dit qu&rsquo;il n&rsquo;y a jamais   personne qui vient dans cet endroit.</span></div>\\012<div><i>&nbsp;</i></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Louis   c&egrave;de aux avances de ses deux amis et les 3 personnages se mettent &agrave; escalader   le mur.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 5</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">TIM et PIERRE se dirigent vers une voiture, et commence &agrave; s&rsquo;amuser   avec. LOUIS n&rsquo;appr&eacute;cie pas.</span></i></div>\\012<div style="text-indent: 16.35pt;"><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Allez d&eacute;p&ecirc;chez vous les mecs&nbsp;!</span></div>\\012<div style="text-indent: 16.35pt;">&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Rolalah c&rsquo;est bon mon pote&nbsp;! T&rsquo;inqui&egrave;tes pas on &agrave; le   temps&nbsp;! C&rsquo;est juste &agrave; cot&eacute; &hellip;</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Nan mais j&rsquo;avoue que &ccedil;a se fait pas, il passe son BAC le   pauvre.</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Les deux   amis s&rsquo;arr&ecirc;tent et reprennent le chemin.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   6</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">En   chemin, PIERRE et TIM veulent montrer &agrave; LOUIS leurs graffitis situ&eacute;s sur un   mur en hauteur.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Viens regarde sur le mur l&agrave;-bas, on a un b&ecirc;te de truc &agrave;   te montrer</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Non j&rsquo;ai pas le temps pas le temps les mecs</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Allez c&rsquo;est vite fait&nbsp;! C&rsquo;est des graffs qu&rsquo;on a   fait&nbsp;! On a besoin de ton opinion (<i>sourire</i>)</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">PIERRE et TIM grimpent sur le mur, pour montrer &agrave; LOUIS   leurs graffitis. LOUIS ne monte pas et regarde la sc&egrave;ne d&rsquo;en bas.</span></i></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Apr&egrave;s ce court arr&ecirc;t, les trois comp&egrave;res repartent en   chemin.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   7</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Sur le   chemin, TIM monte sur une &eacute;chelle pour s&rsquo;amuser, une fois en hauteur, il a un   point de vue magnifique portant tr&egrave;s loin. Il aper&ccedil;oit alors un homme, avec   qui LUI et PIERRE devaient s&rsquo;entretenir d&rsquo;urgence. </span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Hey Pierre t&eacute;ma&nbsp;! Y&rsquo;a Alexandre l&agrave;-bas&nbsp;!! Faut   absolument qu&rsquo;on aille lui parler, on n&rsquo;aura pas de meilleur occasion&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ok&nbsp;! Louis, d&eacute;sol&eacute;, on doit aller r&eacute;gler un truc,   mais on revient t&rsquo;inqui&egrave;te pas&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Mais j&rsquo;ai pas le temps l&agrave;&nbsp;! Faites pas les   encul&eacute;s&nbsp;! Vous m&rsquo;aviez promis&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tiom</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Nan mais t&rsquo;inqui&egrave;tes pas&nbsp;! C&rsquo;est tout droit&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">PIERRE   et TIM abandonnent LOUIS sur la voie d&eacute;serte. LOUIS   est perdu et ne sait plus o&ugrave; aller.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   8</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Longue   s&eacute;ance de Vagabondage de LOUIS sur la PC. </span></i></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Il &egrave;re,   marchant sur les rails et observant le d&eacute;cor autour de lui&nbsp;; d&eacute;couvrant   des lieux tout &agrave; fait insoup&ccedil;onn&eacute; o&ugrave; l&rsquo;on d&eacute;couvre les traces d'une capitale   champ&ecirc;tre, fant&ocirc;me, abandonn&eacute;e.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   9</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Lors de   sa marche, il croise un &laquo;&nbsp;fou&nbsp;&raquo; qui ne r&eacute;pond pas &agrave; ses   interpellations.</span></i></div>\\012<div><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Euuh &hellip;Monsieur&nbsp;? Monsieur&nbsp;!</span></div>\\012<div style="text-indent: 16.35pt;"><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Le fou</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">(<i>soupir</i>)&hellip;</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">LOUIS   continue de marcher et aper&ccedil;oit un tunnel qu&rsquo;il d&eacute;cide de traverser.</span></i></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   10</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">LOUIS   s&rsquo;engage dans un tunnel peu r&eacute;confortant. Il finit par trouver une sortie   signifiant la fin de son   calvaire.</span></i></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   11</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">D&eacute;sesp&eacute;r&eacute;,   Il quitte la    petite ceinture ne retrouvant plus son chemin. Il marche   dans la rue sans but   avec l&rsquo;id&eacute;e qu&rsquo;il a rat&eacute; son BAC et de toute les r&eacute;percutions que cela   pourrai avoir. LOUIS demande son chemin &agrave; un passant qui lui indique le lyc&eacute;e   qui se trouve juste &agrave; c&ocirc;t&eacute;.</span></i></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   12</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">LOUIS   arrive en courant devant son lyc&eacute;e.</span></i></div>\\012<div style="text-indent: 16.35pt;"><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Monsieur&nbsp;! je vous en supplie laissez moi rentrer,   c&rsquo;est super important&nbsp;pour moi&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Le   gardien le laisse rentrer in extremis&nbsp;; heureux d&rsquo;avoir retrouv&eacute; son   chemin et de pouvoir passer son &eacute;preuve.</span></i></div>\\012<div><b>&nbsp;</b></div>\\012<div>&nbsp;</div>\\012<p>            <span style="font-size: 10pt;"><br clear="all" /><br />\\012            </span></p>\\012<div><span style="color: windowtext; text-transform: none;">La note d&rsquo;intention</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">&nbsp;<img height="199" width="149" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image096.jpg" v:shapes="_x0000_i1075" />&nbsp;<img height="200" width="151" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image098.jpg" v:shapes="_x0000_i1076" />&nbsp;</span></b></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">La r&eacute;partition des &eacute;l&egrave;ves aux diff&eacute;rents postes techniques.<br />\\012            Cadrage</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Timoth&eacute;e   (1&egrave;re S1)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ga&eacute;tan (1&egrave;re   ES1)</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Acteurs</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Timoth&eacute;e   (1&egrave;re S2)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Louis (1&egrave;re   ES1)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pierre (1&egrave;re   S2)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ga&eacute;tan (1&egrave;re   ES1)</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Prise de son</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Guillaume   (1&egrave;re STG)</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Scripte</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Alexandre   (1&egrave;re ES1)</span></div>\\012<div style="margin-top: 6pt;"><span style="color: windowtext; text-transform: none;">Vlad (1&egrave;re L2)</span></div>\\012<div><i>&nbsp;</i></div>\\012<div><span style="color: windowtext; text-transform: none;">Les rep&eacute;rages</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="108" width="144" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image100.jpg" v:shapes="_x0000_i1077" />&nbsp;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Petite ceinture</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&agrave;</span><span style="color: windowtext; text-transform: none;"> 13&egrave;me Arrondissement&nbsp;&nbsp; </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="94" width="126" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image101.jpg" v:shapes="_x0000_i1078" /></span></div>\\012<div><span style="color: windowtext; text-transform: none;">Petite ceinture</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;</span><span style="color: windowtext; text-transform: none;">&agrave;</span><span style="color: windowtext; text-transform: none;"> Charonne</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="113" width="168" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image103.jpg" v:shapes="_x0000_i1079" /></span><span style="color: windowtext; text-transform: none;">&nbsp;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Petite ceinture</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&agrave;</span><span style="color: windowtext; text-transform: none;"> Buttes Chaumont&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;<img height="111" width="169" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image105.jpg" v:shapes="_x0000_i1080" />&nbsp;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Petite ceinture</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&agrave;</span><span style="color: windowtext; text-transform: none;"> Tunnel</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="161" width="121" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image107.jpg" v:shapes="_x0000_i1081" />&nbsp;&nbsp; <img height="163" width="122" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image109.jpg" v:shapes="_x0000_i1082" /></span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;PC </span><span style="color: windowtext; text-transform: none;">&agrave;</span><span style="color: windowtext; text-transform: none;"> Montsouris&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;</span></div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="149" width="180" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image111.jpg" v:shapes="_x0000_i1083" /></span></div>\\012<div><span style="color: windowtext; text-transform: none;">&agrave;</span><span style="color: windowtext; text-transform: none;"> Plan de la petite ceinture autour   de Paris</span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="174" width="289" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image113.gif" v:shapes="_x0000_i1084" /></span></div>\\012<div><span style="color: windowtext; text-transform: none;">&agrave;</span><span style="color: windowtext; text-transform: none;"> Plan m&eacute;moire des chemins de fer   de Paris</span></div>\\012<div>&nbsp;</div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><span style="color: windowtext; text-transform: none;">Le d&eacute;coupage technique</span></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><span style="color: red; text-transform: none;">Manque</span></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b>&nbsp;</b></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><span style="color: windowtext; text-transform: none;">Le plan de tournage</span></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">1er JOUR DE TOURNAGE&nbsp;: (s&eacute;quence 1, 2 &amp; 3)</span></b></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 1&nbsp;: </span></b><span style="color: windowtext; text-transform: none;">Tournage   chez Ga&eacute;tan, dans sa chambre. Cadrage&nbsp;: Timoth&eacute;e. Prise de son&nbsp;:   Timoth&eacute;e Gros-. Acteur&nbsp;: Louis.</span></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 2&nbsp;:</span></b><span style="color: windowtext; text-transform: none;">   Tournage chez Ga&eacute;tan, dans la cuisine. Cadrage&nbsp;: Timoth&eacute;e. Prise de   son&nbsp;: Guillaume. Acteur&nbsp;: Louis &amp; Marie.</span></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 3&nbsp;:</span></b><span style="color: windowtext; text-transform: none;">   Tournage chez Ga&eacute;tan, de la    coure de sa r&eacute;sidence &agrave; la boulangerie situ&eacute; &agrave;   cot&eacute;. Cadrage&nbsp;: Marie (Ga&eacute;tan). Prise de son&nbsp;: Guillaume.   Acteur&nbsp;: Louis.</span></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;">&nbsp;</div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">2&egrave;me JOUR DE TOURNAGE&nbsp;: (s&eacute;quence 4, 5, 6, 7, 8, 9,   10, 11 &amp; 12)</span></b></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 4&nbsp;: </span></b><span style="color: windowtext; text-transform: none;">Tournage   place Daumesnil, &agrave; l&rsquo;arr&ecirc;t de bus du 46 et sur la place. Cadrage&nbsp;:   Marie (Ga&eacute;tan)</span></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 6&nbsp;: </span></b><span style="color: windowtext; text-transform: none;">Tournage   Boulevard Soult, en face du lyc&eacute;e Paul Val&eacute;ry, &agrave; cot&eacute; du Franprix.   Cadrage&nbsp;: Timoth&eacute;e. Prise de son&nbsp;: Guillaume. Acteur&nbsp;: Louis,   Pierre et Timoth&eacute;e.</span></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;">&nbsp;</div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 7&nbsp;: </span></b><span style="color: windowtext; text-transform: none;">Tournage   sur la P.C., &agrave; l&rsquo;entr&eacute;e. Cadrage&nbsp;: Marie (Timoth&eacute;e). Prise de son&nbsp;:   Guillaume.</span></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;">&nbsp;</div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 8&nbsp;:</span></b></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 9&nbsp;:</span></b></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 10&nbsp;:</span></b></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 11&nbsp;:</span></b></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 12&nbsp;:</span></b></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 5&nbsp;:</span></b></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">3&egrave;me JOUR DE TOURNAGE&nbsp;: (s&eacute;quence 13)</span></b></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 13&nbsp;: </span></b><span style="color: windowtext; text-transform: none;">n&eacute;ant.</span></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><span style="color: red; text-transform: none;">manquent</span></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;">&nbsp;</div>\\012<p>            <span style="font-size: 10pt;"><br clear="all" /><br />\\012            </span></p>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><span style="color: windowtext; text-transform: none;">Le tournage</span></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b><span style="color: windowtext; text-transform: none;"><img height="162" width="122" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image115.jpg" v:shapes="_x0000_i1034" />&nbsp;&nbsp; <img height="164" width="123" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image117.jpg" v:shapes="_x0000_i1035" /></span></b></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><b>&nbsp;</b></div>\\012<div style="margin: 3pt 3.6pt 3pt 0cm;"><span style="color: windowtext; text-transform: none;">Le d&eacute;rushage, le montage, la   bande-son et le mixage, le g&eacute;n&eacute;rique</span></div>\\012<div><span style="color: red; text-transform: none;"><br />\\012            </span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Liceo classico   M. Gioia, Piacenza (Italie)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">2&egrave;me linguistique A - Paola Gozzi, professeur de langages non verbaux</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">20_Liceo_Mgioia_Piacenza</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Passi nella citt&agrave;&nbsp;&raquo;, dur&eacute;e 8&rsquo;53&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">L'objectif de   ce court-m&eacute;trage (sorte de docu-fiction) est de montrer Piacenza &agrave; partir du   point de vue d'une jeune femme &eacute;trang&egrave;re qui &lsquo;d&eacute;couvre&rsquo; la ville.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="162" width="217" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image119.jpg" v:shapes="_x0000_i1085" /></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: blue;">Texte</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">&laquo;&nbsp;Ekaterina   est &eacute;trang&egrave;re. Elle vient de s&rsquo;installer &agrave; Piacenza . La ville est montr&eacute;e &agrave;   travers un regard subjectif et intime, soulign&eacute; par le recours &agrave; la voix-off   de la    protagoniste. Piacenza y est d&eacute;crite comme une ville de   fronti&egrave;re, d&eacute;limit&eacute;e par le fleuve P&ocirc; : l'atmosph&egrave;re est un peu fade, mais en   m&ecirc;me temps fascinante et captivante c'est un lieu myst&eacute;rieux prisonnier du   temps et, souvent, du brouillard, qui semble vouloir cacher ses secrets &agrave;   tous ceux qui ne lui appartiennent pas.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Synopsis</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Synopsis</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza&nbsp;:   Passi nella citt&agrave; - Les pas dans la ville</span></b><span style="color: windowtext; text-transform: none;">.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza   </span></b><span style="color: windowtext; text-transform: none;">Plan g&eacute;n&eacute;ral (panoramique verticale 120&deg;) du dernier &eacute;tage du Lyc&eacute;e   Gioia, 9h/10h du matin. </span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza.</span></b><b><span style="color: windowtext; text-transform: none;">Chez la protagoniste, Ekaterina</span></b><span style="color: windowtext; text-transform: none;"> Dimanche   matin, Ekaterina, est assise &agrave; son bureau, elle &eacute;crit son journal&nbsp;: elle   raconte la    journ&eacute;e pr&eacute;c&eacute;dente, pass&eacute;e &agrave; visiter la ville dans laquelle   elle vient de s&rsquo;installer.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza.</span></b><span style="color: windowtext; text-transform: none;"> <b>Les enceintes de la ville (d&eacute;but du   flashback) </b>La protagoniste est dans un bus, elle observe les murs et elle   commente ce premier regard sur la ville. </span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza.</span></b><span style="color: windowtext; text-transform: none;"> <b>Piazza Cittadella </b>Ekaterina arrive sur   la place, elle descend du bus. </span><span style="color: windowtext; text-transform: none;">En traversant le terminal de bus, elle entrevoit   trois filles qui attendent le bus et, en observant l&rsquo;endroit, elle remarque   le Palazzo Farnese et ensuite son &eacute;cole, le&nbsp;Lyc&eacute;e Gioia.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza.   Lyc&eacute;e Gioia </span></b><span style="color: windowtext; text-transform: none;">En face, des jeunes gens sont assis sur des bancs et   bavardent entre eux. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ekaterina, apr&egrave;s avoir observ&eacute; le Lyc&eacute;e, se tourne vers la rue Cavour.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza.   Bar Italia </span></b><span style="color: windowtext; text-transform: none;">En parcourant cette rue, la protagoniste passe sous   les portiques et elle arrive au Bar Italia, o&ugrave; l&rsquo;attend une amie. </span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza.   Bar Italia, int&eacute;rieur</span></b><span style="color: windowtext; text-transform: none;"> Les deux filles sont assises &agrave; une   table du caf&eacute; et sirotent une boisson. L&rsquo;amie montre &agrave; Ekaterina des photos   de la ville    ancienne qui sont accroch&eacute;s aux murs du caf&eacute;&nbsp;et   Ekaterina fait une comparaison des lieux d&rsquo;autrefois avec les lieux   d&rsquo;aujourd&rsquo;hui. (Les m&ecirc;mes photos seront ensuite montr&eacute;es tout au long du   court-m&eacute;trage pour faire une comparaison avec les lieux que la protagoniste   visite).</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza.   Piazza Duomo</span></b><span style="color: windowtext; text-transform: none;"> La protagoniste arrive Piazza Duomo en parcourant le   dernier bout de la rue XX septembre.   La place est    montr&eacute;e &agrave; travers des coupes nettes entre les multiples   images qui apparaissent aux yeux d&rsquo;Ekaterina.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza.   Piazza Cavalli</span></b><span style="color: windowtext; text-transform: none;"> Sur les marches de l&rsquo;&eacute;glise qui est dans le coin de la rue XX septembre,   Ekaterina observe la Piazza Cavalli    et, par la suite, lorsqu&rsquo;elle se tourne vers la place, elle   entrevoit l&rsquo;H&ocirc;tel de Ville et l&rsquo;avenue Vittorio Emanuele. La protagoniste observe la   statue des deux chevaux et elle r&eacute;fl&eacute;chit. </span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza.   Rue Calzolai</span></b><span style="color: windowtext; text-transform: none;"> La protagoniste fait un tour dans la place et elle   tourne dans la    rue Calzolai. Ekaterina marche dans cette rue et elle   regarde autour d&rsquo;elle, elle voit des grands b&acirc;timents du Moyen Age. Elle   s&rsquo;arr&ecirc;te ensuite pour observer des vitrines. Elle est cadr&eacute;e de l&rsquo;int&eacute;rieur   du magasin, en respectant la m&ecirc;me &eacute;chelle de plans, afin de cadrer aussi des   gens qui passent dans la rue. </span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza. Piazza Borgo</span></b><span style="color: windowtext; text-transform: none;"> Ekaterina arrive Piazza Borgo venant de la rue Calzolai. Elle remarque une autre tour b&acirc;tie durant le Moyen   Age puis ensuite regarde la    place dans son ensemble en s&rsquo;arr&ecirc;tant notamment sur   l&rsquo;&eacute;glise. </span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza.   Faxal</span></b><span style="color: windowtext; text-transform: none;"> La protagoniste, venant de l&rsquo;avenue Vittorio Emanuele,   se tourne vers le Faxal. On voit Ekaterina s&rsquo;&eacute;loigner de la cam&eacute;ra lorsqu&rsquo;elle   parcourt le boulevard, jusqu&rsquo;&agrave; arriver au square des jeux pour enfants. Ici, la protagoniste s&rsquo;arr&ecirc;te   et elle commence &agrave; se balancer sur la balan&ccedil;oire en repensant   &agrave; son enfance dans la    ville de Petrich.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza.   Parc de la Galleana<span style="font-weight: normal;"> En</span><span style="font-weight: normal;"> provenant de la rue Manfredi,   montr&eacute;e rapidement avec des coupes nettes, Ekaterina arrive au parc de la Galleana en y   entrant par la    grille principale. La cam&eacute;ra observe la protagoniste qui s&rsquo;&eacute;loigne   dans le parc. Apr&egrave;s avoir march&eacute; un peu, elle s&rsquo;allonge dans le gazon en   repensant &agrave; la journ&eacute;e. Apr&egrave;s    cet instant de r&eacute;flexion, elle sort du parc en parcourant la m&ecirc;me rue.</span></span></b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">&nbsp;Piacenza. Chez la protagoniste<span style="font-weight: normal;">. Ekaterina</span><span style="font-weight: normal;"> conclut la r&eacute;daction de son   journal et elle le ferme en le laissant sur son bureau. </span></span></b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Piacenza.   Les berges du P&ocirc; au cr&eacute;puscule.</span></b></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<p>&nbsp;</p>\\012<p>&nbsp;</p>\\012	1249393677	1249307277		0
2:f3c41969350171038b5eacab37877d42	<p class="rteright"><a href="/lignes_de_temps_faq_en">English version</a></p>\\012<p>Le logiciel <i>Lignes de temps</i> est compos&eacute; de deux parties, que l'on appellera syst&egrave;me et interface.           <br />\\012- La partie syst&egrave;me est &quot;invisible&quot; pour l'utilisateur et permet d'enregistrer son travail (notes, d&eacute;coupages, bout &agrave; bout) dans un fichier. Elle permet aussi de lancer les programmes n&eacute;cessaires &agrave; l'import d'un fichier audio ou vid&eacute;o. Ces programmes encodent la vid&eacute;o pour qu'elle soit lisible dans l'interface et g&eacute;n&egrave;rent le plan par plan et la forme d'onde. <br />\\012- L'interface est tout ce qui est &quot;visible&quot; et manipulable par l'utilisateur. Elle se compose du menu en haut &agrave; gauche (Fichier, Affichage...) et des trois fen&ecirc;tres : informations, lecteur vid&eacute;o et celle qui affiche les lignes de temps. <br />\\012Les deux parties du programme communiquent entre elles mais cette communication peut parfois s'interrompre sans en informer l'utilisateur. Dans ce cas, on ne peut malheureusement plus enregistrer son travail. L'Institut de recherche et d'innovation travaille constamment &agrave; la r&eacute;solution de ce type de bogues. Pour toute information, commentaire ou probl&egrave;me, merci d'envoyer un mail &agrave; <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a><br />\\012Un travail dans <i>Lignes de temps</i> est sauvegard&eacute; dans un fichier de projet (extension .ldt) qui contient les r&eacute;f&eacute;rences vers les m&eacute;dias utilis&eacute;s et toutes les donn&eacute;es personnelles (notes, d&eacute;coupages, bout &agrave; bout, vues). Les donn&eacute;es non personnelles sur un m&eacute;dia (plan par plan et forme d'onde par exemple) sont enregistr&eacute;es dans un fichier &agrave; extension .iri.</p>\\012<ul>\\012<li><b>J'utilise un MAC, comment conna&icirc;tre ma configuration ?</b><br />\\012    Pour savoir si votre ordinateur est &quot;Intel&quot; ou &quot;Power PC&quot;, allez dans le menu Pomme en haut &agrave; gauche de votre &eacute;cran. Dans le menu qui est apparu, cliquez sur &quot;&agrave; propos de ce mac&quot;. La ligne &quot;Processeur&quot; indique si celui-ci est de type &quot;Intel&quot; ou &quot;Power PC&quot;.<br />\\012    Apr&egrave;s diff&eacute;rents tests, il apparait que <i>Lignes de temps</i> ne s'installe que sur les postes &eacute;quip&eacute;s du syst&egrave;me d'exploitation 10.5, dit &quot;l&eacute;opard&quot;, et du processeur Intel, ou ceux &eacute;quip&eacute;s du syst&egrave;me 10.4, dit &quot;tiger&quot;, et du processeur Power PC.</li>\\012<li><b>Je n'arrive pas &agrave; afficher les lignes de temps d'un film :</b><br />\\012    Pour afficher ces lignes il faut cliquer sur le titre du film, puis sur l'onglet &quot;D&eacute;coupages&quot; de la fen&ecirc;tre d'informations. Dans cet onglet, se trouve la liste des d&eacute;coupages disponibles. Il suffit de cliquer sur l'un d'entre eux pour afficher la ligne correspondante.</li>\\012<li><b>Je n'arrive pas &agrave; importer un fichier audio ou vid&eacute;o :</b><br />\\012    Il faut s'assurer que l'extension du fichier est compatible. <i>Lignes de temps</i> accepte les fichiers .avi, .mpg, .mov, .flv pour la vid&eacute;o et .mp3 pour l'audio. Ensuite, m&ecirc;me si celui-ci est accept&eacute;, il se peut que l'encodage ne soit pas compatible avec le programme (ffmpeg) qui transforme ce fichier en vid&eacute;o lisible par <i>Lignes de temps</i>, c'est-&agrave;-dire au format flv. Sous MAC, m&ecirc;me si l'extension du fichier est correcte, il se peut que certains caract&egrave;res emp&ecirc;chent l'import. Il est donc conseill&eacute; que le chemin d'acc&egrave;s et le nom de fichier n'aient pas les caract&egrave;res suivants : caract&egrave;res accentu&eacute;s, espace, &ccedil;, #, &amp;, %, !, *, (), [], |, {}, :, ;, @.</li>\\012<li><b>Je n'arrive pas &agrave; sauvegarder mon travail :</b><br />\\012    Comme expliqu&eacute; dans l'introduction, ce probl&egrave;me peut venir de la perte de communication entre l'interface et la partie du programme qui enregistre dans un fichier. Pour enregistrer son travail, on peut passer par le menu en haut &agrave; gauche (Fichier -- Enregistrer le projet) ou par le raccourci clavier Ctrl+S sur PC et Pomme+S sur Mac. En g&eacute;n&eacute;ral, quand un travail a &eacute;t&eacute; modifi&eacute; depuis le dernier enregistrement, une &eacute;toile appara&icirc;t &agrave; c&ocirc;t&eacute; du titre du projet pour montrer qu'un enregistrement est n&eacute;cessaire.</li>\\012</ul>\\012<p>&nbsp;</p>\\012<p><b>Notes de version 0.10.8 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; de vid&eacute;o en plein &eacute;cran sur fond noir</li>\\012<li>Possibilit&eacute; d'afficher un permalien vers un segment</li>\\012<li>Possibilit&eacute; d'afficher des sous-titres depuis un fichier externet au format TimedText XML</li>\\012<li>Possibilit&eacute; d'afficher l'int&eacute;gralit&eacute; des annotations (titre et description) d'une ligne dans un grand champ texte &eacute;quip&eacute; d'une recherche simple</li>\\012</ul>\\012<p><b>Notes de version 0.10.4 &agrave; 0.10.7 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; d'importer des d&eacute;coupages depuis un autre fichier .ldt</li>\\012<li>Possibilit&eacute; d'annoter un flux live stream&eacute; en rtmp://...</li>\\012<li>D&eacute;placement des lignes de temps et des films par simple drag and drop</li>\\012<li>Am&eacute;liorations ergonomiques (nom du fichier .ldt affich&eacute; dans le titre fen&ecirc;tre d'information, zoom plus fluide, possibilit&eacute; de sauvegarder sa langue par d&eacute;faut)</li>\\012<li>Possibilit&eacute; de dupliquer les segments en surbrillance d'une ligne de temps</li>\\012<li>D&eacute;bug divers</li>\\012</ul>\\012<p><b>Notes de version 0.10.3 :</b></p>\\012<ul>\\012<li>Langue japonaise ajout&eacute;e par d&eacute;faut</li>\\012<li>D&eacute;bug divers</li>\\012</ul>\\012<p><b>Notes de version 0.10 :</b></p>\\012<ul>\\012<li>INTERFACE MULTILINGUE avec Anglais et Fran&ccedil;ais propos&eacute;s par d&eacute;faut et possibilit&eacute; d'ajouter soi-m&ecirc;me des langues (&eacute;tapes expliqu&eacute;es dans le <a target="_blank" href="/res/media/ldt_userguide_fr.pdf">mode d'emploi</a> gr&acirc;ce &agrave; l'outil GETTEXT)</li>\\012<li>Refonte compl&egrave;te de l'interface et de l'ergonomie avec entre autres ajout de boutons avec icones, de nouveaux onglets plus visibles, de bulles d'aide, de messages de confirmation avant suppression.</li>\\012<li>Vues : possibilit&eacute; de renommage et de d&eacute;placement.</li>\\012<li>Tags : affichage de la liste compl&egrave;te du nuage de tags du projet par le menu en haut &agrave; gauche et le raccourci Shift + T.</li>\\012<li>Prise de notes : am&eacute;lioration du suivi de la frappe gr&acirc;ce au positionnement automatique de l'ascenceur, indication du timecode correspondant au survol du marqueur.</li>\\012<li>Bout &agrave; bout : possibilit&eacute; de suppression.</li>\\012<li>Ajout d'un <a target="_blank" href="/dev/trac/ldt">trac</a> pour le suivi des bugs.</li>\\012<li>Mise &agrave; jour compl&egrave;te du mode d'emploi en <a target="_blank" href="/res/media/ldt_userguide_fr.pdf">fran&ccedil;ais</a> et en <a target="_blank" href="/res/media/ldt_userguide_en.pdf">anglais</a>.</li>\\012<li>Ajout de la license dans l'&agrave; propos.</li>\\012</ul>\\012<p><b>Notes de version 0.9.4 :</b></p>\\012<ul>\\012<li>Ajout d'un module prise de notes, permettant d'&eacute;crire des commentaires &agrave; la vol&eacute;e puis de les transformer en ligne de temps.</li>\\012<li>Vues : la sauvegarde des &eacute;tats d'affichage prennent maintenant en compte le niveau de zoom, la position de l'ascenceur horizontal et si un bout &agrave; bout est en lecture.</li>\\012<li>Am&eacute;lioration de la saisie des tags : possibilit&eacute; d'avoir une fen&ecirc;tre avec tous les tags d'une ligne et ajout du tag par simple clic.</li>\\012<li>Possibilit&eacute; d'afficher tous les tags du projets dans une grande fen&ecirc;tre gr&acirc;ce au raccourci clavier Shift + F.</li>\\012<li>Possibilit&eacute; de mettre en surbrillance les segments en cliquant sur les tags d'une ligne. Cinq couleurs sont disponibles (une par tag), puis au-del&agrave; les segments concern&eacute;s par la recherche s'affichent en blanc.</li>\\012<li>Possibilit&eacute; de dupliquer une ligne en ne s&eacute;lectionnant que les segments en surbrillance.</li>\\012<li>Possibilit&eacute; de cr&eacute;er un bout &agrave; bout &agrave; partir d'une ligne compl&egrave;te ou des segments en surbrillance.</li>\\012<li>Ajout de messages d'erreur en cas de plantage du logiciel. Cela limite le risque de perdre son travail.</li>\\012</ul>\\012<p><b>Notes de version 0.9.2 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; de dupliquer n'importe quelle ligne (bouton &quot;dupliquer&quot; dans la fen&ecirc;tre d'informations).</li>\\012<li>Ajout du champ tag pour les segments.</li>\\012<li>Possibilit&eacute; d'afficher le sommaire d'un d&eacute;coupage, c'est-&agrave;-dire la liste de ses segments sous forme de texte cliquable.</li>\\012<li>D&eacute;bogage des bugs identifi&eacute;s dans la version pr&eacute;c&eacute;dente.</li>\\012<li>Modification de l'interface : fen&ecirc;tre d'informations agrandie en hauteur et en largeur et fen&ecirc;tre d'affichage des lignes agrandie en largeur.</li>\\012</ul>\\012<p>&nbsp;</p>\\012	1250159076	1250072676		0
2:695eaf23acebce1a27693665d295d5a2	<ul>\\012<li><a href="/telecharger_lignes_de_temps">T&eacute;l&eacute;charger Lignes De Temps</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire">S&eacute;minaires index&eacute;s dans Lignes De Temps</a>\\012<ul>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/1">Figures de l'amateur</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/6">Mus&eacute;ologie 2007-2008</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/8">Mus&eacute;ologie 2008-2009</a></li>\\012<li><span class="orange_txt"><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/9">Politiques et technologies de l&rsquo;amateur</a></span></li>\\012<li><span class="orange_txt"><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/10">THD Cap Digital\\011\\011\\011\\011</a> \\011\\011\\011</span></li>\\012<li><span class="orange_txt"><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/11">Nanotechnologies\\011\\011\\011\\011</a> \\011\\011\\011</span></li>\\012<li><span class="orange_txt"><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/12">Modernisation\\011\\011\\011\\011</a> \\011\\011\\011</span></li>\\012</ul>\\012</li>\\012<li><a href="http://www.iri.centrepompidou.fr/privatedoc/">S&eacute;minaires en audio</a></li>\\012<li><a target="_blank" href="http://www.thdculture.fr">THD Culture</a></li>\\012<li><a href="http://amateur.iri.centrepompidou.fr/nouveaumonde/enmi/conf/">Entretiens du Nouveau Monde Industriel</a><a target="_blank" href="http://www.thdculture.fr"><br />\\012    </a></li>\\012<li><a href="/espaces_critiques">Espaces critiques</a></li>\\012</ul>\\012	1250586673	1250500273		0
2:823f106d47aec36ada08ad40fa981825	<p>- 26-27 novembre 2009 : <a href="http://amateur.iri.centrepompidou.fr/nouveaumonde/enmi/conf/#programme2009" target="_blank">Entretiens du nouveau monde industriel 2009</a>, Centre Pompidou, grande salle</p>\\012	1250592689	1250506289		0
2:6c0b8ace78496e45cd6785558ff13451	<p class="rteright"><a href="/lignes_de_temps_faq_en">English version</a></p>\\012<p>Le logiciel <i>Lignes de temps</i> est compos&eacute; de deux parties, que l'on appellera syst&egrave;me et interface.           <br />\\012- La partie syst&egrave;me est &quot;invisible&quot; pour l'utilisateur et permet d'enregistrer son travail (notes, d&eacute;coupages, bout &agrave; bout) dans un fichier. Elle permet aussi de lancer les programmes n&eacute;cessaires &agrave; l'import d'un fichier audio ou vid&eacute;o. Ces programmes encodent la vid&eacute;o pour qu'elle soit lisible dans l'interface et g&eacute;n&egrave;rent le plan par plan et la forme d'onde. <br />\\012- L'interface est tout ce qui est &quot;visible&quot; et manipulable par l'utilisateur. Elle se compose du menu en haut &agrave; gauche (Fichier, Affichage...) et des trois fen&ecirc;tres : informations, lecteur vid&eacute;o et celle qui affiche les lignes de temps. <br />\\012Les deux parties du programme communiquent entre elles mais cette communication peut parfois s'interrompre sans en informer l'utilisateur. Dans ce cas, on ne peut malheureusement plus enregistrer son travail. L'Institut de recherche et d'innovation travaille constamment &agrave; la r&eacute;solution de ce type de bogues. Pour toute information, commentaire ou probl&egrave;me, merci d'envoyer un mail &agrave; <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a><br />\\012Un travail dans <i>Lignes de temps</i> est sauvegard&eacute; dans un fichier de projet (extension .ldt) qui contient les r&eacute;f&eacute;rences vers les m&eacute;dias utilis&eacute;s et toutes les donn&eacute;es personnelles (notes, d&eacute;coupages, bout &agrave; bout, vues). Les donn&eacute;es non personnelles sur un m&eacute;dia (plan par plan et forme d'onde par exemple) sont enregistr&eacute;es dans un fichier &agrave; extension .iri.</p>\\012<ul>\\012<li><b>J'utilise un MAC, comment conna&icirc;tre ma configuration ?</b><br />\\012    Pour savoir si votre ordinateur est &quot;Intel&quot; ou &quot;Power PC&quot;, allez dans le menu Pomme en haut &agrave; gauche de votre &eacute;cran. Dans le menu qui est apparu, cliquez sur &quot;&agrave; propos de ce mac&quot;. La ligne &quot;Processeur&quot; indique si celui-ci est de type &quot;Intel&quot; ou &quot;Power PC&quot;.<br />\\012    Apr&egrave;s diff&eacute;rents tests, il apparait que <i>Lignes de temps</i> ne s'installe que sur les postes &eacute;quip&eacute;s du syst&egrave;me d'exploitation 10.5, dit &quot;l&eacute;opard&quot;, et du processeur Intel, ou ceux &eacute;quip&eacute;s du syst&egrave;me 10.4, dit &quot;tiger&quot;, et du processeur Power PC.</li>\\012<li><b>Je n'arrive pas &agrave; afficher les lignes de temps d'un film :</b><br />\\012    Pour afficher ces lignes il faut cliquer sur le titre du film, puis sur l'onglet &quot;D&eacute;coupages&quot; de la fen&ecirc;tre d'informations. Dans cet onglet, se trouve la liste des d&eacute;coupages disponibles. Il suffit de cliquer sur l'un d'entre eux pour afficher la ligne correspondante.</li>\\012<li><b>Je n'arrive pas &agrave; importer un fichier audio ou vid&eacute;o :</b><br />\\012    Il faut s'assurer que l'extension du fichier est compatible. <i>Lignes de temps</i> accepte les fichiers .avi, .mpg, .mov, .flv pour la vid&eacute;o et .mp3 pour l'audio. Ensuite, m&ecirc;me si celui-ci est accept&eacute;, il se peut que l'encodage ne soit pas compatible avec le programme (ffmpeg) qui transforme ce fichier en vid&eacute;o lisible par <i>Lignes de temps</i>, c'est-&agrave;-dire au format flv. Sous MAC, m&ecirc;me si l'extension du fichier est correcte, il se peut que certains caract&egrave;res emp&ecirc;chent l'import. Il est donc conseill&eacute; que le chemin d'acc&egrave;s et le nom de fichier n'aient pas les caract&egrave;res suivants : caract&egrave;res accentu&eacute;s, espace, &ccedil;, #, &amp;, %, !, *, (), [], |, {}, :, ;, @.</li>\\012<li><b>Je n'arrive pas &agrave; sauvegarder mon travail :</b><br />\\012    Comme expliqu&eacute; dans l'introduction, ce probl&egrave;me peut venir de la perte de communication entre l'interface et la partie du programme qui enregistre dans un fichier. Pour enregistrer son travail, on peut passer par le menu en haut &agrave; gauche (Fichier -- Enregistrer le projet) ou par le raccourci clavier Ctrl+S sur PC et Pomme+S sur Mac. En g&eacute;n&eacute;ral, quand un travail a &eacute;t&eacute; modifi&eacute; depuis le dernier enregistrement, une &eacute;toile appara&icirc;t &agrave; c&ocirc;t&eacute; du titre du projet pour montrer qu'un enregistrement est n&eacute;cessaire.</li>\\012</ul>\\012<p><b>Notes de version 0.10.8 :</b></p>\\012<p>&nbsp;</p>\\012<ul>\\012<li>Possibilit&eacute; de vid&eacute;o en plein &eacute;cran sur fond noir</li>\\012<li>Possibilit&eacute; d'afficher un permalien vers un segment</li>\\012</ul>\\012<p><b>Notes de version 0.10.4 &agrave; 0.10.7 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; d'importer des d&eacute;coupages depuis un autre fichier .ldt</li>\\012<li>Possibilit&eacute; d'annoter un flux live stream&eacute; en rtmp://...</li>\\012<li>D&eacute;placement des lignes de temps et des films par simple drag and drop</li>\\012<li>Am&eacute;liorations ergonomiques (nom du fichier .ldt affich&eacute; dans le titre fen&ecirc;tre d'information, zoom plus fluide, possibilit&eacute; de sauvegarder sa langue par d&eacute;faut)</li>\\012<li>Possibilit&eacute; de dupliquer les segments en surbrillance d'une ligne de temps</li>\\012<li>D&eacute;bug divers</li>\\012</ul>\\012<p><b>Notes de version 0.10.3 :</b></p>\\012<ul>\\012<li>Langue japonaise ajout&eacute;e par d&eacute;faut</li>\\012<li>D&eacute;bug divers</li>\\012</ul>\\012<p><b>Notes de version 0.10 :</b></p>\\012<ul>\\012<li>INTERFACE MULTILINGUE avec Anglais et Fran&ccedil;ais propos&eacute;s par d&eacute;faut et possibilit&eacute; d'ajouter soi-m&ecirc;me des langues (&eacute;tapes expliqu&eacute;es dans le <a target="_blank" href="/res/media/ldt_userguide_fr.pdf">mode d'emploi</a> gr&acirc;ce &agrave; l'outil GETTEXT)</li>\\012<li>Refonte compl&egrave;te de l'interface et de l'ergonomie avec entre autres ajout de boutons avec icones, de nouveaux onglets plus visibles, de bulles d'aide, de messages de confirmation avant suppression.</li>\\012<li>Vues : possibilit&eacute; de renommage et de d&eacute;placement.</li>\\012<li>Tags : affichage de la liste compl&egrave;te du nuage de tags du projet par le menu en haut &agrave; gauche et le raccourci Shift + T.</li>\\012<li>Prise de notes : am&eacute;lioration du suivi de la frappe gr&acirc;ce au positionnement automatique de l'ascenceur, indication du timecode correspondant au survol du marqueur.</li>\\012<li>Bout &agrave; bout : possibilit&eacute; de suppression.</li>\\012<li>Ajout d'un <a target="_blank" href="/dev/trac/ldt">trac</a> pour le suivi des bugs.</li>\\012<li>Mise &agrave; jour compl&egrave;te du mode d'emploi en <a target="_blank" href="/res/media/ldt_userguide_fr.pdf">fran&ccedil;ais</a> et en <a target="_blank" href="/res/media/ldt_userguide_en.pdf">anglais</a>.</li>\\012<li>Ajout de la license dans l'&agrave; propos.</li>\\012</ul>\\012<p><b>Notes de version 0.9.4 :</b></p>\\012<ul>\\012<li>Ajout d'un module prise de notes, permettant d'&eacute;crire des commentaires &agrave; la vol&eacute;e puis de les transformer en ligne de temps.</li>\\012<li>Vues : la sauvegarde des &eacute;tats d'affichage prennent maintenant en compte le niveau de zoom, la position de l'ascenceur horizontal et si un bout &agrave; bout est en lecture.</li>\\012<li>Am&eacute;lioration de la saisie des tags : possibilit&eacute; d'avoir une fen&ecirc;tre avec tous les tags d'une ligne et ajout du tag par simple clic.</li>\\012<li>Possibilit&eacute; d'afficher tous les tags du projets dans une grande fen&ecirc;tre gr&acirc;ce au raccourci clavier Shift + F.</li>\\012<li>Possibilit&eacute; de mettre en surbrillance les segments en cliquant sur les tags d'une ligne. Cinq couleurs sont disponibles (une par tag), puis au-del&agrave; les segments concern&eacute;s par la recherche s'affichent en blanc.</li>\\012<li>Possibilit&eacute; de dupliquer une ligne en ne s&eacute;lectionnant que les segments en surbrillance.</li>\\012<li>Possibilit&eacute; de cr&eacute;er un bout &agrave; bout &agrave; partir d'une ligne compl&egrave;te ou des segments en surbrillance.</li>\\012<li>Ajout de messages d'erreur en cas de plantage du logiciel. Cela limite le risque de perdre son travail.</li>\\012</ul>\\012<p><b>Notes de version 0.9.2 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; de dupliquer n'importe quelle ligne (bouton &quot;dupliquer&quot; dans la fen&ecirc;tre d'informations).</li>\\012<li>Ajout du champ tag pour les segments.</li>\\012<li>Possibilit&eacute; d'afficher le sommaire d'un d&eacute;coupage, c'est-&agrave;-dire la liste de ses segments sous forme de texte cliquable.</li>\\012<li>D&eacute;bogage des bugs identifi&eacute;s dans la version pr&eacute;c&eacute;dente.</li>\\012<li>Modification de l'interface : fen&ecirc;tre d'informations agrandie en hauteur et en largeur et fen&ecirc;tre d'affichage des lignes agrandie en largeur.</li>\\012</ul>\\012	1249136754	1249050354		0
2:2fb198705d89debdc5ac2b86277d857e	<p><img height="226" width="100%" alt="" src="/res/img/ldt.jpg" /></p>\\012<p align="justify"><a href="../res/img/ldt_300dpi.jpg">Copie d'&eacute;cran de Lignes de temps en 300 dpi</a></p>\\012<p align="justify">Le logiciel Lignes de temps met &agrave; profit les possibilit&eacute;s d&rsquo;analyse et de synth&egrave;se offertes par le support num&eacute;rique. Inspir&eacute;es par les &laquo;timelines&raquo; ordinairement utilis&eacute;es sur les bancs de montage num&eacute;rique, Lignes de temps propose une repr&eacute;sentation graphique d&rsquo;un film, r&eacute;v&eacute;lant d&rsquo;embl&eacute;e, et in extenso, son d&eacute;coupage. Lignes de temps offre en cela un acc&egrave;s in&eacute;dit au film, en substituant &agrave; la logique du d&eacute;filement contraint qui constitue l&rsquo;exp&eacute;rience de tout spectateur de cin&eacute;ma, et pour les besoins de l&rsquo;analyse, la &laquo;cartographie&raquo; d&rsquo;un objet temporel. Aussi, en s&eacute;lectionnant un segment d&rsquo;une ligne de temps, l&rsquo;utilisateur a-t-il acc&egrave;s directement au plan ou &agrave; la s&eacute;quence correspondante dans le film, s&eacute;quence qui peut &ecirc;tre d&eacute;crite et analys&eacute;e par des commentaires textuels, audio, vid&eacute;o, ou document&eacute;e par des images ou des liens Internet.<a href="#more"><br />\\012</a></p>\\012<h3>T&Eacute;L&Eacute;CHARGEMENT de <i>Lignes de temps</i> :</h3>\\012<p><a href="/lignes_de_temps_faq"><strong>? FAQ ?</strong></a></p>\\012<p align="justify">T&eacute;l&eacute;charger d&egrave;s maintenant le logiciel &quot;Lignes de temps&quot;. Gr&acirc;ce &agrave; lui, analysez et annotez les films de votre choix.</p>\\012<ul>\\012<li><b>PC</b> :\\012<ul>\\012<li><a href="../apps/LignesDeTemps-0.10.7-Setup.exe">Version 0.10.7 simple (35 Mo)</a></li>\\012<li><a href="../apps/LignesDeTempsNosferatu-0.10.7-Setup.exe">Version 0.10.7 contenant le film Nosferatu de F.W. Murnau d&eacute;crit et document&eacute; (205 Mo)</a> <a href="http://creativecommons.org/s/publicdomain/deed.fr" target="_blank"><img src="../res/img/creativecommons.jpg" alt="Creative Commons" /></a></li>\\012</ul>\\012</li>\\012</ul>\\012<ul>\\012<li><b>MAC</b> (voir la <a href="/lignes_de_temps_faq">FAQ</a> pour conna&icirc;tre votre configuration) :\\012<ul>\\012<li><a href="../apps/LignesDeTemps.0.10.7.ppc.dmg">Version 0.10.7 Power PC - OS 10.4 tiger (51 Mo)</a></li>\\012<li><a href="../apps/LignesdeTemps.0.10.7.intel.dmg">Version 0.10.7 Intel - OS 10.5 leopard (21 Mo)</a></li>\\012</ul>\\012</li>\\012</ul>\\012<p align="justify">Une fois t&eacute;l&eacute;charg&eacute;, lancez l'installeur et suivez les &eacute;tapes propos&eacute;es. Une fois install&eacute;, importez un contenu vid&eacute;o (formats avi, mpg, mov ou flv) ou audio (mp3) en passant par le menu Fichier -&gt; Importer.</p>\\012<p align="justify">Notes importantes sur l'utilisation de &quot;Lignes de temps&quot;:</p>\\012<ul>\\012<li>En fonction de la puissance de votre ordinateur et de la taille du fichier, l'import peut durer de quelques minutes &agrave; plusieurs dizaines de minutes.</li>\\012<li>Cette version est une <u>version beta</u>, c'est-&agrave;-dire qu'elle contient encore des bogues. Malgr&eacute; tous nos efforts, il se peut donc que le logiciel soit instable et se bloque par moments, rendant la sauvegarde du travail impossible, et que certaines vid&eacute;os ne soient pas importables. Voir les <a href="faq_lignesdetemps.html">FAQ</a></li>\\012</ul>\\012<p align="justify">En savoir plus sur le logiciel : <a href="../res/media/flyer_ldt_fr.pdf" target="_blank">Flyer de pr&eacute;sentation</a>, <a href="../res/media/ldt_userguide_fr.pdf" target="_blank">mode d'emploi</a> et <a href="../res/media/license_lignesdetemps.txt" target="_blank">Licence</a>.</p>\\012<p align="justify">Vous pouvez acc&eacute;der directement &agrave; la <a href="http://web.iri.centrepompidou.fr/demo_entretiens_lignesdetemps.html">d&eacute;monstration</a> et &agrave; la consultation du film <a href="http://web.iri.centrepompidou.fr/lignesdetemps_nosferatu.html"><i>Nosferatu</i> de F.W. Murnau dans &quot;Lignes de temps&quot;</a>.</p>\\012<p align="justify">Pour toute information, feedback ou probl&egrave;me, <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a>.</p>\\012<p align="justify"><b>Plus d'information :</b>              <br />\\012&Agrave; ce premier stade d&rsquo;analyse permettant de parcourir le film plan par plan, peuvent s&rsquo;ajouter d&rsquo;autres param&egrave;tres &agrave; partir desquels il est possible de              construire d&rsquo;autres &laquo;lignes de temps&raquo; parall&egrave;les au d&eacute;roulement du film, et d&rsquo;orienter des explorations multiples, en fonction des &eacute;chelles de plan,              des mouvements de cam&eacute;ra, des entr&eacute;es et sorties de champ et potentiellement de toute forme objectivable. Autant de mani&egrave;res de multiplier les approches,              mais plus encore de visualiser, par comparaison et combinaison des crit&egrave;res de pertinence, des effets de sens, d&rsquo;actualiser, par exemple, des r&eacute;currences et des sym&eacute;tries.</p>\\012<p align="justify"><b>Pour appareiller les pratiques &laquo;amateurs&raquo; :</b>             <br />\\012D&rsquo;ores et d&eacute;j&agrave; des historiens, des critiques, des th&eacute;oriciens, des &eacute;tudiants d&rsquo;&eacute;coles d&rsquo;art et de cin&eacute;ma ont accept&eacute; de s&rsquo;emparer de ces outils pour              v&eacute;rifier des hypoth&egrave;ses qu&rsquo;ils avaient formul&eacute;es, pour en explorer de nouvelles et permettre, &agrave; travers ce travail, l&rsquo;expertise, la critique, l&rsquo;enrichissement,              voire le d&eacute;tournement de ces dispositifs. B&eacute;n&eacute;ficiant de l&rsquo;exp&eacute;rience d&rsquo;une communaut&eacute; experte en mati&egrave;re d&rsquo;analyse cin&eacute;matographique, de nouveaux cercles              d&rsquo;amateurs d&eacute;veloppent progressivement de nouvelles &laquo;pratiques&raquo; de Lignes de temps. C&rsquo;est notamment le cas des professeurs de l&rsquo;enseignement primaire              et secondaire (&eacute;coles, coll&egrave;ges, lyc&eacute;es) abordant l&rsquo;&eacute;tude du cin&eacute;ma et plus largement des cin&eacute;philes d&eacute;sireux de concr&eacute;tiser leur appr&eacute;hension              d&rsquo;un film, leurs souvenirs, leurs impressions, leurs r&eacute;flexions, sur un support appropri&eacute; &agrave; ces contenus temporels.</p>\\012<p align="justify"><a href="http://shotdetect.nonutc.fr" target="_blank">Le logiciel shotdetect d&eacute;velopp&eacute; par l'IRI : d&eacute;tection automatique de plans</a></p>\\012<p><a href="http://www.carrefourdespossibles.org/jsp/fiche_actualite.jsp?STNAV=&amp;RUBNAV=&amp;CODE=1210934670659&amp;LANGUE=0&amp;RH=DESCRIPTIF" target="_blank"><i>Lignes de temps</i> pr&eacute;sent&eacute; au Carrefour des possibles de la FING le 15 mai 2008</a></p>\\012<p><a href="http://www.culture.gouv.fr/culture/editions/r-cr.htm" target="_blank">Lire un article sur <i>Lignes de temps</i> dans le num&eacute;ro 112 de <i>Culture &amp; Recherche</i></a><br />\\012<a href="../res/media/ArticleAmateurs_V.Puig-nov08.pdf" target="_blank">Lire un article sur <i>Les amateurs du XXI&egrave;me si&egrave;cle</i> dont un extrait a paru dans le num&eacute;ro 118-119 de <i>Culture &amp; Recherche</i></a></p>\\012	1249137860	1249051460		0
2:c847cf34ab523c9e7d5c2018a406477d	<p><a href="/ma_ville_vue_par">Projet</a> - Etapes - G&eacute;n&eacute;rique</p>\\012<p><strong>De la th&eacute;orie&hellip;</strong> Dans un premier temps, les classes compl&egrave;tent l&rsquo;analyse du film de r&eacute;f&eacute;rence fourni sur le logiciel <i>Lignes de temps</i>. Les films correspondent &agrave; une double n&eacute;cessit&eacute;&nbsp;: ils sont le produit d&rsquo;un travail d&rsquo;auteur et montrent les choix auxquels les cin&eacute;astes&nbsp; sont confront&eacute;s&nbsp;; la ville y tient un r&ocirc;le en tant que &laquo;&nbsp;personnage&nbsp;&raquo;, sans jamais n&rsquo;&ecirc;tre qu&rsquo;une &laquo;&nbsp;option&nbsp;&raquo;. La  ville peut &ecirc;tre montr&eacute;e de fa&ccedil;on documentaire ou fantastique mais doit rester un lieu reconnaissable et descriptible. Espace &eacute;motionnel de rencontre entre le cin&eacute;aste et le spectateur, le film part &agrave; la d&eacute;couverte de la ville dans ses aspects les plus &eacute;tonnants et les plus quotidiens.</p>\\012<div>Apr&egrave;s visionnage, les &eacute;l&egrave;ves commentent leurs &eacute;motions face au film et vont &agrave; la recherche des &eacute;l&eacute;ments qui les ont suscit&eacute;es. Comment s&rsquo;op&egrave;re la transformation de l&rsquo;espace envahi par la  projection de la g&eacute;ographie mentale du cin&eacute;aste&nbsp;? Comment les &eacute;motions du r&eacute;alisateur passent-elles &agrave; travers l&rsquo;espace montr&eacute; pour arriver au spectateur&nbsp;? Comment peut-elle devenir le catalyseur des regards du cin&eacute;aste et du spectateur&nbsp;?...</div>\\012<div>Ces interpr&eacute;tations et r&eacute;flexions sur le film sont alors &eacute;chang&eacute;es entre classes partenaires via <i>Lignes de temps </i>sous forme de<i> bout-&agrave;-bouts</i>, occasion pour chacun d&rsquo;analyser les diff&eacute;rences de perception d&rsquo;une m&ecirc;me &oelig;uvre, d&rsquo;enrichir une analyse gr&acirc;ce au regard de l&rsquo;autre, de partager un point de vue critique, mais aussi &eacute;motionnel, sur une &oelig;uvre d&rsquo;art&hellip;</div>\\012<div>&nbsp;</div>\\012<div><strong>&hellip;&agrave; la pratique</strong> &Agrave; ce temps de r&eacute;flexion succ&egrave;de un temps de cr&eacute;ation, soit la r&eacute;alisation d&rsquo;un &laquo;&nbsp;film-essai&nbsp;&raquo; par les &eacute;l&egrave;ves de chaque classe. La classe &eacute;crit son projet, puis tourne un court-m&eacute;trage &agrave; partir de proc&eacute;d&eacute;s techniques de r&eacute;alisation, ou &laquo;&nbsp;cahier des charges&nbsp;&raquo;, d&eacute;finis par chaque enseignant en coop&eacute;ration avec son partenaire et en grande partie inspir&eacute;s de l&rsquo;analyse filmique du film de r&eacute;f&eacute;rence.</div>\\012<div>Il s&rsquo;agit par exemple de demander aux &eacute;l&egrave;ves de travailler sur une contrainte purement formelle, comme les &eacute;chelles de plans, ou bien th&eacute;matique (la foule, les toits, l&rsquo;architecture, les rues, les animaux dans la ville)&hellip; Les figures de style impos&eacute;es &eacute;tant identiques pour chaque partenaire du bin&ocirc;me afin d&rsquo;offrir une base de travail commune et de pouvoir clairement identifier les diff&eacute;rences de points de vue des r&eacute;alisateurs.</div>\\012<div>Plusieurs consignes de travail sont donn&eacute;es aux classes, telles que&nbsp;: montrer un monument ou un lieu repr&eacute;sentatif, voire &laquo;&nbsp;clich&eacute;&nbsp;&raquo;, de la&nbsp;ville et en proposer une solution filmique originale et personnelle.</div>\\012<div>La dur&eacute;e des rushes est limit&eacute;e &agrave; vingt minutes par classe.</div>\\012<div>Ces <i>rushes</i> sont ensuite d&eacute;rush&eacute;s (un premier choix de plans) puis d&eacute;crits sur <i>Lignes de temps</i> avant d&rsquo;&ecirc;tre envoy&eacute; &agrave; la classe partenaire. Les r&eacute;alisateurs prenant ainsi du recul sur leur propre exercice, tandis que les &eacute;l&egrave;ves de la classe partenaire peuvent analyser les plans de l&rsquo;autre et r&eacute;fl&eacute;chir sur les diverses &eacute;tapes de la cr&eacute;ation  cin&eacute;matographique.</div>\\012<div>Chaque classe se trouve alors en possession de deux fichiers de rushes&nbsp;: le sien propre, et celui de la classe associ&eacute;e. Deux montages seront alors effectu&eacute;s, offrant pour l&rsquo;un un regard personnel et affectif sur sa propre ville, et pour l&rsquo;autre une vision neuve et interpr&eacute;tative de celle du partenaire. Chaque filmmont&eacute; sera d&eacute;crit et index&eacute; sur <i>Lignes de temps</i> avant d&rsquo;&ecirc;tre envoy&eacute; &agrave; la classe partenaire, laquelle, &agrave; son tour, le commentera et le renverra &agrave; la classe r&eacute;alisatrice, selon le mod&egrave;le des &laquo;&nbsp;Regards sign&eacute;s&nbsp;&raquo; initi&eacute;s par l&rsquo;IRI.</div>\\012<div>En tout, chaque bin&ocirc;me produira, visionnera et montera le mat&eacute;riel de 4 courts-m&eacute;trages et les &eacute;tudiants pourront, &agrave; chaque &eacute;tape des &eacute;changes, en d&eacute;battre avec leurs enseignants. L&rsquo;analyse se nourrit de la discussion, parfois m&ecirc;me de la controverse, et le point de vue de l'autre est une aide pr&eacute;cieuse pour conforter ou amender sa propre opinion.</div>\\012<div>&nbsp;</div>\\012<div>Les chapitres majeurs de l&rsquo;exp&eacute;rience reposent sur un principe <b>d&rsquo;&eacute;changes</b> via <i>Lignes de temps</i> et tout autre moyen num&eacute;rique ou classique de correspondance, et ce, a chacune des &eacute;tapes du processus&nbsp;:</div>\\012<div>1/ Analyse d&rsquo;un film - <b>long m&eacute;trage de fiction, documentaire ou film exp&eacute;rimental.</b> Document&eacute; et comment&eacute; par des documentalistes de l&rsquo;IRI sur <i>Lignes de temps</i>, le film est transmis aux &eacute;coles qui, &agrave; leur tour enrichissent le descriptif. Dirig&eacute;s par Marta Boni (doctorante en cin&eacute;ma) des ateliers de prise en main du logiciel sont tenus dans les classes et amorcent le travail des bin&ocirc;mes.</div>\\012<div>2/ Echanges de points de vue entre partenaires par le biais du logiciel disponible en ligne ou en local.</div>\\012<div>3/ R&eacute;alisation de &laquo;&nbsp;films-essais&nbsp;&raquo;et de&laquo;&nbsp;films-regards&nbsp;&raquo;. Ces essais peuvent ou non s&rsquo;inspirer de la structure narrative ou formelle des films analys&eacute;s ou de tout autre principe sc&eacute;naristique d&eacute;gag&eacute; lors des discussions entre partenaires. Chaque groupe documente ses propres rushes dans&nbsp;<i>Lignes de temps</i> et les &eacute;change avec ceux de sonpartenaire&nbsp;:<b> deux films&nbsp;sont ainsi mont&eacute;s par chaque classe - le premier, le &laquo;&nbsp;film-essai&nbsp;&raquo; avec ses propres rushes, le second, le &laquo;&nbsp;film-regard&nbsp;&raquo; avec les rushes du partenaire.</b></div>\\012<div>Chaque film, une fois mont&eacute;, ne devant pas exc&eacute;der 10&rsquo;.</div>\\012<div>&nbsp;</div>\\012<div>Pr&eacute;sentations des exp&eacute;rimentations</div>\\012<div>&laquo;&nbsp;Ma ville vue par&hellip; Une &eacute;tape&nbsp;&raquo; Vendredi 15 mai 2009</div>\\012<div>&laquo;&nbsp;Ma ville vue par&hellip; / Etape 2&nbsp;&raquo; Jeudi 4 juin 2009</div>\\012<div>Centre Pompidou / Cin&eacute;ma 1 / 9h15&gt;13h30</div>\\012<div>Les travaux r&eacute;alis&eacute;s durant l&rsquo;ann&eacute;e scolaire 2008-2009, &laquo;&nbsp;Regards-sign&eacute;s&nbsp;&raquo; et &laquo;&nbsp;Films-essais&nbsp;&raquo; et les r&eacute;alis&eacute;s durant cette ann&eacute;e scolaire 2008-2009 ont &eacute;t&eacute; projet&eacute;s lors de journ&eacute;es de projection au Centre Pompidou. Les enseignants pr&eacute;sents accompagn&eacute;s de leurs &eacute;l&egrave;ves ont t&eacute;moign&eacute; de leurs relations de travail. Plus de 350 &eacute;l&egrave;ves, dont deux classes italiennes et une classe roumaine ont assist&eacute; &agrave; ces matin&eacute;es.</div>\\012<p>&nbsp;</p>\\012	1249382448	1249296048		0
2:c5bc6f2a4383c0fb239888e339976763	<p><a href="/ma_ville_vue_par">Projet</a> - Etapes - <a href="/ma_ville_vue_par/generique">G&eacute;n&eacute;rique</a> - <a href="/ma_ville_vue_par/binomes">Bin&ocirc;mes</a></p>\\012<p>&nbsp;</p>\\012<p><strong>De la th&eacute;orie&hellip;</strong> Dans un premier temps, les classes compl&egrave;tent l&rsquo;analyse du film de r&eacute;f&eacute;rence fourni sur le logiciel <i>Lignes de temps</i>. Les films correspondent &agrave; une double n&eacute;cessit&eacute;&nbsp;: ils sont le produit d&rsquo;un travail d&rsquo;auteur et montrent les choix auxquels les cin&eacute;astes&nbsp; sont confront&eacute;s&nbsp;; la ville y tient un r&ocirc;le en tant que &laquo;&nbsp;personnage&nbsp;&raquo;, sans jamais n&rsquo;&ecirc;tre qu&rsquo;une &laquo;&nbsp;option&nbsp;&raquo;. La  ville peut &ecirc;tre montr&eacute;e de fa&ccedil;on documentaire ou fantastique mais doit rester un lieu reconnaissable et descriptible. Espace &eacute;motionnel de rencontre entre le cin&eacute;aste et le spectateur, le film part &agrave; la d&eacute;couverte de la ville dans ses aspects les plus &eacute;tonnants et les plus quotidiens.</p>\\012<div>Apr&egrave;s visionnage, les &eacute;l&egrave;ves commentent leurs &eacute;motions face au film et vont &agrave; la recherche des &eacute;l&eacute;ments qui les ont suscit&eacute;es. Comment s&rsquo;op&egrave;re la transformation de l&rsquo;espace envahi par la  projection de la g&eacute;ographie mentale du cin&eacute;aste&nbsp;? Comment les &eacute;motions du r&eacute;alisateur passent-elles &agrave; travers l&rsquo;espace montr&eacute; pour arriver au spectateur&nbsp;? Comment peut-elle devenir le catalyseur des regards du cin&eacute;aste et du spectateur&nbsp;?...</div>\\012<div>Ces interpr&eacute;tations et r&eacute;flexions sur le film sont alors &eacute;chang&eacute;es entre classes partenaires via <i>Lignes de temps </i>sous forme de<i> bout-&agrave;-bouts</i>, occasion pour chacun d&rsquo;analyser les diff&eacute;rences de perception d&rsquo;une m&ecirc;me &oelig;uvre, d&rsquo;enrichir une analyse gr&acirc;ce au regard de l&rsquo;autre, de partager un point de vue critique, mais aussi &eacute;motionnel, sur une &oelig;uvre d&rsquo;art&hellip;</div>\\012<div>&nbsp;</div>\\012<div><strong>&hellip;&agrave; la pratique</strong> &Agrave; ce temps de r&eacute;flexion succ&egrave;de un temps de cr&eacute;ation, soit la r&eacute;alisation d&rsquo;un &laquo;&nbsp;film-essai&nbsp;&raquo; par les &eacute;l&egrave;ves de chaque classe. La classe &eacute;crit son projet, puis tourne un court-m&eacute;trage &agrave; partir de proc&eacute;d&eacute;s techniques de r&eacute;alisation, ou &laquo;&nbsp;cahier des charges&nbsp;&raquo;, d&eacute;finis par chaque enseignant en coop&eacute;ration avec son partenaire et en grande partie inspir&eacute;s de l&rsquo;analyse filmique du film de r&eacute;f&eacute;rence.</div>\\012<div>Il s&rsquo;agit par exemple de demander aux &eacute;l&egrave;ves de travailler sur une contrainte purement formelle, comme les &eacute;chelles de plans, ou bien th&eacute;matique (la foule, les toits, l&rsquo;architecture, les rues, les animaux dans la ville)&hellip; Les figures de style impos&eacute;es &eacute;tant identiques pour chaque partenaire du bin&ocirc;me afin d&rsquo;offrir une base de travail commune et de pouvoir clairement identifier les diff&eacute;rences de points de vue des r&eacute;alisateurs.</div>\\012<div>Plusieurs consignes de travail sont donn&eacute;es aux classes, telles que&nbsp;: montrer un monument ou un lieu repr&eacute;sentatif, voire &laquo;&nbsp;clich&eacute;&nbsp;&raquo;, de la&nbsp;ville et en proposer une solution filmique originale et personnelle.</div>\\012<div>La dur&eacute;e des rushes est limit&eacute;e &agrave; vingt minutes par classe.</div>\\012<div>Ces <i>rushes</i> sont ensuite d&eacute;rush&eacute;s (un premier choix de plans) puis d&eacute;crits sur <i>Lignes de temps</i> avant d&rsquo;&ecirc;tre envoy&eacute; &agrave; la classe partenaire. Les r&eacute;alisateurs prenant ainsi du recul sur leur propre exercice, tandis que les &eacute;l&egrave;ves de la classe partenaire peuvent analyser les plans de l&rsquo;autre et r&eacute;fl&eacute;chir sur les diverses &eacute;tapes de la cr&eacute;ation  cin&eacute;matographique.</div>\\012<div>Chaque classe se trouve alors en possession de deux fichiers de rushes&nbsp;: le sien propre, et celui de la classe associ&eacute;e. Deux montages seront alors effectu&eacute;s, offrant pour l&rsquo;un un regard personnel et affectif sur sa propre ville, et pour l&rsquo;autre une vision neuve et interpr&eacute;tative de celle du partenaire. Chaque filmmont&eacute; sera d&eacute;crit et index&eacute; sur <i>Lignes de temps</i> avant d&rsquo;&ecirc;tre envoy&eacute; &agrave; la classe partenaire, laquelle, &agrave; son tour, le commentera et le renverra &agrave; la classe r&eacute;alisatrice, selon le mod&egrave;le des &laquo;&nbsp;Regards sign&eacute;s&nbsp;&raquo; initi&eacute;s par l&rsquo;IRI.</div>\\012<div>En tout, chaque bin&ocirc;me produira, visionnera et montera le mat&eacute;riel de 4 courts-m&eacute;trages et les &eacute;tudiants pourront, &agrave; chaque &eacute;tape des &eacute;changes, en d&eacute;battre avec leurs enseignants. L&rsquo;analyse se nourrit de la discussion, parfois m&ecirc;me de la controverse, et le point de vue de l'autre est une aide pr&eacute;cieuse pour conforter ou amender sa propre opinion.</div>\\012<div>&nbsp;</div>\\012<div>Les chapitres majeurs de l&rsquo;exp&eacute;rience reposent sur un principe <b>d&rsquo;&eacute;changes</b> via <i>Lignes de temps</i> et tout autre moyen num&eacute;rique ou classique de correspondance, et ce, a chacune des &eacute;tapes du processus&nbsp;:</div>\\012<div>1/ Analyse d&rsquo;un film - <b>long m&eacute;trage de fiction, documentaire ou film exp&eacute;rimental.</b> Document&eacute; et comment&eacute; par des documentalistes de l&rsquo;IRI sur <i>Lignes de temps</i>, le film est transmis aux &eacute;coles qui, &agrave; leur tour enrichissent le descriptif. Dirig&eacute;s par Marta Boni (doctorante en cin&eacute;ma) des ateliers de prise en main du logiciel sont tenus dans les classes et amorcent le travail des bin&ocirc;mes.</div>\\012<div>2/ Echanges de points de vue entre partenaires par le biais du logiciel disponible en ligne ou en local.</div>\\012<div>3/ R&eacute;alisation de &laquo;&nbsp;films-essais&nbsp;&raquo;et de&laquo;&nbsp;films-regards&nbsp;&raquo;. Ces essais peuvent ou non s&rsquo;inspirer de la structure narrative ou formelle des films analys&eacute;s ou de tout autre principe sc&eacute;naristique d&eacute;gag&eacute; lors des discussions entre partenaires. Chaque groupe documente ses propres rushes dans&nbsp;<i>Lignes de temps</i> et les &eacute;change avec ceux de sonpartenaire&nbsp;:<b> deux films&nbsp;sont ainsi mont&eacute;s par chaque classe - le premier, le &laquo;&nbsp;film-essai&nbsp;&raquo; avec ses propres rushes, le second, le &laquo;&nbsp;film-regard&nbsp;&raquo; avec les rushes du partenaire.</b></div>\\012<div>Chaque film, une fois mont&eacute;, ne devant pas exc&eacute;der 10&rsquo;.</div>\\012<div>&nbsp;</div>\\012<div>Pr&eacute;sentations des exp&eacute;rimentations</div>\\012<div>&laquo;&nbsp;Ma ville vue par&hellip; Une &eacute;tape&nbsp;&raquo; Vendredi 15 mai 2009</div>\\012<div>&laquo;&nbsp;Ma ville vue par&hellip; / Etape 2&nbsp;&raquo; Jeudi 4 juin 2009</div>\\012<div>Centre Pompidou / Cin&eacute;ma 1 / 9h15&gt;13h30</div>\\012<div>Les travaux r&eacute;alis&eacute;s durant l&rsquo;ann&eacute;e scolaire 2008-2009, &laquo;&nbsp;Regards-sign&eacute;s&nbsp;&raquo; et &laquo;&nbsp;Films-essais&nbsp;&raquo; et les r&eacute;alis&eacute;s durant cette ann&eacute;e scolaire 2008-2009 ont &eacute;t&eacute; projet&eacute;s lors de journ&eacute;es de projection au Centre Pompidou. Les enseignants pr&eacute;sents accompagn&eacute;s de leurs &eacute;l&egrave;ves ont t&eacute;moign&eacute; de leurs relations de travail. Plus de 350 &eacute;l&egrave;ves, dont deux classes italiennes et une classe roumaine ont assist&eacute; &agrave; ces matin&eacute;es.</div>\\012<p>&nbsp;</p>\\012	1249384224	1249297824		0
2:6172e52b9b57f352f83f0c441e7561c8	<h3>Programmation des ateliers de l'IRI</h3>\\012<ul>\\012<li><a href="/ateliers/regards_signes_2009_2010">Atelier Regards sign&eacute;s</a></li>\\012<li><a href="ateliers/experimentations_pedagogiques">Ateliers avec l&rsquo;Education Nationale et films document&eacute;s et analys&eacute;s dans Lignes de temps</a></li>\\012<li><a href="/ateliers/ma_ville_vue_par">Atelier p&eacute;dagogique &laquo;Ma ville vue par...&raquo;</a></li>\\012<li><a href="/ateliers/lectures_signees">Atelier Lectures sign&eacute;es</a></li>\\012<li><a href="http://www.iri.centrepompidou.fr/seminaires/ihm.php">Atelier IHM 2007</a></li>\\012</ul>\\012<h3>L&rsquo;atelier de l&rsquo;IRI explore trois objets de recherche technologiques principaux :</h3>\\012<p align="justify">ING&Eacute;NIERIE DES CONNAISSANCES ET ING&Eacute;NIERIE DOCUMENTAIRE DANS LES APPAREILS CRITIQUES<br />\\012&nbsp;&nbsp;&nbsp;&nbsp;L&rsquo;IRI &eacute;tudie, con&ccedil;oit et d&eacute;veloppe des outils d'annotation et des appareils critiques d&rsquo;un nouveau genre, bas&eacute;s sur la combinaison d&rsquo;architectures documentaires et de m&eacute;tadonn&eacute;es avec des interfaces de navigation hyperm&eacute;dia, des modules algorithmiques de d&eacute;tection du signal et des modules de repr&eacute;sentation de donn&eacute;es (cartographie). Le fruit de ces recherches est r&eacute;guli&egrave;rement int&eacute;gr&eacute; au logiciel Lignes de temps, plateforme d&rsquo;annotation en ligne et hors ligne pour l'annotation d&rsquo;objets temporels (films, enregistrements audio). Les recherches dans ce domaine sont &eacute;tendues progressivement au domaine de l&rsquo;annotation du langage oral et &eacute;crit et &agrave; l&rsquo;annotation d'images.</p>\\012<p align="justify">TECHNOLOGIES COLLABORATIVES<br />\\012&nbsp;&nbsp;&nbsp;&nbsp;L&rsquo;IRI m&egrave;ne une s&eacute;rie de recherches et d&rsquo;exp&eacute;rimentations notamment sur le concept de &laquo;Lectures sign&eacute;es collaboratives&raquo; combinant modes d&rsquo;annotations h&eacute;rit&eacute;s du livre et encore inexistants sur le web et nouveaux paradigmes pour le travail collaboratif. Un aspect important de ce th&egrave;me est &eacute;videmment la mise au point de technologies de suivi et d&rsquo;administration d&rsquo;&eacute;changes, de d&eacute;bats et de pol&eacute;miques appuy&eacute;s sur les langages d&rsquo;annotation mentionn&eacute;s dans l&rsquo;axe pr&eacute;c&eacute;dent. Cet objet de recherche recouvre en fait toutes les technologies d&rsquo;individuation psychique et collective et concerne &agrave; la fois les technologies de lecture active (lecture / &eacute;criture), les technologies de transcription permettant de passer du discours oral au discours &eacute;crit par exemple, et les outils de gestion de cercles.</p>\\012<p align="justify">INTERFACES MULTIMODALES ET MOBILIT&Eacute; DANS LES PRATIQUES INSTRUMENT&Eacute;ES<br />\\012&nbsp;&nbsp;&nbsp;&nbsp;La motricit&eacute; est un &eacute;l&eacute;ment capital de la capacit&eacute; du jugement : c&rsquo;est souvent en r&eacute;p&eacute;tant et en &laquo;gestualisant&raquo; une forme symbolique que l&rsquo;on peut le mieux l&rsquo;appr&eacute;hender. On vise particuli&egrave;rement dans cet axe l&rsquo;&eacute;tude et le d&eacute;veloppement de nouveaux dispositifs d&rsquo;adresse au public utilisant les dispositifs mobiles notamment dans le contexte mus&eacute;al, les interfaces multimodales (ou poly-sensorielles et notamment les techniques de d&eacute;tection du geste ou du regard) et plus g&eacute;n&eacute;ralement les questions de design num&eacute;rique qui se posent dans ce contexte.</p>\\012	1249393697	1249307297		0
2:49d5484734f2949246586554c152f02a	<p class="rteright"><a href="/lignes_de_temps_faq">Version fran&ccedil;aise</a></p>\\012<p>The software <i>Lignes de temps</i> is divided in two parts: system and interface.           <br />\\012The first one is not visible for users; it allows to record the work done (notes, sequences, rough-cut) in a file. It also permits to launch programs necessary to import an audio or video file. These programs encode video in order that it can be visible in the interface and that it can produce the shot by shot and the sound wave. <br />\\012The interface is composed by all the elements visible and controlled by users. It is composed by the top left menu (File, Display) and by three windows: Informations, the media player, and the one who displays the lignes de temps. <br />\\012The two parts of the program are connected but the communication can sometimes be interrupted, without any notification. In this case, the work can not unfortunately be recorded. The Institute for research and innovation works on those different problems. For any information, feedback or problem : <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a><br />\\012A work on <i>Lignes de temps</i> is saved in a project file (ldt extension) which holds references towards the media used and the personal data (notes, sequences, rough-cut). The non-personal data on one media (shot by shot and sound wave for example) are recorded in an iri extension file.</p>\\012<ul>\\012<li><b>I use a Mac, how can I know which is my configuration ?</b><br />\\012    To know if your computer is &quot;Intel&quot; or &quot;Power PC&quot;, you have to go in the Apple menu up left on the screen. In the menu, click on &quot;About this Mac&quot;. The line &quot;Processor&quot; indicates the type of configuration &quot;Intel&quot; or &quot;Power PC&quot;.<br />\\012    After many tests, it seems that <i>Lignes de temps</i> just settles on the computers with the operating system 10.5 called &quot;leopard&quot;, the 10.4 one called &quot;tiger&quot;, the Intel processor, or with the Power PC processor.</li>\\012<li><b>I do not succeed in displaying movies :</b><br />\\012    To display those lignes de temps, you have to click on the movie title in the lignes de temps window then on the tab &quot;Cuttings&quot;. In this tab, appears the list of the available sequences; you just have to click on one of them to display the corresponding ligne de temps.</li>\\012<li><b>I do not succeed in importing an audio or video file :</b><br />\\012    You have to make sure that the file extension can match. <i>Lignes de temps</i> takes into account avi, mpg, mov, flv extension for video and mp3 for audio. Then, even if this one is accepted, the encoding can not match with the program (ffmpeg) which transforms this file in a video readable in <i>Lignes de temps</i>, that is to say in the flv format. Even if the file extension is correct, some characters block the import. Thus, you should prefer naming your file without the following characters : accented characters, space, &ccedil;, #, &amp;, %, !, *, (), [], |, {}, :, ;, @.</li>\\012<li><b>I do not succeed in saving my work :</b><br />\\012    As it is explained in the introduction, this problem can come from a communication failure between the interface and the program part which records the work in a file. To record the works, we can go through the up left menu (Fichier -- Enregistrer) or through the hot key Ctrl+S on PCs and Apple+S on Macs. In general, when a work has been modified since the last recording, a star appears close the movie title in order to warn about a required recording.</li>\\012</ul>\\012<p>&nbsp;</p>\\012<p><b>Release notes about Lignes de temps 0.10.8 :</b></p>\\012<ul>\\012<li>Possibility to display the video in fullscreen with black background</li>\\012<li>Possibility to display a permalink for a segment</li>\\012<li>Possibility to display subtitles from an external TimedText XML file.</li>\\012<li>Possibility to display all the annotations (title and description) from one timeline in a large text field, fitted with a quick search module</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps from 0.10.4 to 0.10.7 :</b></p>\\012<ul>\\012<li>Possibility to import cuttings from an other ldt file</li>\\012<li>Possibility to stream a video with rtmp://...</li>\\012<li>Possibility to move timelines and contents by simple drag and drop</li>\\012<li>Ergonomic improvements (ldt file name int the information window, zoom more fluid, possibility to save our default language)</li>\\012<li>Possibility to duplicate a timeline's highlighted segments</li>\\012<li>Debug</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.10.3 :</b></p>\\012<ul>\\012<li>Japanese language added</li>\\012<li>Debug</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.10 :</b></p>\\012<ul>\\012<li>MULTILINGUAL INTERFACE with English and French available by default and possibility to add some languages by yourself (the steps are explained in the <a target="_blank" href="/res/media/ldt_userguide_en.pdf">user guide</a> thanks to the GETTEXT tool)</li>\\012<li>Interface and ergonomy completely rebuilt, with for exemple buttons with icons, new tabs more visible, tool tips, confirmation messages before deleting.</li>\\012<li>Views : rename and move by drag and drop.</li>\\012<li>Tags : the complete project's tags list can be displayed from the top left menu or the shortcut Shift + T.</li>\\012<li>Note taking : better management of scroll position, timecode indicated on seperator roll over.</li>\\012<li>Bout &agrave; bout (edit) : an edit can now be deleted.</li>\\012<li>Bug <a target="_blank" href="/dev/trac/ldt">trac</a> added.</li>\\012<li>Complete user guide in <a target="_blank" href="/res/media/ldt_userguide_fr.pdf">french</a> and <a target="_blank" href="/res/media/ldt_userguide_en.pdf">english</a>.</li>\\012<li>License added in the &quot;About&quot;.</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.9.4 :</b></p>\\012<ul>\\012<li>New note-taking functionnality, enabling to write notes on the fly, then to transform them into a cutting.</li>\\012<li>Views : the display states backup includes now the zoom level, the horizontal scroll position and if a &quot;bout &agrave; bout&quot; is playing.</li>\\012<li>Improvement of tags addition : possibility to display a window with all the timeline's tags and to add one of them by simple click.</li>\\012<li>Possibility to display all the project's tags in a large window thanks to the shortcut Shift + F.</li>\\012<li>Possibility to highlight the segments by clicking one of the timeline's tags. 5 colors are available (one per tag), then requested segments are displayed in white.</li>\\012<li>Possibility to duplicate a timeline from highlighted segments only.</li>\\012<li>Possibility to create a bout &agrave; bout from a complete timeline or highlighted segments.</li>\\012<li>Addition of error messages when the software crashes. They limit the risk of work loss.</li>\\012</ul>\\012<p>\\012<b>Release notes about Lignes de temps 0.9.2 :</b></p>\\012<ul>\\012<li>Possibility of duplicating any line (duplication button in the Informations window).</li>\\012<li>Presence of the tag field for segments.</li>\\012<li>Possibility of displaying a sequence's summary, that is to say the sequences'list as a clickable text.</li>\\012<li>Debug of identified bugs in the previous version.</li>\\012<li>Interface's modifications : the &quot;Informations&quot; window enlarged in height and width, and the read-out window enlarged in width.</li>\\012</ul>\\012<p>&nbsp;</p>\\012	1250159285	1250072885		0
2:2c35747ae5f8cc42317bb8cb966c925e	<ul>\\012<li><a href="/telecharger_lignes_de_temps">T&eacute;l&eacute;charger Lignes De Temps</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire">S&eacute;minaires index&eacute;s dans Lignes De Temps</a>\\012<ul> <font size="1">\\012<ul>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/1">Figures de l'amateur</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/6">Mus&eacute;ologie 2007-2008</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/8">Mus&eacute;ologie 2008-2009</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/9">Politiques et technologies de l&rsquo;amateur</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/10">THD Cap Digital</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/11">Nanotechnologies</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/12">Modernisation</a></li>\\012</ul>\\012<p>        </p></font>     </ul>\\012</li>\\012<li><a href="http://www.iri.centrepompidou.fr/privatedoc/">S&eacute;minaires en audio</a></li>\\012<li><a target="_blank" href="http://www.thdculture.fr">THD Culture</a></li>\\012<li><a href="http://amateur.iri.centrepompidou.fr/nouveaumonde/enmi/conf/">Entretiens du Nouveau Monde Industriel</a></li>\\012<li><a href="/espaces_critiques">Espaces critiques</a></li>\\012</ul>\\012	1250587092	1250500692		0
2:b8ea74756d78daec1e8f55761f87b6cd	<ul>\\012<li><a href="/agenda">Agenda</a></li>\\012<li><a href="/ateliers">Ateliers</a></li>\\012<li><a href="/seminaires">S&eacute;minaires</a></li>\\012<li><a href="/colloques">Colloques</a></li>\\012<li><a href="/inscriptions">Inscriptions</a></li>\\012</ul>\\012	1250592957	1250506557		0
2:b608bffc45d5838425aa38366cf172c9	<p><img height="226" width="100%" alt="" src="/res/img/ldt.jpg" /></p>\\012<p align="justify"><a href="../res/img/ldt_300dpi.jpg">Copie d'&eacute;cran de Lignes de temps en 300 dpi</a></p>\\012<p align="justify">Le logiciel Lignes de temps met &agrave; profit les possibilit&eacute;s d&rsquo;analyse et de synth&egrave;se offertes par le support num&eacute;rique. Inspir&eacute;es par les &laquo;timelines&raquo; ordinairement utilis&eacute;es sur les bancs de montage num&eacute;rique, Lignes de temps propose une repr&eacute;sentation graphique d&rsquo;un film, r&eacute;v&eacute;lant d&rsquo;embl&eacute;e, et in extenso, son d&eacute;coupage. Lignes de temps offre en cela un acc&egrave;s in&eacute;dit au film, en substituant &agrave; la logique du d&eacute;filement contraint qui constitue l&rsquo;exp&eacute;rience de tout spectateur de cin&eacute;ma, et pour les besoins de l&rsquo;analyse, la &laquo;cartographie&raquo; d&rsquo;un objet temporel. Aussi, en s&eacute;lectionnant un segment d&rsquo;une ligne de temps, l&rsquo;utilisateur a-t-il acc&egrave;s directement au plan ou &agrave; la s&eacute;quence correspondante dans le film, s&eacute;quence qui peut &ecirc;tre d&eacute;crite et analys&eacute;e par des commentaires textuels, audio, vid&eacute;o, ou document&eacute;e par des images ou des liens Internet.<a href="#more"><br />\\012</a></p>\\012<h3>T&Eacute;L&Eacute;CHARGEMENT de <i>Lignes de temps</i> :</h3>\\012<p><a href="/lignes_de_temps_faq">? FAQ ?</a></p>\\012<p align="justify">T&eacute;l&eacute;charger d&egrave;s maintenant le logiciel &quot;Lignes de temps&quot;. Gr&acirc;ce &agrave; lui, analysez et annotez les films de votre choix.</p>\\012<ul>\\012<li><b>PC</b> :\\012<ul>\\012<li><a href="../apps/LignesDeTemps-0.10.7-Setup.exe">Version 0.10.7 simple (35 Mo)</a></li>\\012<li><a href="../apps/LignesDeTempsNosferatu-0.10.7-Setup.exe">Version 0.10.7 contenant le film Nosferatu de F.W. Murnau d&eacute;crit et document&eacute; (205 Mo)</a> <a href="http://creativecommons.org/s/publicdomain/deed.fr" target="_blank"><img src="../res/img/creativecommons.jpg" alt="Creative Commons" /></a></li>\\012</ul>\\012</li>\\012</ul>\\012<ul>\\012<li><b>MAC</b> (voir la <a href="faq_lignesdetemps.html">FAQ</a> pour conna&icirc;tre votre configuration) :\\012<ul>\\012<li><a href="../apps/LignesDeTemps.0.10.7.ppc.dmg">Version 0.10.7 Power PC - OS 10.4 tiger (51 Mo)</a></li>\\012<li><a href="../apps/LignesdeTemps.0.10.7.intel.dmg">Version 0.10.7 Intel - OS 10.5 leopard (21 Mo)</a></li>\\012</ul>\\012</li>\\012</ul>\\012<p align="justify">Une fois t&eacute;l&eacute;charg&eacute;, lancez l'installeur et suivez les &eacute;tapes propos&eacute;es. Une fois install&eacute;, importez un contenu vid&eacute;o (formats avi, mpg, mov ou flv) ou audio (mp3) en passant par le menu Fichier -&gt; Importer.</p>\\012<p align="justify">Notes importantes sur l'utilisation de &quot;Lignes de temps&quot;:</p>\\012<ul>\\012<li>En fonction de la puissance de votre ordinateur et de la taille du fichier, l'import peut durer de quelques minutes &agrave; plusieurs dizaines de minutes.</li>\\012<li>Cette version est une <u>version beta</u>, c'est-&agrave;-dire qu'elle contient encore des bogues. Malgr&eacute; tous nos efforts, il se peut donc que le logiciel soit instable et se bloque par moments, rendant la sauvegarde du travail impossible, et que certaines vid&eacute;os ne soient pas importables. Voir les <a href="faq_lignesdetemps.html">FAQ</a></li>\\012</ul>\\012<p align="justify">En savoir plus sur le logiciel : <a href="../res/media/flyer_ldt_fr.pdf" target="_blank">Flyer de pr&eacute;sentation</a>, <a href="../res/media/ldt_userguide_fr.pdf" target="_blank">mode d'emploi</a> et <a href="../res/media/license_lignesdetemps.txt" target="_blank">Licence</a>.</p>\\012<p align="justify">Vous pouvez acc&eacute;der directement &agrave; la <a href="http://web.iri.centrepompidou.fr/demo_entretiens_lignesdetemps.html">d&eacute;monstration</a> et &agrave; la consultation du film <a href="http://web.iri.centrepompidou.fr/lignesdetemps_nosferatu.html"><i>Nosferatu</i> de F.W. Murnau dans &quot;Lignes de temps&quot;</a>.</p>\\012<p align="justify">Pour toute information, feedback ou probl&egrave;me, <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a>.</p>\\012<p align="justify"><b>Plus d'information :</b>              <br />\\012&Agrave; ce premier stade d&rsquo;analyse permettant de parcourir le film plan par plan, peuvent s&rsquo;ajouter d&rsquo;autres param&egrave;tres &agrave; partir desquels il est possible de              construire d&rsquo;autres &laquo;lignes de temps&raquo; parall&egrave;les au d&eacute;roulement du film, et d&rsquo;orienter des explorations multiples, en fonction des &eacute;chelles de plan,              des mouvements de cam&eacute;ra, des entr&eacute;es et sorties de champ et potentiellement de toute forme objectivable. Autant de mani&egrave;res de multiplier les approches,              mais plus encore de visualiser, par comparaison et combinaison des crit&egrave;res de pertinence, des effets de sens, d&rsquo;actualiser, par exemple, des r&eacute;currences et des sym&eacute;tries.</p>\\012<p align="justify"><b>Pour appareiller les pratiques &laquo;amateurs&raquo; :</b>             <br />\\012D&rsquo;ores et d&eacute;j&agrave; des historiens, des critiques, des th&eacute;oriciens, des &eacute;tudiants d&rsquo;&eacute;coles d&rsquo;art et de cin&eacute;ma ont accept&eacute; de s&rsquo;emparer de ces outils pour              v&eacute;rifier des hypoth&egrave;ses qu&rsquo;ils avaient formul&eacute;es, pour en explorer de nouvelles et permettre, &agrave; travers ce travail, l&rsquo;expertise, la critique, l&rsquo;enrichissement,              voire le d&eacute;tournement de ces dispositifs. B&eacute;n&eacute;ficiant de l&rsquo;exp&eacute;rience d&rsquo;une communaut&eacute; experte en mati&egrave;re d&rsquo;analyse cin&eacute;matographique, de nouveaux cercles              d&rsquo;amateurs d&eacute;veloppent progressivement de nouvelles &laquo;pratiques&raquo; de Lignes de temps. C&rsquo;est notamment le cas des professeurs de l&rsquo;enseignement primaire              et secondaire (&eacute;coles, coll&egrave;ges, lyc&eacute;es) abordant l&rsquo;&eacute;tude du cin&eacute;ma et plus largement des cin&eacute;philes d&eacute;sireux de concr&eacute;tiser leur appr&eacute;hension              d&rsquo;un film, leurs souvenirs, leurs impressions, leurs r&eacute;flexions, sur un support appropri&eacute; &agrave; ces contenus temporels.</p>\\012<p align="justify"><a href="http://shotdetect.nonutc.fr" target="_blank">Le logiciel shotdetect d&eacute;velopp&eacute; par l'IRI : d&eacute;tection automatique de plans</a></p>\\012<p><a href="http://www.carrefourdespossibles.org/jsp/fiche_actualite.jsp?STNAV=&amp;RUBNAV=&amp;CODE=1210934670659&amp;LANGUE=0&amp;RH=DESCRIPTIF" target="_blank"><i>Lignes de temps</i> pr&eacute;sent&eacute; au Carrefour des possibles de la FING le 15 mai 2008</a></p>\\012<p><a href="http://www.culture.gouv.fr/culture/editions/r-cr.htm" target="_blank">Lire un article sur <i>Lignes de temps</i> dans le num&eacute;ro 112 de <i>Culture &amp; Recherche</i></a><br />\\012<a href="../res/media/ArticleAmateurs_V.Puig-nov08.pdf" target="_blank">Lire un article sur <i>Les amateurs du XXI&egrave;me si&egrave;cle</i> dont un extrait a paru dans le num&eacute;ro 118-119 de <i>Culture &amp; Recherche</i></a></p>\\012	1249136779	1249050379		0
2:dc3ad1878ed7c41919ad8266b40e25f8	<p>Contenu &agrave; venir</p>\\012	1249138745	1249052345		0
2:04674dbbe3c36db8d2e1d89c03c6553a	<p>Projet - <a href="/ma_ville_vue_par/etapes">Etapes</a> - G&eacute;n&eacute;rique</p>\\012<p><strong>Un projet d&rsquo;&eacute;changes culturels entre&nbsp; jeunes de la Communaut&eacute; europ&eacute;enne / 2008-2009</strong><br />\\012&laquo; Films-essais &raquo; / &laquo; Films-regards &raquo; / &laquo; Regards sign&eacute;s Lignes de temps &raquo; / D&eacute;bats&hellip;</p>\\012<p>2008 &ndash; Ann&eacute;e europ&eacute;enne du dialogue interculturel<br />\\0122009 &ndash; Ann&eacute;e europ&eacute;enne de la cr&eacute;ativit&eacute; et de l&rsquo;innovation</p>\\012<p><strong>Regards crois&eacute;s sur la ville, &eacute;changes de points de vue, cr&eacute;ation&hellip; </strong><br />\\012&nbsp;&laquo; Ma ville vue par&hellip;&nbsp; &raquo; vise &agrave; encourager l&rsquo;&eacute;change culturel entre jeunes gens de l&rsquo;Union europ&eacute;enne via une approche analytique et cr&eacute;ative du cin&eacute;ma.</p>\\012<p><strong>Une collaboration</strong><br />\\012Centre Pompidou / Institut de recherche et d&rsquo;innovation / Maison du geste et de l&rsquo;image</p>\\012<p><strong>Liens :</strong><br />\\012<a target="_blank" href="http://www.mgi-paris.org/site2009/index.php">http://www.mgi-paris.org/site2009/index.php</a><br />\\012<a target="_blank" href="http://www.centrepompidou.fr/">http://www.centrepompidou.fr/</a></p>\\012<p><strong>Etablissements europ&eacute;ens partenaires</strong><br />\\012Berufskolleg, Herzogenrath, (Allemagne)<br />\\012Colegiul national B.P. Hasdeu, Buzau (Roumanie)<br />\\012Colegiul national I. C. Bratianu, Pitesti (Roumanie)<br />\\012Colegiul national Mihai Eminescu, Iasi (Roumanie)<br />\\012Colegiul national Radu Negru, Fagaras (Roumanie) <br />\\012Coll&egrave;ge Thomas Mann, Paris 13&egrave;me (France)<br />\\012Coll&egrave;ge Darius Milhaud, Sartrouville (France)<br />\\012Coll&egrave;ge Jean Moulin, Paris 14&egrave;me (France)<br />\\012Ecole &agrave; aires ouvertes Saint-Merri et Renard, Paris 4&egrave;me (France)<br />\\012Ecole &eacute;l&eacute;mentaire Maurice Genevoix, Paris 18&egrave;me (France)<br />\\012Liceo classico M. Gioia, Piacenza (Italie) <br />\\012Lyc&eacute;e Maurice Ravel, Paris 20&egrave;me (France)<br />\\012Lyc&eacute;e Paul Val&eacute;ry, Paris 12&egrave;me (France)<br />\\012Scuola centrala n&deg; 10, Bucarest (Roumanie)<br />\\012Scuola media Irnerio, Bologne (Italie)<br />\\012&nbsp;</p>\\012<p>&nbsp;</p>\\012<div>Le projet europ&eacute;en &laquo;&nbsp;Ma ville vue par&hellip;&nbsp;&raquo; a &eacute;t&eacute; initi&eacute; dans le cadre du <b>D&eacute;partement du d&eacute;veloppement culturel / Centre Pompidou</b> en mai 2008. Il fait suite au travail d&rsquo;exp&eacute;rimentation sur le cin&eacute;ma avec le logiciel <i>Lignes de temps</i><span> men&eacute; lors de la programmation au Centre Pompidou des films de V&iacute;ctor Erice et d&rsquo;Abbas Kiarostami. </span></div>\\012<div>Fond&eacute;<span> en avril 2006 au sein du DDC-Centre Pompidou et constitu&eacute; en association depuis ao&ucirc;t 2008, <b>l</b><b>'Institut de recherche et d'innovation</b></span> travaille sur l'&eacute;tude et le d&eacute;veloppement de technologies culturelles et <span>cognitives favorisant l'&eacute;mergence de nouvelles pratiques amateurs. L&rsquo;Iri met librement &agrave; la disposition du public le logiciel <i>Lignes de temps,</i> accompagn&eacute; pour ce type de projet, d&rsquo;une analyse document&eacute;e et comment&eacute;e des films &eacute;tudi&eacute;s. </span></div>\\012<div>La <b>Maison du geste et de l&rsquo;image</b>, centre de recherche et d&rsquo;&eacute;ducation artistique est aussi une structure de &laquo;&nbsp;m&eacute;diation&nbsp;&raquo; culturelle. Interm&eacute;diaire entre les &eacute;tablissements scolaires et culturels, la MGI accompagne et coordonne des projets, en initie, propose des formations et des pr&eacute;sentations li&eacute;es &agrave; l&rsquo;initiation artistique des publics jeunes. Il s&rsquo;agit de mettre ce public au contact direct de la  cr&eacute;ation et des cr&eacute;ateurs, de lui permettre de s&rsquo;engager dans une d&eacute;marche de cr&eacute;ation collective.</div>\\012<div>&nbsp;</div>\\012<div>Le cin&eacute;ma et la citoyennet&eacute; <b><span>Rencontres</span></b><b> europ&eacute;ennes&nbsp;; &eacute;changes culturels&nbsp;; partage de connaissance&nbsp;; &eacute;changes de points de vue&hellip;</b></div>\\012<div><b>&nbsp;</b></div>\\012<div>Le cin&eacute;ma et la ville<span>  &nbsp;Regards crois&eacute;s sur la ville, &eacute;changes de points de vue, cr&eacute;ation&nbsp;; </span>Innovation&nbsp;; d&eacute;couverte du langage cin&eacute;matographique&nbsp;; cr&eacute;ativit&eacute;&nbsp;; parcours guid&eacute; de cr&eacute;ation aux fins d&rsquo;une correspondance entre bin&ocirc;mes sous forme de production de &laquo;&nbsp;films-essais&nbsp;&raquo; sur sa propre ville (sc&eacute;narisation, tournage, montage)&nbsp;; exploration du point de vue d&rsquo;autrui &agrave; travers la relecture de son propre film par les autres&nbsp;(montage d&rsquo;un &laquo;&nbsp;film-regard&nbsp;&raquo; &agrave; partir des rushes produits par son partenaire)&nbsp;; projections des films&nbsp;; rencontres des participants&hellip;.</div>\\012<div>Le cin&eacute;ma entretient, depuis son origine, (Les fr&egrave;res Lumi&egrave;re&nbsp;: <i>L&rsquo;Arriv&eacute;e d&rsquo;un train en gare de la Ciotat</i>) un rapport privil&eacute;gi&eacute; avec la  ville. D&eacute;cor autant que personnage la ville occupe une place centrale dans bien des &oelig;uvres, &agrave; tel point que son image fictionnelle prend parfois le pas sur la r&eacute;alit&eacute;. Sa pr&eacute;sence impr&egrave;gne les films d&rsquo;une aura particuli&egrave;re et les place sous le sceau d&rsquo;une culture.</div>\\012<div>L&rsquo;espace urbain comprend une identit&eacute; forte, r&eacute;v&eacute;latrice du pays et de son histoire. Il incarne une culture tout enti&egrave;re. Et, si chacun entretient un rapport affectif avec sa propre ville, celle de l&rsquo;autre ne repr&eacute;sente trop souvent qu&rsquo;une carte postale, un souvenir ou un voyage imaginaire. Parler de sa ville &agrave; l&rsquo;autre, ou de la ville de l&rsquo;autre, c&rsquo;est partager une intimit&eacute;, une identit&eacute;, bien au-del&agrave; des clich&eacute;s. C&rsquo;est offrir un quotidien, un regard authentique sur sa vie. Par l&rsquo;&eacute;change des exp&eacute;riences et des regards, le cin&eacute;ma peut devenir le lieu d&rsquo;une telle rencontre.</div>\\012<div>&nbsp;</div>\\012<div>Les films de r&eacute;f&eacute;rence Les films propos&eacute;s &agrave; l&rsquo;analyse aux &eacute;l&egrave;ves partenaires du projet &nbsp;sont &laquo;&nbsp;Le Cam&eacute;raman&nbsp;&raquo; d&rsquo;Edward Sedgwick et Buster Keaton, avec Buster Keaton et &laquo;&nbsp;L&rsquo;Aurore&nbsp;&raquo; de Wilhelm Friedrich Murnau.</div>\\012<div>&nbsp;</div>\\012<div>Le Cam&eacute;raman</div>\\012<div>Etats-Unis 1928</div>\\012<div>Cor&eacute;alisation&nbsp;: Buster Keaton, Edward Sedgwick</div>\\012<div>Avec Buster Keaton, Marceline Day, Harold Goodwin</div>\\012<div align="left">Les aventures de Buster, photographe de rue, sp&eacute;cialis&eacute; dans les daguerr&eacute;otypes dans le New York des ann&eacute;es 20.</div>\\012<div><a target="_blank" href="http://fr.wikipedia.org/wiki/Le_Cameraman">http://fr.wikipedia.org/wiki/Le_Cameraman</a></div>\\012<div align="left"><a target="_blank" href="http://www.cineclubdecaen.com/realisat/keaton/cameraman.htm">http://www.cineclubdecaen.com/realisat/keaton/cameraman.htm</a></div>\\012<div align="left"><a target="_blank" href="http://www.critikat.com/Le-Cameraman.html">http://www.critikat.com/Le-Cameraman.html</a></div>\\012<div>&nbsp;</div>\\012<div>Sunrise&nbsp;- Aurore (L')</div>\\012<div>Etats-Unis, 1927</div>\\012<div>R&eacute;alisation&nbsp; Friedrich-Wilhelm Murnau</div>\\012<div>Sc&eacute;nario : Friedrich-Wilhelm Murnau d'apr&egrave;s <i><span>Le Voyage &agrave; Tilsitt</span></i> de Hermann S&uuml;dermann</div>\\012<div>Avec George O'Brien, Janet Gaynor, Margaret Livingstone, Bodil Rosing</div>\\012<div>Photo Karl Struss, Charles Rosher</div>\\012<div>Musique&nbsp;Dr Hugo Riesenfeld</div>\\012<div>Dur&eacute;e&nbsp;1h20</div>\\012<div>S&eacute;duit par une intrigante de la ville, un fermier tente de noyer son &eacute;pouse lors d'une promenade sur le lac. Pris de remords, il ne parvient pas &agrave; commettre son crime. La jeune femme s&rsquo;enfuit.</div>\\012<div><a target="_blank" href="http://fr.wikipedia.org/wiki/L%27Aurore_%28film,_1927%29">http://fr.wikipedia.org/wiki/L'Aurore_(film,_1927)</a></div>\\012<div><a target="_blank" href="http://www.abc-lefrance.com/fiches/Aurore.pdf">http://www.abc-lefrance.com/fiches/Aurore.pdf</a></div>\\012<div><a target="_blank" href="http://www.cineclubdecaen.com/realisat/murnau/aurore.htm">http://www.cineclubdecaen.com/realisat/murnau/aurore.htm</a>).</div>\\012<div><b>&nbsp;</b></div>\\012<div>Le r&eacute;seau d&rsquo;&eacute;tablissements scolaires constitu&eacute; &agrave; partir des partenariats d&eacute;j&agrave; engag&eacute;s lors du projet Erice-Kiarostami s&rsquo;est &eacute;tendu &agrave; l&rsquo;Europe. Il r&eacute;unit une quinzaine d&rsquo;&eacute;tablissements pour une vingtaine de bin&ocirc;mes de m&ecirc;me niveau et qui travaillent selon les cas dans ou hors temps scolaire.</div>\\012<div>&nbsp;</div>\\012<div>Les pays participants Allemagne, France, Italie, Roumanie&hellip;</div>\\012<div>&nbsp;</div>\\012<div>Les (bin&ocirc;mes Une fois form&eacute;s - groupe ou classe fran&ccedil;aise et groupe ou classe d&rsquo;un pays europ&eacute;en -, r&eacute;unis en fonction de l&rsquo;&acirc;ge, du niveau, ainsi que des demandes sp&eacute;cifiques des participants), la relation &nbsp;des partenaires s&rsquo;organise autour d&rsquo;une s&eacute;rie d&rsquo;&eacute;tapes envisag&eacute;es avec les enseignants.</div>\\012<p>&nbsp;</p>\\012	1249382475	1249296075		0
2:975b0697ed16e1961636a4db57a0cc92	<p><a href="/ma_ville_vue_par">Projet</a> - <a href="/ma_ville_vue_par/etapes">Etapes</a> - G&eacute;n&eacute;rique - <a href="/ma_ville_vue_par/binomes">Bin&ocirc;mes</a></p>\\012<p>&nbsp;</p>\\012<p>&nbsp;</p>\\012<h4>PARTENAIRES</h4>\\012<div>&nbsp;</div>\\012<div>Ce projet a pu &ecirc;tre men&eacute; &agrave; bien gr&acirc;ce &agrave; l&rsquo;aide pr&eacute;cieuse de</div>\\012<div>L&rsquo;Ambassade de France en Roumanie, Bucarest</div>\\012<div>Le Centre culturel su&eacute;dois, Paris</div>\\012<div>L&rsquo;Institut culturel roumain, Paris</div>\\012<div>L&rsquo;Institut fran&ccedil;ais, Berlin</div>\\012<div>La Mairie de Paris / Mission cin&eacute;ma</div>\\012<div>Le Rectorat de Paris / Dareic et Mission innovation</div>\\012<div>&nbsp;</div>\\012<div><a href="http://www.ambafrance-ro.org/">http://www.ambafrance-ro.org/</a></div>\\012<div><a href="http://www.si.se/Centre-culturel-suedois/Francais/Centre-culturel-suedois/">http://www.si.se/Centre-culturel-suedois/Francais/Centre-culturel-suedois/</a></div>\\012<div><a href="http://www.institut-roumain.org/">http://www.institut-roumain.org/</a></div>\\012<div><a href="http://www.institut-francais.fr/">http://www.institut-francais.fr/</a></div>\\012<div><a target="_blank" href="http://www.paris.fr/portail/Culture/Portal.lut?page_id=8358&amp;document_type_id=5&amp;document_id=36017&amp;portlet_id=19409">http://www.paris.fr/portail/Culture/Portal.lut?page_id=8358&amp;document_type_id=5&amp;document_id=36017&amp;portlet_id=19409</a></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<h4>EQUIPE</h4>\\012<div><u><br />\\012</u></div>\\012<div>D&eacute;partement du d&eacute;veloppement culturel-Centre Pompidou,</div>\\012<div><b>Fr&eacute;d&eacute;rique Mirotchnikoff</b> direction du projet.</div>\\012<div>&nbsp;</div>\\012<div>Intervenants</div>\\012<div><b>Marta Boni</b> doctorante en cin&eacute;ma, direction des Ateliers <i>Lignes de temps.</i></div>\\012<div><b>Lila Pinell</b> r&eacute;alisatrice, membre de l&rsquo;association <i>b&eacute;tonsalon</i>, direction des tournages dans des &eacute;tablissements scolaires partenaires.</div>\\012<div><b>Aurore Frey</b> &eacute;tudiante en cin&eacute;ma</div>\\012<div>&nbsp;</div>\\012<div>Stagiaires</div>\\012<div><b>Esther Baucher</b></div>\\012<div><b>Elodie Bertrand</b></div>\\012<div><b>Sophie Besson</b></div>\\012<div><b>Ma&euml;lys Bourgoin</b></div>\\012<div><b>Laure Grimaldi</b></div>\\012<div><b>Alexandre Marques</b></div>\\012<div>&nbsp;</div>\\012<div>Institut de recherche et d&rsquo;innovation-Centre Pompidou</div>\\012<div><b>Bernard Stiegler</b><b>,</b> directeur</div>\\012<div><b>Vincent Puig</b><b>,</b> directeur-adjoint</div>\\012<div><b>Thibaut Cavali&eacute;</b>, chef de projet - ing&eacute;nieur logiciel <i>Lignes de temps</i></div>\\012<div><b>Fanny Belvisi,</b> charg&eacute;e d&rsquo;administration et de communication</div>\\012<div><b>Yves-Marie L&rsquo;Hour,</b> responsable &eacute;ditorial</div>\\012<div><b>Yves-Marie Haussonne</b>, chef de projet web</div>\\012<div>&nbsp;</div>\\012<div>Maison du geste et de l&rsquo;image</div>\\012<div><b>Evelyne Panato </b>directrice</div>\\012<div><b>Laurent Geniller</b> coordinateur vid&eacute;o</div>\\012<div>Et l&rsquo;&eacute;quipe de la MGI</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<p>&nbsp;</p>\\012<p>&nbsp;</p>\\012<h4>REMERCIEMENTS</h4>\\012<div>&nbsp;</div>\\012<div>Pour leur chaleureux soutien</div>\\012<div>&nbsp;</div>\\012<div>Jean-Christophe  Aguas</div>\\012<div>Marion Alluchon</div>\\012<div>Alain Bergala</div>\\012<div>Lucile Bruand-Exner</div>\\012<div>Elisabeth Caillet</div>\\012<div>S&eacute;bastien Canevet</div>\\012<div>Magda Carneci</div>\\012<div>Jean-Louis Comolli</div>\\012<div>Yves Clerget</div>\\012<div>Simona Edwards</div>\\012<div>Laurence  Emile-Besse</div>\\012<div>Anne-Sophie  Fran&ccedil;ois</div>\\012<div>Cezar Grumazescu</div>\\012<div>Alexis J&auml;derholm</div>\\012<div>Marie Kraft</div>\\012<div>Sonia Ouchelli</div>\\012<div>Philippe Puicouyoul</div>\\012<div>Peter Schott</div>\\012<div>Boris Tissot</div>\\012<div>&nbsp;</div>\\012<div>Rectorat de Paris</div>\\012<div>D&eacute;l&eacute;guation acad&eacute;mique aux relations europ&eacute;ennes et internationales et &agrave; la coop&eacute;ration</div>\\012<div>Gilles Laborde, D&eacute;l&eacute;gu&eacute;</div>\\012<div>Jean-Paul Chouard, charg&eacute; de mission</div>\\012<div>GIldas Le Roux, charg&eacute; de mission</div>\\012<div>&nbsp;</div>\\012<div>Mission acad&eacute;mique &laquo;&nbsp;Innovation et exp&eacute;rimentation&nbsp;&raquo;</div>\\012<div>Fran&ccedil;ois Muller, responsable</div>\\012<div>&nbsp;</div>\\012<div>Les directeurs d&rsquo;&eacute;tablissement scolaires et les enseignants dont l&rsquo;engagement sans faille tout au long de ce projet aura permis la r&eacute;alisation des &eacute;changes entre partenaires</div>\\012<div>Donatella Bargis</div>\\012<div>Elisabeth Battistel</div>\\012<div>Isabelle Bucurescu</div>\\012<div>Elisa Cappi</div>\\012<div>Julien Charlier</div>\\012<div>Doroth&eacute;e Clerc</div>\\012<div>Sorina Danaila</div>\\012<div>Laurence Dauvergne</div>\\012<div>Monique Dugu&eacute;-Boyer</div>\\012<div>Maria Rita Fiori</div>\\012<div>M. Goebbels</div>\\012<div>Paola Gozzi</div>\\012<div>Dominique Natta</div>\\012<div>Raluca Ionescu</div>\\012<div>Yola Le Cainec</div>\\012<div>Anne Laforge</div>\\012<div>Isabelle Limon</div>\\012<div>Elisabeth Loupiac</div>\\012<div>Elisabeth Meyer</div>\\012<div>Jean-Paul Moreau</div>\\012<div>Anne Catherine Mourgue</div>\\012<div>C&eacute;line Noras</div>\\012<div>Philippe Roca</div>\\012<div>Luc Richard</div>\\012<div>Assetou Sampebgo</div>\\012<div>Gabriela Sandulescu</div>\\012<div>Maria Augusta Schippisi</div>\\012<div>Dan Solcan</div>\\012<div>Thierry Sursin,</div>\\012<div>Sylvie Tomas</div>\\012<div>Corina Ungurean</div>\\012<div>Iulian Untaru</div>\\012<div>Dominique Vadet</div>\\012<div>H&eacute;l&egrave;ne Valencien</div>\\012<div>Mariana Visan</div>\\012<div>Ioana Voinea</div>\\012<div>Agn&egrave;s de Willecot</div>\\012<div>Philippe Zill</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>Centre Pompidou</div>\\012<div>Louis Corno</div>\\012<div>Olivier Bernon</div>\\012<div>Bruno Boullault</div>\\012<div>Fran&ccedil;oise Cagli</div>\\012<div>Yves Clerget</div>\\012<div>Patrice Chazotte</div>\\012<div>Yves Dalmau</div>\\012<div>Hugues Fournier-Montgieux</div>\\012<div>Sacha Ilic</div>\\012<div>Serge Navas</div>\\012<div>Marc Oustabatchieff</div>\\012<div>Fabrice Pleynet</div>\\012<div>Laurie Szulz</div>\\012<div>Philippe Puicouyoul</div>\\012<div>Boris Tissot</div>\\012<div>&nbsp;</div>\\012<p>Et toutes les personnes que nous aurions oubli&eacute;es.</p>\\012<p>&nbsp;</p>\\012	1249384245	1249297845		0
2:da6fe37074d7da107993d9eefc808c15	<ul>\\012<li><a href="/telecharger_lignes_de_temps">T&eacute;l&eacute;charger Lignes De Temps</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire">S&eacute;minaires index&eacute;s dans Lignes De Temps</a>\\012<ul>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/1">Figures de l'amateur</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/6">Mus&eacute;ologie 2007-2008</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/8">Mus&eacute;ologie 2008-2009</a></li>\\012</ul>\\012</li>\\012<li><a href="http://www.iri.centrepompidou.fr/privatedoc/">S&eacute;minaires en audio</a></li>\\012<li><a href="http://www.thdculture.fr" target="_blank">THD Culture</a></li>\\012<li><a href="http://amateur.iri.centrepompidou.fr/nouveaumonde/enmi/conf/">Entretiens du Nouveau Monde Industriel</a><a href="http://www.thdculture.fr" target="_blank"><br />\\012    </a></li>\\012<li><a href="/espaces_critiques">Espaces critiques</a></li>\\012</ul>\\012	1249394343	1249307943		0
2:59b7c05faefac6c3d0c31bf992363409	<p class="rteright"><a href="/lignes_de_temps_faq_en">English version</a></p>\\012<p>Le logiciel <i>Lignes de temps</i> est compos&eacute; de deux parties, que l'on appellera syst&egrave;me et interface.           <br />\\012- La partie syst&egrave;me est &quot;invisible&quot; pour l'utilisateur et permet d'enregistrer son travail (notes, d&eacute;coupages, bout &agrave; bout) dans un fichier. Elle permet aussi de lancer les programmes n&eacute;cessaires &agrave; l'import d'un fichier audio ou vid&eacute;o. Ces programmes encodent la vid&eacute;o pour qu'elle soit lisible dans l'interface et g&eacute;n&egrave;rent le plan par plan et la forme d'onde. <br />\\012- L'interface est tout ce qui est &quot;visible&quot; et manipulable par l'utilisateur. Elle se compose du menu en haut &agrave; gauche (Fichier, Affichage...) et des trois fen&ecirc;tres : informations, lecteur vid&eacute;o et celle qui affiche les lignes de temps. <br />\\012Les deux parties du programme communiquent entre elles mais cette communication peut parfois s'interrompre sans en informer l'utilisateur. Dans ce cas, on ne peut malheureusement plus enregistrer son travail. L'Institut de recherche et d'innovation travaille constamment &agrave; la r&eacute;solution de ce type de bogues. Pour toute information, commentaire ou probl&egrave;me, merci d'envoyer un mail &agrave; <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a><br />\\012Un travail dans <i>Lignes de temps</i> est sauvegard&eacute; dans un fichier de projet (extension .ldt) qui contient les r&eacute;f&eacute;rences vers les m&eacute;dias utilis&eacute;s et toutes les donn&eacute;es personnelles (notes, d&eacute;coupages, bout &agrave; bout, vues). Les donn&eacute;es non personnelles sur un m&eacute;dia (plan par plan et forme d'onde par exemple) sont enregistr&eacute;es dans un fichier &agrave; extension .iri.</p>\\012<ul>\\012<li><b>J'utilise un MAC, comment conna&icirc;tre ma configuration ?</b><br />\\012    Pour savoir si votre ordinateur est &quot;Intel&quot; ou &quot;Power PC&quot;, allez dans le menu Pomme en haut &agrave; gauche de votre &eacute;cran. Dans le menu qui est apparu, cliquez sur &quot;&agrave; propos de ce mac&quot;. La ligne &quot;Processeur&quot; indique si celui-ci est de type &quot;Intel&quot; ou &quot;Power PC&quot;.<br />\\012    Apr&egrave;s diff&eacute;rents tests, il apparait que <i>Lignes de temps</i> ne s'installe que sur les postes &eacute;quip&eacute;s du syst&egrave;me d'exploitation 10.5, dit &quot;l&eacute;opard&quot;, et du processeur Intel, ou ceux &eacute;quip&eacute;s du syst&egrave;me 10.4, dit &quot;tiger&quot;, et du processeur Power PC.</li>\\012<li><b>Je n'arrive pas &agrave; afficher les lignes de temps d'un film :</b><br />\\012    Pour afficher ces lignes il faut cliquer sur le titre du film, puis sur l'onglet &quot;D&eacute;coupages&quot; de la fen&ecirc;tre d'informations. Dans cet onglet, se trouve la liste des d&eacute;coupages disponibles. Il suffit de cliquer sur l'un d'entre eux pour afficher la ligne correspondante.</li>\\012<li><b>Je n'arrive pas &agrave; importer un fichier audio ou vid&eacute;o :</b><br />\\012    Il faut s'assurer que l'extension du fichier est compatible. <i>Lignes de temps</i> accepte les fichiers .avi, .mpg, .mov, .flv pour la vid&eacute;o et .mp3 pour l'audio. Ensuite, m&ecirc;me si celui-ci est accept&eacute;, il se peut que l'encodage ne soit pas compatible avec le programme (ffmpeg) qui transforme ce fichier en vid&eacute;o lisible par <i>Lignes de temps</i>, c'est-&agrave;-dire au format flv. Sous MAC, m&ecirc;me si l'extension du fichier est correcte, il se peut que certains caract&egrave;res emp&ecirc;chent l'import. Il est donc conseill&eacute; que le chemin d'acc&egrave;s et le nom de fichier n'aient pas les caract&egrave;res suivants : caract&egrave;res accentu&eacute;s, espace, &ccedil;, #, &amp;, %, !, *, (), [], |, {}, :, ;, @.</li>\\012<li><b>Je n'arrive pas &agrave; sauvegarder mon travail :</b><br />\\012    Comme expliqu&eacute; dans l'introduction, ce probl&egrave;me peut venir de la perte de communication entre l'interface et la partie du programme qui enregistre dans un fichier. Pour enregistrer son travail, on peut passer par le menu en haut &agrave; gauche (Fichier -- Enregistrer le projet) ou par le raccourci clavier Ctrl+S sur PC et Pomme+S sur Mac. En g&eacute;n&eacute;ral, quand un travail a &eacute;t&eacute; modifi&eacute; depuis le dernier enregistrement, une &eacute;toile appara&icirc;t &agrave; c&ocirc;t&eacute; du titre du projet pour montrer qu'un enregistrement est n&eacute;cessaire.</li>\\012</ul>\\012<p>&nbsp;</p>\\012<p><b>Notes de version 0.10.8 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; de vid&eacute;o en plein &eacute;cran sur fond noir</li>\\012<li>Possibilit&eacute; d'afficher un permalien vers un segment</li>\\012<li>Possibilit&eacute; d'afficher des sous-titres depuis un fichier externet au format TimedText XML</li>\\012<li>Possibilit&eacute; d'afficher l'int&eacute;gralit&eacute; des annotations (titre et description) d'une timeline dans un grand champ texte &eacute;quip&eacute; d'une recherche simple</li>\\012<li>Am&eacute;liorations ergonomiques (boutons pour timeline r&eacute;arrang&eacute;s, fen&ecirc;tre de tags redimensionnable)</li>\\012</ul>\\012<p><b>Notes de version 0.10.4 &agrave; 0.10.7 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; d'importer des d&eacute;coupages depuis un autre fichier .ldt</li>\\012<li>Possibilit&eacute; d'annoter un flux live stream&eacute; en rtmp://...</li>\\012<li>D&eacute;placement des lignes de temps et des films par simple drag and drop</li>\\012<li>Am&eacute;liorations ergonomiques (nom du fichier .ldt affich&eacute; dans le titre fen&ecirc;tre d'information, zoom plus fluide, possibilit&eacute; de sauvegarder sa langue par d&eacute;faut)</li>\\012<li>Possibilit&eacute; de dupliquer les segments en surbrillance d'une ligne de temps</li>\\012<li>D&eacute;bug divers</li>\\012</ul>\\012<p><b>Notes de version 0.10.3 :</b></p>\\012<ul>\\012<li>Langue japonaise ajout&eacute;e par d&eacute;faut</li>\\012<li>D&eacute;bug divers</li>\\012</ul>\\012<p><b>Notes de version 0.10 :</b></p>\\012<ul>\\012<li>INTERFACE MULTILINGUE avec Anglais et Fran&ccedil;ais propos&eacute;s par d&eacute;faut et possibilit&eacute; d'ajouter soi-m&ecirc;me des langues (&eacute;tapes expliqu&eacute;es dans le <a href="/res/media/ldt_userguide_fr.pdf" target="_blank">mode d'emploi</a> gr&acirc;ce &agrave; l'outil GETTEXT)</li>\\012<li>Refonte compl&egrave;te de l'interface et de l'ergonomie avec entre autres ajout de boutons avec icones, de nouveaux onglets plus visibles, de bulles d'aide, de messages de confirmation avant suppression.</li>\\012<li>Vues : possibilit&eacute; de renommage et de d&eacute;placement.</li>\\012<li>Tags : affichage de la liste compl&egrave;te du nuage de tags du projet par le menu en haut &agrave; gauche et le raccourci Shift + T.</li>\\012<li>Prise de notes : am&eacute;lioration du suivi de la frappe gr&acirc;ce au positionnement automatique de l'ascenceur, indication du timecode correspondant au survol du marqueur.</li>\\012<li>Bout &agrave; bout : possibilit&eacute; de suppression.</li>\\012<li>Ajout d'un <a href="/dev/trac/ldt" target="_blank">trac</a> pour le suivi des bugs.</li>\\012<li>Mise &agrave; jour compl&egrave;te du mode d'emploi en <a href="/res/media/ldt_userguide_fr.pdf" target="_blank">fran&ccedil;ais</a> et en <a href="/res/media/ldt_userguide_en.pdf" target="_blank">anglais</a>.</li>\\012<li>Ajout de la license dans l'&agrave; propos.</li>\\012</ul>\\012<p><b>Notes de version 0.9.4 :</b></p>\\012<ul>\\012<li>Ajout d'un module prise de notes, permettant d'&eacute;crire des commentaires &agrave; la vol&eacute;e puis de les transformer en ligne de temps.</li>\\012<li>Vues : la sauvegarde des &eacute;tats d'affichage prennent maintenant en compte le niveau de zoom, la position de l'ascenceur horizontal et si un bout &agrave; bout est en lecture.</li>\\012<li>Am&eacute;lioration de la saisie des tags : possibilit&eacute; d'avoir une fen&ecirc;tre avec tous les tags d'une ligne et ajout du tag par simple clic.</li>\\012<li>Possibilit&eacute; d'afficher tous les tags du projets dans une grande fen&ecirc;tre gr&acirc;ce au raccourci clavier Shift + F.</li>\\012<li>Possibilit&eacute; de mettre en surbrillance les segments en cliquant sur les tags d'une ligne. Cinq couleurs sont disponibles (une par tag), puis au-del&agrave; les segments concern&eacute;s par la recherche s'affichent en blanc.</li>\\012<li>Possibilit&eacute; de dupliquer une ligne en ne s&eacute;lectionnant que les segments en surbrillance.</li>\\012<li>Possibilit&eacute; de cr&eacute;er un bout &agrave; bout &agrave; partir d'une ligne compl&egrave;te ou des segments en surbrillance.</li>\\012<li>Ajout de messages d'erreur en cas de plantage du logiciel. Cela limite le risque de perdre son travail.</li>\\012</ul>\\012<p><b>Notes de version 0.9.2 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; de dupliquer n'importe quelle ligne (bouton &quot;dupliquer&quot; dans la fen&ecirc;tre d'informations).</li>\\012<li>Ajout du champ tag pour les segments.</li>\\012<li>Possibilit&eacute; d'afficher le sommaire d'un d&eacute;coupage, c'est-&agrave;-dire la liste de ses segments sous forme de texte cliquable.</li>\\012<li>D&eacute;bogage des bugs identifi&eacute;s dans la version pr&eacute;c&eacute;dente.</li>\\012<li>Modification de l'interface : fen&ecirc;tre d'informations agrandie en hauteur et en largeur et fen&ecirc;tre d'affichage des lignes agrandie en largeur.</li>\\012</ul>\\012<p>&nbsp;</p>\\012	1250159930	1250073530		0
2:a71e1c80263cb55bfdfe97102a5fb08e	<p>Created in April 2006, The Institute for Research and Innovation (IRI) of \\011the Centre Pompidou, is focused on the study and development of cultural and \\011learning technologies and promotes the emergence of new amateur practices. \\011R&amp;D topics include annotation tools, collaborative Web platforms, mobile \\011technologies, multimodal interfaces, and digital design. Activities are \\011conducted within three different contexts :</p>\\012<div align="left" style="border: 1px solid black; padding-left: 2px; padding-top: 2px;">\\012<p>&nbsp;</p>\\012<p><center><a href="http://amateur.iri.centrepompidou.fr/nouveaumonde/enmi/conf/"><img border="0" alt="Entretiens du nouveau monde industriel" src="/res/img/enmi.jpg" /></a></center></p>\\012<p>Listen to the recording : <a href="http://amateur.iri.centrepompidou.fr/nouveaumonde/enmi/conf/">http://amateur.iri.centrepompidou.fr/nouveaumonde/enmi/conf/</a></p>\\012</div>\\012<h2>&nbsp;</h2>\\012<div class="illus2"><a href="/res/img/screenshot_ldt_300dpi.jpg">         <img width="287" height="180" alt="Screenshot of 'lignes de temps'" class="image" src="/res/img/screenshot_ldt_300dpi.jpg" /><br />\\012<strong>Screenshot of <i>Lignes de temps</i></strong>       </a></div>\\012<p>Computer science workshop,  dedicated to research and development  in Art mediation technologies          in collaboration with artists in residency, invited scientists/experts and with partners from Research and Industry.          Our research activity cross Human science topics (Judgment and Esthetics, New Amateur practices,  Modernity,  Design,          Knowledge technologies/Nano technologies) with 3 Computer Science disciplines :</p>\\012<ul>\\012<li>Knowledge and document engineering : annotation tools and critics instruments (Lignes de temps for film, text and image annotation),</li>\\012<p></p>\\012<li>Web 2.0 and online collaborative tools (collaborative Web site and review &quot;L'amateur&quot;, Web 2.0 experimentations),</li>\\012<p></p>\\012<li>Public address and mobility (collaborations with Education sciences and school teachers, experimentations on mobile devices for Centre Pompidou exhibitions, prospective studies on mobility, ambient intelligence and nanotechnologies).</li>\\012</ul>\\012<p>&nbsp;</p>\\012<div align="left" style="border: 1px solid black; padding-left: 2px; background-color: rgb(238, 238, 238);">\\012<h2>DOWNLOAD Lignes de temps NOW !</h2>\\012<p><a href="/lignes_de_temps_faq_en"><strong>?&nbsp;FAQ&nbsp;?</strong></a></p>\\012<p>With Lignes de temps you can analyze, comment and annotate films and any audio/video recordings.</p>\\012<ul>\\012<li><b>PC</b> :\\012<ul>\\012<li><a href="/apps/LignesDeTemps-0.10.7-Setup.exe">Simple version 0.10.7 (36 Mo)</a></li>\\012<li><a href="/apps/LignesDeTempsNosferatu-0.10.7-Setup.exe">Version 0.10.7 including F.W. Murnau's Nosferatu described and documented (205 Mo)</a> <a target="_blank" href="http://creativecommons.org/licenses/publicdomain/deed.fr"><img alt="Creative Commons" src="http://www.iri.centrepompidou.fr/res/img/creativecommons.jpg" /></a></li>\\012</ul>\\012</li>\\012<li><b>MAC</b> (see the <a href="/lignes_de_temps_faq_en">FAQ</a> to know your configuration) :\\012<ul>\\012<li><a href="/apps/LignesDeTemps.0.10.7.ppc.dmg">Version 0.10.7 for Power PC - OS 10.4 tiger</a></li>\\012<li><a href="/apps/LignesDeTemps.0.10.7.intel.dmg">Version 0.10.7 for Intel - OS 10.5 leopard</a></li>\\012</ul>\\012<p></p>\\012<div class="illus2"><a href="http://www.iri.centrepompidou.fr/res/img/ldt_300dpi.jpg"><img alt="Copie d'&eacute;cran lignes de temps" class="image" src="/res/img/ldt_thumb.jpg" /></a></div>\\012<p>Once downloaded, double-click on the installer and follow the proposed guidelines. When installed, import a video file (formats: avi, mpg, mov or flv) or an audio file (mp3) using the menu: File -&gt; Import.</p>\\012<p>&nbsp;</p>\\012<p>Important reminder:</p>\\012<ul>\\012<li>Depending on your computer power and file size, Import may last from few minutes to more than 20 or 30 minutes.</li>\\012<p>&nbsp;</p>\\012<li>This version is a <u>beta version</u>, this means it contains bugs despite our continuous attempt to correct them. Some videos may not be imported or the software may crash, and your work could not be saved. See the <a href="/lignes_de_temps_faq_en">FAQ</a>.</li>\\012</ul>\\012<p><b>To know more</b> about the software : <a target="_blank" href="/res/media/lignes_de_temps_ang_site.pdf">Exhibition flyer</a>, <a target="_blank" href="/res/media/flyer_ldt_en.pdf">software flyer</a>, <a target="_blank" href="http://www.iri.centrepompidou.fr/res/media/ldt_userguide_en.pdf">user's guide</a> and <a target="_blank" href="/res/media/license_lignesdetemps.txt">license</a>.</p>\\012<p>To use &quot;Lignes de temps&quot; directly on the web with F.W. Murnau's <i>Nosferatu</i>, click <a href="http://web.iri.centrepompidou.fr/lignesdetemps_nosferatu.html">here</a>. You can also see a <a href="http://web.iri.centrepompidou.fr/demo_entretiens_lignesdetemps.html">demonstration</a> of the software (in french).</p>\\012<p>For any information, feedback or problem, <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a>.</p>\\012</li>\\012</ul>\\012</div>\\012<h2>&nbsp;</h2>\\012<h2>LE&nbsp;COLLEGE</h2>\\012<p>Gathering artists, scientists, experts in residency for seminars and conferences on the different issues tackled by the Institute.</p>\\012<ul>\\012<li>Signed views workshops</li>\\012<li>Theory and Judgment seminar</li>\\012<li>Judgment and Theatre seminar</li>\\012<li>Images and faces sessions</li>\\012<li>Culture 2.0 seminar</li>\\012<li>Nanotechnologies seminar</li>\\012<li>Modernity seminar</li>\\012<li>Judgment and practices seminar</li>\\012<li>Signed readings workshops</li>\\012<li><a target="_blank" href="/res/media/Programme_seminar-IRI-Museology.pdf">Museology, museography and new public adresses seminar</a></li>\\012<li><a href="http://amateur.iri.centrepompidou.fr/nouveaumonde/">New Industrial World Forum</a></li>\\012</ul>\\012<p><b>To subscribe  : <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a></b></p>\\012<h2>&nbsp;</h2>\\012<h2>L'ESPACE&nbsp;CRITIQUE (THE&nbsp;CRITICAL&nbsp;SPACE)</h2>\\012<p>&nbsp;</p>\\012<p>&nbsp;</p>\\012<div align="center">\\012<object width="539" height="201" type="application/x-shockwave-flash" id="myMovie" name="myMovie" data="res/img/test_banner.swf">\\012<param name="quality" value="high" />\\012<param name="wmode" value="transparent" />\\012<param name="allowScriptAccess" value="always" />\\012<param name="salign" value="t" /></object><script type="text/javascript">\\012            var params = {\\012                quality:"high",\\012                wmode:"transparent",\\012                allowScriptAccess:"always",\\012                salign: "t"\\012            };\\012            var attributes = {  id: "myMovie",  name: "myMovie"};\\012            swfobject.embedSWF("/res/img/test_banner.swf", "flashContent", "539", "201", "9.0.0", "../../swf/expressInstall.swf", null, params, attributes);\\012        </script><div align="left" style="width: 539px; letter-spacing: 0.6px;"><span class="normale" align="justify"><a href="http://web.iri.centrepompidou.fr/">Lignes de temps , another sight over Abbas Kiarostmi and V&iacute;ctor Erice works</a></span></div>\\012</div>\\012<p>The Espace critique is composed by documentary resources, critical elements in relation with Centre Pompidou Cultural Dept. activities and annotation tools developed by the IRI.</p>\\012<p>This computer disposal, online with the review &quot;L'amateur&quot; (opening in 2009), can also be sometimes available in Centre Pompidou exhibitions or in spaces related to Centre Pompidou Cultural Dept. activities (Shows, Cinema, Audio reviews, Forums de Soci&eacute;t&eacute;).</p>\\012<p>&nbsp;</p>\\012<div align="center"><img alt="Traces du sacr&eacute;" src="/res/img/traces_du_sacre_iri_1.png" /><br />\\012<b>A new system for visitor guidance and participation</b></div>\\012<p>To enrich the exhibition <i>Traces du sacr&eacute;</i> (Centre Pompidou, May 7th - August 11th 2008), a new multimedia system is accessible to listen to curators and figures from the world of culture and the art. Visitors can also record their own comments, using the multimedia guide or their mobile phones. Afterwards, visitors will be able to access their audio comments on the Internet, modifying, annotating and indexing them, thanks to the software <i>Lignes de temps</i>, before publishing them on a collaborative web site developed for this event.</p>\\012<p>To consult comments: <a href="http://web.iri.centrepompidou.fr/traces">http://web.iri.centrepompidou.fr/traces</a></p>\\012<p><font size="1">Visual credits : Jakob von Narkiewicz-Jodko, Effluves d'une main &eacute;lectrifi&eacute;e pos&eacute;e sur la plaque photographique, mars 1896, &eacute;preuve &agrave; la g&eacute;latine argentique, 18,1 x 12,9 cm, Fonds Camille Flammarion, Soci&eacute;t&eacute; astronomique de France</font></p>\\012<h2>MORE...</h2>\\012<p><a target="_blank" href="http://www.tivipro.tv/salons_sshome.php?id_salon=319">Watch the interviews following the press conference of May 14th, 2009 (in French) on http://www.tivipro.tv</a><br />\\012<a target="_blank" href="/res/media/Flyer_IRI-nov_2008-GB.pdf">         <img class="image" alt="format pdf" src="/res/img/pdf.gif" />          Download a document about IRI (in English)       </a>       <br />\\012<a target="_blank" href="/res/media/presentation_iri.pdf">         <img class="image" alt="format pdf" src="/res/img/pdf.gif" />          Download an article about IRI (in French)       </a>       <br />\\012<a target="_blank" href="/res/media/presentation_ldt.pdf">         <img class="image" alt="format pdf" src="/res/img/pdf.gif" />          Download a document about <i>Lignes de temps</i> (in French)       </a>       <br />\\012<a target="_blank" href="/res/media/lignes_de_temps_ang_site.pdf">         <img class="image" alt="format pdf" src="/res/img/pdf.gif" />          Flyer espace <i>Lignes de temps</i> (in English)       </a>       </p>\\012<p><a href="http://www.iri.centrepompidou.fr/en/cinelab.html">The RIAM/Cap Digital Cine Lab project</a></p>\\012<p><a target="_blank" href="http://www.culture.gouv.fr/culture/editions/r-cr.htm">See an article about Lignes de temps in Culture &amp; Recherche (in French)</a></p>\\012	1250587771	1250501371		0
2:9af54a34c7ab6d287817c6e068588c12	<p class="rteright"><a href="/lignes_de_temps_faq_en">English version</a></p>\\012<p>Le logiciel <i>Lignes de temps</i> est compos&eacute; de deux parties, que l'on appellera syst&egrave;me et interface.           <br />\\012- La partie syst&egrave;me est &quot;invisible&quot; pour l'utilisateur et permet d'enregistrer son travail (notes, d&eacute;coupages, bout &agrave; bout) dans un fichier. Elle permet aussi de lancer les programmes n&eacute;cessaires &agrave; l'import d'un fichier audio ou vid&eacute;o. Ces programmes encodent la vid&eacute;o pour qu'elle soit lisible dans l'interface et g&eacute;n&egrave;rent le plan par plan et la forme d'onde. <br />\\012- L'interface est tout ce qui est &quot;visible&quot; et manipulable par l'utilisateur. Elle se compose du menu en haut &agrave; gauche (Fichier, Affichage...) et des trois fen&ecirc;tres : informations, lecteur vid&eacute;o et celle qui affiche les lignes de temps. <br />\\012Les deux parties du programme communiquent entre elles mais cette communication peut parfois s'interrompre sans en informer l'utilisateur. Dans ce cas, on ne peut malheureusement plus enregistrer son travail. L'Institut de recherche et d'innovation travaille constamment &agrave; la r&eacute;solution de ce type de bogues. Pour toute information, commentaire ou probl&egrave;me, merci d'envoyer un mail &agrave; <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a><br />\\012Un travail dans <i>Lignes de temps</i> est sauvegard&eacute; dans un fichier de projet (extension .ldt) qui contient les r&eacute;f&eacute;rences vers les m&eacute;dias utilis&eacute;s et toutes les donn&eacute;es personnelles (notes, d&eacute;coupages, bout &agrave; bout, vues). Les donn&eacute;es non personnelles sur un m&eacute;dia (plan par plan et forme d'onde par exemple) sont enregistr&eacute;es dans un fichier &agrave; extension .iri.</p>\\012<ul>\\012<li><b>J'utilise un MAC, comment conna&icirc;tre ma configuration ?</b><br />\\012    Pour savoir si votre ordinateur est &quot;Intel&quot; ou &quot;Power PC&quot;, allez dans le menu Pomme en haut &agrave; gauche de votre &eacute;cran. Dans le menu qui est apparu, cliquez sur &quot;&agrave; propos de ce mac&quot;. La ligne &quot;Processeur&quot; indique si celui-ci est de type &quot;Intel&quot; ou &quot;Power PC&quot;.<br />\\012    Apr&egrave;s diff&eacute;rents tests, il apparait que <i>Lignes de temps</i> ne s'installe que sur les postes &eacute;quip&eacute;s du syst&egrave;me d'exploitation 10.5, dit &quot;l&eacute;opard&quot;, et du processeur Intel, ou ceux &eacute;quip&eacute;s du syst&egrave;me 10.4, dit &quot;tiger&quot;, et du processeur Power PC.</li>\\012<li><b>Je n'arrive pas &agrave; afficher les lignes de temps d'un film :</b><br />\\012    Pour afficher ces lignes il faut cliquer sur le titre du film, puis sur l'onglet &quot;D&eacute;coupages&quot; de la fen&ecirc;tre d'informations. Dans cet onglet, se trouve la liste des d&eacute;coupages disponibles. Il suffit de cliquer sur l'un d'entre eux pour afficher la ligne correspondante.</li>\\012<li><b>Je n'arrive pas &agrave; importer un fichier audio ou vid&eacute;o :</b><br />\\012    Il faut s'assurer que l'extension du fichier est compatible. <i>Lignes de temps</i> accepte les fichiers .avi, .mpg, .mov, .flv pour la vid&eacute;o et .mp3 pour l'audio. Ensuite, m&ecirc;me si celui-ci est accept&eacute;, il se peut que l'encodage ne soit pas compatible avec le programme (ffmpeg) qui transforme ce fichier en vid&eacute;o lisible par <i>Lignes de temps</i>, c'est-&agrave;-dire au format flv. Sous MAC, m&ecirc;me si l'extension du fichier est correcte, il se peut que certains caract&egrave;res emp&ecirc;chent l'import. Il est donc conseill&eacute; que le chemin d'acc&egrave;s et le nom de fichier n'aient pas les caract&egrave;res suivants : caract&egrave;res accentu&eacute;s, espace, &ccedil;, #, &amp;, %, !, *, (), [], |, {}, :, ;, @.</li>\\012<li><b>Je n'arrive pas &agrave; sauvegarder mon travail :</b><br />\\012    Comme expliqu&eacute; dans l'introduction, ce probl&egrave;me peut venir de la perte de communication entre l'interface et la partie du programme qui enregistre dans un fichier. Pour enregistrer son travail, on peut passer par le menu en haut &agrave; gauche (Fichier -- Enregistrer le projet) ou par le raccourci clavier Ctrl+S sur PC et Pomme+S sur Mac. En g&eacute;n&eacute;ral, quand un travail a &eacute;t&eacute; modifi&eacute; depuis le dernier enregistrement, une &eacute;toile appara&icirc;t &agrave; c&ocirc;t&eacute; du titre du projet pour montrer qu'un enregistrement est n&eacute;cessaire.</li>\\012</ul>\\012<p>&nbsp;</p>\\012<p><b>Notes de version 0.10.8 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; de vid&eacute;o en plein &eacute;cran sur fond noir</li>\\012<li>Possibilit&eacute; d'afficher un permalien vers un segment</li>\\012</ul>\\012<p><b>Notes de version 0.10.4 &agrave; 0.10.7 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; d'importer des d&eacute;coupages depuis un autre fichier .ldt</li>\\012<li>Possibilit&eacute; d'annoter un flux live stream&eacute; en rtmp://...</li>\\012<li>D&eacute;placement des lignes de temps et des films par simple drag and drop</li>\\012<li>Am&eacute;liorations ergonomiques (nom du fichier .ldt affich&eacute; dans le titre fen&ecirc;tre d'information, zoom plus fluide, possibilit&eacute; de sauvegarder sa langue par d&eacute;faut)</li>\\012<li>Possibilit&eacute; de dupliquer les segments en surbrillance d'une ligne de temps</li>\\012<li>D&eacute;bug divers</li>\\012</ul>\\012<p><b>Notes de version 0.10.3 :</b></p>\\012<ul>\\012<li>Langue japonaise ajout&eacute;e par d&eacute;faut</li>\\012<li>D&eacute;bug divers</li>\\012</ul>\\012<p><b>Notes de version 0.10 :</b></p>\\012<ul>\\012<li>INTERFACE MULTILINGUE avec Anglais et Fran&ccedil;ais propos&eacute;s par d&eacute;faut et possibilit&eacute; d'ajouter soi-m&ecirc;me des langues (&eacute;tapes expliqu&eacute;es dans le <a href="/res/media/ldt_userguide_fr.pdf" target="_blank">mode d'emploi</a> gr&acirc;ce &agrave; l'outil GETTEXT)</li>\\012<li>Refonte compl&egrave;te de l'interface et de l'ergonomie avec entre autres ajout de boutons avec icones, de nouveaux onglets plus visibles, de bulles d'aide, de messages de confirmation avant suppression.</li>\\012<li>Vues : possibilit&eacute; de renommage et de d&eacute;placement.</li>\\012<li>Tags : affichage de la liste compl&egrave;te du nuage de tags du projet par le menu en haut &agrave; gauche et le raccourci Shift + T.</li>\\012<li>Prise de notes : am&eacute;lioration du suivi de la frappe gr&acirc;ce au positionnement automatique de l'ascenceur, indication du timecode correspondant au survol du marqueur.</li>\\012<li>Bout &agrave; bout : possibilit&eacute; de suppression.</li>\\012<li>Ajout d'un <a href="/dev/trac/ldt" target="_blank">trac</a> pour le suivi des bugs.</li>\\012<li>Mise &agrave; jour compl&egrave;te du mode d'emploi en <a href="/res/media/ldt_userguide_fr.pdf" target="_blank">fran&ccedil;ais</a> et en <a href="/res/media/ldt_userguide_en.pdf" target="_blank">anglais</a>.</li>\\012<li>Ajout de la license dans l'&agrave; propos.</li>\\012</ul>\\012<p><b>Notes de version 0.9.4 :</b></p>\\012<ul>\\012<li>Ajout d'un module prise de notes, permettant d'&eacute;crire des commentaires &agrave; la vol&eacute;e puis de les transformer en ligne de temps.</li>\\012<li>Vues : la sauvegarde des &eacute;tats d'affichage prennent maintenant en compte le niveau de zoom, la position de l'ascenceur horizontal et si un bout &agrave; bout est en lecture.</li>\\012<li>Am&eacute;lioration de la saisie des tags : possibilit&eacute; d'avoir une fen&ecirc;tre avec tous les tags d'une ligne et ajout du tag par simple clic.</li>\\012<li>Possibilit&eacute; d'afficher tous les tags du projets dans une grande fen&ecirc;tre gr&acirc;ce au raccourci clavier Shift + F.</li>\\012<li>Possibilit&eacute; de mettre en surbrillance les segments en cliquant sur les tags d'une ligne. Cinq couleurs sont disponibles (une par tag), puis au-del&agrave; les segments concern&eacute;s par la recherche s'affichent en blanc.</li>\\012<li>Possibilit&eacute; de dupliquer une ligne en ne s&eacute;lectionnant que les segments en surbrillance.</li>\\012<li>Possibilit&eacute; de cr&eacute;er un bout &agrave; bout &agrave; partir d'une ligne compl&egrave;te ou des segments en surbrillance.</li>\\012<li>Ajout de messages d'erreur en cas de plantage du logiciel. Cela limite le risque de perdre son travail.</li>\\012</ul>\\012<p><b>Notes de version 0.9.2 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; de dupliquer n'importe quelle ligne (bouton &quot;dupliquer&quot; dans la fen&ecirc;tre d'informations).</li>\\012<li>Ajout du champ tag pour les segments.</li>\\012<li>Possibilit&eacute; d'afficher le sommaire d'un d&eacute;coupage, c'est-&agrave;-dire la liste de ses segments sous forme de texte cliquable.</li>\\012<li>D&eacute;bogage des bugs identifi&eacute;s dans la version pr&eacute;c&eacute;dente.</li>\\012<li>Modification de l'interface : fen&ecirc;tre d'informations agrandie en hauteur et en largeur et fen&ecirc;tre d'affichage des lignes agrandie en largeur.</li>\\012</ul>\\012	1249136836	1249050436		0
2:297d64de3f755f7a51b898a9b239383b	<p>Inscriptions aux s&eacute;minaires :</p>\\012<p><a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a></p>\\012<p>&nbsp;</p>\\012	1249138773	1249052373		0
2:84d9a8f525e62887520fd8fc9ac4c064	<p><a href="/ma_ville_vue_par">Projet</a> - <a href="/ma_ville_vue_par/etapes">Etapes</a> - G&eacute;n&eacute;rique</p>\\012<p>&nbsp;</p>\\012<p><h4>PARTENAIRES</h4>\\012<div>&nbsp;</div>\\012<div>Ce projet a pu &ecirc;tre men&eacute; &agrave; bien gr&acirc;ce &agrave; l&rsquo;aide pr&eacute;cieuse de</div>\\012<div>L&rsquo;Ambassade de France en Roumanie, Bucarest</div>\\012<div>Le Centre culturel su&eacute;dois, Paris</div>\\012<div>L&rsquo;Institut culturel roumain, Paris</div>\\012<div>L&rsquo;Institut fran&ccedil;ais, Berlin</div>\\012<div>La Mairie de Paris / Mission cin&eacute;ma</div>\\012<div>Le Rectorat de Paris / Dareic et Mission innovation</div>\\012<div>&nbsp;</div>\\012<div><a href="http://www.ambafrance-ro.org/">http://www.ambafrance-ro.org/</a></div>\\012<div><a href="http://www.si.se/Centre-culturel-suedois/Francais/Centre-culturel-suedois/">http://www.si.se/Centre-culturel-suedois/Francais/Centre-culturel-suedois/</a></div>\\012<div><a href="http://www.institut-roumain.org/">http://www.institut-roumain.org/</a></div>\\012<div><a href="http://www.institut-francais.fr/">http://www.institut-francais.fr/</a></div>\\012<div><a href="http://www.paris.fr/portail/Culture/Portal.lut?page_id=8358&amp;document_type_id=5&amp;document_id=36017&amp;portlet_id=19409" target="_blank">http://www.paris.fr/portail/Culture/Portal.lut?page_id=8358&amp;document_type_id=5&amp;document_id=36017&amp;portlet_id=19409</a></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<h4>EQUIPE</h4>\\012<div><u><br />\\012</u></div>\\012<div>D&eacute;partement du d&eacute;veloppement culturel-Centre Pompidou,</div>\\012<div><b>Fr&eacute;d&eacute;rique Mirotchnikoff</b> direction du projet.</div>\\012<div>&nbsp;</div>\\012<div>Intervenants</div>\\012<div><b>Marta Boni</b> doctorante en cin&eacute;ma, direction des Ateliers <i>Lignes de temps.</i></div>\\012<div><b>Lila Pinell</b> r&eacute;alisatrice, membre de l&rsquo;association <i>b&eacute;tonsalon</i>, direction des tournages dans des &eacute;tablissements scolaires partenaires.</div>\\012<div><b>Aurore Frey</b> &eacute;tudiante en cin&eacute;ma</div>\\012<div>&nbsp;</div>\\012<div>Stagiaires</div>\\012<div><b>Esther Baucher</b></div>\\012<div><b>Elodie Bertrand</b></div>\\012<div><b>Sophie Besson</b></div>\\012<div><b>Ma&euml;lys Bourgoin</b></div>\\012<div><b>Laure Grimaldi</b></div>\\012<div><b>Alexandre Marques</b></div>\\012<div>&nbsp;</div>\\012<div>Institut de recherche et d&rsquo;innovation-Centre Pompidou</div>\\012<div><b>Bernard Stiegler</b><b>,</b> directeur</div>\\012<div><b>Vincent Puig</b><b>,</b> directeur-adjoint</div>\\012<div><b>Thibaut Cavali&eacute;</b>, chef de projet - ing&eacute;nieur logiciel <i>Lignes de temps</i></div>\\012<div><b>Fanny Belvisi,</b> charg&eacute;e d&rsquo;administration et de communication</div>\\012<div><b>Yves-Marie L&rsquo;Hour,</b> responsable &eacute;ditorial</div>\\012<div><b>Yves-Marie Haussonne</b>, chef de projet web</div>\\012<div>&nbsp;</div>\\012<div>Maison du geste et de l&rsquo;image</div>\\012<div><b>Evelyne Panato </b>directrice</div>\\012<div><b>Laurent Geniller</b> coordinateur vid&eacute;o</div>\\012<div>Et l&rsquo;&eacute;quipe de la MGI</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012</p>\\012<p><h4>REMERCIEMENTS</h4>\\012<div>&nbsp;</div>\\012<div>Pour leur chaleureux soutien</div>\\012<div>&nbsp;</div>\\012<div>Jean-Christophe  Aguas</div>\\012<div>Marion Alluchon</div>\\012<div>Alain Bergala</div>\\012<div>Lucile Bruand-Exner</div>\\012<div>Elisabeth Caillet</div>\\012<div>S&eacute;bastien Canevet</div>\\012<div>Magda Carneci</div>\\012<div>Jean-Louis Comolli</div>\\012<div>Yves Clerget</div>\\012<div>Simona Edwards</div>\\012<div>Laurence  Emile-Besse</div>\\012<div>Anne-Sophie  Fran&ccedil;ois</div>\\012<div>Cezar Grumazescu</div>\\012<div>Alexis J&auml;derholm</div>\\012<div>Marie Kraft</div>\\012<div>Sonia Ouchelli</div>\\012<div>Philippe Puicouyoul</div>\\012<div>Peter Schott</div>\\012<div>Boris Tissot</div>\\012<div>&nbsp;</div>\\012<div>Rectorat de Paris</div>\\012<div>D&eacute;l&eacute;guation acad&eacute;mique aux relations europ&eacute;ennes et internationales et &agrave; la coop&eacute;ration</div>\\012<div>Gilles Laborde, D&eacute;l&eacute;gu&eacute;</div>\\012<div>Jean-Paul Chouard, charg&eacute; de mission</div>\\012<div>GIldas Le Roux, charg&eacute; de mission</div>\\012<div>&nbsp;</div>\\012<div>Mission acad&eacute;mique &laquo;&nbsp;Innovation et exp&eacute;rimentation&nbsp;&raquo;</div>\\012<div>Fran&ccedil;ois Muller, responsable</div>\\012<div>&nbsp;</div>\\012<div>Les directeurs d&rsquo;&eacute;tablissement scolaires et les enseignants dont l&rsquo;engagement sans faille tout au long de ce projet aura permis la r&eacute;alisation des &eacute;changes entre partenaires</div>\\012<div>Donatella Bargis</div>\\012<div>Elisabeth Battistel</div>\\012<div>Isabelle Bucurescu</div>\\012<div>Elisa Cappi</div>\\012<div>Julien Charlier</div>\\012<div>Doroth&eacute;e Clerc</div>\\012<div>Sorina Danaila</div>\\012<div>Laurence Dauvergne</div>\\012<div>Monique Dugu&eacute;-Boyer</div>\\012<div>Maria Rita Fiori</div>\\012<div>M. Goebbels</div>\\012<div>Paola Gozzi</div>\\012<div>Dominique Natta</div>\\012<div>Raluca Ionescu</div>\\012<div>Yola Le Cainec</div>\\012<div>Anne Laforge</div>\\012<div>Isabelle Limon</div>\\012<div>Elisabeth Loupiac</div>\\012<div>Elisabeth Meyer</div>\\012<div>Jean-Paul Moreau</div>\\012<div>Anne Catherine Mourgue</div>\\012<div>C&eacute;line Noras</div>\\012<div>Philippe Roca</div>\\012<div>Luc Richard</div>\\012<div>Assetou Sampebgo</div>\\012<div>Gabriela Sandulescu</div>\\012<div>Maria Augusta Schippisi</div>\\012<div>Dan Solcan</div>\\012<div>Thierry Sursin,</div>\\012<div>Sylvie Tomas</div>\\012<div>Corina Ungurean</div>\\012<div>Iulian Untaru</div>\\012<div>Dominique Vadet</div>\\012<div>H&eacute;l&egrave;ne Valencien</div>\\012<div>Mariana Visan</div>\\012<div>Ioana Voinea</div>\\012<div>Agn&egrave;s de Willecot</div>\\012<div>Philippe Zill</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>Centre Pompidou</div>\\012<div>Louis Corno</div>\\012<div>Olivier Bernon</div>\\012<div>Bruno Boullault</div>\\012<div>Fran&ccedil;oise Cagli</div>\\012<div>Yves Clerget</div>\\012<div>Patrice Chazotte</div>\\012<div>Yves Dalmau</div>\\012<div>Hugues Fournier-Montgieux</div>\\012<div>Sacha Ilic</div>\\012<div>Serge Navas</div>\\012<div>Marc Oustabatchieff</div>\\012<div>Fabrice Pleynet</div>\\012<div>Laurie Szulz</div>\\012<div>Philippe Puicouyoul</div>\\012<div>Boris Tissot</div>\\012<div>&nbsp;</div>\\012</p><p>Et toutes les personnes que nous aurions oubli&eacute;es.</p>\\012	1249382765	1249296365		0
2:673a506c38c100b0916658f10cfd1c8c	<h3>Programmation des ateliers de l'IRI</h3>\\012<ul>\\012<li><a href="/ateliers/regards_signes_2009_2010">Atelier Regards sign&eacute;s</a></li>\\012<li><a href="ateliers/experimentations_pedagogiques">Ateliers avec l&rsquo;Education Nationale et films document&eacute;s et analys&eacute;s dans Lignes de temps</a></li>\\012<li><a href="/ma_ville_vue_par">Atelier p&eacute;dagogique &laquo;Ma ville vue par...&raquo;</a></li>\\012<li><a href="/ateliers/lectures_signees">Atelier Lectures sign&eacute;es</a></li>\\012<li><a href="http://www.iri.centrepompidou.fr/seminaires/ihm.php">Atelier IHM 2007</a></li>\\012</ul>\\012<h3>L&rsquo;atelier de l&rsquo;IRI explore trois objets de recherche technologiques principaux :</h3>\\012<p align="justify">ING&Eacute;NIERIE DES CONNAISSANCES ET ING&Eacute;NIERIE DOCUMENTAIRE DANS LES APPAREILS CRITIQUES<br />\\012&nbsp;&nbsp;&nbsp;&nbsp;L&rsquo;IRI &eacute;tudie, con&ccedil;oit et d&eacute;veloppe des outils d'annotation et des appareils critiques d&rsquo;un nouveau genre, bas&eacute;s sur la combinaison d&rsquo;architectures documentaires et de m&eacute;tadonn&eacute;es avec des interfaces de navigation hyperm&eacute;dia, des modules algorithmiques de d&eacute;tection du signal et des modules de repr&eacute;sentation de donn&eacute;es (cartographie). Le fruit de ces recherches est r&eacute;guli&egrave;rement int&eacute;gr&eacute; au logiciel Lignes de temps, plateforme d&rsquo;annotation en ligne et hors ligne pour l'annotation d&rsquo;objets temporels (films, enregistrements audio). Les recherches dans ce domaine sont &eacute;tendues progressivement au domaine de l&rsquo;annotation du langage oral et &eacute;crit et &agrave; l&rsquo;annotation d'images.</p>\\012<p align="justify">TECHNOLOGIES COLLABORATIVES<br />\\012&nbsp;&nbsp;&nbsp;&nbsp;L&rsquo;IRI m&egrave;ne une s&eacute;rie de recherches et d&rsquo;exp&eacute;rimentations notamment sur le concept de &laquo;Lectures sign&eacute;es collaboratives&raquo; combinant modes d&rsquo;annotations h&eacute;rit&eacute;s du livre et encore inexistants sur le web et nouveaux paradigmes pour le travail collaboratif. Un aspect important de ce th&egrave;me est &eacute;videmment la mise au point de technologies de suivi et d&rsquo;administration d&rsquo;&eacute;changes, de d&eacute;bats et de pol&eacute;miques appuy&eacute;s sur les langages d&rsquo;annotation mentionn&eacute;s dans l&rsquo;axe pr&eacute;c&eacute;dent. Cet objet de recherche recouvre en fait toutes les technologies d&rsquo;individuation psychique et collective et concerne &agrave; la fois les technologies de lecture active (lecture / &eacute;criture), les technologies de transcription permettant de passer du discours oral au discours &eacute;crit par exemple, et les outils de gestion de cercles.</p>\\012<p align="justify">INTERFACES MULTIMODALES ET MOBILIT&Eacute; DANS LES PRATIQUES INSTRUMENT&Eacute;ES<br />\\012&nbsp;&nbsp;&nbsp;&nbsp;La motricit&eacute; est un &eacute;l&eacute;ment capital de la capacit&eacute; du jugement : c&rsquo;est souvent en r&eacute;p&eacute;tant et en &laquo;gestualisant&raquo; une forme symbolique que l&rsquo;on peut le mieux l&rsquo;appr&eacute;hender. On vise particuli&egrave;rement dans cet axe l&rsquo;&eacute;tude et le d&eacute;veloppement de nouveaux dispositifs d&rsquo;adresse au public utilisant les dispositifs mobiles notamment dans le contexte mus&eacute;al, les interfaces multimodales (ou poly-sensorielles et notamment les techniques de d&eacute;tection du geste ou du regard) et plus g&eacute;n&eacute;ralement les questions de design num&eacute;rique qui se posent dans ce contexte.</p>\\012	1249384594	1249298194		0
2:bd0f0146d3e4144c83f9e87753bdd0e6	<h2>L'institut de recherche et d'innovation</h2>\\012<ul>\\012<li><a href="iri/membres">Membres</a></li>\\012<li><a href="iri/organisation">Organisation</a></li>\\012<li><a href="iri/recherches_theoriques">Recherches th&eacute;oriques</a></li>\\012<li><a href="iri/recherches_technologiques">Recherches technologiques</a></li>\\012<li><a href="/telecharger_lignes_de_temps">Lignes de temps</a></li>\\012<li><a href="iri/partenaires">Partenaires</a></li>\\012</ul>\\012<h2>Pr&eacute;sentation</h2>\\012<p>En 2006, le Centre Pompidou, sous l&rsquo;impulsion du philosophe Bernard Stiegler, a cr&eacute;&eacute; en son sein l'Institut de recherche et d'innovation (IRI) pour anticiper les mutations de l&rsquo;offre et de la consommation culturelle permises par les nouvelles technologies num&eacute;riques. En ao&ucirc;t 2008, l'IRI a acquis un statut d'association de recherche autonome co-fond&eacute;e par le Centre Pompidou, le Centre de Culture Contemporaine de Barcelone (CCCB) et Microsoft France.</p>\\012<p>Le programme de recherche de l&rsquo;IRI se d&eacute;veloppe sur un domaine de recherche qui est principalement celui des technologies culturelles et cognitives pour l&rsquo;adresse au public dans le contexte &eacute;mergent du web 2.0. et des r&eacute;seaux sociaux, et en vue de pr&eacute;figurer des technologies du web 3.0. con&ccedil;ues comme dispositifs collaboratifs de production et de partage d&rsquo;appareils critiques et d&rsquo;espaces critiques. Le but est de constituer de tels appareils et espaces critiques au service de cercles d&rsquo;amateurs. Cette hypoth&egrave;se, qui est centrale pour l&rsquo;avenir de toutes les pratiques culturelles, concerne cependant un champ beaucoup plus vaste. En v&eacute;rit&eacute;, il s&rsquo;agit de faire du champ de la culture un laboratoire pour penser l&rsquo;&eacute;volution de la soci&eacute;t&eacute; consum&eacute;riste qui s&rsquo;est mise en place au XX&egrave;me si&egrave;cle vers une soci&eacute;t&eacute; fond&eacute;e sur de nouvelles formes d&rsquo;&eacute;changes s&rsquo;appuyant sur la coop&eacute;ration.</p>\\012<p>Dans ce contexte, la m&eacute;thode de travail de l&rsquo;IRI s&rsquo;appuie sur trois activit&eacute;s :</p>\\012<ul>\\012<li>explorer des hypoth&egrave;ses quant au potentiel des technologies les plus r&eacute;centes des r&eacute;seaux et des objets communicants, par les activit&eacute;s de l&rsquo;Atelier, et par la mise en &oelig;uvre de groupes de recherche technologique associant &eacute;troitement ing&eacute;nieurs et praticiens des technologies maquett&eacute;es et prototyp&eacute;es par l&rsquo;IRI (artistes, critiques d&rsquo;arts, enseignants, amateurs, &eacute;tudiants, etc.),</li>\\012<li>th&eacute;oriser et formaliser au sein des activit&eacute;s du Coll&egrave;ge les r&eacute;sultats de ces travaux de recherche technologique pour les confronter aux objets de la recherche en sciences humaines en revisitant depuis ce contexte les questions les plus traditionnelles de disciplines aff&eacute;rant &agrave; l&rsquo;esth&eacute;tique, &agrave; l&rsquo;histoire de l&rsquo;art, &agrave; la psychologie, &agrave; la philosophie, principalement sous l&rsquo;angle des rapports de la vie de l&rsquo;esprit avec les techniques,</li>\\012<li>mettre en sc&egrave;ne, en oeuvre et &agrave; l&rsquo;&eacute;preuve les r&eacute;sultats de ces travaux, dans les espaces critiques o&ugrave; se forment (concentriquement) les cercles d&rsquo;amateurs, qui sont des espaces coop&eacute;ratifs de travail soit r&eacute;serv&eacute;s aux chercheurs, soit communs aux chercheurs, aux amateurs et &agrave; diff&eacute;rents publics.</li>\\012</ul>\\012<p>Cette approche s&rsquo;articule autour de trois probl&eacute;matiques th&eacute;oriques issues du champ des Sciences humaines et sociales (SHS) qui croisent trois objets de recherche technologique dans le champ des Sciences et technologies de l&rsquo;information et de la communication (STIC).</p>\\012<p>&nbsp;</p>\\012<h2>Pour en savoir plus</h2>\\012<p><a href="/iri/chronologie">Chronologie</a></p>\\012<p><a href="/res/media/DP_IRI.pdf" target="_blank"><img width="20" height="20" src="/res/img/pdf.gif" alt="format pdf" />Dossier de presse de l'IRI, mai 2009<br />\\012</a><a href="fr/lignesdetemps_confpresse.html">La conf&eacute;rence de presse du 14 mai 2009 dans <i>Lignes de temps</i></a><br />\\012<a href="http://www.tivipro.tv/salons_sshome.php?id_salon=319" target="_blank">Consulter les interviews faisant suite &agrave; la conf&eacute;rence de presse du 14 mai 2009 sur http://www.tivipro.tv</a><br />\\012<a href="/res/media/Flyer_IRI-nov_2008.pdf" target="_blank"><img width="20" height="20" src="/res/img/pdf.gif" alt="format pdf" />Consulter un flyer pr&eacute;sentant l'Iri</a>, mai 2008<br />\\012<a href="/res/media/presentation_iri.pdf" target="_blank"><img width="20" height="20" src="/res/img/pdf.gif" alt="format pdf" />Consulter un article pr&eacute;sentant l'Institut</a>, juillet 2008</p>\\012	1249394406	1249308006		0
2:1a42e464f09906367ca47b73241461b5	<p class="rteright"><a href="/lignes_de_temps_faq">Version fran&ccedil;aise</a></p>\\012<p>The software <i>Lignes de temps</i> is divided in two parts: system and interface.           <br />\\012The first one is not visible for users; it allows to record the work done (notes, sequences, rough-cut) in a file. It also permits to launch programs necessary to import an audio or video file. These programs encode video in order that it can be visible in the interface and that it can produce the shot by shot and the sound wave. <br />\\012The interface is composed by all the elements visible and controlled by users. It is composed by the top left menu (File, Display) and by three windows: Informations, the media player, and the one who displays the lignes de temps. <br />\\012The two parts of the program are connected but the communication can sometimes be interrupted, without any notification. In this case, the work can not unfortunately be recorded. The Institute for research and innovation works on those different problems. For any information, feedback or problem : <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a><br />\\012A work on <i>Lignes de temps</i> is saved in a project file (ldt extension) which holds references towards the media used and the personal data (notes, sequences, rough-cut). The non-personal data on one media (shot by shot and sound wave for example) are recorded in an iri extension file.</p>\\012<ul>\\012<li><b>I use a Mac, how can I know which is my configuration ?</b><br />\\012    To know if your computer is &quot;Intel&quot; or &quot;Power PC&quot;, you have to go in the Apple menu up left on the screen. In the menu, click on &quot;About this Mac&quot;. The line &quot;Processor&quot; indicates the type of configuration &quot;Intel&quot; or &quot;Power PC&quot;.<br />\\012    After many tests, it seems that <i>Lignes de temps</i> just settles on the computers with the operating system 10.5 called &quot;leopard&quot;, the 10.4 one called &quot;tiger&quot;, the Intel processor, or with the Power PC processor.</li>\\012<li><b>I do not succeed in displaying movies :</b><br />\\012    To display those lignes de temps, you have to click on the movie title in the lignes de temps window then on the tab &quot;Cuttings&quot;. In this tab, appears the list of the available sequences; you just have to click on one of them to display the corresponding ligne de temps.</li>\\012<li><b>I do not succeed in importing an audio or video file :</b><br />\\012    You have to make sure that the file extension can match. <i>Lignes de temps</i> takes into account avi, mpg, mov, flv extension for video and mp3 for audio. Then, even if this one is accepted, the encoding can not match with the program (ffmpeg) which transforms this file in a video readable in <i>Lignes de temps</i>, that is to say in the flv format. Even if the file extension is correct, some characters block the import. Thus, you should prefer naming your file without the following characters : accented characters, space, &ccedil;, #, &amp;, %, !, *, (), [], |, {}, :, ;, @.</li>\\012<li><b>I do not succeed in saving my work :</b><br />\\012    As it is explained in the introduction, this problem can come from a communication failure between the interface and the program part which records the work in a file. To record the works, we can go through the up left menu (Fichier -- Enregistrer) or through the hot key Ctrl+S on PCs and Apple+S on Macs. In general, when a work has been modified since the last recording, a star appears close the movie title in order to warn about a required recording.</li>\\012</ul>\\012<p>&nbsp;</p>\\012<p><b>Release notes about Lignes de temps 0.10.8 :</b></p>\\012<ul>\\012<li>Possibility to display the video in fullscreen with black background</li>\\012<li>Possibility to display a permalink for a segment</li>\\012<li>Possibility to display subtitles from an external TimedText XML file.</li>\\012<li>Possibility to display all the annotations (title and description) from one timeline in a large text field, fitted with a quick search module</li>\\012<li>Ergonomic improvements (timeline buttons rearranged, tags window resizable)</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps from 0.10.4 to 0.10.7 :</b></p>\\012<ul>\\012<li>Possibility to import cuttings from an other ldt file</li>\\012<li>Possibility to stream a video with rtmp://...</li>\\012<li>Possibility to move timelines and contents by simple drag and drop</li>\\012<li>Ergonomic improvements (ldt file name int the information window, zoom more fluid, possibility to save our default language)</li>\\012<li>Possibility to duplicate a timeline's highlighted segments</li>\\012<li>Debug</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.10.3 :</b></p>\\012<ul>\\012<li>Japanese language added</li>\\012<li>Debug</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.10 :</b></p>\\012<ul>\\012<li>MULTILINGUAL INTERFACE with English and French available by default and possibility to add some languages by yourself (the steps are explained in the <a href="/res/media/ldt_userguide_en.pdf" target="_blank">user guide</a> thanks to the GETTEXT tool)</li>\\012<li>Interface and ergonomy completely rebuilt, with for exemple buttons with icons, new tabs more visible, tool tips, confirmation messages before deleting.</li>\\012<li>Views : rename and move by drag and drop.</li>\\012<li>Tags : the complete project's tags list can be displayed from the top left menu or the shortcut Shift + T.</li>\\012<li>Note taking : better management of scroll position, timecode indicated on seperator roll over.</li>\\012<li>Bout &agrave; bout (edit) : an edit can now be deleted.</li>\\012<li>Bug <a href="/dev/trac/ldt" target="_blank">trac</a> added.</li>\\012<li>Complete user guide in <a href="/res/media/ldt_userguide_fr.pdf" target="_blank">french</a> and <a href="/res/media/ldt_userguide_en.pdf" target="_blank">english</a>.</li>\\012<li>License added in the &quot;About&quot;.</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.9.4 :</b></p>\\012<ul>\\012<li>New note-taking functionnality, enabling to write notes on the fly, then to transform them into a cutting.</li>\\012<li>Views : the display states backup includes now the zoom level, the horizontal scroll position and if a &quot;bout &agrave; bout&quot; is playing.</li>\\012<li>Improvement of tags addition : possibility to display a window with all the timeline's tags and to add one of them by simple click.</li>\\012<li>Possibility to display all the project's tags in a large window thanks to the shortcut Shift + F.</li>\\012<li>Possibility to highlight the segments by clicking one of the timeline's tags. 5 colors are available (one per tag), then requested segments are displayed in white.</li>\\012<li>Possibility to duplicate a timeline from highlighted segments only.</li>\\012<li>Possibility to create a bout &agrave; bout from a complete timeline or highlighted segments.</li>\\012<li>Addition of error messages when the software crashes. They limit the risk of work loss.</li>\\012</ul>\\012<p>\\012<b>Release notes about Lignes de temps 0.9.2 :</b></p>\\012<ul>\\012<li>Possibility of duplicating any line (duplication button in the Informations window).</li>\\012<li>Presence of the tag field for segments.</li>\\012<li>Possibility of displaying a sequence's summary, that is to say the sequences'list as a clickable text.</li>\\012<li>Debug of identified bugs in the previous version.</li>\\012<li>Interface's modifications : the &quot;Informations&quot; window enlarged in height and width, and the read-out window enlarged in width.</li>\\012</ul>\\012<p>&nbsp;</p>\\012	1250159986	1250073586		0
2:57401fd71e2853792d4b8c1b131b8032	<ul>\\012<li><a href="/telecharger_lignes_de_temps">T&eacute;l&eacute;charger Lignes De Temps</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire">S&eacute;minaires index&eacute;s dans Lignes De Temps</a>\\012<ul> <font size="1">\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/1">Figures de l'amateur</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/6">Mus&eacute;ologie 2007-2008</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/8">Mus&eacute;ologie 2008-2009</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/9">Politiques et technologies de l&rsquo;amateur</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/10">THD Cap Digital</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/11">Nanotechnologies</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/12">Modernisation</a></li>\\012<p>    </p></font>\\012    </ul>\\012</li>\\012<li><a href="http://www.iri.centrepompidou.fr/privatedoc/">S&eacute;minaires en audio</a></li>\\012<li><a href="http://www.thdculture.fr" target="_blank">THD Culture</a></li>\\012<li><a href="http://amateur.iri.centrepompidou.fr/nouveaumonde/enmi/conf/">Entretiens du Nouveau Monde Industriel</a></li>\\012<li><a href="/espaces_critiques">Espaces critiques</a></li>\\012</ul>\\012	1250588418	1250502018		0
2:3b224206a7a49f239f1bdaf4be7036df	<p>The software <i>Lignes de temps</i> is divided in two parts: system and interface.           <br />\\012The first one is not visible for users; it allows to record the work done (notes, sequences, rough-cut) in a file. It also permits to launch programs necessary to import an audio or video file. These programs encode video in order that it can be visible in the interface and that it can produce the shot by shot and the sound wave. <br />\\012The interface is composed by all the elements visible and controlled by users. It is composed by the top left menu (File, Display) and by three windows: Informations, the media player, and the one who displays the lignes de temps. <br />\\012The two parts of the program are connected but the communication can sometimes be interrupted, without any notification. In this case, the work can not unfortunately be recorded. The Institute for research and innovation works on those different problems. For any information, feedback or problem : <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a><br />\\012A work on <i>Lignes de temps</i> is saved in a project file (ldt extension) which holds references towards the media used and the personal data (notes, sequences, rough-cut). The non-personal data on one media (shot by shot and sound wave for example) are recorded in an iri extension file.</p>\\012<ul>\\012<li><b>I use a Mac, how can I know which is my configuration ?</b><br />\\012    To know if your computer is &quot;Intel&quot; or &quot;Power PC&quot;, you have to go in the Apple menu up left on the screen. In the menu, click on &quot;About this Mac&quot;. The line &quot;Processor&quot; indicates the type of configuration &quot;Intel&quot; or &quot;Power PC&quot;.<br />\\012    After many tests, it seems that <i>Lignes de temps</i> just settles on the computers with the operating system 10.5 called &quot;leopard&quot;, the 10.4 one called &quot;tiger&quot;, the Intel processor, or with the Power PC processor.</li>\\012<li><b>I do not succeed in displaying movies :</b><br />\\012    To display those lignes de temps, you have to click on the movie title in the lignes de temps window then on the tab &quot;Cuttings&quot;. In this tab, appears the list of the available sequences; you just have to click on one of them to display the corresponding ligne de temps.</li>\\012<li><b>I do not succeed in importing an audio or video file :</b><br />\\012    You have to make sure that the file extension can match. <i>Lignes de temps</i> takes into account avi, mpg, mov, flv extension for video and mp3 for audio. Then, even if this one is accepted, the encoding can not match with the program (ffmpeg) which transforms this file in a video readable in <i>Lignes de temps</i>, that is to say in the flv format. Even if the file extension is correct, some characters block the import. Thus, you should prefer naming your file without the following characters : accented characters, space, &ccedil;, #, &amp;, %, !, *, (), [], |, {}, :, ;, @.</li>\\012<li><b>I do not succeed in saving my work :</b><br />\\012    As it is explained in the introduction, this problem can come from a communication failure between the interface and the program part which records the work in a file. To record the works, we can go through the up left menu (Fichier -- Enregistrer) or through the hot key Ctrl+S on PCs and Apple+S on Macs. In general, when a work has been modified since the last recording, a star appears close the movie title in order to warn about a required recording.</li>\\012</ul>\\012<p>&nbsp;</p>\\012<p>&nbsp;</p>\\012<p><b>Release notes about Lignes de temps 0.10.8 :</b></p>\\012<ul>\\012<li>Possibility to display the video in fullscreen with black background</li>\\012<li>Possibility to display a permalink for a segment</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps from 0.10.4 to 0.10.7 :</b></p>\\012<ul>\\012<li>Possibility to import cuttings from an other ldt file</li>\\012<li>Possibility to stream a video with rtmp://...</li>\\012<li>Possibility to move timelines and contents by simple drag and drop</li>\\012<li>Ergonomic improvements (ldt file name int the information window, zoom more fluid, possibility to save our default language)</li>\\012<li>Possibility to duplicate a timeline's highlighted segments</li>\\012<li>Debug</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.10.3 :</b></p>\\012<ul>\\012<li>Japanese language added</li>\\012<li>Debug</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.10 :</b></p>\\012<ul>\\012<li>MULTILINGUAL INTERFACE with English and French available by default and possibility to add some languages by yourself (the steps are explained in the <a target="_blank" href="http://www.iri.centrepompidou.fr/res/media/ldt_userguide_en.pdf">user guide</a> thanks to the GETTEXT tool)</li>\\012<li>Interface and ergonomy completely rebuilt, with for exemple buttons with icons, new tabs more visible, tool tips, confirmation messages before deleting.</li>\\012<li>Views : rename and move by drag and drop.</li>\\012<li>Tags : the complete project's tags list can be displayed from the top left menu or the shortcut Shift + T.</li>\\012<li>Note taking : better management of scroll position, timecode indicated on seperator roll over.</li>\\012<li>Bout &agrave; bout (edit) : an edit can now be deleted.</li>\\012<li>Bug <a target="_blank" href="/dev/trac/ldt">trac</a> added.</li>\\012<li>Complete user guide in <a target="_blank" href="/res/media/ldt_userguide_fr.pdf">french</a> and <a target="_blank" href="/res/media/ldt_userguide_en.pdf">english</a>.</li>\\012<li>License added in the &quot;About&quot;.</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.9.4 :</b></p>\\012<ul>\\012<li>New note-taking functionnality, enabling to write notes on the fly, then to transform them into a cutting.</li>\\012<li>Views : the display states backup includes now the zoom level, the horizontal scroll position and if a &quot;bout &agrave; bout&quot; is playing.</li>\\012<li>Improvement of tags addition : possibility to display a window with all the timeline's tags and to add one of them by simple click.</li>\\012<li>Possibility to display all the project's tags in a large window thanks to the shortcut Shift + F.</li>\\012<li>Possibility to highlight the segments by clicking one of the timeline's tags. 5 colors are available (one per tag), then requested segments are displayed in white.</li>\\012<li>Possibility to duplicate a timeline from highlighted segments only.</li>\\012<li>Possibility to create a bout &agrave; bout from a complete timeline or highlighted segments.</li>\\012<li>Addition of error messages when the software crashes. They limit the risk of work loss.</li>\\012</ul>\\012<p>\\012<b>Release notes about Lignes de temps 0.9.2 :</b></p>\\012<ul>\\012<li>Possibility of duplicating any line (duplication button in the Informations window).</li>\\012<li>Presence of the tag field for segments.</li>\\012<li>Possibility of displaying a sequence's summary, that is to say the sequences'list as a clickable text.</li>\\012<li>Debug of identified bugs in the previous version.</li>\\012<li>Interface's modifications : the &quot;Informations&quot; window enlarged in height and width, and the read-out window enlarged in width.</li>\\012</ul>\\012<p>&nbsp;</p>\\012	1249137430	1249051030		0
2:37e7222726d6ad0973b5f6ffb8fdf471	<p><img width="250px" hspace="20" alt="" style="float: right;" src="/res/img/0151.jpg" />Les espaces critiques sont le lieu o&ugrave; se forment (concentriquement) les cercles d&rsquo;amateurs, qui sont des espaces coop&eacute;ratifs de travail soit r&eacute;serv&eacute;s aux chercheurs, soit communs aux chercheurs, aux amateurs et &agrave; diff&eacute;rents publics.             Constitu&eacute; par un dispositif d'acc&egrave;s &agrave; des ressources documentaires de r&eacute;f&eacute;rence, &agrave; des &eacute;l&eacute;ments critiques relatifs &agrave; la programmation du Centre Pompidou et aux outils d'annotation d&eacute;velopp&eacute;s par l'Institut. </p>\\012<p>Le site d&rsquo;&eacute;criture et d&rsquo;annotation collaborative <i>L&rsquo;Amateur</i> construit autour de <i>Lignes de temps</i> a ainsi pour objectif de constituer des cercles d&rsquo;amateurs en fournissant au public les documents et outils collaboratifs n&eacute;cessaires &agrave; l&rsquo;exploration d&rsquo;un th&egrave;me ou d&rsquo;un &eacute;v&eacute;nement. Cette plate-forme est actuellement principalement utilis&eacute;e pour deux projets &eacute;ditoriaux: le site d&rsquo;annotation collaborative aliment&eacute; par audioguides et mobiles pour l&rsquo;exposition <i>Traces du sacr&eacute;</i> et les annales des <i>Entretiens du nouveau monde industriel</i>.             Ce dispositif offre la possibilit&eacute; de consulter des contenus critiques propos&eacute;s par une &eacute;quipe &eacute;ditoriale et des personnalit&eacute;s associ&eacute;es, mais &eacute;galement par tous les membres inscrits sur le site (les amateurs). Le site se veut collaboratif en offrant la possibilit&eacute; de &laquo;signatures&raquo; multiples, et critique en &eacute;tant organis&eacute; par fils de discussion o&ugrave; les membres peuvent contribuer et d&eacute;battre autour des commentaires publi&eacute;s &agrave; travers des technologies de coop&eacute;ratives de savoirs appropri&eacute;es.</p>\\012<p>&nbsp;</p>\\012<h2><a href="http://web.iri.centrepompidou.fr/traces">Un nouveau regard sur les &oelig;uvres d'Abbas Kiarostami et de V&iacute;ctor Erice :</a></h2>\\012<p>Dans le cadre de sa mission de  r&eacute;flexion sur les nouveaux modes d&rsquo;adresse au public, et &agrave; l&rsquo;occasion de  l&rsquo;exposition &laquo;&nbsp;Erice / Kiarostami&nbsp;: Correspondances&nbsp;&raquo;,  l&rsquo;Institut de Recherche et d&rsquo;Innovation (IRI) a d&eacute;velopp&eacute; et mis en &oelig;uvre, &agrave;  titre exp&eacute;rimental, un dispositif d&rsquo;analyse critique permettant &agrave; la fois de  confronter les points de vue singuliers des spectateurs et d&rsquo;ouvrir la voie &agrave;  de nouvelles modalit&eacute;s de partage de l&rsquo;exp&eacute;rience esth&eacute;tique.</p>\\012<p><a href="http://web.iri.centrepompidou.fr/pop_site.html"><img width="797" height="534" border="4" src="/res/img/TdS-Screen.jpg" alt="Traces du Sacr&eacute;" longdesc="http://web.iri.centrepompidou.fr/pop_site.html" /></a></p>\\012<p><a href="/res/media/CP-Lignes_de_tempsDEF.pdf" target="_blank"><img width="20" height="20" src="/res/img/pdf.gif" alt="format pdf" class="image" /> Consulter le communiqu&eacute; de presse de l&rsquo;Espace Lignes de temps (exposition V&iacute;ctor Erice / Abbas Kiarostami : Correspondances</a></p>\\012<p>&nbsp;</p>\\012<h2><a href="http://web.iri.centrepompidou.fr/traces">Traces du sacr&eacute; : </a></h2>\\012<p>&Agrave; l&rsquo;occasion de l&rsquo;exposition <i>Traces du sacr&eacute;</i>, en &eacute;troite collaboration avec la Direction de l&rsquo;action &eacute;ducative et des publics (DAEP) du Centre Pompidou et en partenariat avec la soci&eacute;t&eacute; Antenna Audio, l&rsquo;Institut de recherche et d&rsquo;innovation propose au visiteur la possibilit&eacute; d&rsquo;acc&eacute;der &agrave; une plate-forme collaborative de d&eacute;bat autour de l&rsquo;exposition. </p>\\012<p>Pour enrichir l&rsquo;exp&eacute;rience de la visite de l'exposition <i>Traces du sacr&eacute;</i> (Centre Pompidou, 7 mai - 11 ao&ucirc;t 2008), un dispositif multim&eacute;dia d&rsquo;un type nouveau est/&eacute;tait disponible pour &eacute;couter les propos des commissaires et de personnalit&eacute;s du monde de la culture, et enregistrer ses propres observations &agrave; partir du guide multim&eacute;dia ou de son t&eacute;l&eacute;phone portable. Chaque visiteur peut/pouvait ensuite retrouver via Internet ses commentaires audio et les enrichir &agrave; son gr&eacute;, notamment &agrave; l&rsquo;aide du logiciel <i>Lignes de temps</i>, avant de les publier sur un site collaboratif d&eacute;velopp&eacute; &agrave; cette occasion.</p>\\012<p>\\012<a href="http://web.iri.centrepompidou.fr/traces"><img border="0" src="/res/img/traces_du_sacre_iri_1.png" alt="Traces du sacr&eacute;" /></a><br />\\012<font size="1">Cr&eacute;dits visuels : Jakob von Narkiewicz-Jodko, Effluves d'une main &eacute;lectrifi&eacute;e pos&eacute;e sur la plaque photographique, mars 1896, &Eacute;preuve &agrave; la g&eacute;latine argentique, 18,1 x 12,9 cm, Fonds Camille Flammarion, Soci&eacute;t&eacute; astronomique de France</font></p>\\012<p>Pour consulter les enregistrements : <a href="http://web.iri.centrepompidou.fr/traces">http://web.iri.centrepompidou.fr/traces</a></p>\\012<p>&nbsp;</p>\\012<h2>\\012<a href="http://www.festivalpocketfilms.fr/article.php3?id_article=598" target="_blank">La participation de l'IRI au Pocket Film Festival: les nouvelles pratiques vid&eacute;o sur mobiles </a></h2>\\012<p><strong>Organis&eacute; par l&rsquo;Institut de  Recherche et d&rsquo;Innovation (I.R.I.) du Centre Pompidou, cet atelier  (vendredi 8 juin 11h30 petite salle) propose un &eacute;tat des lieux de quelques recherches actuellement men&eacute;es  sur les nouvelles pratiques vid&eacute;o sur mobiles, quinze jours apr&egrave;s le  Web Flash Festival &eacute;galement organis&eacute; au Centre Pompidou du 25 au 27  mai 2007.</strong></p>\\012<p>Il s&rsquo;agit tout d&rsquo;abord de montrer combien les liens  entre les communaut&eacute;s de pratiques, sur le Web d&rsquo;une part et sur  mobiles d&rsquo;autre part, s&rsquo;influencent mutuellement et conditionnent  &eacute;galement l&rsquo;&eacute;volution des d&eacute;veloppements men&eacute;s par l&rsquo;industrie et les  centres de recherche.</p>\\012<p>Cet atelier tente &eacute;galement d&rsquo;examiner comment cette  convergence rapide entre sites vid&eacute;o collaboratifs et pratiques vid&eacute;o  sur mobiles favorise l&rsquo;apparition de nouveaux cercles d&rsquo;amateurs et de  nouvelles pratiques artistiques, critiques ou de recherche d&eacute;tournant  parfois les technologies dans des directions inattendues.</p>\\012<p>L&rsquo;IRI du Centre Pompidou a sollicit&eacute; des  intervenants au niveau international sur diff&eacute;rentes th&eacute;matiques  &eacute;mergentes. On peut citer les recherches visant &agrave; concevoir de  nouvelles ergonomies multimodales sur les terminaux mobiles  (utilisation combin&eacute;e de la voix, du clavier et de la capture vid&eacute;o),  les outils de montage, de mixage ou de transcodage vid&eacute;o accessibles en  ligne et enfin les solutions d&rsquo;annotation et de partage des vid&eacute;os  auto-produites dans le contexte du Web 2.0.</p>\\012<p><em>Interventions</em>&nbsp;:</p>\\012<p><strong>Isao Ohashi</strong> (pr&eacute;sident  de DoCoMo i-mode Europe B.V.) intervient sur&nbsp;: Le positionnement de  DoCoMo et du i-mode au Japon, les d&eacute;veloppements r&eacute;cents sur les  nouveaux contenus et service.<br />\\012<strong>Juha Kaario</strong> (responsable de recherche,  Centre de recherche Nokia - Big Stories On A Small Screen) intervient  sur&nbsp;: La cr&eacute;ation de contenus collaboratifs.<br />\\012<strong>Vincent Puig, Xavier Sirven, Thibaut Cavali&eacute;, Baptiste Bouillot</strong> (Institut de Recherche et d&rsquo;Innovation du Centre Pompidou), <strong>Nancy Proctor, Silvia Filippini Fantoni</strong> (Antenna Audio) (sous r&eacute;serve), interviennent &agrave; propos de&nbsp;:  L&rsquo;exp&eacute;rimentation en cours sur terminaux mobiles dans le cadre du  projet RIAM CineLab et de l&rsquo;exposition Victor Erice - Abbas Kiarostami,  Correspondances (Centre Pompidou, 19 septembre 2007 - 7 janvier 2008).</p>\\012<p><a href="http://www.festivalpocketfilms.fr/article.php3?id_article=598" target="_blank"><img width="88" height="116" alt="" src="http://www.festivalpocketfilms.fr/dist/images/logo_pocket_films.gif" class="image" /></a><img width="102" height="58" alt="" src="/res/img/logo_forum_des_images.gif" /></p>\\012<p>&nbsp;</p>\\012<h2>\\012<a href="3espaces.html">La participation de l'IRI aux &quot;3 Espaces aux Halles&quot;: un r&eacute;cit &agrave; vivre, &agrave; lire, &agrave; jouer </a></h2>\\012<p><b>Semaine techno-po&eacute;tique de la ville num&eacute;rique</b><br />\\012D'apr&egrave;s <i>Le R&eacute;cit des 3 espaces</i> de Carole Lypsic.</p>\\012<p>Aujourd'hui, &agrave; l'&eacute;poque du num&eacute;rique et de la ville communicante, il est possible de raconter des histoires autrement. C'est le pari relev&eacute; par Le R&eacute;cit des 3 Espaces, r&eacute;cit interactif d'un nouveau genre, le r&eacute;cit variable, qui sera diffus&eacute; pendant une semaine sur tous les m&eacute;dias du Forum des Halles du 12 au 18 mars 2008.</p>\\012<p>Parcours po&eacute;tiques, projections, flashcodes, bornes interactives, Bluetooth, messages audio, th&eacute;&acirc;tre de rue, cin&eacute;ma, Internet, Second Life, sms, mails, panneaux lumineux de la ville, jeux, concours, ateliers...</p>\\012<p>Site web de l'&eacute;v&eacute;nement : <a href="http://www.3espaces.com" target="_blank">http://www.3espaces.com</a></p>\\012<p>L'IRI accueille des ateliers scolaires en deux parties :</p>\\012<ul>\\012<li>en salle informatique &agrave; l'IRI / Centre Pompidou, avec d&eacute;couverte du R&eacute;cit des 3 Espaces et de sa console interactive de lecture et d'&eacute;criture.</li>\\012<li>in situ avec visite guid&eacute;e de l'installation ou avec jeux.</li>\\012</ul>\\012<p>&nbsp;</p>\\012<p>&nbsp;</p>\\012<p align="center"><img src="/res/img/visuel_halles.png" alt="3 Espaces aux Halles" /></p>\\012<p><a href="/res/media/CP-CP_3Espaces_aux_Halles-IRI.pdf" target="_blank"><img width="20" height="20" border="0" src="/res/img/pdf.gif" alt="format pdf" class="image" /></a><a href="/res/media/CP_3Espaces_aux_Halles-IRI.pdf" target="_blank">Communiqu&eacute; de presse du 3 mars 2008 </a> (FR)</p>\\012	1249138807	1249052407		0
2:de843187e64ec329f23d3a526c923d2c	<p>Projet - <a href="/ma_ville_vue_par/etapes">Etapes</a> - <a href="/ma_ville_vue_par/generique">G&eacute;n&eacute;rique</a></p>\\012<p><strong>Un projet d&rsquo;&eacute;changes culturels entre&nbsp; jeunes de la Communaut&eacute; europ&eacute;enne / 2008-2009</strong><br />\\012&laquo; Films-essais &raquo; / &laquo; Films-regards &raquo; / &laquo; Regards sign&eacute;s Lignes de temps &raquo; / D&eacute;bats&hellip;</p>\\012<p>2008 &ndash; Ann&eacute;e europ&eacute;enne du dialogue interculturel<br />\\0122009 &ndash; Ann&eacute;e europ&eacute;enne de la cr&eacute;ativit&eacute; et de l&rsquo;innovation</p>\\012<p><strong>Regards crois&eacute;s sur la ville, &eacute;changes de points de vue, cr&eacute;ation&hellip; </strong><br />\\012&nbsp;&laquo; Ma ville vue par&hellip;&nbsp; &raquo; vise &agrave; encourager l&rsquo;&eacute;change culturel entre jeunes gens de l&rsquo;Union europ&eacute;enne via une approche analytique et cr&eacute;ative du cin&eacute;ma.</p>\\012<p><strong>Une collaboration</strong><br />\\012Centre Pompidou / Institut de recherche et d&rsquo;innovation / Maison du geste et de l&rsquo;image</p>\\012<p><strong>Liens :</strong><br />\\012<a href="http://www.mgi-paris.org/site2009/index.php" target="_blank">http://www.mgi-paris.org/site2009/index.php</a><br />\\012<a href="http://www.centrepompidou.fr/" target="_blank">http://www.centrepompidou.fr/</a></p>\\012<p><strong>Etablissements europ&eacute;ens partenaires</strong><br />\\012Berufskolleg, Herzogenrath, (Allemagne)<br />\\012Colegiul national B.P. Hasdeu, Buzau (Roumanie)<br />\\012Colegiul national I. C. Bratianu, Pitesti (Roumanie)<br />\\012Colegiul national Mihai Eminescu, Iasi (Roumanie)<br />\\012Colegiul national Radu Negru, Fagaras (Roumanie) <br />\\012Coll&egrave;ge Thomas Mann, Paris 13&egrave;me (France)<br />\\012Coll&egrave;ge Darius Milhaud, Sartrouville (France)<br />\\012Coll&egrave;ge Jean Moulin, Paris 14&egrave;me (France)<br />\\012Ecole &agrave; aires ouvertes Saint-Merri et Renard, Paris 4&egrave;me (France)<br />\\012Ecole &eacute;l&eacute;mentaire Maurice Genevoix, Paris 18&egrave;me (France)<br />\\012Liceo classico M. Gioia, Piacenza (Italie) <br />\\012Lyc&eacute;e Maurice Ravel, Paris 20&egrave;me (France)<br />\\012Lyc&eacute;e Paul Val&eacute;ry, Paris 12&egrave;me (France)<br />\\012Scuola centrala n&deg; 10, Bucarest (Roumanie)<br />\\012Scuola media Irnerio, Bologne (Italie)<br />\\012&nbsp;</p>\\012<p>&nbsp;</p>\\012<div>Le projet europ&eacute;en &laquo;&nbsp;Ma ville vue par&hellip;&nbsp;&raquo; a &eacute;t&eacute; initi&eacute; dans le cadre du <b>D&eacute;partement du d&eacute;veloppement culturel / Centre Pompidou</b> en mai 2008. Il fait suite au travail d&rsquo;exp&eacute;rimentation sur le cin&eacute;ma avec le logiciel <i>Lignes de temps</i><span> men&eacute; lors de la programmation au Centre Pompidou des films de V&iacute;ctor Erice et d&rsquo;Abbas Kiarostami. </span></div>\\012<div>Fond&eacute;<span> en avril 2006 au sein du DDC-Centre Pompidou et constitu&eacute; en association depuis ao&ucirc;t 2008, <b>l</b><b>'Institut de recherche et d'innovation</b></span> travaille sur l'&eacute;tude et le d&eacute;veloppement de technologies culturelles et <span>cognitives favorisant l'&eacute;mergence de nouvelles pratiques amateurs. L&rsquo;Iri met librement &agrave; la disposition du public le logiciel <i>Lignes de temps,</i> accompagn&eacute; pour ce type de projet, d&rsquo;une analyse document&eacute;e et comment&eacute;e des films &eacute;tudi&eacute;s. </span></div>\\012<div>La <b>Maison du geste et de l&rsquo;image</b>, centre de recherche et d&rsquo;&eacute;ducation artistique est aussi une structure de &laquo;&nbsp;m&eacute;diation&nbsp;&raquo; culturelle. Interm&eacute;diaire entre les &eacute;tablissements scolaires et culturels, la MGI accompagne et coordonne des projets, en initie, propose des formations et des pr&eacute;sentations li&eacute;es &agrave; l&rsquo;initiation artistique des publics jeunes. Il s&rsquo;agit de mettre ce public au contact direct de la  cr&eacute;ation et des cr&eacute;ateurs, de lui permettre de s&rsquo;engager dans une d&eacute;marche de cr&eacute;ation collective.</div>\\012<div>&nbsp;</div>\\012<div>Le cin&eacute;ma et la citoyennet&eacute; <b><span>Rencontres</span></b><b> europ&eacute;ennes&nbsp;; &eacute;changes culturels&nbsp;; partage de connaissance&nbsp;; &eacute;changes de points de vue&hellip;</b></div>\\012<div><b>&nbsp;</b></div>\\012<div>Le cin&eacute;ma et la ville<span>  &nbsp;Regards crois&eacute;s sur la ville, &eacute;changes de points de vue, cr&eacute;ation&nbsp;; </span>Innovation&nbsp;; d&eacute;couverte du langage cin&eacute;matographique&nbsp;; cr&eacute;ativit&eacute;&nbsp;; parcours guid&eacute; de cr&eacute;ation aux fins d&rsquo;une correspondance entre bin&ocirc;mes sous forme de production de &laquo;&nbsp;films-essais&nbsp;&raquo; sur sa propre ville (sc&eacute;narisation, tournage, montage)&nbsp;; exploration du point de vue d&rsquo;autrui &agrave; travers la relecture de son propre film par les autres&nbsp;(montage d&rsquo;un &laquo;&nbsp;film-regard&nbsp;&raquo; &agrave; partir des rushes produits par son partenaire)&nbsp;; projections des films&nbsp;; rencontres des participants&hellip;.</div>\\012<div>Le cin&eacute;ma entretient, depuis son origine, (Les fr&egrave;res Lumi&egrave;re&nbsp;: <i>L&rsquo;Arriv&eacute;e d&rsquo;un train en gare de la Ciotat</i>) un rapport privil&eacute;gi&eacute; avec la  ville. D&eacute;cor autant que personnage la ville occupe une place centrale dans bien des &oelig;uvres, &agrave; tel point que son image fictionnelle prend parfois le pas sur la r&eacute;alit&eacute;. Sa pr&eacute;sence impr&egrave;gne les films d&rsquo;une aura particuli&egrave;re et les place sous le sceau d&rsquo;une culture.</div>\\012<div>L&rsquo;espace urbain comprend une identit&eacute; forte, r&eacute;v&eacute;latrice du pays et de son histoire. Il incarne une culture tout enti&egrave;re. Et, si chacun entretient un rapport affectif avec sa propre ville, celle de l&rsquo;autre ne repr&eacute;sente trop souvent qu&rsquo;une carte postale, un souvenir ou un voyage imaginaire. Parler de sa ville &agrave; l&rsquo;autre, ou de la ville de l&rsquo;autre, c&rsquo;est partager une intimit&eacute;, une identit&eacute;, bien au-del&agrave; des clich&eacute;s. C&rsquo;est offrir un quotidien, un regard authentique sur sa vie. Par l&rsquo;&eacute;change des exp&eacute;riences et des regards, le cin&eacute;ma peut devenir le lieu d&rsquo;une telle rencontre.</div>\\012<div>&nbsp;</div>\\012<div>Les films de r&eacute;f&eacute;rence Les films propos&eacute;s &agrave; l&rsquo;analyse aux &eacute;l&egrave;ves partenaires du projet &nbsp;sont &laquo;&nbsp;Le Cam&eacute;raman&nbsp;&raquo; d&rsquo;Edward Sedgwick et Buster Keaton, avec Buster Keaton et &laquo;&nbsp;L&rsquo;Aurore&nbsp;&raquo; de Wilhelm Friedrich Murnau.</div>\\012<div>&nbsp;</div>\\012<div>Le Cam&eacute;raman</div>\\012<div>Etats-Unis 1928</div>\\012<div>Cor&eacute;alisation&nbsp;: Buster Keaton, Edward Sedgwick</div>\\012<div>Avec Buster Keaton, Marceline Day, Harold Goodwin</div>\\012<div align="left">Les aventures de Buster, photographe de rue, sp&eacute;cialis&eacute; dans les daguerr&eacute;otypes dans le New York des ann&eacute;es 20.</div>\\012<div><a href="http://fr.wikipedia.org/wiki/Le_Cameraman" target="_blank">http://fr.wikipedia.org/wiki/Le_Cameraman</a></div>\\012<div align="left"><a href="http://www.cineclubdecaen.com/realisat/keaton/cameraman.htm" target="_blank">http://www.cineclubdecaen.com/realisat/keaton/cameraman.htm</a></div>\\012<div align="left"><a href="http://www.critikat.com/Le-Cameraman.html" target="_blank">http://www.critikat.com/Le-Cameraman.html</a></div>\\012<div>&nbsp;</div>\\012<div>Sunrise&nbsp;- Aurore (L')</div>\\012<div>Etats-Unis, 1927</div>\\012<div>R&eacute;alisation&nbsp; Friedrich-Wilhelm Murnau</div>\\012<div>Sc&eacute;nario : Friedrich-Wilhelm Murnau d'apr&egrave;s <i><span>Le Voyage &agrave; Tilsitt</span></i> de Hermann S&uuml;dermann</div>\\012<div>Avec George O'Brien, Janet Gaynor, Margaret Livingstone, Bodil Rosing</div>\\012<div>Photo Karl Struss, Charles Rosher</div>\\012<div>Musique&nbsp;Dr Hugo Riesenfeld</div>\\012<div>Dur&eacute;e&nbsp;1h20</div>\\012<div>S&eacute;duit par une intrigante de la ville, un fermier tente de noyer son &eacute;pouse lors d'une promenade sur le lac. Pris de remords, il ne parvient pas &agrave; commettre son crime. La jeune femme s&rsquo;enfuit.</div>\\012<div><a href="http://fr.wikipedia.org/wiki/L%27Aurore_%28film,_1927%29" target="_blank">http://fr.wikipedia.org/wiki/L'Aurore_(film,_1927)</a></div>\\012<div><a href="http://www.abc-lefrance.com/fiches/Aurore.pdf" target="_blank">http://www.abc-lefrance.com/fiches/Aurore.pdf</a></div>\\012<div><a href="http://www.cineclubdecaen.com/realisat/murnau/aurore.htm" target="_blank">http://www.cineclubdecaen.com/realisat/murnau/aurore.htm</a>).</div>\\012<div><b>&nbsp;</b></div>\\012<div>Le r&eacute;seau d&rsquo;&eacute;tablissements scolaires constitu&eacute; &agrave; partir des partenariats d&eacute;j&agrave; engag&eacute;s lors du projet Erice-Kiarostami s&rsquo;est &eacute;tendu &agrave; l&rsquo;Europe. Il r&eacute;unit une quinzaine d&rsquo;&eacute;tablissements pour une vingtaine de bin&ocirc;mes de m&ecirc;me niveau et qui travaillent selon les cas dans ou hors temps scolaire.</div>\\012<div>&nbsp;</div>\\012<div>Les pays participants Allemagne, France, Italie, Roumanie&hellip;</div>\\012<div>&nbsp;</div>\\012<div>Les (bin&ocirc;mes Une fois form&eacute;s - groupe ou classe fran&ccedil;aise et groupe ou classe d&rsquo;un pays europ&eacute;en -, r&eacute;unis en fonction de l&rsquo;&acirc;ge, du niveau, ainsi que des demandes sp&eacute;cifiques des participants), la relation &nbsp;des partenaires s&rsquo;organise autour d&rsquo;une s&eacute;rie d&rsquo;&eacute;tapes envisag&eacute;es avec les enseignants.</div>\\012<p>&nbsp;</p>\\012	1249382784	1249296384		0
2:e9ae68de194bee1d140eb67da4d5daaf	<p><a href="/ma_ville_vue_par">Projet</a> - <a href="/ma_ville_vue_par/etapes">Etapes</a> - G&eacute;n&eacute;rique - <a href="/ma_ville_vue_par/binomes">Bin&ocirc;mes</a></p>\\012<p>&nbsp;</p>\\012<h4>PARTENAIRES</h4>\\012<div>&nbsp;</div>\\012<div>Ce projet a pu &ecirc;tre men&eacute; &agrave; bien gr&acirc;ce &agrave; l&rsquo;aide pr&eacute;cieuse de</div>\\012<div>L&rsquo;Ambassade de France en Roumanie, Bucarest</div>\\012<div>Le Centre culturel su&eacute;dois, Paris</div>\\012<div>L&rsquo;Institut culturel roumain, Paris</div>\\012<div>L&rsquo;Institut fran&ccedil;ais, Berlin</div>\\012<div>La Mairie de Paris / Mission cin&eacute;ma</div>\\012<div>Le Rectorat de Paris / Dareic et Mission innovation</div>\\012<div>&nbsp;</div>\\012<div><a href="http://www.ambafrance-ro.org/">http://www.ambafrance-ro.org/</a></div>\\012<div><a href="http://www.si.se/Centre-culturel-suedois/Francais/Centre-culturel-suedois/">http://www.si.se/Centre-culturel-suedois/Francais/Centre-culturel-suedois/</a></div>\\012<div><a href="http://www.institut-roumain.org/">http://www.institut-roumain.org/</a></div>\\012<div><a href="http://www.institut-francais.fr/">http://www.institut-francais.fr/</a></div>\\012<div><a href="http://www.paris.fr/portail/Culture/Portal.lut?page_id=8358&amp;document_type_id=5&amp;document_id=36017&amp;portlet_id=19409" target="_blank">http://www.paris.fr/portail/Culture/Portal.lut?page_id=8358&amp;document_type_id=5&amp;document_id=36017&amp;portlet_id=19409</a></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<h4>EQUIPE</h4>\\012<div><u><br />\\012</u></div>\\012<div>D&eacute;partement du d&eacute;veloppement culturel-Centre Pompidou,</div>\\012<div><b>Fr&eacute;d&eacute;rique Mirotchnikoff</b> direction du projet.</div>\\012<div>&nbsp;</div>\\012<div>Intervenants</div>\\012<div><b>Marta Boni</b> doctorante en cin&eacute;ma, direction des Ateliers <i>Lignes de temps.</i></div>\\012<div><b>Lila Pinell</b> r&eacute;alisatrice, membre de l&rsquo;association <i>b&eacute;tonsalon</i>, direction des tournages dans des &eacute;tablissements scolaires partenaires.</div>\\012<div><b>Aurore Frey</b> &eacute;tudiante en cin&eacute;ma</div>\\012<div>&nbsp;</div>\\012<div>Stagiaires</div>\\012<div><b>Esther Baucher</b></div>\\012<div><b>Elodie Bertrand</b></div>\\012<div><b>Sophie Besson</b></div>\\012<div><b>Ma&euml;lys Bourgoin</b></div>\\012<div><b>Laure Grimaldi</b></div>\\012<div><b>Alexandre Marques</b></div>\\012<div>&nbsp;</div>\\012<div>Institut de recherche et d&rsquo;innovation-Centre Pompidou</div>\\012<div><b>Bernard Stiegler</b><b>,</b> directeur</div>\\012<div><b>Vincent Puig</b><b>,</b> directeur-adjoint</div>\\012<div><b>Thibaut Cavali&eacute;</b>, chef de projet - ing&eacute;nieur logiciel <i>Lignes de temps</i></div>\\012<div><b>Fanny Belvisi,</b> charg&eacute;e d&rsquo;administration et de communication</div>\\012<div><b>Yves-Marie L&rsquo;Hour,</b> responsable &eacute;ditorial</div>\\012<div><b>Yves-Marie Haussonne</b>, chef de projet web</div>\\012<div>&nbsp;</div>\\012<div>Maison du geste et de l&rsquo;image</div>\\012<div><b>Evelyne Panato </b>directrice</div>\\012<div><b>Laurent Geniller</b> coordinateur vid&eacute;o</div>\\012<div>Et l&rsquo;&eacute;quipe de la MGI</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<p>&nbsp;</p>\\012<p>&nbsp;</p>\\012<h4>REMERCIEMENTS</h4>\\012<div>&nbsp;</div>\\012<div>Pour leur chaleureux soutien</div>\\012<div>&nbsp;</div>\\012<div>Jean-Christophe  Aguas</div>\\012<div>Marion Alluchon</div>\\012<div>Alain Bergala</div>\\012<div>Lucile Bruand-Exner</div>\\012<div>Elisabeth Caillet</div>\\012<div>S&eacute;bastien Canevet</div>\\012<div>Magda Carneci</div>\\012<div>Jean-Louis Comolli</div>\\012<div>Yves Clerget</div>\\012<div>Simona Edwards</div>\\012<div>Laurence  Emile-Besse</div>\\012<div>Anne-Sophie  Fran&ccedil;ois</div>\\012<div>Cezar Grumazescu</div>\\012<div>Alexis J&auml;derholm</div>\\012<div>Marie Kraft</div>\\012<div>Sonia Ouchelli</div>\\012<div>Philippe Puicouyoul</div>\\012<div>Peter Schott</div>\\012<div>Boris Tissot</div>\\012<div>&nbsp;</div>\\012<div>Rectorat de Paris</div>\\012<div>D&eacute;l&eacute;guation acad&eacute;mique aux relations europ&eacute;ennes et internationales et &agrave; la coop&eacute;ration</div>\\012<div>Gilles Laborde, D&eacute;l&eacute;gu&eacute;</div>\\012<div>Jean-Paul Chouard, charg&eacute; de mission</div>\\012<div>GIldas Le Roux, charg&eacute; de mission</div>\\012<div>&nbsp;</div>\\012<div>Mission acad&eacute;mique &laquo;&nbsp;Innovation et exp&eacute;rimentation&nbsp;&raquo;</div>\\012<div>Fran&ccedil;ois Muller, responsable</div>\\012<div>&nbsp;</div>\\012<div>Les directeurs d&rsquo;&eacute;tablissement scolaires et les enseignants dont l&rsquo;engagement sans faille tout au long de ce projet aura permis la r&eacute;alisation des &eacute;changes entre partenaires</div>\\012<div>Donatella Bargis</div>\\012<div>Elisabeth Battistel</div>\\012<div>Isabelle Bucurescu</div>\\012<div>Elisa Cappi</div>\\012<div>Julien Charlier</div>\\012<div>Doroth&eacute;e Clerc</div>\\012<div>Sorina Danaila</div>\\012<div>Laurence Dauvergne</div>\\012<div>Monique Dugu&eacute;-Boyer</div>\\012<div>Maria Rita Fiori</div>\\012<div>M. Goebbels</div>\\012<div>Paola Gozzi</div>\\012<div>Dominique Natta</div>\\012<div>Raluca Ionescu</div>\\012<div>Yola Le Cainec</div>\\012<div>Anne Laforge</div>\\012<div>Isabelle Limon</div>\\012<div>Elisabeth Loupiac</div>\\012<div>Elisabeth Meyer</div>\\012<div>Jean-Paul Moreau</div>\\012<div>Anne Catherine Mourgue</div>\\012<div>C&eacute;line Noras</div>\\012<div>Philippe Roca</div>\\012<div>Luc Richard</div>\\012<div>Assetou Sampebgo</div>\\012<div>Gabriela Sandulescu</div>\\012<div>Maria Augusta Schippisi</div>\\012<div>Dan Solcan</div>\\012<div>Thierry Sursin,</div>\\012<div>Sylvie Tomas</div>\\012<div>Corina Ungurean</div>\\012<div>Iulian Untaru</div>\\012<div>Dominique Vadet</div>\\012<div>H&eacute;l&egrave;ne Valencien</div>\\012<div>Mariana Visan</div>\\012<div>Ioana Voinea</div>\\012<div>Agn&egrave;s de Willecot</div>\\012<div>Philippe Zill</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>Centre Pompidou</div>\\012<div>Louis Corno</div>\\012<div>Olivier Bernon</div>\\012<div>Bruno Boullault</div>\\012<div>Fran&ccedil;oise Cagli</div>\\012<div>Yves Clerget</div>\\012<div>Patrice Chazotte</div>\\012<div>Yves Dalmau</div>\\012<div>Hugues Fournier-Montgieux</div>\\012<div>Sacha Ilic</div>\\012<div>Serge Navas</div>\\012<div>Marc Oustabatchieff</div>\\012<div>Fabrice Pleynet</div>\\012<div>Laurie Szulz</div>\\012<div>Philippe Puicouyoul</div>\\012<div>Boris Tissot</div>\\012<div>&nbsp;</div>\\012<p>Et toutes les personnes que nous aurions oubli&eacute;es.</p>\\012<p>&nbsp;</p>\\012	1249384821	1249298421		0
2:afb62689fa37a5bbfe9d5aba9a2b0b38	<p>Adresse &eacute;lectronique :<br />\\012<a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a></p>\\012<p>Adresse Postale :<br />\\0124 rue Aubry le Boucher,<br />\\01275004 Paris</p>\\012<p>Acc&egrave;s :<br />\\012111, rue Saint-Martin,<br />\\01275004 Paris</p>\\012<p>Code : B1235<br />\\012Escalier C &agrave; gauche dans la cour, puis interphone ( IRI N&deg;9060)</p>\\012<p>T&eacute;l : 01 44 78 42 02.<br />\\012Par d&eacute;faut les conf&eacute;rences ou s&eacute;minaires organis&eacute;s par l'IRI se d&eacute;roulent dans la salle &quot;Piazza&quot;. Elle se situe sur la Piazza Beaubourg (l'esplanade pentue devant l&rsquo;entr&eacute;e du Centre Pompidou), &agrave; droite du pot de Reynaud, pr&egrave;s de l&rsquo;ascenseur rouge.</p>\\012<p><img src="/res/img/photo_salle_iri.jpg" alt="photo_salle_iri.jpg" /></p>\\012<p><img src="/res/img/googlemap.jpg" alt="Google map IRI" /></p>\\012	1249394407	1249308007		0
2:d6aae5c1901d769d0be2df83e8d1f16a	<p class="rteright"><a href="/lignes_de_temps_faq_en">English version</a></p>\\012<p>Le logiciel <i>Lignes de temps</i> est compos&eacute; de deux parties, que l'on appellera syst&egrave;me et interface.           <br />\\012- La partie syst&egrave;me est &quot;invisible&quot; pour l'utilisateur et permet d'enregistrer son travail (notes, d&eacute;coupages, bout &agrave; bout) dans un fichier. Elle permet aussi de lancer les programmes n&eacute;cessaires &agrave; l'import d'un fichier audio ou vid&eacute;o. Ces programmes encodent la vid&eacute;o pour qu'elle soit lisible dans l'interface et g&eacute;n&egrave;rent le plan par plan et la forme d'onde. <br />\\012- L'interface est tout ce qui est &quot;visible&quot; et manipulable par l'utilisateur. Elle se compose du menu en haut &agrave; gauche (Fichier, Affichage...) et des trois fen&ecirc;tres : informations, lecteur vid&eacute;o et celle qui affiche les lignes de temps. <br />\\012Les deux parties du programme communiquent entre elles mais cette communication peut parfois s'interrompre sans en informer l'utilisateur. Dans ce cas, on ne peut malheureusement plus enregistrer son travail. L'Institut de recherche et d'innovation travaille constamment &agrave; la r&eacute;solution de ce type de bogues. Pour toute information, commentaire ou probl&egrave;me, merci d'envoyer un mail &agrave; <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a><br />\\012Un travail dans <i>Lignes de temps</i> est sauvegard&eacute; dans un fichier de projet (extension .ldt) qui contient les r&eacute;f&eacute;rences vers les m&eacute;dias utilis&eacute;s et toutes les donn&eacute;es personnelles (notes, d&eacute;coupages, bout &agrave; bout, vues). Les donn&eacute;es non personnelles sur un m&eacute;dia (plan par plan et forme d'onde par exemple) sont enregistr&eacute;es dans un fichier &agrave; extension .iri.</p>\\012<ul>\\012<li><b>J'utilise un MAC, comment conna&icirc;tre ma configuration ?</b><br />\\012    Pour savoir si votre ordinateur est &quot;Intel&quot; ou &quot;Power PC&quot;, allez dans le menu Pomme en haut &agrave; gauche de votre &eacute;cran. Dans le menu qui est apparu, cliquez sur &quot;&agrave; propos de ce mac&quot;. La ligne &quot;Processeur&quot; indique si celui-ci est de type &quot;Intel&quot; ou &quot;Power PC&quot;.<br />\\012    Apr&egrave;s diff&eacute;rents tests, il apparait que <i>Lignes de temps</i> ne s'installe que sur les postes &eacute;quip&eacute;s du syst&egrave;me d'exploitation 10.5, dit &quot;l&eacute;opard&quot;, et du processeur Intel, ou ceux &eacute;quip&eacute;s du syst&egrave;me 10.4, dit &quot;tiger&quot;, et du processeur Power PC.</li>\\012<li><b>Je n'arrive pas &agrave; afficher les lignes de temps d'un film :</b><br />\\012    Pour afficher ces lignes il faut cliquer sur le titre du film, puis sur l'onglet &quot;D&eacute;coupages&quot; de la fen&ecirc;tre d'informations. Dans cet onglet, se trouve la liste des d&eacute;coupages disponibles. Il suffit de cliquer sur l'un d'entre eux pour afficher la ligne correspondante.</li>\\012<li><b>Je n'arrive pas &agrave; importer un fichier audio ou vid&eacute;o :</b><br />\\012    Il faut s'assurer que l'extension du fichier est compatible. <i>Lignes de temps</i> accepte les fichiers .avi, .mpg, .mov, .flv pour la vid&eacute;o et .mp3 pour l'audio. Ensuite, m&ecirc;me si celui-ci est accept&eacute;, il se peut que l'encodage ne soit pas compatible avec le programme (ffmpeg) qui transforme ce fichier en vid&eacute;o lisible par <i>Lignes de temps</i>, c'est-&agrave;-dire au format flv. Sous MAC, m&ecirc;me si l'extension du fichier est correcte, il se peut que certains caract&egrave;res emp&ecirc;chent l'import. Il est donc conseill&eacute; que le chemin d'acc&egrave;s et le nom de fichier n'aient pas les caract&egrave;res suivants : caract&egrave;res accentu&eacute;s, espace, &ccedil;, #, &amp;, %, !, *, (), [], |, {}, :, ;, @.</li>\\012<li><b>Je n'arrive pas &agrave; sauvegarder mon travail :</b><br />\\012    Comme expliqu&eacute; dans l'introduction, ce probl&egrave;me peut venir de la perte de communication entre l'interface et la partie du programme qui enregistre dans un fichier. Pour enregistrer son travail, on peut passer par le menu en haut &agrave; gauche (Fichier -- Enregistrer le projet) ou par le raccourci clavier Ctrl+S sur PC et Pomme+S sur Mac. En g&eacute;n&eacute;ral, quand un travail a &eacute;t&eacute; modifi&eacute; depuis le dernier enregistrement, une &eacute;toile appara&icirc;t &agrave; c&ocirc;t&eacute; du titre du projet pour montrer qu'un enregistrement est n&eacute;cessaire.</li>\\012</ul>\\012<p>&nbsp;</p>\\012<p><b>Notes de version 0.10.8 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; de vid&eacute;o en plein &eacute;cran sur fond noir</li>\\012<li>Possibilit&eacute; d'afficher des sous-titres depuis un fichier externet au format TimedText XML</li>\\012<li>Possibilit&eacute; d'afficher l'int&eacute;gralit&eacute; des annotations (titre et description) d'une timeline dans un grand champ texte &eacute;quip&eacute; d'une recherche simple</li>\\012<li>Am&eacute;liorations ergonomiques (boutons pour timeline r&eacute;arrang&eacute;s, fen&ecirc;tre de tags redimensionnable)</li>\\012</ul>\\012<p><b>Notes de version 0.10.4 &agrave; 0.10.7 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; d'importer des d&eacute;coupages depuis un autre fichier .ldt</li>\\012<li>Possibilit&eacute; d'annoter un flux live stream&eacute; en rtmp://...</li>\\012<li>D&eacute;placement des lignes de temps et des films par simple drag and drop</li>\\012<li>Am&eacute;liorations ergonomiques (nom du fichier .ldt affich&eacute; dans le titre fen&ecirc;tre d'information, zoom plus fluide, possibilit&eacute; de sauvegarder sa langue par d&eacute;faut)</li>\\012<li>Possibilit&eacute; de dupliquer les segments en surbrillance d'une ligne de temps</li>\\012<li>D&eacute;bug divers</li>\\012</ul>\\012<p><b>Notes de version 0.10.3 :</b></p>\\012<ul>\\012<li>Langue japonaise ajout&eacute;e par d&eacute;faut</li>\\012<li>D&eacute;bug divers</li>\\012</ul>\\012<p><b>Notes de version 0.10 :</b></p>\\012<ul>\\012<li>INTERFACE MULTILINGUE avec Anglais et Fran&ccedil;ais propos&eacute;s par d&eacute;faut et possibilit&eacute; d'ajouter soi-m&ecirc;me des langues (&eacute;tapes expliqu&eacute;es dans le <a target="_blank" href="/res/media/ldt_userguide_fr.pdf">mode d'emploi</a> gr&acirc;ce &agrave; l'outil GETTEXT)</li>\\012<li>Refonte compl&egrave;te de l'interface et de l'ergonomie avec entre autres ajout de boutons avec icones, de nouveaux onglets plus visibles, de bulles d'aide, de messages de confirmation avant suppression.</li>\\012<li>Vues : possibilit&eacute; de renommage et de d&eacute;placement.</li>\\012<li>Tags : affichage de la liste compl&egrave;te du nuage de tags du projet par le menu en haut &agrave; gauche et le raccourci Shift + T.</li>\\012<li>Prise de notes : am&eacute;lioration du suivi de la frappe gr&acirc;ce au positionnement automatique de l'ascenceur, indication du timecode correspondant au survol du marqueur.</li>\\012<li>Bout &agrave; bout : possibilit&eacute; de suppression.</li>\\012<li>Ajout d'un <a target="_blank" href="/dev/trac/ldt">trac</a> pour le suivi des bugs.</li>\\012<li>Mise &agrave; jour compl&egrave;te du mode d'emploi en <a target="_blank" href="/res/media/ldt_userguide_fr.pdf">fran&ccedil;ais</a> et en <a target="_blank" href="/res/media/ldt_userguide_en.pdf">anglais</a>.</li>\\012<li>Ajout de la license dans l'&agrave; propos.</li>\\012</ul>\\012<p><b>Notes de version 0.9.4 :</b></p>\\012<ul>\\012<li>Ajout d'un module prise de notes, permettant d'&eacute;crire des commentaires &agrave; la vol&eacute;e puis de les transformer en ligne de temps.</li>\\012<li>Vues : la sauvegarde des &eacute;tats d'affichage prennent maintenant en compte le niveau de zoom, la position de l'ascenceur horizontal et si un bout &agrave; bout est en lecture.</li>\\012<li>Am&eacute;lioration de la saisie des tags : possibilit&eacute; d'avoir une fen&ecirc;tre avec tous les tags d'une ligne et ajout du tag par simple clic.</li>\\012<li>Possibilit&eacute; d'afficher tous les tags du projets dans une grande fen&ecirc;tre gr&acirc;ce au raccourci clavier Shift + F.</li>\\012<li>Possibilit&eacute; de mettre en surbrillance les segments en cliquant sur les tags d'une ligne. Cinq couleurs sont disponibles (une par tag), puis au-del&agrave; les segments concern&eacute;s par la recherche s'affichent en blanc.</li>\\012<li>Possibilit&eacute; de dupliquer une ligne en ne s&eacute;lectionnant que les segments en surbrillance.</li>\\012<li>Possibilit&eacute; de cr&eacute;er un bout &agrave; bout &agrave; partir d'une ligne compl&egrave;te ou des segments en surbrillance.</li>\\012<li>Ajout de messages d'erreur en cas de plantage du logiciel. Cela limite le risque de perdre son travail.</li>\\012</ul>\\012<p><b>Notes de version 0.9.2 :</b></p>\\012<ul>\\012<li>Possibilit&eacute; de dupliquer n'importe quelle ligne (bouton &quot;dupliquer&quot; dans la fen&ecirc;tre d'informations).</li>\\012<li>Ajout du champ tag pour les segments.</li>\\012<li>Possibilit&eacute; d'afficher le sommaire d'un d&eacute;coupage, c'est-&agrave;-dire la liste de ses segments sous forme de texte cliquable.</li>\\012<li>D&eacute;bogage des bugs identifi&eacute;s dans la version pr&eacute;c&eacute;dente.</li>\\012<li>Modification de l'interface : fen&ecirc;tre d'informations agrandie en hauteur et en largeur et fen&ecirc;tre d'affichage des lignes agrandie en largeur.</li>\\012</ul>\\012<p>&nbsp;</p>\\012	1250590850	1250504450		0
2:004b722fd8584b2d4984ea275f3f3cf8	<p class="rteright"><a href="/lignes_de_temps_faq">Version fran&ccedil;aise</a></p>\\012<p>The software <i>Lignes de temps</i> is divided in two parts: system and interface.           <br />\\012The first one is not visible for users; it allows to record the work done (notes, sequences, rough-cut) in a file. It also permits to launch programs necessary to import an audio or video file. These programs encode video in order that it can be visible in the interface and that it can produce the shot by shot and the sound wave. <br />\\012The interface is composed by all the elements visible and controlled by users. It is composed by the top left menu (File, Display) and by three windows: Informations, the media player, and the one who displays the lignes de temps. <br />\\012The two parts of the program are connected but the communication can sometimes be interrupted, without any notification. In this case, the work can not unfortunately be recorded. The Institute for research and innovation works on those different problems. For any information, feedback or problem : <a href="mailto:contact@iri.centrepompidou.fr">contact@iri.centrepompidou.fr</a><br />\\012A work on <i>Lignes de temps</i> is saved in a project file (ldt extension) which holds references towards the media used and the personal data (notes, sequences, rough-cut). The non-personal data on one media (shot by shot and sound wave for example) are recorded in an iri extension file.</p>\\012<ul>\\012<li><b>I use a Mac, how can I know which is my configuration ?</b><br />\\012    To know if your computer is &quot;Intel&quot; or &quot;Power PC&quot;, you have to go in the Apple menu up left on the screen. In the menu, click on &quot;About this Mac&quot;. The line &quot;Processor&quot; indicates the type of configuration &quot;Intel&quot; or &quot;Power PC&quot;.<br />\\012    After many tests, it seems that <i>Lignes de temps</i> just settles on the computers with the operating system 10.5 called &quot;leopard&quot;, the 10.4 one called &quot;tiger&quot;, the Intel processor, or with the Power PC processor.</li>\\012<li><b>I do not succeed in displaying movies :</b><br />\\012    To display those lignes de temps, you have to click on the movie title in the lignes de temps window then on the tab &quot;Cuttings&quot;. In this tab, appears the list of the available sequences; you just have to click on one of them to display the corresponding ligne de temps.</li>\\012<li><b>I do not succeed in importing an audio or video file :</b><br />\\012    You have to make sure that the file extension can match. <i>Lignes de temps</i> takes into account avi, mpg, mov, flv extension for video and mp3 for audio. Then, even if this one is accepted, the encoding can not match with the program (ffmpeg) which transforms this file in a video readable in <i>Lignes de temps</i>, that is to say in the flv format. Even if the file extension is correct, some characters block the import. Thus, you should prefer naming your file without the following characters : accented characters, space, &ccedil;, #, &amp;, %, !, *, (), [], |, {}, :, ;, @.</li>\\012<li><b>I do not succeed in saving my work :</b><br />\\012    As it is explained in the introduction, this problem can come from a communication failure between the interface and the program part which records the work in a file. To record the works, we can go through the up left menu (Fichier -- Enregistrer) or through the hot key Ctrl+S on PCs and Apple+S on Macs. In general, when a work has been modified since the last recording, a star appears close the movie title in order to warn about a required recording.</li>\\012</ul>\\012<p>&nbsp;</p>\\012<p>&nbsp;</p>\\012<p><b>Release notes about Lignes de temps 0.10.8 :</b></p>\\012<ul>\\012<li>Possibility to display the video in fullscreen with black background</li>\\012<li>Possibility to display a permalink for a segment</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps from 0.10.4 to 0.10.7 :</b></p>\\012<ul>\\012<li>Possibility to import cuttings from an other ldt file</li>\\012<li>Possibility to stream a video with rtmp://...</li>\\012<li>Possibility to move timelines and contents by simple drag and drop</li>\\012<li>Ergonomic improvements (ldt file name int the information window, zoom more fluid, possibility to save our default language)</li>\\012<li>Possibility to duplicate a timeline's highlighted segments</li>\\012<li>Debug</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.10.3 :</b></p>\\012<ul>\\012<li>Japanese language added</li>\\012<li>Debug</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.10 :</b></p>\\012<ul>\\012<li>MULTILINGUAL INTERFACE with English and French available by default and possibility to add some languages by yourself (the steps are explained in the <a href="http://www.iri.centrepompidou.fr/res/media/ldt_userguide_en.pdf" target="_blank">user guide</a> thanks to the GETTEXT tool)</li>\\012<li>Interface and ergonomy completely rebuilt, with for exemple buttons with icons, new tabs more visible, tool tips, confirmation messages before deleting.</li>\\012<li>Views : rename and move by drag and drop.</li>\\012<li>Tags : the complete project's tags list can be displayed from the top left menu or the shortcut Shift + T.</li>\\012<li>Note taking : better management of scroll position, timecode indicated on seperator roll over.</li>\\012<li>Bout &agrave; bout (edit) : an edit can now be deleted.</li>\\012<li>Bug <a href="/dev/trac/ldt" target="_blank">trac</a> added.</li>\\012<li>Complete user guide in <a href="/res/media/ldt_userguide_fr.pdf" target="_blank">french</a> and <a href="/res/media/ldt_userguide_en.pdf" target="_blank">english</a>.</li>\\012<li>License added in the &quot;About&quot;.</li>\\012</ul>\\012<p><b>Release notes about Lignes de temps 0.9.4 :</b></p>\\012<ul>\\012<li>New note-taking functionnality, enabling to write notes on the fly, then to transform them into a cutting.</li>\\012<li>Views : the display states backup includes now the zoom level, the horizontal scroll position and if a &quot;bout &agrave; bout&quot; is playing.</li>\\012<li>Improvement of tags addition : possibility to display a window with all the timeline's tags and to add one of them by simple click.</li>\\012<li>Possibility to display all the project's tags in a large window thanks to the shortcut Shift + F.</li>\\012<li>Possibility to highlight the segments by clicking one of the timeline's tags. 5 colors are available (one per tag), then requested segments are displayed in white.</li>\\012<li>Possibility to duplicate a timeline from highlighted segments only.</li>\\012<li>Possibility to create a bout &agrave; bout from a complete timeline or highlighted segments.</li>\\012<li>Addition of error messages when the software crashes. They limit the risk of work loss.</li>\\012</ul>\\012<p>\\012<b>Release notes about Lignes de temps 0.9.2 :</b></p>\\012<ul>\\012<li>Possibility of duplicating any line (duplication button in the Informations window).</li>\\012<li>Presence of the tag field for segments.</li>\\012<li>Possibility of displaying a sequence's summary, that is to say the sequences'list as a clickable text.</li>\\012<li>Debug of identified bugs in the previous version.</li>\\012<li>Interface's modifications : the &quot;Informations&quot; window enlarged in height and width, and the read-out window enlarged in width.</li>\\012</ul>\\012<p>&nbsp;</p>\\012	1249137462	1249051062		0
2:5a96b61f36464b5a457c586a640c37d8	<ul>\\012<li><a href="/telecharger_lignes_de_temps">T&eacute;l&eacute;charger Lignes De Temps</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire">S&eacute;minaires index&eacute;s dans Lignes De Temps</a>\\012<ul>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/1">Figures de l'amateur</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/6">Mus&eacute;ologie 2007-2008</a></li>\\012<li><a href="http://web.iri.centrepompidou.fr/fonds/seminaires/seminaire/detail/8">Mus&eacute;ologie 2008-2009</a></li>\\012</ul>\\012</li>\\012<li><a href="http://www.iri.centrepompidou.fr/privatedoc/">S&eacute;minaires en audio</a></li>\\012<li><a href="http://amateur.iri.centrepompidou.fr/nouveaumonde/enmi/conf/">Entretiens du Nouveau Monde Industriel</a></li>\\012<li>THD Culture</li>\\012<li><a href="/espaces_critiques">Espaces critiques</a></li>\\012</ul>\\012	1249138890	1249052490		0
2:bf82286bd9bbf453ab0f5db0ff0e3d74	<p><a href="/ma_ville_vue_par">Projet</a> - Etapes - <a href="/ma_ville_vue_par/generique">G&eacute;n&eacute;rique</a></p>\\012<p><strong>De la th&eacute;orie&hellip;</strong> Dans un premier temps, les classes compl&egrave;tent l&rsquo;analyse du film de r&eacute;f&eacute;rence fourni sur le logiciel <i>Lignes de temps</i>. Les films correspondent &agrave; une double n&eacute;cessit&eacute;&nbsp;: ils sont le produit d&rsquo;un travail d&rsquo;auteur et montrent les choix auxquels les cin&eacute;astes&nbsp; sont confront&eacute;s&nbsp;; la ville y tient un r&ocirc;le en tant que &laquo;&nbsp;personnage&nbsp;&raquo;, sans jamais n&rsquo;&ecirc;tre qu&rsquo;une &laquo;&nbsp;option&nbsp;&raquo;. La  ville peut &ecirc;tre montr&eacute;e de fa&ccedil;on documentaire ou fantastique mais doit rester un lieu reconnaissable et descriptible. Espace &eacute;motionnel de rencontre entre le cin&eacute;aste et le spectateur, le film part &agrave; la d&eacute;couverte de la ville dans ses aspects les plus &eacute;tonnants et les plus quotidiens.</p>\\012<div>Apr&egrave;s visionnage, les &eacute;l&egrave;ves commentent leurs &eacute;motions face au film et vont &agrave; la recherche des &eacute;l&eacute;ments qui les ont suscit&eacute;es. Comment s&rsquo;op&egrave;re la transformation de l&rsquo;espace envahi par la  projection de la g&eacute;ographie mentale du cin&eacute;aste&nbsp;? Comment les &eacute;motions du r&eacute;alisateur passent-elles &agrave; travers l&rsquo;espace montr&eacute; pour arriver au spectateur&nbsp;? Comment peut-elle devenir le catalyseur des regards du cin&eacute;aste et du spectateur&nbsp;?...</div>\\012<div>Ces interpr&eacute;tations et r&eacute;flexions sur le film sont alors &eacute;chang&eacute;es entre classes partenaires via <i>Lignes de temps </i>sous forme de<i> bout-&agrave;-bouts</i>, occasion pour chacun d&rsquo;analyser les diff&eacute;rences de perception d&rsquo;une m&ecirc;me &oelig;uvre, d&rsquo;enrichir une analyse gr&acirc;ce au regard de l&rsquo;autre, de partager un point de vue critique, mais aussi &eacute;motionnel, sur une &oelig;uvre d&rsquo;art&hellip;</div>\\012<div>&nbsp;</div>\\012<div><strong>&hellip;&agrave; la pratique</strong> &Agrave; ce temps de r&eacute;flexion succ&egrave;de un temps de cr&eacute;ation, soit la r&eacute;alisation d&rsquo;un &laquo;&nbsp;film-essai&nbsp;&raquo; par les &eacute;l&egrave;ves de chaque classe. La classe &eacute;crit son projet, puis tourne un court-m&eacute;trage &agrave; partir de proc&eacute;d&eacute;s techniques de r&eacute;alisation, ou &laquo;&nbsp;cahier des charges&nbsp;&raquo;, d&eacute;finis par chaque enseignant en coop&eacute;ration avec son partenaire et en grande partie inspir&eacute;s de l&rsquo;analyse filmique du film de r&eacute;f&eacute;rence.</div>\\012<div>Il s&rsquo;agit par exemple de demander aux &eacute;l&egrave;ves de travailler sur une contrainte purement formelle, comme les &eacute;chelles de plans, ou bien th&eacute;matique (la foule, les toits, l&rsquo;architecture, les rues, les animaux dans la ville)&hellip; Les figures de style impos&eacute;es &eacute;tant identiques pour chaque partenaire du bin&ocirc;me afin d&rsquo;offrir une base de travail commune et de pouvoir clairement identifier les diff&eacute;rences de points de vue des r&eacute;alisateurs.</div>\\012<div>Plusieurs consignes de travail sont donn&eacute;es aux classes, telles que&nbsp;: montrer un monument ou un lieu repr&eacute;sentatif, voire &laquo;&nbsp;clich&eacute;&nbsp;&raquo;, de la&nbsp;ville et en proposer une solution filmique originale et personnelle.</div>\\012<div>La dur&eacute;e des rushes est limit&eacute;e &agrave; vingt minutes par classe.</div>\\012<div>Ces <i>rushes</i> sont ensuite d&eacute;rush&eacute;s (un premier choix de plans) puis d&eacute;crits sur <i>Lignes de temps</i> avant d&rsquo;&ecirc;tre envoy&eacute; &agrave; la classe partenaire. Les r&eacute;alisateurs prenant ainsi du recul sur leur propre exercice, tandis que les &eacute;l&egrave;ves de la classe partenaire peuvent analyser les plans de l&rsquo;autre et r&eacute;fl&eacute;chir sur les diverses &eacute;tapes de la cr&eacute;ation  cin&eacute;matographique.</div>\\012<div>Chaque classe se trouve alors en possession de deux fichiers de rushes&nbsp;: le sien propre, et celui de la classe associ&eacute;e. Deux montages seront alors effectu&eacute;s, offrant pour l&rsquo;un un regard personnel et affectif sur sa propre ville, et pour l&rsquo;autre une vision neuve et interpr&eacute;tative de celle du partenaire. Chaque filmmont&eacute; sera d&eacute;crit et index&eacute; sur <i>Lignes de temps</i> avant d&rsquo;&ecirc;tre envoy&eacute; &agrave; la classe partenaire, laquelle, &agrave; son tour, le commentera et le renverra &agrave; la classe r&eacute;alisatrice, selon le mod&egrave;le des &laquo;&nbsp;Regards sign&eacute;s&nbsp;&raquo; initi&eacute;s par l&rsquo;IRI.</div>\\012<div>En tout, chaque bin&ocirc;me produira, visionnera et montera le mat&eacute;riel de 4 courts-m&eacute;trages et les &eacute;tudiants pourront, &agrave; chaque &eacute;tape des &eacute;changes, en d&eacute;battre avec leurs enseignants. L&rsquo;analyse se nourrit de la discussion, parfois m&ecirc;me de la controverse, et le point de vue de l'autre est une aide pr&eacute;cieuse pour conforter ou amender sa propre opinion.</div>\\012<div>&nbsp;</div>\\012<div>Les chapitres majeurs de l&rsquo;exp&eacute;rience reposent sur un principe <b>d&rsquo;&eacute;changes</b> via <i>Lignes de temps</i> et tout autre moyen num&eacute;rique ou classique de correspondance, et ce, a chacune des &eacute;tapes du processus&nbsp;:</div>\\012<div>1/ Analyse d&rsquo;un film - <b>long m&eacute;trage de fiction, documentaire ou film exp&eacute;rimental.</b> Document&eacute; et comment&eacute; par des documentalistes de l&rsquo;IRI sur <i>Lignes de temps</i>, le film est transmis aux &eacute;coles qui, &agrave; leur tour enrichissent le descriptif. Dirig&eacute;s par Marta Boni (doctorante en cin&eacute;ma) des ateliers de prise en main du logiciel sont tenus dans les classes et amorcent le travail des bin&ocirc;mes.</div>\\012<div>2/ Echanges de points de vue entre partenaires par le biais du logiciel disponible en ligne ou en local.</div>\\012<div>3/ R&eacute;alisation de &laquo;&nbsp;films-essais&nbsp;&raquo;et de&laquo;&nbsp;films-regards&nbsp;&raquo;. Ces essais peuvent ou non s&rsquo;inspirer de la structure narrative ou formelle des films analys&eacute;s ou de tout autre principe sc&eacute;naristique d&eacute;gag&eacute; lors des discussions entre partenaires. Chaque groupe documente ses propres rushes dans&nbsp;<i>Lignes de temps</i> et les &eacute;change avec ceux de sonpartenaire&nbsp;:<b> deux films&nbsp;sont ainsi mont&eacute;s par chaque classe - le premier, le &laquo;&nbsp;film-essai&nbsp;&raquo; avec ses propres rushes, le second, le &laquo;&nbsp;film-regard&nbsp;&raquo; avec les rushes du partenaire.</b></div>\\012<div>Chaque film, une fois mont&eacute;, ne devant pas exc&eacute;der 10&rsquo;.</div>\\012<div>&nbsp;</div>\\012<div>Pr&eacute;sentations des exp&eacute;rimentations</div>\\012<div>&laquo;&nbsp;Ma ville vue par&hellip; Une &eacute;tape&nbsp;&raquo; Vendredi 15 mai 2009</div>\\012<div>&laquo;&nbsp;Ma ville vue par&hellip; / Etape 2&nbsp;&raquo; Jeudi 4 juin 2009</div>\\012<div>Centre Pompidou / Cin&eacute;ma 1 / 9h15&gt;13h30</div>\\012<div>Les travaux r&eacute;alis&eacute;s durant l&rsquo;ann&eacute;e scolaire 2008-2009, &laquo;&nbsp;Regards-sign&eacute;s&nbsp;&raquo; et &laquo;&nbsp;Films-essais&nbsp;&raquo; et les r&eacute;alis&eacute;s durant cette ann&eacute;e scolaire 2008-2009 ont &eacute;t&eacute; projet&eacute;s lors de journ&eacute;es de projection au Centre Pompidou. Les enseignants pr&eacute;sents accompagn&eacute;s de leurs &eacute;l&egrave;ves ont t&eacute;moign&eacute; de leurs relations de travail. Plus de 350 &eacute;l&egrave;ves, dont deux classes italiennes et une classe roumaine ont assist&eacute; &agrave; ces matin&eacute;es.</div>\\012<p>&nbsp;</p>\\012	1249382804	1249296404		0
2:087d82d70e94bf179db6d7f593d3441e	<p><a href="/ma_ville_vue_par">Projet</a> - <a href="/ma_ville_vue_par/etapes">Etapes</a> - <a href="/ma_ville_vue_par/generique">G&eacute;n&eacute;rique</a> - Bin&ocirc;mes</p>\\012<p>&nbsp;</p>\\012<p><table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr style="height: 61.2pt;">\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt; height: 61.2pt;">\\012<div><a href="#binome1"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Ecole &agrave; aires ouvertes Saint-Merri et   Renard, Paris 4<sup>&egrave;me </sup>(France)</span></a></div>\\012<div><a href="#binome1"><span style="color: windowtext; text-transform: none;">CE1</span><span style="font-size: 11pt; color: windowtext; text-transform: none;"> &ndash; </span><span style="color: windowtext; text-transform: none;">Anne Laforge</span><span style="color: windowtext; text-transform: none;">,   institutrice</span></a></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt; height: 61.2pt;">\\012<div><a href="#binome1"><span style="font-size: 14pt; color: windowtext; text-transform: none;">Scuola   Elementare Federigo Tozzi, Sienne (Italie)</span></a></div>\\012<div><a href="#binome1"><span style="color: windowtext; text-transform: none;">CE1</span><span style="font-size: 11pt; color: windowtext; text-transform: none;"> &ndash; </span><span style="color: windowtext; text-transform: none;">Mariarita Fiori</span><span style="color: windowtext; text-transform: none;">,   institutrice</span></a></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012</p>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr style="height: 47.5pt;">\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt; height: 47.5pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Ecole &agrave; aires ouvertes Saint-Merri et   Renard, Paris 4<sup>&egrave;me </sup>(France)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">CE1</span><span style="font-size: 11pt; color: windowtext; text-transform: none;"> - </span><span style="color: windowtext; text-transform: none;">H&eacute;l&egrave;ne Valencien</span><span style="color: windowtext; text-transform: none;">,   institutrice</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt; height: 47.5pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Scuola   Elementare Federigo Tozzi, Sienne (Italie) </span></div>\\012<div><span style="color: windowtext; text-transform: none;">CE1</span><span style="font-size: 11pt; color: windowtext; text-transform: none;"> - </span><span style="color: windowtext; text-transform: none;">Donatella Bargis</span><span style="color: windowtext; text-transform: none;">,   institutrice</span></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Ecole Saint-Merri, Paris (France)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">CE1</span><span style="font-size: 11pt; color: windowtext; text-transform: none;"> - </span><span style="color: windowtext; text-transform: none;">Agn&egrave;s   de Willecot, institutrice</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Ecole &eacute;l&eacute;mentaire Maurice Genevoix,   Paris 18<sup>&egrave;me</sup> (France)</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">6<sup>&egrave;me</sup> - Monique Dugu&eacute; Boyer, professeur de   frab&ccedil;ais</span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Scoala   centrala n&deg; 10, Bucarest</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">5<sup>&egrave;me</sup> C - Mariana Visan, Isabelle   Bucurescu, A. Oslobeanu, Cecila Potescu</span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr style="height: 68.4pt;">\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt; height: 68.4pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Coll&egrave;ge Thomas Mann, Paris 13<sup>&egrave;me </sup>(France)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">4<sup>&egrave;me</sup>D - Elisabeth Loupiac, </span><span style="font-size: 11pt; color: windowtext; text-transform: none;">professeur d&rsquo;arts plastiques</span></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt; height: 68.4pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Scuola   Media Irnerio, Bologne </span><span style="font-size: 14pt; color: windowtext; text-transform: none;">(Italie)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">5&egrave;meC - Elisa Cappi, </span><span style="font-size: 11pt; color: windowtext; text-transform: none;">professeur d&rsquo;histoire</span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Coll&egrave;ge Thomas Mann, Paris 13<sup>&egrave;me </sup>(France)</span></div>\\012<div><span style="font-size: 11pt; color: windowtext; text-transform: none;">4<sup>&egrave;me</sup>E - Elisabeth Loupiac</span><span style="color: windowtext; text-transform: none;">, </span><span style="font-size: 11pt; color: windowtext; text-transform: none;">professeur d&rsquo;arts plastiques</span></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Scuola   Media Irnerio, Bologne (Italie)</span></div>\\012<div><span style="font-size: 11pt; color: windowtext; text-transform: none;">5<sup>&egrave;me</sup>2B   - Daniela Amante</span><span style="color: windowtext; text-transform: none;">,</span><span style="font-size: 11pt; color: windowtext; text-transform: none;">professeur d&rsquo;histoire</span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Coll&egrave;ge Thomas Mann, Paris 13<sup>&egrave;me</sup>(France)</span></div>\\012<div><span style="font-size: 11pt; color: windowtext; text-transform: none;">4<sup>&egrave;me</sup>C - Elisabeth Loupiac</span><span style="color: windowtext; text-transform: none;">, </span><span style="font-size: 11pt; color: windowtext; text-transform: none;">professeur d&rsquo;arts plastiques</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Colegiul   national Mihai Eminescu, Iasi (Roumanie)</span></div>\\012<div><span style="font-size: 11pt; color: windowtext; text-transform: none;">4<sup>&egrave;me</sup> - Sorina Danaila</span><span style="color: windowtext; text-transform: none;">, </span><span style="font-size: 11pt; color: windowtext; text-transform: none;">professeur de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Lyc&eacute;e Maurice Ravel, Paris 19<sup>&egrave;me</sup>(France)</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">BTS Assistant trilingue - Yola Le Ca&iuml;nec,   professeur de fran&ccedil;ais</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Colegiul Ion C. Bratianu, Pitesti   (Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Terminale - Iulian Untaru, professeur de fran&ccedil;ais langues   &eacute;trang&egrave;res</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table width="633" cellspacing="0" cellpadding="0" border="1" style="border: medium none ; width: 474.9pt; border-collapse: collapse;">\\012<tbody>\\012<tr style="height: 79.15pt;">\\012<td width="317" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 237.45pt; height: 79.15pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Lyc&eacute;e Maurice Ravel, Paris 19<sup>&egrave;me</sup>   (France)</span></div>\\012<div><span style="font-size: 11pt; color: windowtext; text-transform: none;">1<sup>&egrave;re</sup>ES - Isabelle Limon,   professeur d&rsquo;allemand</span></div>\\012</td>\\012<td width="317" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 237.45pt; height: 79.15pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Berufskolleg Herzogenrath </span><span style="font-size: 14pt; color: windowtext; text-transform: none;">(Allemagne)</span></div>\\012<div><span style="font-size: 11pt; color: windowtext; text-transform: none;">1&egrave;re &eacute;conomie-commerce, Jean-Paul Moreau,   professeur de fran&ccedil;ais</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Coll&egrave;ge Jean Moulin, Paris 14<sup>&egrave;me</sup> (France)</span></div>\\012<div><span style="font-size: 11pt; color: windowtext; text-transform: none;">3<sup>&egrave;me</sup>A etgroupe d&rsquo;&eacute;l&egrave;ves de 3<sup>&egrave;me</sup> - Laurence Dauvergne,   professeur de technologie / Elisabeth Battistel et&nbsp;Dominique Vadet, professeur de fran&ccedil;ais/ C&eacute;line Noras, professeur   d&rsquo;anglais, Mme Amor Fahsi, professeur 1er degr&eacute; d&rsquo;UPI</span></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Colegiul national Mihai Eminescu, Iasi (Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">4<sup>&egrave;me</sup> et 3<sup>&egrave;me</sup> - Sorina Danaila, professeur   de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">2<sup>&egrave;me</sup> -&nbsp;Corina Ungurean,   professeur de fran&ccedil;ais langues &eacute;trang&egrave;res</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Colegiul national Radu Negru, Fagaras   (Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">1&egrave;re - prof. Raluca Ionescu</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Coll&egrave;ge Darius Milhaud, Sartrouville   (France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">3<sup>&egrave;me</sup>1 - </span><span style="color: rgb(51, 51, 51); text-transform: none;">Anne-Catherine Mourgue</span><span style="color: rgb(51, 51, 51); text-transform: none;">,   professeur de lettres classiques / Aur&eacute;lie Pieterwas professeur de lettres   classiques / Philippe Roca et Julien Charlier, professeurs de technologie /   Christelle Musset, professeur d'anglais / Christophe Sayol, professeur   d'anglais / Nicolas Henry professeur de SVT</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Liceo classico   M. Gioia, Piacenza (Italie)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">2<sup>&egrave;me</sup>B classique - Maria Augusta Schippisi,   professeur de langages non verbaux</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Coll&egrave;ge Darius Milhaud, Sartrouville   (France)</span></div>\\012<div><span style="font-size: 11pt; color: rgb(51, 51, 51); text-transform: none;">3</span><sup><span style="color: rgb(51, 51, 51); text-transform: none;">&egrave;me</span></sup><span style="font-size: 11pt; color: rgb(51, 51, 51); text-transform: none;">4</span>&nbsp;<span style="color: rgb(51, 51, 51); text-transform: none;">- </span><span style="color: rgb(51, 51, 51); text-transform: none;">Anne-Catherine    Mourgue</span><span style="color: rgb(51, 51, 51); text-transform: none;">, professeur de lettres classiques /   Aur&eacute;lie Pieterwas professeur de lettres classiques / Philippe Roca et Julien   Charlier, professeurs de technologie / Christelle Musset, professeur   d'anglais / Christophe Sayol, professeur d'anglais / Nicolas Henry professeur   de SVT</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Colegiul   national Mihai Eminescu, Iasi</span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">(Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">3&egrave;me, Sorina    Danaila, professeur de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Lyc&eacute;e Paul Val&eacute;ry, Paris 12<sup>&egrave;me</sup>(France)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">1&egrave;re ES1 et 1er S2- et &eacute;tudiants du Lyc&eacute;e Charlemagne, option   facultative cin&eacute;ma - Philippe    Zill, professeur de cin&eacute;ma</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51);">Colegiul B. P. Hasdeu, Buzau (Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">3&egrave;me - Ioana    Voinea&nbsp;/ Dan    Solcan, professeurs de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr style="height: 48.5pt;">\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt; height: 48.5pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Lyc&eacute;e Paul Val&eacute;ry, Paris 12<sup>&egrave;me</sup>(France)</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Philippe Zill</span><span style="font-size: 10pt; color: windowtext;">, professeur   de cin&eacute;ma </span></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt; height: 48.5pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Liceo classico   M. Gioia, Piacenza (Italie)</span></div>\\012<div><span style="font-size: 9pt; color: windowtext;">2&egrave;me   linguistique A - Paola    Gozzi, professeur de langages non verbaux</span></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<p>&nbsp;</p>\\012<p>&nbsp;</p>\\012<p><span style="font-size: 11pt; color: red;"><br clear="all" /><br />\\012</span></p>\\012<h3>&nbsp;<span style="color: blue; text-transform: none;">BINOMES / REALISATIONS</span></h3>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div style="border: 1pt solid windowtext; padding: 1pt;">\\012<div style="border: medium none ; padding: 0cm;"><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div style="border: medium none ; padding: 0cm;"><span style="color: blue; text-transform: none;">Pr&eacute;sentation du projet</span><span style="color: blue; text-transform: none;"> par Bernard Stiegler, directeur de l&rsquo;Institut de recherche et d&rsquo;innovation /&nbsp;</span></div>\\012</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="614" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 460.6pt;">\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">00_intro</span></div>\\012<div><span style="font-size: 10pt; color: blue;">Pr&eacute;sentation des   exp&eacute;riences r&eacute;alis&eacute;s sur le logiciel &laquo;&nbsp;Lignes de temps&nbsp;&raquo; par Marta   Boni, doctorante en cin&eacute;ma, responsable des Ateliers &laquo;&nbsp;Lignes de&nbsp;temps&nbsp;&raquo;   dans les &eacute;coles partenaires.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="119" width="157" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image002.jpg" v:shapes="_x0000_i1026" /></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div><b>&nbsp;</b></div>\\012<div><b>&nbsp;</b></div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome1"></a>Ecole &agrave; aires ouvertes Saint-Merri et   Renard, Paris 4<sup>&egrave;me </sup>(France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">CE1<span style="color: rgb(51, 51, 51);"> &ndash; </span>Anne Laforge,   institutrice</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;Pr&eacute;sentation par   les enseignants&nbsp;: Anne    Laforge / H&eacute;l&egrave;ne Valencien</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">01_saint_merri</span></div>\\012<div><span style="color: blue; text-transform: none;">Ateliers &laquo;&nbsp;Lignes de temps&nbsp;&raquo;   par Marta Boni, interview d&rsquo;enfants, dur&eacute;e 4&rsquo;34&rsquo;&rsquo;</span></div>\\012<div>&nbsp;</div>\\012<div><img height="116" width="157" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image004.jpg" v:shapes="_x0000_i1027" /></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Scuola   Elementare Federigo Tozzi, Sienne (Italie)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">CE1<span style="color: rgb(51, 51, 51);"> &ndash; </span>Mariarita Fiori,   institutrice</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">0</span><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">2_PP</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation et dessins des &eacute;l&egrave;ves de   l&rsquo;&eacute;cole.</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<p><span style="font-size: 10pt; color: rgb(51, 51, 51);"><br clear="all" /><br />\\012</span></p>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome2"></a>Ecole &agrave; aires ouvertes Saint-Merri et   Renard, Paris</span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">4<sup>&egrave;me </sup>(France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">CE1<span style="color: rgb(51, 51, 51);"> - </span>H&eacute;l&egrave;ne Valencien,   institutrice</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">03_saint_merri</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;L&rsquo;&eacute;cole Saint-Merri&nbsp;&raquo;, dur&eacute;e   3&rsquo;19&rsquo;&rsquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">L&rsquo;&eacute;cole pr&eacute;sent&eacute;e par les enfants.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: red; text-transform: none;">Texte</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Les enfants nous pr&eacute;sentent, en fran&ccedil;ais et en italien,   les lieux les plus significatifs de leur&nbsp;quartier&nbsp;: leur &eacute;cole, le Centre Pompidou, le Bazar de l&rsquo;H&ocirc;tel de   ville, le fameux BHV.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="126" width="168" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image006.jpg" v:shapes="_x0000_i1028" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation du travail par les enseignantes</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;Apr&egrave;s avoir travaill&eacute; avec les &eacute;l&egrave;ves du coll&egrave;ge   Thomas Mann pour ce projet, j&rsquo;ai &eacute;t&eacute; mise en contact avec l'&eacute;cole Saint-Merri   qui avaient besoin d&rsquo;une aide pour concevoir et suivre le travail de tournage   de leurs &eacute;l&egrave;ves. La d&eacute;marche a &eacute;t&eacute; diff&eacute;rente de celle que nous avons suivie   avec les &eacute;l&egrave;ves de Thomas Mann (voir texte Lila Pinell / Coll&egrave;ge   Thomas Mann). Nous avions beaucoup moins de temps (je suis intervenue au   coll&egrave;ge pendant toute l'ann&eacute;e), mais Anne Laforge et H&eacute;l&egrave;ne Valencien avaient   travaill&eacute; en amont avec leurs &eacute;l&egrave;ves. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les enfants ont choisi de pr&eacute;senter leur Paris &agrave; la   mani&egrave;re de petits reporters. C'est pourquoi les lieux choisis sont plut&ocirc;t   dans leur quartier, et qu'&agrave; c&ocirc;t&eacute; du Centre Pompidou, on peut trouver la   boulangerie ou le BHV (Bazar de l&rsquo;H&ocirc;tel de ville). L'id&eacute;e est de parler d'un   Paris totalement subjectif, vu par des enfants qui y habitent, mais de leur   le pr&eacute;senter &agrave; travers une forme journalistique, connue de tous.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Nous avons d&eacute;cid&eacute; de continuer ce travail et de   l'&eacute;tendre &agrave; d'autres lieux de leur Paris, et cela dans la perspective   notamment de continuer le dialogue avec les &eacute;l&egrave;ves italiens.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J'esp&egrave;re que le projet va continuer et &eacute;voluer avec les   ann&eacute;es, parce que les enfants s'amusent, cr&eacute;ent et apprennent beaucoup gr&acirc;ce   &agrave; ce type d'initiatives. Et moi aussi.&nbsp;&raquo; Lila Pinell, juin 2009.</span></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Scuola   Elementare Federigo Tozzi, Sienne (Italie)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">CE1<span style="color: rgb(51, 51, 51);"> - </span>Donatella Bargis,   institutrice</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">03bis_sienne</span></div>\\012<div><span style="color: blue; text-transform: none;">&laquo;&nbsp;A scuola e   il quartiere&nbsp;&raquo;, dur&eacute;e 19&rsquo;27&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Une promenade &agrave; Sienne avec les enfants de l&rsquo;&eacute;cole.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: red; text-transform: none;">Texte</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;&laquo;&nbsp;Sienne est   une petite ville, tr&egrave;s ancienne, de Toscane entour&eacute;e de douces collines et de   grands espaces verts. Dans notre ville&nbsp;il n&rsquo;y a pas de grands b&acirc;timents et surtout il y a peu de trafic. Nous   pouvons marcher ou&nbsp;faire du v&eacute;lo   tranquillement.&nbsp;L&rsquo;ann&eacute;e derni&egrave;re avec   nos ma&icirc;tresses nous avonstravaill&eacute;   sur les <b>limites</b> et, gr&acirc;ce &agrave; cette   r&eacute;flexion, l&rsquo;envie est n&eacute;e de travailler avec la classe de CE1 de   l&rsquo;&eacute;cole &agrave; aires ouvertes Saint-Merri et Renard : nous avons envoy&eacute; des   dessins montrant nos moments pr&eacute;f&eacute;r&eacute;s du film   <i>Le&nbsp;Cam&eacute;raman</i>&nbsp;, ainsi que   nos portraits.&nbsp;&raquo;</span></div>\\012<div><span style="color: red; text-transform: none;"><br />\\012            </span></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome3"></a>Ecole Saint-Merri, Paris (France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">CE1<span style="color: rgb(51, 51, 51);"> - </span>Agn&egrave;s   de Willecot, institutrice</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par l&rsquo;enseignante&nbsp;Agn&egrave;s de&nbsp;Willecot</span><span style="color: red; text-transform: none;">faire interview   Willecot et Serre</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">03ter_saint_merri</span></div>\\012<div><span style="color: red; text-transform: none;">Film-essai&nbsp;:   titre&nbsp;??? </span></div>\\012<div><span style="color: red; text-transform: none;">Film voir chez   THIBAUT </span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome4"></a>Ecole &eacute;l&eacute;mentaire Maurice Genevoix, Paris   18<sup>&egrave;me</sup> (France)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">6<sup>&egrave;me</sup> - Monique Dugu&eacute; Boyer, professeur</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">16_Genevoix(1)</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Regards   crois&eacute;s de notre patrimoine&nbsp;: le mur&nbsp;&raquo;, dur&eacute;e 5&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Quatre   regards sur les murs du 18<sup>&egrave;me</sup> arrondissement de Paris.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: blue;">Texte</span></div>\\012<div><span style="font-size: 10pt; color: blue;">Pr&eacute;sentation du   travail par l&rsquo;enseignante</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">&laquo;&nbsp;En   &eacute;change avec l'Ecole centrale de Bucarest, un travail sur le patrimoine   architectural de chaque ville a &eacute;t&eacute; r&eacute;alis&eacute;. </span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">La classe de CM</span><span style="font-size: 10pt; color: windowtext;">1 et CM2 de l'&eacute;cole Maurice   Genevoix du 18<sup>&egrave;me</sup> arrondissement pr&eacute;sente un travail en cours<strong>.</strong><br />\\012            Ce qui est pr&eacute;sent&eacute; doit &ecirc;tre repris et compl&eacute;t&eacute;, pour &ecirc;tre plus &lsquo;lisible&rsquo;. <br />\\012            Le th&egrave;me g&eacute;n&eacute;ral est une interrogation et un regard sur les diff&eacute;rents   sens&nbsp;et regards que l'on peut porter sur le <i>mur</i>.<br />\\012            Des expositions nous ont servi de r&eacute;f&eacute;rence dans le montage et les   successions d'id&eacute;es, des textes &eacute;tudi&eacute;s en litt&eacute;rature, un travail en arts   visuels autour des maquettes et l'urbanisme&nbsp; en plein mouvement dans   notre quartier du 18<sup>&egrave;me</sup>, Porte de la Chapelle.<br />\\012            <strong><span style="font-weight: normal;">Photomontages sur le</span></strong><strong><span style="font-weight: normal;"> th&egrave;me du <i>mur</i></span></strong>&nbsp;:   les textes sont&nbsp;des po&egrave;mes de&nbsp;Paul Eluard, Pierre Reverdy, Gilles   Troillet, Charles Daubzynski, ainsi que des extraits d'Italo Calvino <i>Les Villes invisibles</i> &raquo;. \\012<p>            </p></span></div>\\012<div><img height="128" width="228" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image008.jpg" v:shapes="_x0000_i1042" /></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">16_Genevoix(2)</span></div>\\012<div><img height="129" width="228" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image010.jpg" v:shapes="_x0000_i1043" /></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">16_Genevoix(3)</span></div>\\012<div><img height="128" width="228" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image012.jpg" v:shapes="_x0000_i1032" /></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">16_Genevoix(4)</span></div>\\012<div><img height="128" width="228" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image014.jpg" v:shapes="_x0000_i1033" /></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: blue;">Texte</span></div>\\012<div><span style="font-size: 10pt; color: blue;">Italo Calvino, <i>Les Villes   invisibles,</i> Seuil Editions.</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">&laquo;&nbsp;En partant de l&agrave; et en allant trois jours vers le   levant, l'homme se trouve &agrave; Diomira, une ville avec soixante coupoles   d'argent, des statues en bronze de tous les dieux, des rues pav&eacute;es d'&eacute;tain,   un th&eacute;&acirc;tre en</span><br />\\012            <span style="font-size: 10pt; color: windowtext;">cristal,   un coq en or qui chante chaque matin sur une tour. Toutes ces beaut&eacute;s, le   voyageur les conna&icirc;t d&eacute;j&agrave; pour les avoir vues aussi dans d'autres villes.   Mais le propre de celle-ci est que si l'on y arrive un soir de septembre,   quand les jours raccourcissent et que les lampes multicolores s'allument   toutes ensemble aux portes des friteries, et que d'une terrasse une voix de   femme crie : hou !, on en vient &agrave; envier ceux qui &agrave; l'heure pr&eacute;sente pensent   qu'ils ont d&eacute;j&agrave; v&eacute;cu une soir&eacute;e pareille et qu'ils ont &eacute;t&eacute; cette fois-l&agrave;   heureux.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Scoala   centrala n&deg; 10, Bucarest</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">5<sup>&egrave;me</sup> C - Mariana Visan, Isabelle   Bucurescu, A. Oslobeanu, Cecila Potescu</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">17_Bucarest</span></div>\\012<div><b><span style="font-size: 10pt;">&nbsp;</span></b><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Bucarest d&rsquo;aujourd&rsquo;hui &ndash; Ancien &lsquo;Petit   Paris&rsquo;&nbsp;&raquo;, extrait 5&rsquo;30&rsquo;&rsquo; - dur&eacute;e 16&rsquo;50&rsquo;&rsquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Une balade dans la ville, &agrave; travers les yeux des enfants   de 6<sup>&egrave;me</sup> de l&rsquo;&eacute;cole de Bucarest.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="157" width="210" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image016.jpg" v:shapes="_x0000_i1029" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;</span><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;Nous   avons d&eacute;cid&eacute;&nbsp;de participer &agrave; ce projet   et de r&eacute;aliser ce film avec nos &eacute;l&egrave;ves de 6<sup>&egrave;me</sup> pour r&eacute;investir des   apprentissages scolaires dans un projet de communication vers l&rsquo;ext&eacute;rieur de   l`&eacute;cole, d&eacute;velopper le sens de la rigueur et pour donner un lien aux diff&eacute;rents   contenus scolaires.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les domaines concern&eacute;s plus particuli&egrave;rement ont   &eacute;t&eacute;&nbsp;:</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- Le fran&ccedil;ais</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- L&rsquo;histoire de l&rsquo;art&nbsp;: connaissance d&rsquo;&oelig;uvres dans   des domaines vari&eacute;s, d&eacute;couvertes, recherche sur Bucarest, dans l&rsquo;id&eacute;e de   mieux conna&icirc;tre sa ville.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">- </span></b><span style="color: windowtext; text-transform: none;">l`histoire<b>&nbsp;: </b>inclure l&rsquo;histoire dans une   d&eacute;marche globale de compr&eacute;hension du monde).</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">- </span></b><span style="color: windowtext; text-transform: none;">l`informatique&nbsp;:   s&rsquo;approprier un outil de travail et de communication, dans un esprit   responsable.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">- </span></b><span style="color: windowtext; text-transform: none;">sciences   et techniques<b>&nbsp;: </b>l&rsquo;&eacute;volution   des techniques, l&rsquo;image fabrication et perception.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">En participant &agrave; ce projet, nos &eacute;l&egrave;ves ont d&eacute;velopp&eacute; le   go&ucirc;t de la d&eacute;couverte, de la curiosit&eacute;, ont appris &agrave; regarder, &agrave; observer, &agrave;   r&eacute;fl&eacute;chir, &agrave; s&rsquo;interroger. Ils ont pris aussi conscience d&rsquo;un choix commun   dans lequel chacun peut avoir un r&ocirc;le. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">M&ecirc;me s&rsquo;ils ont eu des difficult&eacute;s dans la r&eacute;alisation de leur   petit film, la grande satisfaction qu&rsquo;ils ont ressentie &agrave; la fin de leur travail   les a effac&eacute;es totalement.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<p><span style="font-size: 10pt; color: rgb(51, 51, 51);"><br clear="all" /><br />\\012</span></p>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome5"></a>Coll&egrave;ge Thomas Mann, Paris 13<sup>&egrave;me </sup>(France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">4<sup>&egrave;me</sup>D - Elisabeth Loupiac, <span style="color: rgb(51, 51, 51);">professeur d&rsquo;arts plastiques</span></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par </span><span style="color: blue; text-transform: none;">Elisabeth    Loupiac</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">04_thomas_mann</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;</span><span style="color: blue; text-transform: none;">&laquo;&nbsp;Pas perdus&nbsp;&raquo;,&nbsp;dur&eacute;e 6&rsquo;18&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Sous   la direction d&rsquo;Antoine Petit, professeur d&rsquo;&eacute;ducation physique</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La classe et la ville de Paris&nbsp;: balades et   &laquo;&nbsp;effets sp&eacute;ciaux</span><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;&raquo;.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="153" width="204" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image018.jpg" v:shapes="_x0000_i1030" /></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Scuola Media   Irnerio, Bologne </span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">(Italie)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">5<sup>&egrave;me</sup>C - Elisa Cappi, <span style="color: rgb(51, 51, 51);">professeur d&rsquo;histoire</span></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par Elisa Cappi</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">05_scuola_irnerio_bologne</span></div>\\012<div><span style="color: blue; text-transform: none;">&laquo;&nbsp;La mia citt&agrave;&nbsp;&raquo;, dur&eacute;e 14&rsquo;29&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">D&eacute;couverte de la ville de Bologne par la classe, &agrave;   travers une chasse au tr&eacute;sor qui les conduira &agrave;&hellip; Paris.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="154" width="204" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image020.jpg" v:shapes="_x0000_i1031" /></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome6"></a>Coll&egrave;ge Thomas Mann, Paris 13<sup>&egrave;me </sup>(France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">4<sup>&egrave;me</sup>E - Elisabeth Loupiac</span><span style="color: rgb(51, 51, 51); text-transform: none;">, <span style="color: rgb(51, 51, 51);">professeur d&rsquo;arts plastiques</span></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">06_thomas_mann</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Cin&eacute;ma Paris&nbsp;&raquo;, dur&eacute;e 5&rsquo;55&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">R&eacute;alis&eacute; sous la direction de Lila Pinell (sc&eacute;nario,   tournage, montage).</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Un &laquo;&nbsp;journal t&eacute;l&eacute;vis&eacute;&nbsp;&raquo; sur la ville, r&eacute;alis&eacute;   par les &eacute;l&egrave;ves il s&rsquo;inspire de certains des films les plus c&eacute;l&egrave;bres de   l&rsquo;histoire du 7<sup>&egrave;me</sup> art.</span><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012<div><img height="135" width="180" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image022.jpg" v:shapes="_x0000_i1044" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par Lila Pinell</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;&laquo;&nbsp;J'ai   rencontr&eacute; Elisabeth Loupiac   il y a un an, au mois de juillet. Elle voulait monter une com&eacute;die musicale   avec quelques &eacute;l&egrave;ves inscrits &agrave; l'&eacute;cole ouverte du coll&egrave;ge Thomas Mann. Nous   avons donc travaill&eacute; ensemble pendant une semaine, l'exp&eacute;rience a &eacute;t&eacute; riche   et heureuse, et il en a r&eacute;sult&eacute; un film qui a &eacute;t&eacute; projet&eacute; aux &eacute;l&egrave;ves et &agrave;   leurs invit&eacute;s. Le tout s'est d&eacute;roul&eacute; au <i>b&eacute;tonsalon</i>,   un centre d'art au sein duquel j'organise ces diff&eacute;rents ateliers vid&eacute;o. Cette   ann&eacute;e elle m'a recontact&eacute; et je l'ai assist&eacute; sur le projet &laquo;&nbsp;Ma ville vue   par...&nbsp;&raquo;. J&rsquo;ai suivi deux classes : avec la premi&egrave;re, nous avons imagin&eacute;   un sc&eacute;nario dans lequel des &eacute;l&egrave;ves seraient projet&eacute;s dans le film <i>Le Cam&eacute;raman</i>. Cela a permis aux &eacute;l&egrave;ves   de comprendre la construction du film plan par plan. Pour ins&eacute;rer leur propre   image dans le film, ils ont d&ucirc; distinguer les champs et les contre-champs,   les plans serr&eacute;s et les plans larges, et trouver les moments opportuns pour   apparaitre. Ils avaient imagin&eacute; une histoire de vengeance lors de laquelle un   &eacute;l&egrave;ve deviendrait invisible.&nbsp;Nous   avons donc cr&eacute;&eacute; des effets sp&eacute;ciaux tr&egrave;s simples, et les &eacute;l&egrave;ves ont imagin&eacute;   des situations comiques mettant en jeu cette invisibilit&eacute;. Le temps nous   ayant un peu manqu&eacute;, j'ai mont&eacute; moi m&ecirc;me le petit film, mais j'aurais aim&eacute;   qu'ils puissent aussi participer &agrave; cette derni&egrave;re phase.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Avec le deuxi&egrave;me groupe, nous nous sommes concentr&eacute;s sur   Paris. Apr&egrave;s plusieurs discussions, nous sommes tomb&eacute;s d'accord sur l'id&eacute;e de   faire des remakes de sc&egrave;nes tr&egrave;s connues du cin&eacute;ma international, mais de les   transposer &agrave; Paris. Nous avons choisi les films, les sc&egrave;nes, les lieux. Puis   nous avons observ&eacute; le d&eacute;coupage exact des morceaux choisis et nous avons   tent&eacute; de les reproduire dans la mesure du possible. Nous avons utilis&eacute; des   plans larges, moyens, ou des contre-plong&eacute;es lorsqu'il y en avait dans la   sc&egrave;ne initiale.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Chaque fois, nous avons pos&eacute; la musique du film sur   l'extrait rejou&eacute; (ce qui aide beaucoup !). </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ainsi, durant plusieurs apr&egrave;s-midis, nous avons arpent&eacute; Paris   en bus, &agrave; pied ou en m&eacute;tro, en rejouant des sc&egrave;nes de film dans des c&eacute;l&egrave;bres   endroits de Paris ou certains n'avaient jamais &eacute;t&eacute;.&nbsp;&raquo; Lila Pinell, juin 2009</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Scuola Media Irnerio, Bologne (Italie)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">5<sup>&egrave;me</sup>2B - Daniela Amante</span><span style="color: rgb(51, 51, 51); text-transform: none;">,</span><span style="color: rgb(51, 51, 51); text-transform: none;"> <span style="color: rgb(51, 51, 51);">professeur d&rsquo;histoire</span></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">06bis_scuola_media_irnerio</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;</span><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;</span><span style="color: blue; text-transform: none;">&laquo;&nbsp;Bologne&nbsp;&raquo; dur&eacute;e 10&rsquo;20&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Une promenade dans Bologne avec   les &eacute;l&egrave;ves.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="139" width="185" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image024.jpg" v:shapes="_x0000_i1045" /></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome7"></a>Coll&egrave;ge Thomas Mann, Paris 13<sup>&egrave;me</sup>(France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">4<sup>&egrave;me</sup>C - Elisabeth Loupiac</span><span style="color: rgb(51, 51, 51); text-transform: none;">, <span style="color: rgb(51, 51, 51);">professeur d&rsquo;arts plastiques</span></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">07_thomas_mann</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Le Cam&eacute;raman&nbsp;&raquo;, dur&eacute;e 7&rsquo;37&rsquo;&rsquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Film r&eacute;alis&eacute; sous la direction de <span style="color: rgb(51, 51, 51);">Lila Pinell. (</span>coordination, tournage,   montage).</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Toute la classe disparait et se retrouve <b>dans</b> le   film &laquo;&nbsp;Le cam&eacute;raman&nbsp;&raquo;.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="145" width="193" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image026.jpg" v:shapes="_x0000_i1041" /></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Colegiul   national Mihai Eminescu, Iasi (Roumanie)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">4<sup>&egrave;me</sup> - Sorina Danaila</span><span style="color: rgb(51, 51, 51); text-transform: none;">, <span style="color: rgb(51, 51, 51);">professeur de fran&ccedil;ais langue   &eacute;trang&egrave;re</span></span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;">http://lme.is.edu.ro/</span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">12bis_iasi_mihai_eminescu</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Ma ville de jeunesse&nbsp;&raquo;, dur&eacute;e   7&rsquo;22&rsquo;&rsquo; / &laquo;&nbsp;Ma ville de tranquillit&eacute;&nbsp;&raquo;, dur&eacute;e 10&rsquo;08&rsquo;&rsquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">La classe a voulu mettre en opposition - par le sujet,   par le rythme et aussi par la mani&egrave;re d'entrevoir la gestuelle, la marche et   m&ecirc;me la fa&ccedil;on de filmer: le Iasi   de la jeunesse et le   Iasi de l'orthodoxie.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par les enseignants</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;&laquo;&nbsp;Pour les   petits films, c'est tr&egrave;s simple : l'un d'entre eux est une promenade joyeuse   et tr&egrave;s jeune dans une ville qui s'ouvre &agrave; la jeunesse malgr&eacute; son &acirc;ge   v&eacute;n&eacute;rable et sa v&eacute;tust&eacute;. Il a un rythme joyeux et alerte, qui voulait faire   pendant au deuxi&egrave;me film, qui veut mettre en &eacute;vidence un Iasi orthodoxe,   paisible, conservateur, calme, malgr&eacute; toute la modernit&eacute;, plein d'images   d'&eacute;glises qui projettent dans un autre espace et un autre temps. En fait, la   classe a&nbsp;voulu, finalement, se mettre   en opposition - par le sujet, par le rythme et aussi par la mani&egrave;re   d'entrevoir la gestuelle, la marche et m&ecirc;me la fa&ccedil;on de filmer le Iasi de la jeunesse et le   Iasi de l'orthodoxie.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<p><span style="font-size: 10pt; color: rgb(51, 51, 51);"><br clear="all" /><br />\\012</span></p>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome8"></a>Lyc&eacute;e Maurice Ravel, Paris 19<sup>&egrave;me</sup>(France)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">BTS Assistant trilingue - Yola Le Ca&iuml;nec,   professeur de fran&ccedil;ais</span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;"><a href="http://lyc-maurice-ravel.scola.ac-paris.fr/citscol/college.htm">http://lyc-maurice-ravel.scola.ac-paris.fr/citscol/college.htm</a></span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div><span style="font-size: 10pt; color: blue;">Pr&eacute;sentation par Yola Le Ca&iuml;nec, Ma&euml;lys Bourgoin,   Sophie&nbsp;Besson et&nbsp;Esther&nbsp;Baucher</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">08_maurice_ravel</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Ma ville vue   par moi&nbsp;&raquo;, r&eacute;alis&eacute;e par Ma&euml;lys Bourgoin, dur&eacute;e 2&rsquo;37&rsquo;&rsquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&laquo;&nbsp;J&rsquo;ai choisi de montrer diff&eacute;rents lieux du centre   de Paris &agrave; mes correspondants Roumains du Colegiul national I.C. Bratianu de Pitesti.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012<div><img height="143" width="193" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image028.jpg" v:shapes="_x0000_i1039" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;&laquo;&nbsp;J&rsquo;ai   travaill&eacute; dans l&rsquo;optique de d&eacute;finir comment mon regard per&ccedil;oit le caract&egrave;re   culturel de Paris. Jai souhait&eacute; donner deux grands axes &agrave; mon film&nbsp;tout   en restant fid&egrave;le au th&egrave;me de la promenade&nbsp;;&nbsp;donne &agrave; voir des lieux embl&eacute;matiques   comme&nbsp;: la    Cath&eacute;drale Notre Dame, le Marais ou encore le Centre Pompidou.&nbsp;&raquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">La chronologie&nbsp;: Je voulais que le mouvement de la cam&eacute;ra corresponde aux   trajectoires prises par mon corps et que l&rsquo;on puisse rep&eacute;rer sur une carte   les d&eacute;tours emprunt&eacute;s.</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Le rythme&nbsp;: Toujours dans un souci de r&eacute;alisme,   j&rsquo;ai fait co&iuml;ncider la    musique avec les acc&eacute;l&eacute;rations de la foule et j&rsquo;ai marqu&eacute;   les moments cl&eacute;s par des pauses dans la musique. </span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Gr&acirc;ce &agrave; la &laquo;&nbsp;Maison du Geste et de l&rsquo;Image&nbsp;&raquo;   de Paris, qui m&rsquo;a accueillie, j&rsquo;ai pu monter mon film sur le logiciel de   montage Final Cut Pro.&nbsp;&raquo; Ma&euml;lys Bourgoin</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">08bis_maurice_ravel</span></div>\\012<div><span style="color: blue; text-transform: uppercase;">&nbsp;</span><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Walk in Paris by Sophie B. et Esther B.&nbsp;&raquo;, r&eacute;alis&eacute;e   par Sophie Besson, Esther    Baucher, dur&eacute;e 3&rsquo;26&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Une promenade   &agrave; Paris.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="143" width="193" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image030.jpg" v:shapes="_x0000_i1036" /></div>\\012<div><u>&nbsp;</u></div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;&laquo;&nbsp;Nous avons   d&ucirc; faire vite avec deux cam&eacute;ras pour deux heures en ville avec une m&eacute;t&eacute;o tr&egrave;s   favorable ce jour. Ne disposant que de tr&egrave;s peu de temps, nous avons orient&eacute;   les images vers deux th&egrave;mes principaux, l'architecture et les animaux, les   rues servant plus de rep&egrave;res pour la promenade.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je dirais que l'architecture est le th&egrave;me dominant.&nbsp;&raquo;   Sophie Besson</span></div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Colegiul Ion C. Bratianu, Pitesti (Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">Terminale - Iulian    Untaru, professeur de fran&ccedil;ais langues &eacute;trang&egrave;res</span></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: blue;">http://www.epitesti.ro/young/hi-school/</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">09_PP_pitesti</span><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: red; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">attention voir Lacie</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">La ville de   Pitesti</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);"><img height="125" width="171" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image032.jpg" alt="pitestiel panorama" v:shapes="Picture_x0020_5" /></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">09_colegiul_bratianu_pitesti(4)</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Notre lyc&eacute;e&nbsp;&raquo;,   dur&eacute;e 10&rsquo;45&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Visite   du coll&egrave;ge Ion C. Bratianu, homme politique roumain (1864-1927). Parcours   historique, pr&eacute;sentation des &eacute;l&egrave;ves c&eacute;l&egrave;bres&hellip;</span></div>\\012<div>&nbsp;</div>\\012<div><img height="139" width="185" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image034.jpg" v:shapes="_x0000_i1040" /></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">09_colegiul_bratianu_pitesti(3)</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&nbsp;&laquo;&nbsp;L&rsquo;Architecture de Pitesti&nbsp;&raquo;,   dur&eacute;e 10&rsquo;57&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Promenade   dans la ville de Pitesti.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="130" width="173" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image036.jpg" v:shapes="_x0000_i1046" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par les enseignants</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;&laquo;&nbsp;Nous avons   voulu pr&eacute;senter l&rsquo;architecture de notre ville d&rsquo;une mani&egrave;re originale, dans   le cadre d&rsquo;une petite histoire qui racontait une amourette. Le plus difficile   a &eacute;t&eacute; le montage. Il a &eacute;t&eacute; r&eacute;alis&eacute; par Adonis et George, qui ont de   l&rsquo;exp&eacute;rience dans ce domaine. La lecture a &eacute;t&eacute; faite par Iulia, qui a traduit   les textes et George a fait l&rsquo;enregistrement. Les autres membres de l&rsquo;&eacute;quipe   ont fait les recherches sur l&rsquo;architecture de Pitesti. L&rsquo;&eacute;quipe a &eacute;t&eacute;   coordonn&eacute;e par notre professeur, Iulian Untaru.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">09_Colegiul_Bratianu_Pitesti(1)</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&nbsp;&laquo;&nbsp;Les rues&nbsp;&raquo;, dur&eacute;e 10&rsquo;12&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">Une promenade   dans les rues de Pitesti.</span></div>\\012<div><img height="131" width="197" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image038.jpg" v:shapes="_x0000_i1037" /></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">09_Colegiul_Bratianu_Pitesti(2)</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;La   Foule&nbsp;&raquo;, dur&eacute;e 10&rsquo;26&rsquo;&rsquo;</span></div>\\012<div><img height="142" width="186" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image040.jpg" v:shapes="_x0000_i1038" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="font-size: 10pt;">&nbsp;&laquo;&nbsp;La   foule diverse, bigarr&eacute;e, anonyme repr&eacute;sente l&rsquo;&acirc;me quotidienne de notre ville,   elle peuple notre univers noy&eacute; dans le b&eacute;ton et dans l&rsquo;artificiel, cette </span><span style="font-size: 10pt;">civilisation urbanis&eacute;e et   pollu&eacute;e d&rsquo;aujourd&rsquo;hui. La foule, c&rsquo;est le triomphe de l&rsquo;homme vivant sur   l&rsquo;homme c&acirc;bl&eacute;, scotch&eacute; devant le moniteur.<br />\\012            Nous pouvons &eacute;couter aussi la voix myst&eacute;rieuse de   l'actrice Luminita Borta qui r&eacute;cite le po&egrave;me <i>L'Amour</i><span> de</span>&nbsp;Jacques Pr&eacute;vert.<br />\\012            Nous pensons que ce film   est un bon moyen de souligner la condition de l'homme   dans une ville qui ressemble &agrave; toutes les villes.<span style="color: rgb(51, 51, 51);">&nbsp;&raquo;</span></span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<p></p>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table width="633" cellspacing="0" cellpadding="0" border="1" style="border: medium none ; width: 474.9pt; border-collapse: collapse;">\\012<tbody>\\012<tr style="height: 247.05pt;">\\012<td width="317" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 237.45pt; height: 247.05pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome9"></a>Lyc&eacute;e Maurice Ravel, Paris 19<sup>&egrave;me</sup>   (France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">1<sup>&egrave;re</sup>ES - Isabelle Limon,   professeur d&rsquo;allemand</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">A pr&eacute;parer film matin&eacute;e</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par Isabelle Limon</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_ PP_visite_a _aachen_annamarie</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_ PP_visite_a   _aachen_arthur</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_ PP_visite_a   _aachen_lisa</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_ PP_visite_a   _aachen_antoine</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_PP_ visite_a   _aachen_yoannd</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_ PP_ravel_limon   _visite_aix_la_chapelle</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10bis_PP_diapo_voyage_chazette</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">10_PP_   visite_aachen</span></div>\\012<div><span style="color: blue; text-transform: none;">Diaporamas   &laquo;&nbsp; Visite &agrave; Aix-la-Chapelle&nbsp;&raquo; dur&eacute;e 5&rsquo;</span></div>\\012<div>&nbsp;</div>\\012<div><img height="180" width="240" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image042.jpg" v:shapes="_x0000_i1047" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: windowtext; text-transform: none;">En   mars 2009, les &eacute;l&egrave;ves de la classe de 1<sup>&egrave;re</sup> ES d&eacute;j&agrave; en lien depuis   l&rsquo;ann&eacute;e pr&eacute;c&eacute;dente, avec le Berufskolleg d&rsquo;Herzogenrath, ont visit&eacute; leurs   partenaires. Promenades &agrave; Herzogenrath, Aix-la-Chapelle (Aachen), et &agrave; la   fronti&egrave;re entre l&rsquo;Allemagne, la Belgique et la Hollande&hellip;</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="317" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 237.45pt; height: 247.05pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Berufskolleg Herzogenrath</span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">(Allemagne)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">1&egrave;re &eacute;conomie-commerce, Jean-Paul Moreau,   professeur de fran&ccedil;ais</span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;"><a href="http://www.bkherzogenrath.de/">http://www.bkherzogenrath.de/</a></span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="color: red; text-transform: none;">Texte</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les &eacute;l&egrave;ves allemands proposent diff&eacute;rentes visions de   leur r&eacute;gion.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">11_ 1_aachen</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Aachen&nbsp;&raquo; dur&eacute;e 52&rsquo;&rsquo;</span></div>\\012<div><img height="135" width="101" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image044.jpg" v:shapes="_x0000_i1048" /></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">11_ 2_aachen</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Aachen&nbsp;&raquo;, dur&eacute;e 3&rsquo;24&rsquo;&rsquo;</span></div>\\012<div><img height="141" width="186" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image046.jpg" v:shapes="_x0000_i1049" /></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">11_3_baesweiler</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Baesweiler&nbsp;&raquo;, dur&eacute;e 44&rsquo;&rsquo;</span></div>\\012<div><img height="138" width="186" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image048.jpg" v:shapes="_x0000_i1050" /></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">11_ 4_alsdorf</span></div>\\012<div><span style="color: blue; text-transform: none;">&nbsp;&laquo;&nbsp;Alsdorf&nbsp;&raquo; dur&eacute;e 3&rsquo;06&rsquo;&rsquo;</span></div>\\012<div><img height="148" width="198" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image050.jpg" v:shapes="_x0000_i1051" /></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">11_PP_5_alsdorf</span></div>\\012<div><span style="color: blue; text-transform: none;">&laquo;&nbsp;Alsdorf&nbsp;&raquo; </span></div>\\012<div><img height="143" width="197" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image052.jpg" v:shapes="_x0000_i1052" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par l&rsquo;enseignant</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;&laquo;&nbsp;Les &eacute;l&egrave;ves   du Berufskolleg Herzogenrath de la classe G11 passeront l&rsquo;Abitur dans trois ans.   Dans le cours de fran&ccedil;ais ils ont particip&eacute; cette ann&eacute;e, avec leurs   correspondants du Lyc&eacute;e Maurice Ravel de Paris 20, au projet cin&eacute;ma propos&eacute;   par le Centre Pompidou et dont le th&egrave;me est&nbsp;: &laquo;&nbsp;Ma ville vue   par&hellip;&nbsp;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Le point de d&eacute;part a &eacute;t&eacute; l&rsquo;Atelier <i>Lignes de temps</i> qui a eu lieu &agrave; notre &eacute;cole au mois de novembre.   Les explications &eacute;taient en langue fran&ccedil;aise. Les &eacute;l&egrave;ves qui avaient quatre   ans de fran&ccedil;ais ont tr&egrave;s bien compris ce qu&rsquo;on leur a communiqu&eacute;. Le th&egrave;me   cin&eacute;matographique &eacute;tait tr&egrave;s motivant et la pr&eacute;sentation du logiciel <i>Lignes de temps</i> &eacute;tait parfaitement &agrave;   leur port&eacute;e. L&rsquo;intervention d&rsquo;experts extra scolaires a compl&egrave;tement capt&eacute;   leur attention et l&rsquo;introduction tr&egrave;s p&eacute;dagogique des intervenantes ne   pouvait que rencontrer la compr&eacute;hension de tous. Plusieurs coll&egrave;gues dont   notre directeur ont assist&eacute; &agrave; cette prestation exceptionnelle.</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Puis les &eacute;l&egrave;ves ont regard&eacute; le film &laquo;&nbsp;L&rsquo;Aurore&nbsp;&raquo;   de Murnau et ont &eacute;crit leurs impressions et leurs remarques. Celles-ci ont   &eacute;t&eacute; envoy&eacute;es aux correspondants parisiens, qui ont fait de m&ecirc;me.   L&rsquo;appr&eacute;hension du d&eacute;part pour un film en noir et blanc et muet par-dessus le   march&eacute; a &eacute;t&eacute; vite surmont&eacute;e. Les &eacute;l&egrave;ves ont reconnu la qualit&eacute; artistique du   film, les moyens techniques employ&eacute;s, l&rsquo;interpr&eacute;tation des acteurs. Certains   en ont parl&eacute; dans leur r&eacute;sum&eacute;, sans qu&rsquo;on ait au pr&eacute;alable attir&eacute; leur   attention sur ces points. Le th&egrave;me de la ville vue par Murnau a ensuite &eacute;t&eacute;   discut&eacute; en cours.</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Apr&egrave;s les vacances de No&euml;l les &eacute;l&egrave;ves ont form&eacute; de   petits groupes pour faire une pr&eacute;sentation film&eacute;e de leur ville ou leur   quartier. C&rsquo;est ainsi que nous avons obtenu plusieurs r&eacute;sultats&nbsp;: deux   sur la ville d&rsquo;Aix-la-Chapelle, un sur Alsdorf et un sur Baesweiler. Ces   films ont &eacute;t&eacute; envoy&eacute;s &agrave; Paris.</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Lors de la rencontre &agrave; Paris au mois de mars, les petits   groupes allemands se sont associ&eacute;s aux petits groupes fran&ccedil;ais et pour   prendre quelques images ou quelques vid&eacute;os sur la ville de Paris ou ses   quartiers selon des aspects qui ont pr&eacute;alablement &eacute;t&eacute; convenus au sein des   groupes franco-allemands. L&rsquo;&eacute;change n&rsquo;est pas encore termin&eacute; puisque nous   devons encore recevoir &agrave; Herzogenrath le groupe parisien. </span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Parmi les multiples effets positifs que nous a apport&eacute;s   le projet citons en quelques-uns au hasard : Le th&egrave;me de la ville est   particuli&egrave;rement bien adapt&eacute; aux &eacute;changes puisqu&rsquo;une partie des activit&eacute;s   d&rsquo;un &eacute;change ordinaire consiste &agrave; visiter les lieux o&ugrave; vivent les   partenaires. L&rsquo;aspect cin&eacute;matographique nous a apport&eacute; un grand plus, puisque   les &eacute;l&egrave;ves ont &eacute;t&eacute; sensibilis&eacute;s &agrave; certains c&ocirc;t&eacute;s de l&rsquo;art et de la technique   cin&eacute;matographique, qu&rsquo;ils ont communiqu&eacute; sur ce sujet, qu&rsquo;ils l&rsquo;ont m&ecirc;me   utilis&eacute; pour communiquer entre eux. Ce moyen de communication &eacute;tant, comme le   pensait Chaplin, universel, ils ont pu communiquer au-del&agrave; des mots par le   truchement de la cam&eacute;ra.    Ce ne sont pas uniquement les &eacute;l&egrave;ves qui ont tir&eacute; parti de   ce projet, mais aussi les professeurs car il leur a ouvert des horizons.&nbsp;&raquo;   J.P. M.</span></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<p><span style="font-size: 10pt; color: rgb(51, 51, 51);"><br clear="all" /><br />\\012</span></p>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome10"></a>Coll&egrave;ge Jean Moulin, Paris 14<sup>&egrave;me</sup> (France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">3<sup>&egrave;me</sup>A etgroupe d&rsquo;&eacute;l&egrave;ves de 3<sup>&egrave;me</sup> - Laurence Dauvergne,   professeur de technologie / Elisabeth Battistel et&nbsp;Dominique Vadet, professeurs de fran&ccedil;ais/ C&eacute;line Noras, professeur   d&rsquo;anglais / Mme Amor Fahsi, professeur 1<sup>er</sup> degr&eacute; d&rsquo;UPI</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">http://clg-jean-moulin.scola.ac   paris.fr/spip/spip.php?page=login</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: red; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">Film de la matin&eacute;e / pr&eacute;sentation   par&nbsp;?????</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">12_jean_moulin</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Une   rencontre &agrave; Paris&nbsp;&raquo;&nbsp;par des &eacute;l&egrave;ves de 3</span><sup><span style="font-size: 10pt; color: blue;">&egrave;me</span></sup><span style="font-size: 10pt; color: blue;">BCDE&nbsp;:   montage par Marie, dur&eacute;e 2&rsquo;25&rsquo;&rsquo; / montage par&nbsp;Vladimir, dur&eacute;e 5&rsquo;59&rsquo;&rsquo; / montage par Th&eacute;o, dur&eacute;e 5&rsquo;20&rsquo;&rsquo; / &nbsp;montage par&nbsp;Yixuan, dur&eacute;e 4&rsquo;41&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Un adolescent   visite Paris pour la premi&egrave;re fois. Il rencontre un &eacute;l&egrave;ve du coll&egrave;ge Jean   Moulin. Deux visions de Paris, l'une touristique, l'autre plus quotidienne,   se croisent. Diff&eacute;rents montages r&eacute;alis&eacute;s par les &eacute;l&egrave;ves &agrave; partir des m&ecirc;mes   images tourn&eacute;es par la classe.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Des tenues   pour Paris&nbsp;&raquo;, r&eacute;al. Odile, 4&rsquo;57&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Des &eacute;l&egrave;ves sont rejet&eacute;s par un groupe   en raison de leur habillement (diff&eacute;rent des leurs). Rejet&eacute;s, ils font le   tour de Paris et observent des tenues vestimentaires tr&egrave;s diverses. Ils   reviennent et sont finalement int&eacute;gr&eacute;s au groupe.</span></div>\\012<div><img height="135" width="180" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image054.jpg" v:shapes="_x0000_i1053" /></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">12_1_jean_moulin_upi</span></div>\\012<div><span style="color: red; text-transform: none;">Attention voir le DVD dans dossier, &nbsp;film upi / faire encodage / voir Thibaut</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Colegiul national Mihai Eminescu, Iasi (Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">4<sup>&egrave;me</sup> et 3<sup>&egrave;me</sup> - Sorina Danaila,   professeur de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">2<sup>&egrave;me</sup> -&nbsp;Corina Ungurean,   professeur de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">12bis_iasi_mihai_eminescu</span></div>\\012<div><span style="color: blue; text-transform: none;">&laquo;&nbsp;Ma   ville de jeunesse&nbsp;&raquo;, dur&eacute;e 7&rsquo;22&rsquo;&rsquo; / &laquo;&nbsp;Ma ville de   tranquillit&eacute;&nbsp;&raquo;, dur&eacute;e 10&rsquo;08&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La classe a voulu mettre en opposition - par le sujet,   par le rythme et aussi par la mani&egrave;re d'entrevoir la gestuelle, la marche et   m&ecirc;me la fa&ccedil;on de filmer - le Iasi de la jeunesse et le   Iasi de l'orthodoxie.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par les enseignantes</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;Les classes ont fait des   progr&egrave;s dans la pr&eacute;paration (th&egrave;mes des petits films, petits sc&eacute;narios,   travail technique de compr&eacute;hension des notions cin&eacute;matographiques...). Pour   ce qui est des collaborations avec le Coll&egrave;ge Thomas Mann &agrave; Paris les enfants   ont fait connaissance gr&acirc;ce &agrave; des blogs.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Nous avons aussi assist&eacute; &agrave; des projections d&rsquo;un festival   de documentaires sur la    ville de Iasi programm&eacute; pour la comm&eacute;moration des   600 ans de la    fondation de la ville. C'&eacute;tait l'illustration id&eacute;ale de   notre projet, et qui est tomb&eacute; fort &agrave; propos... Les enfants ont appr&eacute;ci&eacute; et   ont beaucoup argument&eacute; sur la valeur des films.&nbsp;&raquo; Sorina Danaila</span></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<p><span style="font-size: 10pt; color: rgb(51, 51, 51);"><br clear="all" /><br />\\012</span></p>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome11"></a>Colegiul national Radu Negru, </span><span style="font-size: 12pt; color: windowtext; text-transform: none;">F</span><span style="font-size: 12pt; color: windowtext; text-transform: none;">\\304\\203</span><span style="font-size: 12pt; color: windowtext; text-transform: none;">g</span><span style="font-size: 12pt; color: windowtext; text-transform: none;">\\304\\203</span><span style="font-size: 12pt; color: windowtext; text-transform: none;">ra</span><span style="font-size: 12pt; color: windowtext; text-transform: none;">\\305\\237</span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">(Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">1<sup>&egrave;re</sup> &nbsp;Raluca Ionescu,   professeur de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;"><a href="http://radunegru.licee.edu.ro/">http://radunegru.licee.edu.ro/</a></span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: red; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">Film matin&eacute;e / Pr&eacute;sentation par Raluca Ionescu et deux   &eacute;l&egrave;ves.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">13_F</span><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">\\304\\203</span><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">g</span><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">\\304\\203</span><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">ra</span><span style="background: yellow none repeat scroll 0% 0%; color: blue; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">\\305\\237</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&nbsp;&laquo;&nbsp;Ma ville vue par&hellip; nous-m&ecirc;mes&nbsp;&raquo;,   dur&eacute;e 11&rsquo;07&rsquo;&rsquo;</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">Reportage sur la ville de F</span><span style="color: rgb(51, 51, 51); text-transform: none;">\\304\\203</span><span style="color: rgb(51, 51, 51); text-transform: none;">g</span><span style="color: rgb(51, 51, 51); text-transform: none;">\\304\\203</span><span style="color: rgb(51, 51, 51); text-transform: none;">ra</span><span style="color: rgb(51, 51, 51); text-transform: none;">\\305\\237</span><span style="color: rgb(51, 51, 51); text-transform: none;"> et ses   monuments historiques.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="155" width="217" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image056.jpg" v:shapes="_x0000_i1054" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Ann&eacute;e scolaire   2008-2008 / Programme de travail</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Ann&eacute;e scolaire 2008-2008 /   Programme de travail</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Septembre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Diffusion du projet dans le lyc&eacute;e: </span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- discussion avec: le Proviseur, le   Conseil d'Administration, le service comptable, les &eacute;l&egrave;ves</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- recherche de sponsors pour le   voyage &agrave; Paris, au mois de mai/ juin</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Septembre-octobre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">constitution du groupe des &eacute;l&egrave;ves participants</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Octobre-novembre </span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Avec le groupe d'&eacute;l&egrave;ves : </span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- visionnage du film <i>Le Cam&eacute;raman</i> de Buster Keaton.</span></div>\\012<div style="margin-left: 117pt; text-indent: -114pt;"><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">-installation du   logiciel <i>Lignes de temps</i>.</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- accueil de Fr&eacute;d&eacute;rique Mirotchnikoff et de Marta Boni:</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- explication de l'emploi de ce   logiciel</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- explication des &eacute;tapes du projet</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">-&nbsp;utilisation du logiciel <i>Lignes   de temps</i>.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Novembre-d&eacute;cembre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Mise en relation avec le bin&ocirc;me fran&ccedil;ais.</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- &eacute;change des lettres de pr&eacute;sentation,</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- mise au point du programme</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Janvier-f&eacute;vrier-mars</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Filmer dans la ville.</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Mars-avril</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- sc&eacute;narisation, tournage, montage du film sur sa propre   ville.</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- correspondance entre bin&ocirc;mes sous forme de production   de &laquo;films-essais&raquo; sur sa&nbsp;propre ville </span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Mai</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- derniers aspects administratifs&nbsp;et mises au point - envoi du film au Centre   Pompidou.</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">- participation au visionnage au Centre Pompidou. </span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Juin</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Diss&eacute;mination du projet dans le lyc&eacute;e</span></div>\\012<div><b><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Septembre 2009</span></b></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Avant la rentr&eacute;e: diss&eacute;mination du projet dans les   &eacute;coles de la ville et du   d&eacute;partement</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Responsable du projet</span></div>\\012<div><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">Raluca Ionescu</span><span style="color: windowtext; text-transform: none; letter-spacing: -0.2pt;">,&nbsp;Professeur de   fran&ccedil;ais langue &eacute;trang&egrave;re. Colegiul National &laquo;&nbsp;Radu Negru&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Quelques courriers des &eacute;l&egrave;ves roumains &agrave; leurs   correspondants fran&ccedil;ais</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Bonjour</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je m&rsquo;appelle Cristian. J&rsquo;ai 17 ans.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis en XI&egrave;me E au Coll&egrave;ge National Radu Negru. En   Roumanie, les coll&egrave;ges nationaux sont les lyc&eacute;es les plus prestigieux.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Notre petite ville tranquille est situ&eacute;e au centre en   Transylvanie (r&eacute;gion du centre du pays), pr&egrave;s des montagnes.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis entr&eacute; dans ce projet parce que j&rsquo;aime le   fran&ccedil;ais, j&rsquo;aime le cin&eacute;ma, le&nbsp;th&eacute;&acirc;tre   et je serai tr&egrave;s heureux si, au mois de juin, on se voyait &agrave; Paris.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Mes passe-temps pr&eacute;f&eacute;r&eacute;s sont: les promenades avec mes   amis, le musique, &nbsp;l'ordinateur et   j'adore les voyages avec mes amis.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;attends impatiemment vos pr&eacute;sentations.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">A +,</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Cristian</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Bonjour!</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je m&rsquo;appelle Cyntia et j&rsquo;ai 17 ans.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J'&eacute;tudie au coll&egrave;ge &laquo; Radu Negru &raquo; (on   peut le voir dans la photo) de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;"> (Roumanie). Je suis   une jeune fille sociable.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le lyc&eacute;e est situ&eacute; au centre de la   ville, qui a 40.000 habitants. Je suis en XI-&egrave;me E (&ccedil;a</span></div>\\012<div><span style="color: windowtext; text-transform: none;">doit &ecirc;tre la premi&egrave;re d'un lyc&eacute;e   fran&ccedil;ais) <img height="118" width="157" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image058.gif" v:shapes="_x0000_i1055" /></span></div>\\012<div><span style="color: windowtext; text-transform: none;">Notre petite ville paisible est situ&eacute;e   au centre de la Roumanie, en Transylvanie, pr&egrave;s des montagnes de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;">. C'est tr&egrave;s beau.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis entr&eacute;e dans ce projet parce que   j&rsquo;aime le fran&ccedil;ais, j&rsquo;aime le cin&eacute;ma et je</span></div>\\012<div><span style="color: windowtext; text-transform: none;">serai bien heureuse si, au mois de   juin, on se voit &agrave; Paris.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Mes passe-temps pr&eacute;f&eacute;r&eacute;s sont le piano,   la lecture, les promenades avec mes amis.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;attends impatiemment vos   pr&eacute;sentations.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Au plaisir de vous lire,</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Cynthia</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="143" width="193" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image060.gif" v:shapes="_x0000_i1056" />&nbsp;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les montagnes de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;">. Cha&icirc;ne des Carpates.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut les copains!</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis Ioana, j&rsquo;ai 17 ans et je suis   &eacute;l&egrave;ve en XI&egrave;me au Coll&egrave;ge National Radu&nbsp;Negru.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;ai beaucoup de hobbies. Par exemple,   j&rsquo;aime danser et &eacute;couter de la musique.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis dans une &eacute;quipe de danses   populaires roumaines.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Eh bon! C&rsquo;est tout!</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Amiti&eacute;s,</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ioana</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Bonjour</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je m&rsquo;appelle Laurentiu .</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;ai 17 ans.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis en XI&egrave;me B &ndash;en France, &ccedil;a doit &ecirc;tre la premi&egrave;re,   du Coll&egrave;ge National Radu Negru. C'est un des meilleurs lyc&eacute;es de notre   d&eacute;partement.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Notre petite ville calme est situ&eacute;e au centre de la Roumanie,   en Transylvanie, pr&egrave;s des montagnes portant le m&ecirc;me nom: F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;">.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ce projet me pla&icirc;t parce que j&rsquo;aime le fran&ccedil;ais et le   cin&eacute;ma. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Mes passe-temps pr&eacute;f&eacute;r&eacute;s sont le football, la danse,   l'ordinateur.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je voudrais bien qu'on se voie au mois de juin &agrave; Paris.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;attends impatiemment vos pr&eacute;sentations.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Au plaisir de vous lire,</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Laurentiu</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Bonjour</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je m&rsquo;appelle Laurentiu Ionut. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;ai 17 ans.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis en XI&egrave;me E du Coll&egrave;ge National Radu Negru de la   ville de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;">. En Roumanie, on nomme coll&egrave;ge national les meilleurs   lyc&eacute;es.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Notre petite ville tranquille est situ&eacute;e au centre de la   Roumanie, en Transylvanie, pr&egrave;s des montagnes portant le m&ecirc;me nom.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis entr&eacute; dans ce projet parce que j&rsquo;aime le   fran&ccedil;ais, j&rsquo;aime le cin&eacute;ma.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je serais tr&egrave;s heureux si, au mois de juin, on se voyait   &agrave; Paris.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Mes passe-temps pr&eacute;f&eacute;r&eacute;s sont le football, l&rsquo;ordinateur,   la musique, les promenades avec mes amis.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">A l&rsquo;attente de vos pr&eacute;sentations,</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ionut</span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><a href="http://upload.wikimedia.org/wikipedia/commons/b/b4/Fagaras_IMG_5668.jpg"><span style="text-decoration: none;"><img height="139" width="185" border="0" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image062.jpg" alt="Fichier:Fagaras IMG 5668.jpg" v:shapes="_x0000_i1057" /></span></a></div>\\012<div><span style="color: windowtext; text-transform: none;">Le Ch&acirc;teau-fort de </span><span style="color: windowtext; text-transform: none;">F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Le ch&acirc;teau-fort de   F</span><span style="color: blue; text-transform: none;">\\304\\203</span><span style="color: blue; text-transform: none;">g</span><span style="color: blue; text-transform: none;">\\304\\203</span><span style="color: blue; text-transform: none;">ra</span><span style="color: blue; text-transform: none;">\\305\\237</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Le ch&acirc;teau-fort de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;(en roumain : Cetatea F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;">) est un   ch&acirc;teau fort situ&eacute; en plein centre ville de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;">. La construction   du ch&acirc;teau a d&eacute;but&eacute; en 1310,</span></div>\\012<div><span style="color: windowtext; text-transform: none;">sur le site   d'une ancienne fortification de terre et de bois du XII si&egrave;cle. Son but &eacute;tait   &eacute;minemment</span></div>\\012<div><span style="color: windowtext; text-transform: none;">strat&eacute;gique,   &agrave; savoir d&eacute;fendre le sud-est de la</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Transylvanie   contre les incursions des Tatars et des Ottomans. Actuellement le ch&acirc;teau   h&eacute;berge le mus&eacute;e du pays de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;"> avec des   sections sur l'histoire de la ville et du pays de F</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">g</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">ra</span><span style="color: windowtext; text-transform: none;">\\305\\237</span><span style="color: windowtext; text-transform: none;"> ainsi que la   biblioth&egrave;que municipale.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ioana</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<p></p>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;"><a name="binome12"></a>Coll&egrave;ge Darius Milhaud, Sartrouville   (France)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">3<sup>&egrave;me</sup>1 - </span><span style="color: windowtext; text-transform: none;">Anne-Catherine Mourgue</span><span style="color: windowtext; text-transform: none;">, professeur de lettres classiques / Aur&eacute;lie Pieterwas professeur de   lettres classiques / Philippe Roca et Julien Charlier, professeurs de   technologie / Christelle Musset, professeur d'anglais / Christophe Sayol,   professeur d'anglais / Nicolas Henry professeur de SVT</span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;"><a href="http://www.clg-milhaud-sartrouville.ac-versailles.fr/">http://www.clg-milhaud-sartrouville.ac-versailles.fr/</a></span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="background: lime none repeat scroll 0% 0%; color: windowtext; text-transform: none; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">Clic</span><span style="color: blue; text-transform: none;"> pr&eacute;sentation   par Anne Catherine    Mourgue</span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">14_Darius_Milhaud</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">&nbsp;</span><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Ma ville vue par&hellip; la m&egrave;re et sa fille&nbsp;&raquo;, dur&eacute;e 5&rsquo;40&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Les alentours   du coll&egrave;ge &agrave; travers deux points de vue&nbsp;: le regard du b&eacute;b&eacute; et celui de   sa m&egrave;re.</span></div>\\012<div>&nbsp;</div>\\012<div><img height="147" width="197" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image064.jpg" v:shapes="_x0000_i1058" /></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: blue;">Texte</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;Nous avons &eacute;crit une trame de sc&eacute;nario : Ma ville   vue par... des personnes d'&acirc;ges diff&eacute;rents.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les deux angles de vues du film seront le regard d'un   b&eacute;b&eacute;/jeune enfant et de sa m&egrave;re.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Point de vue de l'enfant : Vision en contre-plong&eacute;e   et/ou depuis une poussette. Les choses sont vues d'en bas, on est au ras du   sol, on voit tout un tas d'aspect de la ville dont les plus grands n'ont pas   forc&eacute;ment conscience, ou qu'ils per&ccedil;oivent diff&eacute;remment : pots d'&eacute;chappements,   voitures qui passent tr&egrave;s pr&egrave;s de la poussette et qui sont effrayantes,   crottes de chiens, plaques d'&eacute;gouts, jambes des passants, chiens agressifs   juste au m&ecirc;me niveau (qui se jettent contre le grillage ou aboient en   montrant les dents au passage de la poussette), secousses du trajet en   poussette, descente du toboggan (chute en avant vers le vide), personnes qui   se penchent sur la poussette pour embrasser l'enfant ou le toucher (gros plan   d'une personne qui se penche vers la cam&eacute;ra) etc.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Par moments, flashes de lumi&egrave;re vive (rayons de soleil   selon la direction dans laquelle on roule) ou passages plus sombres.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La musique utilis&eacute;e devra &ecirc;tre angoissante, en   ad&eacute;quation avec les impressions de l'enfant. Les bruits (aboiements, etc.)   agressifs et tr&egrave;s forts par rapport &agrave; la musique.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Point de vue de la m&egrave;re : Vision positive de la balade,   atmosph&egrave;re d&eacute;tendue, gens vus d'en haut, souriants, les conducteurs des   v&eacute;hicules crois&eacute;s s'arr&ecirc;tent pour laisser passer la poussette, passants/connaissances   qui s'adressent &agrave; la cam&eacute;ra et lui sourient en restant &agrave; une distance   respectueuse et &agrave; la m&ecirc;me hauteur, parc aux couleurs gaies et agr&eacute;ables de   taille normale, etc.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La musique est plut&ocirc;t gaie, enjou&eacute;e et en tout les cas   agr&eacute;able pour faire un vrai contraste avec l'autre point de vue.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La raison des deux diff&eacute;rents points de vue ne devra pas   &ecirc;tre trop explicite d&egrave;s le d&eacute;but, ce serait bien de pouvoir intriguer et de   ne r&eacute;v&eacute;ler la cl&eacute; qu'&agrave; la fin, &agrave; l'aide d'une chute (m&egrave;re qui se penche sur   la cam&eacute;ra et dit quelque chose concernant la balade)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Lieux : rues voisines du coll&egrave;ge par exemple, parc pr&egrave;s   du coll&egrave;ge (en allant vers l'espace G&eacute;rard Philippe) ou parc du dispensaire&hellip;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Nous (le prof de techno) avons cr&eacute;&eacute; un logiciel pour   r&eacute;diger les sc&eacute;narios et allons commencer &agrave; monter le 31 mars sur un salon o&ugrave;   nous nos &eacute;l&egrave;ves pr&eacute;sentent les logiciels libres&nbsp;: </span><span style="color: blue; text-transform: none;"><a href="http://www.intertice.fr/">http://www.intertice.fr/</a>.</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: windowtext; text-transform: none;">Liceo   classico M. Gioia, Piacenza (Italie)</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">2<sup>&egrave;me</sup>B classique - Maria Augusta Schippisi,   professeur de langages non verbaux</span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;"><a href="http://www.liceogioia.it/">http://www.liceogioia.it/</a></span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">15_LiceoM.GioiaPiacenza</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;I Ragazzi con la machina da presa&nbsp;&ndash; Odessa adesso&nbsp;&raquo;,   dur&eacute;e 11&rsquo;49&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Fascin&eacute;s par <i>L&rsquo;Homme &agrave; la cam&eacute;ra<span style="font-style: normal;"> de Dziga</span><span style="font-style: normal;">   Vertov, les &eacute;l&egrave;ves ont construit leur film sur le mod&egrave;le du film.</span></i></span></div>\\012<div>&nbsp;</div>\\012<div><img height="149" width="197" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image066.jpg" v:shapes="_x0000_i1059" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par les enseignants</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Piacenza, 26 juin 2008</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Projet europ&eacute;en <i>La    mia citt&agrave; vista</i><i>   da&hellip;</i></span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Cadre :</span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Langages non verbaux et multim&eacute;dia (la communication    cin&eacute;matographique) et Informatique</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Autre disciplines&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Italien</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull; Langue   &eacute;trang&egrave;re</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Destinataires&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Les   &eacute;tudiants de deux classes de seconde jumel&eacute;s avec deux classes d&rsquo;un lyc&eacute;e   fran&ccedil;ais (m&ecirc;me type d&rsquo;&eacute;tudes et m&ecirc;me &acirc;ge)</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Enseignants&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Langages&nbsp;:   Paola Gozzi   et Maria    Augusta Schippisi</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Informatique&nbsp;:   Paolo Vermi</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Instruments&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><i><span style="color: windowtext; text-transform: none;">Lignes de temps</span></i></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Formation des enseignants&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Une   journ&eacute;e de pr&eacute;paration avec l&rsquo;expert de l&rsquo;Iri.</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Objectifs&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Approfondir les comp&eacute;tences d&rsquo;analyse du texte filmique.</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   R&eacute;aliser un court-m&eacute;trage inspir&eacute; par la structure narrative ou   formelle des films analys&eacute;s.</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull; Donner   l&rsquo;occasion d&rsquo;un &eacute;change culturel entre des &eacute;tudiants de l&rsquo;Union europ&eacute;enne.</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Plan des activit&eacute;s&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">1er p&eacute;riode de l&rsquo;ann&eacute;e scolaire   (septembre-d&eacute;cembre)</span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">Activit&eacute;s pr&eacute;liminaires&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Exploration guid&eacute;e du logiciel (&eacute;tudiants et expert de l&rsquo;Iri).</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Analyse de textes litt&eacute;raires sur le th&egrave;me de la ville (enseignants d&rsquo;Italien   et de Langue &eacute;trang&egrave;re, pendant les horaires de cours).</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull; D&eacute;but   de la    d&eacute;codification du langage cin&eacute;matographique (avec les   enseignants de Langages, pendant les horaires de cours).</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Pr&eacute;-production d&rsquo;un court-m&eacute;trage sur le th&egrave;me de la ville&nbsp;: &eacute;criture du   sc&eacute;nario (20h- selon les disponibilit&eacute;s des enseignants- avec un expert   externe nomin&eacute; par le lyc&eacute;e).</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">2e p&eacute;riode de l&rsquo;ann&eacute;e scolaire   (janvier-mai)</span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Les   m&ecirc;mes &eacute;tapes seront suivies par les &eacute;tudiants des classes partenaires en   France. </span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">1&egrave;re &eacute;tape&nbsp;(janvier 2009- pendant   les cours de Langages et Informatique)&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull; Avec   le logiciel <i>Lignes de temps</i>,   analyse d&rsquo;un film sur la    ville &agrave; choisir entre un long-m&eacute;trage, un documentaire ou   un film exp&eacute;rimental (propos&eacute;s par l&rsquo;Iri).</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">2e &eacute;tape&nbsp;(janvier/f&eacute;vrier -   pendant les cours de Langages et Informatique)&nbsp;:</span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   &eacute;change de points de vue sur les films analys&eacute;s avec la classe partenaire.</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">3e &eacute;tape&nbsp;(f&eacute;vrier/mars- selon les   disponibilit&eacute;s du conseil de classe - 30h)&nbsp;:</span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull;   Production du court-m&eacute;trage&nbsp;: r&eacute;alisation du court-m&eacute;trage sur le mod&egrave;le   du film analys&eacute; (intervention d&rsquo;un expert nomin&eacute; par le lyc&eacute;e).</span></div>\\012<div style="margin-bottom: 0.0001pt;"><b><span style="color: windowtext; text-transform: none;">4e &eacute;tape&nbsp;(avril/mai pendant les cours   de Langages et Informatique)&nbsp;: </span></b></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&bull; Les   classes partenaires s&rsquo;&eacute;changent les courts-m&eacute;trages r&eacute;alis&eacute;s, ils les   analysent et s&rsquo;&eacute;changent leurs points de vue.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par les enseignants</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Piacenza, mai 2009</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;</span><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;Les   &eacute;l&egrave;ves ont analys&eacute; plusieurs films   sur la ville et ont &eacute;t&eacute; fascin&eacute;s par <i>L&rsquo;homme   &agrave; la cam&eacute;ra</i> de Dziga Vertov, film dans lequel on voit des images de   Moscou mais aussi les p&eacute;rip&eacute;ties de l&rsquo;op&eacute;rateur qui cherche ses images dans   la ville, ainsi que les spectateurs qui assistent, dans une salle de cin&eacute;ma,   &agrave; la projection    du film que la cam&eacute;ra a captur&eacute; pour eux.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">En r&eacute;fl&eacute;chissant &agrave; la mani&egrave;re de repr&eacute;senter   Piacenza, ils ont voulu se r&eacute;f&eacute;rer &agrave; ce mod&egrave;le qu&rsquo;ils consid&egrave;rent encore   d&rsquo;actualit&eacute;. Ils n&rsquo;ont donc pas suivi de sc&eacute;nario, et se sont montr&eacute;s dans   l&rsquo;acte de tourner. Leur cam&eacute;ra a essay&eacute; de saisir le rythme de la vie quotidienne.&nbsp;Le montage a eu un r&ocirc;le capital : la   comparaison entre les plans de la ville sovi&eacute;tique et   ceux de Piacenza montre que les villes, bien que distantes dans l&rsquo;espace et   dans le temps, se ressemblent un peu, lorsqu&rsquo;elles parlent de la vie de tout   les jours lorsque la    ville est vide parce qu&rsquo;elle dort ; lorsqu&rsquo;elle s&rsquo;anime et   se remplit, lorsqu&rsquo;elle travaille; mais, puisque le tournage s&rsquo;est fait le   jour o&ugrave; le pont sur le P&ocirc; s&rsquo;est &eacute;croul&eacute;, ils ont pu filmer aussi cet   &eacute;v&eacute;nement exceptionnel.<br />\\012            Le montage a eu un r&ocirc;le capital : la comparaison continue    entre les plans de la ville sovi&eacute;tique et   celles de Piacenza nous montrent que toutes les villes, bien que distantes   dans l&rsquo;espace et dans le temps, se ressemblent un peu, lorsqu&rsquo;elles parlent   de la vie.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome13"></a>Coll&egrave;ge Darius Milhaud, Sartrouville   (France)</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">3</span><sup><span style="color: rgb(51, 51, 51); text-transform: none;">&egrave;me</span></sup><span style="color: rgb(51, 51, 51); text-transform: none;">4</span>&nbsp;<span style="color: rgb(51, 51, 51); text-transform: none;">- </span><span style="color: rgb(51, 51, 51); text-transform: none;">Anne-Catherine Mourgue</span><span style="color: rgb(51, 51, 51); text-transform: none;">,   professeur de lettres classiques / Aur&eacute;lie Pieterwas professeur de lettres   classiques / Philippe Roca et Julien Charlier, professeurs de technologie /   Christelle Musset, professeur d'anglais / Christophe Sayol, professeur   d'anglais / Nicolas Henry professeur de SVT</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">NN&nbsp;: Le Coll&egrave;ge Darius Milhaud et le Colegiul   National Mihai Eminescu ayant plusieurs classes en bin&ocirc;me ont produit des   films communs. Voir ci-dessus.</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">Colegiul   national Mihai Eminescu, Iasi</span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">(Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">3&egrave;me,</span><span style="font-size: 10pt; color: rgb(51, 51, 51);"> Sorina Danaila,   professeur de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div>&nbsp;</div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<p><span style="font-size: 10pt; color: rgb(51, 51, 51);"><br clear="all" /><br />\\012</span></p>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome14"></a>Lyc&eacute;e Paul Val&eacute;ry, Paris 12<sup>&egrave;me</sup></span><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;">(France)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">1&egrave;re ES1 et 1er S2- et &eacute;tudiants du Lyc&eacute;e Charlemagne, option   facultative cin&eacute;ma - Philippe    Zill, professeur de cin&eacute;ma</span></div>\\012<div>&nbsp;</div>\\012<div><u><span style="color: blue; text-transform: none;"><a href="http://lyc-paul-valery.scola.ac-paris.fr/PVpages/PCSI/index_pcsi.html">http://lyc-paul-valery.scola.ac-paris.fr/PVpages/PCSI/index_pcsi.html</a></span></u></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">18_Charlemagne(1)</span></div>\\012<div><b><span style="font-size: 10pt; color: red;">&nbsp;</span></b><span style="font-size: 10pt; color: rgb(51, 51, 51);">&laquo;&nbsp;</span><span style="font-size: 10pt; color: blue;">Le Prince malheureux&nbsp;&raquo; dur&eacute;e 5&rsquo;26&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Sylvain, 20 ans se pr&eacute;sente confiant &agrave; une audition pour   l&rsquo;adaptation am&eacute;ricaine de <i>B&eacute;r&eacute;nice</i>,   dans le Marais.</span></div>\\012<div><b><span style="font-size: 10pt; color: red;">Attention Thibaut, le film ne commence   qu&rsquo;apr&egrave;s un grand noir, &agrave; 0&rsquo;38&rsquo;&rsquo;</span></b></div>\\012<div><b>&nbsp;</b></div>\\012<div><img height="135" width="180" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image068.jpg" v:shapes="_x0000_i1060" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: rgb(51, 51, 51); text-transform: none;">&nbsp;</span><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;Avant   de partir, sa copine ne l&rsquo;encourage qu&rsquo;&agrave; demi-mot. Pourtant, l&rsquo;enjeu est   important. Il &eacute;choue. A la    sortie de l&rsquo;audition, pris de d&eacute;sespoir il suit la directrice de casting   dans les rues du Marais, en vue d&rsquo;une seconde chance. R&eacute;alisant son&nbsp;   erreur, il reprend ses esprits et se r&eacute;concilie avec sa copine.&nbsp;&raquo; Laure   Massiet</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext;">&nbsp;</span></div>\\012<div>&nbsp;</div>\\012</td>\\012<td width="307" valign="top" style="border-style: solid solid solid none; border-color: windowtext windowtext windowtext -moz-use-text-color; border-width: 1pt 1pt 1pt medium; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51);">Colegiul B. P. Hasdeu, Buz</span><span style="font-size: 14pt; color: rgb(51, 51, 51);">\\304\\203</span><span style="font-size: 14pt; color: rgb(51, 51, 51);">u</span><span style="font-size: 14pt; color: rgb(51, 51, 51);"> (Roumanie)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">3&egrave;me - Ioana    Voinea&nbsp;/ Dan    Solcan, professeurs de fran&ccedil;ais langue &eacute;trang&egrave;re</span></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);"><a href="http://bph.uv.ro/index.php?vidcateg=16">http://bph.uv.ro/index.php?vidcateg=16</a></span></div>\\012<div>&nbsp;</div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">19_Buz</span><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">\\304\\203</span><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">u</span></div>\\012<div><span style="font-size: 10pt; color: blue;">&laquo;&nbsp;Salut   Paris&nbsp;&raquo;, dur&eacute;e 24&rsquo;&rsquo; /&nbsp;&laquo;&nbsp;Ma   ville vue par&hellip; Buz</span><span style="font-size: 10pt; color: blue;">\\304\\203</span><span style="font-size: 10pt; color: blue;">u</span><span style="font-size: 10pt; color: blue;">&nbsp;&raquo;, dur&eacute;e   13&rsquo;08&rsquo;&rsquo;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">L&rsquo;id&eacute;e g&eacute;n&eacute;rale du film, c'est   la ville, les rues, les parcs, des aspects de la vie des gens, des   animaux et des b&acirc;timents anciens, notre lyc&eacute;e et nos &eacute;l&egrave;ves.</span></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><img height="140" width="186" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image070.jpg" v:shapes="_x0000_i1061" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Pr&eacute;sentation par les enseignants</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;&laquo;&nbsp;Nous avons&nbsp;travaill&eacute; sur des s&eacute;quences&nbsp;:</span></div>\\012<div><span style="color: windowtext; text-transform: none;">1.&nbsp;tout d'abord notre lyc&eacute;e   avec l'entr&eacute;e.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">2. la gare, des images du parc   du lyc&eacute;e avec des &eacute;l&egrave;ves qui bougent.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">3. l</span><span style="color: windowtext; text-transform: none;">'&eacute;glise pr&egrave;s du lyc&eacute;e,&nbsp;le cours de religion ayant   comme fond sonore la    pri&egrave;re que les &eacute;l&egrave;ves disent au commencement, des images de   l'&eacute;glise avec des enfants qui embrassent les ic&ocirc;nes, une autre &eacute;glise datant   de l'ann&eacute;e 1922 et qui se trouve dans le Bocage, parc classique de la&nbsp;   ville.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">4. la biblioth&egrave;que du lyc&eacute;e.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">5. une s&eacute;quence d'un montage de   Guignol, inspir&eacute; d'un conte roumain. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">6. la r&eacute;p&eacute;tition d'une troupe   rock, dont la soliste est une de nos &eacute;l&egrave;ves de terminale ; les halls vides et   anim&eacute;s d'&eacute;l&egrave;ves&nbsp;pendant&nbsp;&nbsp;les r&eacute;cr&eacute;ations. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">7. le vieux b&acirc;timent d&rsquo;un   h&ocirc;pital un peu d&eacute;labr&eacute;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">8. des &eacute;l&egrave;ves qui sont entr&eacute;s   dans le livre des records, ils ont nou&eacute; le plus long fil.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">9. la vieille ville avec   la rue    commer&ccedil;ante la plus passanteC<em><span style="font-weight: normal;">uZa   Voda.</span></em></span></div>\\012<div><span style="color: windowtext; text-transform: none;">10. les &eacute;l&egrave;ves qui fl&acirc;nent sur   le boulevard et dans le Bocage.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">11. la ville pendant la   nuit avec le Palais Communal.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">12. retour au lyc&eacute;e avec le   portrait du patron, l'&eacute;crivain BP Hasdeu, les bustes de deux grandes   personnalit&eacute;s, anciens &eacute;l&egrave;ves, les halls , les fleurs tr&egrave;s ch&egrave;res &agrave; notre   directeur.&nbsp;&raquo; Ioana    Voinea</span></div>\\012<div>&nbsp;</div>\\012<div><span style="font-size: 10pt; color: blue;">Texte</span></div>\\012<div><span style="color: blue; text-transform: none;">Quelques courriers des &eacute;l&egrave;ves roumains &agrave; leurs correspondants   fran&ccedil;ais</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Quelques   courriers des &eacute;l&egrave;ves roumains &agrave; leurs correspondants fran&ccedil;ais</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je m&rsquo;appelle   Patricia</span><span style="color: windowtext; text-transform: none;"> et je suis lyc&eacute;enne au college B. P. Hasdeu&nbsp;.Je suis n&eacute;e en novembre 1992 et j&rsquo;ai 16   ans. A l&rsquo;&eacute;cole je suis dans une classe ou nous &eacute;tudions les math&eacute;matiques,   informatique, chimie, biologie, physiques plus que les autres copains. Je   connais l`anglais tr&egrave;s bien et le fran&ccedil;ais de niveau moyen.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;aime communiquer avec d&rsquo;autres gens et me faire   beaucoup d&rsquo;amies. J`aime aussi lire tandis que ma classe est faite pour ceux   qui aiment les sciences. Mon r&ecirc;ve est de&nbsp;devenir un bon m&eacute;decin parce que je crois qu&rsquo;aider les hommes quand   ils sont malades est un des plus beaux m&eacute;tiers. Si on parle &laquo;&nbsp;&eacute;ducation   physique&nbsp;&raquo; je peux dire que j`aime le basket-ball et la danse sportive.   J&rsquo;aime aussi les promenades avec mes amis et&nbsp;mes copains.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les animaux&hellip; je les aime. J&rsquo;ai deux chiens qui s&rsquo;appellent   Fred et Lady et une petite chatte c&acirc;line qui s&rsquo;appelle Zuzu.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Quand j&rsquo;ai du temps j&rsquo;aime naviguer sur l&rsquo;internet et   &eacute;couter de la musique. J&rsquo;&eacute;coute   beaucoup de bandes qui chantent de la musique rock comme   Iron Maiden, AC/DC, Queen, Metallica et autres.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;esp&egrave;re que dans ce projet nous aurons la chance   d&rsquo;apprendre des choses fascinantes sur votre pays et faire beaucoup d`amis. C&rsquo;est   magnifique comme nous pouvons connaitre un autre homme avec des images et des   films.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut   ! Je suis Diana</span><span style="color: windowtext; text-transform: none;"> et j'ai 16 ans et 8 mois. J'aime bien la chimie et les   autres sciences. Dans mon temps libre j&rsquo;aime lire des livres divers, les   promenades et &nbsp;voir des films, surtout   en fin de semaine. Je suis une personne qui s'int&eacute;resse aux probl&egrave;mes de   l'humanit&eacute;, de la&nbsp;nature et des animaux et   je voudrais faire quelque chose pour les aider. Mon r&ecirc;ve est de devenir   m&eacute;decin ou travailler dans un domaine militaire, mais je ne suis s&ucirc;re pour le   moment.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut,   je m'appelle Ana-Maria.</span><span style="color: windowtext; text-transform: none;"> J'ai 16 ans, j'adore dessiner, lire,   chanter n'importe o&ugrave;, sortir avec mes amis, voyager et surfer sur le net.   Depuis que j'ai ma palette graphique, je dessine presque sans arr&ecirc;t sur mon   ordinateur.<br />\\012            En ce qui concerne mon caract&egrave;re : ...t&ecirc;te dans les nuages plut&ocirc;t qu&rsquo;avoir   les pieds sur terre, timide &agrave; certains moments et compl&egrave;tement d&eacute;jant&eacute;e &agrave;   d&rsquo;autres, ouverte d&rsquo;esprit plut&ocirc;t que ferm&eacute;e aux grandes th&eacute;ories, pas tr&egrave;s   expansive mais pas non plus introvertie, bavarde quand l&rsquo;envie m&rsquo;en prend   mais plut&ocirc;t discr&egrave;te quand il s&rsquo;agit de d&eacute;battre&hellip; et un brin cynique (qu&rsquo;est   ce que les gens peuvent me d&eacute;tester pour &ccedil;a <img height="15" width="15" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image071.gif" v:shapes="_x0000_i1062" />)   </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Je m&rsquo;appelle   Denisa</span><span style="color: windowtext; text-transform: none;">. Je suis n&eacute;e en 1992 donc j&rsquo;ai dix-sept ans.   J&rsquo;habite&nbsp;Buz</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">u</span><span style="color: windowtext; text-transform: none;">, une ville de Roumanie.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis lyc&eacute;enne en seconde classe. Mes objets d&rsquo;&eacute;tude   pr&eacute;f&eacute;r&eacute;s sont : les langues &eacute;trang&egrave;res (l&rsquo;anglais et le fran&ccedil;ais), la chimie,   et les maths. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Quand j&rsquo;ai beaucoup de temps libre j&rsquo;aime rencontrer mes   amis. Chaque fois, nous essayons de faire n&rsquo;importe quoi pour nous divertir.   Nous allons au disco, voyons des films, d`habitude des com&eacute;dies, ou nous nous   promenons dans le parc.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Quand je suis seule j&rsquo;adore &eacute;couter de la musique,   danser et pourquoi pas lire un bon livre. De m&ecirc;me j&rsquo;aime jouer avec les   animaux. J`adore les chats mais, comme je n&rsquo;en ai pas, je joue avec le chat   de ma meilleure amie.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis tr&egrave;s heureuse de&nbsp;prendre part a ce projet. J&rsquo;esp&egrave;re que nous deviendrons bons amis.<br clear="all" /><br />\\012            </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Salut !   Je m&rsquo;appelle Corina</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai 16 ans et demi.&nbsp;J&rsquo;habite avec mes parents et je suis fille unique. Moi, je voudrais   devenir un bon psychologue parce que j&rsquo;aime comprendre et expliquer la vie spirituelle de   quelqu'un. En ce qui concerne mes passions j&rsquo;aime voir des films quand j&rsquo;ai   du temps et jouer au volley-ball. </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Je   m&rsquo;appelle Corina</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai 16 ans. Je suis &eacute;l&egrave;ve en seconde au lyc&eacute;e   &ldquo;Bogdan Petriceicu Hasdeu&rdquo; de Buz</span><span style="">\\304\\203</span><span style="color: windowtext; text-transform: none;">u, Roumanie. Je suis toujours calme et   optimiste. Me balader, faire des excursions, passer le temps avec mes amis ou   avec ma famille, toutes ces choses me plaisent beaucoup. J&rsquo;aime aussi lire,   &eacute;couter de la musique, danser&hellip; </span></div>\\012<div><span style="color: windowtext; text-transform: none;">C&rsquo;est parce que je trouve les math&eacute;matiques tr&egrave;s   int&eacute;ressantes que j&rsquo;ai choisi d&rsquo;&ecirc;tre &eacute;l&egrave;ve dans cette classe au profil   math&eacute;matiques-informatiques, mais ce qui me pla&icirc;t le plus &agrave; l&rsquo;&eacute;cole c&rsquo;est la chimie. M&ecirc;me si   je sais que j&rsquo;ai encore beaucoup de choses &agrave; apprendre, je crois que la chimie est r&eacute;ellement   fascinante.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis une fille ambitieuse et je suis s&ucirc;re que mon   r&ecirc;ve d&rsquo;&ecirc;tre m&eacute;decin deviendra r&eacute;alit&eacute; un jour. Et, qui sait ? Peut-&ecirc;tre   j&rsquo;aurai m&ecirc;me l&rsquo;occasion d&rsquo;&eacute;tudier en France.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut mes   amis! Je suis Diana</span><span style="color: windowtext; text-transform: none;"> et j'ai 16   ans. J'habite Buz</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">u</span><span style="color: windowtext; text-transform: none;"> avec ma famille : mes parents, ma s&oelig;ur et mon grand-p&egrave;re. Comme tous   les jeunes j'aime &eacute;couter de la musique mais ce que j'aime le plus est   collectionner des monnaies. En ce qui concerne l'&eacute;cole, mes objets pr&eacute;f&eacute;r&eacute;s   sont l'anglais, la psychologie, la biologie&nbsp;mais aussi le fran&ccedil;ais.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Je   m&rsquo;appelle Maria. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;ai 16 ans.J&rsquo;habite en Buz</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">u</span><span style="color: windowtext; text-transform: none;"> et je suis &eacute;tudiante au </span><em><span style="color: windowtext; text-transform: none; font-weight: normal;">Coll&egrave;ge   National Bogdan Petriceicu Hasdeu.</span></em></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;aime la musique. Mes groupes pr&eacute;f&eacute;r&eacute;es sont Pink Floyd   et Nirvana. J&rsquo;aime aussi la    peinture et la photographie. Mes artists pr&eacute;f&eacute;r&eacute;es sont   Ren&eacute;e Magritte et Salvador Dali. J&rsquo;aime aussi &eacute;couter du th&eacute;&acirc;tre   radiophonique ou lire.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&Agrave; l&rsquo;&eacute;cole j&rsquo;aime beaucoup la chimie et je   voudrais devenir chimiste ou m&eacute;decin.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut !   Je m&rsquo;appelle Monica</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai seize ans. J&rsquo;&eacute;tudie au Coll&egrave;ge B.P.Hasdeu en   seconde. Je suis une fille sociable et&nbsp;toujours joyeuse. J&rsquo;adore la France et surtout le fran&ccedil;ais. J&rsquo;ai eu la   possibilit&eacute; d&rsquo;aller en France et j&rsquo;&eacute;tais vraiment impressionn&eacute;e.   J&rsquo;aimerais&nbsp;retourner dans la ville lumi&egrave;re   un jour.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le projet qu&rsquo;on avait commenc&eacute;&nbsp;ensemble m&rsquo;a donne la possibilit&eacute;   d&rsquo;apprendre beaucoup de nouvelles&nbsp;choses&nbsp;mais aussi que le   travail en &eacute;quipe c&rsquo;est tr&egrave;s important. J&rsquo;aime aussi la photographie et&nbsp;maintenant&nbsp;avec l&rsquo;aide de ce projet je peux combiner la photographie avec le   fran&ccedil;ais.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Mon&nbsp;r&ecirc;ve est de   faire le tour du monde apr&egrave;s que je finirai la Facult&eacute; de M&eacute;dicine. M&ecirc;me si   j&rsquo;aime beaucoup voyager je ne partirai jamais&nbsp;d&eacute;finitivement&nbsp;de&nbsp;Roumanie. J&rsquo;aime beaucoup mon pays&nbsp;et&nbsp;sa culture.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Chers amis, Je m&rsquo;appelle Andreea</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai   16 ans. Je suis une fille tr&egrave;s sociable ; j&rsquo;ai beaucoup d&rsquo;amis, mais mes   meilleures amies sont deux filles. J&rsquo;aime rencontrer mes amis et aussi   j&rsquo;adore quand nous sommes ensemble et nous faisons tout ce que les jeunes de   notre &acirc;ge font : aller dans le&nbsp;parc,   jouer sur l&rsquo;ordinateur, s&rsquo;amuser, lire un bon livre; mais la plus importante chose   et que nous nous &eacute;coutons entre nous et&nbsp;nous apprenons que l&rsquo;amiti&eacute; c&rsquo;est tr&egrave;s importante dans la vie des jeunes.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Apr&egrave;s le bac, je ne sais tr&egrave;s bien quel   m&eacute;tier je choisirai, mais je crois que je deviendrai &eacute;conomiste, avocate ou   professeur.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut&nbsp;!   Je m&rsquo;appelle Bianca,</span><span style="color: windowtext; text-transform: none;"> j&rsquo;ai&nbsp;16 ans et   j&rsquo;habite Buz</span><span style="">\\304\\203</span><span style="color: windowtext; text-transform: none;">u, Roumanie. J&rsquo;ai une s&oelig;ur, qui a 8 ans, mais avec   laquelle je ne m&rsquo;entends pas si bien. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">A l&rsquo;&eacute;cole j&rsquo;aime les langues (l&rsquo;anglais, le fran&ccedil;ais et   aussi l&rsquo;allemand), l&rsquo;histoire, la chimie. J&rsquo;adore lire des romans. Je viens de   finir&nbsp;<i>Le ch&acirc;teau</i> de Kafka),   j&rsquo;aime la photographie, voir des films. J&rsquo;&eacute;coute toujours de la musique &ndash; en   lisant, en &eacute;crivant mes devoirs&hellip; tout les temps. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Si c&rsquo;&eacute;tait selon moi, je resterais toujours dans des   caf&eacute;s, je lirais toujours, j&rsquo;irais aux concerts (m&ecirc;me si &agrave; Buz</span><span style="">\\304\\203</span><span style="color: windowtext; text-transform: none;">u il n&rsquo;y   a pas tant), mais il faut aussi penser aux &eacute;tudes, &agrave; l&rsquo;avenir, essayer de   r&eacute;pondre &agrave; cette question qui a commenc&eacute; &agrave; accaparer nos ann&eacute;es de   lyc&eacute;e&nbsp;: Quelle universit&eacute; veux-tu suivre de suite&nbsp;? Moi, j&rsquo;essaye   de rester &agrave; 16 ans, je ne me comporte pas comme un adulte, je fais toute   sorte de b&ecirc;tises &ndash; il reste encore du temps pour penser aux choses plus   s&eacute;rieuses,&nbsp;pour &lsquo;grandir&rsquo;. </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut!   Je m`appelle Claudia</span><span style="color: windowtext; text-transform: none;">, j&rsquo;ai 16 ans et j&rsquo;habite&nbsp;Buz</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">u</span><span style="color: windowtext; text-transform: none;">, une   ville de&nbsp;la Roumanie.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;ai un fr&egrave;re, il &lsquo;appelle Ciprian et il a 20 ans&hellip; donc   je suis la cadette de    ma famille. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">&Agrave; l&rsquo;&eacute;cole j`aime les langues &eacute;trang&egrave;res [l&rsquo;anglais, le   fran&ccedil;ais et l&rsquo;allemand],&nbsp;la biologie,   l`histoire et les arts plastiques.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Comme hobby, j&rsquo;aime &eacute;couter de la musique, mes artistes   pr&eacute;f&eacute;r&eacute;s sont : Metallica, Pink Floyd, Led Zeppelin, Norah Jones, Red Hot   Chili Peppers , Gorillaz, Urma [ils sont roumains]&nbsp;et beaucoup d&rsquo;autres, j`aime jouer du   tennis, j`aime la photographie.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pour l&rsquo;avenir je veux visiter&nbsp;tout le monde [s`il est&nbsp;possible].</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis tr&egrave;s enchant&eacute;e de ce projet et je le veux&nbsp;voir fini. </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut&nbsp;!   Je m&rsquo;appelle Elena</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai 16 ans. Comme tous les ados, j&rsquo;aime beaucoup &eacute;couter de la musique, surfer sur   l&rsquo;internet, jouer au basketball et j&rsquo;adore aussi voyager. Mon r&ecirc;ve est de   visiter tout le monde, sp&eacute;cialement l&rsquo;Extr&ecirc;me-Orient. </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut!   Je m&rsquo;appelle Ioana</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai 16 ans. J&rsquo;habite Buz</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">u</span><span style="color: windowtext; text-transform: none;">, Roumanie et j&rsquo;&eacute;tudie au Coll&egrave;ge National Bogdan   Petriceicu Hasdeu, dans une classe de math&eacute;matiques-informatique bilingue   anglais. &Agrave; la    diff&eacute;rence de la majorit&eacute; de mes camarades de classe, je ne   sais pas encore quel m&eacute;tier j&rsquo;aimerai exercer, mais j&rsquo;ai assez de temps pour   me d&eacute;cider.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pour me d&eacute;crire en quelques mots, je peux dire que,   d&rsquo;habitude, je suis une fille gaie, qui aime rire tout le temps&nbsp;et   passer le temps avec les amis et la famille. Faire    du sport est une chose que j&rsquo;aime beaucoup, c&rsquo;est pour &ccedil;a   que je&nbsp;pratique le volley &agrave; l&rsquo;&eacute;cole.   Ce n&rsquo;est que le volley que j&rsquo;aime, j&rsquo;aime bien aussi le parachutisme,   peut-&ecirc;tre que c&rsquo;est un trait g&eacute;n&eacute;tique h&eacute;rit&eacute; de mes parents, qui ont mille   sauts. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;esp&egrave;re me r&eacute;aliser en tous les plans&hellip; sentimentaux,   professionnels&nbsp;; en attendant, je ferai tout mon possible pour avoir une   belle vie. </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Je suis   Diana Marina (Marina),</span><span style="color: windowtext; text-transform: none;"> j&rsquo;ai 16 ans et je vis en Buz</span><span style="">\\304\\203</span><span style="color: windowtext; text-transform: none;">u, une   ville assez grande de Roumanie. J&rsquo;ai un fr&egrave;re cadet qui s&rsquo;appelle Petru</span><span style="">\\305\\243</span><span style="color: windowtext; text-transform: none;"> Ciprian   (Pierre). Il a 14 ans, mais il se comporte comme s&rsquo;il &eacute;tait mon fr&egrave;re a&icirc;n&eacute; !   Ma m&egrave;re est m&eacute;decin et mon p&egrave;re est homme d&rsquo;affaires. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Mon lyc&eacute;e est&nbsp;Bogdan Petriceicu Hasdeu, le meilleur   coll&egrave;ge de ma ville et un des meilleurs coll&egrave;ges de Roumanie aussi. Je suis en   10&egrave;me (nous avons une structure diff&eacute;rente pour l&rsquo;&eacute;ducation en Roumanie) et   m&ecirc;me si mon profil est math&eacute;matique informatique bilingue anglais (ce qui   signifie sept heures d&rsquo;anglais par semaine et l&rsquo;histoire des &Eacute;tats-Unis   enseign&eacute;e par un am&eacute;ricain) le fran&ccedil;ais me pla&icirc;t beaucoup. J&rsquo;ai visit&eacute; la France cet &eacute;t&eacute;,   plus exactement Paris et la     prestigieuse Vall&eacute;e de la Loire. Je peux   dire que votre pays m&rsquo;a impressionn&eacute; extraordinairement. Pour moi, la cath&eacute;drale Notre-Dame    de Paris est un v&eacute;ritable joyau architectural et culturel autant   qu&rsquo;une source d&rsquo;inspiration artistique.&nbsp;</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&nbsp;Assez d&rsquo;information palpable ! Cela n&rsquo;est   qu&rsquo;une part minuscule de mon existence, puisqu&rsquo; il y a d&rsquo;autres choses qu&rsquo;on   pourrait dire sur moi. Pour commencer, je suis une antith&egrave;se. Vraiment, parce   qu&rsquo;il y a des tendances &agrave; peu pr&egrave;s contradictoires qui influencent mes   pens&eacute;es et mes id&eacute;es, en transformant ma vie en un m&eacute;lange tr&egrave;s bizarre. Mes   hobbies peuvent parler pout moi : j&rsquo;aime la litt&eacute;rature (lire et &eacute;crire), la   musique (je pr&eacute;f&egrave;re la    musique classique &ndash; Mozart, Beethoven, Bach, Strauss,   George Enescu, mais j&rsquo;&eacute;coute d&rsquo;autres sortes de musique &nbsp;aussi), j&rsquo;ai quelques inclinations pour la   peinture, le patinage&hellip; Voyager me rend presque toujours heureuse. Toutefois,   il y a des activit&eacute;s que je peux faire avec plaisir sans &ecirc;tre mes hobbies   (danser, nager, faire des g&acirc;teaux). </span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">J&rsquo;aime   les Math&eacute;matiques et les Sciences (nous &eacute;tudions la Physique, la Chimie et la   Biologie comme des objets distincts &ndash; je sais qu&rsquo;en France celles-ci sont   comprises dans une seule mati&egrave;re, les Sciences). La cin&eacute;matographie me    semble un domaine complexe qui r&eacute;unit plusieurs   manifestations de l&rsquo;art. C&rsquo;est la raison principale pour   laquelle je suis entr&eacute;e dans ce projet de partenariat.</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">J&rsquo;ai   commenc&eacute; &agrave; &eacute;crire quand j&rsquo;avais 8 ans&hellip; des po&eacute;sies et des petites   compositions. &Agrave; 13 ans j&rsquo;ai publi&eacute; le premier &nbsp;volume de mon roman, &quot;Les myst&egrave;res de   l&rsquo;&eacute;cole Shetland&quot; (&quot;Misterele </span><span style="">\\305\\237</span><span style="color: windowtext; text-transform: none;">colii Shetland&quot; &ndash; en roumain), et   l&rsquo;ann&eacute;e derni&egrave;re j&rsquo;ai lanc&eacute; le second volume. Maintenant, j&rsquo;&eacute;cris un nouveau   roman, quoique je n&rsquo;ai pas beaucoup de temps pour faire &ccedil;a (chaque jour, mes   copains et moi restons &agrave; l&rsquo;&eacute;cole sept ou huit heures et nous avons des   devoirs interminables &agrave; la maison!). La litt&eacute;rature est    essentielle&hellip; ma vie serait impossible sans &eacute;crire ou sans   lire. Ne m&rsquo;entendez pas mal ; je me consid&egrave;re une des plus fortun&eacute;es   personnes du monde. J&rsquo;ai le tout ! Une famille merveilleuse qui m&rsquo;adore et   qui me donne ce que je veux. Mais j&rsquo;ai le sentiment &quot;du temps   perdu&quot;, le sentiment que tout va dans une direction imminente,   implacable et douloureuse&hellip; &nbsp;est   l&rsquo;impression &eacute;pouvantable que l&rsquo;univers s&rsquo;&eacute;coule comme le sable d&rsquo;une   clepsydre et je m&rsquo;affaisse simultan&eacute;ment. Quand j&rsquo;&eacute;cris, je m&rsquo;illusionne   seule en croyant que dans cette mani&egrave;re mon empreinte restera sur la terre. Hm&hellip; l&rsquo;&eacute;criture   n&rsquo;est pas pour moi un simple jeu des chim&egrave;res&hellip; c&rsquo;est un <i>modus vivendi, </i>une<i>   ars poetica, </i>l&rsquo;art po&eacute;tique de l&rsquo;existence&hellip;&nbsp;</span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">&nbsp;Mes &eacute;crivains pr&eacute;f&eacute;r&eacute;s sont Dostoievski,   Goethe, Hermann Hesse et Mihai Eminescu (le po&egrave;te g&eacute;nial des roumains qui a &eacute;crit   quelque prose par ailleurs). Notre professeur de fran&ccedil;ais a stimul&eacute; mon   int&eacute;r&ecirc;t vers des lectures fran&ccedil;aises aussi. J&rsquo;ai l&rsquo;opinion que des &eacute;crivains   comme Balzac, Gustave Flaubert, Jules Verne, Victor Hugo, Antoine de Saint   &Eacute;xup&eacute;ry ou Jean-Paul Sartre ont eu un r&ocirc;le tr&egrave;s important dans l&rsquo;histoire   spirituelle de l&rsquo;humanit&eacute;.&nbsp;&nbsp;&nbsp; </span></div>\\012<div style="margin-bottom: 0.0001pt;"><span style="color: windowtext; text-transform: none;">Peut-&ecirc;tre   que je deviendrai un r&eacute;alisateur de films, ou un homme de science, ou une   femme d&rsquo;affaires. Je ne sais pas. Ce dont je suis s&ucirc;re c&rsquo;est seulement que   mon &quot;destin&quot; (je crois que le destin n&rsquo;existe pas mais j&rsquo;utilise ce   mot pour son pouvoir suggestif) est &eacute;ternellement reli&eacute; &agrave; celui de mes   &eacute;critures&hellip; </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Salut&nbsp;!   Je m&rsquo;appelle Alexandra</span><span style="color: windowtext; text-transform: none;"> et j&rsquo;ai 16 ans. Je suis &eacute;l&egrave;ve en seconde F, au Coll&egrave;ge   National Bogdan Petriceicu Hasdeu, &agrave;&nbsp;Buz</span><span style="color: windowtext; text-transform: none;">\\304\\203</span><span style="color: windowtext; text-transform: none;">u</span><span style="color: windowtext; text-transform: none;">.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Et maintenant quelques choses sur moi&nbsp;: je suis   tr&egrave;s sociable, j&rsquo;aime conna&icirc;tre de nouvelles personnes. J&rsquo;aime beaucoup lire,   surtout des romans et pi&egrave;ces&nbsp;de   th&eacute;&acirc;tre. J&rsquo;aime&nbsp;la nature, les excursions &agrave; la montagne avec mes   amis&hellip;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Cot&eacute; loisirs, je pr&eacute;f&egrave;re &eacute;couter de la musique, me   promener avec mes amis , mais j&rsquo;aime aussi rester &agrave; la maison et faire   diverses choses avec ma famille.</span></div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="122" width="184" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image073.jpg" v:shapes="_x0000_i1063" /></span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Journ&eacute;e   portes ouvertes, juin 2009.</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Projection   des &laquo;&nbsp;films-essais&nbsp;&raquo;.</span></div>\\012</td>\\012</tr>\\012</tbody>\\012</table>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<table cellspacing="0" cellpadding="0" border="1" style="border: medium none ; border-collapse: collapse;">\\012<tbody>\\012<tr>\\012<td width="307" valign="top" style="border: 1pt solid windowtext; padding: 0cm 5.4pt; width: 230.3pt;">\\012<div><span style="font-size: 14pt; color: rgb(51, 51, 51); text-transform: none;"><a name="binome15"></a>Lyc&eacute;e Paul Val&eacute;ry, Paris 12<sup>&egrave;me</sup>(France)</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">Philippe    Zill</span><span style="font-size: 10pt; color: rgb(51, 51, 51);">,   professeur de cin&eacute;ma </span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">&nbsp;</span></div>\\012<div><span style="background: yellow none repeat scroll 0% 0%; font-size: 10pt; color: blue; -moz-background-clip: border; -moz-background-origin: padding; -moz-background-inline-policy: continuous;">18_Paul_Valery</span></div>\\012<div><span style="font-size: 10pt; color: rgb(51, 51, 51);">&laquo;&nbsp;</span><span style="font-size: 10pt; color: blue;">Epreuve capitale&nbsp;&raquo; dur&eacute;e 4&rsquo;87&rsquo;&rsquo; fini   &agrave; 7&rsquo;22&rsquo;&rsquo;</span></div>\\012<div><span style="font-size: 10pt; color: windowtext;">Suite &agrave; une   dispute avec sa m&egrave;re, un jeune homme sort de chez lui furieux le jour de   l&rsquo;examen du baccalaur&eacute;at. </span></div>\\012<div><b><span style="font-size: 10pt; color: red;">Attention, le film ne commence qu&rsquo;apr&egrave;s un   grand noir, &agrave; 2&rsquo;35&rsquo;&rsquo; </span></b></div>\\012<div>&nbsp;</div>\\012<div><img height="144" width="192" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image075.jpg" v:shapes="_x0000_i1064" /></div>\\012<div>&nbsp;</div>\\012<div><span style="color: blue; text-transform: none;">Texte</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&laquo;&nbsp;&hellip; Il claque la porte et pr&eacute;tend   qu&rsquo;il se moque de l&rsquo;examen. Il prend le bus, mais n&rsquo;a pas son pass Navigo. Tout   le bus s&rsquo;en m&ecirc;le. Deuxi&egrave;me dispute, le chauffeur pile. Le jeune homme doit   sortir et croise deux jeunes gens &agrave; qui il demande son chemin. Les deux   jeunes l&rsquo;accompagnent sur la Petite ceinture, puis le laissent seul. Il   cherche son chemin et d&eacute;couvre un lieu tout &agrave; fait insoup&ccedil;onn&eacute; o&ugrave; l&rsquo;on   d&eacute;couvre les traces d'une capitale champ&ecirc;tre, fant&ocirc;me, abandonn&eacute;e. Finalement,   il panique &agrave; l&rsquo;id&eacute;e de rater son examen. En apercevant des individus peu rassurants,   il d&eacute;cide de quitter les lieux. par le premier moyen possible, et s&rsquo;aper&ccedil;oit que,   miraculeusement, il est arriv&eacute; au lyc&eacute;e Paul Val&eacute;ry. Il arrive &agrave;&nbsp;convaincre le gardien de le laiss&eacute; entrer <i>in extremis</i> et peut passer son examen,   l&rsquo;esprit tranquille, lib&eacute;r&eacute; de toute pression.&nbsp;&raquo;</span></div>\\012<div>&nbsp;</div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt; color: blue;">Texte</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt; color: blue;">Journal de bord   collectif</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Journal de bord collectif /   Compte-rendu de la s&eacute;ance du 3 D&eacute;cembre 2008</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Nous   avons d&rsquo;abord commenc&eacute; par faire un tour de table pour rassembler les id&eacute;es   de chacun pour le film&nbsp;:</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Eric</span></b><span style="font-size: 10pt;">&nbsp;:   les quais de seines, voyage au fil de l&rsquo;eau. Rencontre entre un homme riche   qui attend sa femme et un SDF assis l&agrave;. Les deux protagonistes se parlent, se   lient, deviennent presque amis.</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">&reg;</span><span style="font-size: 10pt;"> voir les films de Renoir,   <i>La r&egrave;gle du jeu</i>&nbsp;; <i>Boudu, Sauv&eacute; des eaux</i>.</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Elie&nbsp;:   voir chaque facette de Paris, du m&eacute;tro &agrave; la seine en passant pas les beaux   quartiers puis par Belleville etc.&hellip;.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Ma&iuml;a</span></b><span style="font-size: 10pt;">&nbsp;:   partie de ballon, puis perte du ballon apr&egrave;s un shoot malencontreux. Puis   recherche du ballon &agrave; travers la ville.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Laure</span></b><span style="font-size: 10pt;">&nbsp;:   coul&eacute;e verte.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Youri</span></b><span style="font-size: 10pt;">&nbsp;:   dispute entre un homme et une femme, l&rsquo;homme tente de la rattraper et tombe   dans une partie de la ville qu&rsquo;il ne soup&ccedil;onnait pas. Il est &eacute;tonn&eacute; puis   retour a la r&eacute;alit&eacute;.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Alexandre</span></b><span style="font-size: 10pt;">&nbsp;:   un homme cherche une femme apr&egrave;s une dispute, il la retrouve mais elle ne   veut plus de lui&hellip;D&eacute;prim&eacute; il rencontre alors une personne qui est oppos&eacute;e a   lui comme un artiste fou (opposition de deux personnages cf Eric )</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Guillaume&nbsp;:   deux personnes marchent dans la rue l&rsquo;un fait d&eacute;couvrir a l&rsquo;autre un lieu   secret puis dispara&icirc;t. Retrouv&eacute; seul le deuxi&egrave;me personnage se perd et d&eacute;couvre   des endroits &eacute;tranges (catacombes&nbsp;?)</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Jeu   d&rsquo;opposition entre le mouvement, le bruit, le gens de la ville ext&eacute;rieure et   la ville souterraine silencieuse et vide. (petite ceinture&nbsp;?) Ville du   haut </span><span style="font-size: 10pt;">&sup1;</span><span style="font-size: 10pt;">   ville du bas.</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">&reg;</span><span style="font-size: 10pt;"> voir le film d&rsquo;Antonioni, <i>L&rsquo;Avventura</i>.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Pierre</span></b><span style="font-size: 10pt;">&nbsp;:   Barbes, rue de la chapelle, m&eacute;tro a&eacute;rien, terrain de basket, lieux sales,   tristes&hellip; Comparaison avec un autre quartier.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Timoth&eacute;e</span></b><span style="font-size: 10pt;">&nbsp;:   Petite ceinture, maison abandonn&eacute;e lieux de la digression&nbsp;?</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">D&eacute;couverte   de la maison.</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">&reg;</span><span style="font-size: 10pt;"> Voir film de Richet, <i>Etat des lieux</i>.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Victorine</span></b><span style="font-size: 10pt;">&nbsp;:   Baladeur passant de mains en mains, chaque musique, chaque quartier.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Samuel</span></b><span style="font-size: 10pt;">&nbsp;:   Un homme rate une s&eacute;ance au MK2 Biblioth&egrave;que, il se perd dans les nouveaux   quartiers atroces qu&rsquo;il ne connaissait pas et est en quelque sorte absorb&eacute;   par cette ville. Il avance et se retrouve finalement sur les quais ou il   retrouve l&rsquo;humanit&eacute; des couleurs de la seine et va mieux.</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">&reg;</span><span style="font-size: 10pt;"> Voir le film d&rsquo;Antonioni, <i>La   Notte</i>. </span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Tim</span></b><span style="font-size: 10pt;"> :   Un adolescent qui doit aller acheter du pain t&ocirc;t le matin, il rencontre une   personne qui l&rsquo;intrigue et d&eacute;cide de la suivre. Cet homme se   dirige de&nbsp;magasins en magasins ( Galeries Lafayette&nbsp;?) l&rsquo;adolescent   le suit.</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">L&rsquo;homme   se r&eacute;v&egrave;le&nbsp;finalement &ecirc;tre une femme .</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Philippe &nbsp;Zill</span></b><span style="font-size: 10pt;">&nbsp;:   une personne rencontre une autre personne et la suit &agrave; travers Paris car il   est s&eacute;duit.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Timoth&eacute;e</span></b><span style="font-size: 10pt;">&nbsp;:   Une personne se rendant a un RDV passe devant la cin&eacute;math&egrave;que ou un   r&eacute;alisateur est en train de se faire interviewer. En arri&egrave;re plan des images   de son film sont projet&eacute;es on y voit Paris. Film dans le film.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Blandine</span></b><span style="font-size: 10pt;">&nbsp;:   Petite ceinture, une fille passe par plusieurs endroits anim&eacute;s et rencontre   des musiciens elle s&rsquo;installe avec eux.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Siham</span></b><span style="font-size: 10pt;">&nbsp;:   Une personne lisant un journal assis sur un banc, se crispe &agrave; la lecture d&rsquo;un   article. Il repense &agrave; plusieurs endroits de Paris de sa vie d&rsquo;avant en temps   que juif pendant la seconde guerre mondiale sous l&rsquo;occupation nazis. Il   revient ensuite &agrave; la r&eacute;alit&eacute;&nbsp;.</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Louise</span></b><span style="font-size: 10pt;">&nbsp;:   Un homme a un entretient d&rsquo;embauche ou il est refus&eacute;. Pour tenter d&rsquo;oublier   ses ennuis il s&rsquo;&eacute;chappe dans un endroit qu&rsquo;il ne conna&icirc;t pas (coul&eacute;e   verte&nbsp;?)</span></div>\\012<div align="left" style="margin-top: 0cm;"><b><span style="font-size: 10pt;">Igor</span></b><span style="font-size: 10pt;">&nbsp;:   Un groupe de jeunes ne savant pas ou passer leur soir&eacute;e du samedi soir. Ils   ont plusieurs possibilit&eacute;s. On film chacune d&rsquo;entres elles.</span></div>\\012<div align="left" style="margin-top: 0cm;">&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Propositions retenues&nbsp;: </span></b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Proposition   1</span></b><span style="color: windowtext; text-transform: none;">&nbsp;:</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Deux amis se retrouvent puis se perdent&nbsp;dans la petite ceinture.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">L&rsquo;un dispara&icirc;t et laisse l&rsquo;autre seul.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le premier manque son examen car il se perd.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Guillaume, Pierre, Timoth&eacute;e, Blandine, Samuel,   Alexandre, Antonin, Louis, Ga&eacute;tan, Timoth&eacute;e.</span></div>\\012<div>&nbsp;</div>\\012<div style="margin: 0cm 0cm 0.0001pt;"><b><font size="6"><span style="font-size: 10pt; color: windowtext; text-transform: none;">Proposition 2&nbsp;:</span></font></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Un homme passe un entretient d&rsquo;embauche&nbsp;auquel il   &eacute;choue.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Il sort et rencontre un adolescent. Il veut changer   oublier le r&eacute;el, son point de vue change.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Eric, Elie,   Tim, Laure, Igor, Ma&iuml;a</span><span style="color: windowtext; text-transform: none;">, </span><span style="color: windowtext; text-transform: none;">Louise, </span><span style="color: windowtext; text-transform: none;">Siham, Youri.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Questions</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">&middot;</span><span style="color: windowtext; text-transform: none;"> Les   personnages seront-ils dans une dure r&eacute;alit&eacute; ou bien la digression est elle   vecteur de cette r&eacute;alit&eacute;&nbsp;?</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Tristesse</span><span style="color: windowtext; text-transform: none;">&reg;</span><span style="color: windowtext; text-transform: none;">digression</span><span style="color: windowtext; text-transform: none;">&reg;</span><span style="color: windowtext; text-transform: none;">joie</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Joie</span><span style="color: windowtext; text-transform: none;">&reg;</span><span style="color: windowtext; text-transform: none;">digression</span><span style="color: windowtext; text-transform: none;">&reg;</span><span style="color: windowtext; text-transform: none;">tristesse.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&middot;</span><span style="color: windowtext; text-transform: none;"> La digression sert-elle &agrave;   s&rsquo;&eacute;chapper de la    r&eacute;alit&eacute; ou bien justement &agrave; la trouver&nbsp;?</span></div>\\012<div align="left" style="margin-top: 0cm;"><b>&nbsp;</b></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt; color: blue;">Texte</span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt; color: blue;">Journal de bord </span></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Journal de bord </span></div>\\012<div align="left" style="margin-top: 0cm;"><img height="136" width="180" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image077.jpg" v:shapes="_x0000_i1065" /></div>\\012<div align="left" style="margin-top: 0cm;"><span style="font-size: 10pt;">Un   film &eacute;crit et r&eacute;alis&eacute; par la classe d&rsquo;option cin&eacute;ma audiovisuel facultative   de 1&egrave;re du Lyc&eacute;e Paul Val&eacute;ry&nbsp;:</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Timoth&eacute;e, 1&egrave;re S1</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Alexandre,</span><span style="color: windowtext; text-transform: none;"> 1&egrave;re ES1</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Timoth&eacute;e, 1&egrave;re S2</span></div>\\012<div style="margin: 0cm 0cm 0.0001pt;"><b><font size="4"><span style="font-size: 10pt; font-weight: normal;">Ga&eacute;tan,   1&egrave;re ES1</span></font></b></div>\\012<div style="margin: 0cm 0cm 0.0001pt;"><b><font size="4"><span style="font-size: 10pt; font-weight: normal;">Guillaume,   1&egrave;re STG</span></font></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Louis, 1&egrave;re ES1</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pierre,&nbsp;1&egrave;re S2</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Vlad</span><span style="color: windowtext; text-transform: none;">, 1&egrave;re L</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Table des mati&egrave;res</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le   calendrier du film </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le sujet   propos&eacute;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le synopsis </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Fiches personnages </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le s&eacute;quencier (continuit&eacute;   non-dialogu&eacute;e) </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le sc&eacute;nario </span></div>\\012<div><span style="color: windowtext; text-transform: none;">La note d&rsquo;intention </span></div>\\012<div><span style="color: windowtext; text-transform: none;">La r&eacute;partition aux    diff&eacute;rents</span><span style="color: windowtext; text-transform: none;"> postes techniques </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Les rep&eacute;rages </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le d&eacute;coupage technique </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le plan de tournage </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le tournage </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le d&eacute;rushage </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le montage </span></div>\\012<div><span style="color: windowtext; text-transform: none;">La bande-son et le mixage </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Le g&eacute;n&eacute;rique </span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Le calendrier</span></div>\\012<div><b><u><span style="color: windowtext; text-transform: none;">S&eacute;ance du 21/01/2009</span></u></b><span style="color: windowtext; text-transform: none;"> (3h)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- <b>1&egrave;re id&eacute;e du synopsis</b> / </span><span style="color: red; text-transform: none;">manque</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Une personne du groupe est charg&eacute;e   d&rsquo;envoyer la version    &agrave; tout le monde.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- <b>Sc&eacute;nario</b> Nous avons cherch&eacute;   une id&eacute;e de sc&eacute;nario &agrave; partir du synopsis que nous avons imagin&eacute;. Puis nous   r&eacute;fl&eacute;chissons &agrave; un lieu de tournage (la petit ceinture en   l&rsquo;occurrence) et &agrave; &eacute;laborer des sc&egrave;nes et des situations.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La petite ceinture est</span><span style="color: windowtext; text-transform: none;"> un bon lieu de tournage car il y a peu de bruit.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pour la prochaine s&eacute;ance</span></b><span style="color: windowtext; text-transform: none;">&nbsp;Tourner des images de la petite ceinture,   avec une description des lieux (faire un essai avec les figurants, puis nous   regarderons les rushs que nous avons tourn&eacute;s.</span></div>\\012<div>&nbsp;</div>\\012<div><b><u><span style="color: windowtext; text-transform: none;">S&eacute;ance du 28/01/2009</span></u></b><span style="color: windowtext; text-transform: none;"> (3h)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Arriv&eacute;e d&rsquo;un nouveau membre de l&rsquo;&eacute;quipe&nbsp;: Vlad RATOYAN (1&egrave;re L2)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">En d&eacute;but de s&eacute;ance nous faisons un   r&eacute;capitulatif du sc&eacute;nario en apportant quelques modifications. </span><span style="color: red; text-transform: none;">manque</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Nous avons cherch&eacute; &agrave;   am&eacute;liorer la sc&egrave;ne du    bus&nbsp;: </span></b><span style="color: windowtext; text-transform: none;">Le protagoniste   descend &agrave; porte de Vincennes apr&egrave;s une altercation avec le conducteur du bus   (le conducteur contraint le protagoniste &agrave; descendre car les autres passagers   trouvent injuste qu&rsquo;il l&rsquo;ait laiss&eacute; entr&eacute; malgr&eacute; qu&rsquo;il ait oubli&eacute; son titre   de transport, m&ecirc;me s&rsquo;il passe son bac).</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Nous avons &eacute;galement <b>modifi&eacute; la sc&egrave;ne<span style="font-weight: normal;">    de la</span><span style="font-weight: normal;"> rencontre   entre les deux connaissances du protagoniste et celui-ci. Et du coup la fa&ccedil;on dont le il   est amen&eacute; &agrave; se rendre sur la petite ceinture.</span></b></span></div>\\012<div>&nbsp;</div>\\012<div><b><u><span style="color: windowtext; text-transform: none;">S&eacute;ance du 04/02/2009</span></u></b><span style="color: windowtext; text-transform: none;"> (3h)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- La quasi-totalit&eacute; de cette   s&eacute;ance a servi au groupe de r&eacute;aliser la mise au point du </span><b><span style="color: windowtext; text-transform: none;">s&eacute;quencier</span></b><span style="color: windowtext; text-transform: none;"> (12 s&eacute;quences). </span></div>\\012<div><span style="color: windowtext; text-transform: none;">- Une petite   partie du groupe s&rsquo;est occup&eacute; de r&eacute;dig&eacute; sur ordinateur le sujet propos&eacute;,   ainsi que les donn&eacute;es personnelles de chaque membre du groupe et de la r&eacute;partition de chacun   aux diff&eacute;rents postes techniques.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- Nous avons   &eacute;galement commenc&eacute; en fin de s&eacute;ance </span><b><span style="color: windowtext; text-transform: none;">le sc&eacute;nario de la 1&egrave;re s&eacute;quence<span style="font-weight: normal;">.</span></span></b></div>\\012<div><span style="color: red; text-transform: none;">Manque 1<sup>er</sup>   sc&eacute;nario</span></div>\\012<div>&nbsp;</div>\\012<div><b><u><span style="color: windowtext; text-transform: none;">S&eacute;ance du 11/02/2009</span></u></b><span style="color: windowtext; text-transform: none;"> (1h30)</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">- Visionnage des vid&eacute;os de rep&eacute;rage</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Discussion   autour d&rsquo;une table sur les choses importantes &agrave; mettre en &eacute;vidence dans le   sc&eacute;nario et sur le tournage. </span><span style="color: red; text-transform: none;">Manque texte</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pour la prochaine s&eacute;ance</span></b><span style="color: windowtext; text-transform: none;">&nbsp;: </span><span style="color: windowtext; text-transform: none;">Les trois acteurs devront &eacute;crire un paragraphe sur la vie et la personnalit&eacute;   du personnage qu&rsquo;ils joueront.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pour les autres membres du groupe,   chacun devra se charger d&rsquo;&eacute;crire le sc&eacute;nario de la s&eacute;quence qui lui   sera attribu&eacute;.</span></div>\\012<div>&nbsp;</div>\\012<div><b><u><span style="color: windowtext; text-transform: none;">S&eacute;ance du 04/03/2009</span></u></b><span style="color: windowtext; text-transform: none;"> (3h)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- R&eacute;daction   compl&egrave;te de tout le sc&eacute;nario.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">- Derni&egrave;res   mises au point sur les fiches personnages.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Le sujet propos&eacute;</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Au d&eacute;part, deux groupes ont &eacute;t&eacute; form&eacute;s,   il nous a &eacute;t&eacute; impos&eacute; deux th&eacute;matiques ; la premi&egrave;re traitait de   la digression    dont le protagoniste devait se d&eacute;tourner de son objectif,   s&rsquo;effacer et laisser place au d&eacute;cor.&nbsp;La seconde th&eacute;matique &eacute;tait   celle de la ville. Il fallait   filmer la ville d&rsquo;un   point de vue diff&eacute;rent de l&rsquo;image habituelle de Paris. Nous nous sommes alors   tourn&eacute; vers l&rsquo;id&eacute;e d&rsquo;une action sur la petite ceinture. Cette   voie ferr&eacute;e donnant un point de vue sur l&rsquo;arri&egrave;re des immeubles haussmanniens,   tr&egrave;s beaux sur la    devanture et n&eacute;glig&eacute;s sur la fa&ccedil;ade arri&egrave;re,   permet une opposition flagrante avec le d&eacute;cor du d&eacute;but du film. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pour nous faciliter la t&acirc;che on nous a   aussi donn&eacute; une trame narrative &agrave; suivre&nbsp;: notre personnage principal se   d&eacute;tourne de son objectif et laisse alors place &agrave; une digression qu&rsquo;il va   suivre un temps, avant de la laisser de c&ocirc;t&eacute; et de retourner &agrave; son objectif   initial. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pour nous, cet objectif initial &eacute;tait   celui du passage du BAC. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Une grande partie des id&eacute;es a &eacute;t&eacute;   trouv&eacute;e avec l&rsquo;aide des rep&eacute;rages. Ils nous ont permis de d&eacute;terminer les   commencements et fin de la digression. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">En revanche, nous avons eu quelques   probl&egrave;mes pour trouver l&rsquo;actrice pr&eacute;pos&eacute;e au r&ocirc;le de la m&egrave;re du film. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Ici la digression sert &agrave;   r&eacute;v&eacute;ler au h&eacute;ros, sa volont&eacute; de passer le bac.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">La    structure du r&eacute;cit</span><span style="color: windowtext; text-transform: none;"> sera   donc CONFLIT/DIGRESSION/RESOLUTION.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="146" width="193" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image079.jpg" v:shapes="_x0000_i1066" /></span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Synopsis</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Suite &agrave; une dispute avec sa m&egrave;re, un jeune homme sort de   chez lui furieux le jour de l&rsquo;examen du BAC. Il claque la porte et pr&eacute;tend   qu&rsquo;il se fiche du BAC. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Il prend le bus, mais n&rsquo;a pas son &laquo;&nbsp;PASS   NAVIGO&nbsp;&raquo; tout le bus s&rsquo;en m&ecirc;le. Deuxi&egrave;me dispute, le chauffeur pile, il   doit sortir et croise deux gar&ccedil;ons &agrave; qui il demande son chemin. Les deux   l&rsquo;accompagnent sur la    P.C. puis le laissent seul. Il cherche son chemin et   d&eacute;couvre un lieu tout &agrave; fait insoup&ccedil;onn&eacute; o&ugrave; l&rsquo;on d&eacute;couvre les traces d'une   capitale champ&ecirc;tre, fant&ocirc;me, abandonn&eacute;e. Et il panique &agrave; l&rsquo;id&eacute;e de rater son   BAC.</span></div>\\012<div style="margin: 0cm 0cm 0.0001pt;"><b><font size="6"><span style="font-size: 10pt; color: windowtext; text-transform: none; font-weight: normal;">En   apercevant des individus peu rassurants, il d&eacute;cide de quitter la P.C. par le premier   moyen possible, et s&rsquo;aper&ccedil;oit miraculeusement qu&rsquo;il est arriv&eacute; au lyc&eacute;e Paul   Val&eacute;ry. Il arrive &agrave;&nbsp;convaincre le   gardien de le laisser passer in extremis et peut passer son examen, l&rsquo;esprit   tranquille, lib&eacute;r&eacute; de toute pression.</span></font></b></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="139" width="104" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image081.jpg" v:shapes="_x0000_i1067" />&nbsp;<img height="139" width="104" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image083.jpg" v:shapes="_x0000_i1068" /></span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Fiches   personnages</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis&nbsp;:</span></b><span style="color: windowtext; text-transform: none;"> (par Louis)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Louis est un jeune gar&ccedil;on &acirc;g&eacute; de 16   ans, il vit seul avec sa m&egrave;re suite au d&eacute;part de son p&egrave;re qui n&rsquo;est jamais   revenu. D&eacute;part qui marque aussi la relation tumultueuse    avec sa m&egrave;re. Il aime le sport, et passer du temps avec ses   amis, il n&rsquo;est pas tr&egrave;s travailleur mais reste motiv&eacute; &agrave; l&rsquo;id&eacute;e d&rsquo;avoir son   bac. Il conna&icirc;t assez peu Pierre et Tim mais garde un souvenir plut&ocirc;t   sympathique des deux personnages qu&rsquo;il n&rsquo;a pas revu depuis longtemps. Il sort   assez souvent d&eacute;laissant un peu son travail. Son humeur est plut&ocirc;t joviale   mais reste quelque peu renferm&eacute; sur lui m&ecirc;me.</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre&nbsp;: </span></b><span style="color: windowtext; text-transform: none;">(par Pierre)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Pierre est un jeune gar&ccedil;on &acirc;g&eacute;   d&rsquo;environ 16 ans, c&rsquo;est un adolescent au temp&eacute;rament assez joyeux, tout en   restant bien tremp&eacute;. Il a grandi dans les quartiers populaires parisiens aux   cot&eacute;s de ses amis de quartiers (y compris Tim). Apr&egrave;s une enfance   tumultueuse, et un &eacute;chec scolaire cuisant, il s&rsquo;immisce dans les trafiques de   quartiers ainsi que dans les d&eacute;lits mineurs afin de subvenir aux besoins financiers   de son m&eacute;nage. </span></div>\\012<div><span style="color: windowtext; text-transform: none;">Suite &agrave; une altercation muscl&eacute; face aux forces de   l&rsquo;ordre, il &eacute;vite de peut la prison et d&eacute;cide alors de quitt&eacute; ce milieu dans   lequel il commence &agrave; ressentir un mal-&ecirc;tre. Il trouve alors un petit boulot   tranquille, et occupe son temps libre &agrave; sortir avec son principal ami Tim.   Leur passe temps favori, bien que ill&eacute;gal, reste le graffiti&nbsp;; et leur   terrain de jeu pr&eacute;f&eacute;r&eacute;&nbsp;: Les chemins de fers d&eacute;saffect&eacute;s de &laquo;&nbsp;La Petite Ceinture&nbsp;&raquo;   (o&ugrave; il guidera, avec Louis, <i>voir synopsis</i>).</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim :</span></b><span style="color: windowtext; text-transform: none;"> (par Timoth&eacute;e)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">C&rsquo;est un jeune gar&ccedil;on, habitu&eacute; &agrave; sortir   dans la rue, il va souvent sur la petite ceinture de   Paris pour y faire du graffiti et y vagabonder avec des amis.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Il ne conna&icirc;t pas tr&egrave;s bien Louis (le   personnage principal) et cela faisait longtemps qu&rsquo;il ne l&rsquo;avait pas vue,   avant de le croiser dans la rue (voir synopsis).Il est d&rsquo;humeur plut&ocirc;t jovial   et plaisantin, tout comme son amis Pierre avec qui il passe le plus claire de   son temps &agrave; trainer dans les rues et &agrave; la petite ceinture.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;">Le s&eacute;quencier</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">1&egrave;re s&eacute;quence&nbsp;</span></b><span style="color: windowtext; text-transform: none;">: Louis,   le protagoniste du r&eacute;cit, est r&eacute;veill&eacute; par sa m&egrave;re vers 13h00, alors qu&rsquo;il a   pass&eacute; sa nuit &agrave; r&eacute;viser pour son BAC qu&rsquo;il doit passer le jour m&ecirc;me.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">2&egrave;me   s&eacute;quence</span></b><span style="color: windowtext; text-transform: none;">&nbsp;: Louis arrive dans la cuisine en dilettante,   il commence &agrave; petit d&eacute;jeuner. Sa m&egrave;re est assise pr&egrave;s de lui, et ne cesse de   le scruter en observant ces faits et gestes cherchant le moindre d&eacute;tail pour   le critiquer. Pouss&eacute; &agrave; bout, LOUIS sort de la cuisine en claquant   la porte, prend son sac et sort de chez lui pour aller passer son &eacute;preuve.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">3&egrave;me   s&eacute;quence&nbsp;</span></b><span style="color: windowtext; text-transform: none;">: Louis se dirige vers une boulangerie pour s&rsquo;acheter un   petit quelque chose &agrave; manger puisqu&rsquo;il n&rsquo;a pas eu le temps de petit d&eacute;jeuner   chez lui. Il se rend compte qu&rsquo;il n&rsquo;a pas assez d&rsquo;argent et demande &agrave; la boulang&egrave;re s&rsquo;il   peut la payer avec ce   qu&rsquo;il a, mais celle-ci refuse. Il se dirige alors vers l&rsquo;arr&ecirc;t du bus qu&rsquo;il   doit prendre.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">4&egrave;me   s&eacute;quence&nbsp;</span></b><span style="color: windowtext; text-transform: none;">: Il arrive sur la place Daumesnil,   et s&rsquo;aper&ccedil;oit que celle-ci est ferm&eacute;e &agrave; la circulation. Il    demande &agrave; un viel homme post&eacute; &agrave; l&rsquo;arr&ecirc;t de bus qui lui   indique qu&rsquo;il n&rsquo;y a pas de bus. Louis d&eacute;cide donc de partir au lieu d&rsquo;examen   &agrave; pied.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">5&egrave;me   s&eacute;quence</span></b><span style="color: windowtext; text-transform: none;">&nbsp;: En marchant dans les rues du XX&egrave;me   arrondissement, il croise deux de ses anciens camarades de classe, Pierre et Tim,   assis justement devant leur ancien coll&egrave;ge. Les trois gar&ccedil;ons discutent   bri&egrave;vement, et Louis explique au deux individus qu&rsquo;il va passer son baccalaur&eacute;at   au lyc&eacute;e Paul Val&eacute;ry, mais qu&rsquo;il ne conna&icirc;t pas la route. Les deux   comp&egrave;res lui propose de passer par un raccourci, qui se trouve &ecirc;tre le petite   ceinture. Louis accepte mais reste sur ses gardes.</span></div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="100" width="132" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image085.jpg" v:shapes="_x0000_i1069" />&nbsp;&nbsp;&nbsp; <img height="98" width="131" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image087.jpg" v:shapes="_x0000_i1070" /></span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">6&egrave;me   s&eacute;quence&nbsp;</span></b><span style="color: windowtext; text-transform: none;">: Les trois jeunes hommes prennent alors une petite rue,   qui les m&egrave;nent face &agrave; un mur, Louis est h&eacute;sitant &agrave; l&rsquo;id&eacute;e de p&eacute;n&eacute;trer sur les   rails, de braver l&rsquo;interdit. Finalement il c&egrave;de aux propositions des deux   autres et&nbsp;escalade le mur qui m&egrave;ne aux   rails. </span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">7&egrave;me   s&eacute;quence&nbsp;:</span></b><span style="color: windowtext; text-transform: none;"> Louis, Tim et Pierre commencent alors &agrave; marcher sur les   rails, les deux comp&egrave;res faisant les imb&eacute;ciles. Louis est constern&eacute; et   demande aux deux autres&nbsp;de se d&eacute;p&ecirc;cher   un peu.</span></div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="117" width="156" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image089.jpg" v:shapes="_x0000_i1071" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <img height="124" width="156" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image091.jpg" v:shapes="_x0000_i1072" /></span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">8&egrave;me   s&eacute;quence&nbsp;:</span></b><span style="color: windowtext; text-transform: none;"> Pierre et Tim veulent montrer &agrave; Louis leurs graffs   situ&eacute;s sur un mur en hauteur, mais Louis ne veut pas. Pierre et Tim grimpent sur le mur, pour montrer &agrave; Louis   leurs graffitis, cependant celui-ci ne monte pas, il&nbsp;regarde les graffitis d&rsquo;en bas.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Apr&egrave;s ce court arr&ecirc;t, les   trois comp&egrave;res repartent en chemin.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">9&egrave;me   s&eacute;quence&nbsp;</span></b><span style="color: windowtext; text-transform: none;">: En montant sur une &eacute;chelle, Tim aper&ccedil;oit un homme avec   qui, Pierre et Louis devaient s&rsquo;entretenir. Alors ils abandonnent Louis sur la voie d&eacute;serte en   lui assurant qu&rsquo;il all&eacute; revenir. Louis est perdu, il ne sait plus o&ugrave; aller.</span></div>\\012<div>&nbsp;</div>\\012<div><span style="color: windowtext; text-transform: none;"><img height="109" width="144" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image092.jpg" v:shapes="_x0000_i1073" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <img height="109" width="144" border="0" alt="" src="file:///D:/CavalieT/LOCALS%7E1/Temp/msohtml1/01/clip_image094.jpg" v:shapes="_x0000_i1074" /></span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">10&egrave;me   s&eacute;quence</span></b><span style="color: windowtext; text-transform: none;">&nbsp;: Au bout de dix minutes, Louis perd patience et   prend l&rsquo;initiative de continuer la route seul. Longue   s&eacute;ance de vagabondage de Louis sur la PC. Il &egrave;re, marchant sur les rails et observant   le d&eacute;cor autour de lui&nbsp;; d&eacute;couvrant des lieus tout &agrave; fait insoup&ccedil;onn&eacute; o&ugrave;   l&rsquo;on d&eacute;couvre les traces d'une capitale champ&ecirc;tre, fant&ocirc;me, abandonn&eacute;e.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">11&egrave;me   s&eacute;quence&nbsp;: </span></b><span style="color: windowtext; text-transform: none;">Sur le chemin, il croise un &laquo;&nbsp;fou&nbsp;&raquo; mais ne   r&eacute;pond pas &agrave; ses interpellations. Il continu de marcher.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">12&egrave;me   s&eacute;quence</span></b><span style="color: windowtext; text-transform: none;">&nbsp;: Au bout de plusieurs centaines de m&egrave;tres, Louis   aper&ccedil;oit une sortie et se pr&eacute;cipite sur celle-ci. La sortie l&rsquo;am&egrave;ne juste   devant son lyc&eacute;e.</span></div>\\012<div><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">13&egrave;me   s&eacute;quence&nbsp;</span></b><span style="color: windowtext; text-transform: none;">: Louis arrive en courant devant son lyc&eacute;e et le gardien   le laisse rentrer in extremis&nbsp;; heureux d&rsquo;avoir retrouv&eacute; son chemin et   de pouvoir passer son &eacute;preuve. </span></div>\\012<div><b>&nbsp;</b></div>\\012<div><span style="color: windowtext; text-transform: none;">Le sc&eacute;nario</span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 1</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">La m&egrave;re    de Louis</span></i><i><span style="color: windowtext; text-transform: none;"> est   dans la cuisine en    train de se manucurer et Louis arrive pour prendre son petit-d&eacute;jeuner.</span></i></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">La m&egrave;re</span></b><span style="color: windowtext; text-transform: none;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></div>\\012<div><span style="color: windowtext; text-transform: none;">C&rsquo;est &agrave; cette heure l&agrave; que tu te l&egrave;ves&nbsp;?</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Et tu ne finis pas&nbsp;tes   c&eacute;r&eacute;ales ? Tu crois que c&rsquo;est gratuit ? Et tu aurais pu sortir la poubelle hier soir&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">(<i>Soupir d&rsquo;&eacute;nervement</i>)</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">La m&egrave;re</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Cause toujours tu m&rsquo;int&eacute;resses&hellip;</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">C&rsquo;est bon&nbsp;! Je passe mon bac   aujourd&rsquo;hui&nbsp;! Tu peux me l&acirc;cher deux secondes&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">La m&egrave;re</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Oh il a bon dos le BAC. Le BAC ceci, le   BAC cela, avec toi il y a toujours une bonne excuse.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">De toute fa&ccedil;on tu ne l&rsquo;auras pas ton   BAC. C&rsquo;est de p&egrave;re en fils et puis l&rsquo;ann&eacute;e prochaine je ne garde pas une   larve &agrave; la maison&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">De toute fa&ccedil;on je m&rsquo;en fiche du   BAC&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Louis quitte son domicile en claquant la porte&nbsp;!</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 2</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">LOUIS   s&rsquo;approche du bus tout en cherchant son pass dans sa poche. Arriv&eacute; au niveau   du chauffeur, il se rend compte qu&rsquo;il l&rsquo;a oubli&eacute;.</span></i></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ah merde&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Le   chauffeur</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Bonjour jeune homme, vous avez votre titre de   transport&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Bah en fait, j&rsquo;ai oubli&eacute; ma carte et comme je passe mon   bac aujourd&rsquo;hui, je me demandais si vous pouviez me laisser passer.</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Le   chauffeur</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">C&rsquo;est bon pour cette fois.</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Grognement   des voyageurs. Louis marche vers l&rsquo;arri&egrave;re du bus. Sans le vouloir, il marche   sur le pied d&rsquo;une jeune femme. Celle-ci s&rsquo;&eacute;nerve et commence alors&nbsp;une engueulade entre LOUIS et la FEMME.</span></i></div>\\012<div><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">La femme   </span></b><span style="color: windowtext; text-transform: none;">(<i>&eacute;nerv&eacute;e</i>)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Vous vous croyez tout permis&nbsp;! D&eacute;j&agrave; vous fraudez et   ensuite vous m&rsquo;agressez&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ouais c&rsquo;est bon&nbsp;! Je n&rsquo;ai pas fais expr&egrave;s   pardon&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Un HOMME   s&rsquo;en m&ecirc;le alors soutenu par les commentaires des autres voyageurs.</span></i></div>\\012<div><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">L&rsquo;homme</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Les jeunes de nos jours&nbsp;! Ils pensent que parce   qu&rsquo;ils sont jeunes ils ont tous les droits&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;ai pas fait expr&egrave;s, c&rsquo;est bon&nbsp;! C&rsquo;est pas la peine de s&rsquo;&eacute;nerver   pour si peu&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">L&rsquo;homme</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Et vulgaire en plus&nbsp;! Ah bah bravo&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">N&rsquo;importe quoi&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Le   CHAUFFEUR du bus se gare sur le bas-c&ocirc;t&eacute; et sort de sa cabine.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">LE   CHAUFFEUR&nbsp;: </span></b><span style="color: windowtext; text-transform: none;">(<i>&agrave; bout</i>)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">Bon &ccedil;a suffit maintenant&nbsp;!   J&rsquo;ai &eacute;t&eacute; suffisamment patient pour vous&nbsp;laisser monter, et vous emb&ecirc;ter   tout le monde&nbsp;! Vous descendez et puis c&rsquo;est tout.</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Louis s&rsquo;ex&eacute;cute tout en grognant dans son coin.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 3</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Louis descend du bus &agrave; un endroit qu&rsquo;il   ne conna&icirc;t pas. Il est d&eacute;pit&eacute; et ne sait pas dans quelle direction aller. Il   se d&eacute;cide &agrave; suivre la    direction du bus, et croise des anciens copains du coll&egrave;ge,   qu&rsquo;il avait perdu de vue.</span></i></div>\\012<div><i><span style="color: windowtext; text-transform: none;">TIM et PIERRE, assis sur un banc   l&rsquo;aper&ccedil;oivent.</span></i></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Hey&nbsp;!   Regarde c&rsquo;est pas LOUIS l&agrave;-bas qui arrive&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">LOUIS   lequel&nbsp;? Du coll&egrave;ge&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ouais&nbsp;!   Viens on va le voir.</span></div>\\012<div><span style="color: windowtext; text-transform: none;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Hey&nbsp;!   LOUIS&nbsp;! &Ccedil;a va&nbsp;? Tu te rappels de nous&nbsp;!? Au coll&egrave;ge et   tout&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ah, euh ouais   ouais &hellip; &ccedil;a va et vous&nbsp;? Ca fait longtemps&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">J&rsquo;avoue&nbsp;!   Ca fait grave longtemps&nbsp;! Bien ou quoi&nbsp;? Tu fais quoi ici&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Bah l&agrave;, j&rsquo;vais passer le bac   (rire)&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">T&rsquo;es   s&eacute;rieux&nbsp;? L&agrave;,    maintenant&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Oui mais   j&rsquo;ai eu des probl&egrave;mes dans le bus, le chauffeur il m&rsquo;a oblig&eacute; &agrave;   descendre&nbsp;! J&rsquo;suis un peux perdu l&agrave;.</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Tu dois le   passer dans quel lyc&eacute;e&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Paul   Val&eacute;ry&nbsp;! Vous connaissez&nbsp;? Vous pouvez pas m&rsquo;aider&nbsp;?</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Bien s&ucirc;r   qu&rsquo;on conna&icirc;t&nbsp;! On y &eacute;t&eacute; en seconde, avant d&rsquo;&ecirc;tre r&eacute;orient&eacute; en BEP (<i>rire</i>).   Si tu veux on t&rsquo;y am&egrave;ne. On conna&icirc;t un petit raccourci sympa (<i>sourire</i>).</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ouais   j&rsquo;avoue&nbsp;! Un chemin direct d&rsquo;ici &agrave; PV&nbsp;! Si tu veux on t&rsquo;emm&egrave;ne   jusqu'&agrave; l&agrave;-bas&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ouais je   veux bien, mais j&rsquo;esp&egrave;re que vous me faites pas un plan foireux&nbsp;! Jouez   pas les gamins (<i>sourire</i>).</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Louis suit alors Tim et Pierre.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 4</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Louis et ses deux amis, Pierre et Tim, sont devant la petite ceinture,   soudain Louis h&eacute;site&nbsp;&agrave; p&eacute;n&eacute;trer sur   les rails, car il faut escalader une grille.</span></i></div>\\012<div style="text-indent: 16.35pt;"><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b><i><span style="color: windowtext; text-transform: none;">(vex&eacute;)</span></i></div>\\012<div><span style="color: windowtext; text-transform: none;">Allez viens&nbsp;! Je t&rsquo;assure c&rsquo;est des rails   abandonn&eacute;es,&nbsp;y a rien &agrave; craindre.</span></div>\\012<div><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b><span style="color: windowtext; text-transform: none;"> (<i>h&eacute;sitant</i>)</span></div>\\012<div><span style="color: windowtext; text-transform: none;">On sait jamais&nbsp;! Imagine que quelqu'un nous voit.</span></div>\\012<div style="text-indent: 16.35pt;"><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Mais si allez viens on te dit qu&rsquo;il n&rsquo;y a jamais   personne qui vient dans cet endroit.</span></div>\\012<div><i>&nbsp;</i></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Louis   c&egrave;de aux avances de ses deux amis et les 3 personnages se mettent &agrave; escalader   le mur.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence 5</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">TIM et PIERRE se dirigent vers une voiture, et commence &agrave; s&rsquo;amuser   avec. LOUIS n&rsquo;appr&eacute;cie pas.</span></i></div>\\012<div style="text-indent: 16.35pt;"><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Allez d&eacute;p&ecirc;chez vous les mecs&nbsp;!</span></div>\\012<div style="text-indent: 16.35pt;">&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Rolalah c&rsquo;est bon mon pote&nbsp;! T&rsquo;inqui&egrave;tes pas on &agrave; le   temps&nbsp;! C&rsquo;est juste &agrave; cot&eacute; &hellip;</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Nan mais j&rsquo;avoue que &ccedil;a se fait pas, il passe son BAC le   pauvre.</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">Les deux   amis s&rsquo;arr&ecirc;tent et reprennent le chemin.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   6</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">En   chemin, PIERRE et TIM veulent montrer &agrave; LOUIS leurs graffitis situ&eacute;s sur un   mur en hauteur.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Viens regarde sur le mur l&agrave;-bas, on a un b&ecirc;te de truc &agrave;   te montrer</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Non j&rsquo;ai pas le temps pas le temps les mecs</span></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Allez c&rsquo;est vite fait&nbsp;! C&rsquo;est des graffs qu&rsquo;on a   fait&nbsp;! On a besoin de ton opinion (<i>sourire</i>)</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">PIERRE et TIM grimpent sur le mur, pour montrer &agrave; LOUIS   leurs graffitis. LOUIS ne monte pas et regarde la sc&egrave;ne d&rsquo;en bas.</span></i></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Apr&egrave;s ce court arr&ecirc;t, les trois comp&egrave;res repartent en   chemin.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   7</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Sur le   chemin, TIM monte sur une &eacute;chelle pour s&rsquo;amuser, une fois en hauteur, il a un   point de vue magnifique portant tr&egrave;s loin. Il aper&ccedil;oit alors un homme, avec   qui LUI et PIERRE devaient s&rsquo;entretenir d&rsquo;urgence. </span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tim</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Hey Pierre t&eacute;ma&nbsp;! Y&rsquo;a Alexandre l&agrave;-bas&nbsp;!! Faut   absolument qu&rsquo;on aille lui parler, on n&rsquo;aura pas de meilleur occasion&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Pierre</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Ok&nbsp;! Louis, d&eacute;sol&eacute;, on doit aller r&eacute;gler un truc,   mais on revient t&rsquo;inqui&egrave;te pas&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Mais j&rsquo;ai pas le temps l&agrave;&nbsp;! Faites pas les   encul&eacute;s&nbsp;! Vous m&rsquo;aviez promis&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">Tiom</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Nan mais t&rsquo;inqui&egrave;tes pas&nbsp;! C&rsquo;est tout droit&nbsp;!</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">PIERRE   et TIM abandonnent LOUIS sur la voie d&eacute;serte. LOUIS   est perdu et ne sait plus o&ugrave; aller.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   8</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Longue   s&eacute;ance de Vagabondage de LOUIS sur la PC. </span></i></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Il &egrave;re,   marchant sur les rails et observant le d&eacute;cor autour de lui&nbsp;; d&eacute;couvrant   des lieux tout &agrave; fait insoup&ccedil;onn&eacute; o&ugrave; l&rsquo;on d&eacute;couvre les traces d'une capitale   champ&ecirc;tre, fant&ocirc;me, abandonn&eacute;e.</span></i></div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   9</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">Lors de   sa marche, il croise un &laquo;&nbsp;fou&nbsp;&raquo; qui ne r&eacute;pond pas &agrave; ses   interpellations.</span></i></div>\\012<div><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Euuh &hellip;Monsieur&nbsp;? Monsieur&nbsp;!</span></div>\\012<div style="text-indent: 16.35pt;"><i>&nbsp;</i></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Le fou</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">(<i>soupir</i>)&hellip;</span></div>\\012<div>&nbsp;</div>\\012<div><i><span style="color: windowtext; text-transform: none;">LOUIS   continue de marcher et aper&ccedil;oit un tunnel qu&rsquo;il d&eacute;cide de traverser.</span></i></div>\\012<div>&nbsp;</div>\\012<div>&nbsp;</div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   10</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">LOUIS   s&rsquo;engage dans un tunnel peu r&eacute;confortant. Il finit par trouver une sortie   signifiant la fin de son   calvaire.</span></i></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   11</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">D&eacute;sesp&eacute;r&eacute;,   Il quitte la    petite ceinture ne retrouvant plus son chemin. Il marche   dans la rue sans but   avec l&rsquo;id&eacute;e qu&rsquo;il a rat&eacute; son BAC et de toute les r&eacute;percutions que cela   pourrai avoir. LOUIS demande son chemin &agrave; un passant qui lui indique le lyc&eacute;e   qui se trouve juste &agrave; c&ocirc;t&eacute;.</span></i></div>\\012<div><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">S&eacute;quence   12</span></b></div>\\012<div><i><span style="color: windowtext; text-transform: none;">LOUIS   arrive en courant devant son lyc&eacute;e.</span></i></div>\\012<div style="text-indent: 16.35pt;"><b>&nbsp;</b></div>\\012<div><b><span style="color: windowtext; text-transform: none;">Louis</span></b></div>\\012<div><span style="color: windowtext; text-transform: none;">Monsieur&nbsp;! je vous en supplie laissez moi rentrer,   c&rsquo;est super important&nbsp;pour moi&nbsp;!</span></div>\\0