/* Copyright (C) 2007 Johan MATHE - johan.mathe@tremplin-utc.net -  Centre Pompidou - IRI 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * $Id: graph.cpp 114 2007-02-21 09:58:30Z johmathe $
 * $Date: 2007-02-21 10:58:30 +0100 (mer, 21 fv 2007) $
 */
#include "graph.h"

using namespace std;

graph::graph (int x, int y, string path)
{
  this->xsize = 600;
  this->ysize = y;
  this->xaxis_offset = 200;
  this->xoffset = 10;
  this->yoffset = 10;
  this->size_graduation = 3;
  this->grid_size = 10;
  this->threseold = 100;
  this->global_path = path;
}

graph::~graph ()
{


}


void
graph::save ()
{
  gdImagePng (im_colors, fdgraph_colors);
  gdImagePng (im_qte_mvmt, fdqte_mvmt);
  gdImageDestroy (im_qte_mvmt);
  gdImageDestroy (im_colors);
  fclose (fdgraph_colors);
  fclose (fdqte_mvmt);
}

void
graph::init_gd ()
{

  if (data.size () > xsize)
    {
      xsize = data.size () + 20;
    }

  /* Create image buffers */
  im_colors = gdImageCreate (xsize, ysize);
  im_qte_mvmt = gdImageCreate (xsize, ysize);

  /* Declare color indexes */
  background_color = gdImageColorAllocate (im_qte_mvmt, 255, 255, 255);
  line_color = gdImageColorAllocate (im_qte_mvmt, 0, 0, 0);
  title_color = gdImageColorAllocate (im_qte_mvmt, 255, 255, 0);
  grid_color = gdImageColorAllocate (im_qte_mvmt, 0, 0, 0);
  threseold_color = gdImageColorAllocate (im_qte_mvmt, 255, 0, 0);

  /* Declare color indexes for the color graph */
  background_color = gdImageColorAllocate (im_colors, 255, 255, 255);
  line_color = gdImageColorAllocate (im_colors, 0, 0, 0);
  title_color = gdImageColorAllocate (im_colors, 255, 255, 0);
  grid_color = gdImageColorAllocate (im_colors, 0, 0, 0);
  red_color = gdImageColorAllocate (im_colors, 255, 0, 0);
  green_color = gdImageColorAllocate (im_colors, 0, 255, 0);
  blue_color = gdImageColorAllocate (im_colors, 0, 0, 255);

  /* Open file descriptors (POSIX C) */
  filename_colors = global_path + "/colors.png";
  filename_qte_mvmt = global_path + "/qte_mvmt.png";
  fdgraph_colors = fopen (filename_colors.c_str (), "wb");
  fdqte_mvmt = fopen (filename_qte_mvmt.c_str (), "wb");
}

void
graph::set_title (string title)
{

}


void
graph::draw_all_canvas ()
{

/* Mise en place des deux canvas */
  string str = "Couleurs";
  draw_canvas (im_colors, str);
  str = "quantit de mouvement";
  draw_canvas (im_qte_mvmt, str);

}

void
graph::draw_canvas (gdImagePtr im, string title)
{
  gdImageString (im, gdFontGetLarge (),
		 im->sx / 2 - (title.size () * gdFontGetLarge ()->w / 2),
		 10, (unsigned char *) title.c_str (), grid_color);

/* Yaxis */
  gdImageLine (im, xoffset, yoffset, xoffset, ysize - yoffset, grid_color);

/* graduation */
  for (int i = yoffset; i < ysize - yoffset; i++)
    {
      if (!(i % grid_size))
	{
	  gdImageLine (im, xoffset - 2, i, xoffset + 2, i, grid_color);
	}

    }


/* Xaxis */
  gdImageLine (im, xoffset, xaxis_offset, xsize - xoffset, xaxis_offset,
	       grid_color);


  for (int i = xoffset; i < xsize - xoffset; i++)
    {
      if (!(i % grid_size))
	{
	  gdImageLine (im, i, xaxis_offset - 2, i, xaxis_offset + 2,
		       grid_color);
	}

    }

}



void
graph::draw_datas ()
{
/* boucle de cration des donnes */
  for (int i = 1; i < data.size () - 1; i++)
    {
      gdImageLine (im_qte_mvmt, i - 1 + xoffset,
		   (-data[i - 1].global) +xaxis_offset, i + xoffset,
		   (-data[i].global) +xaxis_offset, line_color);
    }
/* Affichage du seuil de traitement */
  gdImageLine (im_qte_mvmt, xoffset, xaxis_offset - threseold,
	       xsize - xoffset, xaxis_offset - threseold, threseold_color);


}

void
graph::draw_color_datas ()
{
  /* Mise en place du rouge */
  for (int i = 1; i < data.size () - 1; i++)
    {
      gdImageLine (im_colors, i - 1 + xoffset,
		   (-data[i - 1].red) + xaxis_offset, i + xoffset,
		   (-data[i].red) + xaxis_offset, red_color);
    }

  /* Mise en place du vert */
  for (int i = 1; i < data.size () - 1; i++)
    {
      gdImageLine (im_colors, i - 1 + xoffset,
		   (-data[i - 1].green) + xaxis_offset, i + xoffset,
		   (-data[i].green) + xaxis_offset, green_color);
    }

  /* Mise en place du bleu */
  for (int i = 1; i < data.size () - 1; i++)
    {
      gdImageLine (im_colors, i - 1 + xoffset,
		   (-data[i - 1].blue) + xaxis_offset, i + xoffset,
		   (-data[i].blue) + xaxis_offset, blue_color);
    }


}
