/*
 * Copyright (C) 2007 Johan MATHE - johan.mathe@tremplin-utc.net - Centre
 * Pompidou - IRI This library is free software; you can redistribute it 
 * and/or modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either version
 * 2.1 of the License, or (at your option) any later version. This
 * library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details. You should have received a copy of the GNU
 * Lesser General Public License along with this library; if not, write to 
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA $Id: film.cpp 141 2007-04-02 16:10:53Z
 * johmathe $ $Date: 2007-04-03 17:43:39 +0200 (mar, 03 avr 2007) $ 
 */
#include "film.h"
#include "DialogShotDetect_c.h"
#include "graph.h"

#include <wx/thread.h>
#include <wx/msgdlg.h>

int
  film::idfilm = 0;

void
film::do_stats (int frame_num)
{
  double perctmp = percent;
  struct timeval time_now;
  struct timezone timezone;
  gettimeofday (&time_now, &timezone);

  int time_elapsed = time_now.tv_sec - dialogParent->time_start.tv_sec;

  if (dialogParent->get_time_elapsed () != time_elapsed)
    {
      wxMutexGuiEnter ();
      dialogParent->set_time_elapsed (time_elapsed);
      wxMutexGuiLeave ();
    }

  percent = ((frame_num) / (fps * (duration.mstotal / 100000)));
  if (int (percent) != int (perctmp) || !show_started)
    {
      double val_global = percent / idfilm + double (progress_state_prev);
      wxMutexGuiEnter ();
      dialogParent->set_progress_local (percent + 1);
      dialogParent->set_progress_global (val_global + 1);
      wxMutexGuiLeave ();
    }
  show_started = 1;
}


void
film::CompareFrame (AVFrame * pFrame, AVFrame * pFramePrev)
{
  int y;
  int x;
  int diff;
  int frame_number = pFrame->coded_picture_number;
  char c1, c2, c3;
  int c1tot, c2tot, c3tot;
  c1tot = 0;
  c2tot = 0;
  c3tot = 0;
  char c1prev, c2prev, c3prev;
  int score;
  score = 0;
  for (y = 0; y < height; y++)
    {
      for (x = 0; x < width; x++)
	{

	  c1 = (char) *(pFrame->data[0] + y * pFrame->linesize[0] + x * 3);
	  c2 = (char) *(pFrame->data[0] + y * pFrame->linesize[0] + x * 3 + 1);
	  c3 = (char) *(pFrame->data[0] + y * pFrame->linesize[0] + x * 3 + 2);

	  c1prev = (char) *(pFramePrev->data[0] + y * pFramePrev->linesize[0] + x * 3);
	  c2prev = (char) *(pFramePrev->data[0] + y * pFramePrev->linesize[0] + x * 3 + 1);
	  c3prev = (char) *(pFramePrev->data[0] + y * pFramePrev->linesize[0] + x * 3 + 2);
	  c1tot += int (c1 + 127);
	  c2tot += int (c2 + 127);
	  c3tot += int (c3 + 127);
	  score += abs ((c1 - c1prev));
	  score += abs ((c2 - c2prev));
	  score += abs ((c3 - c3prev));
	}
    }
  int nbpx = (height * width);

  /*
   * On se ramene à la moyenne 
   */
  score /= nbpx;
  c1tot /= nbpx;
  c2tot /= nbpx;
  c3tot /= nbpx;


  /*
   * Derivee numerique 
   */
  diff = abs (score - prev_score);
  prev_score = score;

  g->push_data (score, c1tot, c2tot, c3tot);

  if (diff > this->threseold && score > this->threseold)
    {
      shot s;
      s.fbegin = frame_number;
      s.msbegin = int ((frame_number * 1000) / fps);
      s.myid = shots.back ().myid + 1;

      /*
       * Convert to ms 
       */
      shots.back ().fduration = frame_number - shots.back ().fbegin;
      shots.back ().msduration = int (((shots.back ().fduration) * 1000) / fps);


      /*
       * Create images if necessary 
       */
      if (!display || dialogParent->checkbox_1->GetValue ())
	{
	  image *im_begin = new image (this, width, height, s.myid, BEGIN, this->thumb_set, this->shot_set);
	  im_begin->SaveFrame (pFrame);
	  s.img_begin = im_begin;
	}

      if (!display || dialogParent->checkbox_2->GetValue ())
	{
	  image *im_end = new image (this, width, height, s.myid - 1, END,  this->thumb_set, this->shot_set);
	  im_end->SaveFrame (pFramePrev);
	  shots.back ().img_end = im_end;

	}
      shots.push_back (s);

      /*
       * updating display 
       */
      wxString nbshots;
      nbshots << shots.size ();
      if (display)
	{
	  wxMutexGuiEnter ();
	  dialogParent->list_films->SetItem (0, 1, nbshots);
	  wxMutexGuiLeave ();
	}
    }
}

void
film::update_metadata ()
{
  this->height = int (pFormatCtx->streams[videoStream]->codec->height);
  this->width = int (pFormatCtx->streams[videoStream]->codec->width);
  duration.secs = pFormatCtx->duration / AV_TIME_BASE;
  duration.us = pFormatCtx->duration % AV_TIME_BASE;
  duration.mstotal = int (duration.secs * 1000 + duration.us / 1000);
  duration.mins = duration.secs / 60;
  duration.secs %= 60;
  duration.hours = duration.mins / 60;
  duration.mins %= 60;

  fps = av_q2d (pFormatCtx->streams[videoStream]->r_frame_rate);
  char buf[256];
  avcodec_string (buf, sizeof (buf), pFormatCtx->streams[videoStream]->codec, 0);
  codec.video = buf;

  if (audioStream != -1)
    {
      avcodec_string (buf, sizeof (buf), pCodecCtxAudio, 0);
      codec.audio = buf;
      nchannel = pCodecCtxAudio->channels;
      samplerate = pCodecCtxAudio->sample_rate;
    }
  else
    {
      codec.audio = "null";
      nchannel = 0;
      samplerate = 0;
    }


}

void
film::shotlog (string message)
{

  if (display)
    {
      wxString mess;
      mess = wxString (wxString::FromAscii (message.c_str ()));
      wxMutexGuiEnter ();
      wxMessageDialog MsgDlg (dialogParent, mess);
      MsgDlg.ShowModal ();
      wxMutexGuiLeave ();
    }
  else
    {
      cerr << "Shot log :: " << message << endl;
    }
}

int
film::process ()
{
  int audioSize;
  uint8_t *buffer;
  uint8_t *buffer2;
  int frameFinished;
  int numBytes;

  string graphpath = this->global_path + "/" + this->alphaid;
  g = new graph (600, 400, graphpath, threseold, this);
  g->set_title ("Quantité de mouvement en fonction de la frame");

  /*
   * Register all formats and codecs 
   */
  av_register_all ();

  if (av_open_input_file (&pFormatCtx, path.c_str (), NULL, 0, NULL) != 0)
    {
      string error_msg = "Impossible d'ouvrir le fichier ";
      error_msg += path;
      shotlog (error_msg);
      return -1;		// Couldn't open file
    }

  /*
   * Retrieve stream information 
   */
  if (av_find_stream_info (pFormatCtx) < 0)
    return -1;			// Couldn't find stream information


  // dump_format (pFormatCtx, 0, path.c_str (), false);
  videoStream = -1;
  audioStream = -1;


  /*
   * Detect streams types 
   */
  for (int j = 0; j < pFormatCtx->nb_streams; j++)
    {
      switch (pFormatCtx->streams[j]->codec->codec_type)
	{
	case CODEC_TYPE_VIDEO:
	  videoStream = j;
	  break;

	case CODEC_TYPE_AUDIO:
	  audioStream = j;
	  break;

	default:
	  break;
	}
    }



  /*
   * Get a pointer to the codec context for the video stream 
   */
  if (audioStream != -1)
    {
      pCodecCtxAudio = pFormatCtx->streams[audioStream]->codec;
      pCodecAudio = avcodec_find_decoder (pCodecCtxAudio->codec_id);

      if (pCodecAudio == NULL)
	return -1;		// Codec not found
      if (avcodec_open (pCodecCtxAudio, pCodecAudio) < 0)
	return -1;		// Could not open codec
    }

  update_metadata ();
  /*
   * Find the decoder for the video stream 
   */
  if (videoStream != -1)
    {
      pCodecCtx = pFormatCtx->streams[videoStream]->codec;
      pCodec = avcodec_find_decoder (pCodecCtx->codec_id);

      if (pCodec == NULL)
	return -1;		// Codec not found
      if (avcodec_open (pCodecCtx, pCodec) < 0)
	return -1;		// Could not open codec
    }

  /*
   * Allocate video frame 
   */
  pFrame = avcodec_alloc_frame ();
  pFrameRGB = avcodec_alloc_frame ();
  pFrameRGBprev = avcodec_alloc_frame ();

  /*
   * Determine required buffer size and allocate buffer 
   */
  numBytes = avpicture_get_size (PIX_FMT_RGB24, width, height);

  /*
   * On en profite pour mettre à jour les méta données du film 
   */

  wxString fduration;
  fduration << duration.hours << wxT (":") << duration.mins << wxT (":") << duration.secs << wxT (":") << duration.us;

  if (display)
    {
      wxMutexGuiEnter ();
      dialogParent->list_films->SetItem (0, 2, fduration);
      wxMutexGuiLeave ();
    }

  buffer = (uint8_t *) malloc (sizeof (uint8_t) * numBytes);
  buffer2 = (uint8_t *) malloc (sizeof (uint8_t) * numBytes);

  /*
   * Assign appropriate parts of buffer to image planes in pFrameRGB 
   */
  avpicture_fill ((AVPicture *) pFrameRGB, buffer, PIX_FMT_RGB24, width, height);

  avpicture_fill ((AVPicture *) pFrameRGBprev, buffer2, PIX_FMT_RGB24, width, height);


  /*
   * Mise en place du premier plan 
   */
  shot s;
  s.fbegin = 0;
  s.msbegin = 0;
  s.myid = 0;
  shots.push_back (s);

  checknumber = (samplerate * samplearg) / 1000;

  /*
   * Boucle de traitement principale du flux 
   */
  while (av_read_frame (pFormatCtx, &packet) >= 0)
    {
      if (packet.stream_index == videoStream)
	{
	  avcodec_decode_video (pCodecCtx, pFrame, &frameFinished, packet.data, packet.size);
	  if (frameFinished)
	    {
	      img_convert ((AVPicture *) pFrameRGB, PIX_FMT_RGB24, (AVPicture *) pFrame, pCodecCtx->pix_fmt, width, height);


        /* Si ce n'est pas la permiere image */
	      if (pFrame->coded_picture_number)
		{   
          pFrameRGB->coded_picture_number = pFrame->coded_picture_number;
		  CompareFrame (pFrameRGB, pFrameRGBprev);
		}
	      else
		{
		  /*
		   * Cas ou c'est la premiere image, on cree la premiere image dans tous les cas 
		   */
          image *begin_i = new image (this, width, height, s.myid, BEGIN, this->thumb_set, this->shot_set);
		  begin_i->create_dir ();
	      if(audio_set)
          {
    	  string xml_audio = graphpath + "/audio.xml";
		  init_xml (xml_audio);
          }
		  
          if (!display || dialogParent->checkbox_1->GetValue ())
		    {
		      begin_i->SaveFrame (pFrameRGB);
		      shots.back ().img_begin = begin_i;
		    }
		}
	      memcpy (buffer2, buffer, numBytes);
	      if (display)
		do_stats (pFrame->coded_picture_number);
	    }
	}
      if (audio_set && (packet.stream_index == audioStream) )
	{
	  process_audio ();
	}
      /*
       * Free the packet that was allocated by av_read_frame 
       */
      if (packet.data != NULL)
	av_free_packet (&packet);
    }
   

   /* Fermetrure du fichier xml */  
   if(audio_set)   close_xml ();


  /* Mise en place de la dernière image */
  shots.back ().fduration = pFrame->coded_picture_number - shots.back ().fbegin;
  shots.back ().msduration = int (((shots.back ().fduration) * 1000) / fps);
  duration.mstotal = int (shots.back ().msduration + shots.back ().msbegin);
  if (!display || dialogParent->checkbox_2->GetValue ())
    {
      image *end_i = new image (this, width, height, shots.back ().myid, END, this->thumb_set, this->shot_set);
      end_i->SaveFrame (pFrameRGB);
      shots.back ().img_end = end_i;
    }


  /*
   * Free the RGB images 
   */
  free (buffer);
  free (buffer2);
  av_free (pFrameRGB);
  av_free (pFrame);
  av_free (pFrameRGBprev);

  /*
   * Close the codec 
   */
  avcodec_close (pCodecCtx);
  if (audioStream != -1)
    {
      avcodec_close (pCodecCtxAudio);
    }

  /*
   * Close the video file 
   */
  av_close_input_file (pFormatCtx);

  /*
   * Graphe de la qté de mvmt 
   */
  g->init_gd ();
  g->draw_all_canvas ();
  g->draw_color_datas ();
  g->draw_datas ();
  if(video_set)
  {
  string xml_color = graphpath + "/video.xml";
  g->write_xml (xml_color);
  }
  g->save ();

}

void
film::init_xml (string filename)
{
  fd_xml_audio = fopen (filename.c_str (), "w");
  fprintf (fd_xml_audio, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<iri>\n<sound sampling=\"%d\" nchannels=\"%d\">", samplearg, nchannel);
}

int
film::close_xml ()
{
  fprintf (fd_xml_audio, "</sound>\n</iri>");
  return (fclose (fd_xml_audio));
}


void
film::process_audio ()
{
  int len1;
  int len;
  int data_size;
  static unsigned int samples_size = 0;
  int i;
  uint8_t *ptr;

  ptr = packet.data;
  len = packet.size;


  while (len > 0)
    {
      this->audio_buf = (short *) av_fast_realloc (this->audio_buf, &samples_size, FFMAX (packet.size, AVCODEC_MAX_AUDIO_FRAME_SIZE));
      data_size = samples_size;
      len1 = avcodec_decode_audio2 (pCodecCtxAudio, audio_buf, &data_size, ptr, len);


      if (len1 < 0)
	{
	  /*
	   * Error, breaking the frame 
	   */
	  len = 0;
	  break;
	}

      len -= len1;
      ptr += len1;

      if (data_size > 0)
	{

	  samples += data_size / (pCodecCtxAudio->channels * 2);
	  for (i = 0; i < data_size; i += 2 * pCodecCtxAudio->channels)
	    {
	      sample_right = *((signed short int *) (audio_buf + i));
	      /*
	       * Si un seul canal, le sample droit = sample gauche 
	       */
	      if (pCodecCtxAudio->channels >= 1)
		sample_left = *((signed short int *) (audio_buf + i + 2));
	      else
		sample_left = sample_right;

	      /*
	       * extraction des minimas et maximas 
	       */
	      if (minright > sample_right)
		minright = sample_right;
	      if (maxright < sample_right)
		maxright = sample_right;
	      if (minleft > sample_left)
		minleft = sample_left;
	      if (maxleft < sample_left)
		maxleft = sample_left;

	      /*
	       * Get sample 
	       */
	      if (ech++ == checknumber)
		{
		  if (minright > minleft)
		    minright = minleft;
		  if (maxright > maxleft)
		    maxright = maxleft;
		  fprintf (fd_xml_audio, "<v c1d =\"%d\" c1u=\"%d\" />\n", minright / RATIO, maxright / RATIO);
		  minright = MAX_INT;
		  maxright = MIN_INT;
		  minleft = MAX_INT;
		  maxleft = MIN_INT;

		  /*
		   * Reset sample number 
		   */
		  ech = 0;
		}
	    }
	}
    }
}


film::film (DialogShotDetect_c * d)
{
  /*
   * Initialisation des valeurs pour le cas de la version interface
   * graphique 
   */
  myid = idfilm;
  idfilm++;
  dialogParent = d;
  progress_state_prev = dialogParent->GetGlobalProgress ();
  show_started = true;
  percent = 0;
  display = 1;
  threseold = 100;
  samplearg = 1000;
  samples = 0;
  minright = MAX_INT;
  maxright = MIN_INT;
  minleft = MAX_INT;
  maxleft = MIN_INT;
  ech = 0;
  nchannel = 1;
  audio_buf = NULL;
}


film::film (int _threseold, bool _first_img_set, bool _last_img_set,  bool _thumb_set,  bool _shot_set, bool _audio_set, bool _video_set) 
: first_img_set(_first_img_set), last_img_set(_last_img_set), thumb_set(_thumb_set), shot_set(_shot_set), video_set(_video_set), audio_set(_audio_set), percent(0), threseold(_threseold), display(0)
{
  /*
   * Initialisation des valeurs pour le cas de la version interface
   * graphique 
   */
  samplearg = 1000;
  samples = 0;
  minright = MAX_INT;
  maxright = MIN_INT;
  minleft = MAX_INT;
  maxleft = MIN_INT;
  ech = 0;
  nchannel = 1;
  audio_buf = NULL;
}
