/*
 * Copyright (C) 2007 Johan MATHE - johan.mathe@tremplin-utc.net - Centre
 * Pompidou - IRI This library is free software; you can redistribute it 
 * and/or modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either version
 * 2.1 of the License, or (at your option) any later version. This
 * library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details. You should have received a copy of the GNU
 * Lesser General Public License along with this library; if not, write to 
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA $Id: main.cpp 146 2007-04-03 15:24:27Z johmathe $ 
 */

#include <wx/wx.h>
#include <wx/image.h>
#include "DialogShotDetect_c.h"
#include <wx/cmdline.h>
#include <film.h>
#include <stdlib.h>
#include <xml.h>

class xml;
class film;

class ShotApp:public wxApp
{
public:
  virtual bool OnInit ();

};

IMPLEMENT_APP_NO_MAIN (ShotApp)
     bool ShotApp::OnInit ()
{
  DialogShotDetect_c *DialogShotDetect = new DialogShotDetect_c (0, -1, wxT (""));
  SetTopWindow (DialogShotDetect);
  DialogShotDetect->Show ();
}

void
show_help (char **argv)
{
  printf ("usage: %s \n" "Shotdetect (IRI - johmathe - $Id: main.cpp 146 2007-04-03 15:24:27Z johmathe $)\n" 
          "-n 	        : cmd line mode\n"
          "-h           : show this help\n"
          "-y year      : set the year\n"
          "-i file      : input file path\n"
          "-o path      : output path\n"
          "-a id        : id of the movie\n"
          "-x xsl path  : path of the xsl stylesheet\n"
          "-s threseold : threseold\n"
          "-w           : generate xml of waveform\n"
          "-v           : generate xml of video infos\n"
          "-f           : generate first img for each shot\n"
          "-l           : generate last img for each shot\n"
          "-m           : generate the thumb img\n"
          "-r           : generate the real img\n"
          , argv[0]);
}



int
main (int argc, char **argv)
{
  bool gui = true;
  bool ifile_set = false;
  bool ofile_set = false;
  bool id_set = false;
  bool xsl_path_set = false;
  bool first_img_set = false;
  bool last_img_set = false;
  bool thumb_set = false;
  bool shot_set = false;
  bool audio_set = false;
  bool video_set = false;
  string title = "Not set";
  string year = "Not set";
  string input_file = "Not set";
  string output_path = "Not set";
  string id_film = "Not set";
  string xsl_path = "Not set";
  int threseold = 60;
  extern char *optarg;
  extern int optind, opterr, optopt;


  for (;;)
    {
      int c = getopt (argc, argv, "?hnt:y:i:o:a:x:s:flwvmr");

      if (c < 0)
	{
	  break;
	}

      switch (c)
	{
	case '?':
	case 'h':
	  show_help (argv);
	  exit (EXIT_SUCCESS);
	  break;

	  /*
	   * Mise en place des thumbs 
	   */
	case 'f':
	  first_img_set = true;
	  break;

	case 'l':
	  last_img_set = true;
	  break;

    /* generer l'image en resolution native */
    case 'r':
      shot_set = true;
      break;


    /* generer l'image en miniature */
    case 'm':
      thumb_set = true;
      break;

    /* generer le xml pour les donnees video */
    case 'v':
      video_set = true;
      break;

    /* generer le xml pour les donnees audio */
    case 'w':
      audio_set = true;
      break;
	  /*
	   * Seuil 
	   */
	case 's':
	  threseold = atoi(optarg);
   	  break;


	  /*
	   * Id pour le chemin 
	   */
	case 'a':
	  id_film = optarg;
	  id_set = true;
	  break;

	  /*
	   * Chemin vers la feuille de style 
	   */
	case 'x':
	  xsl_path = optarg;
	  xsl_path_set = true;
	  break;

	case 'n':
	  gui = false;
	  break;

	  /*
	   * Recuperation du titre 
	   */
	case 't':
	  title = optarg;
	  break;

	  /*
	   * Recuperation de l'annee 
	   */
	case 'y':
	  year = optarg;
	  break;

	case 'i':
	  input_file = optarg;
	  ifile_set = true;
	  break;

	case 'o':
	  output_path = optarg;
	  ofile_set = true;
	  break;

	default:
	  break;
	}

    }

  if (!gui)
    {
      /*
       * Traitement des erreurs 
       */
      if (!ifile_set || !ofile_set || !id_set || !xsl_path_set)
	{
	  if (!ifile_set)
	    {
        cerr << "please spec an input file" << endl;
        show_help(argv);
        }
	  if (!ofile_set)
	    {
        cerr << "please spec an output path" << endl;
        show_help(argv);
        }
	  if (!id_set)
        {
	    cerr << "please spec an alphanumeric id" << endl;
        show_help(argv);
        }
	  if (!xsl_path_set)
	  {
        cerr << "please spec an xsl path" << endl;
        show_help(argv);
        }
	  exit (EXIT_FAILURE);
	}


      film f = film (threseold, first_img_set,last_img_set,thumb_set,shot_set,audio_set, video_set);
      xml *x = new xml (&f);
      x->set_xsl_path (xsl_path);


      /*
       * extraction du nom de la feuille de style sans l'extension 
       */
#ifdef __WINDOWS__
      x->xsl_name.assign (x->xsl_path, x->xsl_path.rfind ("\\") + 1, x->xsl_path.rfind (".") - x->xsl_path.rfind ("\\") - 1);
#else
      x->xsl_name.assign (x->xsl_path, x->xsl_path.rfind ("/") + 1, x->xsl_path.rfind (".") - x->xsl_path.rfind ("/") - 1);
#endif

      f.x = x;

      f.set_file (input_file);
      f.set_alphaid (id_film);
      f.set_output_path (output_path);
      f.process ();

      string xml_path = f.alphaid;
      xml_path += "_";
      xml_path += f.x->xsl_name;
      xml_path += ".xml";

      string xml_own_path = f.alphaid;
      xml_own_path += ".xml";
      f.x->write_data (xml_own_path);
      f.x->apply_xsl (xml_path);
    }
  else
    {
      /*
       * Entree dans la version graphique 
       */
      wxEntry (argc, argv);
      return true;
    }
  exit (0);
}
