/*
 * $Id: film.h 143 2007-04-03 14:43:56Z johmathe $
 * $Date: 2007-04-03 16:43:56 +0200 (mar, 03 avr 2007) $
 */
#ifndef __FILM_H__
#define __FILM_H__

#ifndef INT64_C
#define INT64_C(c) (c ## LL)
#define UINT64_C(c) (c ## ULL)
#endif 


#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <list>
#include <ffmpeg/swscale.h>


#include <ffmpeg/avcodec.h>
#include <ffmpeg/avformat.h>

#ifdef BDD
#include <postgresql/libpq-fe.h>
#endif
#include <wx/wx.h>

#include "image.h"
#include "shot.h"
#include "xml.h"
#include "graph.h"

#include <string>
#include <iostream>

#define MAX_STR 254
#define MAX_CUTS 200
#define abs(x) ((x) < 0 ? - (x) : (x))
#define HAVE_THREADS
#define MAX_QUERY 400

#define DEFAULT_BDD_PORT 5432
#define DEFAULT_THUMB_HEIGHT 85

#define RATIO 327
#define MIN_INT -32768
#define MAX_INT 32767



using namespace std;

class image;
class conf;
class shot;
class xml;
class DialogShotDetect_c;
class graph;
class film
{

private:
/* Variables d'état */
  bool first_img_set ;
  bool last_img_set ;
  bool audio_set;
  bool video_set;


  unsigned int ech;
  signed short int minright;
  signed short int maxright;
  signed short int minleft;
  signed short int maxleft;


/* Various data for ffmpeg */
  AVFormatContext *pFormatCtx;
  AVCodecContext *pCodecCtx;
  AVCodecContext *pCodecCtxAudio;
  AVCodec *pCodec;
  AVCodec *pCodecAudio;
  AVFrame *pFrame;
  AVFrame *pFrameRGB;
  AVFrame *pFrameRGBprev;
  AVPacket packet;

  FILE *fd_xml_audio;

  int samples;
  int data_size;
  uint8_t *ptr;

  int len1;
  int len;
  int samplerate;
  int checknumber;

  /* Mem allocation */
  short *audio_buf;
  signed short int sample_right;
  signed short int sample_left;
  int ret;
  int audioStream;
  int videoStream;

  int samplearg;

  void do_stats (int frame);
  void CompareFrame (AVFrame * pFrame, AVFrame * pFramePrev);
  graph *g;

void update_metadata();
void init_xml (string filename);
  int close_xml ();
public:
  bool thumb_set ;
  bool shot_set ;


    DialogShotDetect_c * dialogParent;
  struct
  {
    int id;
    string name;
    string surname;
  } author;

  struct
  {
    string video;
    string audio;
  } codec;

  struct
  {
    int hours;
    int mins;
    int secs;
    int us;
    double mstotal;
  } duration;

  int myid;
  static int idfilm;

  int progress_state_prev;
  /* Nom du film */
  string film_name;
  /* Title of the movie */
  string title;
  /* Abstract of the movie */
  string abstract;
  /* Path to the film */
  string path;
  /* Film height */
  int height;
  /* Film width */
  int width;
  /* Film fps */
  double fps;
  /* Number of audio chanels */
  int nchannel;
  /* Year of the movie */
  int year;
  /* Shots */
    list < shot > shots;
  /* Prev Score in compare_frame */
  int prev_score;
  /* ID BDD Film */
  int id;
  /* id du plan en cours de traitement */
  int id_plan;
  /* Code de la langue */
  string code_lang;
  /* Seuil de traitement */
  int threseold;
  /* Id alphanumérique du film */
  string alphaid;
  /* Chemin absolu */
  string global_path;
  /* Percent accomplished */
  double percent;
  /* Showing state started */
  bool show_started;
  xml *x;
  int process ();
  bool display;
  /* Constructeur */
  film (DialogShotDetect_c *);
  film (int _threseold, bool _first_img_set, bool _last_img_set,  bool _thumb_set,  bool _shot_set, bool _audio_set, bool _video_set);
  void process_audio ();
  inline void set_file(string input_file) { this->path = input_file; };
  inline void set_alphaid(string alphaid_arg) { this->alphaid = alphaid_arg; };
  inline void set_output_path(string output_path) { this->global_path = output_path; };
  void shotlog(string message);
};


#endif /* !__FILM_H__ */
