/* Copyright (C) 2007 Johan MATHE - johan.mathe@tremplin-utc.net -  Centre Pompidou - IRI 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 * $Id: film.cpp 114 2007-02-21 09:58:30Z johmathe $
 * $Date: 2007-02-21 10:58:30 +0100 (mer, 21 fv 2007) $
 */
#include "film.h"
#include "DialogShotDetect_c.h"
#include "graph.h"

#include <wx/thread.h>
#include <wx/msgdlg.h>

int
  film::idfilm = 0;

void
film::do_stats (int frame, AVFormatContext * ic)	//, wxWindow *dialogParent)
{
  int secs = ic->duration / AV_TIME_BASE;
  double perctmp = percent;
  struct timeval time_now;
  struct timezone timezone;
  gettimeofday (&time_now, &timezone);
  double time_elapsed =
    (double (time_now.tv_usec) / 1000000 +
     double (time_now.tv_sec)) -(double (dialogParent->time_start.tv_usec) /
				 1000000 +
				 double (dialogParent->time_start.tv_sec));
  wxMutexGuiEnter ();
  dialogParent->set_time_elapsed (time_elapsed);
  wxMutexGuiLeave ();
  percent = ((frame * 100) / (fps * secs));
  if ((int) percent != (int) perctmp || !show_started)
    {
      double val_global = percent / idfilm + double (progress_state_prev);
      wxMutexGuiEnter ();
      dialogParent->set_progress_local (percent);
      dialogParent->set_progress_global (val_global);
      wxMutexGuiLeave ();
    }
  show_started = 1;
}


void
film::CompareFrame (AVFrame * pFrame, AVFrame * pFramePrev, int width,
		    int height, int i)
{
  int y;
  int x;
  int diff;
  char c1, c2, c3;
  int c1tot, c2tot, c3tot;
  c1tot = 0;
  c2tot = 0;
  c3tot = 0;
  char c1prev, c2prev, c3prev;
  int score;
  score = 0;
  for (y = 0; y < height; y++)
    {
      for (x = 0; x < width; x++)
	{

	  c1 = (char) *(pFrame->data[0] + y * pFrame->linesize[0] + x * 3);
	  c2 =
	    (char) *(pFrame->data[0] + y * pFrame->linesize[0] + x * 3 + 1);
	  c3 =
	    (char) *(pFrame->data[0] + y * pFrame->linesize[0] + x * 3 + 2);

	  c1prev =
	    (char) *(pFramePrev->data[0] + y * pFramePrev->linesize[0] +
		     x * 3);
	  c2prev =
	    (char) *(pFramePrev->data[0] + y * pFramePrev->linesize[0] +
		     x * 3 + 1);
	  c3prev =
	    (char) *(pFramePrev->data[0] + y * pFramePrev->linesize[0] +
		     x * 3 + 2);
	  c1tot += int (c1 + 127);
	  c2tot += int (c2 + 127);
	  c3tot += int (c3 + 127);
	  score += abs ((c1 - c1prev));
	  score += abs ((c2 - c2prev));
	  score += abs ((c3 - c3prev));
	}
    }
  int nbpx = (height * width);
  score /= nbpx;
  c1tot /= nbpx;
  c2tot /= nbpx;
  c3tot /= nbpx;
  diff = abs (score - prev_score);
  prev_score = score;
  g->push_data (diff, c1tot, c2tot, c3tot);

  if (diff > this->threseold && score > this->threseold)
    {
      shot s;
      s.fbegin = i;
      s.msbegin = int ((i * 1000) / fps);
      s.myid = shots.back ().myid + 1;

      /* Convert to ms */
      shots.back ().fduration = i - shots.back ().fbegin;
      shots.back ().msduration =
	int (((shots.back ().fduration) * 1000) / fps);


      /* Create images if necessary */
      if (!display || dialogParent->checkbox_1->GetValue ())
	{
	  image *im_begin = new image (this, width, height, s.myid, BEGIN);
	  im_begin->SaveFrame (pFrame);
	  s.img_begin = im_begin;
	}

      if (!display || dialogParent->checkbox_2->GetValue ())
	{
	  image *im_end = new image (this, width, height, s.myid - 1, END);
	  im_end->SaveFrame (pFramePrev);
	  shots.back ().img_end = im_end;

	}
      shots.push_back (s);

      /* updating display */
      wxString nbshots;
      nbshots << shots.size ();
      if (display)
	{
	  wxMutexGuiEnter ();
	  dialogParent->list_films->SetItem (0, 1, nbshots);
	  wxMutexGuiLeave ();
	}
    }
}
int
film::process ()
{
  int i, videoStream, audioStream;

  AVFormatContext *pFormatCtx;
  AVCodecContext *pCodecCtx;
  AVCodecContext *pCodecCtxAudio;
  AVCodec *pCodec;
  AVFrame *pFrame;
  AVFrame *pFrameRGB;
  AVFrame *pFrameRGBprev;
  AVPacket packet;

  uint8_t *buffer;
  uint8_t *buffer2;

  int frameFinished;
  int numBytes;

  char *str;
  string graphpath = this->global_path + "/" + this->alphaid;
  g = new graph (600, 400, graphpath);
  g->set_title ("Quantit de mouvement en fonction de la frame");

  /* Register all formats and codecs */
  av_register_all ();


  if (av_open_input_file (&pFormatCtx, path.c_str (), NULL, 0, NULL) != 0)
    {
      if (display)
	{
	  wxMutexGuiEnter ();
	  wxMessageDialog MsgDlg (dialogParent,
				  _T ("Impossible d'ouvrir le fichier !"));
	  MsgDlg.ShowModal ();
	  wxMutexGuiLeave ();
	}
      else
	{
	  cerr << "Impossible d'ouvrir le fichier" << path << endl;
	}
      return -1;		// Couldn't open file
    }
  /* Retrieve stream information */

  if (av_find_stream_info (pFormatCtx) < 0)
    return -1;			// Couldn't find stream information


  dump_format (pFormatCtx, 0, path.c_str (), false);
  /* Find the first video stream */
  videoStream = -1;
  audioStream = -1;
  for (i = 0; i < pFormatCtx->nb_streams; i++)
    {
      if (pFormatCtx->streams[i]->codec->codec_type == CODEC_TYPE_VIDEO)
	{
	  videoStream = i;
	}
      if (pFormatCtx->streams[i]->codec->codec_type == CODEC_TYPE_AUDIO)
	{
	  audioStream = i;
	}
    }
  if (videoStream == -1)
    return -1;			// Didn't find a video stream
  // Get a pointer to the codec context for the video stream
  pCodecCtx = pFormatCtx->streams[videoStream]->codec;
  if (audioStream != -1)
    {
      pCodecCtxAudio = pFormatCtx->streams[audioStream]->codec;
    }
  // Find the decoder for the video stream
  pCodec = avcodec_find_decoder (pCodecCtx->codec_id);
  if (pCodec == NULL)
    return -1;			// Codec not found
  // Open codec
  if (avcodec_open (pCodecCtx, pCodec) < 0)
    return -1;			// Could not open codec

  /* Allocate video frame */
  pFrame = avcodec_alloc_frame ();

  /* Allocate an AVFrame structure */
  pFrameRGB = avcodec_alloc_frame ();
  pFrameRGBprev = avcodec_alloc_frame ();
  if (pFrameRGB == NULL)
    return -1;

  /* Determine required buffer size and allocate buffer */
  numBytes = avpicture_get_size (PIX_FMT_RGB24, pCodecCtx->width,
				 pCodecCtx->height);
  /* On en profite pour mettre  jour les mta donnes du film */
  height = pCodecCtx->height;
  width = pCodecCtx->width;

  if (pFormatCtx->duration != AV_NOPTS_VALUE)
    {
      duration.secs = pFormatCtx->duration / AV_TIME_BASE;
      duration.us = pFormatCtx->duration % AV_TIME_BASE;
      duration.mstotal = int (duration.secs * 1000 + duration.us / 1000);
      duration.mins = duration.secs / 60;
      duration.secs %= 60;
      duration.hours = duration.mins / 60;
      duration.mins %= 60;
    }
  else
    {
      duration.secs = 0;
      duration.us = 0;
      duration.mins = 0;
      duration.hours = 0;
      duration.mstotal = 0;
    }
  wxString fduration;
  fduration << duration.hours << wxT (":") << duration.
    mins << wxT (":") << duration.secs << wxT (":") << duration.us;

  if (display)
    {
      wxMutexGuiEnter ();
      dialogParent->list_films->SetItem (0, 2, fduration);
      wxMutexGuiLeave ();
    }


  buffer = (uint8_t *) malloc (sizeof (uint8_t) * numBytes);
  buffer2 = (uint8_t *) malloc (sizeof (uint8_t) * numBytes);

  /* Assign appropriate parts of buffer to image planes in pFrameRGB */
  avpicture_fill ((AVPicture *) pFrameRGB, buffer, PIX_FMT_RGB24,
		  pCodecCtx->width, pCodecCtx->height);

  avpicture_fill ((AVPicture *) pFrameRGBprev, buffer2, PIX_FMT_RGB24,
		  pCodecCtx->width, pCodecCtx->height);


  /* Cration des rpertoires pour les images */
  fps = av_q2d (pFormatCtx->streams[videoStream]->r_frame_rate);
  char buf[256];
  avcodec_string (buf, sizeof (buf), pCodecCtx, 0);
  codec.video = buf;

  if (audioStream != -1)
    {
      avcodec_string (buf, sizeof (buf), pCodecCtxAudio, 0);
      codec.audio = buf;
    }
  else
    {
      codec.audio = "null";
    }

  /* Read frames and save first five frames to disk */
  i = 0;
  shot s;
  s.fbegin = 0;
  s.msbegin = 0;
  s.myid = 0;
  shots.push_back (s);



  while (av_read_frame (pFormatCtx, &packet) >= 0)
    {
      if (packet.stream_index == videoStream)
	{
	  avcodec_decode_video (pCodecCtx, pFrame, &frameFinished,
				packet.data, packet.size);
	  if (frameFinished)
	    {
	      img_convert ((AVPicture *) pFrameRGB, PIX_FMT_RGB24,
			   (AVPicture *) pFrame, pCodecCtx->pix_fmt,
			   pCodecCtx->width, pCodecCtx->height);

	      if (i)
		{
		  CompareFrame (pFrameRGB, pFrameRGBprev, pCodecCtx->width,
				pCodecCtx->height, i);
		}
	      else
		{
		  /* Cas ou c'est la premiere image */
		  image *begin_i =
		    new image (this, width, height, s.myid, BEGIN);
		  begin_i->create_dir ();
		  if (!display || dialogParent->checkbox_1->GetValue ())
		    {
		      begin_i->SaveFrame (pFrameRGB);
		      shots.back ().img_begin = begin_i;
		    }
		}
	      memcpy (buffer2, buffer, numBytes);
	      if (display)
		do_stats (i, pFormatCtx);

	      i++;
	    }
	}
      shots.back ().fduration = i - shots.back ().fbegin;
      shots.back ().msduration =
	int (((shots.back ().fduration) * 1000) / fps);


      /* Free the packet that was allocated by av_read_frame */
//      av_free_packet (&packet);
    }



  if (!display || dialogParent->checkbox_2->GetValue ())
    {
      image *end_i = new image (this, width, height, shots.back ().myid, END);
      end_i->SaveFrame (pFrameRGB);
      shots.back ().img_end = end_i;
    }


  /* Free the RGB images */
  free (buffer);
  free (buffer2);
  av_free (pFrameRGB);
  av_free (pFrame);
  av_free (pFrameRGBprev);

  /* Close the codec */
  avcodec_close (pCodecCtx);
  if (audioStream != -1)
    {
//      avcodec_close (pCodecCtxAudio);
    }

  /* Close the video file */
  av_close_input_file (pFormatCtx);


  /* Graphe de la qt de mvmt */
  g->init_gd ();
  g->draw_all_canvas ();
  g->draw_color_datas ();
  g->draw_datas ();
  g->save ();


}



film::film (DialogShotDetect_c * d)
{
  myid = idfilm;
  idfilm++;
  dialogParent = d;
  progress_state_prev = dialogParent->GetGlobalProgress ();
  show_started = true;
  percent = 0;
  display = 1;
  threseold = 100;
}


film::film ()
{
  percent = 0;
  threseold = 100;
  display = 0;
}
