/* Copyright (C) 2007 Johan MATHE - johan.mathe@tremplin-utc.net -  Centre Pompidou - IRI 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * $Id: main.cpp 114 2007-02-21 09:58:30Z johmathe $
 */

#include <wx/wx.h>
#include <wx/image.h>
#include "DialogShotDetect_c.h"
#include <wx/cmdline.h>
#include <film.h>
#include <stdlib.h>
#include <xml.h>

class xml;
class film;
const wxCmdLineEntryDesc gCmdLineDesc[] = {
  {wxCMD_LINE_SWITCH, wxT ("h"), wxT ("help"), wxT ("Display usage info"),
   wxCMD_LINE_VAL_NONE, wxCMD_LINE_OPTION_HELP},
  {wxCMD_LINE_SWITCH, wxT ("n"), wxT ("nodisplay"),
   wxT ("whithout graphical interface"), wxCMD_LINE_VAL_NONE, 0},
  {wxCMD_LINE_OPTION, wxT ("o"), wxT ("output"), wxT ("Output path"),
   wxCMD_LINE_VAL_STRING, 0},
   {wxCMD_LINE_OPTION, wxT ("a"), wxT ("alphaid"), wxT ("Alpha id"),
   wxCMD_LINE_VAL_STRING, 0},
  {wxCMD_LINE_OPTION, wxT ("i"), wxT ("input"), wxT ("Input file"),
   wxCMD_LINE_VAL_STRING, 0},
  {wxCMD_LINE_OPTION, wxT ("x"), wxT ("xsl"), wxT ("Path to xsl file"),
   wxCMD_LINE_VAL_STRING, 0},
  {wxCMD_LINE_OPTION, wxT ("c"), wxT ("name"), wxT ("Author's name"),
   wxCMD_LINE_VAL_STRING, 0},
  {wxCMD_LINE_OPTION, wxT ("s"), wxT ("surname"), wxT ("Author's surname"),
   wxCMD_LINE_VAL_STRING, 0},
  {wxCMD_LINE_OPTION, wxT ("b"), wxT ("abstract"), wxT ("Abstract"),
   wxCMD_LINE_VAL_STRING, 0},
  {wxCMD_LINE_OPTION, wxT ("y"), wxT ("year"), wxT ("Year"),
   wxCMD_LINE_VAL_STRING, 0},
  {wxCMD_LINE_OPTION, wxT ("t"), wxT ("title"), wxT ("Title of the movie"),
   wxCMD_LINE_VAL_STRING, 0},
  {wxCMD_LINE_OPTION, wxT ("s"), wxT ("seuil"), wxT ("Threseold"),
   wxCMD_LINE_VAL_STRING, 0},
  {wxCMD_LINE_NONE, NULL, NULL, NULL, wxCMD_LINE_VAL_NONE, 0},

};

class ShotApp:public wxApp
{
public:
  virtual bool OnInit ();

};


IMPLEMENT_APP_NO_MAIN(ShotApp) 
//IMPLEMENT_APP (ShotApp)
bool ShotApp::OnInit () {
      DialogShotDetect_c *DialogShotDetect =
    new DialogShotDetect_c (0, -1, wxT (""));
      SetTopWindow (DialogShotDetect);
      DialogShotDetect->Show ();

 }


int main(int argc, char **argv)
{
//  wxInitAllImageHandlers ();
  wxCmdLineParser parser(gCmdLineDesc, argc, argv);
  parser.Parse (true);
  int silent_mode = parser.Found (wxT ("n"));

  if (!silent_mode)
    { 
      wxEntry(argc,argv);
      return true;
    }
  else
    {
      /* Cas sans interface graphique */

      film f = film ();
        xml *x = new xml (&f);
      f.x = x; 

      wxString *wxc = new wxString;


      if (parser.Found (wxT ("title"), wxc))
    {
      f.title = wxc->ToAscii ();
      cout << "title : " << f.title << endl;
    }
      else 
    {
      cerr << "Please enter movie title.";
      exit (EXIT_FAILURE);
    }


      cout << "le titre : " << f.title << endl;

      /* Parsing cmd line args */
      if (parser.Found (wxT ("input"), wxc))
	{
	  f.path = wxc->ToAscii ();
	  cout << "Path : " << f.path << endl;
	}
      else
	{
	  cerr << "Please enter movie path.";
	  exit (EXIT_FAILURE);
	}


      if (parser.Found (wxT ("abstract"), wxc))
	{
	  f.abstract = wxc->ToAscii ();
	  cout << "abstract : " << f.abstract << endl;
	}
      else
	{
	  cerr << "Please enter movie abstract.";
	  exit (EXIT_FAILURE);
	}


      if (parser.Found (wxT ("year"), wxc))
	{
	  f.year = atoi (wxc->ToAscii ());
	  cout << "year : " << f.year << endl;
	}
      else
	{
	  cerr << "Please enter movie year.";
	  exit (EXIT_FAILURE);
	}


      if (parser.Found (wxT ("seuil"), wxc))
	{
	  f.threseold = atoi (wxc->ToAscii ());
	  cout << "threseold : " << f.threseold << endl;
	}
      else
	{
	  cerr << "Please enter movie threseold.";
	  exit (EXIT_FAILURE);
	}

      if (parser.Found (wxT ("surname"), wxc))
	{
	  f.author.surname = atoi (wxc->ToAscii ());
	  cout << "threseold : " << f.author.surname << endl;
	}
      else
	{
	  cerr << "Please enter author's surname.";
	  exit (EXIT_FAILURE);
	}


      if (parser.Found (wxT ("name"), wxc))
	{
	  f.author.name = wxc->ToAscii ();
	  cout << "name : " << f.author.name << endl;
	}
      else
	{
	  cerr << "Please enter author's name.";
	  exit (EXIT_FAILURE);
	}

      if (parser.Found (wxT ("xsl"), wxc))
	{
	  f.x->xsl_path = wxc->ToAscii ();
	  f.x->xsl_name.assign (f.x->xsl_path, f.x->xsl_path.rfind ("/") + 1,
				f.x->xsl_path.rfind (".") -
				f.x->xsl_path.rfind ("/") - 1);
	  cout << "xsl name: " << f.x->xsl_name << endl;
	}
      else
	{
	  cerr << "Please enter the path of the xsl file.";
	  exit (EXIT_FAILURE);
	}

         if (parser.Found (wxT ("alphaid"), wxc))
    {
      f.alphaid = wxc->ToAscii ();
      cout << "alpha id: " << f.alphaid << endl;
    }
      else
    {
      cerr << "Please enter the id.";
      exit (EXIT_FAILURE);
    }

    if (parser.Found (wxT ("output"), wxc))
    {
      f.global_path = wxc->ToAscii ();
      cout << "output path: " << f.global_path << endl;
    }
      else
    {
      cerr << "Please enter the output path.";
      exit (EXIT_FAILURE);
    }

      f.process ();
      struct stat *buf = NULL;
      buf = (struct stat *) malloc (sizeof (struct stat));
      if ((stat ((const char *) x->xsl_path.c_str (), buf) == -1)
	  || !S_ISREG (buf->st_mode))
	{
	   cerr << "Impossible de trouver le fichier XSL !";
      exit(0);
 	}

 f.process ();

 string xml_path = f.alphaid;
      xml_path += "_";
      xml_path += f.x->xsl_name;
      xml_path += ".xml";

      string xml_own_path = f.alphaid;
      xml_own_path += ".xml";
      f.x->write_data (xml_own_path);
      f.x->apply_xsl (xml_path);


    }
  exit (0);
}
