function setupRenkan() {
    var renkan = new Rkns.Renkan({
        autoscale_padding: 150,
        manual_save: true,
        show_bookmarklet: false,
        show_user_list: false,
        show_open_button: true,
        bins: [],
        property_files: ["properties.json"],
        search: [
            {
                type: "Ldt"
            },
            {
                type: "Wikipedia",
                lang: "fr"
            }, 
            {
                type: "Twitter"
            }
        ],
        user_id: "u-iri",
        language: "fr",
        static_url: static_url
    });
    
    var gui = require("nw.gui"),
        win = gui.Window.get(),
        fs = require("fs"),
        currentFile = false,
        menubar = new gui.Menu({type: "menubar"});
    
    function notify(text) {
        $(".Rk-Notifications").text(text).fadeIn().delay(5000).fadeOut();
    }
    
    function clearNotifications() {
        $(".Rk-Notifications").stop().hide();
    }
    
    function showOpenDialog() {
        clearNotifications();
        $(".Nw-Open-Dialog").click();
    }
    
    function showSaveDialog() {
        clearNotifications();
        $(".Nw-Save-Dialog").click();
    }
    
    function saveCurrentFile() {
        var jsondata = renkan.project.toJSON();
        fs.writeFile(currentFile, JSON.stringify(jsondata), 'utf-8', function(err) {
            if (err) {
                notify("Impossible d'écrire le fichier \"" + currentFile.match(/[^\\\/]+$/)[0] + '"');
                currentFile = false;
            } else {
                notify("Le fichier \"" + currentFile.match(/[^\\\/]+$/)[0] + "\" a bien été enregistré");
            }
        });
    }
    
    function saveFunction() {
        clearNotifications();
        if (currentFile) {
            saveCurrentFile();
        } else {
            showSaveDialog();
        }
    }
    
    function toggleFullscreen() {
        win.toggleFullscreen();
    }
    
    $(".Nw-Open-Dialog").change(function() {
        currentFile = $(this).val();
        fs.readFile(currentFile, 'utf-8', function(err, d) {
            try {
                if (!err) {
                    console.log(d);
                    var jsondata = JSON.parse(d);
                    renkan.project.set(jsondata, {validate: true});
                    renkan.renderer.autoScale();
                }
            } catch(e) {
                notify('"' + currentFile.match(/[^\\\/]+$/)[0] + '" n\'est pas un fichier Renkan valide');
                currentFile = false;
            }
        });
    });
    
    $(".Nw-Save-Dialog").change(function() {
        currentFile = $(this).val();
        saveCurrentFile();
    });
    
    var fileMenu = new gui.Menu();
    
    fileMenu.append(new gui.MenuItem({
        label: 'Ouvrir un fichier Renkan',
        click: showOpenDialog
    }));
    
    fileMenu.append(new gui.MenuItem({
        label: 'Enregistrer',
        click: saveFunction
    }));
    
    fileMenu.append(new gui.MenuItem({
        label: 'Enregistrer sous',
        click: showSaveDialog
    }));
    
    fileMenu.append(new gui.MenuItem({
        type: "separator"
    }));
    
    fileMenu.append(new gui.MenuItem({
        label: 'Quitter',
        click: function() {
            win.close();
        }
    }));
    
    menubar.append(new gui.MenuItem({
        label: "Fichier",
        submenu: fileMenu
    }));
    
    win.menu = menubar;
    
    renkan.renderer.fullScreen = toggleFullscreen;
    renkan.renderer.open = showOpenDialog;
    renkan.renderer.save = saveFunction;
    
    $(window).keydown(function(e) {
        if (e.ctrlKey || e.metaKey) {
            switch(e.keyCode) {
                case 83: // S
                    if (e.shiftKey) {
                        showSaveDialog();
                    } else {
                        saveFunction();
                    }
                break;
                case 79: // O
                    showOpenDialog();
                break;
                case 70: // F
                    toggleFullscreen();
                break;
            }
        }
    });
    
    $(".Rk-Save-Button .Rk-TopBar-Tooltip-Contents").append(" [Ctrl-S]");
    $(".Rk-Open-Button .Rk-TopBar-Tooltip-Contents").append(" [Ctrl-O]");
    $(".Rk-FullScreen-Button .Rk-TopBar-Tooltip-Contents").append(" [Ctrl-F]");
    
    renkan.project.on("change:title", function() {
        var t = renkan.project.get("title");
        $("title").text('Édition de ' + ( t ? ( '« ' + t + ' »' ) : "Renkan sans titre" ));
    });
    
    $("#renkan").on("click", ".Rk-Edit-Goto", function() {
        var dest = $(this).attr("href");
        if (dest && dest !== "#") {
            gui.Window.open(dest);
        }
        return false; 
    });

}
       
$(setupRenkan);
