define(['jquery', 'underscore', 'requtils', 'renderer/baserepresentation'], function ($, _, requtils, BaseRepresentation) {
    'use strict';

    var Utils = requtils.getUtils();

    /* Rkns.Renderer.View Class */

    /* The representation for the view. */

    var ViewRepr = Utils.inherit(BaseRepresentation);

    _(ViewRepr.prototype).extend({
        _init: function() {
            var _this = this;
            this.$ = $(".Rk-Render");
            this.type = "View";
            this.hiddenNodes = [];
            
//            this.$.find(".Rk-ZoomSetSaved").click( function() {
//                var view = _this.renkan.project.get("views").last();
//                if(view){
//                    //_this.setScale(view.get("zoom_level"), new paper.Point(view.get("offset")));
                _this.showNodes(false);
                if (this.options.hide_nodes){
                    this.hiddenNodes = (this.model.get("hidden_nodes") || []).concat();
                    this.hideNodes();                    
                }
//                }
//            });
            
            this.$.find(".Rk-ShowHiddenNodes").mouseenter( function() {
                _this.showNodes(true);
                _this.$.find(".Rk-ShowHiddenNodes").mouseleave( function() {
                    _this.hideNodes();
                });
            });
            this.$.find(".Rk-ShowHiddenNodes").click( function() {
                _this.showNodes(false);
                _this.$.find(".Rk-ShowHiddenNodes").off( "mouseleave" ); 
            });
            if(this.renkan.project.get("views").length > 0 && this.renkan.options.save_view){
                this.$.find(".Rk-ZoomSetSaved").show();
            }
        },
        redraw: function(options) {
        },
        addHiddenNode: function(_model){
            this.hideNode(_model);
            this.hiddenNodes.push(_model.id);
        },
        hideNode: function(_model){
            if (typeof this.renderer.getRepresentationByModel(_model) !== 'undefined'){
                this.renderer.getRepresentationByModel(_model).hide();
            }
        },
        hideNodes: function(){
            var _this = this;
            this.hiddenNodes.forEach(function(_id, index){
                var node = _this.renkan.project.get("nodes").get(_id);
                if (typeof node !== 'undefined'){
                    return _this.hideNode(_this.renkan.project.get("nodes").get(_id));
                }else{
                    _this.hiddenNodes.splice(index, 1);
                }
            });
            paper.view.draw();
        },
        showNodes: function(ghost){
            var _this = this;
            this.hiddenNodes.forEach(function(_id){
                _this.renderer.getRepresentationByModel(_this.renkan.project.get("nodes").get(_id)).show(ghost);
            });
            if (!ghost){
                this.hiddenNodes = [];
            }
            paper.view.draw();
        },
    }).value();

    return ViewRepr;

});
