package org.iri_research.renkan.repositories;

import java.util.Date;

import org.iri_research.renkan.models.Project;
import org.iri_research.renkan.models.ProjectRevision;
import org.springframework.stereotype.Component;

@Component
public class ProjectRevisionsRepositoryImpl implements
		ProjectRevisionsRepositoryCustom {
	
	@Override
	public ProjectRevision getProjectRevision(Project project, int revision) {
		ProjectRevision pr = new ProjectRevision(
				project.getTitle(),
				project.getDescription(),
				project.getUri(),
				project,
				revision,
				new Date(System.currentTimeMillis())
		);
		
		return pr;
	}

}
