'''
Created on Jul 17, 2014
Reworked in December, 2015

@author: tc, nd
'''
import uuid

from django.conf import settings
from django.db import models
from django.http import Http404


auth_user_model = getattr(settings, 'AUTH_USER_MODEL', 'auth.User')

class Workspace(models.Model):
    
    workspace_guid = models.CharField(max_length=1024, default=uuid.uuid4, unique=True, blank=False, null=False) # typically UUID
    title = models.CharField(max_length=1024, null=True)
    creator = models.ForeignKey(auth_user_model, blank=True, null=True, related_name="workspace_creator")
    creation_date = models.DateTimeField(auto_now_add=True)
    
    @property
    def renkan_count(self):
        return Renkan.objects.filter(workspace_guid=self.workspace_guid).count()
    
    class Meta:
        app_label = 'renkanmanager'
        permissions = (
            ('view_workspace', 'Can view workspace'),
        )

class Renkan(models.Model):
    
    renkan_guid = models.CharField(max_length=256, default=uuid.uuid4, unique=True, blank=False, null=False) # typically UUID
    workspace_guid = models.CharField(max_length=256, blank=True, null=True)
    current_revision_guid = models.CharField(max_length=256, blank=True, null=True)
    source_revision_guid = models.CharField(max_length=256, blank=True, null=True)
    creator = models.ForeignKey(auth_user_model, blank=True, null=True, related_name="renkan_creator")
    creation_date = models.DateTimeField(auto_now_add=True)
    state = models.IntegerField(default=1)
    
    @property
    def revision_count(self):
        return Revision.objects.filter(parent_renkan_guid=self.renkan_guid).count()
    
    @property
    def is_copy(self):
        return bool(self.source_revision_guid)
    
    # Current revision title
    @property
    def title(self):
        current_revision = Revision.objects.get(revision_guid = self.current_revision_guid)
        return current_revision.title
    
    # Current revision content
    @property
    def content(self):
        current_revision = Revision.objects.get(revision_guid = self.current_revision_guid)
        return current_revision.content
    
    class Meta:
        app_label = 'renkanmanager'
        permissions = (
            ('view_renkan', 'Can view renkan'),
        )

class Revision(models.Model):
    
    revision_guid = models.CharField(max_length=256, default=uuid.uuid4, unique=True) # typically UUID
    parent_renkan_guid = models.CharField(max_length=256)
    title = models.CharField(max_length=1024, null=True)
    content = models.TextField(blank=True, null=True)
    creator = models.ForeignKey(auth_user_model, blank=True, null=True, related_name="revision_creator")
    last_updated_by = models.ForeignKey(auth_user_model, blank=True, null=True, related_name="revision_last_updated_by")
    creation_date = models.DateTimeField(auto_now_add=True)
    modification_date = models.DateTimeField(auto_now=True)
    
    @property
    def is_current_revision(self):
        try:
            parent_project = Renkan.objects.get(renkan_guid=self.parent_renkan_guid)
        except Renkan.DoesNotExist: # SHOULD NOT HAPPEN!
            raise Http404
        return parent_project.current_revision_guid == self.revision_guid
    
    class Meta:
        app_label = 'renkanmanager'
        permissions = (
            ('view_revision', 'Can view revision'),
        )       

