"use strict";

define(['jquery', 'underscore', 'requtils', 'renderer/basebutton'], function ($, _, requtils, BaseButton) {
    
    var Utils = requtils.getUtils();

    /* EdgeRemoveButton Begin */

    //var EdgeRemoveButton = Renderer.EdgeRemoveButton = Utils.inherit(Renderer._BaseButton);
    var EdgeRemoveButton = Utils.inherit(BaseButton);

    _(EdgeRemoveButton.prototype).extend({
        _init: function() {
            this.type = "Edge-remove-button";
            this.sector = this.renderer.drawSector(this, Utils._EDGE_BUTTON_INNER, Utils._EDGE_BUTTON_OUTER, -90, 90, 1, "remove", this.renkan.translate("Remove"));
        },
        mouseup: function() {
            this.renderer.click_target = null;
            this.renderer.is_dragging = false;
            this.renderer.removeRepresentationsOfType("editor");
            if (this.renderer.isEditable()) {
                if (this.options.element_delete_delay) {
                    var delid = Utils.getUID("delete");
                    this.renderer.delete_list.push({
                        id: delid,
                        time: new Date().valueOf() + this.options.element_delete_delay
                    });
                    this.source_representation.model.set("delete_scheduled", delid);
                } else {
                    if (confirm(this.renkan.translate('Do you really wish to remove edge ') + '"' + this.source_representation.model.get("title") + '"?')) {
                        this.project.removeEdge(this.source_representation.model);
                    }
                }
            }
        }
    });

    /* EdgeRemoveButton End */
    
    return EdgeRemoveButton;

});