package org.iri_research.renkan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Constants {
	
	@SuppressWarnings("serial")
	public final static List<String> VERSION = Collections.unmodifiableList(new ArrayList<String>() {
		{
			add("0");
			add("1");
			add("0");
			add("final");
			add("0");
		}
	});
	
	
	public static String getVersion() {
		
		String[] version_array = VERSION.toArray(new String[VERSION.size()]);
		
	    String version = String.format("%s.%s",version_array[0], version_array[1]);
	    if(version_array[2] != null && !version_array[2].isEmpty() &&  Integer.parseInt(version_array[2]) > 0 ) {
	    	version = String.format("%s.%s", version, version_array[2]);
	    }
	    if (version_array[3] == "alpha" && version_array[4] == "0") {
	    	version = String.format("%s pre-alpha",version);
	    }
	    else if(version_array[3] != "final") {
	        version = String.format("%s %s %s", version, version_array[3], version_array[4]);
	    }
	    return version;

	}
	
	public final static String KEYHEX = "f2338d2299ac28ef64f82956fde37337b87a2b9e8fc03e28fa0768cac37d838113c7d0fc78c60fce1e23b1b3e03ac7db4676b3189c267f26baaab10f72544441";
	public final static int SALT_LENGTH = 24;
	public final static int PAGINATION_SIZE = 10;

	public enum EditMode {
		READ_ONLY(1),		
		EDITION(2);
		
		private int value;
		
		private final static EditMode[] editModeValues = EditMode.values();
		
		private EditMode(int i) {
			this.value = i;
		}
		
		public static EditMode fromInt(int val) {
			for(int i=0; i < editModeValues.length; i++) {
				if(editModeValues[i].value == val)
				{
					return editModeValues[i];
				}
			}
			return null;
		}
	}

}
