package org.iri_research.renkan.models;

import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;


@Document(collection="edges")
public class Edge extends AbstractRenkanModel<String> {

	@DBRef
	private Node from;
	
	@DBRef
	private Node to;
	
	private String project_id;
	
	private String created_by;
	

	public Edge(String id, String title, String description, String uri, String color, Node from, Node to, String created_by, String project_id) {
		super(id,title, description, uri, color);
		this.from = from;
		this.to = to;
		this.created_by = created_by;
		this.project_id = project_id;
	}


	public String getProject_id() {
		return project_id;
	}


	public String getCreated_by() {
		return created_by;
	}
	
	public String getFrom() {
		if(this.from != null) {
			return this.from.id;
		}
		else {
			return null;
		}
	}

	public String getTo() {
		if(this.to != null) {
			return this.to.id;
		}
		else {
			return null;
		}
	}

}
