package org.iri_research.renkan.models;

import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

@Document(collection = "spaces")
public class Space extends AbstractRenkanModel<String> {

    @Autowired
    public Space(String id, String title, String description, String binConfig,
            String uri, String color, String createdBy, String image,
            DateTime created) {
        super(id, title, description, uri, color);

        this.binConfig = binConfig;
        this.createdBy = createdBy;
        this.setImage(image);
        this.created = created;
        if (this.created == null) {
            this.created = new DateTime();
        }
    }

    public Space() {
    }

    @Field("bin_config")
    @JsonProperty("bin_config")
    private String binConfig;

    @Field("created_by")
    @JsonProperty("created_by")
    private String createdBy = null;
    private String image;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone = "GMT")
    private DateTime created;

    public String getImage() {
        return image;
    }

    @JsonProperty("created_by")
    public String getCreatedBy() {
        return createdBy;
    }

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone = "GMT")
    public DateTime getCreated() {
        return created;
    }

    public void setCreated(DateTime date) {
        this.created = date;

    }

    @JsonProperty("bin_config")
    public String getBinConfig() {
        return binConfig;
    }

    @JsonProperty("bin_config")
    public void setBinConfig(String bin_config) {
        this.binConfig = bin_config;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Override
    protected String getRawKeyPart() {
        return Long.toString(this.getCreated().getMillis());
    }

}