Rkns.Renderers.Paper = Rkns.Utils.inherit(Rkns.Renderers._Base);

Rkns.Renderers.Paper__Controllers = {}

Rkns.Renderers.Paper__Controllers._Base = function(_renderer, _element) {
    if (typeof _renderer !== "undefined") {
        this.id = Rkns.Utils.getUID('controller');
        this._renderer = _renderer;
        this._element = _element;
        this._element.__controller = this;
    }
}

Rkns.Renderers.Paper__Controllers._Base.prototype.select = function() {}

Rkns.Renderers.Paper__Controllers._Base.prototype.unselect = function() {}

Rkns.Renderers.Paper__Controllers.Node = Rkns.Utils.inherit(Rkns.Renderers.Paper__Controllers._Base);

Rkns.Renderers.Paper__Controllers.Node.prototype._init = function() {
    this._renderer.node_layer.activate();
    this.type = "node";
    this.node_circle = new paper.Path.Circle([0, 0], Rkns._NODE_RADIUS);
    this.node_circle.fillColor = '#ffffff';
    this.node_circle.__controller = this;
    this.node_text = new paper.PointText([0,0]);
    this.node_text.characterStyle = {
        fontSize: Rkns._NODE_FONT_SIZE,
        fillColor: 'black'
    };
    this.node_text.paragraphStyle.justification = 'center';
    this.node_text.__controller = this;
}

Rkns.Renderers.Paper__Controllers.Node.prototype.redraw = function() {
    this.node_model_coords = new paper.Point(this._element.position);
    this.node_paper_coords = this._renderer.toPaperCoords(this.node_model_coords);
    this.node_circle.position = this.node_paper_coords;
    this.node_text.content = this._element.title;
    this.node_text.position = this.node_paper_coords.add([0, 2 * Rkns._NODE_RADIUS]);
    this.node_circle.strokeColor = this._element.created_by.color;
}

Rkns.Renderers.Paper__Controllers.Node.prototype.paperShift = function(_delta) {
    this._element.setPosition(this._renderer.toModelCoords(this.node_paper_coords.add(_delta)));
    this._renderer._project.serializer.save();
    this._renderer.redraw();
}

Rkns.Renderers.Paper__Controllers.Node.prototype.select = function(_delta) {
    this.node_circle.strokeWidth = 3;
}

Rkns.Renderers.Paper__Controllers.Node.prototype.unselect = function(_delta) {
    this.node_circle.strokeWidth = 1;
}

/* */

Rkns.Renderers.Paper__Controllers.Edge = Rkns.Utils.inherit(Rkns.Renderers.Paper__Controllers._Base);

Rkns.Renderers.Paper__Controllers.Edge.prototype._init = function() {
    this._renderer.edge_layer.activate();
    this.type = "edge";
    this.from_node_controller = this._element.from.__controller;
    this.to_node_controller = this._element.to.__controller;
    this.edge_line = new paper.Path();
    this.edge_line.add([0,0],[0,0]);
    this.edge_line.__controller = this;
    this.edge_arrow = new paper.Path();
    this.edge_arrow.add([0,0],[Rkns._ARROW_LENGTH,Rkns._ARROW_WIDTH / 2],[0,Rkns._ARROW_WIDTH]);
    this.edge_arrow.__controller = this;
    this.edge_text = new paper.PointText();
    this.edge_text.characterStyle = {
        fontSize: Rkns._EDGE_FONT_SIZE,
        fillColor: 'black'
    };
    this.edge_text.paragraphStyle.justification = 'center';
    this.edge_text.__controller = this;
    this.edge_text_angle = 0;
    this.edge_arrow_angle = 0;
}

Rkns.Renderers.Paper__Controllers.Edge.prototype.redraw = function() {
    var _p0 = this.from_node_controller.node_paper_coords,
        _p1 = this.to_node_controller.node_paper_coords,
        _a = _p1.subtract(_p0).angle,
        _center = _p0.add(_p1).divide(2),
        _color = this._element.created_by.color;
    this.edge_line.strokeColor = _color;
    this.edge_line.segments[0].point = _p0;
    this.edge_line.segments[1].point = _p1;
    this.edge_arrow.rotate(_a - this.edge_arrow_angle);
    this.edge_arrow.fillColor = _color;
    this.edge_arrow.position = _center;
    this.edge_arrow_angle = _a;
    if (_a > 90) {
        _a -= 180;
    }
    if (_a < -90) {
        _a += 180;
    }
    this.edge_text.rotate(_a - this.edge_text_angle);
    this.edge_text.content = this._element.title;
    this.edge_text.position = _center;
    this.edge_text_angle = _a;
}

Rkns.Renderers.Paper__Controllers.Edge.prototype.select = function(_delta) {
    this.edge_line.strokeWidth = 3;
}

Rkns.Renderers.Paper__Controllers.Edge.prototype.unselect = function(_delta) {
    this.edge_line.strokeWidth = 1;
}

Rkns.Renderers.Paper__Controllers.Edge.prototype.paperShift = function(_delta) {
    this.from_node_controller.paperShift(_delta);
    this.to_node_controller.paperShift(_delta);
    this._renderer.redraw();
}
/* */

Rkns.Renderers.Paper__Controllers.TempEdge = Rkns.Utils.inherit(Rkns.Renderers.Paper__Controllers._Base);

Rkns.Renderers.Paper__Controllers.TempEdge.prototype._init = function() {
    this._renderer.edge_layer.activate();
    this.type = "temp-edge";
    var _color = this._renderer._project.current_user.color;
    this.edge_line = new paper.Path();
    this.edge_line.strokeColor = _color;
    this.edge_line.add([0,0],[0,0]);
    this.edge_line.__controller = this;
    this.edge_arrow = new paper.Path();
    this.edge_arrow.fillColor = _color;
    this.edge_arrow.add([0,0],[Rkns._ARROW_LENGTH,Rkns._ARROW_WIDTH / 2],[0,Rkns._ARROW_WIDTH]);
    this.edge_arrow.__controller = this;
    this.edge_arrow_angle = 0;
}

Rkns.Renderers.Paper__Controllers.TempEdge.prototype.redraw = function() {
    var _p0 = this.from_node_controller.node_paper_coords,
        _p1 = this.end_pos,
        _a = _p1.subtract(_p0).angle,
        _c = _p0.add(_p1).divide(2);
    this.edge_line.segments[0].point = _p0;
    this.edge_line.segments[1].point = _p1;
    this.edge_arrow.rotate(_a - this.edge_arrow_angle);
    this.edge_arrow.position = _c;
    this.edge_arrow_angle = _a;
}

Rkns.Renderers.Paper__Controllers.TempEdge.prototype.paperShift = function(_delta) {
    this.end_pos = this.end_pos.add(_delta);
    this._renderer.onMouseMove({point: this.end_pos});
    this.redraw();
}

Rkns.Renderers.Paper__Controllers.TempEdge.prototype.finishEdge = function(_event) {
    var _hitResult = paper.project.hitTest(_event.point);
    if (_hitResult && typeof _hitResult.item.__controller !== "undefined") {
        var _target = _hitResult.item.__controller;
        if (_target.type === "node" && this.from_node_controller._element.id !== _target._element.id) {
            this._renderer._project.addEdge({
                from: this.from_node_controller._element.id,
                to: _target._element.id
            }, Rkns._RENDER_AND_SAVE)
        }
    }
    this.edge_arrow.remove();
    this.edge_line.remove();
    this._renderer.controllers.removeId(this.id);
}

/* */

Rkns.Renderers.Paper.prototype._init = function() {
    this._MARGIN_X = 80;
    this._MARGIN_Y = 50;
    var _canvas_id = this._project._opts.canvas_id;
    this.$ = Rkns.$("#"+_canvas_id)
    paper.setup(document.getElementById(_canvas_id));
    this.scale = 1;
    this.offset = paper.view.center;
    this.totalScroll = 0;
    this.dragging_target = null;
    this.selected_target = null;
    this.edge_layer = new paper.Layer();
    this.node_layer = new paper.Layer();
    var _tool = new paper.Tool(),
        _this = this;
    _tool.onMouseMove = function(_event) {
        _this.onMouseMove(_event);
    }
    _tool.onMouseDown = function(_event) {
        _this.onMouseDown(_event);
    }
    _tool.onMouseDrag = function(_event) {
        _this.onMouseDrag(_event);
    }
    _tool.onMouseUp = function(_event) {
        _this.onMouseUp(_event);
    }
    this.$.mousewheel(function(_event, _delta) {
        _this.onScroll(_event, _delta);
    })
    this.$.dblclick(function(_event) {
        _this.onDoubleClick(_event);
    })
    paper.view.onResize = function(_event) {
        _this.offset = _this.offset.add(_event.delta.divide(2));
        _this.redraw();
    }
}

Rkns.Renderers.Paper.prototype.toPaperCoords = function(_point) {
    return _point.multiply(this.scale).add(this.offset);
}


Rkns.Renderers.Paper.prototype.toModelCoords = function(_point) {
    return _point.subtract(this.offset).divide(this.scale);
}

Rkns.Renderers.Paper.prototype.draw = function() {
    var _this = this,
        _xx = this._project.nodes.map(function(_node) { return _node.position.x }),
        _yy = this._project.nodes.map(function(_node) { return _node.position.y }),
        _minx = Math.min.apply(Math, _xx),
        _miny = Math.min.apply(Math, _yy),
        _maxx = Math.max.apply(Math, _xx),
        _maxy = Math.max.apply(Math, _yy);
    this.scale = Math.min((paper.view.size.width - 2 * this._MARGIN_X) / (_maxx - _minx), (paper.view.size.height - 2 * this._MARGIN_Y) / (_maxy - _miny));
    this.offset = paper.view.center.subtract(new paper.Point([(_maxx + _minx) / 2, (_maxy + _miny) / 2]).multiply(this.scale));
    this.controllers = new Rkns.Model.List();
    this._project.nodes.forEach(function(_node) {
        _this.addElement("Node", _node);
    });
    this._project.edges.forEach(function(_edge) {
        _this.addElement("Edge", _edge);
    });
    
    this.redraw();
}

Rkns.Renderers.Paper.prototype.addElement = function(_type, _element) {
    var _el = new Rkns.Renderers.Paper__Controllers[_type](this, _element);
    this.controllers.push(_el);
    return _el;
}

Rkns.Renderers.Paper.prototype.redraw = function() {
    this.controllers.forEach(function(_controller) {
        _controller.redraw();
    });
    paper.view.draw();
}

Rkns.Renderers.Paper.prototype.onMouseMove = function(_event) {
    var _hitResult = paper.project.hitTest(_event.point);
    if (_hitResult && typeof _hitResult.item.__controller !== "undefined") {
        if (this.selected_target !== _hitResult.item.__controller) {
            if (this.selected_target) {
                this.selected_target.unselect();
            }
            this.selected_target = _hitResult.item.__controller;
            this.selected_target.select();
        }
    } else {
        if (this.selected_target) {
            this.selected_target.unselect();
        }
        this.selected_target = null;
    }
}

Rkns.Renderers.Paper.prototype.onMouseDown = function(_event) {
    var _hitResult = paper.project.hitTest(_event.point);
    if (_hitResult && typeof _hitResult.item.__controller !== "undefined") {
        this.dragging_target = _hitResult.item.__controller;
        if (this.dragging_target.type === "node" && _hitResult.type === "stroke") {
            var _tmpEdge = this.addElement("TempEdge",{});
            _tmpEdge.end_pos = _event.point;
            _tmpEdge.from_node_controller = this.dragging_target;
            _tmpEdge.redraw();
            this.dragging_target = _tmpEdge;
        }
    } else {
        this.dragging_target = null;
    }
}

Rkns.Renderers.Paper.prototype.onMouseDrag = function(_event) {
    if (this.dragging_target && typeof this.dragging_target.paperShift === "function") {
        this.dragging_target.paperShift(_event.delta);
    } else {
        this.offset = this.offset.add(_event.delta);
        this.redraw();
    }
}

Rkns.Renderers.Paper.prototype.onMouseUp = function(_event) {
    if (this.dragging_target && this.dragging_target.type === "temp-edge") {
        this.dragging_target.finishEdge(_event);
    }
    this.dragging_target = null;
}

Rkns.Renderers.Paper.prototype.onScroll = function(_event, _scrolldelta) {
    this.totalScroll += _scrolldelta;
    if (Math.abs(this.totalScroll) >= 1) {
        var _off = this.$.offset(),
            _delta = new paper.Point([
                _event.pageX - _off.left,
                _event.pageY - _off.top
            ]).subtract(this.offset).multiply( Math.SQRT2 - 1 );
        if (this.totalScroll > 0) {
            this.offset = this.offset.subtract(_delta);
            this.scale *= Math.SQRT2;
        } else {
            this.offset = this.offset.add(_delta.divide( Math.SQRT2 ));
            this.scale *= Math.SQRT1_2;
        }
        this.totalScroll = 0;
        this.redraw();
    }
}

Rkns.Renderers.Paper.prototype.onDoubleClick = function(_event) {
    var _off = this.$.offset(),
        _point = new paper.Point([
            _event.pageX - _off.left,
            _event.pageY - _off.top
        ]);
    var _hitResult = paper.project.hitTest(_point);
    if (!_hitResult || typeof _hitResult.item.__controller === "undefined") {
        var _coords = this.toModelCoords(_point);
        this._project.addNode({
            position: {
                x: _coords.x,
                y: _coords.y
            }
        }, Rkns._RENDER_AND_SAVE);
    }
    paper.view.draw();
}
